/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.odt.readOdt;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.odt.readOdt.CodeIncludeInfo;
import org.vishia.odt.readOdt.GetJavadocLabel;
import org.vishia.odt.readOdt.ReadOdt;
import org.vishia.odt.readOdt.TranslateOdtCommon;
import org.vishia.util.Arguments;
import org.vishia.util.Debugutil;
import org.vishia.util.ExcUtil;
import org.vishia.util.FileFunctions;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringFunctions_C;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlSimple.XmlSequWriter;
import org.vishia.zip.ZipUtils;

public class WriteOdt
extends TranslateOdtCommon {
    public static final String version = "2025-10-10";
    final CmdArgs args;
    final Cfg cfg = new Cfg();
    final XmlCfg xmlCfgOdt = new XmlCfg(true);
    BufferedReader rZmL;
    Stack<BufferedReader> stack_rAdoc = new Stack();
    String sLineNext;
    String sStyleParagr;
    boolean bParagrFirstline;
    int nSection;
    int nList;
    boolean bInsideListItem;
    boolean bPageBreakBefore;
    boolean bColumnBreakBefore;
    boolean bInsideColumn2;
    boolean bPage2Start = true;
    int nrSectionName = 0;
    int nrTableName = 0;
    int nrFrameImgName = -1;
    boolean bSetNrChapter = true;
    int[] nrChapter = new int[6];
    Map<String, String> idxLabelIntern = new TreeMap<String, String>();
    Map<String, ReadOdt.LabelRef> idxLabelExternRef = new TreeMap<String, ReadOdt.LabelRef>();
    Map<String, ReadOdt.LabelRef> idxChnrExternRef = new TreeMap<String, ReadOdt.LabelRef>();
    String sCodeStyle;
    boolean bInsideCode;
    String sRefBookmark;
    String sXXXLabel;
    String sInclude;
    final StringBuilder sbo = new StringBuilder(16384);
    private Writer wrRep;
    private String lastAnchorReplaced = "";
    final XmlSequWriter xmlWr = new XmlSequWriter();
    private static String[] specificLineStarts = new String[]{"*", "//", "<:td.>", "<:tr.>", "<.table>"};
    static String[][] sTextReplace = new String[][]{{"\\", "\\\\", "\\", "x"}, {"<:", "<\\:", "<:", "x"}, {"<.", "<\\.", "<.", "x"}, {".>", ".\\>", ".>", "x"}, {"\uff0d", "\\---", "{fmin}", "-"}, {"\u2013", "\\--", "{fmin}", "-"}, {"\u00a0", "\\ ", "{nbsp}", " "}, {"\u2008", "\\:", "{dsp}", " "}, {"\u200b", "\\|", "{zwsp}", " "}, {"\n", "\\n ", " +\n", " "}, {"\t", "\\t ", "{tab}", " "}, {"\u2060", "\\+", "{wj}", " "}, {"\u2011", "\\-", "{nbhy}", "-"}, {"\u00ad", "\\~", "{zhy}", "-"}, {"\u00ab", "\\<<", "{ldaquo}", "x"}, {"\u00bb", "\\>>", "{rdaquo}", "x"}, {"\u2039", "\\<", "{lsaquo}", "x"}, {"\u203a", "\\>", "{rsaquo}", "x"}, {"\u201c", "\\\"", "{ldquo}", "x"}, {"\u201d", "\\''", "{rdquo}", "x"}, {"\u2018", "\\'", "{lsquo}", "'"}, {"\u2019", "\\^", "{rsquo}", "^"}, {"\u201e", "\\,,", "{lbdquo}", "\""}, {"\u201a", "\\,", "{llsquo}", "\""}, {"\u2017", "\\_", "{rxdquo}", "_"}, {"\u2023", "\\*>", "*", "x"}, {"\u25cf", "\\**", "*", "x"}, {"\u2022", "\\*", "*", "x"}};
    static String sTextReplaceChars;
    static String[][] sTextReplaceAsciidoc;
    static String[] sCheckTextReplZmL;
    static String[][] sTextCtrlCommon;
    static String[] sTextCtrlCommonSearchMu;
    static String[] sTextCtrlCommonSearchAsciidoc;
    static String[] sWwwLink;

    public static int amain(CmdArgs cmdArgs) throws IOException {
        WriteOdt writeOdt = new WriteOdt(cmdArgs);
        writeOdt.execute();
        writeOdt.log.close();
        return 0;
    }

    public static int smain(String[] stringArray, Appendable appendable, Appendable appendable2) throws IOException {
        CmdArgs cmdArgs = new CmdArgs();
        if (stringArray.length == 0) {
            cmdArgs.showHelp(appendable);
            return 1;
        }
        cmdArgs.setCurrDir();
        if (!cmdArgs.parseArgs(stringArray, appendable2) || !cmdArgs.testConsistence(appendable2)) {
            return 2;
        }
        int n = WriteOdt.amain(cmdArgs);
        System.out.printf("\n*** finished %s @%s", cmdArgs.fOutOdt.getName(), cmdArgs.fOutOdt.getParent());
        System.out.printf(" EXIT-code=%d", n);
        System.out.println();
        return n;
    }

    public static void main(String[] stringArray) {
        try {
            int n = WriteOdt.smain(stringArray, System.out, System.err);
            System.exit(n);
        }
        catch (Exception exception) {
            System.err.println("Unexpected: " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(255);
        }
    }

    protected WriteOdt(CmdArgs cmdArgs) {
        super((LogMessage)new LogMessageStream(cmdArgs.fLog, null, (Appendable)System.out, (Appendable)System.err, true, Charset.forName("UTF-8")));
        this.args = cmdArgs;
    }

    private void wrRep(CharSequence charSequence) throws IOException {
        if (this.wrRep != null) {
            this.wrRep.append(charSequence).append("\n");
        }
    }

    public void execute() throws IOException {
        String string;
        Object object;
        Iterator iterator;
        this.showArguments();
        if (this.args.dirLabel != null) {
            this.readOwnLabels();
            iterator = new LinkedList();
            FileFunctions.addFileToList((File)this.args.dirLabel, (String)this.args.sNameLabel, iterator);
            Object object2 = iterator.iterator();
            while (object2.hasNext()) {
                object = (File)object2.next();
                string = ((File)object).getName();
                if ((string = string.substring(0, string.indexOf(46))).equals(this.args.sNameDoc)) continue;
                this.readLabelFile((File)object, string);
            }
        }
        if (this.args.listDirJavadoc != null) {
            this.javadocLabel.analyzeAllJavadocFiles(this.args.listDirJavadoc, this.args.fDirOdt);
            if (this.args.fRptClassesJavadoc != null) {
                this.javadocLabel.reportClassesJavadoc(this.args.fRptClassesJavadoc);
            }
        }
        this.xmlCfgOdt.readFromJar(WriteOdt.class, "xmlCfgOdtNonSemantic.txt", this.log);
        if (this.args.fCfg != null) {
            iterator = new FileInputStream(this.args.fCfg);
            Arguments.readConfig((Object)this.cfg, (InputStream)((Object)iterator), null, (LogMessage)this.log);
            ((InputStream)((Object)iterator)).close();
        }
        this.rZmL = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.args.fIn), "UTF-8"));
        this.wrRep = this.args.fReport == null ? null : new OutputStreamWriter((OutputStream)new FileOutputStream(this.args.fReport), "UTF-8");
        this.xmlWr.open(this.args.fOutXml, "UTF-8", (Appendable)this.sbo);
        try {
            this.xmlWr.writeElement("office:document-content");
            for (Object object2 : this.xmlCfgOdt.iterNamespace()) {
                object = (String)object2.getKey();
                string = (String)object2.getValue();
                String string2 = "xmlns:" + string;
                this.xmlWr.writeAttribute(string2, (String)object);
            }
            this.xmlWr.writeElement("office:scripts");
            this.xmlWr.writeElementEnd();
            this.xmlWr.writeElement("office:font-face-decls");
            this.xmlWr.writeElementEnd();
            this.xmlWr.writeElement("office:automatic-styles");
            this.writeStyleSections();
            this.xmlWr.writeElementEnd();
            this.xmlWr.writeElement("office:body");
            this.xmlWr.writeElement("office:text");
            this.xmlWr.writeElement("text:sequence-decls");
            this.xmlWr.writeElementEnd();
        }
        catch (Exception exception) {
            this.log.writeError("Unexpected, will close xml and odt: ", (Throwable)exception);
            this.xmlWr.writeText((CharSequence)exception.getMessage(), true);
        }
        this.searchFirstHeaderLine();
        do {
            try {
                this.parseZmlWriteOdt();
            }
            catch (Exception exception) {
                this.log.writeError("Unexpected, will close xml and odt: ", (Throwable)exception);
                this.xmlWr.writeText((CharSequence)exception.getMessage(), true);
            }
            this.rZmL.close();
            if (this.stack_rAdoc.isEmpty()) {
                this.rZmL = null;
                continue;
            }
            this.rZmL = this.stack_rAdoc.pop();
            this.sInclude = "";
        } while (this.rZmL != null);
        if (this.xmlWr.elementCurrTag().equals("text:section")) {
            this.xmlWr.writeElementEnd("text:section");
        }
        if (this.args.bWriteExternRefs) {
            this.writeExternReferences();
        }
        this.xmlWr.writeElementEnd("office:text");
        this.xmlWr.writeElementEnd("office:body");
        this.xmlWr.writeElementEnd("office:document-content");
        this.xmlWr.close();
        if (this.wrRep != null) {
            this.wrRep.append("\n");
            this.wrRep.close();
            this.wrRep = null;
        }
        this.writeBackupFile(this.args.fOutOdt, this.args.dirOutBack, this.args.sExtOut, this.args);
        if (this.args.fOutOdt != null) {
            if (this.args.fOdtStyles != null) {
                System.out.printf("\nUsed '%s' as template with styles.", this.args.fOdtStyles);
                FileFunctions.copyFile((File)this.args.fOdtStyles, (File)this.args.fOutOdt);
            }
            ZipUtils.replaceFile((String)this.args.fOutOdt.getAbsolutePath(), (String)this.args.fOutXml.getAbsolutePath(), (String)"content.xml");
        }
    }

    private void showArguments() {
        System.out.printf("\n*** org.vishia.idt.readOdt.WriteOdt version %s", version);
        System.out.printf("\n  input=%s", this.args.fIn);
        System.out.printf("\n  output=%s", this.args.fOutOdt);
        System.out.printf("\n  -odtStyles=%s", this.args.fOdtStyles);
        System.out.printf("\n  SrcCmpn=%s", this.args.sDirSrcCmpn);
        System.out.printf("\n  currDir=%s", this.args.sCurrDir);
        System.out.printf("\n  Backup-dir %s", this.args.dirOutBack);
        System.out.printf("\n  -report=%s", this.args.fReport);
        System.out.printf("\n  -dirDbg=%s", this.args.dirDbg);
        System.out.printf("\n  Labels read from=%s/*.%s", this.args.dirLabel, this.args.sNameLabel);
        System.out.printf("\n  www-root=%s", this.args.swwwRoot);
        System.out.printf("\n  -wrelhtml=%s", this.args.sRefBesideInWWWHtml);
        System.out.printf("\n  -wrelpdf=%s", this.args.sRefBesideInWWWPdf);
        System.out.printf("\n  -alinkhtml=%s", this.args.sRefBesideHtml);
        System.out.printf("\n  -alinkpdf=%s", this.args.sRefBesidePdf);
        System.out.printf("\n  sExtRefBesideHtml=%s", this.args.sExtRefBesideHtml);
        System.out.printf("\n  sExtRefBesidePdf=%s", this.args.sExtRefBesidePdf);
        if (this.args.dirCreateCfgJavaData != null) {
            System.out.printf("\n  -genJavaData=%s", this.args.dirCreateCfgJavaData);
        }
    }

    private boolean switchToInclude(String string) throws IOException {
        String string2;
        String string3;
        boolean bl = false;
        BufferedReader bufferedReader = null;
        int n = string.indexOf(58);
        int n2 = string.indexOf(35, n + 1);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n > 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1, n2);
        } else {
            string3 = string.substring(0, n2);
            string2 = null;
        }
        File file = new File(this.args.dirZml, string3 + this.args.sExtZmL);
        if (!file.exists()) {
            this.log.writeError("ERROR include file not found: %s @%s", new Object[]{string3, this.args.dirIn.getPath()});
        } else {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            }
            catch (Exception exception) {
                this.log.writeError("ERROR include file Exception: ", (Throwable)exception);
            }
        }
        if (bufferedReader != null) {
            String string4;
            this.log.writef("\nRead included: %s", new Object[]{string3});
            this.stack_rAdoc.push(this.rZmL);
            this.rZmL = bufferedReader;
            while ((string4 = this.rZmL.readLine()) != null) {
                if (!string4.startsWith("==") || string2 != null && !string4.contains("#" + string2)) continue;
                this.sLineNext = string4;
                break;
            }
            bl = true;
        }
        return bl;
    }

    private void readOwnLabels() throws IOException {
        String string;
        this.rZmL = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.args.fIn), "UTF-8"));
        while ((string = this.rZmL.readLine()) != null) {
            int n;
            int n2;
            if (!string.startsWith("==") || (n2 = string.indexOf("<:#")) <= 0) continue;
            do {
                String string2;
                int n3;
                if (string.charAt((n = string.indexOf(62, n2 += 3)) - 1) == '.') {
                    --n;
                }
                String string3 = string.substring(n2, n);
                n2 = 0;
                while ((n3 = string3.indexOf(35, n2)) > 0) {
                    string2 = string3.substring(n2, n3);
                    this.idxLabelIntern.put(string2, string2);
                    n2 = n3 + 1;
                }
                string2 = string3.substring(n2);
                this.idxLabelIntern.put(string2, string2);
            } while (n > 0 && (n2 = string.indexOf("<:#", n)) > 0);
        }
        this.rZmL.close();
        this.rZmL = null;
    }

    private void readLabelFile(File file, String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                String string3;
                if (!string2.startsWith("#") || this.idxLabelIntern.get(string3 = string2.substring(1, n = string2.indexOf(32))) != null) continue;
                int n2 = string2.lastIndexOf(64);
                if (string3.startsWith("?") || n2 < 0) continue;
                String string4 = string2.substring(n + 1, n2).trim();
                String string5 = string2.substring(n2 + 1).trim();
                ReadOdt.LabelRef labelRef = this.idxLabelExternRef.get(string3);
                if (labelRef != null) {
                    if (labelRef.idxLabel.get(string3) != null) {
                        this.log.writef("\n#%s already contained in bookmarks: >>%s<<, new: >>%s<<", new Object[]{string3, this.idxLabelExternRef.get(string3), string4});
                        continue;
                    }
                    labelRef.idxLabel.put(string3, string3);
                    continue;
                }
                LinkedList<String> linkedList = new LinkedList<String>();
                linkedList.add(string3);
                labelRef = new ReadOdt.LabelRef(string, null, linkedList, string4, string5);
                this.idxLabelExternRef.put(string3, labelRef);
                this.idxChnrExternRef.put(string + string4, labelRef);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.print("\nERROR reading " + file.getAbsolutePath());
        }
    }

    private void writeStyleSections() throws IOException {
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "SectTOC");
        this.xmlWr.writeAttribute("style:family", "section");
        this.xmlWr.writeElement("style:section-properties");
        this.xmlWr.writeAttribute("style:editable", "false");
        this.xmlWr.writeElement("style:columns");
        this.xmlWr.writeAttribute("fo:column-count", "1");
        this.xmlWr.writeAttribute("fo:column-gap", "0mm");
        this.xmlWr.writeElementEnd("style:columns");
        this.xmlWr.writeElementEnd("style:section-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "Contents_20_Heading_pg");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("fo:break-before", "page");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "Column22");
        this.xmlWr.writeAttribute("style:family", "section");
        this.xmlWr.writeElement("style:section-properties");
        this.xmlWr.writeAttribute("text:dont-balance-text-columns", "false");
        this.xmlWr.writeAttribute("style:editable", "false");
        this.xmlWr.writeElement("style:columns");
        this.xmlWr.writeAttribute("fo:column-count", "2");
        this.xmlWr.writeAttribute("fo:column-gap", "7mm");
        this.xmlWr.writeElement("style:column");
        this.xmlWr.writeAttribute("style:rel-width", "32767*");
        this.xmlWr.writeAttribute("fo:start-indent", "0mm");
        this.xmlWr.writeAttribute("fo:end-indent", "3.5mm");
        this.xmlWr.writeElementEnd();
        this.xmlWr.writeElement("style:column");
        this.xmlWr.writeAttribute("style:rel-width", "32768*");
        this.xmlWr.writeAttribute("fo:start-indent", "3.5mm");
        this.xmlWr.writeAttribute("fo:end-indent", "0mm");
        this.xmlWr.writeElementEnd();
        this.xmlWr.writeElementEnd();
        this.xmlWr.writeElementEnd();
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "Column2");
        this.xmlWr.writeAttribute("style:family", "section");
        this.xmlWr.writeElement("style:section-properties");
        this.xmlWr.writeAttribute("text:dont-balance-text-columns", "true");
        this.xmlWr.writeAttribute("style:editable", "false");
        this.xmlWr.writeElement("style:columns");
        this.xmlWr.writeAttribute("fo:column-count", "2");
        this.xmlWr.writeAttribute("fo:column-gap", "7mm");
        this.xmlWr.writeElement("style:column");
        this.xmlWr.writeAttribute("style:rel-width", "32767*");
        this.xmlWr.writeAttribute("fo:start-indent", "0mm");
        this.xmlWr.writeAttribute("fo:end-indent", "3.5mm");
        this.xmlWr.writeElementEnd();
        this.xmlWr.writeElement("style:column");
        this.xmlWr.writeAttribute("style:rel-width", "32768*");
        this.xmlWr.writeAttribute("fo:start-indent", "3.5mm");
        this.xmlWr.writeAttribute("fo:end-indent", "0mm");
        this.xmlWr.writeElementEnd();
        this.xmlWr.writeElementEnd();
        this.xmlWr.writeElementEnd();
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "Title_pg1");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Title");
        this.xmlWr.writeAttribute("style:master-page-name", "First_20_Page");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("fo:break-before", "page");
        this.xmlWr.writeAttribute("style:page-number", "1");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "H1pg2");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:master-page-name", "Standard");
        this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_1");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("style:page-number", "2");
        this.xmlWr.writeAttribute("fo:break-before", "page");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "H2pg2");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:master-page-name", "Standard");
        this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_2");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("style:page-number", "2");
        this.xmlWr.writeAttribute("fo:break-before", "page");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "H2pg");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_2");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("fo:break-before", "page");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "H3pg");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_3");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("fo:break-before", "page");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "H4pg");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_4");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("fo:break-before", "page");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "H5pg");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_5");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("fo:break-before", "page");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "H3col");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_3");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("fo:break-before", "column");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "H4col");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_4");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("fo:break-before", "column");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "H5col");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Heading_20_5");
        this.xmlWr.writeElement("style:paragraph-properties");
        this.xmlWr.writeAttribute("fo:break-before", "column");
        this.xmlWr.writeElementEnd("style:paragraph-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "text_List1");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Text");
        this.xmlWr.writeAttribute("style:list-style-name", "List_20_1");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "text_List2");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Text");
        this.xmlWr.writeAttribute("style:list-style-name", "List_20_2");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "text_List3");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Text");
        this.xmlWr.writeAttribute("style:list-style-name", "List_20_3");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "text_List4");
        this.xmlWr.writeAttribute("style:family", "paragraph");
        this.xmlWr.writeAttribute("style:parent-style-name", "Text");
        this.xmlWr.writeAttribute("style:list-style-name", "List_20_4");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "modif_i");
        this.xmlWr.writeAttribute("style:family", "text");
        this.xmlWr.writeElement("style:text-properties");
        this.xmlWr.writeAttribute("fo:font-style", "italic");
        this.xmlWr.writeAttribute("fo:font-style-asian", "italic");
        this.xmlWr.writeAttribute("fo:font-style-complex", "italic");
        this.xmlWr.writeElementEnd("style:text-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "modif_b");
        this.xmlWr.writeAttribute("style:family", "text");
        this.xmlWr.writeElement("style:text-properties");
        this.xmlWr.writeAttribute("fo:font-weight", "bold");
        this.xmlWr.writeAttribute("fo:font-weight-asian", "bold");
        this.xmlWr.writeAttribute("fo:font-weight-complex", "bold");
        this.xmlWr.writeElementEnd("style:text-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "modif_ib");
        this.xmlWr.writeAttribute("style:family", "text");
        this.xmlWr.writeElement("style:text-properties");
        this.xmlWr.writeAttribute("fo:font-style", "italic");
        this.xmlWr.writeAttribute("fo:font-style-asian", "italic");
        this.xmlWr.writeAttribute("fo:font-style-complex", "italic");
        this.xmlWr.writeAttribute("fo:font-weight", "bold");
        this.xmlWr.writeAttribute("fo:font-weight-asian", "bold");
        this.xmlWr.writeAttribute("fo:font-weight-complex", "bold");
        this.xmlWr.writeElementEnd("style:text-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "Table1");
        this.xmlWr.writeAttribute("style:family", "table");
        this.xmlWr.writeElement("style:table-properties");
        this.xmlWr.writeAttribute("style:width", "8.9cm");
        this.xmlWr.writeAttribute("table:align", "margins");
        this.xmlWr.writeElementEnd("style:table-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "Table1.A");
        this.xmlWr.writeAttribute("style:family", "table-column");
        this.xmlWr.writeElement("style:table-column-properties");
        this.xmlWr.writeAttribute("style:column-width", "1.78cm");
        this.xmlWr.writeAttribute("style:rel-column-width", "13107*");
        this.xmlWr.writeElementEnd("style:table-column-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "Table1.A1");
        this.xmlWr.writeAttribute("style:family", "table-cell");
        this.xmlWr.writeElement("style:table-cell-properties");
        this.xmlWr.writeAttribute("fo:padding", "0cm");
        this.xmlWr.writeAttribute("fo:border", "none");
        this.xmlWr.writeAttribute("style:writing-mode", "page");
        this.xmlWr.writeElementEnd("style:table-cell-properties");
        this.xmlWr.writeElementEnd("style:style");
        this.xmlWr.writeElement("style:style");
        this.xmlWr.writeAttribute("style:name", "ImgFromTop");
        this.xmlWr.writeAttribute("style:family", "graphic");
        this.xmlWr.writeAttribute("style:parent", "Img");
        this.xmlWr.writeElement("style:graphic-properties");
        this.xmlWr.writeAttribute("style:vertical-pos", "from-top");
        this.xmlWr.writeAttribute("style:vertical-rel", "paragraph");
        this.xmlWr.writeAttribute("style:horizontal-pos", "center");
        this.xmlWr.writeAttribute("style:horizontal-rel", "paragraph-content");
        this.xmlWr.writeElementEnd("style:graphic-properties");
        this.xmlWr.writeElementEnd("style:style");
    }

    public void searchFirstHeaderLine() throws IOException {
        int n = 15;
        do {
            String string;
            if (((string = this.rZmL.readLine()) == null || !string.startsWith("=")) && !string.startsWith("<::ZmL.>")) continue;
            this.sLineNext = string;
            break;
        } while (--n >= 0);
    }

    public void parseZmlWriteOdt() throws IOException {
        String string;
        do {
            if (this.sLineNext != null) {
                string = this.sLineNext;
                this.sLineNext = null;
            } else {
                string = this.rZmL.readLine();
            }
            if (string == null) continue;
            int n = string.length();
            while (--n >= 0 && string.charAt(n) == ' ') {
            }
            if (++n < string.length()) {
                string = string.substring(0, n);
            }
            if (this.args.bReadAdoc) {
                this.parseAdocLine(string);
                continue;
            }
            this.parseAdocM(string);
        } while (string != null);
        Debugutil.stop();
    }

    protected String parseAdocLine(String string) throws IOException {
        String string2 = null;
        if (string.startsWith("It should be presumed that")) {
            Debugutil.stop();
        }
        if (string.length() >= 1) {
            char c = string.charAt(0);
            if (c != '*' && this.nList > 0) {
                this.finitList(0);
            }
            switch (c) {
                case ':': {
                    break;
                }
                case '[': {
                    return this.parseWriteParagrStyleLabel(string);
                }
                case '=': {
                    return this.writeHeaderLine(string);
                }
                case '/': {
                    return this.checkParseCommentLine(string);
                }
                case '*': {
                    return this.parseList(string);
                }
                case ' ': {
                    return this.parseWriteCodeBlock(string);
                }
                default: {
                    if (string.startsWith("image::")) {
                        return this.parseImage(string, true);
                    }
                    if (string.startsWith("----")) {
                        return this.parseWriteCodeBlock(string);
                    }
                    return this.parseWriteParagr(string, null);
                }
            }
        }
        return string2;
    }

    private String parseAdocM(String string) throws IOException {
        String string2 = null;
        if (string.startsWith("It should be presumed that")) {
            Debugutil.stop();
        }
        if (string.length() >= 1) {
            char c = string.charAt(0);
            if (c != '*' && this.nList > 0) {
                this.finitList(0);
            }
            switch (c) {
                case '=': {
                    return this.writeHeaderLine(string);
                }
                case '*': {
                    return this.parseList(string);
                }
            }
            if (string.startsWith("##")) {
                return null;
            }
            if (string.startsWith("<:Code:")) {
                return this.parseWriteCodeBlock(string);
            }
            if (string.startsWith("<::TOC-")) {
                return this.writeTableOfContents(string.substring(7));
            }
            if (string.startsWith("<::pageBreak.>")) {
                this.bPageBreakBefore = true;
                return null;
            }
            if (string.startsWith("<::columnBreak.>")) {
                this.bColumnBreakBefore = true;
                return null;
            }
            if (string.startsWith("<:p:")) {
                return this.parseWriteParagrStyleLabel(string);
            }
            if (string.startsWith("<::table")) {
                return this.parseWriteTable(string);
            }
            if (string.startsWith("<::Section:")) {
                return this.parseWriteSection(string);
            }
            if (string.startsWith("<.Section>")) {
                return this.writeSectionEnd(string);
            }
            if (string.startsWith("<:@include:")) {
                return null;
            }
            if (string.startsWith("<::ZmL.>")) {
                return this.writeHeaderLine(string);
            }
            return this.parseWriteParagr(string, null);
        }
        return string2;
    }

    private boolean isEmptyLine(String string, int n) {
        if (string == null) {
            return true;
        }
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            if (" \t".indexOf(string.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    private String writeHeaderLine(String string) throws IOException {
        String string2;
        int n;
        int n2;
        StringBuilder stringBuilder = this.readAllTextLinesOfParagraph(string);
        String string3 = stringBuilder.toString();
        this.finitList(0);
        String string4 = null;
        if (string3.contains("One letter for the base type")) {
            Debugutil.stop();
        }
        if (this.nSection > 0) {
            Debugutil.stop();
        }
        int n3 = string3.length();
        int n4 = 0;
        if (string3.startsWith("<::ZmL.>")) {
            n2 = 0;
            n4 = 8;
        } else {
            while (++n4 < n3 && string3.charAt(n4) == '=') {
            }
            n2 = n4 - 1;
        }
        while (n4 < n3 && string3.charAt(n4) == ' ') {
            ++n4;
        }
        n4 = this.readHeaderNr(string3, n3, n4, n2);
        int n5 = string3.indexOf("<:#");
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.stack_rAdoc.size() > 0 && this.sInclude != null && this.sInclude.length() > 0) {
            n = this.sInclude.indexOf(35);
            if (n > 0) {
                linkedList.add("__PART_" + this.sInclude.substring(0, n));
            } else {
                linkedList.add("__PART_" + this.sInclude);
            }
            this.sInclude = null;
        }
        if (n5 > 0) {
            string2 = string3.substring(n4, n5).trim();
            do {
                int n6;
                String string5;
                if (string3.charAt((n = string3.indexOf(62, n5 += 3)) - 1) == '.') {
                    --n;
                }
                if ((string5 = string3.substring(n5, n)).startsWith("__PART_END") && this.stack_rAdoc.size() == 0) {
                    this.sInclude = null;
                } else if (string5.startsWith("__PART_RD_") && this.stack_rAdoc.size() == 0) {
                    this.sInclude = string5.substring(10);
                } else if (string5.startsWith("__PART_") && this.stack_rAdoc.size() == 0) {
                    this.sInclude = string5.substring(7);
                }
                n5 = 0;
                while ((n6 = string5.indexOf(35, n5)) > 0) {
                    linkedList.add(string5.substring(n5, n6));
                    n5 = n6 + 1;
                }
                linkedList.add(string5.substring(n5));
            } while (n > 0 && (n5 = string3.indexOf("<:#", n)) > 0);
        } else {
            string2 = string3.substring(n4).trim();
        }
        if (this.sInclude != null && this.sInclude.length() > 0) {
            n = this.switchToInclude(this.sInclude) ? 1 : 0;
        } else if (string2.length() == 0) {
            this.log.writef("\nWARNING empty %s found, ignored", new Object[]{string3});
            n = 0;
        } else {
            if (this.sInclude != null) {
                assert (this.sInclude.length() == 0);
                linkedList.add("__PART_END_");
            }
            n = 0;
        }
        if (n == 0) {
            String string6;
            String string7;
            this.sInclude = null;
            if (n2 > 0) {
                int n7 = n2 - 1;
                this.nrChapter[n7] = this.nrChapter[n7] + 1;
            }
            for (int i = n2; i < this.nrChapter.length; ++i) {
                this.nrChapter[i] = 0;
            }
            if (n2 == 0) {
                this.xmlWr.writeElement("text:p");
                this.xmlWr.writeAttribute("text:style-name", "text");
                this.xmlWr.writeText((CharSequence)"(left empty side before page 1)", false);
                this.xmlWr.writeElementEnd();
                this.xmlWr.writeElement("text:p");
                this.xmlWr.writeAttribute("text:style-name", "text");
                this.xmlWr.writeText((CharSequence)"Note: Most of Browser pdf presentations does not support the book mode.", false);
                this.xmlWr.writeElementEnd();
                this.xmlWr.writeElement("text:p");
                this.xmlWr.writeAttribute("text:style-name", "text");
                this.xmlWr.writeText((CharSequence)"Remove this page if you want to have a PDF file in book mode.", false);
                this.xmlWr.writeElementEnd();
                string7 = "Title";
            } else if (this.bPage2Start) {
                string7 = "H" + n2 + "pg2";
                this.bPage2Start = false;
            } else {
                string7 = this.bPageBreakBefore && n2 > 1 ? "H" + n2 + "pg" : (this.bColumnBreakBefore && n2 > 1 ? "H" + n2 + "col" : "Heading_20_" + n2);
            }
            this.bColumnBreakBefore = false;
            this.bPageBreakBefore = false;
            this.xmlWr.writeElement("text:h");
            this.xmlWr.writeAttribute("text:style-name", string7);
            this.xmlWr.writeAttribute("text:outline-level", "" + n2);
            this.bParagrFirstline = true;
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                listIterator.next();
            }
            while (listIterator.hasPrevious()) {
                string6 = (String)listIterator.previous();
                this.xmlWr.writeElementInline("text:bookmark-start");
                if (!string6.startsWith("__PART_")) {
                    string6 = "__Link_" + string6;
                } else {
                    Debugutil.stop();
                }
                this.xmlWr.writeAttribute("text:name", string6);
                this.xmlWr.writeElementEnd("text:bookmark-start");
            }
            string6 = "";
            for (int i = 0; i < n2; ++i) {
                string6 = string6 + this.nrChapter[i];
                string6 = i < n2 - 1 ? string6 + '.' : string6 + ' ';
            }
            string4 = this.parseWriteText(string6 + string2, false);
            for (String string8 : linkedList) {
                this.xmlWr.writeElementInline("text:bookmark-end");
                if (!string8.startsWith("__PART_")) {
                    string8 = "__Link_" + string8;
                } else {
                    Debugutil.stop();
                }
                this.xmlWr.writeAttribute("text:name", string8);
                this.xmlWr.writeElementEnd("text:bookmark-end");
            }
            this.sXXXLabel = null;
            this.xmlWr.writeElementEndInline("text:h");
            this.wrRep(string3);
        }
        return string4;
    }

    private int readHeaderNr(String string, int n, int n2, int n3) {
        char c;
        int n4 = n2;
        int n5 = 0;
        boolean bl = false;
        for (int i = n3; i < this.nrChapter.length; ++i) {
            if (this.nrChapter[i] != 0) continue;
            this.nrChapter[i] = 0;
        }
        while (n4 < n && ((bl = (c = string.charAt(n4)) >= '0' && c <= '9') || c == ' ' || c == '.')) {
            int[] nArray = new int[1];
            if (bl && this.bSetNrChapter) {
                this.nrChapter[n5] = StringFunctions_C.parseIntRadix((CharSequence)string, (int)n4, (int)99, (int)10, (int[])nArray);
                ++n5;
                n4 += nArray[0];
                continue;
            }
            ++n4;
        }
        if (this.bSetNrChapter && n5 > 0) {
            int n6 = n5 - 1;
            this.nrChapter[n6] = this.nrChapter[n6] - 1;
        }
        if (n3 > 0 && this.nrChapter[n3 - 1] == 0) {
            this.nrChapter[n3 - 1] = 0;
        }
        if (n3 > 0) {
            this.bSetNrChapter = false;
        }
        return n4;
    }

    private String checkParseCommentLine(String string) throws IOException {
        int n = string.length();
        if (string.startsWith("//Section:")) {
            this.parseWriteSection(string);
        } else if (string.startsWith("//End-Section")) {
            this.writeSectionEnd(string);
        } else if (string.startsWith("//TOC-")) {
            this.writeTableOfContents(string.substring(6));
        }
        String string2 = null;
        return string2;
    }

    private String parseWriteSection(String string) throws IOException {
        String string2;
        int n = string.indexOf(58, 3);
        int n2 = string.indexOf(62);
        if (n2 < 0) {
            n2 = string.length();
        }
        if ((string2 = string.substring(n + 1, n2).trim()).startsWith("Column")) {
            this.bInsideColumn2 = true;
        }
        this.finitList(0);
        this.xmlWr.writeElement("text:section");
        this.xmlWr.writeAttribute("text:style-name", string2);
        this.xmlWr.writeAttribute("text:name", "Section" + ++this.nrSectionName);
        ++this.nSection;
        return null;
    }

    private String writeSectionEnd(String string) throws IOException {
        if (this.nSection > 0) {
            this.finitSection(this.nSection - 1);
            this.bInsideColumn2 = false;
        }
        return null;
    }

    private String parseWriteParagrStyleLabel(String string) throws IOException {
        int n;
        Object var2_2 = null;
        char c = this.args.bReadAdoc ? (char)']' : '>';
        int n2 = string.indexOf(c);
        if (n2 < 0) {
            return "ERROR in Asciidoc, missing " + c + " in line: " + string;
        }
        if (string.charAt(n2 - 1) == '.') {
            --n2;
        }
        String string2 = null;
        if (!this.args.bReadAdoc) {
            n = string.indexOf(":", 4);
            if (n >= 0 && n < n2) {
                string2 = string.substring(n + 1, n2).trim();
                n2 = n;
            }
            this.sStyleParagr = string.substring(4, n2).trim();
        } else if (string.startsWith("[.")) {
            String string3;
            this.sStyleParagr = string3 = string.substring(2, n2);
        } else if (string.startsWith("[Source,")) {
            this.sCodeStyle = string.substring(8, n2).trim();
        } else if (string.startsWith("[#")) {
            string2 = string.substring(2, n2).trim();
        }
        n = string.charAt(n2) == '.' ? n2 + 2 : n2 + 1;
        String string4 = string.substring(n).trim();
        return this.parseWriteParagr(string4, string2);
    }

    private String parseWriteParagr(String string, String string2) throws IOException {
        if (string.startsWith("LibreOffice and Asciidoc are two very different approaches")) {
            Debugutil.stop();
        }
        String string3 = null;
        this.finitList(0);
        this.xmlWr.writeElement("text:p");
        if (this.bColumnBreakBefore) {
            Debugutil.stop();
        }
        if (this.sStyleParagr == null) {
            this.sStyleParagr = this.bPageBreakBefore ? "TextPg" : (this.bColumnBreakBefore ? "TextCol" : "Text");
        }
        this.bColumnBreakBefore = false;
        this.bPageBreakBefore = false;
        this.bParagrFirstline = false;
        StringBuilder stringBuilder = this.readAllTextLinesOfParagraph(string);
        string3 = this.parseWriteText(stringBuilder, false);
        this.xmlWr.writeElementEndInline("text:p");
        return string3;
    }

    private String parseList(String string) throws IOException {
        String string2 = null;
        if (this.bInsideListItem) {
            this.xmlWr.writeElementEnd("text:list-item");
            this.bInsideListItem = false;
        }
        int n = string.length();
        int n2 = 0;
        while (++n2 < n && string.charAt(n2) == '*') {
        }
        int n3 = n2;
        while (this.nList < n3) {
            ++this.nList;
            this.xmlWr.writeElement("text:list");
            this.xmlWr.writeAttribute("text:style-name", "List_20_" + this.nList);
            this.xmlWr.writeElement("text:list-item");
            this.bInsideListItem = true;
        }
        if (!this.bInsideListItem) {
            this.xmlWr.writeElement("text:list-item");
            this.bInsideListItem = true;
        }
        this.finitList(n3);
        this.xmlWr.writeElement("text:p");
        this.xmlWr.writeAttribute("text:style-name", "text_List" + this.nList);
        this.bParagrFirstline = true;
        if (string.length() > n2 + 1) {
            StringBuilder stringBuilder = this.readAllTextLinesOfParagraph(string.substring(n2 + 1));
            string2 = this.parseWriteText(stringBuilder, false);
        }
        this.xmlWr.writeElementEndInline("text:p");
        this.xmlWr.writeElementEnd("text:list-item");
        this.bInsideListItem = false;
        return string2;
    }

    private StringBuilder readAllTextLinesOfParagraph(String string) throws IOException {
        if (string.startsWith("The element")) {
            Debugutil.stop();
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        String string2 = string;
        if (string != null) {
            if (!this.args.bReadAdoc) {
                string2 = string.trim();
            }
            stringBuilder.append(string2);
        }
        do {
            boolean bl = string2.length() > 0 && !string2.endsWith("::");
            string2 = this.rZmL.readLine();
            if (string2 != null && string2.startsWith("<.")) {
                this.sLineNext = string2;
                string2 = null;
            } else if (this.isEmptyLine(string2, 0)) {
                string2 = null;
            } else {
                if (!this.args.bReadAdoc) {
                    string2 = string2.trim();
                }
                for (String string3 : specificLineStarts) {
                    if (!string2.startsWith(string3)) continue;
                    this.sLineNext = string2;
                    string2 = null;
                    break;
                }
            }
            if (string2 == null) continue;
            if (bl) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2);
        } while (string2 != null);
        return stringBuilder;
    }

    private String parseWriteText(CharSequence charSequence, boolean bl) throws IOException {
        int n;
        int n2;
        StringBuilder stringBuilder;
        int n3 = 0;
        CharSequence charSequence2 = charSequence;
        StringBuilder stringBuilder2 = stringBuilder = charSequence2 instanceof StringBuilder ? (StringBuilder)charSequence2 : new StringBuilder(charSequence2);
        if (stringBuilder.toString().startsWith("Test ")) {
            Debugutil.stopp();
        }
        int n4 = this.args.bReadAdoc ? 2 : 1;
        boolean bl2 = false;
        int n5 = stringBuilder.length();
        if (StringFunctions.startsWith((CharSequence)stringBuilder, (CharSequence)" ")) {
            n3 = this.writeSpaceSupplement(stringBuilder);
        }
        if (stringBuilder.indexOf("etc.") >= 0) {
            Debugutil.stop();
        }
        if ((n2 = stringBuilder.indexOf("etc.")) >= 0) {
            Debugutil.stop();
        }
        int[] nArray = new int[1];
        block8: do {
            boolean bl3;
            String[] stringArray;
            int n6;
            int n7 = n5;
            int n8 = -1;
            int n9 = -1;
            n = n5;
            String string = null;
            String[] stringArray2 = new String[1];
            int n10 = StringFunctions.indexOfAnyString((CharSequence)stringBuilder, (int)n3, (int)n5, (CharSequence[])sTextCtrlCommonSearchMu, (int[])nArray, (String[])stringArray2);
            if (n10 >= 0 && (n6 = StringFunctions.indexOf((CharSequence)stringBuilder, (int)(n8 = n10 + (stringArray = sTextCtrlCommon[nArray[0]])[0].length()), (int)n5, (CharSequence)stringArray[1])) >= 0) {
                string = stringArray[4];
                n7 = n10;
                n9 = n6;
                n = n6 + stringArray[1].length();
            }
            if (!(this.sStyleParagr == null || string != null && string.equals("!image") && n7 <= n3 && n >= n5)) {
                this.xmlWr.writeAttribute("text:style-name", this.sStyleParagr);
                this.sStyleParagr = null;
            }
            if (n7 > n3) {
                bl3 = string != null && string.equals("!Tstyle") && n7 >= n3 + 2 && stringBuilder.substring(n7 - 2, n7).equals(">>");
                int n11 = bl3 ? n7 - 2 : n7;
                CharSequence charSequence3 = this.replaceBackslasSubscription(stringBuilder.substring(n3, n11), null, false, false);
                this.writeText(charSequence3, bl);
            } else {
                bl3 = false;
            }
            if (string == null) continue;
            String string2 = this.replaceBackslasSubscription(stringBuilder.substring(n8, n9), null, false, false).toString();
            char c = string.charAt(0);
            if (c == '*' || c == '+') {
                this.xmlWr.writeText((CharSequence)string2, false);
                continue;
            }
            if (string.charAt(0) == '!') {
                switch (string.charAt(1)) {
                    case 'l': {
                        this.writeChapterRef(string2);
                        break;
                    }
                    case 'p': {
                        this.writeInternalRefPage(string2);
                        break;
                    }
                    case 'g': {
                        this.writeLink(string2);
                        break;
                    }
                    case 'i': {
                        int n12 = this.sStyleParagr != null && n == n5 ? 1 : 0;
                        this.parseImage(string2, n12 != 0);
                        break;
                    }
                    case 'T': {
                        int n12 = StringFunctions.indexOf((CharSequence)stringBuilder, (int)n8, (int)n9, (char)':');
                        if (n12 <= 0) continue block8;
                        String string3 = stringBuilder.substring(n8, n12);
                        CharSequence charSequence4 = this.replaceBackslasSubscription(stringBuilder.substring(n12 + 1, n9), null, false, false);
                        boolean bl4 = false;
                        if (bl3) {
                            bl4 = this.writeJavadocLink(charSequence4, string3);
                        }
                        if (bl4) continue block8;
                        if (bl3) {
                            this.writeText(">>", false);
                        }
                        this.xmlWr.writeElementInline("text:span");
                        this.xmlWr.writeAttribute("text:style-name", string3);
                        this.writeText(charSequence4, bl);
                        this.xmlWr.writeElementEnd("text:span");
                        break;
                    }
                    case 's': {
                        n = n7 + this.writeSpaceSupplement(stringBuilder.substring(n7));
                    }
                }
                continue;
            }
            this.xmlWr.writeElementInline("text:span");
            this.xmlWr.writeAttribute("text:style-name", string);
            this.parseWriteText(string2, bl);
            this.xmlWr.writeElementEnd("text:span");
        } while ((n3 = n) < n5);
        if (n3 < n5) {
            CharSequence charSequence5 = this.replaceBackslasSubscription(stringBuilder.substring(n3), null, false, false);
            this.writeText(charSequence5, false);
        }
        return null;
    }

    private boolean writeJavadocLink(CharSequence charSequence, String string) throws IOException {
        try {
            GetJavadocLabel.Link link;
            int n;
            StringBuilder stringBuilder;
            String string2;
            String string3;
            int n2 = StringFunctions.indexOf((CharSequence)charSequence, (char)'#');
            int n3 = charSequence.length();
            if (n2 < 0) {
                int n4 = n3;
                int n5 = StringFunctions.indexOf((CharSequence)charSequence, (char)'(');
                if (n5 > 0) {
                    n4 = n5;
                }
                n2 = StringFunctions.lastIndexOf((CharSequence)charSequence, (int)0, (int)n4, (char)'.');
                if (n5 < 0 && n2 < n4 - 1 && Character.isUpperCase(charSequence.charAt(n2 + 1))) {
                    n2 = n4;
                }
            }
            if (n2 >= 0 && n2 < n3) {
                string3 = charSequence.subSequence(0, n2).toString();
                string2 = charSequence.subSequence(n2 + 1, n3).toString();
                stringBuilder = null;
                n = StringFunctions.indexOfAnyChar((CharSequence)string2, (int)0, (int)-1, (CharSequence)"\u200b \n\r");
                while (n >= 0) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string2);
                    }
                    stringBuilder.deleteCharAt(n);
                    n = StringFunctions.indexOfAnyChar((CharSequence)stringBuilder, (int)n, (int)-1, (CharSequence)"\u200b \n\r");
                }
                if (stringBuilder != null) {
                    string2 = stringBuilder.toString();
                }
            } else {
                string3 = charSequence.toString();
                string2 = null;
            }
            stringBuilder = null;
            n = StringFunctions.indexOfAnyChar((CharSequence)string3, (int)0, (int)-1, (CharSequence)"\u200b \n\r");
            while (n >= 0) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string3);
                }
                stringBuilder.deleteCharAt(n);
                n = StringFunctions.indexOfAnyChar((CharSequence)stringBuilder, (int)n, (int)-1, (CharSequence)"\u200b \n\r");
            }
            if (stringBuilder != null) {
                string3 = stringBuilder.toString();
            }
            if ((link = this.javadocLabel.idxClass2Html.get(string3)) != null) {
                String string4;
                String string5;
                if (string2 != null && (string2.indexOf("(...)") > 0 || string2.indexOf("()") > 0)) {
                    string2 = this.searchForReplacingLinkOperationLabel(link.sLocal, string2, this.args.fDirOdt);
                }
                if (string2 != null) {
                    string5 = link.sWWW + '#' + string2;
                    string4 = link.sLocal + '#' + string2;
                } else {
                    string5 = link.sWWW;
                    string4 = link.sLocal;
                }
                this.xmlWr.writeElementInline("text:a");
                this.xmlWr.writeAttribute("xlink:type", "simple");
                this.xmlWr.writeAttribute("xlink:href", string5);
                this.xmlWr.writeAttribute("text:style-name", "Internet_20_link");
                this.xmlWr.writeAttribute("text:visited-style-name", "Visited_20_Internet_20_Link");
                this.writeText(">>", false);
                this.xmlWr.writeElementEnd("text:a");
                this.xmlWr.writeElementInline("text:a");
                this.xmlWr.writeAttribute("xlink:type", "simple");
                this.xmlWr.writeAttribute("xlink:href", "." + string4);
                this.xmlWr.writeAttribute("text:style-name", string);
                this.xmlWr.writeAttribute("text:visited-style-name", string);
                this.writeText(charSequence, false);
                this.xmlWr.writeElementEnd("text:a");
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            this.log.writeError("unexpected", (Throwable)exception);
            return false;
        }
    }

    private int writeSpaceSupplement(CharSequence charSequence) throws IOException {
        int n;
        int n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) == ' '; ++n) {
        }
        this.xmlWr.writeElementInline("text:s");
        this.xmlWr.writeAttribute("text:c", "" + n);
        this.xmlWr.writeElementEnd("text:s");
        return n;
    }

    private void writeChapterRef(String string) throws IOException {
        try {
            String string2;
            int n = string.indexOf(this.args.bReadAdoc ? 44 : 58);
            String string3 = string2 = n > 0 ? string.substring(0, n) : string;
            if (!string2.startsWith("#")) {
                this.log.writef("\nWARNING <:@ref:%s without # is ignored.", new Object[]{string});
            } else {
                String string4;
                this.sRefBookmark = string2;
                string2 = string2.substring(1);
                ReadOdt.LabelRef labelRef = this.idxLabelExternRef.get(string2);
                boolean bl = string2.startsWith("__Img_");
                if (bl) {
                    Debugutil.stop();
                }
                String string5 = string2;
                if (!bl && !string2.startsWith("__Link_")) {
                    string5 = "__Link_" + string2;
                }
                if (labelRef == null) {
                    labelRef = this.idxLabelExternRef.get(string5);
                }
                String string6 = string4 = n > 0 ? string.substring(n + 1) : string;
                if (labelRef != null) {
                    this.writeChapterRefExtern(string2, labelRef);
                } else {
                    this.xmlWr.writeElementInline("text:span");
                    this.xmlWr.writeAttribute("text:style-name", "Reference");
                    this.xmlWr.writeElementInline("text:bookmark-ref");
                    this.xmlWr.writeAttribute("text:reference-format", "text");
                    this.xmlWr.writeAttribute("text:ref-name", string5);
                    this.xmlWr.writeText((CharSequence)string4, false);
                    this.xmlWr.writeElementEnd("text:bookmark-ref");
                    this.xmlWr.writeElementEndInline("text:span");
                }
            }
        }
        catch (Exception exception) {
            CharSequence charSequence = ExcUtil.exceptionInfo((CharSequence)"", (Throwable)exception, (int)0, (int)20);
            this.log.writef("\nException %s", new Object[]{charSequence});
            charSequence = ExcUtil.exceptionInfo((CharSequence)"Exception: ", (Throwable)exception, (int)0, (int)2);
            this.xmlWr.writeElementInline("text:span");
            this.xmlWr.writeAttribute("text:style-name", "Emphasis");
            this.writeText("Exception: ", false);
            this.writeText(charSequence, false);
            this.xmlWr.writeElementEndInline("text:span");
        }
    }

    private void writeChapterRefExtern(String string, ReadOdt.LabelRef labelRef) throws IOException {
        try {
            String string2;
            String string3 = this.args.sRefBesideHtml != null ? this.args.sRefBesideHtml + labelRef.sRefHeading + this.args.sExtRefBesideHtml + "#" + string : null;
            String string4 = this.args.sRefBesideInWWWHtml != null ? this.args.sRefBesideInWWWHtml + labelRef.sRefHeading + this.args.sExtRefBesideHtml + "#" + string : null;
            String string5 = this.args.sRefBesidePdf == null ? null : this.args.sRefBesidePdf + labelRef.sRefHeading + this.args.sExtRefBesidePdf;
            String string6 = string2 = this.args.sRefBesideInWWWPdf == null ? null : this.args.sRefBesideInWWWPdf + labelRef.sRefHeading + this.args.sExtRefBesidePdf;
            if (!FileFunctions.isAbsolutePath((CharSequence)string3)) {
                string3 = string3.startsWith("./") ? "." + string3 : "../" + string3;
            }
            if (!FileFunctions.isAbsolutePath(string5)) {
                string5 = string5.startsWith("./") ? "." + string5 : "../" + string5;
            }
            if (string2 != null) {
                this.xmlWr.writeElementInline("text:a");
                this.xmlWr.writeAttribute("xlink:type", "simple");
                this.xmlWr.writeAttribute("xlink:href", string2);
                this.xmlWr.writeAttribute("text:style-name", "Internet_20_link");
                this.xmlWr.writeAttribute("text:visited-style-name", "Visited_20_Internet_20_Link");
                this.writeText(">>>", false);
                this.xmlWr.writeElementEnd("text:a");
            }
            if (string5 != null) {
                this.xmlWr.writeElementInline("text:a");
                this.xmlWr.writeAttribute("xlink:type", "simple");
                this.xmlWr.writeAttribute("xlink:href", string5 == null ? (string2 == null ? string3 : string2) : string5);
                if (string2 == null) {
                    this.xmlWr.writeAttribute("text:style-name", "Internet_20_link");
                    this.xmlWr.writeAttribute("text:visited-style-name", "Visited_20_Internet_20_Link");
                } else {
                    this.xmlWr.writeAttribute("text:style-name", "Reference");
                    this.xmlWr.writeAttribute("text:visited-style-name", "Reference");
                }
                this.writeText(labelRef.sRefHeading, false);
                this.writeText(".pdf", false);
                this.xmlWr.writeElementEnd("text:a");
            }
            if (string4 == null && string3 == null) {
                this.xmlWr.writeElementInline("text:hidden-text");
                this.xmlWr.writeAttribute("text:condition", "ooow:");
                this.xmlWr.writeAttribute("text:string-value", "@ref#" + string);
                this.xmlWr.writeAttribute("text:is-hidden", "true");
                this.xmlWr.writeElementEnd("text:hidden-text");
            }
            this.writeText(": ", false);
            if (string4 != null) {
                this.xmlWr.writeElementInline("text:a");
                this.xmlWr.writeAttribute("xlink:type", "simple");
                this.xmlWr.writeAttribute("xlink:href", string4);
                this.xmlWr.writeAttribute("text:style-name", "Internet_20_link");
                this.xmlWr.writeAttribute("text:visited-style-name", "Visited_20_Internet_20_Link");
                this.writeText(">>>", false);
                this.xmlWr.writeElementEnd("text:a");
            }
            if (string3 != null) {
                this.xmlWr.writeElementInline("text:a");
                this.xmlWr.writeAttribute("xlink:type", "simple");
                this.xmlWr.writeAttribute("xlink:href", string3);
                this.xmlWr.writeAttribute("text:style-name", "Reference");
                this.xmlWr.writeAttribute("text:visited-style-name", "Reference");
                this.writeText(labelRef.sTitle, false);
                this.xmlWr.writeElementEnd("text:a");
            } else {
                this.xmlWr.writeElementInline("text:span");
                this.xmlWr.writeAttribute("text:style-name", "Reference");
                this.writeText(labelRef.sTitle, false);
                this.xmlWr.writeElementEndInline("text:span");
            }
        }
        catch (Exception exception) {
            CharSequence charSequence = ExcUtil.exceptionInfo((CharSequence)"", (Throwable)exception, (int)0, (int)20);
            this.log.writef("\nException %s", new Object[]{charSequence});
            charSequence = ExcUtil.exceptionInfo((CharSequence)"Exception: ", (Throwable)exception, (int)0, (int)2);
            this.xmlWr.writeElementInline("text:span");
            this.xmlWr.writeAttribute("text:style-name", "Emphasis");
            this.writeText("Exception: ", false);
            this.writeText(charSequence, false);
            this.xmlWr.writeElementEndInline("text:span");
        }
    }

    private void writeInternalRefPage(String string) throws IOException {
        ReadOdt.LabelRef labelRef = null;
        String string2 = string == null || !string.startsWith("#") ? this.sRefBookmark : string;
        if (string2 == null) {
            this.log.writef("\nERROR <:@page.> without any <:@ref:... before", new Object[0]);
            return;
        }
        string2 = string2.substring(1);
        labelRef = this.idxLabelExternRef.get(string2);
        boolean bl = string2.startsWith("__Img_");
        if (!bl && !string2.startsWith("__Link_")) {
            string2 = "__Link_" + string2;
        }
        if (labelRef == null) {
            labelRef = this.idxLabelExternRef.get(string2);
        }
        if (labelRef != null) {
            this.xmlWr.writeElementInline("text:span");
            this.xmlWr.writeAttribute("text:style-name", "Reference");
            this.xmlWr.writeText((CharSequence)labelRef.sPage, false);
            this.xmlWr.writeElementEndInline("text:span");
        } else {
            this.xmlWr.writeElementInline("text:span");
            this.xmlWr.writeAttribute("text:style-name", "Reference");
            this.xmlWr.writeElementInline("text:bookmark-ref");
            this.xmlWr.writeAttribute("text:reference-format", "page");
            this.xmlWr.writeAttribute("text:ref-name", string2);
            this.xmlWr.writeText((CharSequence)"78", false);
            this.xmlWr.writeElementEnd("text:bookmark-ref");
            this.xmlWr.writeElementEndInline("text:span");
        }
    }

    private void writeLink(String string) throws IOException {
        String string2;
        String string3;
        int n;
        if (this.args.bReadAdoc) {
            n = string.indexOf(91);
            if (n < 0) {
                this.xmlWr.writeText((CharSequence)("link:" + string + "]"), false);
                string3 = null;
                string2 = null;
            } else {
                string2 = string3 = string.substring(0, n);
            }
        } else {
            n = string.indexOf("::");
            if (n >= 0) {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 2);
            } else {
                string3 = string2 = string;
            }
        }
        if (string3 != null) {
            if (StringFunctions.indexOfAnyString((CharSequence)string3, (int)0, (int)6, (CharSequence[])sWwwLink, null, null) == 0) {
                string3 = this.checkReplaceLinkOperationLabel(string3);
            } else {
                int n2;
                n = string3.indexOf(".html#");
                if (n > 0 && ((n2 = string3.indexOf("(...)")) > 0 || (n2 = string3.indexOf("()")) > 0)) {
                    String string4 = string3.substring(0, n + 5);
                    String string5 = string3.substring(n + 6);
                    String string6 = this.searchForReplacingLinkOperationLabel(string4, string5, this.args.fDirOdt);
                    string3 = string4 + '#' + string6;
                }
                int n3 = StringFunctions.indexAfterAnyChar((CharSequence)string3, (int)0, (int)-1, (CharSequence)"/.");
                this.lastAnchorReplaced = string3.substring(n3);
                string3 = string3.startsWith("./") ? "." + string3 : "../" + string3;
            }
            this.xmlWr.writeElementInline("text:a");
            this.xmlWr.writeAttribute("xlink:type", "simple");
            this.xmlWr.writeAttribute("xlink:href", string3);
            this.xmlWr.writeAttribute("text:style-name", "Internet_20_link");
            this.xmlWr.writeAttribute("text:visited-style-name", "Visited_20_Internet_20_Link");
            this.writeText(string2, false);
            this.xmlWr.writeElementEnd("text:a");
        }
    }

    private String checkReplaceLinkOperationLabel(String string) {
        String string2 = string;
        int n = string.indexOf(35);
        int n2 = string.indexOf("...");
        if (n2 > 0) {
            Debugutil.stop();
        }
        if ((n > 0 || n2 > 0) && this.lastAnchorReplaced.length() > 0 && string.startsWith(this.args.swwwRoot)) {
            if (n2 > 0) {
                string2 = string.substring(0, n2) + this.lastAnchorReplaced;
            } else {
                int n3 = this.lastAnchorReplaced.indexOf(35);
                String string3 = this.lastAnchorReplaced.substring(0, n3 + 1);
                int n4 = string.indexOf(string3);
                if (n4 > 0) {
                    string2 = string.substring(0, n4) + this.lastAnchorReplaced;
                }
            }
        }
        this.lastAnchorReplaced = "";
        return string2;
    }

    private String writeText(CharSequence charSequence, boolean bl) throws IOException {
        int n;
        int n2;
        int n3;
        StringBuilder stringBuilder = null;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 instanceof StringBuilder) {
            stringBuilder = (StringBuilder)charSequence2;
        }
        int n4 = -1;
        n4 = n3 = charSequence2.length();
        for (n2 = n = 0; n2 < n3 && charSequence2.charAt(n2) == ' '; ++n2) {
        }
        if (n2 > n) {
            this.xmlWr.writeElementInline("text:s");
            int n5 = n2 - n;
            this.xmlWr.writeAttribute("text:c", "" + n5);
            this.xmlWr.writeElementEnd("text:s");
            n = n2;
        }
        CharSequence[] charSequenceArray = new String[]{"\n", "\t", "  "};
        int[] nArray = new int[1];
        while ((n2 = StringFunctions.indexOfAnyString((CharSequence)charSequence2, (int)n, (int)-1, (CharSequence[])charSequenceArray, (int[])nArray, null)) >= 0) {
            if (n2 > n) {
                this.xmlWr.writeText(charSequence2.subSequence(n, n2), false);
            }
            switch (nArray[0]) {
                case 0: {
                    this.xmlWr.writeElementInline("text:line-break");
                    this.xmlWr.writeElementEndInline("text:line-break");
                    break;
                }
                case 1: {
                    this.xmlWr.writeElementInline("text:tab");
                    this.xmlWr.writeElementEndInline("text:tab");
                    break;
                }
                case 2: {
                    int n6 = n2;
                    while (n2 < n3 && charSequence2.charAt(n2) == ' ') {
                        ++n2;
                    }
                    this.xmlWr.writeElementInline("text:s");
                    int n7 = n2 - n6;
                    if (n7 > 1) {
                        this.xmlWr.writeAttribute("text:c", "" + n7);
                    }
                    this.xmlWr.writeElementEnd("text:s");
                    --n2;
                    break;
                }
            }
            n = n2 + 1;
        }
        if (n < charSequence2.length()) {
            this.xmlWr.writeText(charSequence2.subSequence(n, charSequence2.length()), false);
        }
        if (n4 < n3) {
            this.xmlWr.writeElementInline("text:s");
            if (n4 < n3 - 1) {
                this.xmlWr.writeAttribute("text:c", "" + (n3 - n4));
            }
            this.xmlWr.writeElementEnd("text:s");
        }
        return null;
    }

    private CharSequence replaceBackslasSubscription(CharSequence charSequence, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        int n;
        StringBuilder stringBuilder2 = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : stringBuilder;
        CharSequence charSequence2 = charSequence;
        int n2 = 0;
        int[] nArray = new int[1];
        int n3 = n = this.args.bReadAdoc ? 2 : 1;
        do {
            if ((n2 = StringFunctions.indexOfAnyString((CharSequence)charSequence2, (int)n2, (int)9999, (CharSequence[])sCheckTextReplZmL, (int[])nArray, null)) < 0) continue;
            if (stringBuilder2 == null) {
                stringBuilder2 = new StringBuilder(charSequence2);
                charSequence2 = stringBuilder2;
            }
            String[] stringArray = sTextReplace[nArray[0]];
            char c = stringArray[3].charAt(0);
            String string = bl ? (c == 'x' ? stringArray[0] : (c == ' ' && bl2 ? "" : stringArray[3])) : stringArray[0];
            stringBuilder2.replace(n2, n2 + stringArray[n].length(), string);
            n2 += string.length();
        } while (n2 >= 0);
        return charSequence2;
    }

    private String parseWriteCodeBlock(String string) throws IOException {
        if (!this.args.bReadAdoc) {
            int n = string.indexOf(58, 2);
            int n2 = string.indexOf(62);
            if (n2 == n + 1) {
                Debugutil.stop();
            }
            if (n > 0 && n2 > n) {
                this.sCodeStyle = "Code" + string.substring(n + 1, n2);
            } else {
                this.sCodeStyle = "Code";
                this.log.writeError("WARNING faulty %s\n", new Object[]{string});
            }
        }
        String string2 = this.rZmL.readLine();
        do {
            if (string2.startsWith("<::include:")) {
                StringBuilder stringBuilder = this.readAllTextLinesOfParagraph(string2);
                String string3 = stringBuilder.toString();
                int n = string3.lastIndexOf(".>");
                if (n < 0) {
                    n = string3.length();
                }
                this.includeSrcCode(string3.substring(3, n), this.sCodeStyle);
            } else {
                if (string2.startsWith("<.Code") || this.args.bReadAdoc && string2.startsWith("----")) break;
                this.xmlWr.writeElement("text:p");
                this.xmlWr.writeAttribute("text:style-name", this.sCodeStyle);
                this.parseWriteText(string2, false);
                this.xmlWr.writeElementEndInline("text:p");
            }
            if (this.sLineNext == null) {
                string2 = this.rZmL.readLine();
                continue;
            }
            string2 = this.sLineNext;
            this.sLineNext = null;
        } while (string2 != null);
        this.sCodeStyle = null;
        this.bInsideCode = false;
        return null;
    }

    private void includeSrcCode(String string, String string2) throws IOException {
        String string3 = this.replaceBackslasSubscription(string, null, true, true).toString();
        String string4 = this.replaceBackslasSubscription(string, null, false, false).toString();
        CodeIncludeInfo codeIncludeInfo = new CodeIncludeInfo(string3);
        this.xmlWr.writeElement("text:p");
        String string5 = this.bPageBreakBefore ? "CaptionCodePg" : (this.bColumnBreakBefore ? "CaptionCodeCol" : "CaptionCode");
        this.bColumnBreakBefore = false;
        this.bPageBreakBefore = false;
        this.xmlWr.writeAttribute("text:style-name", string5);
        this.writeText(string4, false);
        this.xmlWr.writeElementEndInline("text:p");
        if (codeIncludeInfo.sErrorMsg != null) {
            this.xmlWr.writeElement("text:p");
            this.xmlWr.writeAttribute("text:style-name", string2);
            this.xmlWr.writeText((CharSequence)("Error: " + codeIncludeInfo.sErrorMsg), false);
            this.xmlWr.writeElementEndInline("text:p");
            this.log.writef("\nERROR <::include: %s %s", new Object[]{codeIncludeInfo.sErrorMsg, string3});
        } else {
            BufferedReader bufferedReader;
            File file = new File(codeIncludeInfo.sFile);
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                bufferedReader = null;
                String string6 = FileFunctions.absolutePath((String)codeIncludeInfo.sFile, null);
                this.xmlWr.writeElement("text:p");
                this.xmlWr.writeAttribute("text:style-name", string2);
                this.xmlWr.writeText((CharSequence)("File not found: >>" + codeIncludeInfo.sFile + "<< " + string6), false);
                this.xmlWr.writeElementEndInline("text:p");
                this.log.writef("\nERROR file not found: %s (%s)", new Object[]{codeIncludeInfo.sFile, string6});
            }
            if (bufferedReader != null) {
                String string7;
                boolean bl = codeIncludeInfo.sTagStart.equals("<::$.>");
                int n = codeIncludeInfo.tagStartRepeat;
                int n2 = codeIncludeInfo.tagEndRepeat;
                Iterator<CodeIncludeInfo.MarkerLine> iterator = codeIncludeInfo.markerLines == null ? null : codeIncludeInfo.markerLines.iterator();
                CodeIncludeInfo.MarkerLine markerLine = iterator == null ? null : iterator.next();
                int n3 = bl ? 0 : -1;
                int n4 = markerLine == null ? -1 : markerLine.line;
                int n5 = 0;
                int n6 = codeIncludeInfo.nrLines;
                while ((n6 > 0 || n2 > 0) && (string7 = bufferedReader.readLine()) != null) {
                    int n7;
                    int n8;
                    int n9;
                    String string8;
                    int n10;
                    String string9 = null;
                    if (n3 >= 0) {
                        if (markerLine != null && (n3 == n4 || markerLine.sSearch != null && string7.indexOf(markerLine.sSearch) >= 0)) {
                            string9 = markerLine.marker;
                            n5 = markerLine.column;
                            CodeIncludeInfo.MarkerLine markerLine2 = markerLine = iterator == null || !iterator.hasNext() ? null : iterator.next();
                            n4 = markerLine == null ? -1 : (markerLine.line < 0 ? -1 : (markerLine.bLineNext ? n3 + markerLine.line : (markerLine.line <= n3 ? n3 + 1 : markerLine.line)));
                        }
                        ++n3;
                    }
                    boolean bl2 = false;
                    if (!bl) {
                        n10 = string7.indexOf(codeIncludeInfo.sTagStart);
                        if (n10 >= 0 && --n == 0) {
                            bl = true;
                            n3 = 1;
                            string8 = codeIncludeInfo.bWriteTag ? string7 : string7.substring(0, n10);
                        } else if (codeIncludeInfo.sTagStartNextLine != null && string7.indexOf(codeIncludeInfo.sTagStartNextLine) >= 0) {
                            bl = true;
                            string8 = null;
                        } else if (codeIncludeInfo.sTagCont != null && (n10 = string7.indexOf(codeIncludeInfo.sTagCont)) >= 0 || string9 != null && string9.equals("+") && (n10 = string7.length()) > 0) {
                            bl = true;
                            string8 = string7.substring(0, n10);
                            string9 = null;
                        } else {
                            string8 = null;
                        }
                    } else if (codeIncludeInfo.sTagEnd != null && (n10 = string7.indexOf(codeIncludeInfo.sTagEnd)) >= 0 && WriteOdt.checkIndentation(codeIncludeInfo.indentEnd, codeIncludeInfo.nrofSpacesIndent, n10, string7)) {
                        --n2;
                        string8 = codeIncludeInfo.bWriteTag ? string7 : string7.substring(0, n10);
                    } else if (codeIncludeInfo.sTagEndExclLine != null && (n10 = string7.indexOf(codeIncludeInfo.sTagEndExclLine)) >= 0) {
                        --n2;
                        string8 = null;
                    } else if (codeIncludeInfo.sTagPause != null && (n10 = string7.indexOf(codeIncludeInfo.sTagPause)) >= 0 || (bl2 = string9 != null && string9.equals("-"))) {
                        string8 = "    ......";
                        bl = false;
                        if (bl2 && markerLine == null) {
                            n2 = 0;
                            string8 = null;
                        }
                        string9 = null;
                    } else {
                        string8 = string7;
                    }
                    if (string8 == null) continue;
                    --n6;
                    int n11 = codeIncludeInfo.maxLineLen;
                    if (string9 == null && (n11 = string7.indexOf("<:@")) >= 0) {
                        n9 = string7.indexOf(".>", n11 + 3);
                        if (n9 < 0) {
                            n9 = string7.indexOf(62, n11 + 3);
                        }
                        if (n9 > 0) {
                            string9 = string7.substring(n11 + 3, n9);
                        }
                    }
                    n9 = string8.length();
                    if (string9 == null) {
                        n8 = codeIncludeInfo.maxLineLen;
                    } else {
                        n8 = codeIncludeInfo.maxLineLen - string9.length();
                        if (n8 > n11) {
                            n8 = n11;
                        }
                    }
                    if (codeIncludeInfo.sComment != null) {
                        int n12 = string8.indexOf(codeIncludeInfo.sComment);
                        if (n12 >= 0) {
                            string8 = string8.substring(0, n12);
                        }
                        n9 = string8.length();
                        for (n7 = n9 - 1; n7 >= 0 && " \t".indexOf(string8.charAt(n7)) >= 0; --n7) {
                        }
                        if (n7 < 0) {
                            string8 = null;
                        }
                    }
                    if (string8 == null) continue;
                    while (n9 > n8 && string8.charAt(n9 - 1) == ' ') {
                        --n9;
                    }
                    if (n9 > n8) {
                        string8 = string7.substring(0, n8 - 3) + "...";
                    }
                    this.xmlWr.writeElement("text:p");
                    this.xmlWr.writeAttribute("text:style-name", string2);
                    this.writeText(string8, false);
                    if (string9 != null) {
                        if (n9 < n5) {
                            n7 = n5 - n9;
                            this.xmlWr.writeElementInline("text:s");
                            this.xmlWr.writeAttribute("text:c", "" + n7);
                            this.xmlWr.writeElementEnd("text:s");
                        }
                        this.xmlWr.writeElementInline("text:span");
                        this.xmlWr.writeAttribute("text:style-name", "cM");
                        this.xmlWr.writeText((CharSequence)string9, false);
                        this.xmlWr.writeElementEnd("text:span");
                    }
                    this.xmlWr.writeElementEndInline("text:p");
                }
                if (n2 > 0 && !bl && codeIncludeInfo.sTagStart != null) {
                    this.xmlWr.writeElement("text:p");
                    this.xmlWr.writeAttribute("text:style-name", string2);
                    this.xmlWr.writeText((CharSequence)("Tag not found in file: `" + codeIncludeInfo.sFile + "`' tag=`" + codeIncludeInfo.sTagStart + "' "), false);
                    this.xmlWr.writeElementEndInline("text:p");
                    this.log.writef("\n Problem with source include from '%s', tag '%s' not found", new Object[]{codeIncludeInfo.sFile, codeIncludeInfo.sTagStart});
                }
                if (n2 > 0 && codeIncludeInfo.sTagStart != null && !codeIncludeInfo.sTagStart.equals("<::$.>")) {
                    this.xmlWr.writeElement("text:p");
                    this.xmlWr.writeAttribute("text:style-name", string2);
                    this.xmlWr.writeText((CharSequence)("End tag not found in file: `" + codeIncludeInfo.sFile + "' tag=`" + codeIncludeInfo.sTagStart + "' "), false);
                    this.xmlWr.writeElementEndInline("text:p");
                    this.log.writef("\n Problem with source include from %s with end tag=", new Object[]{codeIncludeInfo.sFile, codeIncludeInfo.sTagStart});
                }
                bufferedReader.close();
            }
        }
    }

    private static boolean checkIndentation(int n, int n2, int n3, String string) {
        if (n < 0) {
            return true;
        }
        int n4 = 0;
        int n5 = n2;
        int n6 = n3 - 1;
        while (n4 <= n && n6 >= 0) {
            char c = string.charAt(n6);
            if (c == ' ') {
                --n6;
                if (--n5 > 0) continue;
                ++n4;
                n5 = n2;
                continue;
            }
            if (c == '\t') {
                --n6;
                --n4;
                continue;
            }
            return false;
        }
        return n4 == n && n6 < 0;
    }

    private String writeTableOfContents(String string) throws IOException {
        this.finitList(0);
        int n = string.indexOf("chapter-");
        int n2 = n >= 0 ? n + 8 : 0;
        int n3 = StringFunctions_C.parseIntRadix((CharSequence)string, (int)n2, (int)9999, (int)10, null);
        if (n3 == 0) {
            return "ERROR " + string;
        }
        int n4 = string.indexOf(58);
        String string2 = n4 > 0 ? string.substring(n4 + 1).trim() : "Table of Contents";
        this.xmlWr.writeElement("text:table-of-content");
        this.xmlWr.writeAttribute("text:style-name", "SectTOCc");
        this.xmlWr.writeAttribute("text:protected", "true");
        this.xmlWr.writeElement("text:table-of-content-source");
        this.xmlWr.writeAttribute("text:outline-level", "" + n3);
        if (n >= 0) {
            this.xmlWr.writeAttribute("text:index-scope", "chapter");
        }
        this.xmlWr.writeElement("text:index-title-template");
        this.xmlWr.writeAttribute("text:style-name", "Contents_20_Heading");
        this.xmlWr.writeText((CharSequence)string2, false);
        this.xmlWr.writeElementEnd("text:index-title-template");
        this.xmlWr.writeElementEnd("text:table-of-content-source");
        this.xmlWr.writeElement("text:index-body");
        this.xmlWr.writeElement("text:index-title");
        this.xmlWr.writeElement("text:p");
        String string3 = this.bPageBreakBefore ? "Contents_20_Heading_pg" : (this.bColumnBreakBefore ? "Contents_20_Heading_col" : "Contents_20_Heading");
        this.bColumnBreakBefore = false;
        this.bPageBreakBefore = false;
        this.xmlWr.writeAttribute("text:style-name", string3);
        this.xmlWr.writeText((CharSequence)string2, false);
        this.xmlWr.writeElementEndInline("text:p");
        this.xmlWr.writeElementEnd("text:index-title");
        this.xmlWr.writeElementEnd("text:index-body");
        this.xmlWr.writeElementEnd("text:table-of-content");
        return null;
    }

    private void writeExternReferences() throws IOException {
        String string = "?";
        for (ReadOdt.LabelRef labelRef : this.idxChnrExternRef.values()) {
            if (!labelRef.sRefHeading.equals(string)) {
                this.xmlWr.writeElement("text:p");
                this.xmlWr.writeAttribute("text:style-name", "ExternRefTitle");
                this.writeText("Docu file: ", false);
                this.writeText(labelRef.sRefHeading, false);
                this.xmlWr.writeElementEndInline("text:p");
                string = labelRef.sRefHeading;
            }
            for (String string2 : labelRef.idxLabel.values()) {
                this.xmlWr.writeElement("text:p");
                this.xmlWr.writeAttribute("text:style-name", "ExternRefList");
                this.xmlWr.writeElementInline("text:bookmark-start");
                this.xmlWr.writeAttribute("text:name", "__Link_" + string2);
                this.xmlWr.writeElementEnd("text:bookmark-start");
                String string3 = labelRef.sTitle;
                int n = string3.indexOf(32);
                if (n > 0) {
                    string3 = string3.substring(0, n) + '\t' + string3.substring(n + 1);
                }
                this.writeText(string3, false);
                this.writeText(" page ", false);
                this.writeText(labelRef.sPage, false);
                this.writeText(" (#", false);
                this.writeText(string2, false);
                this.writeText(")", false);
                this.xmlWr.writeElementInline("text:bookmark-end");
                this.xmlWr.writeAttribute("text:name", "__Link_" + string2);
                this.xmlWr.writeElementEnd("text:bookmark-end");
                this.xmlWr.writeElementEndInline("text:p");
            }
        }
    }

    private void finitList(int n) throws IOException {
        while (this.nList > n) {
            if (this.bInsideListItem) {
                this.xmlWr.writeElementEnd("text:list-item");
            }
            this.bInsideListItem = false;
            this.xmlWr.writeElementEnd("text:list");
            --this.nList;
        }
    }

    private void finitSection(int n) throws IOException {
        this.finitList(0);
        while (this.nSection > n) {
            this.xmlWr.writeElementEnd();
            --this.nSection;
        }
    }

    private String parseWriteTable(String string) throws IOException {
        String string2;
        String string3 = null;
        int n = string.indexOf(58, 2);
        int n2 = string.indexOf(62);
        if (n2 < 0) {
            return "missing > on <::table";
        }
        String string4 = "2";
        while (n >= 0 && n < n2) {
            String string5;
            int n3 = string.indexOf(58, n + 1);
            if (n3 < 0 || n3 > n2) {
                n3 = n2;
            }
            if ((string5 = string.substring(n + 1, n3).trim()).startsWith("col=")) {
                string4 = string5.substring(4);
            }
            n = n3;
        }
        this.xmlWr.writeElement("table:table");
        this.xmlWr.writeAttribute("table:name", "Table" + ++this.nrTableName);
        this.xmlWr.writeAttribute("table:style-name", "Table1");
        this.xmlWr.writeAttribute("table:template-name", "Elegant");
        this.xmlWr.writeElement("table:table-column");
        this.xmlWr.writeAttribute("table:style-name", "Table1.A");
        this.xmlWr.writeAttribute("table:number-columns-repeated", string4);
        this.xmlWr.writeElementEnd("table:table-column");
        boolean bl = true;
        while (string3 == null && bl && (string2 = this.sLineNext != null ? this.sLineNext : this.rZmL.readLine()) != null) {
            this.sLineNext = null;
            if (this.isEmptyLine(string2 = string2.trim(), 0)) continue;
            if (string2.startsWith("<.table>")) {
                bl = false;
                continue;
            }
            if (!string2.startsWith("<:tr.>")) continue;
            string3 = this.parseTableRow(string2.substring(6));
        }
        this.xmlWr.writeElementEnd("table:table");
        return string3;
    }

    private String parseTableRow(String string) throws IOException {
        String string2;
        String string3 = null;
        this.xmlWr.writeElement("table:table-row");
        this.xmlWr.writeAttribute("table:style-name", "Table1.A");
        boolean bl = true;
        while (bl && (string2 = this.sLineNext != null ? this.sLineNext : this.rZmL.readLine()) != null) {
            int n;
            this.sLineNext = null;
            if (this.isEmptyLine(string2 = string2.trim(), 0)) continue;
            if (string2.startsWith("<.table>") || string2.startsWith("<:tr.>")) {
                bl = false;
                this.sLineNext = string2;
                continue;
            }
            if (!string2.startsWith("<:td")) continue;
            this.xmlWr.writeElement("table:table-cell");
            this.xmlWr.writeAttribute("table:style-name", "Table1.A1");
            this.xmlWr.writeAttribute("office:value-type", "string");
            int n2 = string2.indexOf(".>");
            int n3 = n2 + 2;
            if (n2 < 0) {
                n2 = string2.indexOf(".>");
                n3 = n2 + 1;
            }
            if (n2 < 0) {
                return "ERROR missing > in <:td...";
            }
            int n4 = string2.indexOf(":spanned=");
            if (n4 >= 0) {
                String string4 = string2.substring(n4 + 9, n2).trim();
                this.xmlWr.writeAttribute("table:number-columns-spanned", string4);
            }
            if ((n = string2.indexOf("<:p:")) > 0) {
                this.parseWriteParagrStyleLabel(string2.substring(n));
            } else {
                this.parseWriteParagr(string2.substring(n3), null);
            }
            this.xmlWr.writeElementEnd("table:table-cell");
        }
        this.xmlWr.writeElementEnd("table:table-row");
        return string3;
    }

    private String parseImage(String string, boolean bl) throws IOException {
        String string2;
        int n;
        int n2;
        File file;
        int n3;
        int n4;
        int n5;
        int n6;
        if (string.contains("exmpTrueFalseComplex_ifFB.png")) {
            Debugutil.stop();
        }
        String string3 = null;
        String string4 = this.args.bReadAdoc ? "," : "::";
        int n7 = string4.length();
        int n8 = n6 = this.args.bReadAdoc ? string.indexOf(91) : string.indexOf(string4);
        if (this.args.bReadAdoc) {
            if (n6 < 0) {
                return "image:: without []";
            }
            n5 = string.charAt(n6 + 1) == ']' ? 0 : n6 + 1;
        } else {
            if (n6 < 0) {
                n6 = string.length();
                string.indexOf(62);
                n5 = 0;
            } else {
                n5 = n6 + n7;
            }
            if (n6 < 0) {
                return "ERROR <image:... without >";
            }
        }
        int n9 = this.args.bReadAdoc ? 7 : 0;
        String string5 = string.substring(n9, n6).trim();
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = "150";
        String string12 = "150";
        String string13 = null;
        String string14 = null;
        boolean bl2 = false;
        int n10 = 0;
        while (n5 > 0) {
            ++n10;
            n4 = string.indexOf(61, n5);
            if (n4 < 0) {
                n4 = string.length();
            }
            String string15 = string.substring(n5, n4).trim();
            n3 = string.indexOf(string4, n4);
            if (n3 < 0) {
                n3 = string.length();
                n5 = -1;
            } else {
                n5 = n3 + n7;
            }
            String string16 = string.substring(n4 + 1, n3).trim();
            int n11 = string16.indexOf(42);
            if (string15.equals("id")) {
                string6 = string16;
                continue;
            }
            if (string15.equals("size")) {
                if (n11 > 0) {
                    string7 = string16.substring(0, n11).trim();
                    string8 = string16.substring(n11 + 1).trim();
                    continue;
                }
                string7 = string16;
                string8 = null;
                continue;
            }
            if (string15.equals("px")) {
                if (n11 > 0) {
                    string9 = string16.substring(0, n11).trim();
                    string10 = string16.substring(n11 + 1).trim();
                    continue;
                }
                string9 = string10 = string16;
                continue;
            }
            if (string15.equals("DPI")) {
                if (n11 > 0) {
                    string11 = string16.substring(0, n11).trim();
                    string12 = string16.substring(n11 + 1).trim();
                    continue;
                }
                string11 = string12 = string16;
                continue;
            }
            if (string15.equals("width")) {
                string7 = string16;
                continue;
            }
            if (string15.equals("height")) {
                string8 = string16;
                continue;
            }
            if (string15.equals("title")) {
                string13 = this.replaceBackslasSubscription(string16, null, false, false).toString();
                continue;
            }
            if (string15.equals("float")) {
                string14 = "ImageFloat" + string16;
                bl2 = true;
                continue;
            }
            if (string15.equals("style")) {
                string14 = string16;
                continue;
            }
            if (n10 == 1) {
                string13 = string15;
                continue;
            }
            if (string15.equals("anchor") || string15.equals("sRelX") || string15.equals("sRelY")) continue;
            Debugutil.stop();
        }
        if (string13 != null && string13.startsWith(this.cfg.sImgCaptionStart) && (n4 = string13.indexOf(this.cfg.sImgCaption2)) > 0) {
            if (this.nrFrameImgName == -1) {
                int n12;
                for (n12 = n4 - 1; n12 >= 0; --n12) {
                    char c = string13.charAt(n12);
                    n3 = c;
                    if (c < '0' || n3 > 57) break;
                }
                this.nrFrameImgName = StringFunctions_C.parseIntRadix((CharSequence)string13, (int)(n12 + 1), (int)99, (int)10, null);
            }
            string13 = string13.substring(n4 + this.cfg.sImgCaption2.length());
        }
        if (string14 == null) {
            string14 = "ImageCenter";
        }
        String[] stringArray = new String[1];
        if (this.args.bRenameImageFiles && string13 != null) {
            file = this.checkAndChangeFileImage(stringArray, this.args.fDirOdt, string5, string13);
        } else {
            file = new File(this.args.fDirOdt, string5);
            stringArray[0] = string5;
        }
        string5 = stringArray[0];
        if (string5.startsWith("./")) {
            string5 = "." + string5;
        } else if (string5.startsWith("../")) {
            string5 = "../" + string5;
        } else {
            System.err.println("\nERROR img absolute: " + string5);
        }
        int[] nArray = new int[1];
        float f = 0.0f;
        float f2 = 0.0f;
        String string17 = null;
        if (string7 != null) {
            f = StringFunctions_C.parseFloat((CharSequence)string7, (int)0, (int)99, (int[])nArray);
            string17 = string7.substring(nArray[0]);
        }
        if (string8 != null) {
            f2 = StringFunctions_C.parseFloat(string8, (int)0, (int)99, (int[])nArray);
            string17 = string8.substring(nArray[0]);
        }
        if (string17 == null) {
            string17 = "in";
        }
        float f3 = 1.0f;
        if (string17.equals("cm")) {
            f3 = 2.54f;
        } else if (string17.equals("mm")) {
            f3 = 25.4f;
        } else if (string17.equals("pt")) {
            f3 = 72.0f;
        } else if (string17.equals("in")) {
            f3 = 1.0f;
        } else if (string17.equals("Pica")) {
            f3 = 6.0f;
        }
        float f4 = 0.25f * f3;
        if (string7 == null || string8 == null) {
            if (string9 == null || string10 == null) {
                if (file.exists()) {
                    BufferedImage bufferedImage = ImageIO.read(file);
                    WritableRaster writableRaster = bufferedImage.getRaster();
                    string9 = "" + writableRaster.getWidth();
                    string10 = "" + writableRaster.getHeight();
                } else {
                    System.out.printf("\nImage not found: %s", file.getAbsolutePath());
                    string9 = "1024";
                    string10 = "768";
                }
            }
            float f5 = StringFunctions_C.parseIntRadix((CharSequence)string9, (int)0, (int)99, (int)10, null);
            float f6 = StringFunctions_C.parseIntRadix((CharSequence)string10, (int)0, (int)99, (int)10, null);
            n2 = StringFunctions_C.parseIntRadix((CharSequence)string11, (int)0, (int)99, (int)10, null);
            n = StringFunctions_C.parseIntRadix((CharSequence)string12, (int)0, (int)99, (int)10, null);
            if (f > 0.0f) {
                f2 = f * f6 / f5;
            } else {
                f = f5 / (float)n2;
                f2 = f6 / (float)n;
            }
        }
        if (f > 7.1f * f3) {
            f2 = 7.1f * f3 / f * f2;
            f = 7.1f * f3;
            string7 = null;
            string8 = null;
        }
        if (string7 == null) {
            string7 = String.format(Locale.ENGLISH, "%2.2f%s", Float.valueOf(f), string17);
        }
        if (string8 == null) {
            string8 = String.format(Locale.ENGLISH, "%2.2f%s", Float.valueOf(f2), string17);
        }
        String string18 = String.format(Locale.ENGLISH, "%2.2f%s", Float.valueOf(f2 + f4), string17);
        this.bColumnBreakBefore = false;
        this.bPageBreakBefore = false;
        String string19 = "paragraph";
        if (bl) {
            assert (this.sStyleParagr != null);
            String string20 = "ImgCaption" + this.sStyleParagr;
            this.xmlWr.writeAttribute("text:style-name", string20);
            this.sStyleParagr = null;
        }
        this.xmlWr.writeElement("draw:frame");
        this.xmlWr.writeAttribute("draw:name", "Image" + this.nrFrameImgName);
        this.xmlWr.writeAttribute("draw:style-name", string14);
        this.xmlWr.writeAttribute("text:anchor-type", string19);
        this.xmlWr.writeAttribute("svg:width", string7);
        this.xmlWr.writeAttribute("svg:height", string8);
        this.xmlWr.writeElement("draw:image");
        this.xmlWr.writeAttribute("xlink:href", string5);
        this.xmlWr.writeAttribute("xlink:type", "simple");
        this.xmlWr.writeAttribute("xlink:show", "embed");
        this.xmlWr.writeAttribute("xlink:actuate", "onLoad");
        this.xmlWr.writeAttribute("draw:mime-type", "image/png");
        this.xmlWr.writeElementEnd("draw:image");
        this.xmlWr.writeElementEnd("draw:frame");
        this.bParagrFirstline = true;
        if (!bl2) {
            Debugutil.stop();
        }
        if (string6 == null) {
            n2 = string5.lastIndexOf(47) + 1;
            n = string5.lastIndexOf(47, n2 - 2) + 1;
            int n13 = string5.lastIndexOf(46);
            string2 = n > 0 && string5.charAt(n) != '.' ? "__Img_" + string5.substring(n, n2 - 1) + "_" + string5.substring(n2, n13) : "__Img_" + string5.substring(n2, n13);
        } else {
            string2 = string6.startsWith("__Img") ? string6 : "__Img_" + string6;
        }
        String string21 = string2;
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append(this.cfg.sImgCaptionStart);
            if (this.cfg.eImgKindNr == 1) {
                stringBuilder.append(this.nrFrameImgName);
            }
            stringBuilder.append(this.cfg.sImgCaption2);
            if (string13 != null) {
                stringBuilder.append(string13);
            }
            this.xmlWr.writeElementInline("text:bookmark-start");
            this.xmlWr.writeAttribute("text:name", string2);
            this.xmlWr.writeElementEnd("text:bookmark-start");
            this.xmlWr.writeText((CharSequence)stringBuilder, false);
            this.xmlWr.writeElementInline("text:bookmark-end");
            this.xmlWr.writeAttribute("text:name", string2);
            this.xmlWr.writeElementEnd("text:bookmark-end");
        }
        ++this.nrFrameImgName;
        this.wrRep("  " + string2 + ": " + string13);
        return string3;
    }

    private File checkAndChangeFileImage(String[] stringArray, File file, String string, String string2) {
        int n;
        stringArray[0] = string;
        File file2 = new File(file, string);
        if (string2 == null) {
            return file2;
        }
        int n2 = string.lastIndexOf(47) + 1;
        int n3 = string.lastIndexOf(46);
        int n4 = StringFunctions.indexOfAnyChar((CharSequence)string2, (int)0, (int)-1, (CharSequence)": ;&");
        if (n4 < 0) {
            n4 = string2.length();
        }
        if ((n = string2.lastIndexOf(46, n4)) > 0 && n4 > n + 1 && string.substring(n3).equals(string2.substring(n, n4))) {
            String string3 = string2.substring(0, n4);
            String string4 = string.substring(0, n2) + string3;
            File file3 = new File(file, string4);
            if (file3.exists()) {
                stringArray[0] = string4;
                return file3;
            }
            if (file2.exists() && file2.renameTo(file3)) {
                stringArray[0] = string4;
                return file3;
            }
        }
        return file2;
    }

    static {
        char[] cArray = new char[sTextReplace.length];
        int n = -1;
        String[][] stringArray = sTextReplace;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String[] stringArray2 = stringArray[i];
            cArray[++n] = stringArray2[0].charAt(0);
        }
        sTextReplaceChars = new String(cArray);
        sTextReplaceAsciidoc = new String[][]{{" ", "\u0000", "{sp}"}, {"'", "\\0", "{apos}"}, {"\"", "\\0", "{quot}"}, {"\u00b0", "\\0", "{deg}"}, {"+", "\\0", "{plus}"}, {"|", "\\0", "{vbar}"}};
        sCheckTextReplZmL = new String[sTextReplace.length];
        int n3 = -1;
        for (String[] stringArray3 : sTextReplace) {
            WriteOdt.sCheckTextReplZmL[++n3] = stringArray3[1];
        }
        sTextCtrlCommon = new String[][]{{"<:i:", ".>", "__", "__", "modif_i"}, {"<:b:", ".>", "**", "**", "modif_b"}, {"<:ib:", ".>", "__**", "**__", "modif_ib"}, {"<:I:", ".>", "[I]`", "`", "Citation"}, {"<:Q:", ".>", "[Q]`", "`", "Citation"}, {"<:E:", ".>", "[E]`", "`", "Emphasis"}, {"<:S:", ".>", "[S]`", "`", "Strong_20_Emphasis"}, {"<:2:", ".>", "[?]`", "`", "Superscript"}, {"<:1:", ".>", "[=]`", "`", "Subscript"}, {"<:c:", ".>", "`", "`", "ccode"}, {"<:@ref:", ".>", "<<#", ">>", "!llink"}, {"<:#", ".>", "<<#", ">>", "!llink"}, {"<:@link:", ".>", "link:", "]", "!glink"}, {"<:@image:", ".>", "image::", "]", "!image"}, {"\u0000", "\u0000", "pass:[", "]", "!pass"}, {"\u0000", "\u0000", "+", "+", "!pass+"}, {"<:@page:", ".>", "PDF@", "99", "!plink"}, {"<:@page", ".>", "PDF@", "99", "!plink"}, {"<:", ".>", "[", "`", "!Tstyle"}, {"  ", "", "  ", "", "!spaces"}};
        sTextCtrlCommonSearchMu = new String[sTextCtrlCommon.length];
        n3 = -1;
        for (String[] stringArray4 : sTextCtrlCommon) {
            WriteOdt.sTextCtrlCommonSearchMu[++n3] = stringArray4[0];
        }
        sTextCtrlCommonSearchAsciidoc = new String[sTextCtrlCommon.length];
        n3 = -1;
        for (String[] stringArray5 : sTextCtrlCommon) {
            WriteOdt.sTextCtrlCommonSearchAsciidoc[++n3] = stringArray5[2];
        }
        sWwwLink = new String[]{"www.", "http:", "https:"};
    }

    private static class Cfg {
        boolean useItalicBold;
        String sImgCaptionStart = "Figure ";
        String sImgCaption2 = ": ";
        int eImgKindNr = 1;

        private Cfg() {
        }
    }

    public static class CmdArgs
    extends TranslateOdtCommon.CommonArgs {
        File dirDbg;
        File fOdtStyles;
        boolean bReadAdoc;
        File fCfg;
        File fDirOdt;
        File fOutOdt;
        File fOutXml;
        String swwwRoot = "XXX";
        File dirCreateCfgJavaData;
        File fWriteXmlStruct;
        List<DirPrepareJavadoc> listDirJavadoc;
        File fRptClassesJavadoc;
        float pixelPerPageWidth = 1024.0f;
        boolean bRenameImageFiles = false;
        boolean bWriteExternRefs = false;
        Arguments.Argument[] argList1 = new Arguments.Argument[]{new Arguments.Argument("-cfg", ":path/file.cfg a plain text file with config entries", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                fCfg = new File(string).getAbsoluteFile();
                return fCfg.exists();
            }
        }), new Arguments.Argument("-i", ":path/file.ZmL markup file for input", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                String string2;
                int n = string.indexOf(42);
                int n2 = string.lastIndexOf(92) + 1;
                int n3 = string.lastIndexOf(47) + 1;
                if (n3 > n2) {
                    n2 = n3;
                }
                int n4 = string.lastIndexOf(46);
                if (n < 0 && (string2 = FileFunctions.getCanonicalPath((File)new File(string))).startsWith(sCurrDir)) {
                    n4 = string2.lastIndexOf(46);
                    sNameDoc = string2.substring(sCurrDir.length() + 1, n4);
                    sExtZmL = string2.substring(n4);
                    dirZml = dirIn = new File(sCurrDir);
                } else {
                    sNameDoc = n == n2 ? sNameDoc : string.substring(n2, n4);
                    dirZml = dirIn = new File(n2 == 0 ? "." : string.substring(0, n2)).getAbsoluteFile();
                    sExtZmL = string.substring(n4);
                }
                fIn = new File(dirIn, sNameDoc + sExtZmL).getAbsoluteFile();
                return fIn.exists();
            }
        }), new Arguments.Argument("-a", ":<path/file.adoc>  pure asciidoc file for input", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                fIn = new File(string).getAbsoluteFile();
                dirIn = fIn.getParentFile();
                bReadAdoc = true;
                return fIn.exists();
            }
        }), new Arguments.Argument("-oxml", ":path/to/contentXY.xml used content.xml temporary\n      default is <dirDbg>/content.xml or beside the odg file", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                TranslateOdtCommon.CommonArgs.DirName dirName = this.getDirNameReplaceSrcCmpn(string);
                File file = dirName.dir;
                FileFunctions.mkDir((File)file);
                fOutXml = new File(file, dirName.name).getAbsoluteFile();
                return true;
            }
        }), new Arguments.Argument("-odtStyles", ":Styles.odt used with styles instead given odt", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                fOdtStyles = new File(string).getAbsoluteFile();
                return fOdtStyles.exists();
            }
        }), new Arguments.Argument("-odt", ":<path/ODT>  file.odt for odt output", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                TranslateOdtCommon.CommonArgs.DirName dirName = this.getDirNameReplaceSrcCmpn(string);
                int n = dirName.name.indexOf(46);
                int n2 = string.indexOf(42);
                if (n2 < 0) {
                    sNameDoc = dirName.name.substring(0, n);
                }
                sExtOut = dirName.name.substring(n);
                fDirOdt = dirName.dir.getAbsoluteFile();
                fOutOdt = new File(fDirOdt, dirName.name).getAbsoluteFile();
                return fDirOdt.exists();
            }
        }), new Arguments.Argument("-www", ":<wwwRoot>>  root for www access to replace operation link anchors", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                swwwRoot = string;
                return true;
            }
        }), new Arguments.Argument("-genJavaData", ":<path>  Generates new versions of Java data in pkg path from -analyzeXmlStruct or from given XmlCfg", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws IOException {
                File file = new File(string).getAbsoluteFile();
                if (!file.exists() || !file.isDirectory()) {
                    return this.errMsg("-genJavaData:%s ERROR not found as directory", new Object[]{file});
                }
                dirCreateCfgJavaData = file;
                return true;
            }
        }), new Arguments.Argument("-extRefs", " write external references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                bWriteExternRefs = true;
                return true;
            }
        }), new Arguments.Argument("-analyzeXmlStruct", ":D:/path/to/xmlCfg.txt optional, first analyze the input xml data and generate a new XmlCfg text file", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                fWriteXmlStruct = new File(string);
                File file = fWriteXmlStruct.getParentFile();
                FileFunctions.mkDir((File)file);
                return file.exists();
            }
        }), new Arguments.Argument("-javadoc", ":../path/to/Javadoc:org/vishia/odg:@https://wwwlink analyze this directory tree, more as one possible", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                String string2;
                File file;
                String string3;
                int n = string.indexOf(":@");
                if (n > 0) {
                    string3 = string.substring(n + 2);
                } else {
                    n = string.length();
                    string3 = null;
                }
                int n2 = string.indexOf(58, 2);
                if (n2 >= 0 && n2 < n) {
                    file = new File(string.substring(0, n2));
                    if (!file.exists()) {
                        return false;
                    }
                    string2 = string.substring(n2 + 1, n);
                    if (!file.exists()) {
                        return false;
                    }
                } else {
                    file = new File(string.substring(0, n));
                    if (!file.exists()) {
                        return false;
                    }
                    string2 = null;
                }
                DirPrepareJavadoc dirPrepareJavadoc = new DirPrepareJavadoc();
                dirPrepareJavadoc.dirBase = file;
                dirPrepareJavadoc.sLocal = string2;
                dirPrepareJavadoc.swww = string3;
                if (listDirJavadoc == null) {
                    listDirJavadoc = new LinkedList<DirPrepareJavadoc>();
                }
                listDirJavadoc.add(dirPrepareJavadoc);
                return true;
            }
        }), new Arguments.Argument("-reportJavadocClasses", ":path/to/reportJavaDocClasses.txt", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                TranslateOdtCommon.CommonArgs.DirName dirName = this.getDirNameReplaceSrcCmpn(string);
                fRptClassesJavadoc = new File(dirName.dir, dirName.name);
                FileFunctions.mkDir((File)dirName.dir);
                return dirName.dir.exists();
            }
        })};

        CmdArgs() {
            this.aboutInfo = "...Reader content from odg for FunctionBlockGrafic";
            this.helpInfo = "obligate args: -o:... ...input";
            for (Arguments.Argument argument : this.argListCommon) {
                this.addArg(argument);
            }
            for (Arguments.Argument argument : this.argList1) {
                this.addArg(argument);
            }
        }

        public boolean testConsistence(Appendable appendable) {
            boolean bl = true;
            if (this.fOutXml == null) {
                File file = this.dirDbg != null ? this.dirDbg : this.fIn.getParentFile();
                this.fOutXml = new File(file, "content.xml");
            }
            try {
                if (!this.fOutOdt.exists() && !this.fOdtStyles.exists()) {
                    appendable.append("either -odtStyles:path/file.odt or -odt:file.odt should be existing");
                    return false;
                }
            }
            catch (IOException iOException) {
                System.err.println("Fatal Error, msg as Appendable has IOException " + iOException.getMessage());
            }
            if (!bl) {
                super.showHelp(appendable);
            }
            return bl;
        }
    }

    public static class DirPrepareJavadoc {
        public File dirBase;
        public String sLocal;
        String swww;
    }
}

