/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.odt.readOdt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.odt.readOdt.GetJavadocLabel;
import org.vishia.util.Arguments;
import org.vishia.util.FileFunctions;
import org.vishia.util.StringFunctions;

abstract class TranslateOdtCommon {
    public final LogMessage log;
    final GetJavadocLabel javadocLabel;

    protected TranslateOdtCommon(LogMessage logMessage) {
        this.log = logMessage;
        this.javadocLabel = new GetJavadocLabel(logMessage);
    }

    protected String searchForReplacingLinkOperationLabel(String string, String string2, File file) {
        String string3;
        Map<String, String> map = this.javadocLabel.idxHtmlFilesAnchors.get(string);
        try {
            if (map == null) {
                File file2 = new File(file, string);
                if (file2.exists()) {
                    map = this.javadocLabel.createHtmlAnchorOperations(string, file);
                } else {
                    this.log.writeError("Warning: file for searchForReplacingLinkOperationLabel in html files not found: '%s' ", new Object[]{file2.getAbsolutePath()});
                }
            }
        }
        catch (IOException iOException) {
            this.log.writeError("ERROR read html file '%s'", new Object[]{string});
        }
        if (map != null) {
            int n = StringFunctions.indexAfterIdentifier((CharSequence)string2, (int)0, (int)-1, null);
            String string4 = StringFunctions.equals((CharSequence)string2, (int)n, (int)(n + 2), (CharSequence)"()") ? string2.substring(0, n + 2) : string2.substring(0, n);
            String string5 = map.get(string4);
            if (string5 == null) {
                this.log.writeError("Warning: operation '%s' not found in: '%s' ", new Object[]{string4, string});
                string3 = string2;
            } else if (string5.endsWith("?")) {
                this.log.writeError("Warning: operation '%s' is not unique in: '%s' ", new Object[]{string4, string});
                string3 = string2;
            } else {
                string3 = string5;
            }
        } else {
            string3 = string2;
        }
        return string3;
    }

    public String getLinkNameFromURL(String string) {
        int n = string.indexOf(35);
        if (n < 0) {
            n = string.length();
        }
        int n2 = string.lastIndexOf(47) + 1;
        int n3 = string.lastIndexOf(46);
        if (n3 < n2) {
            n3 = n;
        }
        return string.substring(n2, n3);
    }

    public String getLinkFileFromURL(String string) {
        int n = string.indexOf(35);
        if (n < 0) {
            n = string.length();
        }
        int n2 = string.lastIndexOf(47) + 1;
        return string.substring(n2, n);
    }

    protected void writeBackupFile(File file, File file2, String string, CommonArgs commonArgs) {
        if (file.exists() && file2 != null) {
            File file3;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            String string3 = string != null ? string : string2.substring(n);
            string2 = string2.substring(0, n);
            if (FileFunctions.getCanonicalPath((File)file2).equals(FileFunctions.getCanonicalPath((File)file.getParentFile()))) {
                string2 = string2 + ".back";
            }
            boolean bl = true;
            if (commonArgs.bBackAll && (file3 = new File(file2, string2 + string3)).exists()) {
                String string4;
                File file4;
                int n2 = 0;
                while ((file4 = new File(file2, string4 = string2 + "." + ++n2 + string3)).exists()) {
                }
                bl = file3.renameTo(file4);
                if (bl) {
                    this.log.writef("\nsuccessfull backall: %s", new Object[]{file4.getAbsolutePath()});
                } else {
                    this.log.writef("\nERROR backall: %s", new Object[]{file4.getAbsolutePath()});
                }
            }
            file3 = new File(file2, string2 + string3);
            try {
                FileFunctions.copyFile((File)file, (File)file3);
                this.log.writef("\nsuccessfull back: %s", new Object[]{file3.getAbsolutePath()});
            }
            catch (IOException iOException) {
                this.log.writef("\nERROR back: %s : %s", new Object[]{file3.getAbsolutePath(), iOException.getMessage()});
            }
        }
    }

    protected static abstract class CommonArgs
    extends Arguments {
        String sCurrDir;
        File dirIn;
        File fIn;
        File fReport;
        OutputStream fLog;
        protected String sDirSrcCmpn;
        String sNameDoc;
        String sExtOut;
        File dirZml;
        String sExtZmL;
        File dirOutBack;
        boolean bBackAll;
        public File dirLabel;
        public String sNameLabel;
        String sRefBesideHtml;
        String sRefBesidePdf;
        String sExtRefBesideHtml = ".html";
        String sExtRefBesidePdf = ".pdf";
        String sRefBesideInWWWHtml;
        String sRefBesideInWWWPdf;
        File dirDbg;
        Arguments.Argument[] argListCommon = new Arguments.Argument[]{new Arguments.Argument("-dirDbg", ":dirWrTest    directory for debug output", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                dirDbg = this.getDirRepaceSrcCmpn(string);
                FileFunctions.mkDir((File)dirDbg);
                return dirDbg.exists();
            }
        }), new Arguments.Argument("-dirCmpn", ":../.. directory from current for the src/Component replacing ++ in odt:++NAME", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                File file = new File(string);
                boolean bl = file.exists();
                if (bl) {
                    String string2 = FileFunctions.normalizePath((File)file).toString();
                    int n = string2.lastIndexOf(47);
                    sDirSrcCmpn = string2.substring(n + 1);
                }
                return bl;
            }
        }), new Arguments.Argument("-labels", ":path/*.label.txt  file contains labels", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                int n = string.lastIndexOf(47);
                dirLabel = n < 0 ? dirZml : this.getDirRepaceSrcCmpn(string.substring(0, n));
                sNameLabel = string.substring(n + 1);
                return dirLabel.exists();
            }
        }), new Arguments.Argument("-report", ":path/default++/file.txt  file for report", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                DirName dirName = this.getDirNameReplaceSrcCmpn(string);
                fReport = new File(dirName.dir, dirName.name);
                FileFunctions.mkDir((File)fReport.getParentFile());
                return fReport.getParentFile().exists();
            }
        }), new Arguments.Argument("-log", ":path/default++/file.log  file for report", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                DirName dirName = this.getDirNameReplaceSrcCmpn(string);
                File file = new File(dirName.dir, dirName.name);
                FileFunctions.mkDir((File)file.getParentFile());
                fLog = new FileOutputStream(file);
                return fLog != null;
            }
        }), new Arguments.Argument("-back", ":path/to  dir for backup vml files", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                dirOutBack = this.getDirRepaceSrcCmpn(string);
                bBackAll = false;
                FileFunctions.mkDir((File)dirOutBack);
                return dirOutBack.exists();
            }
        }), new Arguments.Argument("-relhtml", ":../html/*.html relative path for extern beside bookmark references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                if (string.equals("?")) {
                    sRefBesideHtml = null;
                } else {
                    int n = string.indexOf(42);
                    if (n < 0) {
                        sRefBesideHtml = string.endsWith("/") ? string : string + "/";
                    } else {
                        sRefBesideHtml = string.substring(0, n);
                        sExtRefBesideHtml = string.substring(n + 1);
                    }
                }
                return true;
            }
        }), new Arguments.Argument("-relpdf", ":../pdf/*.pdf relative path for extern beside bookmark references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                if (string.equals("?")) {
                    sRefBesidePdf = null;
                } else {
                    int n = string.indexOf(42);
                    if (n < 0) {
                        sRefBesidePdf = string.endsWith("/") ? string : string + "/";
                    } else {
                        sRefBesidePdf = string.substring(0, n);
                        sExtRefBesidePdf = string.substring(n + 1);
                    }
                }
                return true;
            }
        }), new Arguments.Argument("-arelhtml", ":D:/path/*.html OR https://www.xyz.org/path/*.html path for extern beside bookmark references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                int n = string.indexOf(42);
                if (n < 0) {
                    sRefBesideHtml = string.endsWith("/") ? string : string + "/";
                } else {
                    sRefBesideHtml = string.substring(0, n);
                    sExtRefBesideHtml = string.substring(n + 1);
                }
                return true;
            }
        }), new Arguments.Argument("-arelpdf", ":D:/path/*.pdf OR https://www.xyz.org/path/[*.pdf] path for extern beside bookmark references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                int n = string.indexOf(42);
                if (n < 0) {
                    sRefBesidePdf = string.endsWith("/") ? string : string + "/";
                } else {
                    sRefBesidePdf = string.substring(0, n);
                    sExtRefBesidePdf = string.substring(n + 1);
                }
                return true;
            }
        }), new Arguments.Argument("-wrelhtml", "https://www.xyz.org/path/*.pdf path for extern beside bookmark references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                if (string.equals("?")) {
                    sRefBesideInWWWHtml = null;
                } else {
                    int n = string.indexOf(42);
                    if (n < 0) {
                        sRefBesideInWWWHtml = string.endsWith("/") ? string : string + "/";
                    } else {
                        sRefBesideInWWWHtml = string.substring(0, n);
                        sExtRefBesideHtml = string.substring(n + 1);
                    }
                }
                return true;
            }
        }), new Arguments.Argument("-wrelpdf", "https://www.xyz.org/path/*.pdf path for extern beside bookmark references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                if (string.equals("?")) {
                    sRefBesideInWWWPdf = null;
                } else {
                    int n = string.indexOf(42);
                    if (n < 0) {
                        sRefBesideInWWWPdf = string.endsWith("/") ? string : string + "/";
                    } else {
                        sRefBesideInWWWPdf = string.substring(0, n);
                        sExtRefBesidePdf = string.substring(n + 1);
                    }
                }
                return true;
            }
        }), new Arguments.Argument("-alinkhtml", ":D:/path/*.html OR https://www.xyz.org/path/*.html deprecated: path for extern bookmark references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                int n = string.indexOf(42);
                if (n < 0) {
                    sRefBesideHtml = string.endsWith("/") ? string : string + "/";
                } else {
                    sRefBesideHtml = string.substring(0, n);
                    sExtRefBesideHtml = string.substring(n + 1);
                }
                return true;
            }
        }), new Arguments.Argument("-alinkpdf", ":D:/path/*.pdf OR https://www.xyz.org/path/[*.pdf] deprecated: path for extern bookmark references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                int n = string.indexOf(42);
                if (n < 0) {
                    sRefBesidePdf = string.endsWith("/") ? string : string + "/";
                } else {
                    sRefBesidePdf = string.substring(0, n);
                    sExtRefBesidePdf = string.substring(n + 1);
                }
                return true;
            }
        }), new Arguments.Argument("-rlinkhtml", ":../html/*.html OR https://www.xyz.org/path/*.html path for foreign bookmark references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                int n = string.indexOf(42);
                if (n < 0) {
                    sRefBesideHtml = string.endsWith("/") ? "../" + string : "../" + string + "/";
                } else {
                    sRefBesideHtml = "../" + string.substring(0, n);
                    sExtRefBesideHtml = string.substring(n + 1);
                }
                return true;
            }
        }), new Arguments.Argument("-rlinkpdf", ":../pdf/*.pdf OR https://www.xyz.org/path/*.pdf path for foreign bookmark references", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                int n = string.indexOf(42);
                if (n < 0) {
                    sRefBesidePdf = string.endsWith("/") ? "../" + string : "../" + string + "/";
                } else {
                    sRefBesidePdf = "../" + string.substring(0, n);
                    sExtRefBesidePdf = string.substring(n + 1);
                }
                return true;
            }
        })};

        protected CommonArgs() {
        }

        public void setCurrDir() {
            String string = System.getProperty("user.dir");
            this.sCurrDir = string = FileFunctions.getCanonicalPath((File)new File(string));
        }

        protected DirName getDirNameReplaceSrcCmpn(String string) {
            DirName dirName = new DirName();
            int n = string.lastIndexOf(47);
            int n2 = string.indexOf("*");
            int n3 = string.indexOf("++*");
            if (n3 >= 0) {
                n2 = n3;
            }
            if (n2 >= 0) {
                if (n != n2 - 1) {
                    throw new IllegalArgumentException("Wildcard can only be used replacing the name as 'path/to/*.ext', found: '" + string + "'");
                }
                dirName.name = n3 > 0 ? this.sDirSrcCmpn + "++" + this.sNameDoc + string.substring(n3 + 3) : this.sNameDoc + string.substring(n2 + 1);
            } else {
                dirName.name = string.substring(n + 1);
            }
            dirName.dir = this.getDirRepaceSrcCmpn(string.substring(0, n));
            return dirName;
        }

        protected File getDirRepaceSrcCmpn(String string) {
            String string2;
            int n = string.indexOf("++");
            if (n > 0) {
                if (this.sDirSrcCmpn == null) {
                    string2 = string.substring(0, n) + string.substring(n + 2);
                } else {
                    int n2 = string.lastIndexOf("/", n);
                    string2 = string.substring(0, n2 + 1) + this.sDirSrcCmpn + string.substring(n + 2);
                }
            } else {
                string2 = string;
            }
            return new File(string2);
        }

        protected static class DirName {
            File dir;
            String name;

            protected DirName() {
            }
        }
    }
}

