/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.libOffc.styles;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedList;
import java.util.List;
import org.vishia.genJavaOutClass.GenJavaOutClass;
import org.vishia.libOffc.styles.RdWrStyle2Text_LOffc;
import org.vishia.libOffc.styles.XmlDataLOffcStyles_Zbnf;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.util.Arguments;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.xmlReader.GenXmlCfgJavaData;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlDataNode;
import org.vishia.xmlReader.XmlJzCfgAnalyzer;
import org.vishia.xmlReader.XmlJzReader;

public class ReadStyles_Loffc {
    final CmdArgs cmdArgs;
    public final LogMessage log;
    private XmlCfg xmlCfgStyle = new XmlCfg(true);
    RdWrStyle2Text_LOffc rwStyle2Text = new RdWrStyle2Text_LOffc();

    public static void main(String[] stringArray) {
        try {
            int n = ReadStyles_Loffc.smain(stringArray, System.out, System.err);
            System.exit(n);
        }
        catch (Exception exception) {
            System.err.println("Unexpected: " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(255);
        }
    }

    public static int smain(String[] stringArray, Appendable appendable, Appendable appendable2) throws IOException {
        CmdArgs cmdArgs = new CmdArgs();
        if (stringArray.length == 0) {
            cmdArgs.showHelp(appendable);
            return 1;
        }
        if (!cmdArgs.parseArgs(stringArray, appendable2) || !cmdArgs.testConsistence(appendable2)) {
            return 2;
        }
        int n = ReadStyles_Loffc.amain(cmdArgs);
        if (n != 0) {
            System.out.printf(" EXIT-code=%d", n);
        }
        System.out.println();
        return n;
    }

    public static int amain(CmdArgs cmdArgs) throws IOException {
        ReadStyles_Loffc readStyles_Loffc = new ReadStyles_Loffc(cmdArgs);
        int n = readStyles_Loffc.execute();
        readStyles_Loffc.log.close();
        return n;
    }

    protected ReadStyles_Loffc(CmdArgs cmdArgs) {
        this.log = new LogMessageStream((OutputStream)cmdArgs.fLog, null, (Appendable)System.out, (Appendable)System.err, true, Charset.defaultCharset());
        this.cmdArgs = cmdArgs;
    }

    public int execute() throws IOException {
        Object object;
        int n = 0;
        if (this.cmdArgs.fWriteXmlConfigText != null) {
            object = new XmlJzCfgAnalyzer();
            object.setDirDebug(this.cmdArgs.dirDbg);
            try {
                XmlCfg xmlCfg = object.analyzeXmlFile(this.cmdArgs.listfIn);
                xmlCfg.writeToText(this.cmdArgs.fWriteXmlConfigText, this.log);
            }
            catch (Exception exception) {
                this.log.writeError("Exception analyzeXmlStruct", (Throwable)exception);
            }
        } else if (this.cmdArgs.dirCreateCfgJavaData != null) {
            this.writeJavaClasses();
        }
        if (this.cmdArgs.listfIn != null && this.cmdArgs.fXmlConfigTxt != null) {
            object = new XmlDataLOffcStyles_Zbnf();
            this.xmlCfgStyle = new XmlCfg(true);
            this.xmlCfgStyle.readCfgFile(this.cmdArgs.fXmlConfigTxt, this.log);
            for (FileFunctions.FilePathnameExt filePathnameExt : this.cmdArgs.listfIn) {
                String string = this.readXml(object, filePathnameExt.file);
                if (string != null) {
                    this.log.writeError("\nERROR reading xml file %s: %s", new Object[]{filePathnameExt.file.getPath(), string});
                    n = 4;
                    continue;
                }
                String string2 = filePathnameExt.file.getName();
                int n2 = string2.lastIndexOf(46);
                if (n2 < 0) {
                    n2 = string2.length();
                }
                String string3 = this.cmdArgs.outStyleText.sExt != null ? this.cmdArgs.outStyleText.sNamePath + string2.substring(0, n2) + this.cmdArgs.outStyleText.sExt : (this.cmdArgs.outStyleText.sNamePath.length() == 0 ? string2.substring(0, n2) + ".style.txt" : this.cmdArgs.outStyleText.sNamePath);
                File file = new File(this.cmdArgs.outStyleText.file, string3);
                this.rwStyle2Text.writeStyleDetToText((XmlDataLOffcStyles_Zbnf)object, file);
                Debugutil.stop();
            }
        }
        this.log.close();
        return n;
    }

    private void writeJavaClasses() throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        GenJavaOutClass.CmdArgs cmdArgs = new GenJavaOutClass.CmdArgs();
        cmdArgs.dirJava = this.cmdArgs.dirCreateCfgJavaData;
        cmdArgs.sJavaClass = "XmlDataLOffcStyles";
        cmdArgs.sJavaPkg = "org.vishia.libOffc.styles";
        GenXmlCfgJavaData genXmlCfgJavaData = new GenXmlCfgJavaData(cmdArgs, this.log);
        if (this.cmdArgs.fXmlConfigTxt == null) {
            throw new IllegalArgumentException("-genJavaData:... needs also -xmlCfg:...");
        }
        XmlCfg xmlCfg = new XmlCfg(true);
        xmlCfg.readCfgFile(this.cmdArgs.fXmlConfigTxt, this.log);
        genXmlCfgJavaData.exec(xmlCfg);
    }

    private String readXml(Object object, File file) throws IOException {
        XmlJzReader xmlJzReader = new XmlJzReader();
        xmlJzReader.setNamespaceEntry("xml", "XML");
        xmlJzReader.setCfg(this.xmlCfgStyle);
        String string = file.getName();
        xmlJzReader.openXmlTestOut(new File(this.cmdArgs.dirDbg, string + "-back.xml"));
        String string2 = xmlJzReader.readZipXml(file, "styles.xml", object);
        if (string2 != null) {
            this.log.writef("\nERROR reading xml file %s: %s", new Object[]{string, string2});
        }
        return string2;
    }

    private void writeStyleDetToText(XmlDataNode xmlDataNode) {
        if (xmlDataNode.allNodes.size() != 1) {
            this.log.writef("first level nodes more as one, should contain only 'office:document-styles'", new Object[0]);
        } else {
            XmlDataNode xmlDataNode2 = (XmlDataNode)xmlDataNode.allNodes.get(0);
            if (!xmlDataNode2.tag.equals("office:document-styles")) {
                this.log.writef("first only one sub node should be 'office:document-styles', but is: '%s'", new Object[]{xmlDataNode2.tag});
            } else {
                XmlDataNode xmlDataNode3 = (XmlDataNode)xmlDataNode2.singleNodes.get("office:styles");
                for (XmlDataNode xmlDataNode4 : xmlDataNode3.allNodes) {
                    Debugutil.stopp();
                }
            }
        }
    }

    public static class CmdArgs
    extends Arguments {
        List<FileFunctions.FilePathnameExt> listfIn = new LinkedList<FileFunctions.FilePathnameExt>();
        FileOutputStream fLog;
        File dirDbg;
        File fWriteXmlConfigText;
        File fXmlConfigTxt;
        FileFunctions.FilePathnameExt outStyleText;
        File dirCreateCfgJavaData;
        Arguments.Argument[] argList1 = new Arguments.Argument[]{new Arguments.Argument("-i", ":<path/file.odx>  any LibreOffice file which contains styles.xml for input", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                File file = new File(string);
                listfIn.add(new FileFunctions.FilePathnameExt(file, "styles.xml"));
                return file.exists();
            }
        }), new Arguments.Argument("-analyzeXmlStruct", ":D:/path/to/xmlCfg.txt optional, first analyze the input xml data and generate a new XmlCfg text file", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                fWriteXmlConfigText = new File(string);
                File file = fWriteXmlConfigText.getParentFile();
                FileFunctions.mkDir((File)file);
                return file.exists();
            }
        }), new Arguments.Argument("-xmlCfg", ":D:/path/to/xmlCfg.txt textual given config", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                fXmlConfigTxt = new File(string);
                return fXmlConfigTxt.exists();
            }
        }), new Arguments.Argument("-genJavaData", ":<path>  Generates new versions of Java data in pkg path from -analyzeXmlStruct or from given XmlCfg", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws IOException {
                File file = new File(string).getAbsoluteFile();
                if (!file.exists() || !file.isDirectory()) {
                    return this.errMsg("-genJavaData:%s ERROR not found as directory", new Object[]{file});
                }
                dirCreateCfgJavaData = file;
                return true;
            }
        }), new Arguments.Argument("-oStyle", ":<path>  output of styles in textual form", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws IOException {
                outStyleText = FileFunctions.FilePathnameExt.parseDirWildcardName(null, (String)string);
                FileFunctions.mkDir((File)outStyleText.file);
                return true;
            }
        }), new Arguments.Argument("-dirDebug", ":D:/path/to/xmlCfg.txt in given write debug info", new Arguments.SetArgument(){

            public boolean setArgument(String string) throws FileNotFoundException {
                dirDbg = new File(string);
                FileFunctions.mkDir((File)dirDbg);
                return dirDbg.exists();
            }
        })};

        void test() {
        }

        CmdArgs() {
            this.aboutInfo = "...Reader styles from any LibreOffice file";
            this.helpInfo = "obligate args: -i:path/to/file.od?";
            for (Arguments.Argument argument : this.argList1) {
                this.addArg(argument);
            }
        }

        public boolean testConsistence(Appendable appendable) {
            boolean bl = true;
            if (!bl) {
                super.showHelp(appendable);
            }
            return bl;
        }
    }
}

