/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.libOffc.cfgui;

import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.libOffc.cfgui.XmlDataRegMain;
import org.vishia.libOffc.cfgui.XmlDataRegMain_Zbnf;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlJzReader;

public class ReadRegistryMain {
    Map<String, UnoLabel> idxUnoLabel = new TreeMap<String, UnoLabel>();
    Map<String, Map<String, UnoLabel>> idxCmpnUno = new TreeMap<String, Map<String, UnoLabel>>();

    public void readPrepare(List<FileFunctions.FilePathnameExt> list, LogMessage logMessage) {
        XmlDataRegMain xmlDataRegMain = this.readRegistryMain(list, logMessage);
        this.prepareRegistryNode(xmlDataRegMain);
        Debugutil.stop();
    }

    private XmlDataRegMain readRegistryMain(List<FileFunctions.FilePathnameExt> list, LogMessage logMessage) {
        XmlCfg xmlCfg = new XmlCfg();
        XmlDataRegMain_Zbnf xmlDataRegMain_Zbnf = new XmlDataRegMain_Zbnf();
        try {
            xmlCfg.readFromJar(this.getClass(), "registryMain.xml.cfg", logMessage);
            XmlJzReader xmlJzReader = new XmlJzReader(logMessage);
            xmlJzReader.setCfg(xmlCfg);
            for (FileFunctions.FilePathnameExt filePathnameExt : list) {
                String string = filePathnameExt.file.getName();
                try {
                    logMessage.writef("\nreads XML: %s", new Object[]{filePathnameExt.file.getAbsolutePath()});
                    if (filePathnameExt.sNamePath != null) {
                        xmlJzReader.readZipXml(filePathnameExt.file, filePathnameExt.sNamePath, (Object)xmlDataRegMain_Zbnf);
                        continue;
                    }
                    xmlJzReader.readXml(filePathnameExt.file, (Object)xmlDataRegMain_Zbnf, null);
                }
                catch (Exception exception) {
                    logMessage.writeError("\nEXCEPTION parse : " + string + ": ", (Throwable)exception);
                }
            }
        }
        catch (IOException | IllegalCharsetNameException | UnsupportedCharsetException exception) {
            logMessage.writeError("\nEXCEPTION xmlCfg : ", (Throwable)exception);
        }
        return xmlDataRegMain_Zbnf.dataroot;
    }

    void prepareRegistryNode(XmlDataRegMain xmlDataRegMain) {
        for (XmlDataRegMain.Oor_data oor_data : xmlDataRegMain.oor_data) {
            for (XmlDataRegMain.Oor_component_data oor_component_data : oor_data.get_oor_component_data()) {
                String string = oor_component_data.oor_name;
                Iterable<XmlDataRegMain.Node> iterable = oor_component_data.get_node();
                if (iterable == null) continue;
                for (XmlDataRegMain.Node node : iterable) {
                    this.prepareNode(node, "", string);
                }
            }
            Debugutil.stop();
        }
        Debugutil.stop();
    }

    void prepareNode(XmlDataRegMain.Node node, String string, String string2) {
        if (node.oor_name.startsWith(".uno")) {
            this.prepareNodeUno(node, string, string2);
        }
        if (node.oor_op == null || !node.oor_op.equals("replace")) {
            Debugutil.stop();
        }
        String string3 = string + "/" + node.oor_name;
        if (node.node != null) {
            for (XmlDataRegMain.Node node2 : node.node) {
                this.prepareNode(node2, string3, string2);
            }
        }
    }

    void prepareNodeUno(XmlDataRegMain.Node node, String string, String string2) {
        String string3 = null;
        for (Object object : node.prop) {
            if (!object.oor_name.equals("Label")) continue;
            for (XmlDataRegMain.Value value : object.value) {
                string3 = value.get__textContent();
            }
        }
        if (string3 != null) {
            Object object;
            UnoLabel unoLabel = new UnoLabel(node.oor_name, string3, string2, string);
            this.idxUnoLabel.put(node.oor_name, unoLabel);
            object = string2 + string;
            TreeMap<String, Object> treeMap = this.idxCmpnUno.get(object);
            if (treeMap == null) {
                treeMap = new TreeMap<String, Object>();
                this.idxCmpnUno.put((String)object, treeMap);
            }
            treeMap.put(node.oor_name, unoLabel);
        }
    }

    public static class UnoLabel {
        public final String unoCmd;
        public final String textEn;
        public final String component;
        public final String modules;

        public UnoLabel(String string, String string2, String string3, String string4) {
            this.unoCmd = string;
            this.textEn = string2;
            this.component = string3;
            this.modules = string4;
        }

        public String toString() {
            return this.unoCmd + "=\"" + this.textEn + "\" : " + this.component + ":" + this.modules;
        }
    }
}

