#!/bin/sh
## This file is the shell script to call convert accelerator key settings from cfg to human readable text
echo called: $0 $1 $2 $3 $4
export SCRIPTFILE="$(realpath $0)"          ## The absolute path of this script file from the invocation dir
export SCRIPTDIR="$(dirname $SCRIPTFILE)"   ## The absolute path of this script dir
echo SCRIPTDIR=$SCRIPTDIR
## set the input
if test "$1" != ""; then export INFILES="$(realpath $1)"
else export INFILES="*.cfg"
fi
echo -i:$INFILES
##
if test "$OS" = "Windows_NT"; then ##Windows with shell script capability for example MinGw
  JCPSEP=";"
  JAVA=java
else                          ## real Linux/UNIX
  JCPSEP=":"
  JAVA=java
fi
TOOLSDIR="tools"   ## maybe changed, maybe absolute path to the jar file directory
JCP="$TOOLSDIR/vishiaLOffcTools-2025-12-22.jar${JCPSEP}$TOOLSDIR/vishiaBase-2025-12-31.jar"
echo "$PWD>" java -cp $JCP org.vishia.libOffc.cfgui.WriteKeyAccl --@$SCRIPTFILE:args
$JAVA -cp $JCP org.vishia.libOffc.cfgui.WriteKeyAccl --@$SCRIPTFILE:args
### args ##
### -i:$INFILES
### -LOffcPrg:/opt/libreoffice25.8             ## Libre Office installation here
### -LOffcUser:~/.config/libreoffice/4/user    ## User settings here
### -gTxt:$SCRIPTDIR/KeyAcclText.gTxt          ## output script
### -shfollow            ## sorted shift key variant in order of key names
### -o:*.shift.txt       ## output is INFILES name with given extension
if test "$1" != "NOPAUSE" -a "$2" != "NOPAUSE"; then read -p " ...Press ENTER..." VAR; fi
