package org.vishia.odt.readOdt;

public class StyleOdt {

  public final String name;
  
  /**'\0' or a short character for one-character identification <:E: in VML
   * 
   */
  public final char cShort;
  
  /**If given, then this is the indirect style in libreOffice to use.
   * If not given, the paragraph style determines front size, etc.
   * This style contains necessary direct formatting stuff. 
   */
  public final String parentName;
  
  /**The page break and column break is a property of the paragraph style. 
   * Here only "before" is supported (seams to be sufficient).
   * 
   */
  public final boolean pgBreakBefore;
  
  public final boolean colBreakBefore;
  
  /**style is italic etc. 
   * https://www.data2type.de/xml-xslt-xslfo/xsl-fo/xslfo-referenz/attribute/font-style
   * says for XLS-FO: "italic", "oblique", "backslant", "normal"
   * character i o b n or '\0' for normal
   * based on the paragraph style.
   * <br>
   * This flag is used for character styles (span text). In ASCIIdoc "__xxx__" will be written, 
   * in ZmL it is transferred immediately to <:Q:xxx.> or also to <:E:xxx.> depending from {@link #cWeight}
   * It is then transferred on reading the ZmL to the indirect style 'Quotation' respectively 'Emphasis'.
   * <br>
   * If this flag is found in a paragraph style, the whole paragraph content is written as span with <:Q:....> etc..
   */
  public final char cItalic;
  
  /**weight is bold etc. 
   * https://www.data2type.de/xml-xslt-xslfo/xsl-fo/xslfo-referenz/attribute/font-weight
   * 'b' = "bold" = 700, '"bolder" = 900, "lighter" = 200, "100", ... "900": ' ' = "400" = normal , "700" = bold
   * '\0' for normal.
   * <br>
   * This flag is used for character styles (span text). In ASCIIdoc "**xxx**" will be written, 
   * in ZmL it is transferred immediately to <:S:xxx.> or also to <:E:xxx.> depending from {@link #cItalic}.
   * It is then transferred on reading the ZmL to the indirect style 'Strong Emphasis' respectively 'Emphasis'.
   * <br>
   * If this flag is found in a paragraph style, the whole paragraph content is written as span with <:S:....> etc.
   */
  public final char cWeight;
  
  public final int columns;

  /**Contains 1 for subScript and 2 for superScript
   * 
   */
  public final char cPosition;

  /**
   * @param name
   * @param parentName null if it is a indirect (basic) style
   * @param pgBreakBefore 
   * @param colBreakBefore
   */
  public StyleOdt ( char cShort, String name, String parentName, char italic, char weight, char sub
  , boolean pgBreakBefore, boolean colBreakBefore, int nColumns
  ) {
    this.cShort = cShort;
    this.name = name;
    this.parentName = parentName;
    this.cItalic = italic;
    this.cWeight = weight;
    this.pgBreakBefore = pgBreakBefore;
    this.colBreakBefore = colBreakBefore;
    this.columns = nColumns;
    this.cPosition = sub;
  }
  
  @Override public String toString() { return name; }
  
}
