package org.vishia.odt.generateCfgData;

import java.io.File;
import java.io.IOException;

import org.vishia.util.Arguments;
import org.vishia.xmlReader.GenXmlCfgJavaData;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlJzCfgAnalyzer;
import org.vishia.xmlReader.XmlJzReader;

/**This class helps to (re) generate the appropriate data in org.vishia.odt.xmlData for the xmlcfg and the Java data.
 * It can be started repeatedly with any given odt data, to check whether all is recognized, or add new XML structure data.
 * It is used first to generate this files.
 * <br>
 * <br>Generation is done first in /tmp/genSrc_odg/*, it is to compare with the original files. 
 * In that way new generation has no impact.
 * @author Hartmut Schorrig
 *
 */
public class GenerateCfgData {

  
  /**Version, License and History:
   * <ul>
   * <li>2024-05-08 used for analyze odg, copied from package org.vishia.xmlReader.test
   * <li>2021- created in package org.vishia.xmlReader.test
   * </ul>
   * 
   * <b>Copyright/Copyleft</b>:
   * For this source the LGPL Lesser General Public License,
   * published by the Free Software Foundation is valid.
   * It means:
   * <ol>
   * <li> You can use this source without any restriction for any desired purpose.
   * <li> You can redistribute copies of this source to everybody.
   * <li> Every user of this source, also the user of redistribute copies
   *    with or without payment, must accept this license for further using.
   * <li> But the LPGL is not appropriate for a whole software product,
   *    if this source is only a part of them. It means, the user
   *    must publish this part of source,
   *    but don't need to publish the whole source of the own product.
   * <li> You can study and modify (improve) this source
   *    for own using or for redistribution, but you have to license the
   *    modified sources likewise under this LGPL Lesser General Public License.
   *    You mustn't delete this Copyright/Copyleft inscription in this source file.
   * </ol>
   * If you are intent to use this sources without publishing its usage, you can get
   * a second license subscribing a special contract with the author. 
   * 
   * @author Hartmut Schorrig = hartmut.schorrig@vishia.de
   * 
   */
  public static final String version = "2022-05-29";

  XmlJzCfgAnalyzer cfgAnalyzer = new XmlJzCfgAnalyzer();  //the root node for reading config

  XmlJzReader xmlReader = new XmlJzReader();
  
  
  
  /**Analyzes the given XML file example and creates a proper xmlcfg.xml file from that.
   * @param fXmlIn The example file. The xmlCfg will be write beside as xmlcfg.xml
   * @throws IOException
   */
  public void analyzeXmlStruct(String sIn, String sDirOut) throws IOException {
    this.cfgAnalyzer = new XmlJzCfgAnalyzer();
    //this.cfgAnalyzer.readXmlStruct(new File(sIn));
    this.cfgAnalyzer.readXmlStructZip(new File(sIn), "content.xml");
    this.cfgAnalyzer.writeData(new File(sDirOut + "/xmlcfg.txt"));
    this.cfgAnalyzer.writeCfgText(new File(sDirOut + "/xmlcfg.cfg"));
    this.cfgAnalyzer.writeCfgTemplate(new File(sDirOut + "/xmlcfg.xml"));

//    this.cfgAnalyzer = new XmlJzCfgAnalyzer();
//    this.cfgAnalyzer.readXmlStructZip(new File("d:\\vishia\\Fpga\\doc\\Java2Vhdl_Diagrams.odg"), "content.xml");
//    this.cfgAnalyzer.writeCfgText(new File("T:/Java2Vhdl_Diagrams.odg.cfg"));

//    this.cfgAnalyzer = new XmlJzCfgAnalyzer();
//    this.cfgAnalyzer.readXmlStructZip(new File("d:\\vishia\\spe\\SPE-card\\wrk-src\\src\\src_SpeA_Fpga\\oodg\\modules_SpeA-c.odg"), "content.xml");
//    this.cfgAnalyzer.writeCfgText(new File("T:/modules_SpeA-c.odg.cfg"));
    
//    XmlCfg cfg = new XmlCfg();
//    cfg.setCfgFromZml(new File("D:/vishia/Java/cmpnJava_vishiaBase/src/srcJava_vishiaBase/java/org/vishia/odg/data/xmlcfg.cfg"));
    
    
    
    
//    this.cfgAnalyzer = new XmlJzCfgAnalyzer();
//    this.cfgAnalyzer.readConfigText(new File("T:/xmlcfg.cfg"));
//    this.cfgAnalyzer.writeCfgText(new File("T:/xmlcfg.back.cfg"));
//    this.cfgAnalyzer.writeCfgTemplate(new File("T:/xmlcfg.back.xml"));
    System.out.println("done\n");
  }


  /**Generates Java source files to store the data due to xmlcfg.xml.
   * It calls immediately {@link GenXmlCfgJavaData#smain(String[])}
   * with here set arguments.
   */
  public void genJavaData() {
    String sGenDirJava = Arguments.replaceEnv("$(TMP)/test_XmlOdt/Java");
    String[] args = 
      { //Arguments.replaceEnv("-cfg:$(TMP)/test_XmlOdg/xmlcfg.xml")
        "-cfg:T:/xmlcfg.xml"
      , "-dirJava:" + sGenDirJava
      , "-pkg:org.vishia.odt.xmlData"
      , "-class:XmlForOdt"
      };
      
    GenXmlCfgJavaData.smain(args);
  }


  public static void main(String[] args) {
    GenerateCfgData thiz = new GenerateCfgData();
    try {
      String sIn = "Q:/vishia/fbg/source.wrk/src/docuFBcl/odt/UFBgl-Diagrams-OpenLibreoffice.odt";  // example (adapt it)
      String sDirOut = "T:/tmp/test_XmlOdt/Java/org/vishia/odt/xmlData";
      thiz.analyzeXmlStruct(sIn, sDirOut);
      thiz.genJavaData();
      //main.readXmlMap();
    } catch (Exception e) {
      System.err.println("Unexpected: " + e.getMessage());
      e.printStackTrace(System.err);
    }
  }
  
  

  
  

  
}
