package org.vishia.libOffc.styles;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.vishia.genJavaOutClass.GenJavaOutClass;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.util.Arguments;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.xmlReader.GenXmlCfgJavaData;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlDataNode;
import org.vishia.xmlReader.XmlJzCfgAnalyzer;
import org.vishia.xmlReader.XmlJzReader;

public class ReadStyles_Loffc {

  
  
  public static class CmdArgs extends Arguments {
  
    /**The input file to read, either odt or ZmL. */
    List<FileFunctions.FilePathnameExt> listfIn = new LinkedList<>();;
    
    FileOutputStream fLog;

    File dirDbg;
    
    /**If not null then write a new analyzed XmlCfg to this file, which is gotten from only one read #fIn . */
    File fWriteXmlConfigText;
 
    /**The XML configuration textual syntax to read for working. Option -xmlCfg:path/to/config.txt*/
    File fXmlConfigTxt;
    
    /**The output file for write the style description. Option -oStyle:path/to/*.txt*/
    FileFunctions.FilePathnameExt outStyleText;
    
    /**If true then call {@link GenXmlCfgJavaData} with the used existing XmlCfg. */
    File dirCreateCfgJavaData;
    
    void test() {
      //fileStyleText.getParentFile();
    }

    Argument[] argList1 = {
      new Argument("-i", ":<path/file.odx>  any LibreOffice file which contains styles.xml for input", new SetArgument(){ 
      @Override public boolean setArgument(String val) throws FileNotFoundException { 
        File fIn = new File(val);
        CmdArgs.this.listfIn.add(new FileFunctions.FilePathnameExt(fIn, "styles.xml")); 
        return fIn.exists();
      }})
      , new Argument("-analyzeXmlStruct", ":D:/path/to/xmlCfg.txt optional, first analyze the input xml data and generate a new XmlCfg text file", new SetArgument() {
        @Override public boolean setArgument(String val) throws FileNotFoundException { 
          CmdArgs.this.fWriteXmlConfigText = new File(val) ;  
          File dirWriteXmlStruct = CmdArgs.this.fWriteXmlConfigText.getParentFile();
          FileFunctions.mkDir(dirWriteXmlStruct);
          return dirWriteXmlStruct.exists();
        }})
      , new Argument("-xmlCfg", ":D:/path/to/xmlCfg.txt textual given config", new SetArgument() {
        @Override public boolean setArgument(String val) throws FileNotFoundException { 
          CmdArgs.this.fXmlConfigTxt = new File(val) ;  
          return CmdArgs.this.fXmlConfigTxt.exists();
        }})
    , new Argument("-genJavaData", ":<path>  Generates new versions of Java data in pkg path from -analyzeXmlStruct or from given XmlCfg", new SetArgument(){ 
      @Override public boolean setArgument(String val) throws IOException { 
        File dirJava = new File(val).getAbsoluteFile();
        if(!dirJava.exists() || !dirJava.isDirectory()) {
          return CmdArgs.this.errMsg("-genJavaData:%s ERROR not found as directory", dirJava );
        } else {
          CmdArgs.this.dirCreateCfgJavaData = dirJava;
          return true;
      }}})
    , new Argument("-oStyle", ":<path>  output of styles in textual form", new SetArgument(){ 
      @Override public boolean setArgument(String val) throws IOException { 
        CmdArgs.this.outStyleText = FileFunctions.FilePathnameExt.parseDirWildcardName(null, val);
        FileFunctions.mkDir(CmdArgs.this.outStyleText.file);
        return true;
      }})
    , new Argument("-dirDebug", ":D:/path/to/xmlCfg.txt in given write debug info", new SetArgument() {
      @Override public boolean setArgument(String val) throws FileNotFoundException { 
        CmdArgs.this.dirDbg = new File(val) ;  
        FileFunctions.mkDir(CmdArgs.this.dirDbg);
        return CmdArgs.this.dirDbg.exists();
      }})
    }; 
    
    
    CmdArgs(){
      super();
      super.aboutInfo = "...Reader styles from any LibreOffice file";
      super.helpInfo="obligate args: -i:path/to/file.od?";
      for(Argument arg: this.argList1) { addArg(arg); }
    }
  

    
    @Override public boolean testConsistence ( Appendable msg ) {
      boolean bOk = true;
      try {
        if(false) { msg.append("-dirFBcl:path/to/outdir is obligate\n"); bOk = false; }
      } catch(IOException exc) {
        System.err.println("Fatal Error, msg as Appendable has IOException " + exc.getMessage());
      }
      if(!bOk) {
        super.showHelp(msg);
      }
      return bOk;
    }


  }
  
  /**main for UFBglConv, invoked from cmd line. 
   * Catch and report an unexpected exceptions via console error output, returns an exit code 
   * @param sArgs
   * @return 0 if all is ok
   */
  public static void main ( String[] sArgs) {
    try {
      int exitCode = smain(sArgs, System.out, System.err);
      System.exit(exitCode);
    } catch (Exception e) {
      System.err.println("Unexpected: " + e.getMessage());
      e.printStackTrace(System.err);
      System.exit(255);
    }
  }



  /**main gets the arguments as String, 
   * but does not catch unexpected exceptions and does not System.exit(...), use it to execute in a Java environment. 
   * @param sArgs
   * @return 0 if all is ok
   * @throws IOException 
   * @throws Exception if unexpected.
   */
  public static int smain ( String[] sArgs, Appendable logHelp, Appendable logError) throws IOException {
    CmdArgs args = new CmdArgs();
    if(sArgs.length ==0) {
      args.showHelp(logHelp);
      return(1);                // no arguments, help is shown.
    }
    if(  ! args.parseArgs(sArgs, logError)
      || ! args.testConsistence(logError)
      ) { 
      return(2);                    // argument error
    }
    //LogMessageStream log = new LogMessageStream(System.out);
    int exitCode = amain(args);
    if(exitCode !=0 ) { System.out.printf(" EXIT-code=%d", exitCode); }
    System.out.println();
    return exitCode;
  }



  /**main for this class, with given prepared arguments 
   * Does not catch unexpected exceptions and does not System.exit(...), use it to execute in a Java environment. 
   * @param args prepared cmd line arguments
   * @return 0 if all is ok
   * @throws IOException 
   * @throws Exception if unexpected.
   */
  public static int amain ( CmdArgs args) throws IOException {
    ReadStyles_Loffc thiz = new ReadStyles_Loffc(args);
    int error = thiz.execute();
    thiz.log.close();
    return error;
  }



  final CmdArgs cmdArgs;

  /**Central possibility to write messages. Can be in file, on screen. */
  final public LogMessage log;

  private XmlCfg xmlCfgStyle = new XmlCfg(true);

  RdWrStyle2Text_LOffc rwStyle2Text = new RdWrStyle2Text_LOffc();
  
  
  protected ReadStyles_Loffc (CmdArgs cmdArgs) {
    this.log = new LogMessageStream(cmdArgs.fLog, null, System.out, System.err, true, Charset.defaultCharset());
    this.cmdArgs = cmdArgs;
  }
  
  
  
  @SuppressWarnings("resource") public int execute() throws IOException {
    //showArguments();
    int err = 0;

    if(this.cmdArgs.fWriteXmlConfigText !=null) {    //========vv option -analyzeXmlStruct:path/to/fWriteCfgTxt
      XmlJzCfgAnalyzer cfgAnalyzer = new XmlJzCfgAnalyzer();
      cfgAnalyzer.setDirDebug(this.cmdArgs.dirDbg);
      try {
        XmlCfg xmlCfgAnalyzed = cfgAnalyzer.analyzeXmlFile(this.cmdArgs.listfIn);
        xmlCfgAnalyzed.writeToText(this.cmdArgs.fWriteXmlConfigText, this.log);
      } catch(Exception exc) {
        this.log.writeError("Exception analyzeXmlStruct", exc);
      }
    }
    else if(this.cmdArgs.dirCreateCfgJavaData !=null) {
      writeJavaClasses();
    }
    if(this.cmdArgs.listfIn !=null && this.cmdArgs.fXmlConfigTxt !=null) {  //======================== read the given odt file <::callReadXml.>
      //XmlDataNode data = new XmlDataNode(null, "root", null);  //<:@<new root>.>
      XmlDataLOffcStyles_Zbnf data = new XmlDataLOffcStyles_Zbnf();
      this.xmlCfgStyle = new XmlCfg(true);
      this.xmlCfgStyle.readCfgFile(this.cmdArgs.fXmlConfigTxt, this.log);
      for(FileFunctions.FilePathnameExt fInZip: this.cmdArgs.listfIn) {
        String error = readXml(data, fInZip.file);  //<:@<readXml>.>
        if(error !=null) {
          this.log.writeError("\nERROR reading xml file %s: %s", fInZip.file.getPath(), error);
          err = 4;
        } else {
          String sOut;
          String sIn = fInZip.file.getName();
          int posExt = sIn.lastIndexOf('.');
          if(posExt <0) { posExt = sIn.length(); }
          if(this.cmdArgs.outStyleText.sExt !=null) {
            sOut = this.cmdArgs.outStyleText.sNamePath + sIn.substring(0, posExt) + this.cmdArgs.outStyleText.sExt; 
          } else if(this.cmdArgs.outStyleText.sNamePath.length()==0) {
            sOut = sIn.substring(0, posExt) + ".style.txt";
          } else {
            sOut = this.cmdArgs.outStyleText.sNamePath;
          }
          File fOut = new File(this.cmdArgs.outStyleText.file, sOut); 
          this.rwStyle2Text.writeStyleDetToText(data, fOut);
          Debugutil.stop();
        }
      }
    }
//        writeBackupFile(this.cmdArgs.fOutZmL, this.cmdArgs.dirOutBack, this.cmdArgs.sExtOut, this.cmdArgs);
//        this.wra = this.cmdArgs.fAdoc == null ? null :new OutputStreamWriter(new FileOutputStream(this.cmdArgs.fAdoc), "UTF-8");
//        this.wr = new java.io.OutputStreamWriter(new FileOutputStream(this.cmdArgs.fOutZmL), "UTF-8");
//        this.wrRep = this.cmdArgs.fReport == null ? null :new OutputStreamWriter(new FileOutputStream(this.cmdArgs.fReport), "UTF-8");
        //this.wr = new java.io.FileWriter(this.cmdArgs.fOut);
        //======>>>>                   ====================>> convert to ZmL
//        try { 
//          readOdgxmlWriteZmL(data);   //<:@<prc>.>
//          wrClose();
//          if(!this.bIsInclude) {
//            writeLabelRef();                     //---------- writes the NAME.Labels.txt only for comprehensive files.
//          }
//          System.out.printf("\n*** finished %s @%s", this.cmdArgs.fOutZmL.getName(), this.cmdArgs.fOutZmL.getParent()  );
//          err = 0;         //<:.callReadXml.>
//        }
//        catch(Exception exc) {
//          CharSequence sExc;
//          if(exc == this.excTOCnotUpdated) {
//            sExc = "\nERROR: Table of contents is not updated, update all is missing, do it!";
//          } else {
//            sExc= org.vishia.util.ExcUtil.exceptionInfo("\nERROR ", exc, 0, 10);
//          }
//          this.log.append(sExc);
//          // restore the back vml file:
//          wrClose();
//          if(this.cmdArgs.dirOutBack !=null) {
//            String sNameBack = this.cmdArgs.sNameDoc;
//            if(FileFunctions.getCanonicalPath(this.cmdArgs.dirOutBack).equals(FileFunctions.getCanonicalPath(this.cmdArgs.dirIn))) {
//              sNameBack += ".back";
//            }
//            File fMarkupBack0 = new File(this.cmdArgs.dirOutBack, sNameBack + this.cmdArgs.sExtZmL);
//            boolean bOkRename;
//            bOkRename = this.cmdArgs.fOutZmL.delete()                   // delete the new created file
//                      & fMarkupBack0.renameTo(this.cmdArgs.fOutZmL);    // and rename the last backup file with this number.
//            if(bOkRename) { this.log.writef("\n%s successfull restored from: %s", this.cmdArgs.sNameDoc + this.cmdArgs.sExtZmL, fMarkupBack0.getAbsolutePath()); }
//            else { this.log.writef("\nERROR restoring %s from %s", this.cmdArgs.sNameDoc + this.cmdArgs.sExtZmL, fMarkupBack0.getAbsolutePath());}
//          }
//          err = 3;
//        }
//        if(this.cmdArgs.sCmdDifftool !=null) {
//          executeViewDiff();
//        }
    this.log.close();
    return err;

  }
  
  
  
  private void writeJavaClasses () throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
    GenJavaOutClass.CmdArgs genXmlJavaDataArgs = new GenJavaOutClass.CmdArgs();
    genXmlJavaDataArgs.dirJava = this.cmdArgs.dirCreateCfgJavaData;
    genXmlJavaDataArgs.sJavaClass = "XmlDataLOffcStyles";
    genXmlJavaDataArgs.sJavaPkg = "org.vishia.libOffc.styles";
    GenXmlCfgJavaData genXmlJavaData = new GenXmlCfgJavaData(genXmlJavaDataArgs, this.log);
    XmlCfg xmlCfgForJavaData;
    if(this.cmdArgs.fXmlConfigTxt !=null) {
      xmlCfgForJavaData = new XmlCfg(true);
      xmlCfgForJavaData.readCfgFile(this.cmdArgs.fXmlConfigTxt, this.log);
      genXmlJavaData.exec(xmlCfgForJavaData);
    } else {
      throw new IllegalArgumentException("-genJavaData:... needs also -xmlCfg:...");
    }
  }
  
  
  /**Reads completely the content.xml from the given odt file <::readXml.>
   * and stores the data in the data instance.
   * @param data The root node for all XML data
   * @param fInOdt the odt file is a zip file
   * @return null or an error message
   * @throws IOException for file operation
   */
  private String readXml (Object data, File fInOdt) throws IOException {
    XmlJzReader xmlReader = new XmlJzReader();
    xmlReader.setNamespaceEntry("xml", "XML");  // it is missing
    xmlReader.setCfg(this.xmlCfgStyle);
    
    String sFileOdg = fInOdt.getName();
    //xmlReader.setDebugStopTag("office:body");
    xmlReader.openXmlTestOut( new File(this.cmdArgs.dirDbg, sFileOdg + "-back.xml")); //fout1);
    String error = xmlReader.readZipXml(fInOdt, "styles.xml", data);
    if(error !=null) {
      this.log.writef("\nERROR reading xml file %s: %s", sFileOdg, error);
    }
    return error;
  } //<:.readXml.>
  
  
  private void writeStyleDetToText (XmlDataNode ndRoot) {
    if(ndRoot.allNodes.size() !=1) {
      this.log.writef("first level nodes more as one, should contain only 'office:document-styles'");
    } else {
      XmlDataNode ndStyle1 = ndRoot.allNodes.get(0);
      if(!ndStyle1.tag.equals("office:document-styles")) {
        this.log.writef("first only one sub node should be 'office:document-styles', but is: '%s'", ndStyle1.tag);
      } else {
        XmlDataNode ndStyles = ndStyle1.singleNodes.get("office:styles"); 
        for( XmlDataNode nd3: ndStyles.allNodes) {
          
          Debugutil.stopp();
        }
      }
    }
  }

}

