package org.vishia.libOffc.cfgui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.util.Arguments;
import org.vishia.util.FileFunctions;
import org.vishia.util.OutTextPreparer;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlJzReader;

/**This class presents an application which writes the key accelerator output of LibreOffice
 * as human readable text file.
 * <br><br>
 * It can be used as template for the {@link XmlJzReader} usage in an application.
 * Because the intrinsic processing of the read data is not part of this class.
 * It is called in only one line in {@link #execute()}: 'WriteKeyAcclPrc.exec(...)'.
 * This line and the used 'XmlDataLOffcKeyAccl_Zbnf data' also only in {@link #execute()}
 * should be exchanged.
 * <ul>
 * <li>Copy this class as source.java renamed 
 * <li>Search and replace 'WriteKeyAccl' to the name used.
 * <li>First comment out the 'evalPrc' class and call, replace later with your evaluation process.
 * <li>The config file should be given, see {@link org.vishia.xmlReader.XmlJzCfgAnalyzer}
 *   or also {@link https://vishia.org/Java/html/RWTrans/XmlJzReader.html}.
 *   Replace with your configuration file for {@link XmlCfg}.
 * <li>The destination classes should be given, see also there.
 *   Replace with your destination classes.
 * <li>Test it. Look whether the config file is ok, destination is ok, look on your data read.  
 * </ul>
 * <br><br>
 * Due to the common approach as template, processing the result of XML reading is completely done
 * in {@link WriteKeyAcclPrc}, see there.
 * 
 */
public class WriteKeyAccl {

  
  
  
  public static class CmdArgs extends Arguments {
    
    /**The input file to read, It is here a zip file contains an XML. */
    List<File> fInKeyboardCfg = new LinkedList<>();
    
    /**Log file. */
    File fLog;
    
    File dirLOffcPrg;

    File dirLOffcUser;

    /**Used for debug outputs. */
    File dirDbg;
    
    /**The pattern for write the output. Option -oStyle:path/to/*.txt*/
    FileFunctions.FilePathnameExt fpOutText;
    
    /**Output control generate Text pattern. */
    File file_gTxt;
    
    /**If true then on output the key with shift modifier follows immediately the key without shift.*/
    boolean bShFollow;
    
    Argument[] argList1 = {
      new Argument("-i", ":path/...Keyboard...cfg  File which is outputted on LOffc: Tools-Customize.Keyboard-Save", new SetArgument(){ 
      @Override public boolean setArgument(String val) { 
        FileFunctions.addFileToList(val, CmdArgs.this.fInKeyboardCfg);
        return true;
      }})
    , new Argument("-o", ":path/to/*.txt  output in human readable form, if not given writes beside -i:...", new SetArgument(){ 
      @Override public boolean setArgument(String val) throws IOException { 
        CmdArgs.this.fpOutText = FileFunctions.FilePathnameExt.parseDirWildcardName(null, val);
        //FileFunctions.mkDir(CmdArgs.this.fpOutText.file);
        return true;
      }})
    , new Argument("-LOffcPrg", ":/path/to/LibreOffice installation, where .../share/registry will be found.", new SetArgument(){ 
      @Override public boolean setArgument(String val) throws FileNotFoundException { 
        CmdArgs.this.dirLOffcPrg = new File(val);
        return true; // not tested here whether it exists
      }})
    , new Argument("-LOffcUser", ":~/.config/libreoffice/4/user   user settings, where .../config/... will be found.", new SetArgument(){ 
      @Override public boolean setArgument(String val) throws FileNotFoundException { 
        CmdArgs.this.dirLOffcUser = new File(val); 
        return true; // not tested here whether it exists
      }})
    , new Argument("-gTxt", ":KeyAcclText.gTxt  gTxt script as template for the output", new SetArgument(){ 
      @Override public boolean setArgument(String val) throws FileNotFoundException { 
        CmdArgs.this.file_gTxt = FileFunctions.newFile(val); 
        return true; // not tested here whether it exists
      }})
    , new Argument("-log", ":path/to/log.txt  Logfile, additonal to console.out, err", new SetArgument(){ 
      @Override public boolean setArgument(String val) throws FileNotFoundException { 
        File fLog = new File(val);
        File dirLog = fLog.getParentFile();
        FileFunctions.mkDir(dirLog);
        CmdArgs.this.fLog = fLog; 
        return true;
      }})
    , new Argument("-dirDebug", ":D:/path/to/xmlCfg.txt in given write debug info", new SetArgument() {
      @Override public boolean setArgument(String val) throws FileNotFoundException { 
        CmdArgs.this.dirDbg = new File(val) ;  
        FileFunctions.mkDir(CmdArgs.this.dirDbg);
        return CmdArgs.this.dirDbg.exists();
      }})
    , new Argument("-shfollow", " then the key with shift modifier follows immediately the key without shift", new SetArgument() {
      @Override public boolean setArgument(String val) throws FileNotFoundException { 
        CmdArgs.this.bShFollow = true ;  
        return true;
      }})
    }; 
    
    
    CmdArgs(){
      super();
      super.aboutInfo = "...Writes Key accelerators in human readable text form";
      super.helpInfo="obligate args: -i:path/...Keyboard...cfg, -LOffcPrg:...";
      for(Argument arg: this.argList1) { addArg(arg); }
    }


    @Override public boolean testConsistence ( Appendable msg ) throws IOException {
      if(this.fInKeyboardCfg.size() == 0) {      //--------vv no input files found.
        showHelp(msg);
        return false;
      }
      if(this.dirLOffcPrg == null) {
        msg.append("-LOffcPrg: is not set, maybe faulty");
        showHelp(msg);
      }
      if(this.fpOutText == null) {     //------------------vv standard for output  
        this.fpOutText = new FileFunctions.FilePathnameExt(null, "", ".txt");
      }                                
      return true;
    }
  }
  
  
  /**main for UFBglConv, invoked from cmd line. 
   * Catch and report an unexpected exceptions via console error output, returns an exit code 
   * @param sArgs
   * @return 0 if all is ok
   */
  public static void main ( String[] sArgs) {
    try {
      int exitCode = smain(sArgs, System.out, System.err);
      System.exit(exitCode);
    } catch (Exception e) {
      System.err.println("Unexpected: " + e.getMessage());
      e.printStackTrace(System.err);
      System.exit(255);
    }
  }


  /**main gets the arguments as String, 
   * but does not catch unexpected exceptions and does not System.exit(...), use it to execute in a Java environment. 
   * @param sArgs
   * @return 0 if all is ok
   * @throws IOException 
   * @throws Exception if unexpected.
   */
  public static int smain ( String[] sArgs, Appendable logHelp, Appendable logError) throws IOException {
    CmdArgs args = new CmdArgs();
    if(sArgs.length ==0) {
      args.showHelp(logHelp);
      return(1);                // no arguments, help is shown.
    }
    if(  ! args.parseArgs(sArgs, logError)
      || ! args.testConsistence(logError)
      ) { 
      return(2);                    // argument error
    }
    //LogMessageStream log = new LogMessageStream(System.out);
    int exitCode = amain(args);
    if(exitCode !=0 ) { System.out.printf(" EXIT-code=%d", exitCode); }
    System.out.println();
    return exitCode;
  }


  /**main for this class, with given prepared arguments 
   * Does not catch unexpected exceptions and does not System.exit(...), use it to execute in a Java environment. 
   * @param args prepared cmd line arguments
   * @return 0 if all is ok
   * @throws IOException 
   * @throws Exception if unexpected.
   */
  public static int amain ( CmdArgs args) throws IOException {
    WriteKeyAccl thiz = new WriteKeyAccl(args);
    int error = thiz.execute();
    return error;
  }


  /**All command arguments after command line evaluation with {@link Arguments}. */
  final CmdArgs cmdArgs;

  /**{@link XmlCfg} how to read the xml file, prepared for
   * {@link XmlCfg#readCfgFile(File, LogMessage)}
   * 
   */
  private XmlCfg xmlCfg = new XmlCfg(true);

  /**Instance of the xmlReader used with the {@link #xmlCfg}*/
  private XmlJzReader xmlReader = new XmlJzReader();
  
  /**The class instance which is responsible to the evaluation of the XML parsing result. */
  private final WriteKeyAcclPrc evalPrc;
  
  public WriteKeyAccl (CmdArgs cmdArgs) {
    this.cmdArgs = cmdArgs;
    this.evalPrc = new WriteKeyAcclPrc(this.cmdArgs);
  }

  
  
  /**Executes read the XML file and calls the evaluation: 'WriteKeyAcclPrc.exec(...)'
   * <br><br>
   * This can be used as template for applications which uses the {@link XmlJzReader}
   * @return 0 or an error level proper for main call.
   * @throws IOException for file problems.
   */
  public int execute () throws IOException {
    int nError = 0;                    //----------vvvv----vv opens the log file here, close the resource in the same operation on end.
    FileOutputStream sLog = this.cmdArgs.fLog == null ? null : new FileOutputStream(this.cmdArgs.fLog);
    LogMessage log = new LogMessageStream(sLog, System.out, null, System.err, false, Charset.forName("UTF-8"));
    //                                 //--------vvvv------vv instantiates the evaluation process class:
    this.evalPrc.init(log);
    //                                 //----------vvvv----vv Read the XML configuration file inside the jar archive:
    this.xmlCfg.readFromJar(this.getClass(), "KeyboardAccl.xml.cfg", log); // relative to this class, with the given file name.
    this.xmlReader.setCfg(this.xmlCfg);
    this.xmlReader.setNamespaceEntry("xml", "XML");        // it is missing
    //                                 //----------vvvv----vv The destination instance for XML data:
    XmlDataLOffcKeyAccl_Zbnf data = new XmlDataLOffcKeyAccl_Zbnf();
    //                                 //--vvvv------------vv call the XmlJzReader for the input file
    for(File fIn: this.cmdArgs.fInKeyboardCfg) {
      if(this.cmdArgs.dirDbg !=null) {
        try {
          String sFile = fIn.getName();
          this.xmlReader.openXmlTestOut( new File(this.cmdArgs.dirDbg, sFile + "-back.xml"));
        } catch (IOException exc) {
          log.writeError("\nWARNING cannot open debug/*-back.xml", exc);
        }
      }                                  //----------vvvv----vv Reads a XML in a zip file, from this path inside zip:
      String sPathInZip = "Configurations2/accelerator/current.xml"; 
      log.writef("\nreads accelerator key XML from %s, \n  internal in zip: '%s' ...", fIn, sPathInZip);
      //============>>>>XmlJzReader#readZipXml(...)
      String error = this.xmlReader.readZipXml(fIn, sPathInZip, data);
      if(error !=null) {
        log.writeError("\nERROR reading xml file %s: %s", fIn.getPath(), error);
        nError = 4;
      } else {                           //--------vvvv------vv calls the execution procedure to work with the XML data
        log.writeInfo(" done");
        nError = this.evalPrc.exec(data.dataroot, fIn, log);
      }
    }
    log.close();
    if(sLog !=null) {
      sLog.close();
    }
    return nError;
  }
  
  

  
}
