package org.vishia.libOffc.cfgui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlJzReader;

/**This class reads all libreoffice/officecfg/registry/data/org/openoffice/Office/UI/*.xcu files
 * It is currently not used and not completed tested and documented.
 */
public class ReadUiXcu_LOffc {

  
  Map<String,UiReplace> idxReplace1 = new TreeMap<>(); 
  
  Map<String,UiReplace> idxReplace2 = new TreeMap<>(); 
  
  Map<String,UiReplace> idxReplace3 = new TreeMap<>(); 
  
  ReadUiXcu_LOffc () {
    FileFunctions.FilePathnameExt xx;
  }
  
  
  /**Read and prepare the User Interface texts.
   * @param listFiles
   * @param log
   */
  private XmlDataLOffcXcuUi readUiXcu (List<FileFunctions.FilePathnameExt> listFiles, LogMessage log) {
    XmlCfg xmlCfg = new XmlCfg(true);
    XmlDataLOffcXcuUi_Zbnf data = new XmlDataLOffcXcuUi_Zbnf();
    try {
      xmlCfg.readFromJar(this.getClass(), "uixcu.xml.cfg", log);
      XmlJzReader xmlReader = new XmlJzReader(log);
      xmlReader.setCfg(xmlCfg);
      for(FileFunctions.FilePathnameExt fIn1: listFiles) {
        try {
          String sInName = fIn1.file.getName();
          log.writef("\nreads XML: %s", fIn1.file.getAbsolutePath());
          if(fIn1.sNamePath !=null) {
            xmlReader.readZipXml(fIn1.file, fIn1.sNamePath, data);
          } else {
            xmlReader.readXml(fIn1.file, data, null);
          }
        } catch(Exception exc) {
          log.writeError("\nEXCEPTION parse : ", exc);
        }
      }
    } catch (IllegalCharsetNameException | UnsupportedCharsetException | IOException exc) {
      log.writeError("\nEXCEPTION xmlCfg : ", exc);
    }
    return data.dataroot;
  }
  
  
  public void readPrepareXcuUi (List<FileFunctions.FilePathnameExt> listFiles, LogMessage log) {
    XmlDataLOffcXcuUi data = readUiXcu(listFiles, log);
    prepareXcuUi(data);
  }
  
  
  void prepareXcuUi ( XmlDataLOffcXcuUi data ) {
    for(XmlDataLOffcXcuUi.Oor_component_data xcmpn:  data.oor_component_data){
      String sCmpn = xcmpn.oor_name;
      for(XmlDataLOffcXcuUi.Node xnode: xcmpn.node) {
        prepareNode(xnode, "", sCmpn);
      }
    }
    
    
    
    Debugutil.stop();
    
  }
  
  
  void prepareNode (XmlDataLOffcXcuUi.Node xnode, String sNodeNamesParent, String sCmpn) {
    String sNodenames = sNodeNamesParent + "." + xnode.oor_name;
    if(xnode.oor_op !=null && xnode.oor_op.equals("replace")) {
      prepareNodeReplace(xnode, sNodenames, sCmpn);
    } else {
      Debugutil.stop();
    }
    if(xnode.node !=null) for(XmlDataLOffcXcuUi.Node xnodeSub: xnode.node) {
      prepareNode(xnodeSub, sNodenames, sCmpn);
    }
    
  }

  
  
  void prepareNodeReplace (XmlDataLOffcXcuUi.Node xnode, String sNodeNames, String sCmpn) {
    for(XmlDataLOffcXcuUi.Prop xprop : xnode.prop) {
      UiReplace repl = new UiReplace();
      repl.xnode = xnode;
      repl.sNameProp = xprop.oor_name;
      repl.sCmpn = sCmpn;
      repl.sNodeNames = sNodeNames;
      String sUno = null;
      for(XmlDataLOffcXcuUi.Value xval : xprop.value) {
        UiValue val = new UiValue();
        repl.values.add(val);
        val.text = xval._textContent;
        val.separator = xval.oor_separator == null ? "" : xval.oor_separator;
        val.xml_lang = xval.xml_lang == null ? "" : xval.xml_lang;
        if(val.text !=null && val.text.startsWith(".uno")) {
          sUno = val.text;
        }
      }
      String key = repl.sNameProp + sNodeNames + "/" + sCmpn;
      this.idxReplace1.put(key, repl);
      if(sUno !=null) {
        while(this.idxReplace2.get(sUno) !=null) {
          sUno += "+";
        }
        this.idxReplace2.put(sUno, repl);
      }
    }
    Debugutil.stop();
  }
  
  
  static class UiReplace {
    XmlDataLOffcXcuUi.Node xnode;
    String sCmpn;
    String sNodeNames;
    String sNameProp;
    List<UiValue> values = new LinkedList<>();
    
    @Override public String toString() { return this.sNameProp + ":" + this.values.toString() + "(" + this.sNodeNames + "/" + this.sCmpn; }
  }
  
  static class UiValue {
    String text;
    String separator;
    String xml_lang;
    @Override public String toString() { return this.text + this.separator + this.xml_lang; }
  }
  
}
