/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zip;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static final String version = "2024-09-20";

    public static OutputStream openToZipOneFile(File file, String string) throws IOException {
        ZipOutputStream zipOutputStream = null;
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        zipOutputStream = new ZipOutputStream(fileOutputStream);
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        return zipOutputStream;
    }

    public static FileSystem openZip(File file) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("create", "true");
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        URI uRI = URI.create("jar:" + path.toUri());
        FileSystem fileSystem = FileSystems.newFileSystem(uRI, hashMap);
        return fileSystem;
    }

    public static void copyFileFromZip(String string, String string2, String string3) throws IOException {
        Path path = Paths.get(string2, new String[0]);
        Path path2 = Paths.get(string, new String[0]);
        FileSystem fileSystem = FileSystems.newFileSystem(path2, (ClassLoader)null);
        Path path3 = fileSystem.getPath("/" + string3, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        Files.copy(path3, path, new CopyOption[0]);
        fileSystem.close();
    }

    public static String copyFileFromZip(File file, File file2, String string) {
        try {
            ZipUtils.copyFileFromZip(file.getAbsolutePath(), file2.getAbsolutePath(), string);
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
        return null;
    }

    public static void replaceFile(String string, String string2, String string3) throws IOException {
        Path path = Paths.get(string2, new String[0]);
        Path path2 = Paths.get(string, new String[0]);
        FileSystem fileSystem = FileSystems.newFileSystem(path2, (ClassLoader)null);
        Path path3 = fileSystem.getPath("/" + string3, new String[0]);
        if (Files.exists(path3, new LinkOption[0])) {
            Files.delete(path3);
        }
        Files.copy(path, path3, new CopyOption[0]);
        fileSystem.close();
    }

    public static BufferedWriter openZipEntryToWrite(File file, String string, Charset charset) throws IOException {
        Charset charset2 = charset != null ? charset : Charset.forName("UTF-8");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("create", "true");
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        URI uRI = URI.create("jar:" + path.toUri());
        FileSystem fileSystem = FileSystems.newFileSystem(uRI, hashMap);
        Path path2 = fileSystem.getPath(string, new String[0]);
        return Files.newBufferedWriter(path2, charset2, new OpenOption[0]);
    }

    public static boolean closeZipEntry(OutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = (ZipOutputStream)outputStream;
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        return true;
    }
}

