/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zbnf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.Debugutil;
import org.vishia.util.StringFormatter;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.util.StringPartScan;
import org.vishia.util.TreeNodeBase;
import org.vishia.util.TreeNode_ifc;
import org.vishia.xmlSimple.XmlNode;
import org.vishia.xmlSimple.XmlNodeSimple;
import org.vishia.zbnf.ZbnfParseResultItem;
import org.vishia.zbnf.ZbnfParserStore;
import org.vishia.zbnf.ZbnfSyntaxPrescript;

public class ZbnfParser {
    public static final String sVersion = "2022-04-30";
    private static final String sEmpty = "                                                                                                                                                                                                                                                                                                                          ";
    public final Args args;
    static final int mXmlSrcline_xmlWrmode = 1;
    static final int mXmlSrctext_xmlWrmode = 2;
    int dbgPosFrom;
    int dbgPosTo;
    int dbgLineSyntax;
    protected final LogMessage report;
    protected int nReportLevel;
    protected int nLevelReportParsing;
    protected int nLevelReportComponentParsing;
    protected int nLevelReportInfo;
    protected int nLevelReportError;
    protected int nLevelReportBranchParsing = 1;
    protected int idReportParsing = 6;
    protected int idReportComponentParsing = 5;
    protected int idReportBranchParsing = 5;
    protected int idReportInfo = 3;
    protected int idReportError = 1;
    protected final TreeMap<String, ZbnfSyntaxPrescript> listSubPrescript;
    TreeMap<String, String> listKeywords = new TreeMap();
    TreeMap<String, String> xmlnsList = null;
    protected boolean bConstantSyntaxAsParseResult = false;
    private ZbnfSyntaxPrescript mainScript;
    protected PrescriptParser prescriptParserTopLevel;
    protected CharSequence sRightestError = "--noError--";
    protected String sExpectedSyntax = "--noError--";
    protected String xxxsFoundedSyntax = "--noError--";
    private int maxParseResultEntriesOnError = 0;
    private final LogParsing log;
    ArrayList<ZbnfParseResultItem> listParseResultOnError = null;
    protected long posRightestError = 0L;
    protected int lineError;
    protected int columnError;
    String sInputMostRightError;
    protected String sFileError;
    String sCommentStringStart = "/*";
    String sCommentStringEnd = "*/";
    boolean bStoreComment = false;
    String sEndlineCommentStringStart = "//";
    protected String sInputEncodingKeyword;
    protected String sInputEncoding;
    boolean bStoreEndlineComment = false;
    String sWhiteSpaces = " \t\r\f\n";
    boolean bStoreNewline = false;
    boolean bStoreOneSpaceOnWhitespaces = false;
    boolean bStoreWhiteSpaces = false;
    private Charset charsetInput;
    protected Map<String, String> idxMissingPrescripts;
    private ZbnfParserStore parserStoreTopLevel;
    private final ZbnfParserStore.BuilderTreeNodeXml builderTreeNodeXml = new ZbnfParserStore.BuilderTreeNodeXml();
    final TreeMap<String, ParseResultlet> alreadyParsedCmpn = new TreeMap();
    final LogZbnfParser log1 = new LogZbnfParser();

    public ZbnfParser(LogMessage logMessage) {
        this(logMessage, 20);
    }

    public ZbnfParser(LogMessage logMessage, int n) {
        this(logMessage, new Args(n));
    }

    public ZbnfParser(LogMessage logMessage, Args args) {
        this.report = logMessage;
        this.args = args;
        this.listSubPrescript = new TreeMap();
        this.log = new LogParsing(logMessage);
        this.maxParseResultEntriesOnError = args.maxParseResultEntriesOnError;
        this.listParseResultOnError = this.maxParseResultEntriesOnError > 0 ? new ArrayList(this.maxParseResultEntriesOnError) : null;
    }

    public void setLogComponents(Appendable appendable) {
        this.log1.logComponents = appendable;
    }

    public void setSyntax(CharSequence charSequence) throws ParseException {
        this.setSyntax(new StringPartScan(charSequence));
    }

    public void setSyntaxString(CharSequence charSequence) throws ParseException {
        this.setSyntax(new StringPartScan(charSequence));
    }

    public void setSyntaxFile(File file) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException, ParseException {
        this.setSyntax(file);
    }

    public void setSyntax(File file) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException, ParseException {
        StringPartFromFileLines stringPartFromFileLines = null;
        int n = (int)file.length();
        stringPartFromFileLines = new StringPartFromFileLines(file, n, "encoding", null);
        String string = file.getParent();
        this.setSyntax(stringPartFromFileLines, string);
    }

    public void setSyntaxFromJar(Class<?> clazz, String string) throws IOException, IllegalCharsetNameException, UnsupportedCharsetException, ParseException {
        InputStream inputStream = clazz.getResourceAsStream(string);
        StringPartFromFileLines stringPartFromFileLines = new StringPartFromFileLines(inputStream, "jar:" + string, 0, "encoding", null);
        String string2 = null;
        this.setSyntax(stringPartFromFileLines, string2);
        ((StringPartScan)stringPartFromFileLines).close();
        inputStream.close();
    }

    public void setSyntax(StringPartScan stringPartScan) throws ParseException {
        try {
            this.setSyntax(stringPartScan, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParseException("import in ZBNF-script is not supported here.", 0);
        }
        catch (IOException iOException) {
            throw new ParseException("import in ZBNF-script is not supported here.", 0);
        }
    }

    public void setSyntax(StringPartScan stringPartScan, String string) throws ParseException, IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        LinkedList linkedList = null;
        int[] nArray = new int[1];
        boolean bl = false;
        if (stringPartScan.startsWith("<?SBNF") || stringPartScan.startsWith("<?ZBNF")) {
            stringPartScan.seek("?>", 1);
        }
        while (stringPartScan.seekNoWhitespace().length() > 0) {
            String string2;
            CharSequence charSequence = stringPartScan.getCurrent(30);
            stringPartScan.scanStart();
            if (StringFunctions.startsWith(charSequence, "$keywords")) {
                char c;
                stringPartScan.seek(9);
                if (stringPartScan.startsWith("::=")) {
                    stringPartScan.seek(3);
                } else if (stringPartScan.startsWith("=")) {
                    stringPartScan.seek(1);
                } else {
                    throw new ParseException("expected \"=\" behind \"$keywords\"", stringPartScan.getLineAndColumn(nArray));
                }
                do {
                    stringPartScan.seekNoWhitespace().lentoIdentifier();
                    if (stringPartScan.length() > 0) {
                        string2 = stringPartScan.getCurrentPart().toString();
                        this.listKeywords.put(string2, string2);
                    }
                    c = stringPartScan.fromEnd().seekNoWhitespace().getCurrentChar();
                    stringPartScan.seek(1);
                } while (c == '|');
                if (c == '.') continue;
                throw new ParseException("expected \".\" on end of \"$keywords\"", stringPartScan.getLineAndColumn(nArray));
            }
            if (StringFunctions.startsWith(charSequence, "$Whitespaces=")) {
                stringPartScan.seek(12);
                String string3 = stringPartScan.getCircumScriptionToAnyChar(".").toString();
                if (string3.length() == 0 || string3.indexOf(10) >= 0) {
                    throw new ParseException("expected \".\" on end of \"$Whitespaces=\"", stringPartScan.getLineAndColumn(nArray));
                }
                stringPartScan.seek(1);
                this.setWhiteSpaces(this.sWhiteSpaces);
                continue;
            }
            if (StringFunctions.startsWith(charSequence, "$setLinemode")) {
                stringPartScan.seek(12);
                if (stringPartScan.getCurrentChar() == '.') {
                    stringPartScan.seek(1);
                    this.setLinemode(true);
                    continue;
                }
                throw new ParseException("expected \".\" on end of \"$setLinemode\"", stringPartScan.getLineAndColumn(nArray));
            }
            if (StringFunctions.startsWith(charSequence, "$setXmlSrcline")) {
                stringPartScan.seek(16);
                if (stringPartScan.getCurrentChar() == '.') {
                    stringPartScan.seek(1);
                    this.setXmlSrcline(true);
                    continue;
                }
                throw new ParseException("expected \".\" on end of \"$setXmlSrcline\"", stringPartScan.getLineAndColumn(nArray));
            }
            if (StringFunctions.startsWith(charSequence, "$setXmlSrctext")) {
                stringPartScan.seek(16);
                if (stringPartScan.getCurrentChar() == '.') {
                    stringPartScan.seek(1);
                    this.setXmlSrctext(true);
                    continue;
                }
                throw new ParseException("expected \".\" on end of \"$setXmlSrctext\"", stringPartScan.getLineAndColumn(nArray));
            }
            if (StringFunctions.startsWith(charSequence, "$endlineComment=")) {
                stringPartScan.seek(16);
                stringPartScan.seekNoWhitespace();
                this.sEndlineCommentStringStart = stringPartScan.getCircumScriptionToAnyChar(".").toString().trim();
                if (this.sEndlineCommentStringStart.length() == 0) {
                    this.sEndlineCommentStringStart = null;
                } else if (this.sEndlineCommentStringStart.length() > 5) {
                    throw new ParseException("more as 5 chars as $endlineComment unexpected", stringPartScan.getLineAndColumn(nArray));
                }
                stringPartScan.seek(1);
                continue;
            }
            if (StringFunctions.startsWith(charSequence, "$comment=")) {
                stringPartScan.seek(9);
                stringPartScan.seekNoWhitespace();
                this.sCommentStringStart = stringPartScan.getCircumScriptionToAnyChar(".").toString().trim();
                if (this.sCommentStringStart.length() == 0) {
                    this.sCommentStringStart = null;
                    continue;
                }
                if (this.sCommentStringStart.length() > 5) {
                    throw new ParseException("more as 5 chars as $endlineComment unexpected", stringPartScan.getLineAndColumn(nArray));
                }
                if (!stringPartScan.startsWith("...")) {
                    throw new ParseException("$comment, must have ... betwenn comment strings.", stringPartScan.getLineAndColumn(nArray));
                }
                stringPartScan.seek(3);
                stringPartScan.seekNoWhitespace();
                this.sCommentStringEnd = stringPartScan.getCircumScriptionToAnyChar(".").toString().trim();
                if (this.sCommentStringEnd.length() == 0) {
                    throw new ParseException("$comment: no endchars found.", stringPartScan.getLineAndColumn(nArray));
                }
                if (this.sCommentStringEnd.length() > 5) {
                    throw new ParseException("SyntaxPrescript: more as 5 chars as $endlineComment-end unexpected", stringPartScan.getLineAndColumn(nArray));
                }
                stringPartScan.seek(1);
                continue;
            }
            if (stringPartScan.scan("$inputEncodingKeyword=").scanOk()) {
                String[] stringArray = new String[1];
                if (stringPartScan.scanQuotion("\"", "\"", stringArray).scan(".").scanOk()) {
                    this.sInputEncodingKeyword = stringArray[0];
                    continue;
                }
                throw new ParseException("$inputEncodingKeyword=", 0);
            }
            if (stringPartScan.scan("$inputEncoding=").scanOk()) {
                String[] stringArray = new String[1];
                if (stringPartScan.scanQuotion("\"", "\"", stringArray).scan(".").scanOk()) {
                    this.sInputEncoding = stringArray[0];
                    this.charsetInput = Charset.forName(stringArray[0]);
                    continue;
                }
                throw new ParseException("$inputEncodingKeyword=", 0);
            }
            if (StringFunctions.startsWith(charSequence, "##")) {
                stringPartScan.seek('\n', 1);
                continue;
            }
            if (StringFunctions.startsWith(charSequence, "$main=")) {
                stringPartScan.seek(6);
                this.mainScript = ZbnfSyntaxPrescript.createWithSyntax(stringPartScan, this.sEndlineCommentStringStart, this.sCommentStringStart, this.report);
                this.listSubPrescript.put(this.mainScript.getDefinitionIdent(), this.mainScript);
                continue;
            }
            if (StringFunctions.startsWith(charSequence, "$xmlns:")) {
                stringPartScan.seek(7);
                String string4 = stringPartScan.lento("=").getCurrentPart().toString();
                string2 = stringPartScan.fromEnd().seek(1).lentoQuotionEnd('\"', Integer.MAX_VALUE).getCurrentPart().toString();
                if (string4.length() > 0 && string2.length() > 2) {
                    if (this.xmlnsList == null) {
                        this.xmlnsList = new TreeMap();
                    }
                } else {
                    throw new ParseException("SyntaxPrescript: $xmlns:ns:\"string\". :failed syntax.", stringPartScan.getLineAndColumn(nArray));
                }
                this.xmlnsList.put(string4, string2.substring(1, string2.length() - 1));
                if (stringPartScan.fromEnd().getCurrentChar() == '.') {
                    stringPartScan.seek(1);
                    continue;
                }
                throw new ParseException("SyntaxPrescript: $xmlns:ns:\"string\". :no dot on end.", stringPartScan.getLineAndColumn(nArray));
            }
            if (stringPartScan.scan("$import").scanOk()) {
                String[] stringArray = new String[1];
                if (stringPartScan.seekNoWhitespace().scan().scanQuotion("\"", "\"", stringArray).scan(".").scanOk()) {
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                    }
                    this.importScript(stringArray[0], string);
                    continue;
                }
                throw new ParseException("$import \"importfile\".", 0);
            }
            ZbnfSyntaxPrescript zbnfSyntaxPrescript = ZbnfSyntaxPrescript.createWithSyntax(stringPartScan, this.sEndlineCommentStringStart, this.sCommentStringStart, this.report);
            if (!bl) {
                bl = true;
                this.mainScript = zbnfSyntaxPrescript;
            }
            if ((string2 = zbnfSyntaxPrescript.getDefinitionIdent()) == null) continue;
            this.listSubPrescript.put(string2, zbnfSyntaxPrescript);
        }
        if (linkedList != null) {
            for (String string5 : linkedList) {
                this.importScript(string5, string);
            }
        }
    }

    public void setMainSyntax(String string) throws ParseException {
        ZbnfSyntaxPrescript zbnfSyntaxPrescript = this.listSubPrescript.get(string);
        if (zbnfSyntaxPrescript == null) {
            throw new ParseException("syntax rule not found: " + string, 0);
        }
        this.mainScript = zbnfSyntaxPrescript;
    }

    public void writeSyntaxStruct(Appendable appendable) throws IOException {
        appendable.append("Main Script\n");
        this.mainScript.writeSyntaxStruct(appendable, 0);
        for (Map.Entry<String, ZbnfSyntaxPrescript> entry : this.listSubPrescript.entrySet()) {
            appendable.append("Sub Syntax Component: ").append(entry.getKey()).append("\n");
            ZbnfSyntaxPrescript zbnfSyntaxPrescript = entry.getValue();
            zbnfSyntaxPrescript.writeSyntaxStruct(appendable, 0);
        }
    }

    public ZbnfSyntaxPrescript mainScript() {
        return this.mainScript;
    }

    public TreeMap<String, ZbnfSyntaxPrescript> subPrescripts() {
        return this.listSubPrescript;
    }

    private void importScript(String string, String string2) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException, ParseException {
        String string3 = string2 + "/" + string;
        File file = new File(string3);
        this.setSyntax(file);
    }

    public void setDebugPosition(int n, int n2, int n3) {
        this.dbgPosFrom = n;
        this.dbgPosTo = n2;
        this.dbgLineSyntax = n3;
    }

    public void setSkippingComment(String string, String string2, boolean bl) {
        this.sCommentStringStart = string;
        this.sCommentStringEnd = string2;
        this.bStoreComment = bl;
    }

    public void setSkippingEndlineComment(String string, boolean bl) {
        this.sEndlineCommentStringStart = string;
        this.bStoreComment = bl;
    }

    public void setWhiteSpaces(String string) {
        this.sWhiteSpaces = string;
    }

    public void setLinemode(boolean bl) {
        int n = this.sWhiteSpaces.indexOf(10);
        if (bl && n >= 0) {
            this.sWhiteSpaces = this.sWhiteSpaces.substring(0, n) + this.sWhiteSpaces.substring(n + 1);
        } else if (!bl && n < 0) {
            this.sWhiteSpaces = this.sWhiteSpaces + '\n';
        }
    }

    public void setXmlSrcline(boolean bl) {
        this.builderTreeNodeXml.bXmlSrcline = bl;
    }

    public void setXmlSrctext(boolean bl) {
        this.builderTreeNodeXml.bXmlSrctext = bl;
    }

    public void setReportIdents(int n, int n2, int n3, int n4) {
        this.idReportParsing = n4;
        this.idReportComponentParsing = n3;
        this.idReportInfo = n2;
        this.idReportError = n;
    }

    public boolean parseFile(File file, int n, String string, Charset charset) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        StringPartFromFileLines stringPartFromFileLines = new StringPartFromFileLines(file, n, string, charset);
        return this.parse(stringPartFromFileLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseFile(File file) throws IllegalCharsetNameException, UnsupportedCharsetException, FileNotFoundException, IOException {
        int n = 0;
        boolean bl = false;
        try (StringPartFromFileLines stringPartFromFileLines = new StringPartFromFileLines(file, n, null, null);){
            bl = this.parse(stringPartFromFileLines);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseFileFromJar(Class<?> clazz, String string, int n) throws IOException {
        boolean bl = false;
        try (StringPartScan stringPartScan = null;){
            stringPartScan = new StringPartFromFileLines(clazz, string, n, "encoding", null);
            bl = this.parse(stringPartScan);
        }
        return bl;
    }

    public boolean parse(String string) {
        StringPartScan stringPartScan = new StringPartScan(string);
        return this.parse(stringPartScan);
    }

    public boolean parse(StringPartScan stringPartScan) {
        return this.parse(stringPartScan, null);
    }

    public boolean parse(StringPartScan stringPartScan, List<String> list) {
        Object object;
        ZbnfParserStore zbnfParserStore;
        this.nReportLevel = 0;
        this.parserStoreTopLevel = new ZbnfParserStore();
        this.posRightestError = 0L;
        this.lineError = 0;
        this.columnError = 0;
        this.sFileError = null;
        this.sExpectedSyntax = null;
        this.alreadyParsedCmpn.clear();
        this.sRightestError = stringPartScan.getCurrentPart(80);
        this.prescriptParserTopLevel = new PrescriptParser(null, this.mainScript, "topLevelSyntax", stringPartScan, 0);
        if (list != null) {
            zbnfParserStore = new ZbnfParserStore();
            object = list.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = object.hasNext() ? (String)object.next() : "";
                zbnfParserStore.addString(string2, string, null, stringPartScan, null, -1, -1, null);
            }
        } else {
            zbnfParserStore = null;
        }
        object = this.mainScript.getDefinitionIdent();
        try {
            boolean bl = this.prescriptParserTopLevel.parsePrescript1((String)object, this.mainScript, null, this.parserStoreTopLevel, zbnfParserStore, false, false, 0);
            return bl;
        }
        catch (Exception exception) {
            System.err.println("Parser Error" + exception.getMessage());
            exception.printStackTrace(System.err);
            return false;
        }
    }

    protected ZbnfSyntaxPrescript searchSyntaxPrescript(String string) {
        ZbnfSyntaxPrescript zbnfSyntaxPrescript = this.listSubPrescript.get(string);
        if (zbnfSyntaxPrescript == null) {
            if (this.idxMissingPrescripts == null) {
                this.idxMissingPrescripts = new TreeMap<String, String>();
            }
            this.idxMissingPrescripts.put(string, string);
        }
        return zbnfSyntaxPrescript;
    }

    public void reportSyntax(LogMessage logMessage, int n) {
        this.mainScript.reportContent(logMessage, n);
        for (String string : this.listSubPrescript.keySet()) {
            ZbnfSyntaxPrescript zbnfSyntaxPrescript = this.listSubPrescript.get(string);
            logMessage.reportln(n, 0, "");
            zbnfSyntaxPrescript.reportContent(logMessage, n);
        }
    }

    public void reportStore(LogMessage logMessage, int n, String string) {
        if (logMessage.getReportLevel() >= n) {
            logMessage.reportln(n, 0, "== LogMessage ParserStore " + string + " ==");
            this.reportStoreComponent(this.getFirstParseResult(), logMessage, 1, null, n);
            logMessage.flushReport();
        }
    }

    public void reportStore(LogMessage logMessage, int n) {
        this.reportStore(logMessage, n, "");
    }

    public void reportStore(LogMessage logMessage) {
        this.reportStore(logMessage, 4);
    }

    private int reportStoreComponent(ZbnfParseResultItem zbnfParseResultItem, LogMessage logMessage, int n, ZbnfParseResultItem zbnfParseResultItem2, int n2) {
        int n3 = 0;
        while (zbnfParseResultItem != null) {
            ++n3;
            logMessage.reportln(n2, 0, "parseResult: " + sEmpty.substring(0, n) + zbnfParseResultItem.getDescription());
            if (zbnfParseResultItem.isComponent()) {
                this.reportStoreComponent(zbnfParseResultItem.nextSkipIntoComponent(zbnfParseResultItem), logMessage, n + 1, zbnfParseResultItem, n2);
            }
            zbnfParseResultItem = zbnfParseResultItem.next(zbnfParseResultItem2);
        }
        return n3;
    }

    public String getInputEncodingKeyword() {
        return this.sInputEncodingKeyword;
    }

    public Charset getInputEncoding() {
        return this.charsetInput;
    }

    public String getExpectedSyntaxOnError() {
        return this.sExpectedSyntax;
    }

    public String getLastFoundedResultOnError() {
        String string = null;
        if (this.listParseResultOnError != null) {
            string = "";
            for (ZbnfParseResultItem zbnfParseResultItem : this.listParseResultOnError) {
                string = string + "\n" + zbnfParseResultItem.getDescription();
            }
        }
        return string;
    }

    public StringBuilder buildFoundedInputOnError() {
        StringBuilder stringBuilder = new StringBuilder(120);
        int n = this.getInputColumnOnError();
        int n2 = this.getInputLineOnError();
        String string = this.getInputFileOnError();
        stringBuilder.append("ZbnfParser ERROR ");
        if (string != null) {
            stringBuilder.append(" in file ").append((CharSequence)string);
        } else {
            stringBuilder.append("file not available (String given input) ");
        }
        stringBuilder.append("\n@char-pos: ");
        stringBuilder.append(this.getInputPositionOnError());
        stringBuilder.append("=0x" + Long.toString(this.getInputPositionOnError(), 16) + " ");
        if (n2 > 0 || n > 0) {
            stringBuilder.append(" @line, col: ").append(n2).append(", ").append(n);
        } else {
            stringBuilder.append(" @line, col: not available");
        }
        int n3 = stringBuilder.length() + 1;
        stringBuilder.append("\n  ...:").append(this.getRightestInputOnError());
        stringBuilder.append(" >>>>>").append(this.sRightestError);
        if (stringBuilder.length() < 80) {
            stringBuilder.append("<<<<end of file");
        }
        for (int i = n3; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (c != '\n' && c != '\r') continue;
            stringBuilder.setCharAt(i, '|');
        }
        return stringBuilder;
    }

    public String getFoundedInputOnError() {
        return this.buildFoundedInputOnError().toString();
    }

    public long getInputPositionOnError() {
        return this.posRightestError;
    }

    public String getRightestInputOnError() {
        return this.sInputMostRightError;
    }

    public int getInputLineOnError() {
        return this.lineError;
    }

    public int getInputColumnOnError() {
        return this.columnError;
    }

    public String getInputFileOnError() {
        return this.sFileError;
    }

    protected void throwSyntaxErrorException(String string) throws ParseException {
        throw new ParseException(string + this.getSyntaxErrorReport(), (int)this.getInputPositionOnError());
    }

    public String getSyntaxErrorReport() {
        String string = this.getLastFoundedResultOnError();
        StringBuilder stringBuilder = this.buildFoundedInputOnError();
        stringBuilder.append("\n expected: ----------------------------------------------");
        stringBuilder.append(this.getExpectedSyntaxOnError());
        stringBuilder.append("\n found before: ----------------------------------------------");
        stringBuilder.append(string == null ? "-nothing-" : string);
        stringBuilder.append("\n");
        if (this.idxMissingPrescripts != null) {
            for (Map.Entry<String, String> entry : this.idxMissingPrescripts.entrySet()) {
                stringBuilder.append("missing prescript: ").append(entry.getValue()).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public ZbnfParseResultItem getFirstParseResult() {
        if (this.parserStoreTopLevel.items.size() > 0) {
            return this.parserStoreTopLevel.items.get(0);
        }
        return null;
    }

    public void writeResultAsTextList(Appendable appendable) throws IOException {
        this.parserStoreTopLevel.writeContentAsList(appendable);
    }

    public XmlNode getResultTree() {
        if (this.parserStoreTopLevel.items.size() > 0) {
            ZbnfParserStore.ParseResultItemImplement parseResultItemImplement = this.parserStoreTopLevel.items.get(0);
            if (parseResultItemImplement.treeNodeXml == null) {
                this.builderTreeNodeXml.buildTreeNodeRepresentationXml(null, parseResultItemImplement, true);
            }
            return parseResultItemImplement.treeNodeXml;
        }
        return null;
    }

    public TreeNode_ifc<XmlNodeSimple<ZbnfParseResultItem>, ZbnfParseResultItem> getResultNode() {
        if (this.parserStoreTopLevel.items.size() > 0) {
            ZbnfParserStore.ParseResultItemImplement parseResultItemImplement = this.parserStoreTopLevel.items.get(0);
            assert (parseResultItemImplement.treeNodeXml instanceof TreeNodeBase);
            TreeNodeBase treeNodeBase = (TreeNodeBase)((Object)parseResultItemImplement.treeNodeXml);
            return treeNodeBase;
        }
        return null;
    }

    public TreeMap<String, String> getXmlnsFromSyntaxPrescript() {
        return this.xmlnsList;
    }

    public boolean setStoringConstantSyntax(boolean bl) {
        boolean bl2 = this.bConstantSyntaxAsParseResult;
        this.bConstantSyntaxAsParseResult = bl;
        return bl2;
    }

    public void clean() {
        this.alreadyParsedCmpn.clear();
        this.listParseResultOnError.clear();
        this.parserStoreTopLevel.items.clear();
        this.parserStoreTopLevel.item = null;
        this.prescriptParserTopLevel = null;
        System.gc();
    }

    private void stop() {
    }

    static CharSequence inputCurrent(StringPartScan stringPartScan) {
        StringBuilder stringBuilder = new StringBuilder(stringPartScan.getCurrent(40));
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (c == '\n') {
                stringBuilder.replace(i, i + 1, "|");
            }
            if (c != '\r') continue;
            stringBuilder.replace(i, i + 1, "-");
        }
        return stringBuilder;
    }

    static class ForkPoint {
        final long posInput;
        final int ixPrescript;
        final int ixParseResult;
        final boolean bSkipSpacesAndComment;

        ForkPoint(long l, int n, int n2, boolean bl) {
            this.posInput = l;
            this.ixPrescript = n;
            this.ixParseResult = n2;
            this.bSkipSpacesAndComment = bl;
        }
    }

    static class ParseResultlet {
        final ZbnfSyntaxPrescript syntaxPrescript;
        final long startPosText;
        long endPosText;
        ZbnfParserStore.ParseResultItemImplement[] parseResult;

        ParseResultlet(ZbnfSyntaxPrescript zbnfSyntaxPrescript, long l) {
            this.syntaxPrescript = zbnfSyntaxPrescript;
            this.startPosText = l;
        }

        public final String toString() {
            return this.syntaxPrescript.sDefinitionIdent;
        }
    }

    class LogZbnfParser {
        final StringBuilder componentsWhileParsing = new StringBuilder(4000);
        Appendable logComponents;
        final long time0 = System.currentTimeMillis();
        long timeLast;
        long zComonentsLast = 0L;

        LogZbnfParser() {
        }

        void write(StringPart stringPart) {
            try {
                int n = 0;
                int n2 = this.componentsWhileParsing.length();
                while (n2 - n > 150) {
                    n += 50;
                }
                String string = stringPart.getCurrent(30).toString().replace('\n', '\u00a7');
                int n3 = (int)stringPart.getCurrentPosition();
                int n4 = (int)(System.currentTimeMillis() - this.time0);
                int n5 = ((ZbnfParser)ZbnfParser.this).parserStoreTopLevel.items.size();
                this.logComponents.append("\n").append(Integer.toString(n3)).append(" ").append(string).append(" : ").append(Integer.toString(n4)).append(" ms ").append(Integer.toString(n5)).append("* ").append(Integer.toString(n)).append(this.componentsWhileParsing.subSequence(n, n2));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static class LogParsing {
        public int mLogParse;
        public static int mLogParseCmpn = 4;
        public static int mLogParseItem = 8;
        final StringFormatter line = new StringFormatter(250);
        final LogMessage logOut;

        LogParsing(LogMessage logMessage) {
            this.logOut = logMessage;
        }

        void reportParsing(String string, int n, ZbnfSyntaxPrescript zbnfSyntaxPrescript, String string2, StringPartScan stringPartScan, int n2, int n3, boolean bl) {
            int n4 = (int)(stringPartScan.getCurrentPosition() - (long)n2);
            this.line.reset().add(string).pos(10).addint(n3, "221").addint(n2, "22221").add('+').addint(n4, "221").add(": ").addReplaceLinefeed(stringPartScan.getPart(n2, 30), "|-||", 30).pos(50).add(bl ? "  ok    " : "  error ").add(zbnfSyntaxPrescript.toString()).pos(70).add(" in ").add(string2);
            this.logOut.reportln(n, this.line.getContent());
        }
    }

    class PrescriptParser {
        final ParseResultlet resultlet;
        protected final StringPartScan input;
        protected final int posInputbase;
        protected int srcLineOption = -1;
        protected final int[] srcColumnOption = new int[1];
        protected long srcPosOption;
        final PrescriptParser parentPrescriptParser;
        ZbnfParserStore parserStoreInPrescript;
        ZbnfParserStore parseResultToOtherComponent = null;
        int[] idxWholeParserStoreForInsertionsFromOuterToInnerLevels = new int[100];
        ZbnfParseResultItem[] parentInWholeParserStoreForInsertionsFromOuterToInnerLevels = new ZbnfParseResultItem[100];
        final String sSemanticIdent;
        final String sReportParentComponents;

        protected PrescriptParser(PrescriptParser prescriptParser, ZbnfSyntaxPrescript zbnfSyntaxPrescript, String string, StringPartScan stringPartScan, int n) {
            this.resultlet = new ParseResultlet(zbnfSyntaxPrescript, stringPartScan.getCurrentPosition());
            this.parentPrescriptParser = prescriptParser;
            this.input = stringPartScan;
            this.posInputbase = n;
            this.sSemanticIdent = string;
            this.sReportParentComponents = (prescriptParser != null ? prescriptParser.sReportParentComponents : "") + "+" + string;
        }

        public boolean parsePrescript1(String string, ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, ZbnfParserStore zbnfParserStore, ZbnfParserStore zbnfParserStore2, boolean bl, boolean bl2, int n) throws ParseException {
            int n2 = 0;
            if (ZbnfParser.this.log1.logComponents != null) {
                n2 = ZbnfParser.this.log1.componentsWhileParsing.length();
                ZbnfParser.this.log1.componentsWhileParsing.append("->").append(zbnfSyntaxPrescript.sDefinitionIdent);
                ZbnfParser.this.log1.write(this.input);
            }
            this.parserStoreInPrescript = zbnfParserStore;
            int n3 = this.parserStoreInPrescript.items.size();
            int n4 = -1;
            SubParser subParser = new SubParser(null, parseResultItemImplement, bl2, n);
            boolean bl3 = subParser.parseSub(this.resultlet.syntaxPrescript, "::=", -32766, zbnfSyntaxPrescript, string, parseResultItemImplement, bl, zbnfParserStore2, n);
            if (!bl3 && n4 >= 0) {
                this.parserStoreInPrescript.setCurrentPosition(n4);
            }
            if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportComponentParsing) {
                ZbnfParser.this.log.reportParsing("parseComp ", ZbnfParser.this.idReportComponentParsing, this.resultlet.syntaxPrescript, this.sReportParentComponents, this.input, (int)this.input.getCurrentPosition(), n, bl3);
            }
            if (bl3) {
                Object object;
                if (n3 < this.parserStoreInPrescript.items.size()) {
                    object = this.parserStoreInPrescript.items.get(n3);
                    int n5 = this.parserStoreInPrescript.items.size() - n3;
                    this.resultlet.parseResult = new ZbnfParserStore.ParseResultItemImplement[n5];
                    for (int i = 0; i < n5; ++i) {
                        this.resultlet.parseResult[i] = this.parserStoreInPrescript.items.get(n3 + i);
                    }
                } else {
                    this.resultlet.parseResult = null;
                }
                this.resultlet.endPosText = this.input.getCurrentPosition();
                object = String.format("%9d", this.resultlet.startPosText) + this.resultlet.syntaxPrescript.sDefinitionIdent;
                ZbnfParser.this.alreadyParsedCmpn.put((String)object, this.resultlet);
            }
            if (ZbnfParser.this.log1.logComponents != null) {
                ZbnfParser.this.log1.componentsWhileParsing.setLength(n2);
            }
            return bl3;
        }

        class SubParser {
            private final int nRecursion;
            int xxxidxAlternative;
            String sSemanticForError;
            long posStoreSrc;
            String semanticStoreSrc = null;
            final boolean bDoNotStoreData;
            final SubParser parentParser;
            final ZbnfParserStore.ParseResultItemImplement parentOfParentResultItem;
            private final int[] srcColumn = new int[1];
            private int srcLine;

            protected SubParser(SubParser subParser, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, boolean bl, int n) {
                this.parentParser = subParser;
                this.bDoNotStoreData = bl;
                this.parentOfParentResultItem = parseResultItemImplement;
                this.nRecursion = n;
            }

            private void init() {
                if (PrescriptParser.this.parseResultToOtherComponent != null) {
                    PrescriptParser.this.parseResultToOtherComponent = null;
                }
            }

            public boolean parseSub(ZbnfSyntaxPrescript zbnfSyntaxPrescript, String string, int n, ZbnfSyntaxPrescript zbnfSyntaxPrescript2, String string2, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, boolean bl, ZbnfParserStore zbnfParserStore, int n2) throws ParseException {
                int n3;
                Object object;
                int n4;
                ZbnfParserStore.ParseResultItemImplement parseResultItemImplement2;
                String string3;
                long l;
                boolean bl2 = false;
                if (n2 > 300) {
                    Debugutil.stop();
                    throw new IllegalArgumentException("to deep recursion");
                }
                this.sSemanticForError = string;
                String string4 = PrescriptParser.this.sSemanticIdent;
                String string5 = string2 != null && string2.equals("@") ? zbnfSyntaxPrescript.getSemantic() : string2;
                if (zbnfSyntaxPrescript.getSemantic() != null) {
                    this.sSemanticForError = zbnfSyntaxPrescript.getSemantic();
                }
                long l2 = PrescriptParser.this.input.getCurrentPosition();
                if (bl && n == -32763 && string5 != null) {
                    this.parseWhiteSpaceAndComment();
                    l = PrescriptParser.this.input.getCurrentPosition();
                    PrescriptParser.this.input.setCurrentPosition(l2);
                } else {
                    l = l2;
                }
                int n5 = -1;
                if (zbnfSyntaxPrescript2 != null && zbnfSyntaxPrescript2.bDebugParsing) {
                    Debugutil.stop();
                }
                if (string5 != null && string5.length() > 0 && !this.bDoNotStoreData) {
                    this.srcLine = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                    string3 = PrescriptParser.this.input.getInputfile();
                    parseResultItemImplement2 = PrescriptParser.this.parserStoreInPrescript.add(string5, zbnfSyntaxPrescript2, zbnfSyntaxPrescript, null, n, 0L, 0L, this.srcLine, this.srcColumn[0], string3, this.parentOfParentResultItem);
                    n5 = n4 = PrescriptParser.this.parserStoreInPrescript.items.size() - 1;
                    parseResultItemImplement = parseResultItemImplement2;
                } else {
                    n4 = -1;
                    parseResultItemImplement2 = null;
                    parseResultItemImplement = this.parentOfParentResultItem;
                }
                if (zbnfParserStore != null && !this.bDoNotStoreData) {
                    int n6 = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                    PrescriptParser.this.parserStoreInPrescript.insert(zbnfParserStore, n6, parseResultItemImplement);
                    if (n5 == -1) {
                        n5 = n6;
                    }
                }
                if ((((ZbnfParser)ZbnfParser.this).log.mLogParse & LogParsing.mLogParseCmpn) != 0) {
                    string3 = "parseSub                " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " semantic=" + string5 + " errormsg=" + this.sSemanticForError;
                    ZbnfParser.this.report.reportln(ZbnfParser.this.nLevelReportParsing, string3);
                }
                int n7 = -1;
                boolean bl3 = false;
                if (zbnfSyntaxPrescript.isAlternative()) {
                    object = zbnfSyntaxPrescript.getListPrescripts();
                    Iterator<ZbnfSyntaxPrescript> iterator = object.iterator();
                    while (!bl3 && iterator.hasNext()) {
                        ++n7;
                        ZbnfSyntaxPrescript zbnfSyntaxPrescript3 = iterator.next();
                        String string6 = zbnfSyntaxPrescript3.getSemantic();
                        if (string6 != null) {
                            SubParser subParser = new SubParser(this, parseResultItemImplement, this.bDoNotStoreData || zbnfSyntaxPrescript.bDonotStoreData, this.nRecursion + 1);
                            bl3 = subParser.parseSub(zbnfSyntaxPrescript3, "..|..|..", -32763, null, "@", parseResultItemImplement, bl, null, n2 + 1);
                        } else {
                            bl3 = this.parsePrescript(zbnfSyntaxPrescript3, parseResultItemImplement, bl, this.bDoNotStoreData, n2);
                        }
                        if (ZbnfParser.this.nReportLevel < 6) continue;
                        ZbnfParser.this.report.reportln(6, "parse Error, reset to:  " + PrescriptParser.this.input.getCurrent(30) + "...... idxResult = " + PrescriptParser.this.parserStoreInPrescript.getNextPosition() + " idxAlternative = " + n7);
                    }
                    n3 = (int)PrescriptParser.this.input.getCurrentPosition();
                    if (ZbnfParser.this.dbgPosFrom > 0 && (n3 = (int)l2) >= ZbnfParser.this.dbgPosFrom && n3 < ZbnfParser.this.dbgPosTo) {
                        Debugutil.stop();
                    }
                } else {
                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parse subPrescript;     " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") alternative=" + n7);
                    }
                    bl3 = this.parsePrescript(zbnfSyntaxPrescript, parseResultItemImplement, bl, this.bDoNotStoreData, n2);
                }
                if (bl3) {
                    bl2 = true;
                }
                if (!bl2) {
                    if (n5 >= 0) {
                        PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n5);
                    }
                    object = null;
                } else {
                    long l3 = PrescriptParser.this.input.getCurrentPosition();
                    if (parseResultItemImplement2 != null && l <= l3) {
                        object = PrescriptParser.this.input.getPart((int)l, (int)(PrescriptParser.this.input.getCurrentPosition() - l));
                        if (parseResultItemImplement2.kind != -32766 && parseResultItemImplement2.parsedString == null) {
                            parseResultItemImplement2.parsedString = ((StringPart.Part)object).toString();
                        }
                        if (ZbnfParser.this.args.bStoreInputForComponent || zbnfSyntaxPrescript2 != null && zbnfSyntaxPrescript2.bStoreAsString) {
                            parseResultItemImplement2.sInput = ((StringPart.Part)object).toString();
                        }
                    } else {
                        object = null;
                    }
                }
                if (!bl2 && zbnfSyntaxPrescript.isPossibleEmptyOption()) {
                    bl2 = true;
                    n7 = -1;
                } else if (bl2 && n4 >= 0) {
                    n7 = n7 == 0 && !zbnfSyntaxPrescript.hasAlternatives() ? -1 : ++n7;
                    if (!this.bDoNotStoreData) {
                        PrescriptParser.this.parserStoreInPrescript.setAlternativeAndOffsetToEnd(n4, n7);
                        if (n == -32763 && object != null) assert (parseResultItemImplement2 != null);
                    }
                }
                if (zbnfSyntaxPrescript.sSubSyntax != null) {
                    int n8 = parseResultItemImplement.srcLine;
                    n3 = parseResultItemImplement.srcColumn;
                    long l4 = parseResultItemImplement.start;
                    String string7 = parseResultItemImplement.sFile;
                    bl2 = this.addResultOrSubsyntax((CharSequence)object, l4, n8, n3, string7, string5, parseResultItemImplement, zbnfSyntaxPrescript);
                }
                if (!bl2 && n5 >= 0) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseSub not found;     " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " error parsing, remove items from result buffer, before=" + PrescriptParser.this.parserStoreInPrescript.items.size());
                    ZbnfParser.this.report.report(ZbnfParser.this.idReportParsing, " after=" + PrescriptParser.this.parserStoreInPrescript.items.size());
                }
                return bl2;
            }

            boolean parsePrescript(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, boolean bl, boolean bl2, int n) throws ParseException {
                Object object;
                List<ZbnfSyntaxPrescript> list = zbnfSyntaxPrescript.getListPrescripts();
                boolean bl3 = bl;
                boolean bl4 = false;
                long l = PrescriptParser.this.input.getCurrentPosition();
                int n2 = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                LinkedList<Object> linkedList = null;
                boolean bl5 = false;
                int n3 = 0;
                do {
                    Object object2;
                    bl4 = true;
                    while (bl4 && n3 < list.size()) {
                        ZbnfSyntaxPrescript.EType eType;
                        while (n3 < list.size() && list.get(n3).getType() == ZbnfSyntaxPrescript.EType.kSkipSpaces) {
                            ++n3;
                            bl3 = true;
                        }
                        if (n3 >= list.size()) continue;
                        object2 = list.get(n3);
                        if (((ZbnfSyntaxPrescript)object2).bDebugParsing) {
                            Debugutil.stop();
                        }
                        if ((eType = ((ZbnfSyntaxPrescript)object2).getType()) == ZbnfSyntaxPrescript.EType.kAlternativeOptionCheckEmptyFirst && !bl5) {
                            if (linkedList == null) {
                                linkedList = new LinkedList<Object>();
                            }
                            object = new ForkPoint(PrescriptParser.this.input.getCurrentPosition(), n3, PrescriptParser.this.parserStoreInPrescript.getNextPosition(), bl3);
                            linkedList.add(object);
                            ++n3;
                            continue;
                        }
                        bl4 = this.parseItem((ZbnfSyntaxPrescript)object2, parseResultItemImplement, bl3, n);
                        if (eType == ZbnfSyntaxPrescript.EType.kAlternativeOptionCheckEmptyFirst) {
                            bl5 = false;
                            if (bl4) {
                                Debugutil.stop();
                            }
                        }
                        bl3 = false;
                        if (!bl4) continue;
                        ++n3;
                    }
                    if (bl3) {
                        // empty if block
                    }
                    if (!bl4 && this.semanticStoreSrc != null) {
                        this.semanticStoreSrc = null;
                        this.posStoreSrc = 0L;
                    }
                    if (!bl4 && linkedList != null) {
                        object2 = (ForkPoint)linkedList.remove(linkedList.size() - 1);
                        if (linkedList.size() == 0) {
                            linkedList = null;
                        }
                        PrescriptParser.this.input.setCurrentPosition(((ForkPoint)object2).posInput);
                        PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(((ForkPoint)object2).ixParseResult);
                        n3 = ((ForkPoint)object2).ixPrescript;
                        bl3 = ((ForkPoint)object2).bSkipSpacesAndComment;
                        bl5 = true;
                        continue;
                    }
                    bl5 = false;
                } while (bl5);
                if (!bl4) {
                    PrescriptParser.this.input.setCurrentPosition(l);
                    PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n2);
                }
                if (this.semanticStoreSrc != null) {
                    long l2 = PrescriptParser.this.input.getCurrentPosition();
                    object = PrescriptParser.this.input.getCharSequenceRange(this.posStoreSrc, -1L).toString();
                    PrescriptParser.this.parserStoreInPrescript.add(this.semanticStoreSrc, null, null, (CharSequence)object, 0, this.posStoreSrc, l2, 0, 0, null, null);
                }
                return bl4;
            }

            private boolean parseItem(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, boolean bl, int n) throws ParseException {
                boolean bl2;
                boolean bl3;
                int n2;
                String string = zbnfSyntaxPrescript.getConstantSyntax();
                String string2 = zbnfSyntaxPrescript.getDefinitionIdent();
                String string3 = zbnfSyntaxPrescript.getSemantic();
                ZbnfSyntaxPrescript zbnfSyntaxPrescript2 = null;
                if (zbnfSyntaxPrescript.bDebugParsing) {
                    Debugutil.stop();
                }
                CharSequence charSequence = PrescriptParser.this.input.getCurrent(80);
                if (string3 != null && string3.length() == 0) {
                    string3 = null;
                }
                if (string3 != null) {
                    this.sSemanticForError = string3;
                    if (string3.equals("semantic")) {
                        ZbnfParser.this.stop();
                    }
                }
                if ((n2 = zbnfSyntaxPrescript.getMaxNrofCharsFromComplexItem()) < -1) {
                    ZbnfParser.this.stop();
                }
                ZbnfSyntaxPrescript.EType eType = zbnfSyntaxPrescript.getType();
                long l = PrescriptParser.this.input.getCurrentPosition();
                String string4 = null;
                if (bl) {
                    String string5;
                    if (eType == ZbnfSyntaxPrescript.EType.kTerminalSymbolInComment) {
                        string5 = zbnfSyntaxPrescript.getConstantSyntax();
                        string4 = ZbnfParser.this.nReportLevel < ZbnfParser.this.nLevelReportBranchParsing ? "" : "parsSpace " + PrescriptParser.this.input.getCurrentPosition() + " " + ZbnfParser.inputCurrent(PrescriptParser.this.input);
                    } else {
                        string5 = null;
                    }
                    bl2 = bl3 = this.parseWhiteSpaceAndCommentOrTerminalSymbol(string5, parseResultItemImplement);
                } else {
                    bl3 = false;
                    bl2 = false;
                }
                if (!bl3) {
                    Object object;
                    int n3;
                    if (PrescriptParser.this.input.getCurrentPosition() == 704L) {
                        ZbnfParser.this.stop();
                    }
                    if (PrescriptParser.this.input.startsWith("\r\n#include")) {
                        ZbnfParser.this.stop();
                    }
                    long l2 = PrescriptParser.this.input.getCurrentPosition();
                    PrescriptParser.this.input.setCurrentPosition(l);
                    l = l2;
                    if (ZbnfParser.this.dbgPosFrom > 0 && (n3 = (int)l) >= ZbnfParser.this.dbgPosFrom && n3 <= ZbnfParser.this.dbgPosTo && (ZbnfParser.this.dbgLineSyntax == 0 || ZbnfParser.this.dbgLineSyntax == zbnfSyntaxPrescript.lineFile)) {
                        Debugutil.stop();
                    }
                    if ((((ZbnfParser)ZbnfParser.this).log.mLogParse & LogParsing.mLogParseItem) != 0) {
                        String string6 = "" + PrescriptParser.this.input.getLineAndColumn(null) + ":" + PrescriptParser.this.input.getCurrent(20) + "-?-" + zbnfSyntaxPrescript.lineFile;
                        object = zbnfSyntaxPrescript;
                        do {
                            string6 = string6 + " - " + ((ZbnfSyntaxPrescript)object).sDefinitionIdent;
                        } while ((object = ((ZbnfSyntaxPrescript)object).parent) != null && string6.length() < 120);
                        ZbnfParser.this.report.reportln(3, string6);
                    }
                    switch (eType) {
                        case kSyntaxDefinition: 
                        case kAlternative: 
                        case kSimpleOption: 
                        case kAlternativeOption: 
                        case kAlternativeOptionCheckEmptyFirst: {
                            if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportBranchParsing) {
                                ZbnfParser.this.log.reportParsing("Opti " + PrescriptParser.this.input.getCurrentPosition() + " " + ZbnfParser.inputCurrent(PrescriptParser.this.input), ZbnfParser.this.idReportBranchParsing, zbnfSyntaxPrescript, PrescriptParser.this.sReportParentComponents, PrescriptParser.this.input, (int)PrescriptParser.this.input.getCurrentPosition(), this.nRecursion, true);
                            }
                            bl2 = this.parseOptions(zbnfSyntaxPrescript, parseResultItemImplement, bl, n);
                            break;
                        }
                        case kNegativVariant: {
                            bl2 = this.parseNegativVariant(zbnfSyntaxPrescript, bl, n);
                            break;
                        }
                        case kUnconditionalVariant: {
                            bl2 = this.parseUnconditionalVariant(zbnfSyntaxPrescript, parseResultItemImplement, bl, n);
                            break;
                        }
                        case kExpectedVariant: {
                            bl2 = this.parseExpectedVariant(zbnfSyntaxPrescript, bl, n);
                            break;
                        }
                        case kRepetition: {
                            bl2 = this.parseRepetition(zbnfSyntaxPrescript, zbnfSyntaxPrescript.getRepetitionBackwardPrescript(), parseResultItemImplement, bl, n);
                            break;
                        }
                        case kOnlySemantic: {
                            bl2 = true;
                            if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseItem only Semantic;" + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseSemantic(" + this.nRecursion + ") <?" + this.sSemanticForError + ">");
                            }
                            if (this.bDoNotStoreData) break;
                            this.srcLine = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                            String string7 = PrescriptParser.this.input.getInputfile();
                            if (string3 != null) {
                                PrescriptParser.this.parserStoreInPrescript.addSemantic(string3, zbnfSyntaxPrescript, parseResultItemImplement, this.srcLine, this.srcColumn[0], string7);
                                break;
                            }
                            Debugutil.stop();
                            break;
                        }
                        case kSyntaxComponent: {
                            zbnfSyntaxPrescript2 = zbnfSyntaxPrescript.componentSyntax;
                            if (zbnfSyntaxPrescript2 == null) {
                                zbnfSyntaxPrescript2 = zbnfSyntaxPrescript.componentSyntax = ZbnfParser.this.searchSyntaxPrescript(string2);
                            }
                            if (zbnfSyntaxPrescript2 == null) {
                                bl2 = false;
                                ZbnfParser.this.report.reportln(1, "parse - Syntaxprescript not found:" + string2);
                                String string8 = "prescript for : <" + string2 + (!this.sSemanticForError.equals("@") && !this.sSemanticForError.equals("?") ? "?" + this.sSemanticForError : "") + "> not found.";
                                this.saveError(string8);
                                break;
                            }
                            if (string3 != null && string3.equals("@")) {
                                string3 = zbnfSyntaxPrescript2.getSemantic();
                            }
                            bl2 = this.parse_Component(PrescriptParser.this.input, PrescriptParser.this.posInputbase, zbnfSyntaxPrescript2, string3, parseResultItemImplement, bl, this.bDoNotStoreData || zbnfSyntaxPrescript.bDonotStoreData, zbnfSyntaxPrescript, zbnfSyntaxPrescript.isResultToAssignIntoNextComponent(), zbnfSyntaxPrescript.isToAddOuterResults());
                            break;
                        }
                        case kOnlyMarker: {
                            bl2 = true;
                            break;
                        }
                        default: {
                            PrescriptParser.this.input.setCurrentPosition(l);
                            n3 = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                            assert (!bl2);
                            object = null;
                            string4 = ZbnfParser.this.nReportLevel < ZbnfParser.this.nLevelReportBranchParsing ? "" : "item " + PrescriptParser.this.input.getCurrentPosition() + " " + ZbnfParser.inputCurrent(PrescriptParser.this.input);
                            switch (eType) {
                                case kTerminalSymbolInComment: 
                                case kTerminalSymbol: {
                                    bl2 = this.parseTerminalSymbol(zbnfSyntaxPrescript, parseResultItemImplement);
                                    break;
                                }
                                case kStoreSrc: {
                                    this.posStoreSrc = PrescriptParser.this.input.getCurrentPosition();
                                    this.semanticStoreSrc = zbnfSyntaxPrescript.sSemantic;
                                    bl2 = true;
                                    break;
                                }
                                case kIdentifier: {
                                    bl2 = this.parseIdentifier(string, string3, parseResultItemImplement);
                                    break;
                                }
                                case kPositivNumber: {
                                    bl2 = this.parsePositiveInteger(zbnfSyntaxPrescript, parseResultItemImplement, n2);
                                    break;
                                }
                                case kHexNumber: {
                                    bl2 = this.parseHexNumber(zbnfSyntaxPrescript, parseResultItemImplement, n2);
                                    break;
                                }
                                case kNumberRadix: {
                                    bl2 = this.parseNumberRadix(zbnfSyntaxPrescript, parseResultItemImplement, n2);
                                    break;
                                }
                                case kIntegerNumber: {
                                    bl2 = this.parseInteger(zbnfSyntaxPrescript, parseResultItemImplement, n2);
                                    break;
                                }
                                case kFloatNumber: 
                                case kFloatWithFactor: {
                                    bl2 = this.parseFloatNumber(zbnfSyntaxPrescript, n2, parseResultItemImplement);
                                    break;
                                }
                                case kStringUntilEndchar: {
                                    if (string3 != null && string3.equals("TESTrest")) {
                                        ZbnfParser.this.stop();
                                    }
                                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseItem StrTilEndchar;" + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <*" + string + "?" + this.sSemanticForError + ">");
                                    }
                                    if (string.length() > 0) {
                                        bl2 = PrescriptParser.this.input.lentoAnyChar(string, n2).found();
                                    } else {
                                        int n4 = PrescriptParser.this.input.length();
                                        if (n2 < n4) {
                                            PrescriptParser.this.input.lento(n2);
                                        }
                                        bl2 = true;
                                    }
                                    if (bl2) {
                                        object = PrescriptParser.this.input.getCurrentPart();
                                        break;
                                    }
                                    PrescriptParser.this.input.setLengthMax();
                                    this.saveError("ones of terminate chars \"" + string + "\" not found <?" + this.sSemanticForError + ">");
                                    break;
                                }
                                case kStringUntilRightEndchar: {
                                    bl2 = this.parseStringUntilRightEndchar(string, false, n2, string3, parseResultItemImplement, zbnfSyntaxPrescript);
                                    break;
                                }
                                case kStringUntilRightEndcharInclusive: {
                                    bl2 = this.parseStringUntilRightEndchar(string, true, n2, string3, parseResultItemImplement, zbnfSyntaxPrescript);
                                    break;
                                }
                                case kStringUntilEndString: {
                                    bl2 = this.parseStringUntilTerminateString(string, false, false, n2, string3, parseResultItemImplement, zbnfSyntaxPrescript);
                                    break;
                                }
                                case kStringUntilEndStringTrim: {
                                    bl2 = this.parseStringUntilTerminateString(string, false, true, n2, string3, parseResultItemImplement, zbnfSyntaxPrescript);
                                    break;
                                }
                                case kStringUntilEndStringInclusive: {
                                    bl2 = this.parseStringUntilTerminateString(string, true, false, n2, string3, parseResultItemImplement, zbnfSyntaxPrescript);
                                    break;
                                }
                                case kStringUntilEndStringWithIndent: {
                                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseItem-StrTilEndInde;" + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <*" + string + "?" + this.sSemanticForError + ">");
                                    }
                                    StringBuilder stringBuilder = new StringBuilder();
                                    PrescriptParser.this.input.setLengthMax().lentoAnyStringWithIndent(zbnfSyntaxPrescript.getListStrings().toArray(new String[1]), zbnfSyntaxPrescript.getIndentChars(), n2, stringBuilder);
                                    if (PrescriptParser.this.input.found()) {
                                        object = stringBuilder;
                                        break;
                                    }
                                    PrescriptParser.this.input.setLengthMax();
                                    this.saveError("ones of terminate strings not found <?" + this.sSemanticForError + ">");
                                    break;
                                }
                                case kStringUntilEndcharOutsideQuotion: {
                                    bl2 = this.parseNoOrSomeCharsOutsideQuotion(string, n2, string3, parseResultItemImplement, zbnfSyntaxPrescript);
                                    break;
                                }
                                case kQuotedString: {
                                    bl2 = this.parseSimpleStringLiteral(string, n2, string3, parseResultItemImplement, zbnfSyntaxPrescript);
                                    break;
                                }
                                case kRegularExpression: {
                                    bl2 = this.parseRegularExpression(zbnfSyntaxPrescript, string3, parseResultItemImplement, bl);
                                    break;
                                }
                                default: {
                                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseItem-default;      " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseSemantic(" + this.nRecursion + ") <?" + this.sSemanticForError + ">");
                                    }
                                    bl2 = false;
                                }
                            }
                            if (object != null) {
                                if (StringFunctions.startsWith((CharSequence)object, "First line")) {
                                    ZbnfParser.this.stop();
                                }
                                long l3 = PrescriptParser.this.input.getCurrentPosition();
                                int n5 = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                                bl2 = this.addResultOrSubsyntax((CharSequence)object, l3, n5, this.srcColumn[0], PrescriptParser.this.input.getInputfile(), string3, parseResultItemImplement, zbnfSyntaxPrescript);
                                PrescriptParser.this.input.fromEnd();
                            }
                            if (!bl2) {
                                PrescriptParser.this.input.setCurrentPosition(l);
                                PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n3);
                            }
                            if (ZbnfParser.this.nReportLevel < ZbnfParser.this.nLevelReportBranchParsing) break;
                            ZbnfParser.this.log.reportParsing(string4, ZbnfParser.this.idReportBranchParsing, zbnfSyntaxPrescript, PrescriptParser.this.sReportParentComponents, PrescriptParser.this.input, (int)l, this.nRecursion, bl2);
                        }
                    }
                }
                if (bl2 && zbnfSyntaxPrescript.bStoreAsString && !this.bDoNotStoreData) {
                    this.srcLine = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                    String string9 = PrescriptParser.this.input.getInputfile();
                    int n6 = (int)(PrescriptParser.this.input.getCurrentPosition() - l);
                    StringPart.Part part = PrescriptParser.this.input.getPart((int)l, n6);
                    PrescriptParser.this.parserStoreInPrescript.add(string3, zbnfSyntaxPrescript, zbnfSyntaxPrescript2, part, -32756, 0L, 0L, this.srcLine, this.srcColumn[0], string9, this.parentOfParentResultItem);
                }
                if ((((ZbnfParser)ZbnfParser.this).log.mLogParse & LogParsing.mLogParseItem) != 0) {
                    String string10 = bl2 ? " ok " : " ERROR";
                    ZbnfParser.this.report.report(3, string10);
                }
                if (ZbnfParser.this.dbgPosFrom > 0 && l >= (long)ZbnfParser.this.dbgPosFrom && l <= (long)ZbnfParser.this.dbgPosTo && (ZbnfParser.this.dbgLineSyntax == 0 || ZbnfParser.this.dbgLineSyntax == zbnfSyntaxPrescript.lineFile)) {
                    Debugutil.stop();
                }
                return bl2;
            }

            private boolean parseWhiteSpaceAndComment() {
                return this.parseWhiteSpaceAndCommentOrTerminalSymbol(null, null);
            }

            private boolean parseWhiteSpaceAndCommentOrTerminalSymbol(String string, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement) {
                boolean bl;
                boolean bl2;
                long l = PrescriptParser.this.input.getCurrentPosition();
                long l2 = PrescriptParser.this.input.getCurrentPosition();
                CharSequence charSequence = PrescriptParser.this.input.getCurrent(40);
                do {
                    long l3;
                    bl2 = false;
                    if (string != null && string.charAt(0) == '\u0003' && PrescriptParser.this.input.length() == 0) {
                        bl = true;
                        bl2 = false;
                        if (ZbnfParser.this.nReportLevel < ZbnfParser.this.nLevelReportParsing) continue;
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseWhiteSpace;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse Ok EndOfText:");
                        continue;
                    }
                    if (string != null && PrescriptParser.this.input.startsWith(string)) {
                        bl = true;
                        bl2 = false;
                        if (string.equals("<:>")) {
                            ZbnfParser.this.stop();
                        }
                        l3 = PrescriptParser.this.input.getCurrentPosition();
                        this.srcLine = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                        String string2 = PrescriptParser.this.input.getInputfile();
                        PrescriptParser.this.input.seek(string.length());
                        if (ZbnfParser.this.bConstantSyntaxAsParseResult && !this.bDoNotStoreData) {
                            PrescriptParser.this.srcLineOption = -1;
                            PrescriptParser.this.parserStoreInPrescript.addConstantSyntax(null, string, l3, PrescriptParser.this.input.getCurrentPosition(), this.srcLine, this.srcColumn[0], string2, parseResultItemImplement);
                        } else {
                            if (PrescriptParser.this.srcLineOption == -1) {
                                PrescriptParser.this.srcLineOption = this.srcLine;
                                PrescriptParser.this.srcColumnOption[0] = this.srcColumn[0];
                                PrescriptParser.this.srcPosOption = l3;
                            }
                            if (parseResultItemImplement != null) {
                                parseResultItemImplement.setSrcLineColumnFileInParent(l3, PrescriptParser.this.input.getCurrentPosition(), this.srcLine, this.srcColumn[0], string2);
                            }
                        }
                        if (ZbnfParser.this.nReportLevel < ZbnfParser.this.nLevelReportParsing) continue;
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseConstInComment;    " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse Ok Terminal:" + string);
                        continue;
                    }
                    bl = false;
                    PrescriptParser.this.input.seekNoChar(ZbnfParser.this.sWhiteSpaces);
                    l3 = PrescriptParser.this.input.getCurrentPosition();
                    if (l3 > l2) {
                        bl2 = true;
                        l2 = l3;
                    }
                    if (!bl2 && ZbnfParser.this.sCommentStringStart != null && PrescriptParser.this.input.startsWith(ZbnfParser.this.sCommentStringStart)) {
                        PrescriptParser.this.input.lento(ZbnfParser.this.sCommentStringEnd, 1);
                        if (PrescriptParser.this.input.length() > 0) {
                            bl2 = true;
                            PrescriptParser.this.input.fromEnd();
                            l2 = PrescriptParser.this.input.getCurrentPosition();
                        }
                    }
                    if (bl2 || ZbnfParser.this.sEndlineCommentStringStart == null || !PrescriptParser.this.input.startsWith(ZbnfParser.this.sEndlineCommentStringStart)) continue;
                    PrescriptParser.this.input.lento("\n");
                    if (PrescriptParser.this.input.length() <= 0) continue;
                    bl2 = true;
                    PrescriptParser.this.input.fromEnd();
                    l2 = PrescriptParser.this.input.getCurrentPosition();
                } while (bl2);
                if (string != null && !bl) {
                    this.saveError("\"" + string + "\"");
                    PrescriptParser.this.input.setCurrentPosition(l);
                    int n = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                    PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n);
                }
                return bl;
            }

            private boolean parseTerminalSymbol(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement) {
                boolean bl;
                long l = PrescriptParser.this.input.getCurrentPosition();
                this.srcLine = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                String string = PrescriptParser.this.input.getInputfile();
                String string2 = zbnfSyntaxPrescript.getConstantSyntax();
                if (PrescriptParser.this.input.scanStart().scan(string2).scanOk()) {
                    bl = true;
                    if (ZbnfParser.this.bConstantSyntaxAsParseResult && !this.bDoNotStoreData) {
                        PrescriptParser.this.srcLineOption = -1;
                        PrescriptParser.this.parserStoreInPrescript.addConstantSyntax(zbnfSyntaxPrescript, string2, l, PrescriptParser.this.input.getCurrentPosition(), this.srcLine, this.srcColumn[0], string, parseResultItemImplement);
                    } else {
                        if (PrescriptParser.this.srcLineOption == -1) {
                            PrescriptParser.this.srcLineOption = this.srcLine;
                            PrescriptParser.this.srcColumnOption[0] = this.srcColumn[0];
                            PrescriptParser.this.srcPosOption = l;
                        }
                        if (parseResultItemImplement != null) {
                            parseResultItemImplement.setSrcLineColumnFileInParent(l, PrescriptParser.this.input.getCurrentPosition(), this.srcLine, this.srcColumn[0], string);
                        }
                    }
                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseTerminalSymbol;    " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse Ok Terminal:" + string2);
                    }
                } else {
                    bl = false;
                    this.saveError("\"" + string2 + "\"");
                }
                return bl;
            }

            private boolean parseRegularExpression(ZbnfSyntaxPrescript zbnfSyntaxPrescript, String string, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, boolean bl) throws ParseException {
                Pattern pattern = zbnfSyntaxPrescript.getRegexPatternFromComplexItem();
                String string2 = pattern.pattern();
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRegex;             " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseRegex(" + this.nRecursion + ") <!" + string2 + "?" + this.sSemanticForError + ">");
                }
                StringPart.Part part = PrescriptParser.this.input.getCurrentPart();
                Matcher matcher = pattern.matcher(part);
                boolean bl2 = true;
                matcher.lookingAt();
                int n = -1;
                try {
                    n = matcher.end();
                }
                catch (IllegalStateException illegalStateException) {
                    bl2 = false;
                    String string3 = illegalStateException.getMessage();
                    this.saveError("regex: <!" + string2 + "?" + this.sSemanticForError + "> illegalStateException:" + string3);
                }
                if (bl2) {
                    PrescriptParser.this.input.lento(n);
                    StringPart.Part part2 = PrescriptParser.this.input.getCurrentPart();
                    long l = PrescriptParser.this.input.getCurrentPosition();
                    int n2 = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                    bl2 = this.addResultOrSubsyntax(part2, l, n2, this.srcColumn[0], PrescriptParser.this.input.getInputfile(), string, parseResultItemImplement, zbnfSyntaxPrescript);
                    if (bl2) {
                        PrescriptParser.this.input.fromEnd();
                    }
                }
                return bl2;
            }

            private boolean parseIdentifier(String string, String string2, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement) {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseIdentifier;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseIdentifier(" + this.nRecursion + ") <$?" + this.sSemanticForError + ">");
                }
                PrescriptParser.this.input.lentoIdentifier(null, string);
                if (PrescriptParser.this.input.length() > 0) {
                    String string3 = PrescriptParser.this.input.getCurrentPart().toString();
                    if (string3.equals("way1Sensor") && PrescriptParser.this.parentPrescriptParser.parseResultToOtherComponent != null) {
                        ZbnfParser.this.stop();
                    }
                    if (ZbnfParser.this.listKeywords.get(string3) != null) {
                        bl = false;
                        PrescriptParser.this.input.setLengthMax();
                    } else {
                        bl = true;
                        if (string2 != null && !this.bDoNotStoreData) {
                            this.srcLine = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                            PrescriptParser.this.parserStoreInPrescript.addIdentifier(string2, null, string3, parseResultItemImplement, this.srcLine, this.srcColumn[0], PrescriptParser.this.input.getInputfile());
                        }
                        PrescriptParser.this.input.fromEnd();
                    }
                } else {
                    bl = false;
                    PrescriptParser.this.input.fromEnd();
                    this.saveError("identifier <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parsePositiveInteger(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, int n) throws ParseException {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parsePositivIntg;       " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parsePosNumber(" + this.nRecursion + ") <#?" + this.sSemanticForError + ">");
                }
                String[] stringArray = new String[1];
                if (PrescriptParser.this.input.scanDigits(10, Integer.MAX_VALUE, zbnfSyntaxPrescript.getConstantSyntax(), stringArray).scanOk()) {
                    bl = true;
                    if (zbnfSyntaxPrescript.getSemantic() != null && !this.bDoNotStoreData) {
                        PrescriptParser.this.parserStoreInPrescript.addIntegerNumber(zbnfSyntaxPrescript.getSemantic(), null, PrescriptParser.this.input.getLastScannedIntegerNumber(), stringArray, parseResultItemImplement);
                    }
                } else {
                    bl = false;
                    this.saveError("positive number <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseHexNumber(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, int n) throws ParseException {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseHexNumber;         " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseHex(" + this.nRecursion + ") <#x?" + this.sSemanticForError + ">");
                }
                String[] stringArray = new String[1];
                if (PrescriptParser.this.input.scanDigits(16, n, zbnfSyntaxPrescript.getConstantSyntax(), stringArray).scanOk()) {
                    bl = true;
                    if (zbnfSyntaxPrescript.getSemantic() != null && !this.bDoNotStoreData) {
                        PrescriptParser.this.parserStoreInPrescript.addIntegerNumber(zbnfSyntaxPrescript.getSemantic(), null, PrescriptParser.this.input.getLastScannedIntegerNumber(), stringArray, parseResultItemImplement);
                    }
                } else {
                    bl = false;
                    this.saveError("hex number <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseNumberRadix(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, int n) throws ParseException {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseHexNumber;         " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseHex(" + this.nRecursion + ") <#x?" + this.sSemanticForError + ">");
                }
                String[] stringArray = new String[1];
                if (PrescriptParser.this.input.scanDigits((int)zbnfSyntaxPrescript.nFloatFactor, n, zbnfSyntaxPrescript.getConstantSyntax(), stringArray).scanOk()) {
                    bl = true;
                    if (zbnfSyntaxPrescript.getSemantic() != null && !this.bDoNotStoreData) {
                        PrescriptParser.this.parserStoreInPrescript.addIntegerNumber(zbnfSyntaxPrescript.getSemantic(), null, PrescriptParser.this.input.getLastScannedIntegerNumber(), stringArray, parseResultItemImplement);
                    }
                } else {
                    bl = false;
                    this.saveError("hex number <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseInteger(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, int n) throws ParseException {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseInteger;           " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseInt(" + this.nRecursion + ") <#-?" + this.sSemanticForError + ">");
                }
                String[] stringArray = new String[1];
                if (PrescriptParser.this.input.scanInteger(zbnfSyntaxPrescript.getConstantSyntax(), stringArray).scanOk()) {
                    bl = true;
                    if (zbnfSyntaxPrescript.getSemantic() != null && !this.bDoNotStoreData) {
                        PrescriptParser.this.parserStoreInPrescript.addIntegerNumber(zbnfSyntaxPrescript.getSemantic(), null, PrescriptParser.this.input.getLastScannedIntegerNumber(), stringArray, parseResultItemImplement);
                    }
                } else {
                    bl = false;
                    this.saveError("integer number <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseFloatNumber(ZbnfSyntaxPrescript zbnfSyntaxPrescript, int n, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement) throws ParseException {
                boolean bl;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseFloat;             " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseFloat(" + this.nRecursion + ") <#f?" + this.sSemanticForError + ">");
                }
                if (PrescriptParser.this.input.scanFloatNumber(true).scanOk()) {
                    bl = true;
                    if (zbnfSyntaxPrescript.getSemantic() != null && !this.bDoNotStoreData) {
                        double d = PrescriptParser.this.input.getLastScannedFloatNumber();
                        if (zbnfSyntaxPrescript.getType() == ZbnfSyntaxPrescript.EType.kFloatWithFactor) {
                            d *= zbnfSyntaxPrescript.getFloatFactor();
                        }
                        PrescriptParser.this.srcLineOption = -1;
                        PrescriptParser.this.parserStoreInPrescript.addFloatNumber(zbnfSyntaxPrescript.getSemantic(), null, d, parseResultItemImplement);
                    }
                } else {
                    bl = false;
                    this.saveError("float number <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseNoOrSomeCharsOutsideQuotion(String string, int n, String string2, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, ZbnfSyntaxPrescript zbnfSyntaxPrescript) throws ParseException {
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseCharsOutsideQuot;  " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <*\"\"" + string + "?" + this.sSemanticForError + ">");
                }
                int n2 = PrescriptParser.this.input.indexOfAnyCharOutsideQuotion(string, 0, n);
                boolean bl = PrescriptParser.this.input.found();
                if (bl) {
                    if (n2 >= 0) {
                        PrescriptParser.this.input.lento(n2);
                        StringPart.Part part = PrescriptParser.this.input.getCurrentPart();
                        long l = PrescriptParser.this.input.getCurrentPosition();
                        int n3 = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                        bl = this.addResultOrSubsyntax(part, l, n3, this.srcColumn[0], PrescriptParser.this.input.getInputfile(), string2, parseResultItemImplement, zbnfSyntaxPrescript);
                        if (bl) {
                            PrescriptParser.this.input.fromEnd();
                        }
                    }
                } else {
                    this.saveError("ones of terminate chars \"" + string + "\" not found <?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseStringUntilRightEndchar(String string, boolean bl, int n, String string2, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, ZbnfSyntaxPrescript zbnfSyntaxPrescript) throws ParseException {
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseStrTilRightChar;   " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <stringtolastinclChar?" + this.sSemanticForError + ">");
                }
                PrescriptParser.this.input.lentoAnyChar(string, n, 48);
                boolean bl2 = PrescriptParser.this.input.found();
                if (bl2) {
                    if (bl) {
                        PrescriptParser.this.input.lento(PrescriptParser.this.input.length() + 1);
                    }
                    if (PrescriptParser.this.input.length() > 0) {
                        StringPart.Part part = PrescriptParser.this.input.getCurrentPart();
                        long l = PrescriptParser.this.input.getCurrentPosition();
                        this.srcLine = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                        int n2 = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                        bl2 = this.addResultOrSubsyntax(part, l, n2, this.srcColumn[0], PrescriptParser.this.input.getInputfile(), string2, parseResultItemImplement, zbnfSyntaxPrescript);
                    }
                    PrescriptParser.this.input.fromEnd();
                } else {
                    PrescriptParser.this.input.setLengthMax();
                    this.saveError("ones of terminate chars \"" + string + "\" not found <?" + this.sSemanticForError + ">");
                }
                return bl2;
            }

            private boolean parseStringUntilTerminateString(String string, boolean bl, boolean bl2, int n, String string2, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, ZbnfSyntaxPrescript zbnfSyntaxPrescript) throws ParseException {
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseStrTilTermString;  " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <*" + string + "?" + this.sSemanticForError + ">");
                }
                int n2 = bl ? 1 : 0;
                PrescriptParser.this.input.setLengthMax().lentoAnyString(zbnfSyntaxPrescript.getListStrings().toArray(new String[1]), n, n2);
                boolean bl3 = PrescriptParser.this.input.found();
                if (bl3) {
                    int n3;
                    long l;
                    if (bl) {
                        PrescriptParser.this.input.lento(PrescriptParser.this.input.length() + 1);
                    }
                    StringPart.Part part = PrescriptParser.this.input.getCurrentPart();
                    if (bl2) {
                        part = part.trim();
                    }
                    if (bl3 = this.addResultOrSubsyntax(part, l = PrescriptParser.this.input.getCurrentPosition(), n3 = PrescriptParser.this.input.getLineAndColumn(this.srcColumn), this.srcColumn[0], PrescriptParser.this.input.getInputfile(), string2, parseResultItemImplement, zbnfSyntaxPrescript)) {
                        PrescriptParser.this.input.fromEnd();
                    }
                } else {
                    PrescriptParser.this.input.setLengthMax();
                    String string3 = "";
                    Iterator<String> iterator = zbnfSyntaxPrescript.getListStrings().iterator();
                    while (iterator.hasNext()) {
                        string3 = string3 + "|" + iterator.next();
                    }
                    this.saveError("ones of terminate strings:" + string3 + " not found <?" + this.sSemanticForError + ">");
                }
                return bl3;
            }

            /*
             * WARNING - void declaration
             */
            private boolean parse_Component(StringPartScan stringPartScan, int n, ZbnfSyntaxPrescript zbnfSyntaxPrescript, String string, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, boolean bl, boolean bl2, ZbnfSyntaxPrescript zbnfSyntaxPrescript2, boolean bl3, boolean bl4) throws ParseException {
                boolean bl5;
                String string2 = String.format("%9d", PrescriptParser.this.input.getCurrentPosition()) + zbnfSyntaxPrescript.sDefinitionIdent;
                ParseResultlet parseResultlet = ZbnfParser.this.alreadyParsedCmpn.get(string2);
                if (parseResultlet != null && ZbnfParser.this.args.bUseResultlet) {
                    ZbnfParserStore zbnfParserStore = PrescriptParser.this.parserStoreInPrescript;
                    int n2 = zbnfParserStore.items.size();
                    if (parseResultlet.parseResult != null && parseResultlet.parseResult.length >= 1) {
                        ZbnfParserStore.ParseResultItemImplement object = zbnfParserStore.items.get(n2 - 1);
                        object.offsetAfterEnd = parseResultlet.parseResult.length + 1;
                        parseResultlet.parseResult[0].parent = object;
                    }
                    for (ZbnfParserStore.ParseResultItemImplement parseResultItemImplement2 : parseResultlet.parseResult) {
                        int n3 = parseResultItemImplement2.idxOwn - n2;
                        parseResultItemImplement2.idxOwn = n2++;
                        parseResultItemImplement2.store = zbnfParserStore;
                        zbnfParserStore.items.add(parseResultItemImplement2);
                    }
                    zbnfParserStore.item = null;
                    PrescriptParser.this.input.setCurrentPosition(parseResultlet.endPosText);
                    bl5 = true;
                } else {
                    void var16_21;
                    ZbnfParserStore zbnfParserStore;
                    if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseComponent;         " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseComponent(" + this.nRecursion + ") <" + zbnfSyntaxPrescript.sDefinitionIdent + "?" + this.sSemanticForError + ">");
                    }
                    if (zbnfSyntaxPrescript.sDefinitionIdent.equals("headerBlock") && parseResultItemImplement.sSemantic.equals("CLASS_C")) {
                        ZbnfParser.this.stop();
                    }
                    if (string != null && string.equals("ModifierMethod")) {
                        Debugutil.stop();
                    }
                    if (bl3) {
                        if (PrescriptParser.this.parseResultToOtherComponent == null) {
                            PrescriptParser.this.parseResultToOtherComponent = new ZbnfParserStore();
                        }
                        zbnfParserStore = PrescriptParser.this.parseResultToOtherComponent;
                        Object var16_19 = null;
                    } else {
                        zbnfParserStore = PrescriptParser.this.parserStoreInPrescript;
                        ZbnfParserStore.ParseResultItemImplement parseResultItemImplement3 = parseResultItemImplement;
                    }
                    PrescriptParser prescriptParser = new PrescriptParser(PrescriptParser.this, zbnfSyntaxPrescript, zbnfSyntaxPrescript.sDefinitionIdent, stringPartScan, n);
                    bl5 = prescriptParser.parsePrescript1(string, zbnfSyntaxPrescript2, (ZbnfParserStore.ParseResultItemImplement)var16_21, zbnfParserStore, bl4 ? PrescriptParser.this.parseResultToOtherComponent : null, bl, bl2, this.nRecursion + 2);
                    ZbnfParser.this.stop();
                    if (bl5) {
                        if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                            ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseCompOk;            " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseComponent-ok(" + this.nRecursion + ") <?" + this.sSemanticForError + ">");
                        }
                    } else if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                        ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseCompError;         " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseComponent-error(" + this.nRecursion + ") <?" + this.sSemanticForError + ">");
                    }
                }
                return bl5;
            }

            private boolean addResultOrSubsyntax(CharSequence charSequence, long l, int n, int n2, String string, String string2, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, ZbnfSyntaxPrescript zbnfSyntaxPrescript) throws ParseException {
                boolean bl;
                if (zbnfSyntaxPrescript.sSubSyntax != null) {
                    String string3 = zbnfSyntaxPrescript.sSubSyntax;
                    ZbnfSyntaxPrescript zbnfSyntaxPrescript2 = zbnfSyntaxPrescript.componentSyntax;
                    if (zbnfSyntaxPrescript2 == null) {
                        zbnfSyntaxPrescript2 = zbnfSyntaxPrescript.componentSyntax = ZbnfParser.this.searchSyntaxPrescript(string3);
                    }
                    if (zbnfSyntaxPrescript2 == null) {
                        bl = false;
                        ZbnfParser.this.report.reportln(1, "parse - Syntaxprescript not found:" + string3);
                        String string4 = "prescript for : <" + string3 + (!this.sSemanticForError.equals("@") && !this.sSemanticForError.equals("?") ? "?" + this.sSemanticForError : "") + "> not found.";
                        this.saveError(string4);
                    } else {
                        StringPartScan stringPartScan = new StringPartScan(charSequence);
                        bl = this.parse_Component(stringPartScan, (int)l, zbnfSyntaxPrescript2, string2, parseResultItemImplement, false, false, zbnfSyntaxPrescript, false, false);
                    }
                } else if (string2 != null && !this.bDoNotStoreData) {
                    PrescriptParser.this.srcLineOption = -1;
                    PrescriptParser.this.parserStoreInPrescript.addString(charSequence, string2, zbnfSyntaxPrescript, null, parseResultItemImplement, n, n2, string);
                    bl = true;
                } else {
                    if (PrescriptParser.this.srcLineOption == -1) {
                        PrescriptParser.this.srcLineOption = n;
                        PrescriptParser.this.srcColumnOption[0] = n2;
                        PrescriptParser.this.srcPosOption = l;
                    }
                    if (parseResultItemImplement != null) {
                        parseResultItemImplement.setSrcLineColumnFileInParent(l, l, n, n2, string);
                    }
                    bl = true;
                }
                return bl;
            }

            private boolean parseSimpleStringLiteral(String string, int n, String string2, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, ZbnfSyntaxPrescript zbnfSyntaxPrescript) throws ParseException {
                boolean bl;
                char c;
                char c2 = c = string.length() >= 3 ? (char)string.charAt(2) : (char)'\\';
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseSimpleStringLit;   " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse(" + this.nRecursion + ") <\"\"\"?" + this.sSemanticForError + ">");
                }
                if (PrescriptParser.this.input.getCurrentChar() == string.charAt(0)) {
                    int n2 = PrescriptParser.this.input.indexEndOfQuotation(string.charAt(1), c, 0, n);
                    if (n2 >= 2) {
                        bl = true;
                        PrescriptParser.this.input.seekPos(1);
                        PrescriptParser.this.input.lentoPos(n2 - 2);
                        StringPart.Part part = PrescriptParser.this.input.getCurrentPart();
                        long l = PrescriptParser.this.input.getCurrentPosition();
                        int n3 = PrescriptParser.this.input.getLineAndColumn(this.srcColumn);
                        bl = this.addResultOrSubsyntax(part, l, n3, this.srcColumn[0], PrescriptParser.this.input.getInputfile(), string2, parseResultItemImplement, zbnfSyntaxPrescript);
                        if (bl) {
                            PrescriptParser.this.input.fromEnd().seekPos(1);
                        }
                    } else {
                        bl = false;
                        this.saveError("right quotion mark <" + string + "?" + this.sSemanticForError + ">");
                    }
                } else {
                    bl = false;
                    this.saveError("" + string.charAt(0) + "StingLiteral" + string.charAt(1) + " <" + string + "?" + this.sSemanticForError + ">");
                }
                return bl;
            }

            private boolean parseOptions(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, boolean bl, int n) throws ParseException {
                boolean bl2 = true;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseOptions;           " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse option:" + this.sSemanticForError);
                }
                PrescriptParser.this.srcLineOption = -1;
                SubParser subParser = new SubParser(this, parseResultItemImplement, this.bDoNotStoreData || zbnfSyntaxPrescript.bDonotStoreData, this.nRecursion + 1);
                bl2 = subParser.parseSub(zbnfSyntaxPrescript, "[...]", -32763, null, "@", parseResultItemImplement, bl, null, n + 1);
                if (!bl2) {
                    this.saveError(" [...]<?" + this.sSemanticForError + ">");
                }
                return bl2;
            }

            private boolean parseNegativVariant(ZbnfSyntaxPrescript zbnfSyntaxPrescript, boolean bl, int n) throws ParseException {
                boolean bl2 = true;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseNegativVariante;   " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " [?" + this.sSemanticForError);
                }
                SubParser subParser = new SubParser(this, null, false, this.nRecursion + 1);
                int n2 = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                long l = PrescriptParser.this.input.getCurrentPosition();
                bl2 = subParser.parseSub(zbnfSyntaxPrescript, "[?..]", -32763, null, "@", null, bl, null, n + 1);
                PrescriptParser.this.input.setCurrentPosition(l);
                PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n2);
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportBranchParsing) {
                    ZbnfParser.this.log.reportParsing("parseNegV ", ZbnfParser.this.idReportBranchParsing, zbnfSyntaxPrescript, PrescriptParser.this.sReportParentComponents, PrescriptParser.this.input, (int)PrescriptParser.this.input.getCurrentPosition(), this.nRecursion, bl2);
                }
                return !bl2;
            }

            private boolean parseExpectedVariant(ZbnfSyntaxPrescript zbnfSyntaxPrescript, boolean bl, int n) throws ParseException {
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseExpectVariante;    " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " [!" + this.sSemanticForError);
                }
                SubParser subParser = new SubParser(this, null, this.bDoNotStoreData || zbnfSyntaxPrescript.bDonotStoreData, this.nRecursion + 1);
                int n2 = PrescriptParser.this.parserStoreInPrescript.getNextPosition();
                long l = PrescriptParser.this.input.getCurrentPosition();
                boolean bl2 = subParser.parseSub(zbnfSyntaxPrescript, "[!..]", -32763, null, "@", null, bl, null, n + 1);
                if (bl2) {
                    PrescriptParser.this.input.setCurrentPosition(l);
                    PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n2);
                }
                return bl2;
            }

            private boolean parseUnconditionalVariant(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, boolean bl, int n) throws ParseException {
                SubParser subParser;
                boolean bl2 = true;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseUncondVariante;    " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " [>" + this.sSemanticForError);
                }
                if (!(bl2 = (subParser = new SubParser(this, parseResultItemImplement, this.bDoNotStoreData || zbnfSyntaxPrescript.bDonotStoreData, this.nRecursion + 1)).parseSub(zbnfSyntaxPrescript, "[>..]", -32763, null, "@", parseResultItemImplement, bl, null, n + 1))) {
                    throw new ParseException("unconditional Syntax failes", 0);
                }
                return bl2;
            }

            private boolean parseRepetition(ZbnfSyntaxPrescript zbnfSyntaxPrescript, ZbnfSyntaxPrescript zbnfSyntaxPrescript2, ZbnfParserStore.ParseResultItemImplement parseResultItemImplement, boolean bl, int n) throws ParseException {
                boolean bl2;
                ZbnfSyntaxPrescript zbnfSyntaxPrescript3;
                boolean bl3 = true;
                boolean bl4 = true;
                int n2 = 0;
                String string = zbnfSyntaxPrescript.getSemantic();
                if (string != null) {
                    this.sSemanticForError = string;
                }
                if (string != null) {
                    this.sSemanticForError = string;
                }
                if ((zbnfSyntaxPrescript3 = zbnfSyntaxPrescript.componentSyntax) == null && !zbnfSyntaxPrescript.sDefinitionIdent.equals("i-Repetition")) {
                    zbnfSyntaxPrescript3 = zbnfSyntaxPrescript.componentSyntax = ZbnfParser.this.searchSyntaxPrescript(zbnfSyntaxPrescript.sDefinitionIdent);
                }
                int n3 = -1;
                ZbnfParserStore.ParseResultItemImplement parseResultItemImplement2 = parseResultItemImplement;
                long l = -1L;
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRepetition;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse repetition:");
                }
                do {
                    boolean bl5;
                    String string2;
                    Object object;
                    ++n2;
                    long l2 = PrescriptParser.this.input.getCurrentPosition();
                    if (zbnfSyntaxPrescript.bEntryComponentContainer) {
                        n3 = PrescriptParser.this.parserStoreInPrescript.items.size();
                        object = PrescriptParser.this.input.getInputfile();
                        assert (zbnfSyntaxPrescript != null);
                        parseResultItemImplement2 = PrescriptParser.this.parserStoreInPrescript.add(string, zbnfSyntaxPrescript, null, null, n2, 0L, 0L, this.srcLine, this.srcColumn[0], (String)object, parseResultItemImplement);
                        string2 = null;
                    } else {
                        string2 = string;
                    }
                    object = new SubParser(this, parseResultItemImplement2, this.bDoNotStoreData || zbnfSyntaxPrescript.bDonotStoreData, this.nRecursion + 1);
                    SubParser subParser = new SubParser(this, parseResultItemImplement2, this.bDoNotStoreData || zbnfSyntaxPrescript2 != null && zbnfSyntaxPrescript2.bDonotStoreData, this.nRecursion + 1);
                    if (l2 == l) {
                        bl5 = false;
                        if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                            ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRep-nonRepeat;     " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + "   parse no repetition because no progress on input");
                        }
                    } else {
                        l = l2;
                        if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                            ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRep-repeat;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " { parse repetition nr:" + n2);
                        }
                        bl5 = ((SubParser)object).parseSub(zbnfSyntaxPrescript, "{...}", n2, null, string2, parseResultItemImplement, bl, null, n + 1);
                    }
                    switch (n) {
                        case 0: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        case 1: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        case 2: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        case 3: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        case 4: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        case 5: {
                            ZbnfParser.this.stop();
                            break;
                        }
                        default: {
                            ZbnfParser.this.stop();
                        }
                    }
                    if (!bl5 && bl4) {
                        bl3 = false;
                        this.saveError("repetition required because backward-continue is matched.");
                    }
                    if (bl5) {
                        if (zbnfSyntaxPrescript2 != null) {
                            if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRep-backCheck;     " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse test repetition back:");
                            }
                            bl4 = bl2 = subParser.parseSub(zbnfSyntaxPrescript2, "{?...}", -n2, null, "@", parseResultItemImplement, bl, null, n);
                        } else {
                            bl4 = false;
                            bl2 = true;
                            if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                                ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRep-backUncond;    " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parse repetition test repeat:");
                            }
                        }
                    } else {
                        bl2 = false;
                    }
                    if (n3 < 0) continue;
                    if (bl3) {
                        PrescriptParser.this.parserStoreInPrescript.setAlternativeAndOffsetToEnd(n3, n2);
                        Debugutil.stop();
                        continue;
                    }
                    PrescriptParser.this.parserStoreInPrescript.setCurrentPosition(n3);
                } while (bl2);
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parseRep-finish;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " } parse repetition finished, nr:" + n2);
                }
                return bl3;
            }

            private void saveError(String string) {
                int n;
                if (PrescriptParser.this.input.length() < PrescriptParser.this.input.lengthMaxPart()) {
                    ZbnfParser.this.report.reportln(1, " saveError: actual length of input is to less");
                }
                if (ZbnfParser.this.posRightestError < (long)(n = (int)PrescriptParser.this.input.getCurrentPosition() + PrescriptParser.this.posInputbase)) {
                    ZbnfParser.this.posRightestError = n;
                    ZbnfParser.this.sInputMostRightError = PrescriptParser.this.input.getCurrentPart(40).toString();
                    int[] nArray = new int[1];
                    ZbnfParser.this.lineError = PrescriptParser.this.input.getLineAndColumn(nArray);
                    ZbnfParser.this.sFileError = PrescriptParser.this.input.getInputfile();
                    ZbnfParser.this.columnError = nArray[0];
                    ZbnfParser.this.sRightestError = PrescriptParser.this.input.getCurrentPart(80);
                    ZbnfParser.this.sExpectedSyntax = "";
                    if (ZbnfParser.this.listParseResultOnError != null) {
                        int n2 = PrescriptParser.this.parserStoreInPrescript.items.size();
                        int n3 = n2 - ZbnfParser.this.maxParseResultEntriesOnError;
                        if (n3 < 0) {
                            n3 = 0;
                        }
                        ZbnfParser.this.listParseResultOnError.clear();
                        while (n3 < n2) {
                            ZbnfParser.this.listParseResultOnError.add(PrescriptParser.this.parserStoreInPrescript.items.get(n3));
                            ++n3;
                        }
                    }
                }
                if (ZbnfParser.this.posRightestError <= PrescriptParser.this.input.getCurrentPosition()) {
                    ZbnfParser.this.sExpectedSyntax = ZbnfParser.this.sExpectedSyntax + "\n " + string + " in " + this.getSemanticTreeForErrorMsg();
                }
                if (ZbnfParser.this.nReportLevel >= ZbnfParser.this.nLevelReportParsing) {
                    ZbnfParser.this.report.reportln(ZbnfParser.this.idReportParsing, "parse-saveError;        " + PrescriptParser.this.input.getCurrentPosition() + " " + PrescriptParser.this.input.getCurrent(30) + ZbnfParser.sEmpty.substring(0, this.nRecursion) + " parseError");
                }
            }

            private String getSemanticTreeForErrorMsg() {
                StringBuilder stringBuilder = new StringBuilder(200);
                PrescriptParser prescriptParser = PrescriptParser.this;
                String string = "";
                while (prescriptParser != null) {
                    stringBuilder.append(string);
                    stringBuilder.append(prescriptParser.sSemanticIdent);
                    prescriptParser = prescriptParser.parentPrescriptParser;
                    string = " <- ";
                }
                SubParser subParser = null;
                while (subParser != null) {
                    if (subParser.sSemanticForError != null) {
                        stringBuilder.append('+');
                        stringBuilder.append(subParser.sSemanticForError);
                    }
                    subParser = subParser.parentParser;
                }
                return stringBuilder.toString();
            }

            public ZbnfParserStore xxxgetParserStore() {
                return PrescriptParser.this.parserStoreInPrescript;
            }

            public String XXXgetDefinitionIdent() {
                return null;
            }
        }
    }

    public static class Args {
        boolean bStoreInputForComponent;
        int maxParseResultEntriesOnError;
        boolean bUseResultlet;

        public Args(int n) {
            this.maxParseResultEntriesOnError = n;
        }

        public Args() {
            this.maxParseResultEntriesOnError = 20;
        }
    }
}

