/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zbnf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.FileFunctions;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.xmlSimple.SimpleXmlOutputter;
import org.vishia.xmlSimple.XmlException;
import org.vishia.xmlSimple.XmlNode;
import org.vishia.zbnf.ZbnfParser;

public class Zbnf2Xml {
    public static final String sVersion = "2022-02-08";
    protected final MainCmdLogging_ifc logmaincmd;
    protected final Args argsx;
    protected ZbnfParser parser = null;

    public static void main(String[] stringArray) {
        Zbnf2Xml.smain(stringArray, true);
    }

    public static String smain(String[] stringArray) {
        return Zbnf2Xml.smain(stringArray, false);
    }

    private static String smain(String[] stringArray, boolean bl) {
        String string;
        Args args = new Args();
        CmdLine cmdLine = new CmdLine(args, stringArray);
        try {
            boolean bl2;
            cmdLine.addCmdLineProperties();
            try {
                bl2 = cmdLine.parseArguments();
            }
            catch (Exception exception) {
                cmdLine.report("Argument error:", exception);
                cmdLine.setExitErrorLevel(5);
                bl2 = false;
            }
            if (bl2) {
                Zbnf2Xml zbnf2Xml = new Zbnf2Xml(args, cmdLine);
                try {
                    zbnf2Xml.parseAndWriteXml();
                }
                catch (Exception exception) {
                    zbnf2Xml.logmaincmd.report("Uncatched Exception on main level:", exception);
                    exception.printStackTrace(System.out);
                    zbnf2Xml.logmaincmd.setExitErrorLevel(3);
                }
            }
            string = "";
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        if (bl) {
            cmdLine.exit();
        }
        return string;
    }

    public Zbnf2Xml(Args args, MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.argsx = args;
        this.logmaincmd = mainCmdLogging_ifc;
    }

    public Zbnf2Xml(String string, String string2, String string3, MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.argsx = new Args();
        this.argsx.sFileIn = string;
        this.argsx.sFileXmlOut = string3;
        this.argsx.sFileSyntax = string2;
        this.logmaincmd = mainCmdLogging_ifc;
    }

    @Deprecated
    public final boolean execute() {
        return this.parseAndWriteXml();
    }

    public boolean parseAndWriteXml() {
        boolean bl = true;
        File file = this.argsx.sFileXmlOut == null ? null : new File(this.argsx.sFileXmlOut);
        File file2 = new File(this.argsx.sFileIn);
        if (this.argsx.checknew && file != null && file.exists() && file2.exists() && file.lastModified() > file2.lastModified()) {
            this.logmaincmd.writeInfo("Zbnf2Xml - is uptodate; " + file.getAbsolutePath());
            this.logmaincmd.writeInfoln("");
            return true;
        }
        this.parser = new ZbnfParser((LogMessage)this.logmaincmd, this.argsx.parserArgs);
        this.parser.setReportIdents(1, 3, 5, 6);
        try {
            this.parser.setSkippingComment("/*", "*/", true);
            this.parser.setSyntax(new File(this.argsx.sFileSyntax));
        }
        catch (ParseException parseException) {
            this.logmaincmd.writeError("Parser Syntax reading error: " + parseException.getMessage());
            parseException.printStackTrace();
            bl = false;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            this.logmaincmd.writeError("The " + this.argsx.sFileSyntax + " contains an illegal charset-name");
            bl = false;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            this.logmaincmd.writeError("The charset in " + this.argsx.sFileSyntax + " is not supported");
            bl = false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logmaincmd.writeError("file not found:" + this.argsx.sFileSyntax);
            bl = false;
        }
        catch (IOException iOException) {
            this.logmaincmd.writeError("file read error:" + this.argsx.sFileSyntax);
            bl = false;
        }
        if ((this.argsx.xmlWrModeSet & 1) != 0) {
            this.parser.setXmlSrcline((this.argsx.xmlWrMode & 1) != 0);
        }
        if ((this.argsx.xmlWrModeSet & 2) != 0) {
            this.parser.setXmlSrctext((this.argsx.xmlWrMode & 2) != 0);
        }
        if (bl && this.logmaincmd != null) {
            this.parser.reportSyntax(this.logmaincmd, 4);
        }
        StringPartFromFileLines stringPartFromFileLines = null;
        if (bl) {
            Charset charset = this.parser.getInputEncoding();
            String string = this.parser.getInputEncodingKeyword();
            try {
                stringPartFromFileLines = new StringPartFromFileLines(file2, -1, string, charset);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logmaincmd.writeError("file not found:" + file2.getAbsolutePath());
                bl = false;
            }
            catch (IOException iOException) {
                this.logmaincmd.writeError("file read error:" + file2.getAbsolutePath());
                bl = false;
            }
        }
        if (bl) {
            this.logmaincmd.writeInfoln("parsing " + this.argsx.sFileIn);
            try {
                bl = this.parser.parse(stringPartFromFileLines, this.argsx.additionalSemantic);
            }
            catch (Exception exception) {
                this.logmaincmd.writeError("any exception while parsing:" + exception.getMessage());
                this.logmaincmd.report("any exception while parsing", exception);
                this.parser.reportStore(this.logmaincmd);
                bl = false;
            }
            if (!bl) {
                this.logmaincmd.writeError(this.parser.getSyntaxErrorReport());
                this.parser.reportStore(this.logmaincmd);
            }
        }
        if (bl) {
            this.parser.reportStore(this.logmaincmd);
            this.logmaincmd.writeInfo(" XML: ");
            if (file != null) {
                try {
                    Zbnf2Xml.writeZbnf2Xml(this.parser, this.argsx.sFileXmlOut, this.argsx.encoding);
                    this.logmaincmd.writeInfo(" done ");
                    this.logmaincmd.writeInfoln("");
                }
                catch (IOException iOException) {
                    this.logmaincmd.writeError("file not writeable:" + file.getAbsolutePath());
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static void writeZbnf2Xml(ZbnfParser zbnfParser, String string, Charset charset) throws IOException {
        Object object;
        Object object2;
        Object object3;
        File file = string == null ? null : new File(string);
        XmlNode xmlNode = zbnfParser.getResultTree();
        TreeMap<String, String> treeMap = zbnfParser.getXmlnsFromSyntaxPrescript();
        if (treeMap != null) {
            object3 = treeMap.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = treeMap.get(object2);
                xmlNode.addNamespaceDeclaration((String)object2, (String)object);
            }
        }
        if ((object3 = charset) == null) {
            object3 = Charset.forName("UTF-8");
        }
        FileFunctions.mkDirPath(file);
        object2 = new FileOutputStream(file);
        object = new OutputStreamWriter((OutputStream)object2, (Charset)object3);
        SimpleXmlOutputter simpleXmlOutputter = new SimpleXmlOutputter();
        simpleXmlOutputter.write((OutputStreamWriter)object, xmlNode);
        ((OutputStreamWriter)object).close();
        ((FileOutputStream)object2).close();
    }

    protected static class CmdLine
    extends MainCmd {
        MainCmd.SetArgument setInput = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sFileIn = string;
                return true;
            }
        };
        MainCmd.SetArgument setSyntax = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sFileSyntax = string;
                return true;
            }
        };
        MainCmd.SetArgument setOptimized = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.parserArgs.bUseResultlet = string.equals("1");
                return true;
            }
        };
        MainCmd.SetArgument setOutUtf8 = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sFileXmlOut = string;
                argData.encoding = Charset.forName("UTF-8");
                return true;
            }
        };
        MainCmd.SetArgument setOutAscii = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sFileXmlOut = string;
                argData.encoding = Charset.forName("US-ASCII");
                return true;
            }
        };
        MainCmd.SetArgument setOut = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.sFileXmlOut = string;
                return true;
            }
        };
        MainCmd.SetArgument setChecknew = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                argData.checknew = true;
                return true;
            }
        };
        MainCmd.SetArgument setOutEncoding = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                try {
                    argData.encoding = Charset.forName(string);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };
        MainCmd.SetArgument setXmlContent = new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                String string2;
                String string3;
                String string4 = this.getArgument(3);
                int n = string4.indexOf(61);
                if (n >= 0) {
                    string3 = string4.substring(0, n);
                    string2 = string4.length() > n + 2 && string4.charAt(n + 1) == '\"' ? string4.substring(n + 2, string4.length() - 1) : string4.substring(n + 1);
                } else {
                    string3 = string4;
                    string2 = "";
                }
                if (argData.additionalSemantic == null) {
                    argData.additionalSemantic = new LinkedList<String>();
                }
                argData.additionalSemantic.add(string3);
                argData.additionalSemantic.add(string2);
                return true;
            }
        };
        public final MainCmd.Argument[] argumentsZbnf2Xml = new MainCmd.Argument[]{new MainCmd.Argument("-i", ":<INPUT>     input file-path, file to parse", this.setInput), new MainCmd.Argument("-s", ":<SYNTAX>    syntax prescript in ZBNF format for parsing", this.setSyntax), new MainCmd.Argument("-opt", ":[1|0]     optimizing, uses already parsed result (since 2019-12)", this.setOptimized), new MainCmd.Argument("-x", ":<OUTPUT>    output xml file-path written in UTF8-encoding", this.setOutUtf8), new MainCmd.Argument("-y", ":<OUTPUT>    output xml file-path written in the standard encoding of system\n                   or the given -charset:encoding", this.setOut), new MainCmd.Argument("-z", ":<OUTPUT>    output xml file-path written in US-ASCII-encoding", this.setOutAscii), new MainCmd.Argument("-xmlSrcline", "[:[off|on]]   sets source line and column info in XML tags", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                if (!string.contains("off")) {
                    if (string.length() <= 11 || string.contains("on")) {
                        argData.xmlWrMode |= 1;
                    } else {
                        throw new IllegalArgumentException("faulty option -xmlSrctext[:[on|off]]");
                    }
                }
                argData.xmlWrModeSet |= 1;
                return true;
            }
        }), new MainCmd.Argument("-xmlSrctext", "[:[off|on]]   sets source text info in XML tags", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                if (!string.contains("off")) {
                    if (string.length() <= 11 || string.contains("on")) {
                        argData.xmlWrMode |= 2;
                    } else {
                        throw new IllegalArgumentException("faulty option -xmlSrctext[:[on|off]]");
                    }
                }
                argData.xmlWrModeSet |= 2;
                return true;
            }
        }), new MainCmd.Argument("-checknew", "      executes only if output not exists or input is newer", this.setChecknew), new MainCmd.Argument("-charset", ":<CHARSET> use this encoding.", this.setOutEncoding), new MainCmd.Argument("-a", ":<NAME>=<VALUE> set an additional xml information\n   <NAME>       of the additional XML infomation, typical @attribute\n   <VALUE>      its text, may be in \"\"", this.setXmlContent)};
        public final Args argData;

        protected CmdLine(Args args, String[] stringArray) {
            super(stringArray);
            this.argData = args;
        }

        void addCmdLineProperties() {
            super.addAboutInfo("Conversion text to XML via ZBNF");
            super.addAboutInfo("made by HSchorrig, 2006-03-20..2014-05-29");
            super.addHelpInfo("args: -i:<INPUT> -s:<SYNTAX> -[x|y|z]:<OUTPUT> [{-a:<NAME>=<VALUE>}]");
            super.addArgument(this.argumentsZbnf2Xml);
            super.addHelpInfo("==Standard arguments of MainCmd==");
            super.addStandardHelpInfo();
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (this.argData.sFileIn == null) {
                bl = false;
                this.writeError("ERROR argument -iInputfile is obligat.");
            } else if (this.argData.sFileIn.length() == 0) {
                bl = false;
                this.writeError("ERROR argument -iInputfile without content.");
            }
            if (this.argData.sFileSyntax == null) {
                bl = false;
                this.writeError("ERROR argument -sSyntaxfile is obligat.");
            } else if (this.argData.sFileSyntax.length() == 0) {
                bl = false;
                this.writeError("ERROR argument -sSyntaxfile without content.");
            }
            if (this.argData.sFileXmlOut == null) {
                bl = false;
                this.writeError("argument -y -x or -z: no outputfile is given");
            } else if (this.argData.sFileXmlOut.length() == 0) {
                bl = false;
                this.writeError("argument -y -x or -z without content");
            }
            if (!bl) {
                this.setExitErrorLevel(5);
            }
            return bl;
        }
    }

    protected static class Args {
        ZbnfParser.Args parserArgs = new ZbnfParser.Args();
        public String sFileIn = null;
        public String sFileSyntax = null;
        public int xmlWrMode;
        public int xmlWrModeSet;
        public String sFileXmlOut = null;
        public boolean checknew;
        public Charset encoding = Charset.defaultCharset();
        public List<String> additionalSemantic;

        protected Args() {
        }

        public void setInput(String string) {
            this.sFileIn = string;
        }
    }

    public static interface PrepareXmlNode {
        public void prepareXmlNode(XmlNode var1, String var2) throws XmlException;
    }
}

