/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlReader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.genJavaOutClass.GenJavaOutClass;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.LogMessageStream;
import org.vishia.util.ApplMain;
import org.vishia.util.Arguments;
import org.vishia.util.Debugutil;
import org.vishia.util.ExcUtil;
import org.vishia.util.FileFunctions;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFunctions_B;
import org.vishia.xmlReader.GenXmlCfgJavaData;
import org.vishia.xmlReader.XmlCfg;
import org.vishia.xmlReader.XmlJzReader;
import org.vishia.xmlSimple.SimpleXmlOutputter;
import org.vishia.xmlSimple.XmlException;
import org.vishia.xmlSimple.XmlNode;
import org.vishia.xmlSimple.XmlNodeSimple;

public class XmlJzCfgAnalyzer {
    public static final String version = "2025-12-15";
    private CmdArgs cmdArgs;
    File dirDbg;
    int debugStopLineXmlInp = -1;
    LogMessage log;
    final XmlStructureData xmlStructData = new XmlStructureData(this);
    XmlStructureNode xmlStructTree = new XmlStructureNode(null, "root", this.xmlStructData);
    TreeMap<String, XmlStructureData.CfgSubtreeType> allElementTypes = new TreeMap();
    XmlCfg cfgData = new XmlCfg(true);
    XmlCfg cfgGiven;
    XmlCfg cfgGiven1;

    public static void main(String[] stringArray) {
        try {
            int n = XmlJzCfgAnalyzer.smain(stringArray, System.out, System.err);
            System.exit(n);
        }
        catch (Exception exception) {
            System.err.println("Unexpected: " + exception.getMessage());
            exception.printStackTrace(System.err);
            System.exit(255);
        }
    }

    public static int smain(String[] stringArray, Appendable appendable, Appendable appendable2) throws IOException {
        CmdArgs cmdArgs = new CmdArgs();
        if (stringArray.length == 0) {
            cmdArgs.showHelp(appendable);
            return 1;
        }
        if (!cmdArgs.parseArgs(stringArray, appendable2) || !cmdArgs.testConsistence(appendable2)) {
            return 2;
        }
        int n = XmlJzCfgAnalyzer.amain(cmdArgs);
        return n;
    }

    public static int amain(CmdArgs cmdArgs) {
        int n = 0;
        XmlJzCfgAnalyzer xmlJzCfgAnalyzer = new XmlJzCfgAnalyzer();
        xmlJzCfgAnalyzer.cmdArgs = cmdArgs;
        xmlJzCfgAnalyzer.setDirDebug(cmdArgs.dirDbg);
        try {
            if (cmdArgs.fInCfg != null) {
                xmlJzCfgAnalyzer.cfgGiven = new XmlCfg(true);
                xmlJzCfgAnalyzer.cfgGiven.readCfgFile(cmdArgs.fInCfg, xmlJzCfgAnalyzer.log);
                if (cmdArgs.dirDbg != null) {
                    xmlJzCfgAnalyzer.cfgGiven.writeToText(new File(cmdArgs.dirDbg, "cfgGiven.read.back.txt"), xmlJzCfgAnalyzer.log);
                }
            }
            if (cmdArgs.fWriteXmlConfigText != null || cmdArgs.fxOut != null) {
                xmlJzCfgAnalyzer.analyzeXml(cmdArgs);
            } else {
                xmlJzCfgAnalyzer.cfgData = xmlJzCfgAnalyzer.cfgGiven;
            }
            if (cmdArgs.dirCreateCfgJavaData != null && xmlJzCfgAnalyzer.cfgData != null) {
                xmlJzCfgAnalyzer.writeJavaClasses();
            }
        }
        catch (Exception exception) {
            System.err.println("Unexpected: " + exception.getMessage());
            exception.printStackTrace(System.err);
            n = 255;
        }
        return n;
    }

    public static XmlCfg newCfgReadStruct() {
        XmlCfg xmlCfg = new XmlCfg(false);
        xmlCfg.rootNode = new XmlCfg.XmlCfgNode(null, xmlCfg, null);
        XmlCfg.XmlCfgNode xmlCfgNode = new XmlCfg.XmlCfgNode(null, xmlCfg, "?");
        xmlCfg.rootNode.addSubnode(xmlCfgNode.tag.toString(), xmlCfgNode);
        xmlCfgNode.addSubnode(xmlCfgNode.tag.toString(), xmlCfgNode);
        try {
            xmlCfgNode.setNewElementPath("!addElement(tag)");
            xmlCfgNode.setFinishElementPath("!finishElement(value)");
            xmlCfgNode.addAttribStorePath("?", "!setAttribute(name)");
            xmlCfgNode.setNameSpaceStorePath("!addNamespace(name, value)");
            xmlCfgNode.setContentStorePath("!setTextOccurrence()");
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
        return xmlCfg;
    }

    public XmlJzCfgAnalyzer() {
        this.log = new LogMessageStream(null, null, System.out, System.err, false, Charset.forName("UTF-8"));
    }

    public void setDirDebug(File file) {
        this.dirDbg = file;
    }

    public void setDebugStop(int n) {
        this.debugStopLineXmlInp = n;
    }

    void analyzeXml(CmdArgs cmdArgs) throws IOException {
        this.analyzeXmlFile(cmdArgs.listfIn);
        if (cmdArgs.fdOut != null) {
            this.writeData(cmdArgs.fdOut);
        }
        if (cmdArgs.fxOut != null) {
            this.writeCfgTemplate(cmdArgs.fxOut);
            this.log.writef("\nconfig XML template written to: %s", cmdArgs.fxOut.getAbsolutePath());
            this.log.writef("", new Object[0]);
        }
        if (cmdArgs.fWriteXmlConfigText != null) {
            this.cfgData.writeToText(cmdArgs.fWriteXmlConfigText, this.log);
            this.log.writef("\nconfig text written to: %s", cmdArgs.fWriteXmlConfigText.getAbsolutePath());
        }
    }

    public XmlCfg analyzeXmlFile(List<FileFunctions.FilePathnameExt> list) throws IOException {
        XmlJzReader xmlJzReader = new XmlJzReader();
        xmlJzReader.setCfg(XmlJzCfgAnalyzer.newCfgReadStruct());
        if (this.debugStopLineXmlInp > 0) {
            xmlJzReader.setDebugStop(this.debugStopLineXmlInp);
        }
        for (FileFunctions.FilePathnameExt object : list) {
            this.resetCtNodesInStructTree();
            String string = object.file.getName();
            this.log.writef("\nanalyses XML for: %s", object.file.getAbsolutePath());
            if (this.dirDbg != null) {
                xmlJzReader.openXmlTestOut(new File(this.dirDbg, string + "-back.xml"));
            }
            if (object.sNamePath != null) {
                xmlJzReader.readZipXml(object.file, object.sNamePath, this.xmlStructTree);
                continue;
            }
            xmlJzReader.readXml(object.file, (Object)this.xmlStructTree, null);
        }
        for (XmlStructureNode xmlStructureNode : this.xmlStructTree.nodes.values()) {
            xmlStructureNode.onlySingle = false;
        }
        this.checkStructTree();
        this.storeInCfg(xmlJzReader);
        return this.cfgData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCfgTemplate(File file) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            XmlNodeSimple xmlNodeSimple = new XmlNodeSimple("xmlinput:root");
            xmlNodeSimple.addNamespaceDeclaration("xmlinput", "www.vishia.org/XmlReader-xmlinput");
            for (Map.Entry<String, String> object2 : this.cfgData.xmlnsAssign.entrySet()) {
                xmlNodeSimple.addNamespaceDeclaration(object2.getValue(), object2.getKey());
            }
            for (Map.Entry<String, Object> entry : this.xmlStructData.cfgSubtreeList.entrySet()) {
                Object object;
                XmlStructureNode xmlStructureNode = (XmlStructureNode)entry.getValue();
                assert (xmlStructureNode.sSubtreenode != null);
                XmlNode xmlNode = xmlNodeSimple.addNewNode("subtree", "xmlinput");
                if (xmlStructureNode.sSubtreenode.equals("ObjectList_A")) {
                    Debugutil.stop();
                }
                xmlNode.setAttribute("name", "xmlinput", xmlStructureNode.sSubtreenode);
                String string = StringFunctions_B.replaceNonIdentifierChars(xmlStructureNode.sSubtreenode, '-').toString();
                xmlNode.setAttribute("class", "xmlinput", string);
                if (xmlStructureNode.attribs != null) {
                    for (Map.Entry<String, AttribRead> entry2 : xmlStructureNode.attribs.entrySet()) {
                        object = entry2.getValue();
                        xmlNode.setAttribute(((AttribRead)object).name, ((AttribRead)object).namespace, ((AttribRead)object).value);
                    }
                }
                this.wrSetAddContentAttrib(xmlStructureNode, xmlNode);
                if (xmlStructureNode.nodes == null) continue;
                for (Map.Entry<String, Object> entry3 : xmlStructureNode.nodes.entrySet()) {
                    object = (XmlStructureNode)entry3.getValue();
                    XmlNodeSimple xmlNodeSimple2 = new XmlNodeSimple(((XmlStructureNode)object).tag);
                    xmlNode.addContent(xmlNodeSimple2);
                    this.addWrNode(xmlNodeSimple2, (XmlStructureNode)object, 999);
                }
            }
            XmlNode xmlNode = xmlNodeSimple.addNewNode("cfg", "xmlinput");
            this.addWrNode(xmlNode, this.xmlStructTree, 999);
            SimpleXmlOutputter simpleXmlOutputter = new SimpleXmlOutputter();
            outputStreamWriter = new FileWriter(file);
            simpleXmlOutputter.write(outputStreamWriter, xmlNodeSimple);
            outputStreamWriter.close();
        }
        catch (IOException | XmlException exception) {
            CharSequence charSequence = ExcUtil.exceptionInfo("unexpected", exception, 0, 100);
            System.err.append(charSequence);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    System.err.append("cannot close" + file.getAbsolutePath());
                }
            }
        }
        Debugutil.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCfgText(File file) {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            writer.append("\n\n##== Namespaces ==\n");
            for (Map.Entry<String, String> entry : this.cfgData.xmlnsAssign.entrySet()) {
                ApplMain.outNewlineIndent(writer, 0);
                writer.append("@xmlns:").append(entry.getValue()).append(" = ").append(entry.getKey());
            }
            writer.append("\n\n##== Subtrees ==\n");
            for (Map.Entry<String, Object> entry : this.xmlStructData.cfgSubtreeList.entrySet()) {
                XmlStructureNode xmlStructureNode = (XmlStructureNode)entry.getValue();
                if (xmlStructureNode.sSubtreenode == null) {
                    Debugutil.stop();
                }
                xmlStructureNode.writeData(writer, 0);
            }
            writer.append("\n\n##== The root struct ==\n");
            this.xmlStructTree.writeData(writer, 0);
            ApplMain.outNewlineIndent(writer, 0);
            writer.close();
        }
        catch (Exception exception) {
            CharSequence charSequence = ExcUtil.exceptionInfo("unexpected", exception, 0, 100);
            System.err.append(charSequence);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    System.err.append("cannot close" + file.getAbsolutePath());
                }
            }
        }
    }

    private void resetCtNodesInStructTree() {
        this.resetCtNodesInStructTree(this.xmlStructTree, 0);
    }

    private void resetCtNodesInStructTree(XmlStructureNode xmlStructureNode, int n) {
        if (n > 100) {
            return;
        }
        xmlStructureNode.ctTextInNode = 0;
        xmlStructureNode.ctOccurInParent = 0;
        assert (xmlStructureNode.sSubtreenode == null);
        if (xmlStructureNode.nodes != null) {
            for (XmlStructureNode xmlStructureNode2 : xmlStructureNode.nodes.values()) {
                this.resetCtNodesInStructTree(xmlStructureNode2, n + 1);
            }
        }
    }

    private void writeJavaClasses() throws IllegalCharsetNameException, UnsupportedCharsetException {
        GenJavaOutClass.CmdArgs cmdArgs = new GenJavaOutClass.CmdArgs();
        cmdArgs.dirJava = this.cmdArgs.dirCreateCfgJavaData;
        cmdArgs.sJavaClass = this.cmdArgs.sClassJava;
        cmdArgs.sJavaPkg = this.cmdArgs.sPkgJava;
        GenXmlCfgJavaData genXmlCfgJavaData = new GenXmlCfgJavaData(cmdArgs, this.log);
        genXmlCfgJavaData.exec(this.cfgData);
    }

    private void wrSetAddContentAttrib(XmlStructureNode xmlStructureNode, XmlNode xmlNode) throws XmlException {
        CharSequence charSequence;
        CharSequence charSequence2;
        if (xmlStructureNode.attribs != null) {
            charSequence2 = new StringBuilder(100);
            charSequence = charSequence2;
            int n = 40;
            for (Map.Entry<String, AttribRead> entry : xmlStructureNode.attribs.entrySet()) {
                AttribRead attribRead = entry.getValue();
                xmlNode.setAttribute(attribRead.name, attribRead.namespace, attribRead.value);
                if (!attribRead.value.startsWith("@")) continue;
                ((StringBuilder)charSequence2).append((char)n).append(attribRead.value.substring(2));
                n = 44;
            }
            ((StringBuilder)charSequence2).append(')');
        } else {
            charSequence = "()";
        }
        xmlNode.setAttribute("data", "xmlinput", "!new_" + xmlStructureNode.tagIdent + charSequence);
        if (xmlStructureNode.onlySingle) {
            charSequence2 = "!set_";
        } else {
            charSequence2 = "!add_";
            xmlNode.setAttribute("list", "xmlinput", "");
        }
        xmlNode.setAttribute("finish", "xmlinput", (String)charSequence2 + xmlStructureNode.tagIdent + "(value)");
    }

    private void addWrNode(XmlNode xmlNode, XmlStructureNode xmlStructureNode, int n) throws XmlException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (xmlStructureNode.nodes != null || xmlStructureNode.attribs != null) {
            this.wrSetAddContentAttrib(xmlStructureNode, xmlNode);
            if (xmlStructureNode.sSubtreenode != null) {
                String string = xmlStructureNode.sSubtreenode;
                xmlNode.setAttribute("subtree", "xmlinput", string);
            } else {
                if (xmlStructureNode.nodes != null || xmlStructureNode.attribs != null && (xmlStructureNode.ctText > 0 || xmlStructureNode.attribs.size() > 1)) {
                    Iterator<Map.Entry<String, XmlStructureNode>> iterator = StringFunctions_B.replaceNonIdentifierChars(xmlStructureNode.tagIdent, '-').toString();
                    xmlNode.setAttribute("class", "xmlinput", (String)((Object)iterator));
                }
                if (xmlStructureNode.nameSpaces != null) {
                    Debugutil.stop();
                    for (Map.Entry<String, XmlStructureNode> entry : xmlStructureNode.nameSpaces.entrySet()) {
                        xmlNode.addNamespaceDeclaration(entry.getKey(), (String)((Object)entry.getValue()));
                    }
                }
                if (xmlStructureNode.nodes != null) {
                    for (Map.Entry<String, XmlStructureNode> entry : xmlStructureNode.nodes.entrySet()) {
                        XmlStructureNode xmlStructureNode2 = entry.getValue();
                        String string = entry.getKey();
                        XmlNodeSimple xmlNodeSimple = new XmlNodeSimple(string);
                        xmlNode.addContent(xmlNodeSimple);
                        this.addWrNode(xmlNodeSimple, xmlStructureNode2, n - 1);
                    }
                }
            }
            if (xmlStructureNode.ctText == 1) {
                xmlNode.addContent("!set_text(text)");
            } else if (xmlStructureNode.ctText > 1) {
                xmlNode.addContent("!add_text(text)");
            }
        } else if (xmlStructureNode.onlySingle) {
            xmlNode.addContent("!set_" + xmlStructureNode.tag + "(text)");
        } else {
            xmlNode.addContent("!add_" + xmlStructureNode.tag + "(text)");
        }
    }

    public XmlCfg analyzeXmlStruct(File file) throws IOException {
        LinkedList<FileFunctions.FilePathnameExt> linkedList = new LinkedList<FileFunctions.FilePathnameExt>();
        linkedList.add(new FileFunctions.FilePathnameExt(file, null));
        return this.analyzeXmlFile(linkedList);
    }

    public XmlCfg readXmlStruct(File file) throws IOException {
        return this.analyzeXmlStruct(file);
    }

    public XmlCfg readXmlStructZip(File file, String string) throws IOException {
        LinkedList<FileFunctions.FilePathnameExt> linkedList = new LinkedList<FileFunctions.FilePathnameExt>();
        linkedList.add(new FileFunctions.FilePathnameExt(file, string));
        return this.analyzeXmlFile(linkedList);
    }

    private void checkStructTree() {
        TreeMap<String, XmlCfg.XmlCfgNode> treeMap = new TreeMap<String, XmlCfg.XmlCfgNode>();
        if (this.cfgGiven != null) {
            this.cfgData = this.cfgGiven;
            this.fillNodesGivenForCheckSubtree(this.cfgGiven.rootNode, treeMap, 0);
            for (XmlCfg.XmlCfgNode object : this.cfgGiven.subtrees.values()) {
                this.fillNodesGivenForCheckSubtree(object, treeMap, 0);
            }
        }
        for (XmlStructureData.CfgSubtreeType cfgSubtreeType : this.allElementTypes.values()) {
            XmlCfg.XmlCfgNode xmlCfgNode;
            String string = cfgSubtreeType.occurrence.get((int)0).tag;
            XmlCfg.XmlCfgNode xmlCfgNode2 = this.cfgGiven == null ? null : this.cfgGiven.subtrees.get(string);
            XmlCfg.XmlCfgNode xmlCfgNode3 = xmlCfgNode = this.cfgGiven == null ? null : (XmlCfg.XmlCfgNode)treeMap.get(string);
            if (xmlCfgNode2 == null && xmlCfgNode == null && cfgSubtreeType.occurrence.size() <= 1) continue;
            String string2 = null;
            if (xmlCfgNode != null) {
                string2 = xmlCfgNode.parent.tag.toString();
            }
            boolean bl = xmlCfgNode2 != null;
            for (XmlStructureNode xmlStructureNode : cfgSubtreeType.occurrence) {
                xmlStructureNode.onlySingle = xmlStructureNode.onlySingle & (xmlCfgNode == null && xmlCfgNode2 == null);
                if (string2 == null) {
                    string2 = xmlStructureNode.parent.tag;
                    continue;
                }
                if (!string2.equals(xmlStructureNode.parent.tag)) {
                    bl = true;
                    break;
                }
                Debugutil.stop();
            }
            if (!bl) {
                Debugutil.stop();
            }
            if (!bl) continue;
            XmlCfg.XmlCfgNode xmlCfgNode4 = this.cfgData.addSubTree(string);
            if (xmlCfgNode2 == null && xmlCfgNode != null) {
                if (xmlCfgNode.attribs != null) {
                    xmlCfgNode4.attribs = new TreeMap<String, XmlCfg.AttribDstCheck>();
                    Iterator<XmlCfg.AttribDstCheck> iterator = xmlCfgNode.attribs.values().iterator();
                    while (iterator.hasNext()) {
                        XmlCfg.AttribDstCheck attribDstCheck = iterator.next();
                        if (!attribDstCheck.bUseForCheck) {
                            iterator.remove();
                        }
                        xmlCfgNode4.attribs.put(attribDstCheck.name, attribDstCheck);
                    }
                }
                xmlCfgNode4.subnodes = xmlCfgNode.subnodes;
                xmlCfgNode.subnodes = null;
                xmlCfgNode.cfgSubtreeName = string;
                xmlCfgNode4.dstClassName = xmlCfgNode.dstClassName;
                xmlCfgNode4.elementCreatePath = xmlCfgNode.elementCreatePath;
                xmlCfgNode4.contentStorePath = xmlCfgNode.contentStorePath;
            }
            for (XmlStructureNode xmlStructureNode : cfgSubtreeType.occurrence) {
                xmlStructureNode.sSubtreenode = string;
            }
        }
    }

    private final void fillNodesGivenForCheckSubtree(XmlCfg.XmlCfgNode xmlCfgNode, Map<String, XmlCfg.XmlCfgNode> map, int n) {
        if (n > 100) {
            return;
        }
        if (xmlCfgNode.subnodes != null) {
            for (XmlCfg.XmlCfgNode xmlCfgNode2 : xmlCfgNode.subnodes.values()) {
                map.put(xmlCfgNode2.tag.toString(), xmlCfgNode2);
                this.fillNodesGivenForCheckSubtree(xmlCfgNode2, map, n + 1);
            }
        }
    }

    private void storeInCfg(XmlJzReader xmlJzReader) {
        this.cfgData.transferNamespaceAssignment(xmlJzReader.namespaces);
        try {
            for (XmlStructureData.CfgSubtreeType cfgSubtreeType : this.allElementTypes.values()) {
                for (XmlStructureNode xmlStructureNode : cfgSubtreeType.occurrence) {
                    if (xmlStructureNode.sSubtreenode == null) continue;
                    XmlCfg.XmlCfgNode xmlCfgNode = this.cfgData.subtrees.get(xmlStructureNode.sSubtreenode);
                    this.storeCfgNode(xmlCfgNode, xmlStructureNode, true, 100);
                }
            }
            this.storeCfgNode(this.cfgData.rootNode, this.xmlStructTree, true, 100);
        }
        catch (ParseException parseException) {
            this.log.writeError("ERROR unexpected: ", parseException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void storeCfgNode(XmlCfg.XmlCfgNode xmlCfgNode, XmlStructureNode xmlStructureNode, boolean bl, int n) throws ParseException {
        String string;
        if (n <= 0) {
            assert (false);
            return;
        }
        XmlStructureNode xmlStructureNode2 = xmlStructureNode;
        xmlCfgNode.bList = xmlCfgNode.bList | !xmlStructureNode.onlySingle;
        xmlCfgNode.bTextMoreOccurrences = xmlCfgNode.bTextMoreOccurrences | xmlStructureNode.ctText > 1;
        String string2 = string = StringFunctions_B.replaceNonIdentifierChars(xmlStructureNode2.tagIdent, '-').toString();
        char c = string.charAt(0);
        if (!Character.isUpperCase(c)) {
            string2 = Character.toUpperCase(c) + string.substring(1);
        }
        assert (xmlCfgNode.dstClassName == null || xmlCfgNode.dstClassName.equals(string2) || xmlCfgNode.dstClassName.equals(string));
        xmlCfgNode.dstClassName = string2;
        if (!bl || xmlStructureNode.sSubtreenode == null) {
            Iterator<XmlStructureNode> iterator = new StringBuilder(20 + (xmlStructureNode.attribs == null ? 0 : xmlStructureNode.attribs.size() * 10));
            ((StringBuilder)((Object)iterator)).append("new_").append(xmlStructureNode.tagIdent).append('(');
            if (xmlStructureNode.attribs != null) {
                String object2 = "";
                for (AttribRead attribRead : xmlStructureNode.attribs.values()) {
                    void var10_11;
                    if (!attribRead.value.startsWith("@")) continue;
                    ((StringBuilder)((Object)iterator)).append((String)var10_11).append(attribRead.value.substring(1));
                    String string3 = ",";
                }
            }
            ((StringBuilder)((Object)iterator)).append(')');
            xmlCfgNode.setNewElementPath(((StringBuilder)((Object)iterator)).toString());
            if (xmlCfgNode.bList) {
                String string4 = "add_" + xmlStructureNode.tagIdent + "(value)";
                xmlCfgNode.setFinishElementPath(string4);
            } else {
                String string5 = "set_" + xmlStructureNode.tagIdent + "(value)";
                xmlCfgNode.setFinishElementPath(string5);
            }
        }
        if (!bl && xmlStructureNode.sSubtreenode != null) {
            xmlCfgNode.cfgSubtreeName = xmlStructureNode.sSubtreenode;
        } else {
            Object object;
            if (xmlStructureNode.ctText == 1) {
                xmlCfgNode.setContentStorePath("set_Text(text)");
            } else if (xmlStructureNode.ctText > 1) {
                xmlCfgNode.setContentStorePath("add_Text(text)");
            }
            xmlCfgNode.bCheckAttributeNode = false;
            xmlCfgNode.bStoreAttribsInNewContent = false;
            if (xmlStructureNode.attribs != null) {
                for (AttribRead attribRead : xmlStructureNode.attribs.values()) {
                    object = attribRead.namespace + ':' + attribRead.name;
                    xmlCfgNode.addAttribStorePath((String)object, attribRead.value);
                }
            }
            if (xmlStructureNode.nodes != null) {
                if (xmlCfgNode.subnodes == null) {
                    xmlCfgNode.subnodes = new TreeMap<String, XmlCfg.XmlCfgNode>();
                }
                for (XmlStructureNode xmlStructureNode3 : xmlStructureNode.nodes.values()) {
                    object = xmlCfgNode.subnodes.get(xmlStructureNode3.tag);
                    if (object == null) {
                        object = new XmlCfg.XmlCfgNode(xmlCfgNode, this.cfgData, xmlStructureNode3.tag);
                        xmlCfgNode.addSubnode(((XmlCfg.XmlCfgNode)object).tag.toString(), (XmlCfg.XmlCfgNode)object);
                    } else {
                        this.mergeNode((XmlCfg.XmlCfgNode)object, xmlStructureNode3);
                    }
                    this.storeCfgNode((XmlCfg.XmlCfgNode)object, xmlStructureNode3, false, n - 1);
                    Debugutil.stop();
                }
            }
        }
    }

    public void mergeNode(XmlCfg.XmlCfgNode xmlCfgNode, XmlStructureNode xmlStructureNode) {
        Debugutil.stop();
    }

    public void writeData(File file) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        this.xmlStructTree.writeData(outputStreamWriter, 0);
        ApplMain.outNewlineIndent(outputStreamWriter, 0);
        ((Writer)outputStreamWriter).close();
    }

    static class XmlStructureNode {
        final String tag;
        final XmlStructureNode parent;
        Map<String, XmlStructureNode> nodes;
        Map<String, AttribRead> attribs;
        boolean bNewAttributes = false;
        Map<String, String> nameSpaces;
        List<String> attribsUnnamed;
        final String tagIdent;
        String sSubtreenode;
        int ctText = 0;
        int ctTextInNode;
        boolean XXXbDetermineWithParent = false;
        boolean bDependencyChecked;
        boolean onlySingle = true;
        int ctOccurInParent = 0;
        Map<String, String> nodesLocal;
        int nrofAttributes = 0;
        final XmlStructureData xmlStructData;
        long mGroup;

        XmlStructureNode(XmlStructureNode xmlStructureNode, String string, XmlStructureData xmlStructureData) {
            this.parent = xmlStructureNode;
            this.tag = string;
            this.tagIdent = StringFunctions_B.replaceNonIdentifierChars(string, '-').toString();
            this.xmlStructData = xmlStructureData;
        }

        public void addAttribute(String string, String string2) {
            AttribRead attribRead = new AttribRead();
            attribRead.value = string2;
            int n = string.indexOf(58);
            if (n >= 0) {
                attribRead.namespace = string.substring(0, n);
                attribRead.name = string.substring(n + 1);
            } else {
                attribRead.name = string;
            }
            if (this.attribs == null) {
                this.attribs = new TreeMap<String, AttribRead>();
                this.bNewAttributes = true;
                this.attribs.put(string, attribRead);
            } else if (this.attribs.get(string) == null) {
                this.bNewAttributes = true;
                this.attribs.put(string, attribRead);
            }
        }

        public void addAttributeUnnamed(String string) {
            if (this.attribsUnnamed == null) {
                this.attribsUnnamed = new LinkedList<String>();
            }
            this.attribsUnnamed.add(string);
        }

        void putSubnode(XmlStructureNode xmlStructureNode) {
            if (this.nodes == null) {
                this.nodes = new TreeMap<String, XmlStructureNode>();
            }
            this.nodes.put(xmlStructureNode.tag, xmlStructureNode);
        }

        public XmlStructureNode addElement(String string) {
            XmlStructureNode xmlStructureNode;
            if (this.nodes == null) {
                this.nodes = new TreeMap<String, XmlStructureNode>();
            }
            if (this.nodesLocal == null) {
                this.nodesLocal = new TreeMap<String, String>();
            }
            if ((xmlStructureNode = this.nodes.get(string)) == null) {
                xmlStructureNode = new XmlStructureNode(this, string, this.xmlStructData);
                this.nodes.put(string, xmlStructureNode);
                this.xmlStructData.addStructureNodeOccurence(xmlStructureNode);
            } else if (xmlStructureNode.parent != this) {
                Debugutil.stopp();
            }
            xmlStructureNode.ctTextInNode = 0;
            ++xmlStructureNode.ctOccurInParent;
            if (xmlStructureNode.ctOccurInParent > 1) {
                xmlStructureNode.onlySingle = false;
            }
            if (this.nodesLocal.get(string) != null) {
                Debugutil.stop();
            }
            this.nodesLocal.put(string, string);
            xmlStructureNode.nodesLocal = null;
            return xmlStructureNode;
        }

        public void finishElement(XmlStructureNode xmlStructureNode) {
            if (xmlStructureNode.ctText < xmlStructureNode.ctTextInNode) {
                xmlStructureNode.ctText = xmlStructureNode.ctTextInNode;
            }
            Debugutil.stop();
        }

        public void addNamespace(String string, String string2) {
            if (this.nameSpaces == null) {
                this.nameSpaces = new TreeMap<String, String>();
            }
            this.nameSpaces.put(string, string2);
        }

        public void setAttribute(String string) {
            String string2 = "set_" + StringFunctions_B.replaceNonIdentifierChars(string, '-').toString() + "(value)";
            this.addAttribute(string, string2);
        }

        public void setTextOccurrence() {
            if (this.tag.equals("it") && this.ctTextInNode > 0) {
                Debugutil.stop();
            }
            ++this.ctTextInNode;
            if (this.ctText < this.ctTextInNode) {
                this.ctText = this.ctTextInNode;
            }
        }

        void writeNodeData(Appendable appendable, int n) throws IOException {
            ApplMain.outIndent(appendable, n);
            appendable.append('<').append(this.tag).append(' ').append(this.tagIdent).append(' ').append(this.sSubtreenode).append(' ');
            if (this.ctText == 1) {
                appendable.append(" TEXT ");
            } else if (this.ctText > 1) {
                appendable.append(" TEXT LIST ");
            }
            if (this.bDependencyChecked) {
                appendable.append(" DEPCHECKED ");
            }
            if (this.onlySingle) {
                appendable.append(" SINGLE ");
            }
            appendable.append('\n');
            if (this.attribs != null) {
                for (Map.Entry<String, AttribRead> entry : this.attribs.entrySet()) {
                    ApplMain.outIndent(appendable, n + 2);
                    AttribRead attribRead = entry.getValue();
                    appendable.append('@');
                    if (attribRead.namespace != null) {
                        appendable.append(attribRead.namespace).append(':');
                    }
                    appendable.append(attribRead.name).append(" = ").append(attribRead.value).append("\n");
                }
            }
        }

        void writeData(Appendable appendable, int n) throws IOException {
            this.writeNodeData(appendable, n);
            if (this.nodes != null) {
                for (Map.Entry<String, XmlStructureNode> entry : this.nodes.entrySet()) {
                    XmlStructureNode xmlStructureNode = entry.getValue();
                    xmlStructureNode.writeData(appendable, n + 2);
                }
            }
            ApplMain.outIndent(appendable, n);
            appendable.append(">\n");
        }

        public String toString() {
            return this.tag + (this.attribs != null ? " attr:" + this.attribs.toString() : "") + (this.nodes != null ? " nodes:" + this.nodes.toString() : "");
        }
    }

    public static class AttribRead {
        String namespace;
        String name;
        String value;
    }

    static final class XmlStructureData {
        final XmlJzCfgAnalyzer this0;
        IndexMultiTable<String, CfgSubtreeType2> allElementTypes2 = new IndexMultiTable(IndexMultiTable.providerString);
        Map<String, XmlStructureNode> cfgSubtreeByName = new TreeMap<String, XmlStructureNode>();
        Map<String, XmlStructureNode> cfgSubtreeList = new TreeMap<String, XmlStructureNode>();

        public XmlStructureData(XmlJzCfgAnalyzer xmlJzCfgAnalyzer) {
            this.this0 = xmlJzCfgAnalyzer;
        }

        private void createCfgSubtree(XmlStructureNode xmlStructureNode, char c) {
            CfgSubtreeType2 cfgSubtreeType2 = new CfgSubtreeType2(xmlStructureNode);
            String string = c < 'A' ? xmlStructureNode.tag : xmlStructureNode.tag + '_' + c;
            if (xmlStructureNode.attribs != null) {
                for (Map.Entry<String, Object> entry : xmlStructureNode.attribs.entrySet()) {
                    cfgSubtreeType2.attributeNames.put(entry.getKey(), entry.getKey());
                }
            }
            if (xmlStructureNode.nodes != null) {
                for (Map.Entry<String, Object> entry : xmlStructureNode.nodes.entrySet()) {
                    cfgSubtreeType2.nodeNames.put(entry.getKey(), entry.getKey());
                }
            }
            if (this.allElementTypes2.get(xmlStructureNode.tag) != null) {
                Debugutil.stop();
            }
            if (this.allElementTypes2.get(xmlStructureNode.tag) != null) {
                Debugutil.stop();
            }
            this.allElementTypes2.add(xmlStructureNode.tag, cfgSubtreeType2);
            this.cfgSubtreeByName.put(string, xmlStructureNode);
        }

        void addStructureNodeOccurence(XmlStructureNode xmlStructureNode) {
            CfgSubtreeType cfgSubtreeType = this.this0.allElementTypes.get(xmlStructureNode.tag);
            if (cfgSubtreeType == null) {
                cfgSubtreeType = new CfgSubtreeType();
                this.this0.allElementTypes.put(xmlStructureNode.tag, cfgSubtreeType);
            }
            cfgSubtreeType.occurrence.add(xmlStructureNode);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void checkStructureNodeOccurence(XmlStructureNode xmlStructureNode, List<XmlStructureNode> list) {
            CfgSubtreeType2 cfgSubtreeType2;
            boolean bl;
            char c;
            ListIterator<CfgSubtreeType2> listIterator;
            block17: {
                block16: {
                    if (xmlStructureNode.nodes == null && xmlStructureNode.attribs == null) {
                        return;
                    }
                    listIterator = this.allElementTypes2.iterator(xmlStructureNode.tag);
                    c = '@';
                    bl = false;
                    if (xmlStructureNode.tag.equals("AttributeList")) {
                        Debugutil.stop();
                    }
                    if (!listIterator.hasNext()) break block16;
                    cfgSubtreeType2 = (CfgSubtreeType2)listIterator.next();
                    if (cfgSubtreeType2.tag.equals(xmlStructureNode.tag)) break block17;
                }
                this.createCfgSubtree(xmlStructureNode, '\u0000');
                return;
            }
            do {
                c = (char)(c + 1);
                int n = 0;
                int n2 = 0;
                if (xmlStructureNode.attribs != null) {
                    for (Map.Entry<String, AttribRead> entry : xmlStructureNode.attribs.entrySet()) {
                        String string = entry.getKey();
                        if (cfgSubtreeType2.attributeNames.get(string) != null) {
                            ++n;
                        }
                        ++n2;
                    }
                }
                float f = cfgSubtreeType2.attributeNames.size() - n;
                float f2 = n2 - n;
                float f3 = n;
                n2 = 0;
                n = 0;
                if (xmlStructureNode.nodes != null) {
                    for (Map.Entry<String, XmlStructureNode> entry : xmlStructureNode.nodes.entrySet()) {
                        String string = entry.getKey();
                        if (cfgSubtreeType2.nodeNames.get(string) != null) {
                            ++n;
                        }
                        ++n2;
                    }
                }
                int n3 = cfgSubtreeType2.nodeNames.size() - n;
                int n4 = n2 - n;
                int n5 = n;
                for (XmlStructureNode xmlStructureNode2 : list) {
                    n2 = 0;
                    n = 0;
                    int n6 = 1;
                    if (xmlStructureNode.nodes == null) continue;
                    for (Map.Entry<String, XmlStructureNode> entry : xmlStructureNode.nodes.entrySet()) {
                        String string = entry.getKey();
                        if (xmlStructureNode2.nodes == null || xmlStructureNode2.nodes.get(string) == null) continue;
                        xmlStructureNode.mGroup |= (long)n6;
                    }
                }
                boolean bl2 = false;
                if (bl2) {
                    this.createCfgSubtree(xmlStructureNode, c);
                    if (bl) break;
                } else {
                    bl = true;
                    cfgSubtreeType2.occurrence.add(xmlStructureNode);
                    xmlStructureNode.sSubtreenode = cfgSubtreeType2.representative.sSubtreenode;
                    cfgSubtreeType2.addContentOfFoundNode(xmlStructureNode);
                    break;
                }
                if (!listIterator.hasNext()) break;
                cfgSubtreeType2 = (CfgSubtreeType2)listIterator.next();
            } while (cfgSubtreeType2.tag.equals(xmlStructureNode.tag));
            if (bl) return;
        }

        protected void checkCfgSubtree(XmlCfg xmlCfg) {
            Object object;
            Object object2;
            for (CfgSubtreeType object3 : this.this0.allElementTypes.values()) {
                object2 = object3.occurrence.get((int)0).tag;
                Object object4 = object = xmlCfg == null ? null : xmlCfg.subtrees.get(object2);
                if (object == null && object3.occurrence.size() <= 1) continue;
                if (object != null && object3.occurrence.size() == 1) {
                    Debugutil.stop();
                }
                for (XmlStructureNode xmlStructureNode : object3.occurrence) {
                    this.checkStructureNodeOccurence(xmlStructureNode, object3.occurrence);
                }
            }
            Debugutil.stop();
            for (Map.Entry entry : this.allElementTypes2.entrySet()) {
                object2 = (CfgSubtreeType2)entry.getValue();
                object = ((CfgSubtreeType2)entry.getValue()).representative;
                if (((XmlStructureNode)object).bDependencyChecked) continue;
                ((XmlStructureNode)object).bDependencyChecked = true;
                this.checkUsageSubtreenode((CfgSubtreeType2)object2, (XmlStructureNode)object, 99);
            }
            Debugutil.stop();
            for (Map.Entry entry : this.allElementTypes2.entrySet()) {
                object2 = (CfgSubtreeType2)entry.getValue();
                this.processDependingCfgSubtree((CfgSubtreeType2)object2, 99);
            }
        }

        private void processDependingCfgSubtree(CfgSubtreeType2 cfgSubtreeType2, int n) {
            if (n < 50) {
                Debugutil.stop();
            }
            assert (n >= 0);
            if (!cfgSubtreeType2.bSort) {
                if (cfgSubtreeType2.dependings.size() == 0) {
                    if (this.cfgSubtreeList.get(cfgSubtreeType2.tag) != null) {
                        System.out.println("processDependingCfgSubtree twice: " + cfgSubtreeType2.tag);
                    }
                    this.cfgSubtreeList.put(cfgSubtreeType2.tag, cfgSubtreeType2.representative);
                    cfgSubtreeType2.bSort = true;
                } else {
                    cfgSubtreeType2.bSort = true;
                    for (CfgSubtreeType2 cfgSubtreeType22 : cfgSubtreeType2.dependings) {
                        this.processDependingCfgSubtree(cfgSubtreeType22, n - 1);
                    }
                    if (this.cfgSubtreeList.get(cfgSubtreeType2.tag) != null) {
                        System.out.println("processDependingCfgSubtree-2 twice: " + cfgSubtreeType2.tag);
                    }
                    this.cfgSubtreeList.put(cfgSubtreeType2.tag, cfgSubtreeType2.representative);
                }
            }
        }

        private void checkUsageSubtreenode(CfgSubtreeType2 cfgSubtreeType2, XmlStructureNode xmlStructureNode, int n) {
            assert (n >= 0);
            if (xmlStructureNode.nodes != null) {
                block0: for (Map.Entry<String, XmlStructureNode> entry : xmlStructureNode.nodes.entrySet()) {
                    XmlStructureNode xmlStructureNode2 = entry.getValue();
                    if (xmlStructureNode2.sSubtreenode != null) {
                        if (xmlStructureNode2.bDependencyChecked) continue;
                        xmlStructureNode2.bDependencyChecked = true;
                        ListIterator<CfgSubtreeType2> listIterator = this.allElementTypes2.iterator(xmlStructureNode2.tag);
                        while (listIterator.hasNext()) {
                            CfgSubtreeType2 cfgSubtreeType22 = (CfgSubtreeType2)listIterator.next();
                            if (!cfgSubtreeType22.tag.equals(xmlStructureNode2.tag)) continue block0;
                            if (!cfgSubtreeType22.representative.sSubtreenode.equals(xmlStructureNode2.sSubtreenode)) continue;
                            cfgSubtreeType2.dependings.add(cfgSubtreeType22);
                            this.checkUsageSubtreenode(cfgSubtreeType22, cfgSubtreeType22.representative, n - 1);
                            continue block0;
                        }
                        continue;
                    }
                    this.checkUsageSubtreenode(cfgSubtreeType2, xmlStructureNode2, n - 1);
                }
            }
        }

        static class CfgSubtreeType2 {
            final String tag;
            List<XmlStructureNode> occurrence = new ArrayList<XmlStructureNode>();
            XmlStructureNode representative;
            List<CfgSubtreeType2> dependings = new ArrayList<CfgSubtreeType2>();
            boolean bSort;
            Map<String, String> attributeNames = new TreeMap<String, String>();
            Map<String, String> nodeNames = new TreeMap<String, String>();

            public CfgSubtreeType2(XmlStructureNode xmlStructureNode) {
                this.tag = xmlStructureNode.tag;
                this.representative = xmlStructureNode;
                this.occurrence.add(xmlStructureNode);
            }

            protected void addContentOfFoundNode(XmlStructureNode xmlStructureNode) {
                String string;
                if (xmlStructureNode.attribs != null) {
                    for (Map.Entry<String, Object> entry : xmlStructureNode.attribs.entrySet()) {
                        string = entry.getKey();
                        if (string.equals("draw:fit-to-size")) {
                            Debugutil.stopp();
                        }
                        if (this.attributeNames.get(string) != null) continue;
                        this.attributeNames.put(string, string);
                        if (this.representative.attribs == null) {
                            this.representative.attribs = new TreeMap<String, AttribRead>();
                        }
                        this.representative.attribs.put(string, (AttribRead)entry.getValue());
                    }
                }
                if (xmlStructureNode.nodes != null) {
                    for (Map.Entry<String, Object> entry : xmlStructureNode.nodes.entrySet()) {
                        string = entry.getKey();
                        if (this.nodeNames.get(entry.getKey()) != null) continue;
                        this.nodeNames.put(string, string);
                        if (this.representative.nodes == null) {
                            this.representative.nodes = new TreeMap<String, XmlStructureNode>();
                        }
                        this.representative.nodes.put(string, (XmlStructureNode)entry.getValue());
                    }
                }
                if (this.representative.ctText < xmlStructureNode.ctText) {
                    this.representative.ctText = xmlStructureNode.ctText;
                }
            }

            public String toString() {
                return "" + this.occurrence.size() + " * " + this.occurrence.get(0).toString();
            }
        }

        static class CfgSubtreeType {
            List<XmlStructureNode> occurrence = new ArrayList<XmlStructureNode>();

            public String toString() {
                return "" + this.occurrence.size() + " * " + this.occurrence.get(0).toString();
            }
        }
    }

    private static class CmdArgs
    extends Arguments {
        List<FileFunctions.FilePathnameExt> listfIn = new LinkedList<FileFunctions.FilePathnameExt>();
        File fLog;
        File fInCfg;
        File fdOut;
        File fWriteXmlConfigText;
        File fxOut;
        File dirDbg;
        File dirCreateCfgJavaData;
        String sPkgJava;
        String sClassJava;
        Arguments.Argument[] argsXmlJzCfgAnalyzer = new Arguments.Argument[]{new Arguments.Argument("-iXML", ":D:/path/to/file.xml to analyze", new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                File file = new File(string);
                listfIn.add(new FileFunctions.FilePathnameExt(file, null));
                return file.exists();
            }
        }), new Arguments.Argument("-iXml", ":\"D:/path/to/file.xml\" or \"...zip:content.xml\" to analyze a stored XML in a zip format", new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) throws FileNotFoundException {
                int n = FileFunctions.FilePathnameExt.parseWildcardZipPath(listfIn, null, string, ':');
                return n > 0;
            }
        }), new Arguments.Argument("-iCfg", ":D:/path/to/file.cfg a given config file to supplement or for genJavaClass", new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                fInCfg = new File(string);
                return fInCfg.exists();
            }
        }), new Arguments.Argument("-oCfg", ":D:/path/to/file.xml or file.txt to write the config as cfg.xml or cfg.txt", new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                File file = new File(string);
                if (!file.getParentFile().exists()) {
                    return false;
                }
                if (string.endsWith(".xml")) {
                    fxOut = new File(string);
                } else {
                    fWriteXmlConfigText = new File(string);
                }
                return true;
            }
        }), new Arguments.Argument("-genJavaData", ":path/to/JavaDir:pkg.path.Classname - Generates new versions of Java data in pkg path", new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) throws IOException {
                FileFunctions.FilePathnameExt filePathnameExt = FileFunctions.FilePathnameExt.parseZipPath(null, string, ':');
                File file = filePathnameExt.file;
                if (!file.exists() || !file.isDirectory()) {
                    return this.errMsg("-genJavaData:%s ERROR not found as directory", new Object[]{file});
                }
                dirCreateCfgJavaData = file;
                int n = filePathnameExt.sNamePath.lastIndexOf(46);
                if (n < 0) {
                    this.errMsg("\"-genJavaData pathToDir:pkg.Class\" not correct, \".Class\" not found: %s ", new Object[]{filePathnameExt.sNamePath});
                }
                sPkgJava = filePathnameExt.sNamePath.substring(0, n);
                sClassJava = filePathnameExt.sNamePath.substring(n + 1);
                return true;
            }
        }), new Arguments.Argument("-log", ":D:/path/to/logfile.txt", new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) throws FileNotFoundException {
                fLog = new File(string);
                return fLog.getParentFile().exists();
            }
        }), new Arguments.Argument("-dirDebug", ":D:/path/to/xmlCfg.txt in given write debug info", new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) throws FileNotFoundException {
                dirDbg = new File(string);
                return dirDbg.exists();
            }
        })};

        CmdArgs() {
            this.aboutInfo = "...your about info";
            this.helpInfo = "obligate args: -o:...";
            for (Arguments.Argument argument : this.argsXmlJzCfgAnalyzer) {
                this.addArg(argument);
            }
        }

        @Override
        public boolean testConsistence(Appendable appendable) throws IOException {
            boolean bl = true;
            if (!bl) {
                super.showHelp(appendable);
            }
            return bl;
        }
    }
}

