/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.vishia.util.Assert;
import org.vishia.util.CalculatorExpr;
import org.vishia.util.Debugutil;
import org.vishia.util.ExcUtil;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPartScan;
import org.vishia.util.TreeNodeBase;

public class DataAccess {
    public static final String sVersion = "2024-02-10";
    private static Map<String, Conversion> idxConversions = DataAccess.initConversion();
    private static String debugIdent;
    private static String debugMethod;
    protected List<DatapathElement> listDatapath;
    protected DatapathElement oneDatapathElement;

    public DataAccess(String string) throws ParseException {
        if ("$+%!".indexOf(string.charAt(0)) >= 0) {
            DatapathElement datapathElement = new DatapathElement(string);
            this.add_datapathElement(datapathElement);
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\.")) {
                DatapathElement datapathElement = new DatapathElement(string2);
                this.add_datapathElement(datapathElement);
            }
        }
    }

    public DataAccess(String string, char c) throws ParseException {
        assert (this.listDatapath == null && this.oneDatapathElement == null);
        String[] stringArray = string.split("\\.");
        DatapathElement datapathElement = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            datapathElement = new DatapathElement(string2);
            this.add_datapathElement(datapathElement);
        }
        if (c >= 'A' && c <= 'Z' && datapathElement != null) {
            datapathElement.whatisit = c;
        }
    }

    public DataAccess(StringPartScan stringPartScan, Map<String, IntegerIx> map, Class<?> clazz, char c) throws ParseException {
        boolean bl = true;
        do {
            DatapathElement datapathElement = new DatapathElement(stringPartScan, map, clazz, bl);
            if (c >= 'A' && c <= 'Z' && datapathElement != null) {
                datapathElement.whatisit = c;
            }
            this.add_datapathElement(datapathElement);
            bl = false;
        } while (stringPartScan.scan(".").scanOk());
    }

    public DataAccess() {
    }

    public final List<DatapathElement> datapath() {
        if (this.oneDatapathElement != null) {
            LinkedList<DatapathElement> linkedList = new LinkedList<DatapathElement>();
            linkedList.add(this.oneDatapathElement);
            return linkedList;
        }
        return this.listDatapath;
    }

    public final DatapathElement dataPath1() {
        return this.oneDatapathElement;
    }

    public void add_datapathElement(DatapathElement datapathElement) {
        if (this.listDatapath == null) {
            if (this.oneDatapathElement == null) {
                this.oneDatapathElement = datapathElement;
            } else {
                this.listDatapath = new ArrayList<DatapathElement>();
                this.listDatapath.add(this.oneDatapathElement);
                this.oneDatapathElement = null;
                this.listDatapath.add(datapathElement);
            }
        } else {
            this.listDatapath.add(datapathElement);
        }
    }

    public Object access(Object object, boolean bl, boolean bl2, Map<String, IntegerIx> map, Object[] objectArray) throws Exception {
        return this.access(object, bl, bl2, map, objectArray, false, null);
    }

    public Object access(Object object, boolean bl, boolean bl2, Map<String, IntegerIx> map, Object[] objectArray, boolean bl3, Dst dst) throws Exception {
        if (this.oneDatapathElement != null) {
            Object object2;
            Object object3 = DataAccess.access(this.oneDatapathElement, object, bl, bl2, map, objectArray, bl3, dst);
            if (object3 instanceof Variable && !bl3) {
                object2 = (Variable)object3;
                object3 = ((Variable)object2).value;
            }
            if (object3 == null) {
                return null;
            }
            if (bl2) {
                if (object3.getClass().isArray()) {
                    return object3;
                }
                if (object3 instanceof Iterable || object3 instanceof Map) {
                    return object3;
                }
                object2 = new LinkedList();
                object2.add(object3);
                return object2;
            }
            return object3;
        }
        return DataAccess.access(this.listDatapath, object, bl, bl2, map, objectArray, bl3, dst);
    }

    public static void XXXstoreValue(List<DatapathElement> list, Object object, Object object2, boolean bl) throws Exception {
        Dst dst = new Dst();
        Object object3 = DataAccess.access(list, object, bl, false, null, null, true, dst);
        if (object3 instanceof Variable) {
            Variable variable = (Variable)object3;
            variable.setValue(object2);
        } else {
            dst.set(object2);
        }
    }

    public static void storeValue(DatapathElement datapathElement, Object object, Object object2, boolean bl) throws Exception {
        Dst dst = new Dst();
        Object object3 = DataAccess.access(datapathElement, object, bl, false, null, null, true, dst);
        if (object3 instanceof Variable) {
            Variable variable = (Variable)object3;
            variable.setValue(object2);
        } else {
            dst.set(object2);
        }
    }

    public void storeValue(Object object, Object object2, boolean bl) throws Exception {
        Dst dst = new Dst();
        Object object3 = this.access(object, bl, false, null, null, true, dst);
        if (object3 instanceof Variable) {
            Variable variable = (Variable)object3;
            variable.setValue(object2);
        } else {
            dst.set(object2);
        }
    }

    static Map<String, Conversion> initConversion() {
        TreeMap<String, Conversion> treeMap = new TreeMap<String, Conversion>();
        treeMap.put("org.vishia.util.CalculatorExpr$Value:int", Conversions.calcValue2int);
        treeMap.put("java.lang.Long:int", Conversions.long2int);
        treeMap.put("java.lang.Integer:boolean", Conversions.int2bool);
        treeMap.put("java.lang.Integer:byte", Conversions.int2byte);
        treeMap.put("java.lang.Integer:short", Conversions.int2short);
        treeMap.put("java.lang.Integer:int", Conversions.obj2obj);
        treeMap.put("java.lang.Integer:long", Conversions.int2long);
        treeMap.put("java.lang.Integer:float", Conversions.int2float);
        treeMap.put("java.lang.Integer:double", Conversions.int2double);
        treeMap.put("java.lang.Integer:char", Conversions.int2char);
        treeMap.put("java.lang.Float:float", Conversions.obj2obj);
        treeMap.put("java.lang.Float:double", Conversions.float2double);
        treeMap.put("java.lang.Double:double", Conversions.obj2obj);
        treeMap.put("java.lang.Double:float", Conversions.double2float);
        treeMap.put("java.lang.Number:boolean", Conversions.number2bool);
        treeMap.put("java.lang.Number:char", Conversions.number2char);
        treeMap.put("java.lang.Boolean:boolean", Conversions.obj2obj);
        treeMap.put("java.lang.Object:boolean", Conversions.obj2bool);
        treeMap.put("java.lang.CharSequence:char", Conversions.charSeq2char);
        treeMap.put("java.lang.CharSequence:java.lang.String", Conversions.charSequence2String);
        return treeMap;
    }

    private static final Class<?> getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<DatapathElement> expandElements(CharSequence charSequence, char n) throws ParseException {
        int n2;
        int n3;
        LinkedList<DatapathElement> linkedList = new LinkedList<DatapathElement>();
        int n4 = charSequence.charAt(0);
        if ("&@$".indexOf(n4) >= 0) {
            n3 = 0;
        } else {
            n3 = -1;
            n4 = n;
        }
        int n5 = charSequence.length();
        do {
            if ((n2 = StringFunctions.indexOf(charSequence, '.', n3 + 1)) < 0) {
                n2 = n5;
            }
            String string = charSequence.subSequence(n3 + 1, n2).toString();
            DatapathElement datapathElement = new DatapathElement(string);
            datapathElement.whatisit = n4;
            n4 = 46;
            linkedList.add(datapathElement);
        } while ((n3 = n2) < n5);
        return linkedList;
    }

    public static Object access(CharSequence charSequence, Object object, boolean bl, boolean bl2, boolean bl3, Dst dst) throws Exception {
        if (StringFunctions.startsWith(charSequence, "%")) {
            DatapathElement datapathElement = new DatapathElement(charSequence.toString());
            return DataAccess.access(datapathElement, object, bl, bl2, null, null, bl3, dst);
        }
        List<DatapathElement> list = DataAccess.expandElements(charSequence, '.');
        return DataAccess.access(list, object, bl, bl2, null, null, bl3, dst);
    }

    public static Object access(List<DatapathElement> list, Object list2, boolean bl, boolean bl2, Map<String, IntegerIx> map, Object[] objectArray, boolean bl3, Dst dst) throws Exception {
        Object object;
        Object object2;
        Iterator<DatapathElement> iterator = list.iterator();
        DatapathElement datapathElement = iterator.next();
        if ("+%".indexOf(datapathElement.whatisit) < 0 && datapathElement.ident != null && datapathElement.ident.contains(".")) {
            object2 = DataAccess.expandElements(datapathElement.ident, datapathElement.whatisit);
            iterator = object2.iterator();
            datapathElement = iterator.next();
        }
        object2 = list2;
        while (datapathElement != null) {
            if (debugIdent != null && datapathElement.ident != null && datapathElement.ident.equals(debugIdent)) {
                DataAccess.debug();
            }
            object2 = DataAccess.access(datapathElement, object2, bl, bl2, map, objectArray, bl3, dst);
            datapathElement = iterator.hasNext() ? iterator.next() : null;
        }
        if (object2 instanceof Variable && !bl3) {
            object = (Variable)object2;
            object2 = ((Variable)object).value;
        }
        if (object2 == null) {
            return null;
        }
        if (bl2) {
            if (object2.getClass().isArray()) {
                return object2;
            }
            if (object2 instanceof Iterable || object2 instanceof Map) {
                return object2;
            }
            object = new LinkedList();
            object.add(object2);
            return object;
        }
        return object2;
    }

    public static Object access(DatapathElement datapathElement, Object object, boolean bl, boolean bl2, Map<String, IntegerIx> map, Object[] objectArray, boolean bl3, Dst dst) throws Exception {
        Object object2;
        boolean bl4;
        Object object3 = object;
        if (object3 instanceof Class) {
            bl4 = true;
        } else if (object3 instanceof Variable) {
            Variable variable = (Variable)object3;
            bl4 = variable.type == 'C';
            object3 = variable.value;
        } else {
            bl4 = false;
        }
        boolean bl5 = false;
        if (datapathElement.reflAccess != null) {
            if (datapathElement.reflAccess instanceof Field) {
                object3 = ((Field)datapathElement.reflAccess).get(object3);
                bl5 = true;
                Debugutil.stop();
            } else {
                bl5 = false;
            }
        }
        if (!bl5) {
            switch (datapathElement.whatisit) {
                case '&': {
                    Object object4 = datapathElement.args[0].calc(map, objectArray);
                    assert (object4 instanceof String);
                    if (map != null) {
                        object2 = map.get((String)object4);
                        if (object2 != null) {
                            object3 = objectArray[((IntegerIx)object2).ix];
                            break;
                        }
                        throw new IllegalArgumentException(" variable with name in &(>>" + object4 + "<<) not found");
                    }
                    if (!(object3 instanceof Map)) break;
                    Debugutil.todo();
                    break;
                }
                case '@': {
                    if (datapathElement.ixData < 0) {
                        if (object3 != null && object3 instanceof Map) {
                            object3 = ((Map)object3).get(datapathElement.ident);
                            break;
                        }
                        object3 = null;
                        break;
                    }
                    object3 = objectArray[datapathElement.ixData];
                    break;
                }
                case '.': {
                    if (bl4) {
                        object3 = DataAccess.getDataFromField(datapathElement.ident, null, bl, (Class)object3, dst, 0);
                        break;
                    }
                    if (object3 == null) break;
                    object3 = DataAccess.getDataPriv(datapathElement.ident, object3, bl, bl2, true, dst);
                    break;
                }
                case '+': {
                    object3 = DataAccess.invokeNew(datapathElement);
                    break;
                }
                case '(': {
                    if (object3 != null) {
                        Class clazz = bl4 && object3 instanceof Class ? (Class)object3 : object3.getClass();
                        object3 = DataAccess.invokeMethod(datapathElement, clazz, object3, bl, objectArray, false);
                        break;
                    }
                    Debugutil.stop();
                    break;
                }
                case '%': {
                    object3 = datapathElement.operation_ || datapathElement.args != null || datapathElement.fnArgs != null ? DataAccess.invokeStaticMethod(datapathElement, objectArray) : DataAccess.getStaticValue(datapathElement);
                    break;
                }
                case '$': {
                    if (object3 instanceof Map) {
                        Map map2 = (Map)object3;
                        object3 = map2.get("$" + datapathElement.ident);
                    }
                    if (object3 == null) {
                        object3 = System.getenv(datapathElement.ident);
                    }
                    if (object3 == null) {
                        object3 = System.getProperty(datapathElement.ident);
                    }
                    if (object3 != null) break;
                    throw new NoSuchElementException("DataAccess - environment variable not found: >>" + datapathElement.ident + "<<");
                }
                default: {
                    boolean bl6;
                    char c = datapathElement.whatisit;
                    if (datapathElement.whatisit >= 'a' && datapathElement.whatisit <= 'z') {
                        bl6 = true;
                        c = (char)(c - 32);
                    } else {
                        bl6 = false;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        if (object3 instanceof Map) {
                            Map map3 = (Map)object3;
                            Variable<Object> variable = new Variable<Object>(datapathElement.whatisit, datapathElement.ident, null, bl6);
                            map3.put(datapathElement.ident, variable);
                            object3 = variable;
                            break;
                        }
                        throw new IllegalArgumentException("DataAccess.storeValue - destination should be Map<String, DataAccess.Variable>; " + dst);
                    }
                    if (bl4) {
                        object3 = DataAccess.getDataFromField(datapathElement.ident, null, bl, (Class)object3, dst, 0);
                        break;
                    }
                    if (object3 == null) break;
                    object3 = DataAccess.getDataPriv(datapathElement.ident, object3, bl, bl2, bl3, dst);
                }
            }
        }
        if (object3 != null && datapathElement.indices != null) {
            int[] nArray;
            if (datapathElement.indices[0] < 0) {
                object2 = datapathElement.args[0].calc(map, objectArray);
                nArray = new int[1];
                if (object2 instanceof Integer) {
                    nArray[0] = (Integer)object2;
                } else {
                    Debugutil.stop();
                }
            } else {
                nArray = datapathElement.indices;
            }
            object3 = DataAccess.getArrayElement(object3, nArray);
        }
        return object3;
    }

    protected static Object invokeNew(DatapathElement datapathElement) throws Exception {
        Constructor<?>[] constructorArray;
        Class<?> clazz;
        if (datapathElement instanceof DatapathElementClass && ((DatapathElementClass)datapathElement).clazz != null) {
            clazz = ((DatapathElementClass)datapathElement).clazz;
        } else {
            constructorArray = datapathElement.ident;
            if (debugIdent != null && constructorArray.equals(debugIdent)) {
                DataAccess.debug();
            }
            ClassLoader classLoader = DataAccess.getClassLoader(datapathElement);
            clazz = classLoader.loadClass((String)constructorArray);
        }
        constructorArray = clazz.getConstructors();
        boolean bl = false;
        Object var4_5 = null;
        if (constructorArray.length == 0 && datapathElement.fnArgs == null) {
            var4_5 = clazz.newInstance();
            bl = var4_5 != null;
        } else {
            for (Constructor<?> constructor : constructorArray) {
                bl = false;
                Class<?>[] object = constructor.getParameterTypes();
                Object[] objectArray = DataAccess.checkAndConvertArgTypes(datapathElement.fnArgs, object);
                if (objectArray == null) continue;
                bl = true;
                try {
                    var4_5 = constructor.newInstance(objectArray);
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    CharSequence charSequence = Assert.stackInfo(" called ", 3, 5);
                    throw new NoSuchMethodException("DataAccess - method access problem: >>" + clazz.getName() + "." + datapathElement.ident + "(...)<<\n ..." + charSequence);
                }
                catch (InstantiationException instantiationException) {
                    CharSequence charSequence = Assert.stackInfo(" called ", 3, 5);
                    throw new NoSuchMethodException("DataAccess - new invocation problem: >>" + clazz.getName() + "." + datapathElement.ident + "(...)<<\n ..." + charSequence);
                }
            }
        }
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder(1000);
            stringBuilder.append("DataAccess - constructor not found in class: >>").append(clazz.getName()).append(", ").append(datapathElement.ident).append("(");
            if (datapathElement.fnArgs != null) {
                for (Object object : datapathElement.fnArgs) {
                    stringBuilder.append(object.getClass()).append(", ");
                }
            } else if (datapathElement.args != null) {
                for (CalculatorExpr.Operand operand : datapathElement.args) {
                    stringBuilder.append(operand.textOrVar).append(", ");
                }
            }
            stringBuilder.append(")<<\n ... stackInfo: ");
            CharSequence charSequence = Assert.stackInfo(stringBuilder, 3, 8);
            throw new NoSuchMethodException(charSequence.toString());
        }
        return var4_5;
    }

    public static Object invokeMethod(DatapathElement datapathElement, Class<?> clazz, Object object, boolean bl, Object[] objectArray, boolean bl2) throws InvocationTargetException, NoSuchMethodException, Exception {
        Object[] objectArray2 = null;
        if (datapathElement.ident.equals("genExprOut")) {
            Debugutil.stop();
        }
        if (datapathElement.fnArgs == null && datapathElement.args != null) {
            objectArray2 = new Object[datapathElement.args.length];
            int n = -1;
            for (CalculatorExpr.Operand operand : datapathElement.args) {
                objectArray2[++n] = operand.calc(null, objectArray);
            }
        }
        return DataAccess.invokeMethodWithGivenArgValues(datapathElement, clazz, object, bl, bl2, objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeMethodWithGivenArgValues(DatapathElement datapathElement, Class<?> clazz, Object object, boolean bl, boolean bl2, Object[] objectArray) throws InvocationTargetException, NoSuchMethodException, Exception {
        int n;
        Object object2;
        Object[] objectArray2;
        Object[] objectArray3;
        Method methodArray;
        Class<?> clazz2;
        Object object3 = null;
        if (datapathElement.ident.equals("prcEvChain")) {
            Debugutil.stop();
        }
        Class<?> clazz3 = clazz2 = (methodArray = (Method)datapathElement.reflAccess) != null ? methodArray.getDeclaringClass() : (clazz == null ? object.getClass() : clazz);
        Object[] objectArray4 = objectArray3 = objectArray != null ? objectArray : datapathElement.fnArgs;
        if (datapathElement.ident.equals("new_draw_polygon")) {
            Debugutil.stop();
        }
        while (methodArray == null && clazz3 != null) {
            if (bl || (clazz3.getModifiers() & 1) != 0) {
                Method[] methodArray2 = bl ? clazz3.getDeclaredMethods() : clazz3.getMethods();
                for (Method objectArray5 : methodArray2) {
                    if (!objectArray5.getName().equals(datapathElement.ident)) continue;
                    if (debugMethod != null && (debugMethod.equals(datapathElement.ident) || debugMethod.equals(""))) {
                        DataAccess.debug();
                        if (debugMethod.equals("")) {
                            debugMethod = null;
                        }
                    }
                    if ((objectArray2 = DataAccess.checkAndConvertArgTypes(objectArray3, object2 = objectArray5.getParameterTypes())) == null) continue;
                    methodArray = objectArray5;
                    break;
                }
            }
            if (methodArray != null) continue;
            clazz3 = clazz3.getSuperclass();
        }
        boolean bl3 = false;
        Object object4 = "Method not found";
        if (methodArray != null) {
            if (datapathElement.reflAccess == null) {
                // empty if block
            }
            try {
                methodArray.setAccessible(bl);
            }
            catch (Exception exception) {
                Debugutil.stop();
            }
            Class<?>[] classArray = methodArray.getParameterTypes();
            Object[] objectArray6 = DataAccess.checkAndConvertArgTypes(objectArray3, classArray);
            if (objectArray6 != null) {
                try {
                    object3 = methodArray.invoke(object, objectArray6);
                    object4 = null;
                }
                catch (Exception exception) {
                    void var18_43;
                    void var21_58;
                    object2 = "";
                    objectArray2 = exception.getCause();
                    if (objectArray2 != null) {
                        String string = "cause: " + objectArray2.getMessage();
                    } else {
                        String string = "";
                    }
                    Object[] objectArray5 = objectArray6;
                    n = objectArray5.length;
                    boolean bl4 = false;
                    while (var21_58 < n) {
                        Object object5 = objectArray5[var21_58];
                        object2 = object2 + ", " + object5;
                        ++var21_58;
                    }
                    object4 = ExcUtil.exceptionInfo("DataAccess - Exc in method: " + object.toString() + "." + methodArray.getName() + "(...): " + (String)var18_43, exception, 0, 10);
                    if (!bl2) {
                        throw new InvocationTargetException(exception.getCause(), object4.toString());
                    }
                    object3 = "<?? " + object4 + " ??>";
                }
            }
        }
        if (object4 != null) {
            StringBuilder stringBuilder = new StringBuilder(1000);
            stringBuilder.append((CharSequence)object4);
            if (methodArray != null) {
                clazz3 = clazz2;
                do {
                    Method[] methodArray3;
                    if (!bl && (clazz3.getModifiers() & 1) == 0) continue;
                    for (Method method : methodArray3 = bl ? clazz3.getDeclaredMethods() : clazz3.getMethods()) {
                        bl3 = false;
                        if (!method.getName().equals(datapathElement.ident)) continue;
                        Parameter[] parameterArray = method.getParameters();
                        stringBuilder.append("  ").append(clazz3.getName()).append(".").append(method.getName()).append("(");
                        n = 0;
                        for (Parameter parameter : parameterArray) {
                            if (n != 0) {
                                stringBuilder.append(", ");
                            } else {
                                n = 1;
                            }
                            stringBuilder.append(parameter.getType().getName());
                        }
                        stringBuilder.append(")\n");
                    }
                } while (!bl3 && (clazz3 = clazz3.getSuperclass()) != null);
                stringBuilder.append("  ... given arg names: ");
                boolean bl4 = false;
                if (datapathElement.args != null) {
                    void var18_47;
                    boolean bl5 = false;
                    CalculatorExpr.Operand[] operandArray = datapathElement.args;
                    int n2 = operandArray.length;
                    boolean bl6 = false;
                    while (var18_47 < n2) {
                        void var15_30;
                        CalculatorExpr.Operand operand = operandArray[var18_47];
                        if (bl4) {
                            stringBuilder.append(", ");
                        } else {
                            bl4 = true;
                        }
                        stringBuilder.append(operand.textOrVar).append(": ");
                        Object object6 = objectArray3[++var15_30];
                        stringBuilder.append(object6 == null ? "null" : object6.getClass());
                        ++var18_47;
                    }
                }
                stringBuilder.append("<<;\n  ... stackInfo: ");
                CharSequence charSequence = Assert.stackInfo(stringBuilder, 3, 5);
                if (debugMethod != null && debugMethod.equals("")) {
                    DataAccess.debug();
                    debugMethod = null;
                }
            } else {
                stringBuilder.append("DataAccess - method not found, searched:\n  ");
                stringBuilder.append(clazz2.getName()).append(".").append(datapathElement.ident).append("(");
                boolean bl5 = false;
                if (objectArray != null) {
                    for (Object object7 : objectArray) {
                        if (bl5) {
                            stringBuilder.append(", ");
                        } else {
                            bl5 = true;
                        }
                        if (object7 == null) {
                            stringBuilder.append("null");
                            continue;
                        }
                        stringBuilder.append(object7.getClass());
                    }
                }
                stringBuilder.append(")\n");
            }
            if (!bl2) {
                throw new NoSuchMethodException(stringBuilder.toString());
            }
        }
        return object3;
    }

    protected static Object invokeStaticMethod(DatapathElement datapathElement, Object[] objectArray) throws Exception {
        Object[] objectArray2;
        Method[] methodArray;
        String string;
        Class<?> clazz;
        if (datapathElement instanceof DatapathElementClass && ((DatapathElementClass)datapathElement).clazz != null) {
            clazz = ((DatapathElementClass)datapathElement).clazz;
            string = datapathElement.ident;
        } else {
            int n = datapathElement.ident.lastIndexOf(46);
            methodArray = datapathElement.ident.substring(0, n);
            string = datapathElement.ident.substring(n + 1);
            CalculatorExpr.Operand[] operandArray = DataAccess.getClassLoader(datapathElement);
            clazz = operandArray.loadClass((String)methodArray);
        }
        if (datapathElement.fnArgs != null) {
            objectArray2 = datapathElement.fnArgs;
        } else if (datapathElement.args != null) {
            objectArray2 = new Object[datapathElement.args.length];
            int n = -1;
            for (CalculatorExpr.Operand operand : datapathElement.args) {
                objectArray2[++n] = operand.calc(null, objectArray);
            }
        } else {
            objectArray2 = null;
        }
        methodArray = clazz.getMethods();
        boolean bl = false;
        Object object = null;
        for (Method method : methodArray) {
            Class<?>[] object2;
            Object[] objectArray3;
            bl = false;
            String string2 = method.getName();
            if (!string2.equals(string)) continue;
            if (debugMethod != null && (debugMethod.equals(datapathElement.ident) || debugMethod.equals(""))) {
                DataAccess.debug();
                if (debugMethod.equals("")) {
                    debugMethod = null;
                }
            }
            if ((objectArray3 = DataAccess.checkAndConvertArgTypes(objectArray2 != null ? objectArray2 : datapathElement.fnArgs, object2 = method.getParameterTypes())) == null) continue;
            if ((method.getModifiers() & 8) == 0) {
                throw new IllegalArgumentException("DataAccess - invokeStaticMethod on non static method, " + string);
            }
            bl = true;
            try {
                object = method.invoke(null, objectArray3);
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                CharSequence charSequence = Assert.stackInfo(" called ", 3, 5);
                throw new NoSuchMethodException("DataAccess - method access problem:\n in class: >>" + clazz.getName() + "." + datapathElement.ident + "(...)<<\n ... stackInfo:" + charSequence);
            }
        }
        if (!bl) {
            Object[] objectArray4;
            StringBuilder stringBuilder = new StringBuilder(1000);
            stringBuilder.append("DataAccess - static method not found: ").append(datapathElement.ident).append("(");
            Object[] objectArray5 = objectArray4 = objectArray2 != null ? objectArray2 : datapathElement.fnArgs;
            if (objectArray4 != null) {
                for (Object object2 : objectArray4) {
                    if (object2 == null) {
                        stringBuilder.append("null, ");
                        continue;
                    }
                    stringBuilder.append(object2.getClass()).append(", ");
                }
            } else if (datapathElement.args != null) {
                for (CalculatorExpr.Operand operand : datapathElement.args) {
                    stringBuilder.append(operand.textOrVar).append(", ");
                }
            }
            stringBuilder.append(")|, ");
            CharSequence charSequence = Assert.stackInfo(stringBuilder, 3, 5);
            if (debugMethod != null && debugMethod.equals("")) {
                DataAccess.debug();
                debugMethod = null;
            }
            throw new NoSuchMethodException(charSequence.toString());
        }
        return object;
    }

    protected static Object getStaticValue(DatapathElement datapathElement) throws Exception {
        String string;
        Class<?> clazz;
        if (datapathElement instanceof DatapathElementClass && ((DatapathElementClass)datapathElement).clazz != null) {
            clazz = ((DatapathElementClass)datapathElement).clazz;
            string = datapathElement.ident;
        } else {
            int n = datapathElement.ident.lastIndexOf(46);
            String string2 = datapathElement.ident.substring(0, n);
            string = datapathElement.ident.substring(n + 1);
            ClassLoader classLoader = DataAccess.getClassLoader(datapathElement);
            clazz = classLoader.loadClass(string2);
        }
        return DataAccess.getDataFromField(string, null, false, clazz, null, 0);
    }

    private static ClassLoader getClassLoader(DatapathElement datapathElement) {
        ClassLoader classLoader = datapathElement.getClass().getClassLoader();
        if (datapathElement instanceof DatapathElementClass) {
            DatapathElementClass datapathElementClass = (DatapathElementClass)datapathElement;
            if (datapathElementClass.loader != null) {
                classLoader = datapathElementClass.loader;
            }
        }
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    protected static Object[] checkAndConvertArgTypes(Object[] objectArray, Class<?>[] classArray) {
        int n;
        Object[] objectArray2 = null;
        if (classArray.length == 1 && classArray[0].isArray() && classArray[0].getName().equals("[Ljava.lang.String;")) {
            if (objectArray == null) {
                objectArray2 = new Object[]{new Object[0]};
            } else {
                Object[] objectArray3 = new Object[objectArray.length];
                objectArray2 = new Object[]{objectArray3};
                n = -1;
                for (Object object : objectArray) {
                    if (!(object instanceof CharSequence)) {
                        objectArray2 = null;
                        break;
                    }
                    objectArray3[++n] = ((CharSequence)object).toString();
                }
            }
        }
        if (objectArray2 == null) {
            if (classArray.length == 0 && objectArray == null) {
                objectArray2 = new Object[]{};
            } else if (objectArray != null && (classArray.length == objectArray.length || classArray.length > 0 && classArray.length < objectArray.length && classArray[classArray.length - 1].isArray())) {
                Object object;
                Object[] objectArray3;
                boolean bl = true;
                n = 0;
                Object var5_7 = null;
                Conversion[] conversionArray = new Conversion[objectArray.length];
                int n2 = -1;
                int n3 = -1;
                boolean bl2 = false;
                while (bl && ++n3 < objectArray.length) {
                    objectArray3 = objectArray[n3];
                    bl = false;
                    ++n2;
                    if (objectArray3 == null) {
                        bl = true;
                        conversionArray[n2] = Conversions.obj2obj;
                    } else {
                        object = null;
                        Class<?> clazz = objectArray3.getClass();
                        if (classArray[n].isArray() && objectArray3 instanceof List && DataAccess.istypeof(((List)objectArray3).get(0), classArray[n].getComponentType())) {
                            object = Conversions.list2array;
                        } else if (n == classArray.length - 1 && classArray[n].isArray() && (objectArray.length > n + 1 || objectArray.length == n + 1 && !clazz.isArray())) {
                            Class<?> clazz2 = classArray[n].getComponentType();
                            bl2 = true;
                        } else {
                            Class<?> clazz3 = classArray[n];
                        }
                        if (object == null) {
                            void var5_8;
                            object = DataAccess.checkArgTypes(var5_8, clazz, objectArray3);
                        }
                        if (object != null) {
                            conversionArray[n2] = object;
                            bl = true;
                        }
                        if (!bl) break;
                    }
                    if (n >= classArray.length - 1) continue;
                    ++n;
                }
                if (bl) {
                    objectArray3 = bl2 ? ((object = classArray[classArray.length - 1].getComponentType()) == String.class ? new String[objectArray.length - classArray.length + 1] : new Object[objectArray.length - classArray.length + 1]) : null;
                    object = objectArray2 = new Object[classArray.length];
                    n = 0;
                    n2 = -1;
                    for (Object object2 : objectArray) {
                        Object object3;
                        ++n2;
                        if (object == objectArray2) {
                            if (n >= classArray.length - 1 && objectArray3 != null) {
                                objectArray2[n] = objectArray3;
                                object = objectArray3;
                                n = 0;
                                Class<?> clazz = classArray[n].getComponentType();
                            } else {
                                Class<?> clazz = classArray[n];
                            }
                        }
                        assert (conversionArray[n2] != null);
                        object[n] = object3 = conversionArray[n2].convert(object2);
                        ++n;
                    }
                } else {
                    objectArray2 = null;
                }
            } else {
                objectArray2 = null;
            }
        }
        return objectArray2;
    }

    public static Conversion checkArgTypes(Class<?> clazz, Class<?> clazz2, Object object) {
        Conversion conversion = null;
        Class<?> clazz3 = clazz2;
        while (conversion == null && clazz3 != null) {
            conversion = DataAccess.checkIfcTypes(clazz, clazz3, object);
            if (conversion != null) continue;
            clazz3 = clazz3.getSuperclass();
        }
        return conversion;
    }

    private static Conversion checkIfcTypes(Class<?> clazz, Class<?> clazz2, Object object) {
        Conversion conversion = DataAccess.checkTypes(clazz, clazz2, object);
        if (conversion == null) {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = -1;
            int n2 = classArray.length;
            while (conversion == null && ++n < n2) {
                Class<?> clazz3 = classArray[n];
                conversion = DataAccess.checkIfcTypes(clazz, clazz3, object);
            }
        }
        return conversion;
    }

    public static Conversion checkTypes(Class<?> clazz, Class<?> clazz2, Object object) {
        if (clazz == clazz2) {
            return Conversions.obj2obj;
        }
        String string = clazz2.getName() + ":" + clazz.getName();
        Conversion conversion = idxConversions.get(string);
        if (conversion != null && !conversion.canConvert(object)) {
            conversion = null;
        }
        return conversion;
    }

    public static final boolean istypeof(Object object, String string) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(string);
        return DataAccess.istypeof(object, clazz);
    }

    public static final boolean istypeof(Object object, Class clazz) {
        if (object == null) {
            return false;
        }
        Class<?> clazz2 = object.getClass();
        do {
            if (clazz2 != clazz) continue;
            return true;
        } while ((clazz2 = clazz2.getSuperclass()) != null);
        return false;
    }

    public static Object getData(String string, Object object, boolean bl, boolean bl2, boolean bl3, Dst dst) throws NoSuchFieldException, IllegalAccessException {
        Object object2;
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            object2 = variable.value;
        } else {
            object2 = object;
        }
        return DataAccess.getDataPriv(string, object2, bl, bl2, bl3, dst);
    }

    private static Object getDataPriv(String string, Object object, boolean bl, boolean bl2, boolean bl3, Dst dst) throws NoSuchFieldException, IllegalAccessException {
        Object object2;
        if (string.equals("cellx")) {
            Debugutil.stop();
        }
        List<Object> list = null;
        if (string.equals("[]")) {
            if (object instanceof Object[]) {
                return new Integer(((Object[])object).length);
            }
            if (object instanceof Collection) {
                return new Integer(((Collection)object).size());
            }
            if (object instanceof Map) {
                return new Integer(((Map)object).size());
            }
            throw new IllegalArgumentException("is not a container or array, " + string);
        }
        if (object instanceof Map) {
            object2 = (Map)object;
            list = (List<Object>)object2.get(string);
            if (list == null && !object2.containsKey(string)) {
                throw new NoSuchFieldException(string);
            }
        } else {
            try {
                list = DataAccess.getDataFromField(string, object, bl, dst);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (object instanceof TreeNodeBase) {
                    TreeNodeBase treeNodeBase = (TreeNodeBase)object;
                    list = bl2 ? treeNodeBase.listChildren(string) : treeNodeBase.getChild(string);
                    if (list == null) {
                        throw new NoSuchFieldException(string + " ;in TreeNode, contains; " + treeNodeBase.toString());
                    }
                }
                throw noSuchFieldException;
            }
        }
        if (!bl3 && list instanceof Variable) {
            object2 = (Variable)((Object)list);
            list = ((Variable)object2).value;
        }
        return list;
    }

    public static Object getDataFromField(String string, Object object, boolean bl, Dst dst) throws NoSuchFieldException, IllegalAccessException {
        return DataAccess.getDataFromField(string, object, bl, object.getClass(), dst, 0);
    }

    private static Object getDataFromField(String string, Object object, boolean bl, Class<?> clazz, Dst dst, int n) throws NoSuchFieldException, IllegalAccessException {
        AnnotatedElement annotatedElement;
        if (n > 100) {
            throw new IllegalArgumentException("recursion error");
        }
        Object object2 = null;
        boolean bl2 = false;
        try {
            annotatedElement = clazz.getDeclaredField(string);
            annotatedElement.setAccessible(bl);
            if (dst != null) {
                dst.field = annotatedElement;
                dst.obj = object;
            }
            object2 = annotatedElement.get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            bl2 = true;
        }
        if (bl2 && (annotatedElement = clazz.getSuperclass()) != null) {
            try {
                object2 = DataAccess.getDataFromField(string, object, bl, annotatedElement, dst, n + 1);
                bl2 = false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                bl2 = true;
            }
        }
        if (bl2 && (annotatedElement = clazz.getEnclosingClass()) != null) {
            Object object3 = DataAccess.getEnclosingInstance(object);
            try {
                object2 = DataAccess.getDataFromField(string, object3, bl, annotatedElement, dst, n + 1);
                bl2 = false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                bl2 = true;
            }
        }
        if (bl2) {
            throw new NoSuchFieldException(string + " ;in class ;" + clazz.getCanonicalName() + ", data," + (object == null ? "" : object.toString()));
        }
        return object2;
    }

    public static Object getEnclosingInstance(Object object) {
        return DataAccess.getEnclosingInstance(0, object);
    }

    private static Object getEnclosingInstance(int n, Object object) {
        Object object2;
        boolean bl = false;
        if (n > 10) {
            object2 = null;
        } else {
            String string = "this$" + n;
            try {
                Field field = object.getClass().getDeclaredField(string);
                field.setAccessible(true);
                object2 = field.get(object);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                bl = true;
                object2 = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                object2 = null;
            }
        }
        if (bl) {
            object2 = DataAccess.getEnclosingInstance(n + 1, object);
        }
        return object2;
    }

    public static boolean isReferenceToEnclosing(Field field) {
        return field.getName().startsWith("this$");
    }

    public static boolean isOrExtends(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3 = clazz;
        do {
            if (clazz3 != clazz2) continue;
            return true;
        } while ((clazz3 = clazz3.getSuperclass()) != null);
        return false;
    }

    public static String getStringFromObject(Object object, String string) {
        String string2;
        Object object2;
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            object2 = variable.value;
        } else {
            object2 = object;
        }
        if (object2 == null) {
            string2 = "";
        } else if (object2 instanceof String) {
            string2 = (String)object2;
        } else if (object2 instanceof Integer) {
            if (string != null) {
                try {
                    string2 = String.format(string, object2);
                }
                catch (Exception exception) {
                    string2 = "<??format:" + string + " exception:" + exception.getMessage() + "??>";
                }
            } else {
                int n = (Integer)object2;
                string2 = Integer.toString(n);
            }
        } else {
            string2 = object.toString();
        }
        return string2;
    }

    public static int getInt(Object object) {
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        if (object instanceof Float) {
            return (int)((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (int)((Double)object).doubleValue();
        }
        return 0;
    }

    public static float getFloat(Object object) {
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return ((Long)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (float)((Double)object).doubleValue();
        }
        return 0.0f;
    }

    public static int getLengthOfArray(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            Object[] objectArray = (Object[])object;
            return objectArray.length;
        }
        return -1;
    }

    public static Object getArrayElement(Object object, int ... nArray) {
        int n = 0;
        Object object2 = object;
        Class<?> clazz = object.getClass();
        while (clazz.isArray() && n < nArray.length) {
            Object[] objectArray;
            if ((clazz = clazz.getComponentType()) == Integer.TYPE) {
                objectArray = (int[])object2;
                object2 = objectArray[nArray[n]];
                continue;
            }
            if (clazz == Character.TYPE) {
                objectArray = (char[])object2;
                object2 = Character.valueOf(objectArray[nArray[n]]);
                continue;
            }
            if (clazz == Long.TYPE) {
                objectArray = (long[])object2;
                object2 = (long)objectArray[nArray[n]];
                continue;
            }
            if (clazz == Short.TYPE) {
                objectArray = (short[])object2;
                object2 = objectArray[nArray[n]];
                continue;
            }
            if (clazz == Byte.TYPE) {
                objectArray = (byte[])object2;
                object2 = objectArray[nArray[n]];
                continue;
            }
            if (clazz == Boolean.TYPE) {
                objectArray = (boolean[])object2;
                object2 = objectArray[nArray[n]];
                continue;
            }
            if (clazz == Float.TYPE) {
                objectArray = (float[])object2;
                object2 = Float.valueOf(objectArray[nArray[n]]);
                continue;
            }
            if (clazz == Double.TYPE) {
                objectArray = (double[])object2;
                object2 = (double)objectArray[nArray[n]];
                continue;
            }
            object2 = ((Object[])object2)[nArray[n]];
        }
        return object2;
    }

    public static int setBit(int n, int n2, boolean bl) {
        return bl ? n | n2 : n & ~n2;
    }

    public static Variable<Object> createOrReplaceVariable(Map<String, Variable<Object>> map, String string, char c, Object object, boolean bl) throws IllegalAccessException {
        Variable<Object> variable = map.get(string);
        if (variable == null) {
            variable = new Variable<Object>(c, string, object);
            variable.isConst = bl;
            map.put(string, variable);
        } else {
            if (variable.isConst && !bl) {
                throw new IllegalAccessException("DataAccess.setVariable - modification of const; " + variable.name);
            }
            variable.value = object;
            variable.type = c;
            variable.isConst = bl;
        }
        return variable;
    }

    public static void setVariable(Map<String, Variable<Object>> map, Variable<Object> variable) {
        Variable<Object> variable2 = map.get(variable.name);
        if (variable2 != null) {
            map.remove(variable.name);
        }
        map.put(variable.name, variable);
    }

    public static Variable<Object> getVariable(Map<String, Variable<Object>> map, String string, boolean bl) throws NoSuchFieldException {
        Variable<Object> variable = map.get(string);
        if (variable != null) {
            return variable;
        }
        if (bl) {
            throw new NoSuchFieldException("DataAccess.getVariable - not found; " + string);
        }
        return null;
    }

    public String toString() {
        return this.oneDatapathElement != null ? this.oneDatapathElement.toString() : (this.listDatapath != null ? this.listDatapath.toString() : "emtpy DataAccess");
    }

    public CharSequence idents() {
        int n;
        if (this.oneDatapathElement != null) {
            return this.oneDatapathElement.ident;
        }
        int n2 = n = this.listDatapath == null ? 0 : this.listDatapath.size();
        if (n == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (DatapathElement datapathElement : this.listDatapath) {
            stringBuilder.append(datapathElement.ident).append(".");
        }
        return stringBuilder;
    }

    public static void debugIdent(String string) {
        debugIdent = string;
    }

    public static void debugMethod(String string) {
        debugMethod = string;
    }

    protected static void debug() {
        Debugutil.stop();
    }

    public void writeStruct(Appendable appendable) throws IOException {
        String string = "";
        for (DatapathElement datapathElement : this.listDatapath) {
            appendable.append(string);
            datapathElement.writeStruct(appendable);
            string = ".";
        }
    }

    public short shortFromUnsignedByte(byte by) {
        return by >= 0 ? (short)by : (short)(by + 256);
    }

    public int intFromUnsignedShort(short n) {
        return n >= 0 ? n : n + 32768;
    }

    public static class Test {
        public static void testArrayElement() {
            float[][] fArray = new float[5][3];
            Object object = DataAccess.getArrayElement(fArray, 2);
            System.out.println(object);
        }
    }

    public static final class Variable<T> {
        protected char type;
        protected Class<? extends T> clazz;
        protected boolean isConst;
        protected final String name;
        protected T value;

        public Variable(char c, String string, T t) {
            this.type = c;
            this.name = string;
            this.value = t;
            if (t != null) {
                Class<?> clazz = t.getClass();
                this.clazz = clazz;
            }
        }

        public Variable(char c, String string, T t, boolean bl) {
            this(c, string, t);
            this.isConst = bl;
        }

        public Variable(Variable<T> variable) {
            this.type = variable.type;
            this.name = variable.name;
            this.isConst = variable.isConst;
            this.clazz = variable.clazz;
            this.value = variable.value instanceof Appendable && variable.value instanceof CharSequence ? variable.value : variable.value;
        }

        public String name() {
            return this.name;
        }

        public T value() {
            return this.value;
        }

        public char type() {
            return this.type;
        }

        public boolean isConst() {
            return this.isConst;
        }

        public void setValue(T t) {
            this.value = t;
        }

        public String toString() {
            return "Variable " + this.type + " " + this.name + " = " + this.value;
        }
    }

    public static final class Dst {
        protected Field field;
        protected Object obj;

        public void set(Object object) throws IllegalArgumentException, IllegalAccessException {
            Conversion conversion = DataAccess.checkArgTypes(this.field.getType(), object.getClass(), object);
            if (conversion == null) {
                throw new IllegalArgumentException("DataAccess - cannot assign >>" + this.field + "<< = >>" + object + "<<");
            }
            Object object2 = conversion.convert(object);
            this.field.set(this.obj, object2);
        }
    }

    public static final class ObjMethod {
        public final Method method;
        public final Object obj;

        public ObjMethod(Method method, Object object) {
            this.method = method;
            this.obj = object;
        }
    }

    public static class DatapathElementClass
    extends DatapathElement {
        ClassLoader loader;
        Class<?> clazz;

        public void set_javapath(String string) {
            this.ident = string;
        }

        public void set_loader(ClassLoader classLoader) {
            this.loader = classLoader;
        }

        public void set_Class(Class<?> clazz) {
            this.clazz = clazz;
        }
    }

    public static class DatapathElement {
        protected String ident;
        protected char whatisit = (char)46;
        @Deprecated
        protected Object[] fnArgs;
        private CalculatorExpr.Operand[] args;
        Member reflAccess;
        int ixData = -1;
        int[] indices;
        private boolean operation_;

        protected DatapathElement() {
        }

        public DatapathElement(String string) throws ParseException {
            this.set(string);
        }

        public DatapathElement(StringPartScan stringPartScan, Map<String, IntegerIx> map, Class<?> clazz, boolean bl) throws ParseException {
            this.set(stringPartScan, map, clazz, bl);
        }

        public DatapathElement(StringPartScan stringPartScan, Map<String, IntegerIx> map, Class<?> clazz) throws ParseException {
            this.set(stringPartScan, map, clazz, false);
        }

        public void set_operation(boolean bl) {
            this.operation_ = bl;
        }

        public void set_operation() {
            this.operation_ = true;
        }

        public boolean isOperation() {
            return this.operation_;
        }

        public int nrArgNames() {
            return this.args == null ? 0 : this.args.length;
        }

        public String argName(int n) {
            return this.args[n].textOrVar;
        }

        public void set(String string) throws ParseException {
            char c = string.charAt(0);
            int n = 1;
            if ("$@+%".indexOf(c) >= 0) {
                this.whatisit = c;
            } else {
                this.whatisit = (char)46;
                n = 0;
            }
            int n2 = string.indexOf(40);
            if (n2 != -1) {
                this.whatisit = (char)(this.whatisit == '%' ? 37 : 40);
                this.operation_ = true;
                int n3 = n2 + 1;
                int n4 = string.length();
                int n5 = 32;
                while (n3 < n4 && n5 == 32) {
                    n5 = string.charAt(n3++);
                }
                if (n5 != 32 && n5 != 41) {
                    StringPartScan stringPartScan = new StringPartScan(string.substring(n2 + 1));
                    stringPartScan.setIgnoreWhitespaces(true);
                    this.args = this.parseArgumentExpr(stringPartScan, null, null);
                }
            } else {
                n2 = string.indexOf(91);
                if (n2 != -1) {
                    LinkedList<Object> linkedList = new LinkedList<Object>();
                    CalculatorExpr calculatorExpr = new CalculatorExpr();
                    StringPartScan stringPartScan = new StringPartScan(string);
                    stringPartScan.seekPos(n2 + 1);
                    stringPartScan.setIgnoreWhitespaces(true);
                    stringPartScan.scanStart();
                    boolean bl = false;
                    do {
                        calculatorExpr.setExpr(stringPartScan, null, false);
                        CalculatorExpr.Operand operand = calculatorExpr.isSimpleSetExpr();
                        if (operand != null && operand.dataConst instanceof CalculatorExpr.Value) {
                            linkedList.add(((CalculatorExpr.Value)operand.dataConst).intValue());
                            continue;
                        }
                        bl = true;
                        linkedList.add(calculatorExpr);
                        calculatorExpr = new CalculatorExpr();
                    } while (stringPartScan.scan(",").scanOk());
                    this.indices = new int[linkedList.size()];
                    if (bl) {
                        this.args = new CalculatorExpr.Operand[linkedList.size()];
                    }
                    int n6 = 0;
                    for (Object e : linkedList) {
                        if (e instanceof Integer) {
                            this.indices[n6] = (Integer)e;
                        } else {
                            this.indices[n6] = -1;
                            this.args[n6] = new CalculatorExpr.Operand((CalculatorExpr)e);
                        }
                        ++n6;
                    }
                    Debugutil.stop();
                } else {
                    n2 = string.length();
                }
            }
            this.ident = string.substring(n, n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void set(StringPartScan stringPartScan, Map<String, IntegerIx> map, Class<?> clazz, boolean bl) throws ParseException {
            Class<?>[] classArray;
            Object object;
            stringPartScan.scanSkipSpace().scanOk();
            int n = 63;
            if (bl) {
                n = stringPartScan.getCurrentChar();
                if ("$@+%".indexOf(n) >= 0) {
                    this.whatisit = (char)n;
                    stringPartScan.seekPos(1);
                } else {
                    this.whatisit = (char)46;
                }
            }
            if (n == 38) {
                this.whatisit = (char)38;
                if (!stringPartScan.scan("&(").scanOk()) throw new ParseException("&(<expression>) expected, \"(\" missing " + stringPartScan.getCurrent(32), 0);
                this.args = new CalculatorExpr.Operand[1];
                this.args[0] = new CalculatorExpr.Operand(stringPartScan, map, clazz, false);
                if (!stringPartScan.scan(")").scanOk()) {
                    throw new ParseException("&(<expression>) expected: , \")\" missing" + stringPartScan.getCurrent(32), 0);
                }
            } else {
                stringPartScan.scanStart();
                if (stringPartScan.scan("[]").scanOk()) {
                    Debugutil.stop();
                    this.ident = "[]";
                } else {
                    if (!stringPartScan.scanIdentifier().scanOk()) throw new ParseException("idenfifier expected instead: " + stringPartScan.getCurrent(32), 0);
                    this.ident = stringPartScan.getLastScannedString();
                }
                if (stringPartScan.scan("(").scanOk()) {
                    this.whatisit = (char)(this.whatisit == '%' ? 37 : 40);
                    this.operation_ = true;
                    if (!stringPartScan.scan(")").scanOk()) {
                        this.args = this.parseArgumentExpr(stringPartScan, map, clazz);
                        stringPartScan.scan(")").scanOk();
                    }
                }
            }
            if (stringPartScan.scan("[").scanOk()) {
                object = new LinkedList();
                classArray = new CalculatorExpr();
                stringPartScan.scanStart();
                boolean bl2 = false;
                do {
                    classArray.setExpr(stringPartScan, null, false);
                    CalculatorExpr.Operand operand = classArray.isSimpleSetExpr();
                    if (operand != null && operand.dataConst instanceof CalculatorExpr.Value) {
                        object.add(((CalculatorExpr.Value)operand.dataConst).intValue());
                        continue;
                    }
                    bl2 = true;
                    object.add(classArray);
                    classArray = new CalculatorExpr();
                } while (stringPartScan.scan(",").scanOk());
                this.indices = new int[object.size()];
                if (bl2) {
                    this.args = new CalculatorExpr.Operand[object.size()];
                }
                int n2 = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof Integer) {
                        this.indices[n2] = (Integer)e;
                    } else {
                        this.indices[n2] = -1;
                        this.args[n2] = new CalculatorExpr.Operand((CalculatorExpr)e);
                    }
                    ++n2;
                }
                if (!stringPartScan.scan("]").scanOk()) {
                    throw new IllegalArgumentException("indices, missing ]");
                }
                Debugutil.stop();
            }
            if (!bl || this.ident == null) return;
            if (map != null && !this.operation_) {
                object = map.get(this.ident);
                if (object != null) {
                    this.ixData = ((IntegerIx)object).ix;
                    this.whatisit = (char)64;
                    assert (!this.operation_ && this.args == null && this.fnArgs == null && this.reflAccess == null);
                } else if (clazz == null) {
                    this.ixData = map.size();
                    object = new IntegerIx(this.ixData);
                    map.put(this.ident, (IntegerIx)object);
                    this.whatisit = (char)64;
                    assert (!this.operation_ && this.args == null && this.fnArgs == null && this.indices == null && this.reflAccess == null);
                } else {
                    this.ixData = -1;
                }
            } else {
                this.ixData = -1;
            }
            if (this.ixData >= 0 || clazz == null) return;
            if ("%(".indexOf(this.whatisit) >= 0) {
                object = clazz.getMethods();
                classArray = null;
                for (Method method : object) {
                    if (!method.getName().equals(this.ident)) continue;
                    if (this.reflAccess != null) {
                        this.reflAccess = null;
                        return;
                    } else {
                        classArray = method.getParameterTypes();
                        this.reflAccess = method;
                    }
                    return;
                }
                return;
            }
            if (".%".indexOf(this.whatisit) < 0) return;
            try {
                this.reflAccess = clazz.getDeclaredField(this.ident);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        CalculatorExpr.Operand[] parseArgumentExpr(StringPartScan stringPartScan, Map<String, IntegerIx> map, Class<?> clazz) throws ParseException {
            CalculatorExpr.Operand[] operandArray;
            LinkedList<CalculatorExpr.Operand[]> linkedList = new LinkedList<CalculatorExpr.Operand[]>();
            do {
                operandArray = new CalculatorExpr.Operand(stringPartScan, map, clazz, false);
                linkedList.add(operandArray);
            } while (stringPartScan.scan(",").scanOk());
            if (linkedList.size() >= 0) {
                operandArray = new CalculatorExpr.Operand[linkedList.size()];
                linkedList.toArray(operandArray);
                return operandArray;
            }
            return null;
        }

        public void set_ident(String string) {
            this.ident = string;
        }

        public void set_whatisit(String string) {
            this.whatisit = string.charAt(0);
        }

        public char whatisit() {
            return this.whatisit;
        }

        public String ident() {
            return this.ident;
        }

        public void setIdent(String string) {
            this.ident = string;
        }

        public void setActualArguments(Object ... objectArray) {
            this.fnArgs = objectArray;
        }

        public void setActualArgumentArray(Object[] objectArray) {
            this.fnArgs = objectArray;
        }

        public void writeStruct(Appendable appendable) throws IOException {
            appendable.append(this.whatisit);
            if (this.whatisit >= 'A' && this.whatisit <= 'Z') {
                appendable.append(':');
            }
            appendable.append(this.ident);
            if (this.fnArgs != null) {
                String string = "(";
                for (Object object : this.fnArgs) {
                    appendable.append(string).append(object.toString());
                    string = ", ";
                }
                appendable.append(")");
            }
        }

        public void writeAccessString(Appendable appendable) throws IOException {
            appendable.append(this.ident());
            if (this.isOperation()) {
                appendable.append("(");
                String string = "";
                if (this.args != null) {
                    for (CalculatorExpr.Operand operand : this.args) {
                        appendable.append(string).append(operand.textOrVar);
                        string = ", ";
                    }
                }
                appendable.append(")");
            }
        }

        public String toString() {
            if (this.whatisit == '\u0000') {
                return this.ident + ":?";
            }
            if (this.whatisit != '(') {
                return this.ident + ":" + this.whatisit;
            }
            return this.ident + "(...)";
        }
    }

    public static class SetDatapathElement
    extends DatapathElement {
        protected final Object dbgParent;

        public SetDatapathElement(Object object) {
            this.dbgParent = object;
        }

        public SetDatapathElement() {
            this.dbgParent = null;
        }

        public void set_javapath(String string) {
            this.ident = string;
        }

        @Override
        public void set_ident(String string) {
            this.ident = string;
        }

        @Deprecated
        public void set_index(int n) {
            int n2;
            if (this.indices != null) {
                this.indices = new int[1];
                n2 = 0;
            } else {
                this.indices = new int[1];
                n2 = 0;
            }
            this.indices[n2] = n;
        }
    }

    public static class DataAccessSet
    extends DataAccess {
        public SetDatapathElement new_datapathElement() {
            return new SetDatapathElement();
        }

        public final void add_datapathElement(SetDatapathElement setDatapathElement) {
            super.add_datapathElement(setDatapathElement);
        }

        public DatapathElementClass newDatapathElementClass() {
            return new DatapathElementClass();
        }

        public final void add_datapathElementClass(DatapathElementClass datapathElementClass) {
            super.add_datapathElement(datapathElementClass);
        }

        public SetDatapathElement new_startDatapath() {
            return new SetDatapathElement();
        }

        public final void add_startDatapath(SetDatapathElement setDatapathElement) {
            super.add_datapathElement(setDatapathElement);
        }

        public final void set_envVariable(String string) {
            assert (this.listDatapath == null && this.oneDatapathElement == null);
            DatapathElement datapathElement = new DatapathElement();
            datapathElement.whatisit = (char)36;
            datapathElement.ident = string;
            this.add_datapathElement(datapathElement);
        }

        public final void set_startVariable(String string) {
            assert (this.listDatapath == null && this.oneDatapathElement == null);
            DatapathElement datapathElement = new DatapathElement();
            datapathElement.whatisit = (char)64;
            datapathElement.ident = string;
            this.add_datapathElement(datapathElement);
        }

        public final DatapathElementClass new_newJavaClass() {
            DatapathElementClass datapathElementClass = this.newDatapathElementClass();
            datapathElementClass.whatisit = (char)43;
            return datapathElementClass;
        }

        public final void add_newJavaClass(DatapathElementClass datapathElementClass) {
            this.add_datapathElement(datapathElementClass);
        }

        public final DatapathElementClass new_staticJavaMethod() {
            DatapathElementClass datapathElementClass = this.newDatapathElementClass();
            datapathElementClass.whatisit = (char)37;
            return datapathElementClass;
        }

        public final void add_staticJavaMethod(DatapathElementClass datapathElementClass) {
            this.add_datapathElement(datapathElementClass);
        }

        public final void setTypeToLastElement(char c) {
            if (this.oneDatapathElement != null) {
                this.oneDatapathElement.whatisit = c;
            } else {
                int n = this.listDatapath.size() - 1;
                if (n >= 0) {
                    DatapathElement datapathElement = (DatapathElement)this.listDatapath.get(n);
                    datapathElement.whatisit = c;
                }
            }
        }
    }

    private static class Conversions {
        protected static Conversion calcValue2int = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Integer(((CalculatorExpr.Value)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "org.vishia.util.CalculatorExpr$Value:int";
            }

            public String toString() {
                return "calcValue:int";
            }
        };
        protected static Conversion long2int = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Integer(((Long)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                long l = (Long)object;
                return l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE;
            }

            @Override
            public String key() {
                return "java.lang.Long:int";
            }

            public String toString() {
                return "long:int";
            }
        };
        protected static Conversion int2char = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Character((char)((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.Integer:char";
            }

            public String toString() {
                return "int:double";
            }
        };
        protected static Conversion int2bool = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Boolean((Integer)object != 0);
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.Integer:boolean";
            }

            public String toString() {
                return "int:long";
            }
        };
        protected static Conversion int2byte = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Byte((byte)((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                int n = (Integer)object;
                return n <= 127 && n >= -128;
            }

            @Override
            public String key() {
                return "java.lang.Integer:byte";
            }

            public String toString() {
                return "int:long";
            }
        };
        protected static Conversion int2short = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Short((byte)((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                int n = (Integer)object;
                return n <= Short.MAX_VALUE && n >= Short.MIN_VALUE;
            }

            @Override
            public String key() {
                return "java.lang.Integer:short";
            }

            public String toString() {
                return "int:long";
            }
        };
        protected static Conversion int2long = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Long(((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.Integer:long";
            }

            public String toString() {
                return "int:long";
            }
        };
        protected static Conversion int2float = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Float(((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.Integer:float";
            }

            public String toString() {
                return "int:float";
            }
        };
        protected static Conversion int2double = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Double(((Integer)object).intValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.Integer:double";
            }

            public String toString() {
                return "int:double";
            }
        };
        protected static Conversion number2char = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Character((char)((Number)object).longValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.Number:char";
            }

            public String toString() {
                return "int:double";
            }
        };
        protected static Conversion double2float = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Float(((Double)object).floatValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.Double:float";
            }

            public String toString() {
                return "double:float";
            }
        };
        protected static Conversion float2double = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Double(((Float)object).floatValue());
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.Float:double";
            }

            public String toString() {
                return "float:double";
            }
        };
        protected static Conversion number2bool = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Boolean(((Number)object).longValue() != 0L);
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.Number:bool";
            }

            public String toString() {
                return "number:bool";
            }
        };
        protected static Conversion obj2bool = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Boolean(object != null);
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.Object:bool";
            }

            public String toString() {
                return "obj:bool";
            }
        };
        protected static Conversion charSequence2String = new Conversion(){

            @Override
            public Object convert(Object object) {
                return object.toString();
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return "java.lang.CharSequence:java.lang.String";
            }

            public String toString() {
                return "CharSequence:String";
            }
        };
        protected static Conversion charSeq2char = new Conversion(){

            @Override
            public Object convert(Object object) {
                return new Character(((CharSequence)object).charAt(0));
            }

            @Override
            public boolean canConvert(Object object) {
                return ((CharSequence)object).length() == 1;
            }

            @Override
            public String key() {
                return "java.lang.CharSequence:char";
            }

            public String toString() {
                return "CharSequence:char";
            }
        };
        protected static Conversion list2array = new Conversion(){

            @Override
            public Object convert(Object object) {
                List list = (List)object;
                Object e = list.get(0);
                int n = list.size();
                Class<?> clazz = e.getClass();
                Object[] objectArray = (Object[])Array.newInstance(clazz, n);
                int n2 = -1;
                for (Object e2 : list) {
                    objectArray[++n2] = e2;
                }
                return objectArray;
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return null;
            }

            public String toString() {
                return "obj:obj";
            }
        };
        protected static Conversion obj2obj = new Conversion(){

            @Override
            public Object convert(Object object) {
                return object;
            }

            @Override
            public boolean canConvert(Object object) {
                return true;
            }

            @Override
            public String key() {
                return null;
            }

            public String toString() {
                return "obj:obj";
            }
        };

        private Conversions() {
        }
    }

    private static interface Conversion {
        public Object convert(Object var1);

        public boolean canConvert(Object var1);

        public String key();
    }

    public static class IntegerIx {
        public final int ix;

        public IntegerIx(int n) {
            this.ix = n;
        }

        public String toString() {
            return Integer.toString(this.ix);
        }
    }
}

