/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.vishia.util.Assert;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringFunctions_C;
import org.vishia.util.StringPartScan;
import org.vishia.util.StringSeq;

public class CalculatorExpr {
    public static final String version = "2024-01-20";
    private final List<Operation> listOperations_ = new ArrayList<Operation>();
    private Appendable log;
    protected static Map<String, Operator> operators;
    protected static Map<String, Operator> unaryOperators;

    public CalculatorExpr() {
        if (operators == null) {
            operators = new TreeMap<String, Operator>();
            operators.put("!", Operators.setOperation);
            operators.put("#", Operators.setOperation);
            operators.put("@", Operators.setOperation);
            operators.put("!set", Operators.setOperation);
            operators.put("=", Operators.assignOperation);
            operators.put(":", Operators.concatStringOperation);
            operators.put("+", Operators.addOperation);
            operators.put("-", Operators.subOperation);
            operators.put("*", Operators.mulOperation);
            operators.put("/", Operators.divOperation);
            operators.put(">=", Operators.cmpGreaterEqualOperation);
            operators.put(">", Operators.cmpGreaterThanOperation);
            operators.put("<=", Operators.cmpLessEqualOperation);
            operators.put("<", Operators.cmpLessThanOperation);
            operators.put("!=", Operators.cmpNeOperation);
            operators.put("<>", Operators.cmpNeOperation);
            operators.put("==", Operators.cmpEqOperation);
            operators.put("lt", Operators.cmpLessThanOperation);
            operators.put("le", Operators.cmpLessEqualOperation);
            operators.put("gt", Operators.cmpGreaterThanOperation);
            operators.put("ge", Operators.cmpGreaterEqualOperation);
            operators.put("eq", Operators.cmpEqOperation);
            operators.put("ne", Operators.cmpNeOperation);
            operators.put("instanceof", Operators.cmpInstanceofOperation);
            operators.put("=.", Operators.cmpStartsOperation);
            operators.put(".=", Operators.cmpEndsOperation);
            operators.put(".=.", Operators.cmpContainsOperation);
            operators.put("!||", Operators.boolCheckOrOperation);
            operators.put("||", Operators.boolOrOperation);
            operators.put("!&&", Operators.boolCheckAndOperation);
            operators.put("&&", Operators.boolAndOperation);
            operators.put("ub", Operators.boolOperation);
            operators.put("u!", Operators.boolNotOperation);
            operators.put("u~", Operators.bitNotOperation);
            operators.put("u-", Operators.negOperation);
        }
    }

    public CalculatorExpr(String string, Map<String, DataAccess.IntegerIx> map, Class<?> clazz) {
        this();
        String string2 = this.setExpr(string, map, clazz);
        if (string2 != null) {
            throw new IllegalArgumentException(string2);
        }
    }

    public CalculatorExpr(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, boolean bl) {
        this();
        String string = this.setExpr(stringPartScan, map, clazz, bl);
        if (string != null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static String[] splitFnNameAndParams(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(40);
        if (n >= 0) {
            stringArray[0] = string.substring(0, n).trim();
            int n2 = string.lastIndexOf(41);
            if (n2 < 0) {
                n2 = string.length();
            }
            stringArray[1] = string.substring(n + 1, n2);
        } else {
            stringArray[0] = string.trim();
            stringArray[1] = null;
        }
        return stringArray;
    }

    public static String[] splitFnParams(String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public static int sh(int n, int n2) {
        return n2 >= 0 ? n << n2 : n >> -n2;
    }

    public static int shmask(int n, byte by, int n2) {
        return by >= 0 ? n << by & n2 : n >> -by & n2;
    }

    public static int masksh(int n, int n2, byte by) {
        if (by >= 0) {
            return (n & n2) << by;
        }
        int n3 = (n & n2) >> by;
        if (n3 < 0) {
            int n4 = Integer.MAX_VALUE >> -by - 1;
            n3 &= n4;
        }
        return n3;
    }

    public void setLog(Appendable appendable) {
        this.log = appendable;
    }

    public String setExpr(String string, String[] stringArray) {
        TreeMap<String, DataAccess.IntegerIx> treeMap = new TreeMap<String, DataAccess.IntegerIx>();
        for (int i = 0; i < stringArray.length; ++i) {
            treeMap.put(stringArray[i], new DataAccess.IntegerIx(i));
        }
        return this.setExpr(string, treeMap, null);
    }

    public String setExpr(String string, Map<String, DataAccess.IntegerIx> map, Class<?> clazz) {
        StringPartScan stringPartScan = new StringPartScan(string);
        stringPartScan.setIgnoreWhitespaces(true);
        return this.setExpr(stringPartScan, map, clazz, false);
    }

    public String setExpr(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, boolean bl) {
        this.listOperations_.clear();
        try {
            int n = stringPartScan.length();
            if (stringPartScan.startsWith("'")) {
                this.parseString(stringPartScan, map, clazz, "!", 0);
            } else {
                if (n > 50) {
                    n = StringFunctions.indexOf((CharSequence)stringPartScan, 0, 100, ')');
                }
                if (n >= 0 && StringFunctions.indexOfAnyChar(stringPartScan, 0, n, "+-*/(&|?=", null) < 0) {
                    this.parseArgument(stringPartScan, map, clazz, "!", 0);
                } else {
                    this.parseExpr(stringPartScan, map, clazz, "!", bl, 1);
                }
            }
        }
        catch (ParseException parseException) {
            return parseException.getMessage();
        }
        return null;
    }

    public String setExpr(String string) {
        StringPartScan stringPartScan = new StringPartScan(string);
        return this.setExpr(stringPartScan, null, false);
    }

    public String setExpr(String string, Class<?> clazz) {
        StringPartScan stringPartScan = new StringPartScan(string);
        return this.setExpr(stringPartScan, clazz, false);
    }

    public String setExpr(StringPartScan stringPartScan, Class<?> clazz, boolean bl) {
        this.listOperations_.clear();
        TreeMap<String, DataAccess.IntegerIx> treeMap = new TreeMap<String, DataAccess.IntegerIx>();
        treeMap.put("X", new DataAccess.IntegerIx(0));
        try {
            this.parseExpr(stringPartScan, treeMap, clazz, "!", bl, 1);
        }
        catch (ParseException parseException) {
            return parseException.getMessage();
        }
        return null;
    }

    protected void parseString(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, String string, int n) throws ParseException {
        String string2 = string;
        while (string2 != null) {
            if (stringPartScan.scanSkipSpace().scanLiteral("''\\", -1).scanOk()) {
                String string3 = stringPartScan.getLastScannedString();
                this.listOperations_.add(new Operation(string2, StringFunctions.convertTransliteration(string3, '\\').toString()));
            } else {
                char c = stringPartScan.getCurrentChar();
                if (c == '(') {
                    this.parseExpr(stringPartScan, map, clazz, string2, false, 0);
                    if (stringPartScan.scanSkipSpace().scan(")").scanOk()) {
                        throw new ParseException(") expected for expression inside parseString", (int)stringPartScan.getCurrentPosition());
                    }
                } else {
                    this.parseArgument(stringPartScan, map, clazz, ":", 0);
                }
            }
            if (stringPartScan.scanSkipSpace().scan(":").scanOk()) {
                string2 = ":";
                continue;
            }
            string2 = null;
        }
    }

    protected void parseExpr(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, String string, boolean bl, int n) throws ParseException {
        if (n > 1000) {
            throw new RuntimeException("recursion");
        }
        String string2 = string;
        this.parseAndExpr(stringPartScan, map, clazz, string2, bl, n + 1);
        while (string2 != null) {
            string2 = stringPartScan.scan("||").scanOk() ? "||" : null;
            if (string2 == null) continue;
            this.parseAndExpr(stringPartScan, map, clazz, string2, bl, n + 1);
        }
    }

    protected void parseAndExpr(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, String string, boolean bl, int n) throws ParseException {
        if (n > 1000) {
            throw new RuntimeException("recursion");
        }
        String string2 = string;
        this.parseCmpExpr(stringPartScan, map, clazz, string2, bl, n + 1);
        while (string2 != null) {
            string2 = stringPartScan.scan("&&").scanOk() ? "&&" : null;
            if (string2 == null) continue;
            this.parseCmpExpr(stringPartScan, map, clazz, string2, bl, n + 1);
        }
    }

    protected void parseCmpExpr(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, String string, boolean bl, int n) throws ParseException {
        if (n > 1000) {
            throw new RuntimeException("recursion");
        }
        String string2 = string;
        this.parseAddExpr(stringPartScan, map, clazz, string2, n + 1);
        if (stringPartScan.scanSkipSpace().scanOk()) {
            char c = stringPartScan.getCurrentChar();
            if ("=!><?".indexOf(c) >= 0) {
                string2 = null;
                if (stringPartScan.scan("==").scanOk()) {
                    string2 = "==";
                } else if (stringPartScan.scan("?eq").scanOk()) {
                    string2 = "==";
                } else if (stringPartScan.scan("!=").scanOk()) {
                    string2 = "!=";
                } else if (stringPartScan.scan("?ne").scanOk()) {
                    string2 = "!=";
                } else if (stringPartScan.scan(">=").scanOk()) {
                    string2 = ">=";
                } else if (stringPartScan.scan("?ge").scanOk()) {
                    string2 = ">=";
                } else if (stringPartScan.scan("?gt").scanOk()) {
                    string2 = ">";
                } else if (!bl && stringPartScan.scan(">").scanOk()) {
                    string2 = ">";
                } else if (stringPartScan.scan("?le").scanOk()) {
                    string2 = "<=";
                } else if (stringPartScan.scan("<=").scanOk()) {
                    string2 = "<=";
                } else if (stringPartScan.scan("?lt").scanOk()) {
                    string2 = "<";
                } else if (stringPartScan.scan("<").scanOk()) {
                    string2 = "<";
                } else if (stringPartScan.scan("?instanceof").scanOk()) {
                    string2 = "instanceof";
                } else if (stringPartScan.scan("?contains").scanOk()) {
                    string2 = ".=.";
                } else if (stringPartScan.scan("?starts").scanOk()) {
                    string2 = "=.";
                } else if (stringPartScan.scan("?ends").scanOk()) {
                    string2 = ".=";
                }
                if (string2 != null) {
                    this.parseAddExpr(stringPartScan, map, clazz, string2, n + 1);
                }
            } else {
                string2 = null;
            }
        }
    }

    protected void parseAddExpr(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, String string, int n) throws ParseException {
        if (n > 1000) {
            throw new RuntimeException("recursion");
        }
        String string2 = string;
        while (string2 != null) {
            this.parseMultExpr(stringPartScan, map, clazz, string2, n + 1);
            if (stringPartScan.scanSkipSpace().length() > 0) {
                char c = stringPartScan.getCurrentChar();
                if ("+-".indexOf(c) >= 0) {
                    stringPartScan.seek(1).scan().scanOk();
                    string2 = "" + c;
                    continue;
                }
                string2 = null;
                continue;
            }
            string2 = null;
        }
    }

    protected String parseMultExpr(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, String string, int n) throws ParseException {
        if (n > 1000) {
            throw new RuntimeException("recursion");
        }
        String string2 = null;
        String string3 = string;
        while (string3 != null) {
            this.parseArgument(stringPartScan, map, clazz, string3, n);
            if (stringPartScan.scanSkipSpace().length() > 0) {
                char c = stringPartScan.getCurrentChar();
                if ("*/".indexOf(c) >= 0) {
                    stringPartScan.seek(1).scan().scanOk();
                    string3 = "" + c;
                    continue;
                }
                string3 = null;
                continue;
            }
            string3 = null;
        }
        return string2;
    }

    protected void parseArgument(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, String string, int n) throws ParseException {
        stringPartScan.scanSkipSpace().scanStart();
        if (stringPartScan.scanSkipSpace().scan("(").scanOk()) {
            this.parseAddExpr(stringPartScan, map, clazz, "!", n + 1);
            if (!stringPartScan.scanSkipSpace().scan(")").scanOk()) {
                throw new ParseException(") expected", (int)stringPartScan.getCurrentPosition());
            }
            this.listOperations_.add(new Operation(string, -2));
        } else if (stringPartScan.scanSkipSpace().scanLiteral("''\\", -1).scanOk()) {
            String string2 = stringPartScan.getLastScannedString();
            this.listOperations_.add(new Operation(string, StringFunctions.convertTransliteration(string2, '\\').toString()));
        } else if (stringPartScan.scanSkipSpace().scanInteger().scanOk()) {
            Value value = new Value();
            boolean bl = stringPartScan.getLastScannedIntegerSign();
            long l = stringPartScan.getLastScannedIntegerNumber();
            if (stringPartScan.scanFractionalNumber(l, bl).scanOk()) {
                double d = stringPartScan.getLastScannedFloatNumber();
                if (stringPartScan.scan("F").scanOk()) {
                    value.floatVal = (float)d;
                    value.type_ = (char)70;
                    value.etype = ExprTypes.floatExpr;
                } else {
                    value.doubleVal = d;
                    value.type_ = (char)68;
                    value.etype = ExprTypes.doubleExpr;
                }
            } else if (l < 0x80000000L && l >= Integer.MIN_VALUE) {
                value.intVal = (int)l;
                value.type_ = (char)73;
                value.etype = ExprTypes.intExpr;
            } else {
                value.longVal = l;
                value.type_ = (char)74;
                value.etype = ExprTypes.longExpr;
            }
            this.listOperations_.add(new Operation(string, value));
        } else {
            String string3 = stringPartScan.scanSkipSpace().scan("NOT").scanOk() ? "!" : (stringPartScan.scanSkipSpace().scan("!").scanOk() ? "!" : (stringPartScan.scanSkipSpace().scan("~").scanOk() ? "~" : (stringPartScan.scanSkipSpace().scan("+").scanOk() ? "+" : (stringPartScan.scanSkipSpace().scan("-").scanOk() ? "-" : null))));
            if (string3 != null) {
                Debugutil.stop();
            }
            DataAccess dataAccess = new DataAccess(stringPartScan, map, clazz, '\u0000');
            Operand operand = dataAccess.oneDatapathElement != null && dataAccess.oneDatapathElement.whatisit == '@' && dataAccess.oneDatapathElement.indices == null ? new Operand(dataAccess.oneDatapathElement.ixData, null, null, dataAccess.oneDatapathElement.ident) : new Operand(-1, dataAccess, null, dataAccess.toString());
            Operation operation = new Operation(string, operand);
            if (string3 != null) {
                operation.addUnaryOperator(string3);
            }
            this.listOperations_.add(operation);
        }
    }

    private Operation parseOperand(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, String string, int n) throws ParseException {
        stringPartScan.scanSkipSpace().scanStart();
        if (stringPartScan.scanSkipSpace().scan("(").scanOk()) {
            this.parseAddExpr(stringPartScan, map, clazz, "!", n + 1);
            if (!stringPartScan.scanSkipSpace().scan(")").scanOk()) {
                throw new ParseException(") expected", (int)stringPartScan.getCurrentPosition());
            }
            return new Operation(string, -2);
        }
        if (stringPartScan.scanSkipSpace().scanLiteral("''\\", -1).scanOk()) {
            String string2 = stringPartScan.getLastScannedString();
            return new Operation(string, StringFunctions.convertTransliteration(string2, '\\').toString());
        }
        if (stringPartScan.scanSkipSpace().scanInteger().scanOk()) {
            Value value = new Value();
            boolean bl = stringPartScan.getLastScannedIntegerSign();
            long l = stringPartScan.getLastScannedIntegerNumber();
            if (stringPartScan.scanFractionalNumber(l, bl).scanOk()) {
                double d = stringPartScan.getLastScannedFloatNumber();
                if (stringPartScan.scan("F").scanOk()) {
                    value.floatVal = (float)d;
                    value.type_ = (char)70;
                    value.etype = ExprTypes.floatExpr;
                } else {
                    value.doubleVal = d;
                    value.type_ = (char)68;
                    value.etype = ExprTypes.doubleExpr;
                }
            } else if (l < 0x80000000L && l >= Integer.MIN_VALUE) {
                value.intVal = (int)l;
                value.type_ = (char)73;
                value.etype = ExprTypes.intExpr;
            } else {
                value.longVal = l;
                value.type_ = (char)74;
                value.etype = ExprTypes.longExpr;
            }
            return new Operation(string, value);
        }
        DataAccess dataAccess = new DataAccess(stringPartScan, map, clazz, '\u0000');
        Operand operand = dataAccess.oneDatapathElement != null && dataAccess.oneDatapathElement.whatisit == '@' && dataAccess.oneDatapathElement.indices == null ? new Operand(dataAccess.oneDatapathElement.ixData, null, null, dataAccess.oneDatapathElement.ident) : new Operand(-1, dataAccess, null, null);
        return new Operation(string, operand);
    }

    public void setRpnExpr(CharSequence charSequence, Map<String, DataAccess.IntegerIx> map, Class<?> clazz) throws ParseException {
        this.setRpnExpr(new StringPartScan(charSequence), map, clazz);
    }

    public int setRpnExpr(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz) throws ParseException {
        stringPartScan.setIgnoreWhitespaces(true);
        this.listOperations_.clear();
        boolean bl = false;
        if (stringPartScan.scanChar('[').scanOk()) {
            bl = true;
        }
        do {
            Object object;
            stringPartScan.seekNoWhitespace().lento(' ');
            String string = stringPartScan.getCurrent().toString();
            stringPartScan.fromEnd().seekNoWhitespace();
            String string2 = null;
            CharSequence charSequence = stringPartScan.getCurrent(2);
            if (StringFunctions.startsWith(charSequence, "--")) {
                string2 = "--";
            }
            if (StringFunctions.startsWith(charSequence, "++")) {
                string2 = "++";
            } else if (StringFunctions.startsWith(charSequence, "-")) {
                string2 = "-";
            } else if (StringFunctions.startsWith(charSequence, "+")) {
                string2 = "+";
            } else if (StringFunctions.startsWith(charSequence, "~")) {
                string2 = "~";
            } else if (StringFunctions.startsWith(charSequence, "!")) {
                string2 = "!";
            }
            if (string2 != null) {
                stringPartScan.seekPos(string2.length());
            }
            stringPartScan.seekNoWhitespace().scan().scanStart();
            int n = -99;
            String string3 = null;
            Operand operand = null;
            if (stringPartScan.scanIdentifier().scanOk()) {
                string3 = stringPartScan.getLastScannedString();
                object = map.get(string3);
                n = object != null ? ((DataAccess.IntegerIx)object).ix : 0;
                operand = new Operand(n, null, null, string3);
            } else if (stringPartScan.scanAnyChar("#@").scanOk()) {
                n = -2;
                operand = new Operand(n, null, null, null);
            } else if (!stringPartScan.scanFloatNumber('.', true, null).scanOk() && !stringPartScan.scanInteger(null).scanOk()) {
                this.parseException(stringPartScan);
            }
            object = new Operation(string, operand);
            if (string2 != null) {
                ((Operation)object).addUnaryOperator(string2);
            }
            stringPartScan.lentoAnyChar("],;").len0end();
            if (string != null && string.equals("=")) {
                Debugutil.stop();
                continue;
            }
            this.listOperations_.add((Operation)object);
        } while (stringPartScan.scanAnyChar(",;").scanOk() && stringPartScan.seekNoWhitespace().length() > 0);
        if (!bl || stringPartScan.scanChar('[').scanOk()) {
            // empty if block
        }
        return (int)stringPartScan.getCurrentPosition();
    }

    private void parseException(StringPartScan stringPartScan) throws ParseException {
        int n = (int)stringPartScan.getCurrentPosition();
        String string = stringPartScan.setParttoMax().toString();
        throw new ParseException("CalculaterExpr parse error for:" + string, n);
    }

    public void addOperation(Operation operation) {
        this.listOperations_.add(operation);
    }

    public List<Operation> listOperations() {
        return this.listOperations_;
    }

    public Operand isSimpleSetExpr() {
        Operation operation;
        if (this.listOperations_.size() == 1 && (operation = this.listOperations_.get(0)).operator() == Operators.setOperation) {
            return operation.operand_;
        }
        return null;
    }

    public static Operator getOperator(String string) {
        return operators.get(string);
    }

    public double calc(double d) {
        Value value;
        try {
            value = this.calcDataAccess(null, d);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return value.doubleValue();
    }

    public float Oldcalc(float f) {
        float f2 = 0.0f;
        for (Operation operation : this.listOperations_) {
            float f3 = operation.operand_ != null && operation.operand_.ixValue >= 0 ? f : (float)operation.value_d;
            switch (operation.operatorChar) {
                case '!': {
                    f2 = f3;
                    break;
                }
                case '+': {
                    f2 += f3;
                    break;
                }
                case '-': {
                    f2 -= f3;
                    break;
                }
                case '*': {
                    f2 *= f3;
                    break;
                }
                case '/': {
                    f2 /= f3;
                }
            }
        }
        return f2;
    }

    public float calc(float f) {
        Value value;
        try {
            value = this.calcDataAccess(null, Float.valueOf(f));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return value.floatValue();
    }

    public long calc(long l) {
        Value value;
        try {
            value = this.calcDataAccess(null, l);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return value.longValue();
    }

    public long calcLong(int n) {
        Value value;
        try {
            value = this.calcDataAccess(null, n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return value.intValue();
    }

    public float Oldcalc(int n) {
        float f = 0.0f;
        for (Operation operation : this.listOperations_) {
            float f2 = operation.operand_ != null && operation.operand_.ixValue >= 0 ? (float)n : (float)operation.value_d;
            switch (operation.operatorChar) {
                case '!': {
                    f = f2;
                    break;
                }
                case '+': {
                    f += f2;
                    break;
                }
                case '-': {
                    f -= f2;
                    break;
                }
                case '*': {
                    f *= f2;
                    break;
                }
                case '/': {
                    f /= f2;
                }
            }
        }
        return f;
    }

    public Value calc(Object ... objectArray) {
        Data data = new Data();
        try {
            return this.calcDataAccess(null, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Value calcDataAccess(Map<String, DataAccess.Variable<Object>> map, Object ... objectArray) throws Exception {
        Data data = new Data();
        return this.calcDataAccess(data, map, objectArray);
    }

    @Deprecated
    public Value calcDataAccess(Data data, Map<String, DataAccess.Variable<Object>> map, Object ... objectArray) throws Exception {
        data.clean();
        Value value = new Value();
        int n = 0;
        int n2 = this.listOperations_.size();
        while (n < n2) {
            Operation operation = this.listOperations_.get(n);
            ++n;
            if (operation.operator_ == Operators.assignOperation) {
                Debugutil.stop();
            }
            Value value2 = this.getValue(data, operation, map, objectArray);
            if (operation.unaryOperator != null) {
                if (value2 != null && value2 != value) {
                    value.copy(value2);
                    value2 = value;
                }
                operation.unaryOperator.operate(value2, null);
            } else if (operation.unaryOperators != null) {
                if (value2 != null && value2 != value) {
                    value.copy(value2);
                    value2 = value;
                }
                for (Operator operator : operation.unaryOperators) {
                    operator.operate(value2, null);
                }
            }
            operation.operator_.operate(data.accu, value2);
            if (this.log != null) {
                Iterator<Operator> iterator = data.stack.iterator();
                while (iterator.hasNext()) {
                    this.log.append(((Value)((Object)iterator.next())).toString()).append(" | ");
                }
                this.log.append(data.accu.toString()).append("  <-");
                this.log.append(value2.toString());
                this.log.append(" ").append(operation.toString());
                this.log.append("\n");
            }
            if (data.accu.etype != ExprTypes.finishBooleanExpr) continue;
            n = operation.kindOperand;
        }
        return data.accu;
    }

    private Value getValue(Data data, Operation operation, Map<String, DataAccess.Variable<Object>> map, Object[] objectArray) throws Exception {
        Value value;
        Object object;
        Value value2 = new Value();
        if (operation.operator_.isBoolCheck()) {
            this.debug();
        }
        if (operation.operand_ != null) {
            object = map;
            try {
                if (operation.operand_.ixValue >= 0) {
                    Object object2;
                    int n = operation.operand_.ixValue;
                    int n2 = -2;
                    int n3 = 0;
                    while (objectArray.length >= n3 + 1 && objectArray[n3].getClass().isArray()) {
                        int n4 = Array.getLength(objectArray[n3]);
                        if (n < n4) {
                            n2 = n;
                            n = n3;
                            break;
                        }
                        n -= n4;
                        ++n3;
                    }
                    object = n2 >= 0 ? ((object2 = objectArray[n]) instanceof float[] ? Float.valueOf(((float[])object2)[n2]) : (object2 instanceof int[] ? Integer.valueOf(((int[])object2)[n2]) : (object2 instanceof double[] ? Double.valueOf(((double[])object2)[n2]) : (object2 instanceof short[] ? Short.valueOf(((short[])object2)[n2]) : (object2 instanceof byte[] ? Byte.valueOf(((byte[])object2)[n2]) : (object2 instanceof char[] ? Character.valueOf(((char[])object2)[n2]) : (object2 instanceof boolean[] ? Boolean.valueOf(((boolean[])object2)[n2]) : ((Object[])object2)[n2]))))))) : objectArray[n];
                } else if (operation.operand_.dataConst != null) {
                    object = operation.operand_.dataConst;
                } else if (operation.operand_.dataAccess != null) {
                    object = operation.operand_.dataAccess.access(object, true, false, null, objectArray);
                } else if (operation.operand_.textOrVar != null) {
                    object = operation.operand_.textOrVar;
                }
                if (object == null) {
                    Debugutil.stop();
                }
                CalculatorExpr.convertObj(value2, object);
                value = value2;
            }
            catch (Exception exception) {
                value2.type_ = (char)101;
                value2.oVal = exception;
                value2.etype = ExprTypes.variableNotFoundExpr;
                value = value2;
            }
        } else if (operation.kindOperand == -2) {
            value = data.accu;
            data.accu = data.stack.pop();
        } else {
            value = null;
        }
        if (operation.operator_ == Operators.setOperation && data.accu.type_ != '?') {
            object = data.accu.etype;
            data.stack.push(data.accu);
            data.accu = new Value();
            data.accu.etype = object;
        }
        if (!operation.operator_.isUnary() && value != null) {
            data.accu.etype.checkArgument(data.accu, value);
        }
        return value;
    }

    public String toString() {
        return this.listOperations_.toString();
    }

    static void convertObj(Value value, Object object) {
        value.oVal = object;
        if (object instanceof Value) {
            value.copy((Value)object);
        } else if (object instanceof Long) {
            value.longVal = (Long)object;
            value.type_ = (char)74;
            value.etype = ExprTypes.longExpr;
        } else if (object instanceof Integer) {
            value.intVal = (Integer)object;
            value.type_ = (char)73;
            value.etype = ExprTypes.intExpr;
        } else if (object instanceof Short) {
            value.intVal = ((Short)object).intValue();
            value.type_ = (char)73;
            value.etype = ExprTypes.intExpr;
        } else if (object instanceof Byte) {
            value.intVal = ((Byte)object).intValue();
            value.type_ = (char)73;
            value.etype = ExprTypes.intExpr;
        } else if (object instanceof Boolean) {
            value.boolVal = (Boolean)object;
            value.type_ = (char)90;
            value.etype = ExprTypes.booleanExpr;
        } else if (object instanceof Double) {
            value.doubleVal = (Double)object;
            value.type_ = (char)68;
            value.etype = ExprTypes.doubleExpr;
        } else if (object instanceof Float) {
            value.floatVal = ((Float)object).floatValue();
            value.type_ = (char)70;
            value.etype = ExprTypes.floatExpr;
        } else if (object instanceof StringSeq) {
            value.stringVal = (StringSeq)object;
            value.type_ = (char)116;
            value.etype = ExprTypes.stringExpr;
        } else if (object instanceof CharSequence) {
            value.stringVal = (CharSequence)object;
            value.type_ = (char)116;
            value.etype = ExprTypes.stringExpr;
        } else {
            value.type_ = (char)111;
            value.etype = ExprTypes.objExpr;
        }
    }

    int debug() {
        return 0;
    }

    static {
        unaryOperators = new TreeMap<String, Operator>();
        unaryOperators.put("!", Operators.boolNotOperation);
        unaryOperators.put("~", Operators.bitNotOperation);
        unaryOperators.put("-", Operators.negOperation);
        unaryOperators.put("+", null);
    }

    public static class SetExprBase {
        private Operation actOperation;
        public final CalculatorExpr expr;
        protected final Object dbgParent;

        public SetExprBase(boolean bl, Object object) {
            this.expr = new CalculatorExpr();
            this.dbgParent = object;
        }

        public SetExprBase(boolean bl) {
            this.expr = new CalculatorExpr();
            this.dbgParent = null;
        }

        public SetExprBase(CalculatorExpr calculatorExpr) {
            this.expr = calculatorExpr;
            this.dbgParent = null;
        }

        public SetExprBase(SetExprBase setExprBase) {
            this.expr = setExprBase.expr;
            this.dbgParent = setExprBase;
        }

        public class SetExpr {
            public final SetExpr parent;
            private final List<Operator> unaryOperators = new ArrayList<Operator>();
            private final int ixList;

            public SetExpr() {
                this.parent = null;
                this.ixList = 0;
            }

            private SetExpr(SetExpr setExpr) {
                this.parent = setExpr;
                this.ixList = SetExprBase.this.expr.listOperations_.size();
            }

            public CalculatorExpr expr() {
                return SetExprBase.this.expr;
            }

            public SetExpr new_parenthesisExpr() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                SetExpr setExpr = new SetExpr(this);
                return setExpr;
            }

            public void add_parenthesisExpr(SetExpr setExpr) {
                setExpr.closeExprPreparation();
            }

            public SetExpr new_boolOrOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                return this;
            }

            public void add_boolOrOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("||");
                this.addToOperations();
            }

            public SetExpr set_boolCheckAndOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                SetExprBase.this.actOperation = new Operation();
                SetExprBase.this.actOperation.setOperator("!&&");
                ((SetExprBase)SetExprBase.this).actOperation.kindOperand = -6;
                return this;
            }

            public SetExpr set_boolCheckOrOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                SetExprBase.this.actOperation = new Operation();
                SetExprBase.this.actOperation.setOperator("!||");
                ((SetExprBase)SetExprBase.this).actOperation.kindOperand = -6;
                return this;
            }

            public SetExpr new_boolAndOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                return this;
            }

            public void add_boolAndOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("&&");
                this.addToOperations();
            }

            public void set_boolNot(String string) {
                this.unaryOperators.add(CalculatorExpr.getOperator("u!"));
            }

            public SetExpr new_cmpOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                SetExprBase.this.actOperation = new Operation();
                return this;
            }

            public void add_cmpOperation(SetExpr setExpr) {
                this.addToOperations();
            }

            public void set_cmpOperator(String string) {
                if (SetExprBase.this.actOperation == null) {
                    assert (false);
                    SetExprBase.this.actOperation = new Operation();
                }
                SetExprBase.this.actOperation.setOperator(string);
            }

            public void set_unaryOperator(String string) {
                Operator operator = CalculatorExpr.getOperator("u" + string);
                assert (operator != null);
                this.unaryOperators.add(operator);
            }

            public SetExpr new_addOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                assert (SetExprBase.this.actOperation == null);
                return this;
            }

            public void add_addOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("+");
                this.addToOperations();
            }

            public SetExpr new_subOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                assert (SetExprBase.this.actOperation == null);
                return this;
            }

            public void add_subOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("-");
                this.addToOperations();
            }

            public SetExpr new_multOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                assert (SetExprBase.this.actOperation == null);
                return this;
            }

            public void add_multOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("*");
                this.addToOperations();
            }

            public SetExpr new_divOperation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                assert (SetExprBase.this.actOperation == null);
                return this;
            }

            public void add_divOperation(SetExpr setExpr) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                    SetExprBase.this.actOperation.setStackOperand();
                }
                SetExprBase.this.actOperation.setOperator("/");
                this.addToOperations();
            }

            public void set_charValue(String string) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                }
                SetExprBase.this.actOperation.set_charValue(string.charAt(0));
            }

            public void set_intValue(int n) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                }
                SetExprBase.this.actOperation.set_intValue(n);
            }

            public void set_doubleValue(double d) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                }
                SetExprBase.this.actOperation.set_doubleValue(d);
            }

            public void set_textValue(String string) {
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                }
                SetExprBase.this.actOperation.set_textValue(string);
            }

            protected DataAccess.DataAccessSet newDataAccessSet() {
                return new DataAccess.DataAccessSet();
            }

            public DataAccess.DataAccessSet new_dataAccess() {
                if (SetExprBase.this.actOperation != null) {
                    Debugutil.stop();
                }
                if (SetExprBase.this.actOperation == null) {
                    SetExprBase.this.actOperation = new Operation();
                }
                if (((SetExprBase)SetExprBase.this).actOperation.operand_ == null || ((SetExprBase)SetExprBase.this).actOperation.operand_.dataAccess == null) {
                    ((SetExprBase)SetExprBase.this).actOperation.operand_ = new Operand(-1, this.newDataAccessSet(), null, "new empty");
                }
                return (DataAccess.DataAccessSet)((SetExprBase)SetExprBase.this).actOperation.operand_.dataAccess;
            }

            public void add_dataAccess(DataAccess.DataAccessSet dataAccessSet) {
            }

            public DataAccess onlyDataAccess() {
                if ((SetExprBase.this.expr.listOperations_ == null || SetExprBase.this.expr.listOperations_.size() == 0) && SetExprBase.this.actOperation != null && this.unaryOperators.size() == 0 && ((SetExprBase)SetExprBase.this).actOperation.unaryOperator == null && ((SetExprBase)SetExprBase.this).actOperation.unaryOperators == null && ((SetExprBase)SetExprBase.this).actOperation.operand_ != null && ((SetExprBase)SetExprBase.this).actOperation.operand_.dataAccess != null) {
                    return ((SetExprBase)SetExprBase.this).actOperation.operand_.dataAccess;
                }
                return null;
            }

            public void closeExprPreparation() {
                if (SetExprBase.this.actOperation != null) {
                    this.addToOperations();
                }
                int n = SetExprBase.this.expr.listOperations_.size();
                for (int i = this.ixList; i < n; ++i) {
                    Operation operation = (Operation)SetExprBase.this.expr.listOperations_.get(i);
                    if (operation.kindOperand != -6) continue;
                    operation.kindOperand = n;
                }
            }

            private void addToOperations() {
                if (!SetExprBase.this.actOperation.hasOperator()) {
                    SetExprBase.this.actOperation.setOperator("!set");
                }
                if (this.unaryOperators.size() == 1) {
                    SetExprBase.this.actOperation.addUnaryOperator(this.unaryOperators.get(0));
                } else if (this.unaryOperators.size() > 1) {
                    ListIterator<Operator> listIterator = this.unaryOperators.listIterator();
                    while (listIterator.hasPrevious()) {
                        Operator operator = listIterator.previous();
                        SetExprBase.this.actOperation.addUnaryOperator(operator);
                    }
                }
                this.unaryOperators.clear();
                SetExprBase.this.expr.addOperation(SetExprBase.this.actOperation);
                SetExprBase.this.actOperation = null;
            }

            private void addUnaryToOperations() {
                if (this.unaryOperators != null) {
                    ListIterator<Operator> listIterator = this.unaryOperators.listIterator();
                    while (listIterator.hasNext()) {
                        listIterator.next();
                    }
                    while (listIterator.hasPrevious()) {
                        Operator operator = listIterator.previous();
                        Operation operation = new Operation(operator, -3);
                        SetExprBase.this.expr.addOperation(operation);
                    }
                    this.unaryOperators.clear();
                }
            }
        }
    }

    public static class Operation {
        protected static final int kArgumentUndefined = -4;
        public static final int kConstant = -1;
        public static final int kDatapath = -5;
        public static final int kStackOperand = -2;
        public static final int kUnaryOperation = -3;
        private static final int kCheckBoolExpr = -6;
        @Deprecated
        private char operatorChar;
        protected Operator operator_;
        Operator unaryOperator;
        List<Operator> unaryOperators;
        Operand operand_;
        protected int kindOperand;
        @Deprecated
        double value_d;
        @Deprecated
        Object oValue;

        public Operation() {
            this.kindOperand = -4;
        }

        public Operation(String string, String string2) {
            this.setOperator(string);
            this.operand_ = new Operand(string2);
            this.kindOperand = -1;
        }

        public Operation(String string, Operand operand) {
            this.setOperator(string);
            if (operand.ixValue == -2) {
                this.kindOperand = -2;
                this.operand_ = null;
            } else {
                this.kindOperand = this.operator_.isUnary() ? -3 : -5;
                this.operand_ = operand;
            }
        }

        public Operation(String string, Value value) {
            this.setOperator(string);
            this.kindOperand = this.operator_.isUnary() ? -3 : -1;
            this.operand_ = new Operand(value);
        }

        public Operation(Operator operator, Value value) {
            this.operator_ = operator;
            this.operatorChar = operator.name.charAt(0);
            this.kindOperand = this.operator_.isUnary() ? -3 : -4;
            this.operand_ = new Operand(value);
        }

        public Operation(Operator operator, int n) {
            this.operator_ = operator;
            this.operatorChar = operator.name.charAt(0);
            this.kindOperand = n;
            if (operator.isUnary()) assert (n == -3);
        }

        public Operation(String string, int n) {
            this.setOperator(string);
            if (n >= 0) {
                this.operand_ = new Operand(n, null, null, null);
                this.kindOperand = -5;
            } else {
                this.kindOperand = n;
            }
        }

        Operation(String string, double d) {
            this.value_d = d;
            this.operand_ = new Operand(new Value(d));
            this.operator_ = CalculatorExpr.getOperator(string);
            this.operatorChar = this.operator_.name.charAt(0);
            this.kindOperand = -1;
            this.oValue = null;
        }

        Operation(Operator operator, Object object) {
            this.value_d = 0.0;
            this.operator_ = operator;
            this.operatorChar = operator.name.charAt(0);
            this.kindOperand = -1;
            this.oValue = object;
        }

        public Operand operand() {
            return this.operand_;
        }

        public Operator operator() {
            return this.operator_;
        }

        public boolean hasOperator() {
            return this.operator_ != null;
        }

        public boolean hasUnaryOperator() {
            return this.unaryOperator != null || this.unaryOperators != null;
        }

        public void add_datapathElement(DataAccess.DatapathElement datapathElement) {
            if (this.operand_ == null) {
                this.operand_ = new Operand(-1, new DataAccess.DataAccessSet(), null, null);
            }
            this.operand_.dataAccess.add_datapathElement(datapathElement);
        }

        public void set_intValue(int n) {
            if (this.operand_ == null) {
                this.operand_ = new Operand(new Value());
            }
            if (!(this.operand_.dataConst instanceof Value)) {
                Assert.checkMsg(false, "unexpected");
            }
            Value value = (Value)this.operand_.dataConst;
            value.type_ = (char)73;
            value.etype = ExprTypes.intExpr;
            value.intVal = n;
        }

        public void set_doubleValue(double d) {
            if (this.operand_ == null) {
                this.operand_ = new Operand(new Value());
            }
            if (!(this.operand_.dataConst instanceof Value)) {
                Assert.checkMsg(false, "unexpected");
            }
            Value value = (Value)this.operand_.dataConst;
            value.type_ = (char)68;
            value.etype = ExprTypes.doubleExpr;
            value.doubleVal = d;
        }

        public void set_charValue(char c) {
            if (this.operand_ == null) {
                this.operand_ = new Operand(new Value());
            }
            if (!(this.operand_.dataConst instanceof Value)) {
                Assert.checkMsg(false, "unexpected");
            }
            Value value = (Value)this.operand_.dataConst;
            value.type_ = (char)67;
            value.etype = ExprTypes.intExpr;
            value.intVal = c;
        }

        public void set_textValue(String string) {
            if (this.operand_ == null) {
                this.operand_ = new Operand(new Value());
            }
            if (!(this.operand_.dataConst instanceof Value)) {
                Assert.checkMsg(false, "unexpected");
            }
            Value value = (Value)this.operand_.dataConst;
            value.type_ = (char)116;
            value.etype = ExprTypes.stringExpr;
            value.stringVal = StringSeq.create(string);
        }

        public void setStackOperand() {
            this.kindOperand = -2;
        }

        public void addUnaryOperator(Operator operator) {
            if (this.unaryOperators != null) {
                this.unaryOperators.add(operator);
            } else if (this.unaryOperator != null) {
                this.unaryOperators = new ArrayList<Operator>();
                this.unaryOperators.add(this.unaryOperator);
                this.unaryOperators.add(operator);
                this.unaryOperator = null;
            } else {
                this.unaryOperator = operator;
            }
        }

        public boolean addUnaryOperator(String string) {
            Operator operator = unaryOperators.get(string);
            if (operator != null) {
                this.addUnaryOperator(operator);
                return true;
            }
            return false;
        }

        public void setOperator(Operator operator) {
            this.operator_ = operator;
            this.operatorChar = operator.name.charAt(0);
            if (operator.isUnary()) {
                this.kindOperand = -3;
            }
        }

        public boolean setOperator(String string) {
            if (string.equals("?instanceof")) {
                Debugutil.stop();
            }
            Operator operator = operators.get(string);
            this.operatorChar = operator.name.charAt(0);
            if (operator != null) {
                this.setOperator(operator);
            }
            return this.operator_ != null;
        }

        public DataAccess datapath() {
            return this.operand_ == null ? null : this.operand_.dataAccess;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.operator_);
            if (this.unaryOperator != null) {
                stringBuilder.append(" ").append(this.unaryOperator);
            }
            if (this.unaryOperators != null) {
                stringBuilder.append(" ").append(this.unaryOperators);
            }
            stringBuilder.append(' ');
            if (this.operand_ != null) {
                stringBuilder.append(this.operand_.toString());
            } else if (this.kindOperand == -1) {
                stringBuilder.append(" const ");
            } else if (this.kindOperand == -2) {
                stringBuilder.append(" stack ");
            } else if (this.kindOperand == -3) {
                stringBuilder.append(" unary:accu ");
            } else if (this.kindOperand == -4) {
                stringBuilder.append(" arg undef ");
            } else {
                stringBuilder.append(" ?unknown kindOperand=").append(this.kindOperand);
            }
            if (this.operand_ != null && this.operand_.dataAccess != null) {
                stringBuilder.append(this.operand_.dataAccess.toString());
            }
            if (this.oValue != null) {
                stringBuilder.append(" oValue:").append(this.oValue.toString());
            }
            return stringBuilder.toString();
        }
    }

    public static class Operand {
        public int ixValue;
        public final DataAccess dataAccess;
        public final Object dataConst;
        public final String textOrVar;
        public final CalculatorExpr expr;

        public Operand(String string) {
            this.ixValue = -1;
            this.dataAccess = null;
            this.dataConst = null;
            assert (string != null);
            this.textOrVar = string;
            this.expr = null;
        }

        public Operand(CalculatorExpr calculatorExpr) {
            this.ixValue = -1;
            this.dataAccess = null;
            this.dataConst = null;
            this.textOrVar = calculatorExpr.toString();
            this.expr = calculatorExpr;
        }

        public Operand(int n, DataAccess dataAccess, Object object, String string) {
            this.ixValue = n;
            this.dataAccess = dataAccess;
            this.dataConst = object;
            assert (string != null);
            this.textOrVar = string;
            this.expr = null;
        }

        public Operand(Object object) {
            this.ixValue = -1;
            this.dataAccess = null;
            this.dataConst = object;
            this.textOrVar = object == null ? "<null>" : object.toString();
            this.expr = null;
        }

        public Operand(String string, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, Map<String, Object> map2) throws Exception {
            Object object;
            Object object2 = object = map2 == null || string == null ? null : map2.get(string);
            if (object != null) {
                this.ixValue = -1;
                this.dataAccess = null;
                this.dataConst = object;
                this.expr = null;
                this.textOrVar = string;
            } else if (string != null) {
                Operand operand;
                Operation operation;
                CalculatorExpr calculatorExpr;
                List<Operation> list;
                if (string.contains("(")) {
                    Debugutil.stop();
                }
                if ((list = (calculatorExpr = new CalculatorExpr(string, map, clazz)).listOperations()).size() == 1 && (operation = list.get(0)) != null && operation.unaryOperator == null && operation.unaryOperators == null && operation.kindOperand == -5 && (operand = operation.operand()) != null) {
                    this.dataAccess = operand.dataAccess;
                    this.dataConst = operand.dataConst;
                    this.ixValue = operand.ixValue;
                    this.expr = null;
                    this.textOrVar = operand.textOrVar;
                } else {
                    this.dataAccess = null;
                    this.dataConst = null;
                    this.ixValue = -1;
                    this.expr = calculatorExpr;
                    this.textOrVar = string;
                }
            } else {
                this.ixValue = -1;
                this.dataAccess = null;
                this.dataConst = null;
                this.expr = null;
                this.textOrVar = null;
            }
        }

        public Operand(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, boolean bl) throws ParseException {
            this(stringPartScan, map, clazz, null, bl);
        }

        public Operand(StringPartScan stringPartScan, Map<String, DataAccess.IntegerIx> map, Class<?> clazz, Map<String, Object> map2, boolean bl) throws ParseException {
            Object object;
            Object object2 = object = map2 == null ? null : map2.get(stringPartScan.getCurrent().toString());
            if (object != null) {
                this.ixValue = -1;
                this.dataAccess = null;
                this.dataConst = object;
                this.expr = null;
                this.textOrVar = object == null ? "<null>" : object.toString();
            } else if (stringPartScan != null) {
                Operand operand;
                CalculatorExpr calculatorExpr = new CalculatorExpr(stringPartScan, map, clazz, bl);
                List<Operation> list = calculatorExpr.listOperations();
                if (list.size() == 1 && (operand = list.get(0).operand()) != null) {
                    this.dataAccess = operand.dataAccess;
                    this.dataConst = operand.dataConst;
                    this.ixValue = operand.ixValue;
                    this.expr = null;
                    this.textOrVar = operand.textOrVar;
                } else {
                    this.dataAccess = null;
                    this.dataConst = null;
                    this.ixValue = -1;
                    this.expr = calculatorExpr;
                    this.textOrVar = stringPartScan.getCurrent(20).toString();
                }
            } else {
                this.ixValue = -1;
                this.dataAccess = null;
                this.dataConst = null;
                this.expr = null;
                this.textOrVar = null;
            }
        }

        public Object calc(Map<String, DataAccess.IntegerIx> map, Object[] objectArray) throws Exception {
            Object object;
            Object object2;
            if (this.ixValue < 0) {
                if (this.dataConst != null) {
                    object2 = this.dataConst instanceof Value ? ((Value)this.dataConst).objValue() : this.dataConst;
                } else if (this.expr != null) {
                    object = this.expr.calcDataAccess(null, objectArray);
                    object2 = ((Value)object).objValue();
                } else {
                    object2 = this.dataAccess != null ? null : this.textOrVar;
                }
            } else {
                object2 = objectArray[this.ixValue];
            }
            object = this.dataAccess != null ? this.dataAccess.access(object2, true, false, map, objectArray) : object2;
            return object;
        }

        public String toString() {
            String string;
            String string2 = string = this.textOrVar != null ? "\"" + this.textOrVar + "\" " : "";
            if (this.ixValue >= 0) {
                return string + "[" + this.ixValue + "]";
            }
            if (this.ixValue == -2) {
                return string + "#";
            }
            if (this.dataConst != null) {
                return string + this.dataConst.toString();
            }
            if (this.dataAccess != null) {
                return string + this.dataAccess.toString();
            }
            if (this.textOrVar != null) {
                return string;
            }
            return "--null--";
        }
    }

    protected static class Operators {
        protected static final Operator boolOperation = new Operator("bool"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = value.booleanValue();
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return true;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator boolNotOperation = new Operator("not"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = !value.booleanValue();
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return true;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator bitNotOperation = new Operator("bitneg"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        value.intVal = ~value.intVal;
                        break;
                    }
                    case 'J': {
                        value.longVal = value.longVal ^ 0xFFFFFFFFFFFFFFFFL;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = !value.boolVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return true;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator negOperation = new Operator("neg"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        value.intVal = -value.intVal;
                        break;
                    }
                    case 'J': {
                        value.longVal = -value.longVal;
                        break;
                    }
                    case 'D': {
                        value.doubleVal = -value.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.floatVal = -value.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = !value.boolVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return true;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator addOperation = new Operator("+"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'B': 
                    case 'I': 
                    case 'S': {
                        Value value3 = value;
                        value3.intVal = value3.intVal + value2.intVal;
                        break;
                    }
                    case 'J': {
                        Value value4 = value;
                        value4.longVal = value4.longVal + value2.longVal;
                        break;
                    }
                    case 'D': {
                        Value value5 = value;
                        value5.doubleVal = value5.doubleVal + value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        Value value6 = value;
                        value6.floatVal = value6.floatVal + value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        Value value7 = value;
                        value7.boolVal = value7.boolVal | value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.stringVal = value.stringVal.toString() + value2.stringVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator subOperation = new Operator("-"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        Value value3 = value;
                        value3.intVal = value3.intVal - value2.intVal;
                        break;
                    }
                    case 'J': {
                        Value value4 = value;
                        value4.longVal = value4.longVal - value2.longVal;
                        break;
                    }
                    case 'D': {
                        Value value5 = value;
                        value5.doubleVal = value5.doubleVal - value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        Value value6 = value;
                        value6.floatVal = value6.floatVal - value2.floatVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator mulOperation = new Operator("*"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        Value value3 = value;
                        value3.intVal = value3.intVal * value2.intVal;
                        break;
                    }
                    case 'J': {
                        Value value4 = value;
                        value4.longVal = value4.longVal * value2.longVal;
                        break;
                    }
                    case 'D': {
                        Value value5 = value;
                        value5.doubleVal = value5.doubleVal * value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        Value value6 = value;
                        value6.floatVal = value6.floatVal * value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        Value value7 = value;
                        value7.boolVal = value7.boolVal & value2.boolVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator divOperation = new Operator("/"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        Value value3 = value;
                        value3.intVal = value3.intVal / value2.intVal;
                        break;
                    }
                    case 'J': {
                        Value value4 = value;
                        value4.longVal = value4.longVal / value2.longVal;
                        break;
                    }
                    case 'D': {
                        Value value5 = value;
                        value5.doubleVal = value5.doubleVal / value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        Value value6 = value;
                        value6.floatVal = value6.floatVal / value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        Value value7 = value;
                        value7.doubleVal = value7.doubleVal / value2.doubleVal;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpEqOperation = new Operator("eq"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal == value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal == value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = Math.abs(value.doubleVal - value2.doubleVal) < Math.abs(value.doubleVal) / 100000.0;
                        break;
                    }
                    case 'F': {
                        value.boolVal = Math.abs(value.floatVal - value2.floatVal) < Math.abs(value.floatVal) / 100000.0f;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = value.boolVal == value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.boolVal = StringFunctions.equals(value.stringVal, value2.stringVal);
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal == null && value2.oVal == null || value.oVal != null && value2.oVal != null && value.oVal.equals(value2.oVal);
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpNeOperation = new Operator("ne"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal != value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal != value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = Math.abs(value.doubleVal - value2.doubleVal) >= Math.abs(value.doubleVal) / 100000.0;
                        break;
                    }
                    case 'F': {
                        value.boolVal = Math.abs(value.floatVal - value2.floatVal) >= Math.abs(value.floatVal) / 100000.0f;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = value.boolVal != value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.boolVal = !StringFunctions.equals(value.stringVal, value2.stringVal);
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal != null || value2.oVal != null || value.oVal != null && value2.oVal != null && !value.oVal.equals(value2.oVal);
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpLessThanOperation = new Operator("lt"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal < value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal < value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = value.doubleVal < value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.boolVal = value.floatVal < value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = !value.boolVal && value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.boolVal = StringFunctions.compare(value.stringVal, value2.stringVal) < 0;
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal instanceof Comparable && value2.oVal instanceof Comparable ? ((Comparable)value.oVal).compareTo(value2.oVal) < 0 : false;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpGreaterEqualOperation = new Operator("ge"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal >= value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal >= value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = value.doubleVal >= value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.boolVal = value.floatVal >= value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = true;
                        break;
                    }
                    case 't': {
                        value.boolVal = StringFunctions.startsWith(value.stringVal, value2.stringVal);
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal instanceof Comparable && value2.oVal instanceof Comparable ? ((Comparable)value.oVal).compareTo(value2.oVal) >= 0 : false;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpGreaterThanOperation = new Operator("gt"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal > value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal > value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = value.doubleVal > value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.boolVal = value.floatVal > value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = value.boolVal && !value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.boolVal = StringFunctions.compare(value.stringVal, value2.stringVal) > 0;
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal instanceof Comparable && value2.oVal instanceof Comparable ? ((Comparable)value.oVal).compareTo(value2.oVal) > 0 : false;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                }
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpLessEqualOperation = new Operator("le"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 'I': {
                        value.boolVal = value.intVal <= value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.boolVal = value.longVal <= value2.longVal;
                        break;
                    }
                    case 'D': {
                        value.boolVal = value.doubleVal <= value2.doubleVal;
                        break;
                    }
                    case 'F': {
                        value.boolVal = value.floatVal <= value2.floatVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = true;
                        break;
                    }
                    case 't': {
                        value.boolVal = StringFunctions.compare(value.stringVal, value2.stringVal) <= 0;
                        break;
                    }
                    case 'o': {
                        value.boolVal = value.oVal instanceof Comparable && value2.oVal instanceof Comparable ? ((Comparable)value.oVal).compareTo(value2.oVal) <= 0 : false;
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpContainsOperation = new Operator("contains"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 't': {
                        value.boolVal = StringFunctions.contains(value.stringVal, value2.stringVal);
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpStartsOperation = new Operator("starts"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 't': {
                        value.boolVal = StringFunctions.startsWith(value.stringVal, value2.stringVal);
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpEndsOperation = new Operator("ends"){

            @Override
            public void operate(Value value, Value value2) throws Exception {
                switch (value.etype.typeChar()) {
                    case 't': {
                        value.boolVal = StringFunctions.endsWith(value.stringVal, value2.stringVal);
                        break;
                    }
                    case 'e': {
                        throw (Exception)value.oVal;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value.etype.toString());
                    }
                }
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator boolAndOperation = new Operator("&&"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = value.booleanValue() && value2.booleanValue();
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator boolOrOperation = new Operator("||"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = value.booleanValue() || value2.booleanValue();
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator boolCheckAndOperation = new Operator("check &&"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = value.booleanValue();
                value.type_ = (char)90;
                value.etype = value.boolVal ? ExprTypes.booleanExpr : ExprTypes.finishBooleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return true;
            }
        };
        protected static final Operator boolCheckOrOperation = new Operator("check ||"){

            @Override
            public void operate(Value value, Value value2) {
                value.boolVal = value.booleanValue();
                value.type_ = (char)90;
                value.etype = value.boolVal ? ExprTypes.finishBooleanExpr : ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return true;
            }
        };
        protected static final Operator concatStringOperation = new Operator("concat"){

            @Override
            public void operate(Value value, Value value2) {
                if (!(value.stringVal instanceof StringBuilder)) {
                    value.stringVal = new StringBuilder(value.stringVal);
                }
                ((StringBuilder)value.stringVal).append(value2.stringValue());
            }

            @Override
            protected boolean isUnary() {
                return false;
            }

            @Override
            protected boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator cmpInstanceofOperation = new Operator("instanceof"){

            @Override
            public void operate(Value value, Value value2) {
                Object object = value2.oVal;
                if (object == null || !(object instanceof Class)) {
                    throw new IllegalArgumentException("'instanceof' should compare with a class:" + object.toString());
                }
                value.boolVal = value.oVal != null && DataAccess.isOrExtends(value.oVal.getClass(), (Class)object) || object == Float.class && "FISB".indexOf(value.type_) >= 0 || object == Double.class && "DFJISB".indexOf(value.type_) >= 0 || object == Long.class && "JISB".indexOf(value.type_) >= 0 || object == Integer.class && "ISB".indexOf(value.type_) >= 0 || object == Short.class && "SB".indexOf(value.type_) >= 0 || object == Byte.class && "B".indexOf(value.type_) >= 0 || object == Character.class && "C".indexOf(value.type_) >= 0 || object == Boolean.class && "Z".indexOf(value.type_) >= 0;
                value.type_ = (char)90;
                value.etype = ExprTypes.booleanExpr;
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator setOperation = new Operator("set"){

            @Override
            public void operate(Value value, Value value2) {
                value.type_ = value2.type_;
                value.etype = value2.etype;
                value.oVal = value2.oVal;
                switch (value.type_) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        value.intVal = value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.longVal = value2.longVal;
                        break;
                    }
                    case 'F': {
                        value.floatVal = value2.floatVal;
                        break;
                    }
                    case 'D': {
                        value.doubleVal = value2.doubleVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.stringVal = value2.stringVal;
                        break;
                    }
                    case 'o': {
                        CalculatorExpr.convertObj(value, value2.oVal);
                        break;
                    }
                    case 'e': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value2.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };
        protected static final Operator assignOperation = new Operator("assign"){

            @Override
            public void operate(Value value, Value value2) {
                value.type_ = value2.type_;
                value.etype = value2.etype;
                value.oVal = value2.oVal;
                switch (value.type_) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        value.intVal = value2.intVal;
                        break;
                    }
                    case 'J': {
                        value.longVal = value2.longVal;
                        break;
                    }
                    case 'F': {
                        value.floatVal = value2.floatVal;
                        break;
                    }
                    case 'D': {
                        value.doubleVal = value2.doubleVal;
                        break;
                    }
                    case 'Z': {
                        value.boolVal = value2.boolVal;
                        break;
                    }
                    case 't': {
                        value.stringVal = value2.stringVal;
                        break;
                    }
                    case 'o': {
                        CalculatorExpr.convertObj(value, value2.oVal);
                        break;
                    }
                    case 'e': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown type" + value2.etype.toString());
                    }
                }
            }

            @Override
            public boolean isUnary() {
                return false;
            }

            @Override
            public boolean isBoolCheck() {
                return false;
            }
        };

        protected Operators() {
        }
    }

    public static abstract class Operator {
        protected final String name;

        protected Operator(String string) {
            this.name = string;
        }

        protected abstract void operate(Value var1, Value var2) throws Exception;

        protected abstract boolean isUnary();

        protected abstract boolean isBoolCheck();

        public String toString() {
            return this.name;
        }
    }

    protected static class ExprTypes {
        protected static final ExpressionType startExpr = new ExpressionType(){

            @Override
            public char typeChar() {
                return '!';
            }

            @Override
            public ExpressionType checkArgument(Value value, Value value2) {
                value.type_ = value2.type_;
                switch (value2.type_) {
                    case 'I': {
                        value.etype = intExpr;
                        break;
                    }
                    case 'J': {
                        value.etype = longExpr;
                        break;
                    }
                    case 'F': {
                        value.etype = floatExpr;
                        break;
                    }
                    case 'D': {
                        value.etype = doubleExpr;
                        break;
                    }
                    case 'C': {
                        value.etype = intExpr;
                        break;
                    }
                    case 'Z': {
                        value.etype = booleanExpr;
                        break;
                    }
                    case 't': {
                        value.etype = stringExpr;
                        break;
                    }
                    case 'o': {
                        value.etype = objExpr;
                        break;
                    }
                    case 'e': {
                        value.etype = variableNotFoundExpr;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("src type");
                    }
                }
                return value.etype;
            }

            public String toString() {
                return "Type=!";
            }
        };
        protected static final ExpressionType intExpr = new ExpressionType(){

            @Override
            public char typeChar() {
                return 'I';
            }

            @Override
            public ExpressionType checkArgument(Value value, Value value2) throws Exception {
                switch (value2.type_) {
                    case 'C': 
                    case 'I': {
                        return this;
                    }
                    case 'J': {
                        value.longVal = value.intVal;
                        value.type_ = (char)74;
                        value.etype = longExpr;
                        return value.etype;
                    }
                    case 'F': {
                        value.floatVal = value.intVal;
                        value.type_ = (char)70;
                        value.etype = floatExpr;
                        return value.etype;
                    }
                    case 'D': {
                        value.doubleVal = value.intVal;
                        value.type_ = (char)68;
                        value.etype = doubleExpr;
                        return value.etype;
                    }
                    case 'Z': {
                        value.boolVal = value.intVal != 0;
                        value.type_ = (char)90;
                        value.etype = booleanExpr;
                        return value.etype;
                    }
                    case 'o': {
                        if (value2.oVal instanceof Long) {
                            value2.longVal = (Long)value2.oVal;
                            value.longVal = value.intVal;
                            return longExpr;
                        }
                        if (value2.oVal instanceof Integer) {
                            value2.intVal = (Integer)value2.oVal;
                            return this;
                        }
                        if (value2.oVal instanceof Short) {
                            value2.intVal = ((Short)value2.oVal).shortValue();
                            return this;
                        }
                        if (value2.oVal instanceof Byte) {
                            value2.intVal = ((Byte)value2.oVal).byteValue();
                            return this;
                        }
                        if (value2.oVal instanceof Double) {
                            value2.doubleVal = (Double)value2.oVal;
                            value.doubleVal = value.intVal;
                            return doubleExpr;
                        }
                        if (value2.oVal instanceof Float) {
                            value2.floatVal = ((Float)value2.oVal).floatValue();
                            value.floatVal = value.intVal;
                            return floatExpr;
                        }
                        if (value2.oVal instanceof Boolean) {
                            value2.boolVal = (Boolean)value2.oVal;
                            value.boolVal = value.intVal != 0;
                            return booleanExpr;
                        }
                        if (value2.oVal instanceof Character) {
                            value2.intVal = ((Character)value2.oVal).charValue();
                            return this;
                        }
                        throw new IllegalArgumentException("the value should be of a numeric type");
                    }
                    case 'e': {
                        throw (Exception)value2.oVal;
                    }
                    case 't': {
                        try {
                            value2.longVal = Long.parseLong(value2.stringVal.toString());
                            return this;
                        }
                        catch (Exception exception) {
                            throw new IllegalArgumentException("CalculatorExpr - String converion error");
                        }
                    }
                }
                throw new IllegalArgumentException("src type");
            }

            public String toString() {
                return "Type=I";
            }
        };
        protected static final ExpressionType longExpr = new ExpressionType(){

            @Override
            public char typeChar() {
                return 'J';
            }

            @Override
            public ExpressionType checkArgument(Value value, Value value2) throws Exception {
                switch (value2.type_) {
                    case 'C': 
                    case 'I': {
                        value2.longVal = value2.intVal;
                        return this;
                    }
                    case 'J': {
                        return this;
                    }
                    case 'F': {
                        value.floatVal = value.longVal;
                        value.type_ = (char)70;
                        value.etype = floatExpr;
                        return value.etype;
                    }
                    case 'D': {
                        value.doubleVal = value.longVal;
                        value.type_ = (char)68;
                        value.etype = doubleExpr;
                        return value.etype;
                    }
                    case 'o': {
                        if (value2.oVal instanceof Long) {
                            value2.longVal = (Long)value2.oVal;
                            return this;
                        }
                        if (value2.oVal instanceof Integer) {
                            value2.longVal = ((Integer)value2.oVal).intValue();
                            return this;
                        }
                        if (value2.oVal instanceof Short) {
                            value2.longVal = ((Short)value2.oVal).shortValue();
                            return this;
                        }
                        if (value2.oVal instanceof Byte) {
                            value2.longVal = ((Byte)value2.oVal).byteValue();
                            return this;
                        }
                        if (value2.oVal instanceof Double) {
                            value2.doubleVal = (Double)value2.oVal;
                            value.doubleVal = value.longVal;
                            return doubleExpr;
                        }
                        if (value2.oVal instanceof Float) {
                            value2.floatVal = ((Float)value2.oVal).floatValue();
                            value.floatVal = value.longVal;
                            return floatExpr;
                        }
                        if (value2.oVal instanceof Boolean) {
                            value2.boolVal = (Boolean)value2.oVal;
                            value.boolVal = value.longVal != 0L;
                            return booleanExpr;
                        }
                        if (value2.oVal instanceof Character) {
                            value2.intVal = ((Character)value2.oVal).charValue();
                            return this;
                        }
                        throw new IllegalArgumentException("the value should be of a numeric type");
                    }
                    case 'e': {
                        throw (Exception)value2.oVal;
                    }
                }
                throw new IllegalArgumentException("src type");
            }

            public String toString() {
                return "Type=J";
            }
        };
        protected static final ExpressionType floatExpr = new ExpressionType(){

            @Override
            public char typeChar() {
                return 'F';
            }

            @Override
            public ExpressionType checkArgument(Value value, Value value2) throws Exception {
                switch (value2.type_) {
                    case 'C': 
                    case 'I': {
                        value2.floatVal = value2.intVal;
                        return this;
                    }
                    case 'J': {
                        value2.doubleVal = value2.longVal;
                        return doubleExpr;
                    }
                    case 'F': {
                        return this;
                    }
                    case 'D': {
                        value.doubleVal = value.floatVal;
                        value.type_ = (char)68;
                        value.etype = doubleExpr;
                        return value.etype;
                    }
                    case 'Z': {
                        value.boolVal = value.floatVal != 0.0f;
                        value.type_ = (char)90;
                        value.etype = booleanExpr;
                        return value.etype;
                    }
                    case 'o': {
                        if (value2.oVal instanceof Long) {
                            value2.floatVal = ((Long)value2.oVal).longValue();
                            return this;
                        }
                        if (value2.oVal instanceof Integer) {
                            value2.floatVal = ((Integer)value2.oVal).intValue();
                            return this;
                        }
                        if (value2.oVal instanceof Short) {
                            value2.floatVal = ((Short)value2.oVal).shortValue();
                            return this;
                        }
                        if (value2.oVal instanceof Byte) {
                            value2.floatVal = ((Byte)value2.oVal).byteValue();
                            return this;
                        }
                        if (value2.oVal instanceof Double) {
                            value2.doubleVal = (Double)value2.oVal;
                            value.doubleVal = value.floatVal;
                            return doubleExpr;
                        }
                        if (value2.oVal instanceof Float) {
                            value2.floatVal = ((Float)value2.oVal).floatValue();
                            return this;
                        }
                        if (value2.oVal instanceof Boolean) {
                            value2.boolVal = (Boolean)value2.oVal;
                            value.boolVal = value.floatVal != 0.0f;
                            return booleanExpr;
                        }
                        if (value2.oVal instanceof Character) {
                            value2.floatVal = ((Character)value2.oVal).charValue();
                            return this;
                        }
                        return objExpr;
                    }
                    case 'e': {
                        throw (Exception)value2.oVal;
                    }
                }
                throw new IllegalArgumentException("src type");
            }

            public String toString() {
                return "Type=F";
            }
        };
        protected static final ExpressionType doubleExpr = new ExpressionType(){

            @Override
            public char typeChar() {
                return 'D';
            }

            @Override
            public ExpressionType checkArgument(Value value, Value value2) throws Exception {
                switch (value2.type_) {
                    case 'C': 
                    case 'I': {
                        value2.doubleVal = value2.intVal;
                        return this;
                    }
                    case 'J': {
                        value2.doubleVal = value2.longVal;
                        return this;
                    }
                    case 'F': {
                        value2.doubleVal = value2.floatVal;
                        return this;
                    }
                    case 'D': {
                        return this;
                    }
                    case 'o': {
                        if (value2.oVal instanceof Long) {
                            value2.doubleVal = ((Long)value2.oVal).longValue();
                            return this;
                        }
                        if (value2.oVal instanceof Integer) {
                            value2.doubleVal = ((Integer)value2.oVal).intValue();
                            return this;
                        }
                        if (value2.oVal instanceof Short) {
                            value2.doubleVal = ((Short)value2.oVal).shortValue();
                            return this;
                        }
                        if (value2.oVal instanceof Byte) {
                            value2.doubleVal = ((Byte)value2.oVal).byteValue();
                            return this;
                        }
                        if (value2.oVal instanceof Double) {
                            value2.doubleVal = (Double)value2.oVal;
                            return this;
                        }
                        if (value2.oVal instanceof Float) {
                            value2.doubleVal = ((Float)value2.oVal).floatValue();
                            return this;
                        }
                        if (value2.oVal instanceof Boolean) {
                            value2.boolVal = (Boolean)value2.oVal;
                            value.boolVal = value.doubleVal != 0.0;
                            return booleanExpr;
                        }
                        if (value2.oVal instanceof Character) {
                            value2.doubleVal = ((Character)value2.oVal).charValue();
                            return this;
                        }
                        throw new IllegalArgumentException("the value should be of a numeric type");
                    }
                    case 'e': {
                        throw (Exception)value2.oVal;
                    }
                }
                throw new IllegalArgumentException("src type");
            }

            public String toString() {
                return "Type=D";
            }
        };
        protected static final ExpressionType booleanExpr = new ExpressionType(){

            @Override
            public char typeChar() {
                return 'Z';
            }

            @Override
            public ExpressionType checkArgument(Value value, Value value2) {
                switch (value2.type_) {
                    case 'C': 
                    case 'I': {
                        value2.boolVal = value2.intVal != 0;
                        break;
                    }
                    case 'J': {
                        value2.boolVal = value2.longVal != 0L;
                        break;
                    }
                    case 'F': {
                        value2.boolVal = value2.floatVal != 0.0f;
                        break;
                    }
                    case 'D': {
                        value2.boolVal = value2.doubleVal != 0.0;
                        break;
                    }
                    case 't': {
                        value2.boolVal = value2.stringVal != null && value2.stringVal.length() > 0;
                        break;
                    }
                    case 'o': {
                        if (value2.oVal instanceof Long) {
                            value2.boolVal = (Long)value2.oVal != 0L;
                        } else if (value2.oVal instanceof Integer) {
                            value2.boolVal = (Integer)value2.oVal != 0;
                        } else if (value2.oVal instanceof Short) {
                            value2.boolVal = (Short)value2.oVal != 0;
                        } else if (value2.oVal instanceof Byte) {
                            value2.boolVal = (Byte)value2.oVal != 0;
                        } else if (value2.oVal instanceof Double) {
                            value2.boolVal = (Double)value2.oVal != 0.0;
                        } else if (value2.oVal instanceof Float) {
                            value2.boolVal = ((Float)value2.oVal).floatValue() != 0.0f;
                        } else if (value2.oVal instanceof Boolean) {
                            value2.boolVal = (Boolean)value2.oVal;
                        } else if (value2.oVal instanceof Character) {
                            value2.boolVal = ((Character)value2.oVal).charValue() != '\u0000';
                        } else {
                            value2.boolVal = value2.oVal != null;
                        }
                        return this;
                    }
                    case 'e': {
                        value2.boolVal = false;
                        return this;
                    }
                    case 'Z': {
                        return this;
                    }
                    default: {
                        throw new IllegalArgumentException("src type");
                    }
                }
                return this;
            }

            public String toString() {
                return "Type=Z";
            }
        };
        protected static final ExpressionType finishBooleanExpr = new ExpressionType(){

            @Override
            public char typeChar() {
                return 'z';
            }

            @Override
            public ExpressionType checkArgument(Value value, Value value2) {
                return booleanExpr;
            }

            public String toString() {
                return "Type=z";
            }
        };
        protected static final ExpressionType stringExpr = new ExpressionType(){

            @Override
            public char typeChar() {
                return 't';
            }

            @Override
            public ExpressionType checkArgument(Value value, Value value2) {
                if (value.type_ != 't') {
                    value.stringVal = value.stringValue();
                    value.type_ = (char)116;
                }
                if (value2.type_ != 't') {
                    value2.stringVal = value2.stringValue();
                }
                return this;
            }

            public String toString() {
                return "Type=t";
            }
        };
        protected static final ExpressionType objExpr = new ExpressionType(){

            @Override
            public char typeChar() {
                return 'o';
            }

            @Override
            public ExpressionType checkArgument(Value value, Value value2) throws Exception {
                if (value.type_ == '?') {
                    value.type_ = value2.type_;
                    switch (value2.type_) {
                        case 'Z': {
                            value.etype = booleanExpr;
                            return value.etype;
                        }
                        case 'D': {
                            value.etype = doubleExpr;
                            return value.etype;
                        }
                        case 'F': {
                            value.etype = floatExpr;
                            return value.etype;
                        }
                        case 'I': {
                            value.etype = intExpr;
                            return value.etype;
                        }
                        case 'J': {
                            value.etype = longExpr;
                            return value.etype;
                        }
                        case 'o': {
                            value.etype = objExpr;
                            return value.etype;
                        }
                        case 'e': {
                            value.etype = objExpr;
                            return value.etype;
                        }
                        case 't': {
                            value.etype = stringExpr;
                            return value.etype;
                        }
                        case '?': {
                            throw new IllegalArgumentException("the type is not determined while operation.");
                        }
                    }
                    throw new IllegalArgumentException("unknown type char: " + value2.type_);
                }
                if (value.type_ != 't') {
                    value.stringVal = value.stringValue();
                    value.type_ = (char)116;
                }
                if (value2.type_ != 't') {
                    value2.stringVal = value2.stringValue();
                }
                value.etype = stringExpr;
                return value.etype;
            }

            public String toString() {
                return "Type=o";
            }
        };
        protected static final ExpressionType variableNotFoundExpr = new ExpressionType(){

            @Override
            public char typeChar() {
                return 'e';
            }

            @Override
            public ExpressionType checkArgument(Value value, Value value2) throws Exception {
                if (value.type_ == '?') {
                    value.type_ = (char)101;
                }
                value.etype = this;
                return value.etype;
            }

            public String toString() {
                return "Type=e";
            }
        };

        protected ExprTypes() {
        }
    }

    protected static interface ExpressionType {
        public char typeChar();

        public ExpressionType checkArgument(Value var1, Value var2) throws Exception;
    }

    public static class Value {
        protected char type_ = (char)63;
        ExpressionType etype = ExprTypes.startExpr;
        private long longVal;
        private int intVal;
        private double doubleVal;
        private float floatVal;
        private boolean boolVal;
        private CharSequence stringVal;
        private Object oVal;

        public Value(long l) {
            this.type_ = (char)74;
            this.etype = ExprTypes.longExpr;
            this.longVal = l;
        }

        public Value(int n) {
            this.type_ = (char)73;
            this.etype = ExprTypes.intExpr;
            this.intVal = n;
        }

        public Value(double d) {
            this.type_ = (char)68;
            this.etype = ExprTypes.doubleExpr;
            this.doubleVal = d;
        }

        public Value(float f) {
            this.type_ = (char)70;
            this.etype = ExprTypes.floatExpr;
            this.floatVal = f;
        }

        public Value(boolean bl) {
            this.type_ = (char)90;
            this.etype = ExprTypes.booleanExpr;
            this.boolVal = bl;
        }

        public Value(char c) {
            this.type_ = (char)67;
            this.etype = ExprTypes.intExpr;
            char c2 = c;
            this.intVal = c2;
            this.longVal = c2;
        }

        public Value(String string) {
            this.type_ = (char)116;
            this.etype = ExprTypes.stringExpr;
            this.stringVal = string;
            this.oVal = this.stringVal;
        }

        public Value(Appendable appendable) {
            this.type_ = (char)97;
            this.etype = ExprTypes.objExpr;
            this.oVal = appendable;
        }

        public Value(Object object) {
            this.type_ = (char)111;
            this.etype = ExprTypes.objExpr;
            this.oVal = object;
        }

        public Value() {
            this.type_ = (char)63;
            this.etype = ExprTypes.startExpr;
        }

        public char type() {
            return this.type_;
        }

        public void copy(Value value) {
            this.type_ = value.type_;
            this.etype = value.etype;
            this.longVal = value.longVal;
            this.intVal = value.intVal;
            this.doubleVal = value.doubleVal;
            this.floatVal = value.floatVal;
            this.boolVal = value.boolVal;
            this.stringVal = value.stringVal;
            this.oVal = value.oVal;
        }

        public boolean booleanValue() {
            switch (this.type_) {
                case 'I': {
                    return this.intVal != 0;
                }
                case 'J': {
                    return this.longVal != 0L;
                }
                case 'D': {
                    return this.doubleVal != 0.0;
                }
                case 'F': {
                    return this.floatVal != 0.0f;
                }
                case 'C': {
                    return this.intVal != 0;
                }
                case 'Z': {
                    return this.boolVal;
                }
                case 't': {
                    return this.stringVal != null && this.stringVal.length() > 0;
                }
                case 'o': {
                    if (this.oVal instanceof Long) {
                        return (Long)this.oVal != 0L;
                    }
                    if (this.oVal instanceof Integer) {
                        return (Integer)this.oVal != 0;
                    }
                    if (this.oVal instanceof Short) {
                        return (Short)this.oVal != 0;
                    }
                    if (this.oVal instanceof Byte) {
                        return (Byte)this.oVal != 0;
                    }
                    if (this.oVal instanceof Double) {
                        return (Double)this.oVal != 0.0;
                    }
                    if (this.oVal instanceof Float) {
                        return ((Float)this.oVal).floatValue() != 0.0f;
                    }
                    if (this.oVal instanceof Boolean) {
                        return (Boolean)this.oVal;
                    }
                    if (this.oVal instanceof Character) {
                        return ((Character)this.oVal).charValue() != '\u0000';
                    }
                    return this.oVal != null;
                }
                case 'e': {
                    return false;
                }
                case '?': {
                    return false;
                }
            }
            throw new IllegalArgumentException("unknown type char: " + this.type_);
        }

        public int intValue() {
            switch (this.type_) {
                case 'I': {
                    return this.intVal;
                }
                case 'C': {
                    return this.intVal;
                }
                case 'J': {
                    return (int)this.longVal;
                }
                case 'D': {
                    return (int)this.doubleVal;
                }
                case 'F': {
                    return (int)this.floatVal;
                }
                case 'Z': {
                    return this.boolVal ? 1 : 0;
                }
                case 't': {
                    return Integer.parseInt(this.stringVal.toString());
                }
                case 'o': {
                    throw new IllegalArgumentException("Double expected, object given.");
                }
                case '?': {
                    return 7777777;
                }
            }
            throw new IllegalArgumentException("unknown type char: " + this.type_);
        }

        public long longValue() {
            switch (this.type_) {
                case 'I': {
                    return this.intVal;
                }
                case 'C': {
                    return this.intVal;
                }
                case 'J': {
                    return this.longVal;
                }
                case 'D': {
                    return (long)this.doubleVal;
                }
                case 'F': {
                    return (long)this.floatVal;
                }
                case 'Z': {
                    return this.boolVal ? 1L : 0L;
                }
                case 't': {
                    return Long.parseLong(this.stringVal.toString());
                }
                case 'o': {
                    throw new IllegalArgumentException("Double expected, object given.");
                }
                case '?': {
                    return 777777777777L;
                }
            }
            throw new IllegalArgumentException("unknown type char: " + this.type_);
        }

        public double doubleValue() {
            switch (this.type_) {
                case 'F': {
                    return this.floatVal;
                }
                case 'I': {
                    return this.intVal;
                }
                case 'C': {
                    return this.intVal;
                }
                case 'J': {
                    return this.longVal;
                }
                case 'D': {
                    return this.doubleVal;
                }
                case 'Z': {
                    return this.boolVal ? 1.0 : 0.0;
                }
                case 't': {
                    return Double.parseDouble(this.stringVal.toString());
                }
                case 'o': {
                    throw new IllegalArgumentException("Double expected, object given.");
                }
                case '?': {
                    return 7777777.0;
                }
            }
            throw new IllegalArgumentException("unknown type char: " + this.type_);
        }

        public float floatValue() {
            switch (this.type_) {
                case 'I': {
                    return this.intVal;
                }
                case 'C': {
                    return this.intVal;
                }
                case 'J': {
                    return this.longVal;
                }
                case 'D': {
                    return (float)this.doubleVal;
                }
                case 'F': {
                    return this.floatVal;
                }
                case 'Z': {
                    return this.boolVal ? 1.0f : 0.0f;
                }
                case 't': {
                    return Float.parseFloat(this.stringVal.toString());
                }
                case 'o': {
                    throw new IllegalArgumentException("Double expected, object given.");
                }
                case '?': {
                    return 77777.0f;
                }
            }
            throw new IllegalArgumentException("unknown type char: " + this.type_);
        }

        public CharSequence stringValue() {
            switch (this.type_) {
                case 'I': {
                    return StringSeq.create(Integer.toString(this.intVal));
                }
                case 'J': {
                    return StringSeq.create(Long.toString(this.longVal));
                }
                case 'D': {
                    return StringSeq.create(Double.toString(this.doubleVal));
                }
                case 'F': {
                    return StringSeq.create(Float.toString(this.floatVal));
                }
                case 'C': {
                    return new StringBuilder(1).append((char)this.intVal);
                }
                case 'Z': {
                    return StringSeq.create(Boolean.toString(this.boolVal));
                }
                case 't': {
                    return this.stringVal;
                }
                case 'o': {
                    return StringSeq.create(this.oVal == null ? "null" : this.oVal.toString());
                }
                case 'e': {
                    return StringSeq.create(this.oVal.toString());
                }
                case '?': {
                    return StringSeq.create("??");
                }
            }
            return StringSeq.create("?" + this.type_);
        }

        public Object objValue() {
            switch (this.type_) {
                case 'I': {
                    return new Integer(this.intVal);
                }
                case 'C': {
                    return new Character((char)this.intVal);
                }
                case 'J': {
                    return new Long(this.longVal);
                }
                case 'D': {
                    return new Double(this.doubleVal);
                }
                case 'F': {
                    return new Float(this.doubleVal);
                }
                case 'Z': {
                    return new Boolean(this.boolVal);
                }
                case 't': {
                    return this.stringVal;
                }
                case 'e': 
                case 'o': {
                    return this.oVal;
                }
            }
            return "?" + this.type_;
        }

        public boolean isObjValue() {
            return this.type_ == 'o';
        }

        public String stringxValue() {
            switch (this.type_) {
                case 'I': {
                    return Integer.toString(this.intVal);
                }
                case 'J': {
                    return Long.toString(this.longVal);
                }
                case 'D': {
                    return Double.toString(this.doubleVal);
                }
                case 'F': {
                    return Float.toString(this.floatVal);
                }
                case 'C': {
                    return "" + (char)this.intVal;
                }
                case 'Z': {
                    return Boolean.toString(this.boolVal);
                }
                case 't': {
                    return this.stringVal.toString();
                }
                case 'o': {
                    return this.oVal == null ? "null" : this.oVal.toString();
                }
                case 'e': {
                    return ((Exception)this.oVal).getMessage();
                }
                case '?': {
                    return "??";
                }
            }
            return "?" + this.type_;
        }

        public void toNumValue() {
            if ("JISBFD".indexOf(this.type_) < 0) {
                String string = this.stringVal != null ? this.stringVal.toString() : (this.oVal != null ? this.oVal.toString() : "0");
                int n = string.length();
                int[] nArray = new int[1];
                long l = StringFunctions_C.parseIntRadix(string, 0, 999999, 10, nArray, " ,'");
                int n2 = nArray[0];
                if (n2 < n && string.charAt(n2) == '.') {
                    long l2 = StringFunctions_C.parseIntRadix(string.substring(n2 + 1), 0, 999999, 10, nArray, " ,'");
                    if (n2 + nArray[0] > 7) {
                        // empty if block
                    }
                }
                if ("DF".indexOf(this.type_) < 0) {
                    if (n <= 9) {
                        this.intVal = (int)l;
                        this.type_ = (char)73;
                        this.etype = ExprTypes.intExpr;
                    } else {
                        this.longVal = l;
                        this.type_ = (char)76;
                        this.etype = ExprTypes.longExpr;
                    }
                }
            }
        }

        public String toString() {
            char c = this.etype == null ? (char)'?' : (char)this.etype.typeChar();
            switch (this.type_) {
                case 'I': {
                    return c + "I " + Integer.toString(this.intVal);
                }
                case 'J': {
                    return c + "J " + Long.toString(this.longVal);
                }
                case 'D': {
                    return c + "D " + Double.toString(this.doubleVal);
                }
                case 'F': {
                    return c + "F " + Float.toString(this.floatVal);
                }
                case 'C': {
                    return c + "C " + (char)this.intVal;
                }
                case 'Z': {
                    return c + "Z " + Boolean.toString(this.boolVal);
                }
                case 't': {
                    return c + "t " + this.stringVal.toString();
                }
                case 'o': {
                    return c + "o " + (this.oVal == null ? "null" : this.oVal.toString());
                }
                case 'e': {
                    return c + "e " + (this.oVal instanceof Exception ? ((Exception)this.oVal).getMessage() : (this.oVal == null ? "null" : this.oVal.toString()));
                }
                case '?': {
                    return c + "??";
                }
            }
            return c + "?" + this.type_;
        }
    }

    @Deprecated
    public static class Data {
        protected Value accu;
        protected final Stack<Value> stack = new Stack();

        public void clean() {
            this.stack.clear();
            this.accu = new Value();
        }

        public Data() {
            this.clean();
        }
    }
}

