/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.tools.ReadWriteFileBase;
import org.vishia.util.Arguments;
import org.vishia.util.ExcUtil;

public class PrepareAsciidoc
extends ReadWriteFileBase {
    public static final String sVersion = "2023-03-17";
    private static String sChpAdd = "=====";
    int[] chpNr = new int[5];
    String chpLabel = null;
    Map<String, String> idxChpLabel = new TreeMap<String, String>();
    Map<String, String> idxChpNr = new TreeMap<String, String>();

    public static void main(String[] stringArray) {
        Args args = new Args();
        args.readArguments(stringArray);
        try {
            PrepareAsciidoc.smain(args);
        }
        catch (Throwable throwable) {
            CharSequence charSequence = ExcUtil.exceptionInfo("unexpected: ", throwable, 0, 20);
            System.err.println(charSequence);
            System.exit(5);
        }
        System.exit(0);
    }

    public static void smain(Args args) throws IOException {
        PrepareAsciidoc prepareAsciidoc = new PrepareAsciidoc();
        prepareAsciidoc.processFile(null, args);
        System.out.println("all chapter label gathered ");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(args.fOut), args.csOut);
        prepareAsciidoc.processFile(outputStreamWriter, args);
        ((Writer)outputStreamWriter).close();
    }

    void processChapterStruct(String string, Args args) throws IOException {
        int n = 0;
        if (string.startsWith("[#")) {
            int n2 = string.indexOf(93);
            this.chpLabel = string.substring(2, n2);
        } else if (string.startsWith("== ")) {
            this.chpNr[0] = this.chpNr[0] + 1;
            this.chpNr[1] = 0;
            this.chpNr[2] = 0;
            this.chpNr[3] = 0;
            this.chpNr[4] = 0;
            n = 1;
        } else if (string.startsWith("=== ")) {
            this.chpNr[1] = this.chpNr[1] + 1;
            this.chpNr[2] = 0;
            this.chpNr[3] = 0;
            this.chpNr[4] = 0;
            n = 2;
        } else if (string.startsWith("==== ")) {
            this.chpNr[2] = this.chpNr[2] + 1;
            this.chpNr[3] = 0;
            this.chpNr[4] = 0;
            n = 3;
        } else if (string.startsWith("===== ")) {
            this.chpNr[3] = this.chpNr[3] + 1;
            this.chpNr[4] = 0;
            n = 4;
        } else if (string.startsWith("====== ")) {
            this.chpNr[4] = this.chpNr[4] + 1;
            n = 5;
        } else {
            n = 0;
            this.chpLabel = null;
        }
        if (n > 0) {
            String string2 = "";
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    string2 = string2 + '.';
                }
                string2 = string2 + Integer.toString(this.chpNr[i]);
            }
            if (this.chpLabel == null) {
                System.err.println("No chapter label for " + string2 + string);
            } else {
                this.idxChpNr.put(this.chpLabel, string2);
                this.idxChpLabel.put(string2, this.chpLabel);
            }
        }
    }

    void processFile(Writer writer, Args args) throws IOException {
        boolean bl = true;
        for (File file : args.fIn) {
            String string;
            File file2 = file.getParentFile();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), args.csIn));
            if (!bl) {
                while (!((string = bufferedReader.readLine()) == null || string.startsWith("[#") || string.startsWith("== ") || string.startsWith("<<<"))) {
                }
            } else {
                string = bufferedReader.readLine();
            }
            bl = false;
            do {
                this.processLine(string, bufferedReader, writer, file2, args);
            } while ((string = bufferedReader.readLine()) != null);
            bufferedReader.close();
        }
        System.out.println("successfull: " + args.fOut.getPath());
    }

    void processLine(String string, BufferedReader bufferedReader, Writer writer, File file, Args args) throws IOException {
        if (string.equals("----")) {
            if (writer != null) {
                this.processPre(bufferedReader, writer, file, args);
            } else {
                this.skipPre(bufferedReader);
            }
        } else if (string.startsWith("include::")) {
            this.processIncludeAdoc(string, writer, file, args);
        } else if (writer == null) {
            this.processChapterStruct(string, args);
        } else {
            String string2 = string;
            int n = string.indexOf("link:");
            if (n >= 0) {
                string2 = this.replaceLink(string, n, args);
            }
            string2 = this.addChapterNrToChapterLink(string);
            writer.append(string2).append('\n');
        }
    }

    private String replaceLink(String string, int n, Args args) {
        String string2 = string;
        String string3 = string.substring(n + 5);
        if (!(string3.startsWith("https:") || string3.startsWith("http:") || string3.startsWith("www."))) {
            int n2 = 0;
            while (string3.substring(3 * n2).startsWith("../")) {
                ++n2;
            }
            String string4 = n2 == 0 ? "/" + string3 : string3.substring(3 * n2 - 1);
            string2 = string.substring(0, n + 5) + args.rlink[n2] + string4;
        }
        return string2;
    }

    private String addChapterNrToChapterLink(String string) {
        int n;
        String string2 = string;
        int n2 = 0;
        while ((n = string2.indexOf("<<#", n2)) >= 0) {
            n2 = string2.indexOf(">>", n);
            String string3 = string2.substring(n + 3, n2);
            String string4 = this.idxChpNr.get(string3);
            if (string4 == null) {
                System.err.println("chapter label not found: " + string3);
                continue;
            }
            string2 = string2.substring(0, n) + string4 + ' ' + string2.substring(n);
            n2 += string4.length() + 1;
        }
        return string2;
    }

    void processIncludeAdoc(String string, Writer writer, File file, Args args) throws IOException {
        int n = string.indexOf(91);
        int n2 = string.indexOf(93, n + 1);
        String string2 = null;
        String string3 = null;
        int n3 = 0;
        if (n < 0 || n2 < 0) {
            System.err.println("missing [...]: " + string);
        } else {
            BufferedReader bufferedReader;
            int n4;
            String[] stringArray;
            for (String fileNotFoundException : stringArray = string.substring(n + 1, n2).split(",")) {
                if ((fileNotFoundException = fileNotFoundException.trim()).startsWith("leveloffset")) {
                    n4 = fileNotFoundException.indexOf("=");
                    String n5 = fileNotFoundException.substring(n4 + 1).trim();
                    n3 = Integer.parseInt(n5);
                    continue;
                }
                if (!fileNotFoundException.startsWith("chapter=")) continue;
                n4 = fileNotFoundException.indexOf("..");
                if (n4 > 0) {
                    string3 = "[#" + fileNotFoundException.substring(n4 + 2).trim() + "]";
                    string2 = "[#" + fileNotFoundException.substring(8, n4).trim() + "]";
                    continue;
                }
                string2 = string3 = "[#" + fileNotFoundException.substring(8).trim() + "]";
            }
            String string4 = string.substring(9, n);
            File file2 = new File(file, string4);
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), args.csIn));
            }
            catch (FileNotFoundException fileNotFoundException) {
                bufferedReader = null;
                writer.append("ERROR file not found: ").append(string4).append('\n');
                System.err.println("ERROR file not found: " + string4);
            }
            if (bufferedReader != null) {
                String fileNotFoundException;
                n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while ((fileNotFoundException = bufferedReader.readLine()) != null) {
                    if (fileNotFoundException.startsWith("<<<")) {
                        n4 = 1;
                        continue;
                    }
                    if (string2 == null && (fileNotFoundException.startsWith("[#") || fileNotFoundException.startsWith("== ") || fileNotFoundException.startsWith("<<<")) || string2 != null && fileNotFoundException.startsWith(string2)) break;
                    if (fileNotFoundException.trim().length() <= 0) continue;
                    n4 = 0;
                }
                if (writer == null || n4 != 0) {
                    // empty if block
                }
                boolean bl = false;
                while (fileNotFoundException != null) {
                    try {
                        if (string3 != null && fileNotFoundException.startsWith(string3)) {
                            bl = true;
                            n5 = 0;
                        }
                        if (fileNotFoundException.startsWith("==")) {
                            n6 = 1;
                            while (fileNotFoundException.charAt(++n6) == '=') {
                            }
                            if (bl) {
                                if (n5 == 0) {
                                    n5 = n6;
                                } else if (n6 <= n5) break;
                            }
                            if (n3 > 0) {
                                fileNotFoundException = sChpAdd.substring(0, n3) + fileNotFoundException;
                            }
                        }
                        this.processLine(fileNotFoundException, bufferedReader, writer, file, args);
                    }
                    catch (Exception exception) {
                        CharSequence charSequence = ExcUtil.exceptionInfo(" // ERROR in Line while PrepareAsciidoc.java: ", exception, 0, 10);
                        writer.append(fileNotFoundException + charSequence);
                    }
                    fileNotFoundException = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
        }
    }

    void processPre(BufferedReader bufferedReader, Writer writer, File file, Args args) throws IOException {
        String string;
        writer.append("----\n");
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("include::")) {
                String string2;
                int n = string.indexOf(91);
                int n2 = string.indexOf(93, n + 1);
                if (n > 0 && n2 == n + 1) {
                    string2 = null;
                } else if (!string.substring(n).startsWith("[tag=") || n2 < 0) {
                    System.err.println("faulty " + string);
                    string2 = null;
                } else {
                    string2 = string.substring(n + 5, n2);
                }
                this.readTagFromFile(string.substring(9, n), string2, writer, file, args);
                continue;
            }
            if (string.startsWith("----")) {
                writer.append("----\n");
                break;
            }
            writer.append(this.shortenPreLine(string, args)).append('\n');
        }
    }

    void skipPre(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("----")) {
        }
    }

    private String shortenPreLine(String string, Args args) {
        int n;
        for (n = string.length(); n > args.maxLineLength && string.charAt(n - 1) == ' '; --n) {
        }
        if (n > args.maxLineLength) {
            return string.substring(0, args.maxLineLength - 3) + "...";
        }
        return string;
    }

    void readTagFromFile(String string, String string2, Writer writer, File file, Args args) throws IOException {
        BufferedReader bufferedReader;
        File file2 = new File(file, string);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), args.csIn));
        }
        catch (FileNotFoundException fileNotFoundException) {
            bufferedReader = null;
            writer.append("ERROR file not found: ").append(string).append('\n');
            System.err.println("ERROR file not found: " + string);
        }
        if (bufferedReader != null) {
            String string3;
            boolean bl = string2 == null;
            boolean bl2 = false;
            boolean bl3 = false;
            while (!bl2 && (string3 = bufferedReader.readLine()) != null) {
                if (!bl) {
                    if (!string3.contains("tag::" + string2 + "[]")) continue;
                    bl = true;
                    continue;
                }
                if (string2 != null && string3.contains("end::" + string2 + "[]")) {
                    bl2 = true;
                    continue;
                }
                if (string3.contains("tagOffStart::")) {
                    writer.append("    ......\n");
                    bl3 = true;
                    continue;
                }
                if (string3.contains("tagOffEnd::")) {
                    bl3 = false;
                    continue;
                }
                if (string3.contains("tagOff::")) {
                    writer.append("    ......\n");
                    continue;
                }
                if (bl3 || string3.contains("tag::") || string3.contains("end::")) continue;
                writer.append(this.shortenPreLine(string3, args)).append('\n');
            }
            if (!(string2 == null || bl && bl2)) {
                System.err.println("Problem with tag=" + string2 + " in " + string);
            }
            bufferedReader.close();
        }
    }

    static class Args
    extends ReadWriteFileBase.ArgsBase {
        Arguments.Argument sMaxLineLength = new Arguments.Argument("-lmax", ":97 maximal length of a line in a pre section");
        Arguments.SetArgument set_rlink = new Arguments.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                assert (string.charAt(1) == ':');
                int n = string.charAt(0) - 48;
                rlink[n] = string.substring(2);
                return true;
            }
        };
        int maxLineLength;
        String[] rlink = new String[5];

        Args() {
            super("Preparation of Asciidoc", "");
            this.addArg(this.sMaxLineLength);
            this.addArg(new Arguments.Argument("-rlink", ":1:https// replaces for link:../link, digit is number of ../../", this.set_rlink));
        }

        @Override
        public boolean testConsistence(Appendable appendable) throws IOException {
            boolean bl = super.testConsistence(appendable);
            if (!bl) {
                return false;
            }
            this.maxLineLength = this.sMaxLineLength.val != null ? Integer.parseInt(this.sMaxLineLength.val) : 97;
            return bl;
        }
    }
}

