/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.header2Reflection;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.byteData.Class_Jc;
import org.vishia.byteData.Field_Jc;
import org.vishia.byteData.ObjectArray_Jc;
import org.vishia.byteData.RawDataAccess;
import org.vishia.byteData.SuperclassIfc_idxMtblJc_ByteDataAccess;
import org.vishia.header2Reflection.BinOutShow;
import org.vishia.header2Reflection.ExtReflection_Insp_h;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.util.FileSystem;
import org.vishia.util.StdHexFormatWriter;

public class BinOutPrep {
    public static final String version = "2018-12-31";
    private OutputStream fileBin;
    private final String sFileBin;
    private final String sFileList;
    private final byte[] binOutData;
    private final byte[] binOutHeadData;
    private final byte[] binOutClassArrayData;
    private final RawDataAccess binOutRefl;
    private final ExtReflection_Insp_h.ExtReflection_Insp binOutHead;
    private final ObjectArray_Jc binOutClassArray;
    private final Class_Jc binClass;
    private final ObjectArray_Jc binOutSuperArray;
    private final SuperclassIfc_idxMtblJc_ByteDataAccess binSuperClass;
    private final ObjectArray_Jc binFieldArray;
    private final Field_Jc binField;
    private int nrofRelocEntries = 0;
    private int nrofClasses = 0;
    private int nrofFieldsInClass;
    private final Map<String, TypeBinPosition> posClassesInBuffer = new TreeMap<String, TypeBinPosition>();
    private final Map<String, Integer> missingClasses = new TreeMap<String, Integer>();
    private final List<TypeNeedInBinOut> typeBinNeed = new LinkedList<TypeNeedInBinOut>();

    public BinOutPrep(String string, String string2, boolean bl, boolean bl2, int n) throws FileNotFoundException {
        this.sFileBin = string;
        File file = FileFunctions.newFile(string);
        this.fileBin = bl2 ? new StdHexFormatWriter(FileFunctions.newFile(string)) : new FileOutputStream(file);
        this.sFileList = string + ".lst";
        this.binOutData = new byte[2000000];
        this.binOutHeadData = new byte[400000];
        this.binOutClassArrayData = new byte[80000];
        this.binOutHead = new ExtReflection_Insp_h.ExtReflection_Insp(this.binOutHeadData);
        this.binOutHead.setBigEndian(bl);
        this.binOutHead.set_sign(n);
        this.binOutRefl = new RawDataAccess();
        this.binOutRefl.assignClear(this.binOutData);
        this.binOutRefl.setBigEndian(bl);
        this.binOutClassArray = new ObjectArray_Jc();
        this.binOutClassArray.assignClear(this.binOutClassArrayData);
        this.binOutClassArray.setBigEndian(bl);
        this.binOutClassArray.set_sizeElement(4);
        this.binClass = new Class_Jc();
        this.binOutSuperArray = new ObjectArray_Jc();
        this.binSuperClass = new SuperclassIfc_idxMtblJc_ByteDataAccess();
        this.binFieldArray = new ObjectArray_Jc();
        this.binField = new Field_Jc();
    }

    private void setRelocEntry(int n) throws IllegalArgumentException {
        ++this.nrofRelocEntries;
        this.binOutHead.add_relocateAddr(n);
    }

    public int addSuperclass(String string) throws IllegalArgumentException {
        if (string.equals("Controller_ObjMod")) {
            Debugutil.stop();
        }
        this.binOutRefl.addChild(this.binOutSuperArray);
        this.binOutSuperArray.clearData();
        this.binOutSuperArray.set_length(1);
        this.binOutSuperArray.set_sizeElement(56);
        this.binOutSuperArray.set_mode(256);
        this.binOutSuperArray.addChild(this.binSuperClass);
        this.binSuperClass.clearData();
        this.binSuperClass.addInnerChildren();
        TypeBinPosition typeBinPosition = this.posClassesInBuffer.get(string);
        int n = 0;
        if (typeBinPosition != null) {
            n = typeBinPosition.posClassInBuffer;
        }
        int n2 = this.binSuperClass.set_TypeOffs(n);
        if (typeBinPosition == null) {
            this.typeBinNeed.add(new TypeNeedInBinOut(string, n2));
        } else {
            this.setRelocEntry(n2);
        }
        this.binSuperClass.set_Field("super");
        this.binOutSuperArray.setIdentSize(true, true, 4090, this.binOutSuperArray.getLength());
        return this.binOutSuperArray.getPositionInBuffer();
    }

    public int addClass(String string, String string2) throws IllegalArgumentException {
        this.binOutRefl.addChild(this.binClass);
        this.binClass.clearData();
        int n = this.binClass.getPositionInBuffer();
        ++this.nrofClasses;
        this.binOutClassArray.addChildInteger(4, n);
        this.binClass.setName(string2);
        this.binClass.set_posObjectBase(0);
        this.binClass.setIdentSize();
        this.binClass.set_nSize(-4096 + this.nrofClasses);
        this.posClassesInBuffer.put(string, new TypeBinPosition(n));
        this.nrofFieldsInClass = 0;
        return this.nrofClasses;
    }

    void setClassSuperclass(int n) {
        int n2 = this.binClass.setOffs_superclasses(n);
        this.setRelocEntry(n2);
    }

    public void setClassBasedOnObjectJc() {
        this.binClass.set_modifiers(0x4000000);
    }

    public void addFieldHead() throws IllegalArgumentException {
        this.binOutRefl.addChild(this.binFieldArray);
        this.binFieldArray.clearData();
    }

    public void addField(String string, int n, String string2, int n2, int n3) throws IllegalArgumentException {
        int n4;
        ++this.nrofFieldsInClass;
        int n5 = this.nrofFieldsInClass;
        this.binFieldArray.addChildEmpty(this.binField);
        this.binField.setName(string);
        this.binField.set_nrofArrayElements(n3);
        this.binField.set_position(32768 + n5);
        this.binField.set_offsetToObjectifcBase(0);
        if (n3 > 0) {
            this.stop();
        }
        if (n == -1) {
            n4 = this.binField.getPositionInBuffer_type();
            this.typeBinNeed.add(new TypeNeedInBinOut(string2, n4));
            this.binField.set_type(0);
        } else {
            this.binField.set_type(n);
        }
        this.binField.set_bitModifiers(n2);
        n4 = this.binField.setOffs_declaringClass(this.binClass.getPositionInBuffer());
        this.setRelocEntry(n4);
    }

    void setAttributRef(int n) throws IllegalArgumentException {
        this.binFieldArray.set_length(n);
        this.binFieldArray.setIdentSize(true, true, 4085, this.binFieldArray.getLength());
        int n2 = this.binFieldArray.getPositionInBuffer();
        int n3 = this.binClass.setOffs_attributes(n2);
        this.setRelocEntry(n3);
    }

    public void closeAddClass() {
        this.setAttributRef(this.nrofFieldsInClass);
    }

    public void postProcessBinOut() throws IOException, IllegalArgumentException {
        Object object;
        int n;
        for (TypeNeedInBinOut object2 : this.typeBinNeed) {
            n = object2.posRefInFieldBuffer;
            object = this.posClassesInBuffer.get(object2.sType);
            if (object != null) {
                int binOutShow = ((TypeBinPosition)object).posClassInBuffer;
                int n2 = binOutShow - n;
                this.binOutRefl.setIntVal(n, 4, n2);
                this.setRelocEntry(n);
                continue;
            }
            Integer n3 = this.missingClasses.get(object2.sType);
            if (n3 == null) {
                n3 = new Integer(0);
                this.missingClasses.put(object2.sType, n3);
            }
            n3 = n3 + 1;
            this.binOutRefl.setIntVal(n, 4, 1L);
        }
        for (Map.Entry entry : this.missingClasses.entrySet()) {
            System.err.println("Missing type " + (String)entry.getKey());
        }
        this.binOutClassArray.set_length(this.nrofClasses);
        this.binOutClassArray.setIdentSize(true, true, 4092, this.binOutClassArray.getLength());
        int n5 = this.binOutHead.getLengthTotal();
        int n4 = this.binOutClassArray.getLengthTotal();
        n = this.binOutRefl.getLengthTotal();
        this.binOutHead.set_nrofRelocEntries(this.nrofRelocEntries);
        this.binOutHead.set_arrayClasses(n5);
        this.binOutHead.set_classDataBlock(n5 + n4);
        this.fileBin.write(this.binOutHead.getData(), 0, n5);
        this.fileBin.write(this.binOutClassArray.getData(), 0, n4);
        this.fileBin.write(this.binOutRefl.getData(), 0, n);
        if (this.sFileList != null) {
            object = FileSystem.readBinFile(FileFunctions.newFile(this.sFileBin));
            BinOutShow binOutShow = new BinOutShow((byte[])object, ((Object)object).length);
            binOutShow.show(FileFunctions.newFile(this.sFileList));
        }
    }

    public void writeAsCfile(File file) {
        block4: {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.close();
                bufferedWriter = null;
            }
            catch (IOException iOException) {
                Assert.exceptionInfo("", iOException, 0, 10);
                if (bufferedWriter == null) break block4;
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
    }

    public void close() throws IOException {
        this.fileBin.close();
    }

    void stop() {
    }

    private static class TypeNeedInBinOut {
        String sType;
        int posRefInFieldBuffer;

        public TypeNeedInBinOut(String string, int n) {
            this.sType = string;
            this.posRefInFieldBuffer = n;
        }
    }

    private static class TypeBinPosition {
        int posClassInBuffer;

        public TypeBinPosition(int n) {
            this.posClassInBuffer = n;
        }
    }
}

