/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.io.Serializable;
import org.vishia.event.Payload;
import org.vishia.event.PayloadBack;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCmdEventData;

public class FileRemoteProgressEvData
extends PayloadBack
implements Serializable,
Payload {
    public static final String version = "2023-07-24";
    private static final long serialVersionUID = 1L;
    public ProgressCmd progressCmd;
    public FileRemoteCmdEventData.Cmd answerToCmd;
    public FileRemote currFile;
    public FileRemote currDir;
    public long dateCreate;
    public long dateLastAccess;
    public long nrofBytesAll;
    public long nrofBytesFile;
    public long nrofBytesFileCopied;
    public int nrDirVisited;
    public int nrDirProcessed;
    public int nrFilesVisited;
    public int nrofFilesSelected;
    public int nrofFilesMarked;
    public int modeCopyOper;
    public boolean bQuest;
    public boolean bPause;
    protected boolean bAbort;
    protected boolean bOverwrite;
    protected boolean bOverwriteAll;
    protected boolean bMkdirAll;

    @Override
    public FileRemoteProgressEvData clean() {
        super.clean();
        this.currFile = null;
        this.currDir = null;
        this.progressCmd = ProgressCmd.noCmd;
        this.dateCreate = 0L;
        this.dateLastAccess = 0L;
        this.nrDirProcessed = 0;
        this.nrDirVisited = 0;
        this.nrFilesVisited = 0;
        this.nrofFilesSelected = 0;
        this.nrofFilesMarked = 0;
        this.nrofBytesAll = 0L;
        this.nrofBytesFile = 0L;
        this.nrofBytesFileCopied = 0L;
        this.bQuest = false;
        this.bPause = false;
        this.bAbort = false;
        this.bOverwrite = false;
        this.bOverwriteAll = false;
        this.bMkdirAll = false;
        return this;
    }

    public void done(FileRemoteCmdEventData.Cmd cmd, String string) {
        this.sError = string;
        this.answerToCmd = cmd;
        this.bDone = true;
    }

    @Override
    public boolean done() {
        return this.bDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAnswer(ProgressCmd progressCmd) {
        this.progressCmd = progressCmd;
        if (this.bQuest) {
            FileRemoteProgressEvData fileRemoteProgressEvData = this;
            synchronized (fileRemoteProgressEvData) {
                this.notify();
            }
        }
    }

    public boolean abort() {
        return this.bAbort;
    }

    public void setAbort() {
        this.bAbort = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pause() {
        boolean bl = false;
        while (this.bPause) {
            bl = true;
            FileRemoteProgressEvData fileRemoteProgressEvData = this;
            synchronized (fileRemoteProgressEvData) {
                this.bQuest = true;
                try {
                    this.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.bQuest = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPause(boolean bl) {
        this.bPause = bl;
        if (this.bQuest && !bl) {
            FileRemoteProgressEvData fileRemoteProgressEvData = this;
            synchronized (fileRemoteProgressEvData) {
                this.notify();
            }
        }
    }

    public boolean overwrite() {
        return this.bOverwrite;
    }

    public void setOverwrite(boolean bl) {
        this.bOverwrite = bl;
    }

    public boolean bOverwriteAll() {
        return this.bOverwriteAll;
    }

    public void setbOverwriteAll(boolean bl) {
        this.bOverwriteAll = bl;
    }

    public boolean mkdirAll() {
        return this.bMkdirAll;
    }

    public void setMkdirAll(boolean bl) {
        this.bMkdirAll = bl;
    }

    @Override
    public byte[] serialize() {
        return null;
    }

    @Override
    public boolean deserialize(byte[] byArray) {
        return false;
    }

    public static enum ProgressCmd {
        noCmd,
        refreshDirPre,
        refreshDirPost,
        refreshFile,
        refreshFileFaulty,
        done,
        nok,
        error,
        askErrorSrcOpen,
        askErrorDstCreate,
        askDstOverwr,
        askDstReadonly,
        askDstNotAbletoOverwr,
        askErrorCopy,
        acknAbortAll,
        acknAbortDir,
        acknAbortFile;

    }

    public static enum Answer {
        noCmd,
        cont,
        overwrite,
        skip,
        abortFile,
        abortDir,
        abortAll;

    }
}

