/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventWithDst;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.fileRemote.FileRemoteProgressEvData;
import org.vishia.fileRemote.FileRemoteWalkerCallback;

public abstract class FileRemoteAccessor
implements EventConsumer {
    private static final long serialVersionUID = 1589913596618865454L;
    public static final String version = "2023-07-22";

    protected FileRemoteAccessor() {
    }

    public abstract void activate();

    public abstract void close();

    public abstract CharSequence completeFilePath(CharSequence var1);

    public abstract void refreshFileProperties(FileRemote var1, EventWithDst<FileRemoteProgressEvData, ?> var2);

    public abstract String cmd(boolean var1, FileRemoteCmdEventData var2, EventWithDst<FileRemoteProgressEvData, ?> var3);

    public String cmdFile(FileRemote fileRemote, FileRemoteCmdEventData.Cmd cmd, FileRemote fileRemote2, String string, long l, EventWithDst<FileRemoteProgressEvData, FileRemoteCmdEventData> eventWithDst) {
        EventWithDst<FileRemoteCmdEventData, FileRemoteProgressEvData> eventWithDst2 = eventWithDst != null ? eventWithDst.getOpponent() : null;
        FileRemoteCmdEventData fileRemoteCmdEventData = eventWithDst2 != null ? eventWithDst2.data() : new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdChgFileRemote(fileRemote, cmd, fileRemote2, string, l);
        boolean bl = eventWithDst2 == null;
        return this.cmd(bl, fileRemoteCmdEventData, eventWithDst);
    }

    public abstract List<File> getChildren(FileRemote var1, FileFilter var2);

    protected abstract boolean setLastModified(FileRemote var1, long var2);

    public abstract boolean createNewFile(FileRemote var1, EventWithDst<FileRemoteProgressEvData, ?> var2) throws IOException;

    public abstract boolean delete(FileRemote var1, EventWithDst<FileRemoteProgressEvData, ?> var2);

    public abstract boolean mkdir(FileRemote var1, boolean var2, EventWithDst<FileRemoteProgressEvData, ?> var3);

    public abstract void copyChecked(FileRemote var1, String var2, String var3, int var4, FileRemoteWalkerCallback var5, FileRemoteProgressEvData var6);

    public abstract void search(FileRemote var1, byte[] var2, FileRemoteWalkerCallback var3, FileRemoteProgressEvData var4);

    public abstract ReadableByteChannel openRead(FileRemote var1, long var2);

    public abstract InputStream openInputStream(FileRemote var1, long var2);

    public abstract WritableByteChannel openWrite(FileRemote var1, long var2);

    public abstract OutputStream openOutputStream(FileRemote var1, long var2);

    public abstract boolean isLocalFileSystem();

    public abstract CharSequence getStateInfo();

    public abstract void abortAll();

    public static class FileWalkerThread
    extends Thread {
        protected final FileRemote startDir;
        protected final int markSet;
        protected final int markSetDir;
        protected final String sMask;
        protected final long bMarkCheck;
        protected final FileRemoteWalkerCallback callback;
        protected final boolean bRefresh;
        protected final int depth;
        protected final boolean debugOut;

        public FileWalkerThread(FileRemote fileRemote, boolean bl, int n, int n2, int n3, String string, long l, FileRemoteWalkerCallback fileRemoteWalkerCallback, boolean bl2) {
            super("FileRemoteRefresh");
            this.startDir = fileRemote;
            this.bRefresh = bl;
            this.markSet = n2;
            this.markSetDir = n3;
            this.depth = n;
            this.sMask = string;
            this.bMarkCheck = l;
            this.callback = fileRemoteWalkerCallback;
            this.debugOut = bl2;
        }
    }
}

