/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileLocalAccessor;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import org.vishia.event.EventWithDst;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.fileRemote.FileRemoteProgressEvData;
import org.vishia.fileRemote.FileRemoteWalkerCallback;
import org.vishia.util.Debugutil;
import org.vishia.util.SortedTreeWalkerCallback;

public class FileCallbackLocalMove
implements SortedTreeWalkerCallback<FileRemote, FileRemoteCmdEventData> {
    public static final String sVersion = "2025-12-27";
    private FileRemote dirDst;
    private final EventWithDst<FileRemoteProgressEvData, ?> evBack;
    private final FileRemoteProgressEvData progress;
    private final FileRemoteWalkerCallback callbackUser;

    public FileCallbackLocalMove(FileRemote fileRemote, FileRemoteWalkerCallback fileRemoteWalkerCallback, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        this.evBack = eventWithDst;
        this.progress = eventWithDst.data();
        this.callbackUser = fileRemoteWalkerCallback;
        this.dirDst = fileRemote;
    }

    @Override
    public void start(FileRemote fileRemote, FileRemoteCmdEventData fileRemoteCmdEventData) {
    }

    @Override
    public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote, Object object, Object object2) {
        String string = fileRemote.getName();
        this.dirDst = FileRemote.getDir(this.dirDst.getPathChars() + "/" + string);
        this.dirDst.mkdir();
        if (this.progress != null) {
            this.progress.currDir = fileRemote;
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, Object object, Object object2) {
        this.dirDst = this.dirDst.getParentFile();
        return SortedTreeWalkerCallback.Result.cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
        FileRemote fileRemote2 = this.dirDst.child(fileRemote.getName());
        Path path = fileRemote.path();
        Path path2 = fileRemote2.path();
        try {
            FileSystemProvider fileSystemProvider = path.getFileSystem().provider();
            FileSystemProvider fileSystemProvider2 = path2.getParent().getFileSystem().provider();
            if (this.progress != null) {
                this.progress.nrofBytesFile = fileRemote.length();
            }
            if (fileSystemProvider == fileSystemProvider2) {
                Files.move(path, path2, new CopyOption[0]);
                if (this.progress != null) {
                    this.progress.nrofBytesFileCopied = this.progress.nrofBytesFile;
                }
            } else {
                Debugutil.stopp();
            }
            fileRemote2.internalAccess().setLengthAndDate(fileRemote.length(), fileRemote.lastModified(), -1L, -1L);
            if (this.callbackUser != null) {
                this.callbackUser.offerLeafNode(fileRemote, object);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public boolean shouldAborted() {
        return false;
    }

    @Override
    public void finished(FileRemote fileRemote) {
    }
}

