/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileLocalAccessor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.spi.FileSystemProvider;
import org.vishia.event.EventWithDst;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.fileRemote.FileRemoteProgressEvData;
import org.vishia.fileRemote.FileRemoteWalkerCallback;
import org.vishia.util.SortedTreeWalkerCallback;

public class FileCallbackLocalCopy
extends FileRemoteWalkerCallback {
    public static final String sVersion = "2024-02-17";
    byte[] buffer = new byte[16384];

    public FileCallbackLocalCopy(FileRemote fileRemote, FileRemote fileRemote2, FileRemoteWalkerCallback fileRemoteWalkerCallback, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        super(fileRemote, fileRemote2, fileRemoteWalkerCallback, eventWithDst);
    }

    @Override
    public void start(FileRemote fileRemote, FileRemoteCmdEventData fileRemoteCmdEventData) {
    }

    @Override
    public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote, Object object, Object object2) {
        super.prepareDirs(fileRemote, true);
        this.dir2Curr.mkdir();
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, Object object, Object object2) {
        super.restoreDirs();
        return SortedTreeWalkerCallback.Result.cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
        FileRemote fileRemote2 = super.getFile2(fileRemote, true);
        Path path = fileRemote.path();
        Path path2 = fileRemote2.path();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            FileSystemProvider fileSystemProvider = path.getFileSystem().provider();
            FileSystemProvider fileSystemProvider2 = path2.getParent().getFileSystem().provider();
            if (this.progress != null) {
                this.progress.nrofBytesFile = fileRemote.length();
            }
            if (fileSystemProvider == fileSystemProvider2) {
                Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                if (this.progress != null) {
                    this.progress.nrofBytesFileCopied = this.progress.nrofBytesFile;
                }
            } else {
                if (this.progress != null) {
                    this.progress.nrofBytesFileCopied = 0L;
                }
                inputStream = fileRemote.openInputStream(0L);
                outputStream = fileRemote2.openOutputStream(0L);
                if (inputStream != null && outputStream != null) {
                    int n;
                    int n2 = 0;
                    while ((n = inputStream.read(this.buffer)) > 0) {
                        outputStream.write(this.buffer, 0, n);
                        n2 += n;
                        if (this.progress == null) continue;
                        this.progress.nrofBytesFileCopied = n2;
                    }
                }
            }
            fileRemote2.internalAccess().setLengthAndDate(fileRemote.length(), fileRemote.lastModified(), -1L, -1L);
            if (this.callbackUser != null) {
                this.callbackUser.offerLeafNode(fileRemote, object);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public boolean shouldAborted() {
        return this.aborted;
    }

    @Override
    public void finished(FileRemote fileRemote) {
    }
}

