/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileLocalAccessor;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventSource;
import org.vishia.event.EventThread_ifc;
import org.vishia.event.EventTimerThread;
import org.vishia.event.EventTimerThread_ifc;
import org.vishia.event.EventWithDst;
import org.vishia.event.TimeOrder;
import org.vishia.fileLocalAccessor.FileCallbackLocalCmp;
import org.vishia.fileLocalAccessor.FileCallbackLocalCopy;
import org.vishia.fileLocalAccessor.FileCallbackLocalDelete;
import org.vishia.fileLocalAccessor.FileCallbackLocalMove;
import org.vishia.fileRemote.FileCluster;
import org.vishia.fileRemote.FileMark;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteAccessor;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.fileRemote.FileRemoteProgressEvData;
import org.vishia.fileRemote.FileRemoteTestCallback;
import org.vishia.fileRemote.FileRemoteWalker;
import org.vishia.fileRemote.FileRemoteWalkerCallback;
import org.vishia.util.Debugutil;
import org.vishia.util.ExcUtil;
import org.vishia.util.FileFunctions;
import org.vishia.util.FilepathFilterM;
import org.vishia.util.SortedTreeWalkerCallback;

public final class FileAccessorLocalJava7
extends FileRemoteAccessor {
    public static final String sVersion = "2024-02-12";
    private static final boolean useFileChildren = false;
    private static FileRemoteAccessor instance;
    protected final Class<? extends BasicFileAttributes> systemAttribtype = DosFileAttributes.class;
    EventSource evSrc = new EventSource("FileLocalAccessor"){

        @Override
        public void notifyDequeued() {
        }

        @Override
        public void notifyConsumed(int n) {
        }

        @Override
        public void notifyRelinquished(int n) {
        }

        @Override
        public void notifyShouldSentButInUse() {
            throw new RuntimeException("event usage error");
        }

        @Override
        public void notifyShouldOccupyButInUse() {
            throw new RuntimeException("event usage error");
        }
    };
    EventTimerThread singleThreadForCommission;
    final WalkerThread[] walkerThread = new WalkerThread[3];
    EventConsumer executerCommission = new EventConsumer(){

        @Override
        public int processEvent(EventObject eventObject) {
            if (eventObject instanceof EventWithDst) {
                return FileAccessorLocalJava7.this.execCommission((EventWithDst)eventObject);
            }
            return 0;
        }

        public String toString() {
            return "FileRemoteAccessorLocal - executerCommision";
        }

        @Override
        public EventThread_ifc evThread() {
            return null;
        }
    };
    private FileRemote workingDir;
    public static FileRemote.FileRemoteAccessorSelector selectLocalFileAlways;

    private FileAccessorLocalJava7() {
        this.singleThreadForCommission = new EventTimerThread("FileAccessor-local");
        this.singleThreadForCommission.start();
        for (int i = 0; i < this.walkerThread.length; ++i) {
            this.walkerThread[i] = new WalkerThread();
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public void activate() {
    }

    public static FileRemoteAccessor getInstance() {
        if (instance == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            try {
                classLoader.loadClass("java.nio.file.Files");
                instance = new FileAccessorLocalJava7();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return instance;
    }

    @Override
    public CharSequence completeFilePath(CharSequence charSequence) {
        return FileFunctions.absolutePath(charSequence.toString(), null);
    }

    private File getLocalFile(FileRemote fileRemote) {
        if (fileRemote.oFile() == null) {
            String string = fileRemote.getPath();
            fileRemote.setFileObject(new File(string));
        }
        return (File)fileRemote.oFile();
    }

    protected static void setAttributes(FileRemote fileRemote, Path path, BasicFileAttributes basicFileAttributes) {
        Path path2 = path;
        fileRemote.internalAccess().setPath(path2);
        FileTime fileTime = basicFileAttributes.lastModifiedTime();
        long l = fileTime.toMillis();
        long l2 = basicFileAttributes.creationTime().toMillis();
        long l3 = basicFileAttributes.lastAccessTime().toMillis();
        long l4 = basicFileAttributes.size();
        int n = -2147483647;
        if (basicFileAttributes.isDirectory()) {
            n |= 0x10;
        }
        String string = fileRemote.getAbsolutePath();
        try {
            boolean bl;
            Path path3 = path2.toRealPath(new LinkOption[0]);
            boolean bl2 = bl = path3.compareTo(path2) != 0;
            if (bl) {
                fileRemote.setSymbolicLinkedPath(path3.toAbsolutePath().toString());
            } else {
                fileRemote.setCanonicalAbsPath(fileRemote.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            System.err.println("FileAccessorLocalJava7 - Problem on toRealPath; " + fileRemote.getAbsolutePath());
        }
        int n2 = -2147483631;
        if (basicFileAttributes instanceof DosFileAttributes) {
            DosFileAttributes dosFileAttributes = (DosFileAttributes)basicFileAttributes;
            n2 |= 0xE;
            if (dosFileAttributes.isHidden()) {
                n |= 8;
            }
            if (!dosFileAttributes.isReadOnly()) {
                n |= 4;
            }
            if (basicFileAttributes.isRegularFile()) {
                n |= 2;
            }
        }
        fileRemote.internalAccess().setFlagBits(n2, n);
        fileRemote.internalAccess().setLengthAndDate(l4, l, l2, l3);
    }

    @Override
    public void refreshFileProperties(FileRemote fileRemote, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        RunRefresh runRefresh = new RunRefresh(fileRemote, eventWithDst);
        if (eventWithDst == null) {
            runRefresh.run();
        } else {
            Thread thread = new Thread(runRefresh);
            thread.start();
        }
    }

    @Override
    public List<File> getChildren(FileRemote fileRemote, FileFilter fileFilter) {
        File file = (File)fileRemote.oFile();
        File[] fileArray = file.listFiles(fileFilter);
        LinkedList<File> linkedList = new LinkedList<File>();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                linkedList.add(file2);
            }
        }
        return linkedList;
    }

    @Override
    public boolean setLastModified(FileRemote fileRemote, long l) {
        File file = (File)fileRemote.oFile();
        if (file != null) {
            return file.setLastModified(l);
        }
        return false;
    }

    @Override
    public ReadableByteChannel openRead(FileRemote fileRemote, long l) {
        try {
            FileInputStream fileInputStream = new FileInputStream(fileRemote);
            return fileInputStream.getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public InputStream openInputStream(FileRemote fileRemote, long l) {
        try {
            FileInputStream fileInputStream = new FileInputStream(fileRemote);
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public OutputStream openOutputStream(FileRemote fileRemote, long l) {
        try {
            FileFunctions.mkDirPath(fileRemote);
            FileOutputStream fileOutputStream = new FileOutputStream(fileRemote);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public WritableByteChannel openWrite(FileRemote fileRemote, long l) {
        try {
            FileFunctions.mkDirPath(fileRemote);
            FileOutputStream fileOutputStream = new FileOutputStream(fileRemote);
            return fileOutputStream.getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public boolean createNewFile(FileRemote fileRemote, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) throws IOException {
        File file;
        if (fileRemote.oFile() == null) {
            file = new File(fileRemote.getAbsolutePath());
            fileRemote.setFileObject(file);
        } else {
            file = (File)fileRemote.oFile();
        }
        return file.createNewFile();
    }

    @Override
    public boolean mkdir(FileRemote fileRemote, boolean bl, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        String string;
        String string2 = fileRemote.getAbsolutePath();
        Path path = Paths.get(string2, new String[0]);
        try {
            if (bl) {
                Files.createDirectories(path, new FileAttribute[0]);
            } else {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            string = null;
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        if (eventWithDst != null) {
            FileRemoteProgressEvData fileRemoteProgressEvData = eventWithDst.data();
            fileRemoteProgressEvData.done(FileRemoteCmdEventData.Cmd.mkDir, string);
            eventWithDst.sendEvent("mkdir");
        }
        return string == null;
    }

    @Override
    public boolean delete(FileRemote fileRemote, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        File file = this.getLocalFile(fileRemote);
        boolean bl = file.exists() ? file.delete() : true;
        eventWithDst.relinquish();
        return bl;
    }

    @Override
    public void copyChecked(FileRemote fileRemote, String string, String string2, int n, FileRemoteWalkerCallback fileRemoteWalkerCallback, FileRemoteProgressEvData fileRemoteProgressEvData) {
    }

    protected static String copyFile(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        String string = null;
        try {
            Files.copy(fileRemoteCmdEventData.filesrc().path(), fileRemoteCmdEventData.filedst().path(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            string = ExcUtil.exceptionInfo("copyFile", exception, 0, 10).toString();
        }
        if (eventWithDst != null) {
            eventWithDst.data().done(FileRemoteCmdEventData.Cmd.copyFile, string);
            eventWithDst.sendEvent("copy");
        }
        return string;
    }

    protected static String moveFile(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        String string = null;
        try {
            Files.move(fileRemoteCmdEventData.filesrc().path(), fileRemoteCmdEventData.filedst().path(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            string = ExcUtil.exceptionInfo("copyFile", exception, 0, 10).toString();
        }
        if (eventWithDst != null) {
            eventWithDst.data().done(FileRemoteCmdEventData.Cmd.moveFile, string);
            eventWithDst.sendEvent("move");
        }
        return string;
    }

    @Override
    public void search(FileRemote fileRemote, byte[] byArray, FileRemoteWalkerCallback fileRemoteWalkerCallback, FileRemoteProgressEvData fileRemoteProgressEvData) {
    }

    @Override
    public boolean isLocalFileSystem() {
        return true;
    }

    @Override
    public CharSequence getStateInfo() {
        return "no stateInfo";
    }

    @Override
    public void abortAll() {
    }

    int execCommission(EventWithDst<FileRemoteCmdEventData, FileRemoteProgressEvData> eventWithDst) {
        int n = 0;
        FileRemoteCmdEventData fileRemoteCmdEventData = eventWithDst.data();
        FileRemoteCmdEventData.Cmd cmd = fileRemoteCmdEventData.cmd();
        EventWithDst<FileRemoteProgressEvData, FileRemoteCmdEventData> eventWithDst2 = eventWithDst.getOpponent();
        switch (cmd) {
            case check: 
            case abortAll: 
            case delChecked: 
            case moveChecked: 
            case chgProps: {
                this.execChgProps(fileRemoteCmdEventData, eventWithDst2);
                break;
            }
            case chgPropsRecurs: {
                this.execChgPropsRecurs(fileRemoteCmdEventData, eventWithDst2);
                break;
            }
            case countLength: {
                this.execCountLength(fileRemoteCmdEventData, eventWithDst2);
                break;
            }
            case delete: {
                this.execDel(fileRemoteCmdEventData, eventWithDst2);
                break;
            }
            case mkDir: {
                this.mkdir(fileRemoteCmdEventData.filesrc(), false, eventWithDst2);
                break;
            }
            case mkDirs: {
                this.mkdir(fileRemoteCmdEventData.filesrc(), true, eventWithDst2);
            }
        }
        return n;
    }

    protected String execCmd(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        String string = null;
        FileRemoteCmdEventData.Cmd cmd = fileRemoteCmdEventData.cmd();
        switch (cmd) {
            case check: {
                break;
            }
            case abortAll: {
                break;
            }
            case delChecked: {
                break;
            }
            case moveChecked: {
                break;
            }
            case chgProps: {
                this.execChgProps(fileRemoteCmdEventData, eventWithDst);
                break;
            }
            case chgPropsRecurs: {
                this.execChgPropsRecurs(fileRemoteCmdEventData, eventWithDst);
                break;
            }
            case countLength: {
                this.execCountLength(fileRemoteCmdEventData, eventWithDst);
                break;
            }
            case delete: {
                this.execDel(fileRemoteCmdEventData, eventWithDst);
                break;
            }
            case mkDir: {
                this.mkdir(fileRemoteCmdEventData.filesrc(), false, eventWithDst);
                break;
            }
            case mkDirs: {
                this.mkdir(fileRemoteCmdEventData.filesrc(), true, eventWithDst);
                break;
            }
            case copyFile: {
                FileAccessorLocalJava7.copyFile(fileRemoteCmdEventData, eventWithDst);
                break;
            }
            case moveFile: {
                FileAccessorLocalJava7.moveFile(fileRemoteCmdEventData, eventWithDst);
                break;
            }
            case walkRefresh: {
                assert (fileRemoteCmdEventData.callback() == null);
                this.walkFileTreeExecInThisThread(fileRemoteCmdEventData, true, eventWithDst, false);
                break;
            }
            case walkCopyDirTree: {
                assert (fileRemoteCmdEventData.callback() == null);
                fileRemoteCmdEventData.setCallback(new FileCallbackLocalCopy(fileRemoteCmdEventData.filesrc(), fileRemoteCmdEventData.filedst(), null, eventWithDst));
                this.walkFileTreeExecInThisThread(fileRemoteCmdEventData, false, eventWithDst, false);
                break;
            }
            case walkMoveDirTree: {
                assert (fileRemoteCmdEventData.callback() == null);
                fileRemoteCmdEventData.setCallback(new FileCallbackLocalMove(fileRemoteCmdEventData.filedst(), null, eventWithDst));
                this.walkFileTreeExecInThisThread(fileRemoteCmdEventData, false, eventWithDst, false);
                break;
            }
            case walkDelete: {
                assert (fileRemoteCmdEventData.callback() == null);
                fileRemoteCmdEventData.setCallback(new FileCallbackLocalDelete(eventWithDst));
                this.walkFileTreeExecInThisThread(fileRemoteCmdEventData, false, eventWithDst, false);
                break;
            }
            case walkCompare: {
                assert (fileRemoteCmdEventData.callback() == null);
                fileRemoteCmdEventData.setCallback(new FileCallbackLocalCmp(fileRemoteCmdEventData.filesrc(), fileRemoteCmdEventData.filedst(), fileRemoteCmdEventData.modeCmpOper, null, eventWithDst));
                this.walkFileTreeExecInThisThread(fileRemoteCmdEventData, true, eventWithDst, false);
                break;
            }
            case walkTest: {
                assert (fileRemoteCmdEventData.callback() == null);
                fileRemoteCmdEventData.setCallback(new FileRemoteTestCallback());
                this.walkFileTreeExecInThisThread(fileRemoteCmdEventData, true, eventWithDst, false);
                break;
            }
        }
        return string;
    }

    @Override
    public String cmd(boolean bl, FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (bl) {
            return this.execCmd(fileRemoteCmdEventData, eventWithDst);
        }
        String string = "no thread free";
        for (WalkerThread walkerThread : this.walkerThread) {
            if (!walkerThread.isFree()) continue;
            if (!walkerThread.setOrder(fileRemoteCmdEventData, eventWithDst)) {
                string = "cannot set order, evBack is null";
                break;
            }
            string = null;
            break;
        }
        return string;
    }

    private void execChgProps(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        FileRemote fileRemote;
        boolean bl;
        boolean bl2 = bl = fileRemoteCmdEventData != null;
        if (fileRemoteCmdEventData.newName() != null && !fileRemoteCmdEventData.newName().equals(fileRemoteCmdEventData.filesrc().getName())) {
            fileRemote = fileRemoteCmdEventData.filesrc().getParentFile().child(fileRemoteCmdEventData.newName());
            bl &= fileRemoteCmdEventData.filesrc().renameTo(fileRemote);
            fileRemote.refreshProperties(null);
        } else {
            fileRemote = fileRemoteCmdEventData.filesrc();
        }
        bl = this.chgFile(fileRemote, fileRemoteCmdEventData.maskFlags(), fileRemoteCmdEventData.newFlags(), bl);
        long l = fileRemoteCmdEventData.newDate();
        if (l != 0L) {
            bl &= fileRemote.setLastModified(l);
        }
        FileRemoteProgressEvData.ProgressCmd progressCmd = bl ? FileRemoteProgressEvData.ProgressCmd.done : FileRemoteProgressEvData.ProgressCmd.nok;
        if (!eventWithDst.isOccupied()) {
            eventWithDst.occupy(this.evSrc, true);
        }
        FileRemoteProgressEvData fileRemoteProgressEvData = eventWithDst.data();
        fileRemoteProgressEvData.currFile = fileRemote;
        fileRemoteProgressEvData.setAnswer(progressCmd);
        eventWithDst.sendEvent("execChgProps");
    }

    private void execChgPropsRecurs(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        FileRemote fileRemote;
        Object object;
        boolean bl;
        boolean bl2 = bl = fileRemoteCmdEventData != null;
        if (fileRemoteCmdEventData.newName() != null && !fileRemoteCmdEventData.newName().equals(fileRemoteCmdEventData.filesrc().getName())) {
            object = fileRemoteCmdEventData.filesrc().getParentFile().child(fileRemoteCmdEventData.newName());
            bl &= fileRemoteCmdEventData.filesrc().renameTo((File)object);
            fileRemote = object;
        } else {
            fileRemote = fileRemoteCmdEventData.filesrc();
        }
        bl &= this.chgPropsRecursive(fileRemote, fileRemoteCmdEventData.maskFlags(), fileRemoteCmdEventData.newFlags(), bl, 0);
        object = bl ? FileRemoteProgressEvData.ProgressCmd.done : FileRemoteProgressEvData.ProgressCmd.error;
        FileRemoteProgressEvData fileRemoteProgressEvData = eventWithDst.data();
        fileRemoteProgressEvData.currFile = fileRemote;
        fileRemoteProgressEvData.setAnswer((FileRemoteProgressEvData.ProgressCmd)((Object)object));
        eventWithDst.sendEvent("execChgPropsRecurs");
    }

    private boolean chgPropsRecursive(File file, int n, int n2, boolean bl, int n3) {
        if (n3 > 100) {
            throw new IllegalArgumentException("FileRemoteAccessorLocal.chgProsRecursive: too many recursions ");
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                bl = this.chgPropsRecursive(file2, n, n2, bl, n3 + 1);
            }
        } else {
            bl = this.chgFile(file, n, n2, bl);
        }
        return bl;
    }

    private boolean chgFile(File file, int n, int n2, boolean bl) {
        int n3 = n;
        for (int i = 1; i != 0; i <<= 1) {
            if ((n3 & i & n) == 0 || this.chgFile1(file, i, n2)) continue;
            bl = false;
        }
        return bl;
    }

    private boolean chgFile1(File file, int n, int n2) {
        boolean bl;
        boolean bl2 = (n2 & n) != 0;
        switch (n) {
            case 4: {
                bl = file.setWritable(bl2);
                break;
            }
            case 32768: {
                bl = file.setWritable(bl2, true);
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl && file instanceof FileRemote) {
            FileRemote fileRemote = (FileRemote)file;
            fileRemote.internalAccess().setOrClrFlagBit(n, bl2);
        }
        return bl;
    }

    private void execCountLength(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        FileRemoteProgressEvData.ProgressCmd progressCmd;
        long l = this.countLengthDir(fileRemoteCmdEventData.filesrc(), 0L, 0);
        FileRemoteProgressEvData fileRemoteProgressEvData = eventWithDst.data();
        if (l >= 0L) {
            progressCmd = FileRemoteProgressEvData.ProgressCmd.done;
            fileRemoteProgressEvData.nrofBytesAll = l;
        } else {
            progressCmd = FileRemoteProgressEvData.ProgressCmd.nok;
        }
        fileRemoteProgressEvData.currFile = fileRemoteCmdEventData.filesrc();
        fileRemoteProgressEvData.setAnswer(progressCmd);
        eventWithDst.sendEvent("execCountLength");
    }

    private long countLengthDir(File file, long l, int n) {
        if (n > 100) {
            throw new IllegalArgumentException("FileRemoteAccessorLocal.chgProsRecursive: too many recursions ");
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                l = this.countLengthDir(file2, l, n + 1);
            }
        } else {
            l += file.length();
        }
        return l;
    }

    void execDel(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        Path path = fileRemoteCmdEventData.filesrc().path();
        String string = null;
        try {
            Files.delete(path);
            fileRemoteCmdEventData.filesrc().internalAccess().setDeleted();
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        if (eventWithDst != null) {
            FileRemoteProgressEvData fileRemoteProgressEvData = eventWithDst.data();
            fileRemoteProgressEvData.currFile = fileRemoteCmdEventData.filesrc();
            fileRemoteProgressEvData.done(FileRemoteCmdEventData.Cmd.noCmd, string);
            eventWithDst.sendEvent(this);
        }
    }

    @Override
    public void close() {
        if (this.singleThreadForCommission != null) {
            this.singleThreadForCommission.close();
        }
        for (WalkerThread walkerThread : this.walkerThread) {
            if (walkerThread == null) continue;
            walkerThread.bRun = false;
        }
    }

    protected void walkFileTreeExecInThisThread(FileRemoteCmdEventData fileRemoteCmdEventData, boolean bl, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst, boolean bl2) {
        int n = 4;
        String string = null;
        try {
            Object object;
            if (fileRemoteCmdEventData.callback() != null) {
                fileRemoteCmdEventData.callback().start(fileRemoteCmdEventData.filesrc(), fileRemoteCmdEventData);
            }
            if (bl) {
                fileRemoteCmdEventData.filesrc().internalAccess().pendingChildren();
            }
            int n2 = fileRemoteCmdEventData.depthWalk() == 0 ? Integer.MAX_VALUE : (fileRemoteCmdEventData.depthWalk() < 0 ? -fileRemoteCmdEventData.depthWalk() : fileRemoteCmdEventData.depthWalk());
            if (eventWithDst != null) {
                object = eventWithDst.data();
                ((FileRemoteProgressEvData)object).clean();
                ((FileRemoteProgressEvData)object).answerToCmd = fileRemoteCmdEventData.cmd();
            }
            object = new WalkFileTreeVisitor(fileRemoteCmdEventData.filesrc().itsCluster, bl, fileRemoteCmdEventData, eventWithDst, bl2);
            TreeSet<FileVisitOption> treeSet = new TreeSet<FileVisitOption>();
            treeSet.add(FileVisitOption.FOLLOW_LINKS);
            Files.walkFileTree(fileRemoteCmdEventData.filesrc().path(), treeSet, n2, (FileVisitor<? super Path>)object);
            if (((WalkFileTreeVisitor)object).timeOrderProgress != null) {
                ((WalkFileTreeVisitor)object).timeOrderProgress.deactivate();
            }
        }
        catch (IOException iOException) {
            string = ExcUtil.exceptionInfo("FileAccessorLocalJava7.walkFileTree - unexpected Exception; ", iOException, 0, 20).toString();
            n = 8;
        }
        if (fileRemoteCmdEventData.callback() != null) {
            fileRemoteCmdEventData.callback().finished(fileRemoteCmdEventData.filesrc());
        }
        if (eventWithDst != null) {
            FileRemoteProgressEvData fileRemoteProgressEvData = eventWithDst.data();
            fileRemoteProgressEvData.done(fileRemoteCmdEventData.cmd(), string);
            eventWithDst.sendEvent("walkFileTreeExecInThisThread-done");
        }
    }

    @Override
    public EventThread_ifc evThread() {
        return null;
    }

    @Override
    public int processEvent(EventObject eventObject) {
        return 0;
    }

    static {
        selectLocalFileAlways = new FileRemote.FileRemoteAccessorSelector(){

            @Override
            public FileRemoteAccessor selectFileRemoteAccessor(CharSequence charSequence) {
                return FileAccessorLocalJava7.getInstance();
            }
        };
    }

    class WalkerThread
    implements Runnable {
        Thread thread;
        boolean bRun = false;
        EventWithDst<FileRemoteProgressEvData, ?> evBack;
        FileRemoteCmdEventData co;

        WalkerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, "walkerThread");
                this.bRun = true;
                this.thread.start();
            } else {
                WalkerThread walkerThread = this;
                synchronized (walkerThread) {
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.bRun) {
                if (this.evBack != null) {
                    if (this.co != null) {
                        FileAccessorLocalJava7.this.execCmd(this.co, this.evBack);
                    }
                    this.evBack = null;
                    this.co = null;
                    continue;
                }
                WalkerThread walkerThread = this;
                synchronized (walkerThread) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }

        synchronized boolean setOrder(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
            if (this.evBack != null) {
                return false;
            }
            this.co = fileRemoteCmdEventData;
            this.evBack = eventWithDst;
            this.start();
            return true;
        }

        boolean isFree() {
            return this.evBack == null && this.co == null;
        }
    }

    protected class WalkFileTreeVisitor
    implements FileVisitor<Path> {
        public boolean debugOut;
        final FileCluster fileCluster;
        final boolean bRefresh;
        final FileRemoteCmdEventData co;
        final SortedTreeWalkerCallback<FileRemote, FileRemoteCmdEventData> callback;
        private FileRemoteWalker.WalkInfo walkInfo;
        final EventWithDst<FileRemoteProgressEvData, ?> evBack;
        final FileRemoteProgressEvData progress;
        final TimeOrder timeOrderProgress;
        final FilepathFilterM fileFilter;
        long startTime;
        long lastTimeProgress;

        public WalkFileTreeVisitor(FileCluster fileCluster, boolean bl, FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst, boolean bl2) {
            this.debugOut = bl2;
            this.fileCluster = fileCluster;
            this.bRefresh = bl;
            this.co = fileRemoteCmdEventData;
            this.fileFilter = fileRemoteCmdEventData.selectFilter() == null ? null : FilepathFilterM.createWildcardFilter(fileRemoteCmdEventData.selectFilter());
            this.callback = fileRemoteCmdEventData.callback();
            this.evBack = eventWithDst;
            this.progress = eventWithDst == null ? null : eventWithDst.data();
            this.walkInfo = new FileRemoteWalker.WalkInfo(null, null, this.fileFilter);
            this.walkInfo.levelProcessMarked = 0;
            this.startTime = System.currentTimeMillis();
            if (fileRemoteCmdEventData.cycleProgress() > 0 && eventWithDst != null) {
                EventThread_ifc eventThread_ifc = this.evBack.getDstThread();
                assert (eventThread_ifc instanceof EventTimerThread_ifc);
                this.timeOrderProgress = new TimeOrder("progress", (EventTimerThread_ifc)eventThread_ifc, this.evBack);
            } else {
                this.timeOrderProgress = null;
            }
            this.reset();
        }

        private FileVisitResult translateResult(SortedTreeWalkerCallback.Result result) {
            FileVisitResult fileVisitResult;
            switch (result) {
                case cont: {
                    fileVisitResult = FileVisitResult.CONTINUE;
                    break;
                }
                case skipSiblings: {
                    fileVisitResult = FileVisitResult.SKIP_SIBLINGS;
                    break;
                }
                case skipSubtree: {
                    fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                    break;
                }
                case terminate: {
                    fileVisitResult = FileVisitResult.TERMINATE;
                    break;
                }
                default: {
                    fileVisitResult = FileVisitResult.TERMINATE;
                }
            }
            return fileVisitResult;
        }

        private void reset() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            FileRemote fileRemote;
            Object object;
            SortedTreeWalkerCallback.Result result;
            FilepathFilterM filepathFilterM;
            boolean bl;
            boolean bl2;
            Path path2 = path.getFileName();
            String string = path2 == null ? "/" : path2.toString();
            int n = this.co.selectMask();
            boolean bl3 = bl2 = (n & Integer.MIN_VALUE) != 0;
            if (bl2) {
                Debugutil.stop();
            }
            Path path3 = !path.isAbsolute() ? path.toAbsolutePath() : path;
            Path path4 = path3.toRealPath(new LinkOption[0]);
            boolean bl4 = path4.compareTo(path3) != 0;
            boolean bl5 = Files.isSymbolicLink(path);
            if (bl5) {
                Debugutil.stop();
            }
            if (this.walkInfo.parent == null) {
                bl = true;
                filepathFilterM = this.walkInfo.fileFilter;
            } else if ((n & Integer.MIN_VALUE) != 0 && bl4) {
                bl = false;
                filepathFilterM = null;
            } else if (this.fileFilter == null) {
                bl = true;
                result = SortedTreeWalkerCallback.Result.cont;
                filepathFilterM = null;
            } else {
                filepathFilterM = this.walkInfo.fileFilter.check(string, true);
                bl = filepathFilterM != null;
            }
            int n2 = this.co.markSet();
            int n3 = this.co.selectMask();
            if (!(bl || n3 != 0 && (n3 & 0x40000000) != 0 || n2 != 0 || this.bRefresh)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (this.walkInfo.dir == null) {
                object = path.toString();
                fileRemote = FileRemote.getDir((CharSequence)object);
            } else {
                fileRemote = this.walkInfo.dir.subdir(string);
            }
            FileAccessorLocalJava7.setAttributes(fileRemote, path, basicFileAttributes);
            if (this.bRefresh && this.walkInfo != null) {
                fileRemote.internalAccess().clrFlagBit(0x40000000);
                fileRemote.internalAccess().pendingChildren();
            }
            if (this.walkInfo.parent != null && (n3 & 0x3FFFFFFF) != 0) {
                boolean bl6;
                boolean bl7 = bl6 = (fileRemote.getMark() & 0x3FFFFFFF & n3) != 0;
                bl = (n3 & 0x40000000) != 0 ? (bl |= bl6) : (bl &= bl6);
            }
            if (!bl) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
            if (this.walkInfo.parent != null && n2 != 0) {
                if ((n2 & Integer.MIN_VALUE) != 0) {
                    fileRemote.resetMarked(n2);
                } else {
                    boolean bl8;
                    boolean bl9 = bl8 = (fileRemote.getMark() & 0x1000000 & n3) != 0;
                    if (bl8) {
                        fileRemote.setMarked(this.co.markSet());
                    }
                }
            }
            if (this.progress != null) {
                if (this.timeOrderProgress != null) {
                    this.timeOrderProgress.hold();
                }
                this.progress.progressCmd = FileRemoteProgressEvData.ProgressCmd.refreshDirPre;
                ++this.progress.nrDirProcessed;
                this.progress.currDir = fileRemote;
                if (this.co.cycleProgress() == 0) {
                    this.evBack.sendEvent(this);
                } else {
                    long l = System.currentTimeMillis() + (long)this.co.cycleProgress();
                    this.timeOrderProgress.activateAt(l, l);
                }
            }
            object = new FileRemoteWalker.WalkInfo(fileRemote, this.walkInfo, filepathFilterM);
            result = this.callback != null ? this.callback.offerParentNode(fileRemote, path, object) : SortedTreeWalkerCallback.Result.cont;
            if (result == SortedTreeWalkerCallback.Result.cont) {
                this.walkInfo = object;
                if (this.debugOut) {
                    System.out.println("FileRemoteAccessorLocalJava7.walker - pre dir; " + this.walkInfo.dir.getAbsolutePath());
                }
            } else if (this.debugOut) {
                System.out.println("FileRemoteAccessorLocalJava7.walker - pre dir don't entry; " + this.walkInfo.dir.getAbsolutePath());
            }
            return this.translateResult(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            Object object;
            if (this.bRefresh) {
                this.walkInfo.dir.timeChildren = System.currentTimeMillis();
                this.walkInfo.dir.internalAccess().setChildrenRefreshed();
                this.walkInfo.dir.internalAccess().setLengthAndDate(this.walkInfo.nrBytesInDir, -1L, -1L, System.currentTimeMillis());
            }
            if (this.walkInfo.nrofFilesSelected > 0 && this.co.markSetDir() != 0 && (this.co.markSetDir() & Integer.MIN_VALUE) == 0) {
                object = this.walkInfo.dir.getCreateMark();
                ((FileMark)object).nrofBytesSelected = this.walkInfo.nrBytesInDirSelected;
                ((FileMark)object).nrofFilesSelected = this.walkInfo.nrofFilesSelected;
                ((FileMark)object).setMarked(this.co.markSetDir(), null);
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            object = this.walkInfo.parent != null && this.walkInfo.parent.parent != null && this.callback != null ? this.callback.finishedParentNode(this.walkInfo.dir, path, this.walkInfo) : SortedTreeWalkerCallback.Result.cont;
            if (this.progress != null) {
                if (this.timeOrderProgress != null) {
                    this.timeOrderProgress.hold();
                }
                this.progress.progressCmd = FileRemoteProgressEvData.ProgressCmd.refreshDirPost;
                this.progress.currFile = this.walkInfo.dir;
                if (this.co.cycleProgress() == 0) {
                    this.evBack.sendEvent(this);
                } else {
                    long l = System.currentTimeMillis() + (long)this.co.cycleProgress();
                    this.timeOrderProgress.activateAt(l, l);
                }
            }
            if (this.debugOut) {
                System.out.println("FileRemoteAccessorLocalJava7.walker - post dir; " + this.walkInfo.dir.getAbsolutePath());
            }
            if (this.walkInfo.parent != null) {
                this.walkInfo.parent.nrBytesInDirSelected += this.walkInfo.nrBytesInDirSelected;
                this.walkInfo.parent.nrofFilesSelected += this.walkInfo.nrofFilesSelected;
            }
            this.walkInfo = this.walkInfo.parent;
            return this.translateResult((SortedTreeWalkerCallback.Result)((Object)object));
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            try {
                FileVisitResult fileVisitResult;
                FileRemote fileRemote;
                boolean bl;
                String string = path.getFileName().toString();
                if (string.startsWith("constant-values.html")) {
                    Debugutil.stop();
                }
                boolean bl2 = Files.isDirectory(path, new LinkOption[0]);
                if (this.progress != null) {
                    if (bl2) {
                        ++this.progress.nrDirVisited;
                    } else {
                        ++this.progress.nrFilesVisited;
                    }
                }
                boolean bl3 = bl = this.fileFilter == null || this.walkInfo.fileFilter.check(string, bl2) != null;
                if (!(bl || this.co.markSet() != 0 || this.co.selectMask() != 0 && (this.co.selectMask() & 0x40000000) != 0)) {
                    return FileVisitResult.CONTINUE;
                }
                if (this.walkInfo.dir != null) {
                    fileRemote = bl2 ? this.walkInfo.dir.subdir(string) : this.walkInfo.dir.child(string);
                } else {
                    String string2 = path.getParent().toString();
                    this.walkInfo.dir = FileRemote.getFile(string2, null);
                    fileRemote = FileRemote.getFile(string2, string);
                }
                int n = this.co.selectMask();
                int n2 = fileRemote.getMark();
                if ((n2 & 0x4000000) != 0 && (n & 0x8000000) != 0) {
                    n2 &= 0xFF3FFFFF;
                }
                if ((n & 0x400000) != 0) {
                    Debugutil.stop();
                }
                if ((n & 0x3FFFFFFF) != 0) {
                    boolean bl4;
                    boolean bl5 = bl4 = (n2 & 0x3FFFFFFF & n) != 0;
                    bl = (this.co.selectMask() & 0x40000000) != 0 ? (bl |= bl4) : (bl &= bl4);
                }
                if (!bl) {
                    if (this.co.markSet() != 0 && (this.co.markSet() & 0x40000000) != 0) {
                        fileRemote.resetMarked(this.co.markSet());
                    }
                    fileVisitResult = FileVisitResult.CONTINUE;
                } else {
                    SortedTreeWalkerCallback.Result result;
                    if (this.co.markSet() != 0) {
                        if ((this.co.markSet() & Integer.MIN_VALUE) != 0) {
                            fileRemote.resetMarked(this.co.markSet());
                        } else {
                            fileRemote.setMarked(this.co.markSet());
                        }
                        if (this.progress != null) {
                            ++this.progress.nrofFilesMarked;
                        }
                    }
                    FileAccessorLocalJava7.setAttributes(fileRemote, path, basicFileAttributes);
                    long l = basicFileAttributes.size();
                    assert (this.walkInfo.dir == fileRemote.getParentFile());
                    this.walkInfo.nrBytesInDir += l;
                    this.walkInfo.nrBytesInDirSelected += l;
                    ++this.walkInfo.nrofFilesSelected;
                    if (this.progress != null) {
                        if (this.timeOrderProgress != null) {
                            this.timeOrderProgress.hold();
                        }
                        this.progress.progressCmd = FileRemoteProgressEvData.ProgressCmd.refreshFile;
                        ++this.progress.nrofFilesSelected;
                        this.progress.nrofBytesAll += l;
                        this.progress.currFile = fileRemote;
                        if (this.co.cycleProgress() == 0) {
                            this.evBack.sendEvent(this);
                        } else {
                            long l2 = System.currentTimeMillis() + (long)this.co.cycleProgress();
                            this.timeOrderProgress.activateAt(l2, l2);
                        }
                    }
                    if (this.debugOut) {
                        System.out.println("FileRemoteAccessorLocalJava7.walker - file; " + string);
                    }
                    if (this.callback != null && this.callback.shouldAborted()) {
                        result = SortedTreeWalkerCallback.Result.terminate;
                    } else {
                        if (this.bRefresh) {
                            fileRemote.internalAccess().clrFlagBit(0x40000000);
                            fileRemote.internalAccess().setRefreshed();
                        }
                        if (this.callback != null) {
                            if (bl2) {
                                Debugutil.stop();
                            }
                            result = this.callback.offerLeafNode(fileRemote, path);
                        } else {
                            result = SortedTreeWalkerCallback.Result.cont;
                        }
                    }
                    fileVisitResult = this.translateResult(result);
                }
                return fileVisitResult;
            }
            catch (Exception exception) {
                return FileVisitResult.SKIP_SUBTREE;
            }
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
            if (this.progress != null) {
                if (this.timeOrderProgress != null) {
                    this.timeOrderProgress.hold();
                }
                this.progress.progressCmd = FileRemoteProgressEvData.ProgressCmd.refreshFileFaulty;
                if (this.co.cycleProgress() == 0) {
                    this.evBack.sendEvent(this);
                } else {
                    long l = System.currentTimeMillis() + (long)this.co.cycleProgress();
                    this.timeOrderProgress.activateAt(l, l);
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private class RunRefresh
    implements Runnable {
        final FileRemote fileRemote;
        final EventWithDst<FileRemoteProgressEvData, ?> evBack;

        RunRefresh(FileRemote fileRemote, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
            this.fileRemote = fileRemote;
            this.evBack = eventWithDst;
        }

        @Override
        public void run() {
            Object object;
            String string = this.fileRemote.getAbsolutePath();
            String string2 = this.fileRemote.getName();
            Path path = Paths.get(string, new String[0]);
            boolean bl = true;
            try {
                object = path.toRealPath(LinkOption.NOFOLLOW_LINKS);
                boolean bl2 = Files.exists((Path)object, new LinkOption[0]);
                BasicFileAttributes basicFileAttributes = Files.readAttributes((Path)object, FileAccessorLocalJava7.this.systemAttribtype, new LinkOption[0]);
                FileAccessorLocalJava7.setAttributes(this.fileRemote, (Path)object, basicFileAttributes);
            }
            catch (IOException iOException) {
                this.fileRemote.internalAccess().clrFlagBit(1);
            }
            this.fileRemote.timeRefresh = System.currentTimeMillis();
            if (this.evBack != null) {
                object = this.evBack.data();
                ((FileRemoteProgressEvData)object).setAnswer(FileRemoteProgressEvData.ProgressCmd.done);
                this.evBack.occupy(FileAccessorLocalJava7.this.evSrc, true);
                this.evBack.sendEvent("RunFrefresh");
            }
        }
    }
}

