/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.cmd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.vishia.cmd.JZtxtcmdEngine;
import org.vishia.cmd.JZtxtcmdExecuter;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.CalculatorExpr;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.util.FilePath;
import org.vishia.util.FileSet;
import org.vishia.util.GetTypeToUse;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.SetLineColumn_ifc;
import org.vishia.util.StringFunctions_B;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.util.StringPartScan;
import org.vishia.xmlSimple.XmlNode;
import org.vishia.zbnf.ZbnfJavaOutput;
import org.vishia.zbnf.ZbnfParseResultItem;
import org.vishia.zbnf.ZbnfParser;

public class JZtxtcmdScript
extends CompiledScript {
    public static final String version = "2022-02-22";
    final LogMessage console;
    final File fileScript;
    final JZtxtcmdEngine scriptEngine;
    final Map<String, Subroutine> subroutinesAll = new TreeMap<String, Subroutine>();
    final Map<String, JZcmdClass> classesAll = new IndexMultiTable<String, JZcmdClass>(IndexMultiTable.providerString);
    Subroutine mainRoutine;
    protected JZcmditem checkJZcmdFile;
    JZcmditem checkJZcmdXmlFile;
    XmlNode xmlSrc;
    JZcmdClass scriptClass;
    JZscriptSettings jzScriptSettings = new JZscriptSettings();

    public JZtxtcmdScript(LogMessage logMessage, File file, JZtxtcmdEngine jZtxtcmdEngine) {
        this.console = logMessage;
        this.fileScript = file;
        this.scriptEngine = jZtxtcmdEngine;
    }

    public static JZtxtcmdScript createScriptFromFile(File file, LogMessage logMessage, File file2) throws ScriptException {
        StringPartFromFileLines stringPartFromFileLines;
        int n = (int)file.length();
        try {
            stringPartFromFileLines = new StringPartFromFileLines(file, n, "encoding", null);
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            throw new ScriptException("JZcmd - Error script file not found; " + file.getAbsolutePath() + "; " + string);
        }
        JZtxtcmdScript jZtxtcmdScript = JZtxtcmdScript.createScriptFromString(stringPartFromFileLines, logMessage, file2, file);
        ((StringPartScan)stringPartFromFileLines).close();
        return jZtxtcmdScript;
    }

    public static JZtxtcmdScript createScriptFromString(StringPartScan stringPartScan, LogMessage logMessage, File file, File file2) throws ScriptException {
        JZtxtcmdScript jZtxtcmdScript = new JZtxtcmdScript(logMessage, file2, null);
        File file3 = file2 == null ? null : FileFunctions.getDir(file2);
        ZbnfJZcmdScript zbnfJZcmdScript = new ZbnfJZcmdScript(jZtxtcmdScript);
        try {
            jZtxtcmdScript.setScriptFromString(stringPartScan, zbnfJZcmdScript, file3, file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ScriptException(fileNotFoundException);
        }
        return jZtxtcmdScript;
    }

    private void setScriptFromString(StringPartScan stringPartScan, ZbnfJZcmdScript zbnfJZcmdScript, File file, File file2) throws ScriptException, FileNotFoundException {
        Object object;
        ZbnfParser zbnfParser = new ZbnfParser(this.console);
        try {
            zbnfParser.setSyntax(" $comment=(?...?).\n $endlineComment=\\#\\#.  ##The ## is the start chars for an endline-comment or commented line in the generator script.\n $keywords= new | cmd | cmd_check | start \n   | debug | java \n   | stdout | stdin | stderr \n   | subtext | sub | main | call | cd | CD | REM | Rem | rem \n   | Pipe | StringBuffer | Stringjar | String | List | Openfile | Fileset | Obj | Set | set | include | zbatch \n   | break | XXXreturn | exit | onerror | instanceof | for | while | do | if | elsif | else | not | NOT | and | AND | or | OR \n   | throw . \n \n JZtxtcmd::= \n [<*|==JZtxtcmd==?>==JZtxtcmd== ]\n [<*|==JZcmd==?>==JZcmd== ]\n [{ ! checkjzTc = <textValue?checkJZcmdFile> ; \n  | ! checkJZcmd = <textValue?checkJZcmdFile> ; \n  | ! checkXml = <textValue?checkXmlFile> ; \n }]\n [{ [REM|Rem|rem] <*\\n\\r?> ##Remark like in batch files\n  | include <include> ; \n  | currdir = <textDatapath?cd> ;\n }] \n { [//] ==endJZcmd==<*\\e?> \n | [REM|Rem|rem] <*\\n\\r?> ##Remark like in batch files\n | //JZtxtcmd       ##ignore //JZtxtcmd, it may be a comment for another language\n | //JZcmd      ##ignore //JZcmd, it may be a comment for another language\n | //<*\\n\\r?> ##line comment in C style\n | /*<*|*/?>*/ ##block commment in C style\n | <DefVariable?> ; \n | <statement?>\n | subtext  <subtext?subroutine> \n | sub <subroutine> \n | class <subClass> \n | main ( ) \\{ <statementBlock?mainRoutine> \\} \n } \\e.\n \n \n include::= [$<$?envVar>[/|\\\\]|%<?bJop>[<#?parentLevel>:]|][ <\"\"?path> | <*;\\ ?path>].\n \n \n subClass::= <$?name> \\{ \n { <DefVariable?> ; \n | subtext  <subtext?subroutine> \n | sub <subroutine> \n | class <subClass> \n } \\}. \n \n \n subroutine::= <$?name> [( [ use-locals<?useLocals> | { add-locals<?addLocals> | <DefVariable?formalArgument> ? , } |] ) [=] | = <?useLocals>] \\{ [<statementBlock>] \\}. \n \n subtext::= <$?name> [( [ use-locals<?useLocals> | { add-locals<?addLocals> | <DefVariable?formalArgument> ? , } |] ) [=] | = <?useLocals>]  \n [ \\<:\\><textExpr?textExpr?.indent=-3>\\<\\.\\> \n | \\<::\\><textExpr?textExpr?.indent=-4?.skipFirstnl=1>\\<\\.\\> \n ].\n \n \n statementBlock::= { [ <statement?> ] }.\n \n statement::=\n   \\{ [<statementBlock>] \\} \n | REM <*\\n\\r?> ##Remark like in batch files\n | ::{:}                ##Skip over :::\n | =={=}                ##Skip over :::\n | //JZtxtcmd       ##ignore //JZtxtcmd, it may be a comment for another language\n | //JZcmd      ##ignore //JZcmd, it may be a comment for another language\n | //<*|\\n|\\r|\\<+?>     ##line commment in C style but only till <+\n | /*<*|*/?>*/          ##block commment in C style\n | text = <objExpr?createTextOut> ;    ##set text output\n | currdir = <textDatapath?cd> ;   ##set current directory\n | [cd|CD] [<textValue?cd> | <*\\ ;?cd> ; ]  ##change current directory \n | mkdir <textValue?mkdir> ;                 ##create any directory if not exists \n | <DefVariable?> ; \n | for <forCtrl> \n | if <ifCtrl> \n | while <whileCtrl> \n | do <dowhileCtrl> \n | start <cmdLine?cmdStart> \n | shell <cmdLine?cmdShell> \n | zmake <zmake> \n | move <srcdst?move> ; \n | copy <srcdst?copy> ; \n | [rm|del] <oneArg?del> ; \n | break <?breakBlock> ; \n | return <?return> ; \n | exit <#?exitScript> ;\n | throw on errorlevel <#?throwonerror> \n | throw <textDatapath?throw> \n | onerror <onerror> \n | errortoOutput off <?errorToOutput=0> \n | errortoOutput <?errorToOutput=1> \n | if errorlevel <iferrorlevel> \n | debug [<textValue?debug>| <?debug>] ; \n | debugOp <textValue?debugOp> ; \n | <callSubroutine?call> \n | <threadBlock> \n | \\<+:create\\><textExpr?createTextOut>\\<\\.+\\> \n | \\<+:append\\><textExpr?appendTextOut>\\<\\.+\\> \n | \\<+ <textOut> \n | \\<::\\><textExpr?.indent=-4?.skipFirstnl=1>\\<\\.\\> [;] \n | \\<:\\><textExpr?.indent=-3>\\<\\.\\> [;] \n | <cmdLineWait?cmdWait> \n | <assignExpr> \n | ; \n .\n \n \n srcdst::= [{ -n<?newTimestamp>| -w<?overwr> | -r<?overwro>}] [ src=] <textValue?src> [ dst=] <textValue?dst> .\n oneArg::= <textValue?src> .\n \n \n DefVariable::=\n   String\\  <DefStringVar?textVariable> \n | Stringjar\\  <DefSpecVar?Stringjar> \n | Num\\  <DefNumVar> \n | Bool\\  <DefBoolVar> \n | Pipe\\  <DefSpecVar?Pipe> \n | List\\  <DefList?List> \n | Map\\  <DefMapVar> \n | Obj\\  <DefObjVar> \n | Class\\  <DefClassVar> \n | Classpath\\  <DefClasspath> \n | Openfile\\  <Openfile> \n | Fileset\\  <DefFileset> \n | Filepath\\ <DefFilepath> \n | Subtextvar\\ <subtext?DefSubtext> \n | Subroutinevar\\ <subroutine?DefSubtext> \n | Set\\  <DefStringVar?setEnvVar> \n | set\\  <DefStringVar?setEnvVar> \n | SET\\  <DefStringVar?setEnvVar> \n .\n \n DefNumVar::= [const <?const>] <definePath?defVariable>  [ = <numExpr>].\n \n DefBoolVar::= [const <?const>] <definePath?defVariable>  [ = <boolExpr>].\n \n DefList::= [const <?const>] <definePath?defVariable> [ @ <$?keyVariableName> ] \n[ = \\[ {<?element> \\{ <dataStruct?dataSet> \\} ? , } \\]  ##some { dataSet, ...} \n| = \\[ <dataStruct?>   \\]  ##some String or variable (const) definitions in the container.\n| = <objExpr?> [!;]\n| = \\[ { <objExpr?objElement> ? , } \\]\n|].\n \n DefSpecVar::= [const <?const>] <definePath?defVariable>  [ = <objExpr?>].\n \n DefObjVar::= [const <?const>] <definePath?defVariable> [ : <$\\.$?type>]  [ = <objExpr?>].\n \n DefClassVar::= [const] <definePath?defVariable>  = \n   [: <dataAccess?loader> : ]  ## a datapath to a ClassLoader instance, a Classpath variable. \n   <textValue?>.               ## The package path maybe contained in any expression\n \n DefClasspath::= [const] <definePath?defVariable>  = [ : <$?parentClasspath> : ] { <filesetAccess> ? , }.\n \n DefStringVar::= [const <?const>] <definePath?defVariable> [ = <textDatapath?>].\n \n DefMapVar::= [const <?const>] <definePath?defVariable> [ = \\{ <dataStruct> \\}  ].\n \n Openfile::= [const <?const>] <definePath?defVariable> [+= <?appendToFile> | = ] <textDatapath?> .\n \n \n definePath::= <$-?startVariable>[ [?\\. \\>] \\.{ <defineSubelement?datapathElement> ? [?\\. \\>] \\.}].\n \n defineSubelement::= <$-?ident> [( [{ <objExpr?argument> ? ,}])<?whatisit=(>].\n \n \n DefFileset::= <definePath?defVariable> [ =  ( \n [ commonpath = [<\"\"?commonPath>|<*;,)(\\ \\r\\n?commonPath>] , ] \n { [{ //JZcmd | //JZtxtcmd | //<*\\n\\r?>}] \n     [ <\"\"?filePath>             ##filePath in \"\"\n     | <*;,)(\\ \\r\\n?filePath>   ##filePath without \"\"\n     ]    [{ //JZcmd | //<*\\n\\r?>}] ? , } \n ) ] .\n \n DefFilepath::= <definePath?defVariable> [ = <textValue?> ]. \n \n \n \n XXXFilepath::=<\"\"?!prepFilePath>|<*;\\ \\r\\n,)?!prepFilePath>. \n \n prepFilePath::=<$NoWhiteSpaces><! *?>\n [ &$<$?@envVariable> [\\\\|/|]      ##path can start with a environment variable's content\n | &<$?@scriptVariable> [\\\\|/|]    ##path can start with a scriptvariable's content\n | [<!.?@drive>:]                  ## only 1 char with followed : is the drive letter\n   [ [/|\\\\]<?@absPath>]            ## starting with / maybe after d: is absolute path\n |]\n [ <*:?@pathbase>[?:=]:]           ## all until : is pathbase, but not till a :=\n [ <toLastChar:/\\\\?@path>[\\\\|/|]] ## all until last \\ or / is path\n [ <toLastChar:.?@name>              ## all until exclusive dot is the name\n   <*\\e?@ext>                       ## from dot to end is the extension\n | <*\\e?@name>                      ## No dot is found, all is the name.\n ] . \n \n \n text::=  <\"\"?text>                                    ## It is a constant text. \n | \\<:\\><textExpr?.indent=-3>\\<\\.\\>                 ## It is a text assembled in runtime. \n | \\<::\\><textExpr?.indent=-4?.skipFirstnl=1>\\<\\.\\> ## text assembled in runtime starting in next line. \n .\n \n \n \n textDatapath::=  <text?> | [& [?(] ] <dataAccess> .\n \n textValue::=  <text?> | & <dataAccess> | <*;,)(\\ \\r\\n\\>?text> .\n \n textValueTextExpr::=  <text?> | & <dataAccess> | <*:;,)(\\ \\r\\n\\>?text> .\n \n \n objExpr::= \n   Filepath : <textValue?Filepath> ## A textValue which builds a Filepath in the currdir \n | Fileset : <filesetAccess>  \n | \\{ <dataStruct> \\}              ## It is a Map of Variables. \n | <text?> \n | <numExpr>.                        ## special detection of a simple dataAccess.\n \n dataStruct::= { <DefVariable?> ; } | { <DefStringVar?textVariable> ? , }.\n \n \n \n \n dataAccess::= \n [ $<$?envVariable> \n | [<?startVariable> $<#?>| $<$?>]    ## $1 .. $999 are the arguments of JZcmd, $name for environment \n | [|java\\ ] new\\  <staticJavaAccess?newJavaClass> \n | [%|java\\ ] <staticJavaAccess?staticJavaMethod> \n | <dataPath?> \n ].\n \n \n ## Access to a Java class constructor or static method or field\n staticJavaAccess::=\n   [ & <dataAccess?Class_Var> : [<$\\.$?javapath>]       ## access via Class variable .element\n   | [: <dataAccess?Classpath_Var> : ] <$\\.$?javapath>  ## [Classpath] package.path.Class.element\n   ] [( <?operation> [ { <objExpr?argument> ? , } ])].   ## arguments\n \n dataPath::= \n [ File : <textValue?File>     ##creates a file object with given path\n | <startDatapath> \n ] [ [?\\. \\>] \\.{ <datapathElement> ? [?\\. \\>] \\.}].\n \n ## A datapath cannot start with an JZcmd keyword! \n startDatapath::= <?whatisit=@> \n [ & ( <dataPath> )  ##takes the result of <dataPath> as name of an element or method. \n | <$-?ident> \n ][\n   ( [{ <objExpr?argument> ? ,}]) <?whatisit=(>   ##a method\n | \\[ <#?index> \\] <?whatisit=\\[>   ##an indexed array access\n |].\n \n datapathElement::= \n [ & ( <dataPath> ) ##takes the result of <dataPath> as name of an element or method.\n | ##Field or method identifier, use regex for the second datapath element, it can be a JZcmd keyword too! \n   [<?ident> [@] [\\[\\]   ##[] instead name for length operation. \n   | <![\\\\w-]+?>]        ##name as regex or [] for length of array or size() of container\n   ]\n ][\n   ( [{ <objExpr?argument> ? ,}]) <?whatisit=(>   ##a method\n | \\[ <#?index> \\] <?whatisit=\\[>   ##an indexed array access\n |].\n \n \n \n \n condition::=<andExpr?> [{\\|\\| <?boolCheckOrOperation> <andExpr?boolOrOperation>}].\n \n andExpr::= <boolExpr?> [{ && <?boolCheckAndOperation> <boolExpr?boolAndOperation>}].\n \n boolExpr::= [<?boolNot> ! | not| NOT|]\n [ ( <condition?parenthesisExpr> ) \n | <numExpr?> [<cmpOperation>]\n ].\n \n cmpOperation::=[ \\?[<?cmpOperator>gt|ge|lt|le|eq|ne|instanceof] |  [<?cmpOperator> != | == | \\>= | \\> | \\<= | \\< ]] <numExpr?>.\n \n instanceof::=<objExpr> instanceof <staticJavaAccess>.\n \n conditionInText::=<andExprInText?> [{\\|\\| <?boolCheckOrOperation> <andExprInText?boolOrOperation>}].\n \n andExprInText::= <boolExprInText?> [{ && <?boolCheckAndOperation> <boolExprInText?boolAndOperation>}].\n \n boolExprInText::= [<?boolNot> ! | not|]\n [ ( <conditionInText?parenthesisExpr>) \n | <numExpr?> [<cmpOperationInText?cmpOperation>]\n ].\n \n cmpOperationInText::=[ \\?[<?cmpOperator>gt|ge|lt|le|eq|ne|instanceof] |  [<?cmpOperator> != | == ]] <numExpr?>.\n \n \n numExpr::=  bool ( <boolExpr?> ) \n | <multExpr?> [{ + <multExpr?addOperation> | - <multExpr?subOperation>}]\n .\n \n \n multExpr::= <value?> [{ * <value?multOperation> | / <value?divOperation> }].\n \n value::= 0x<#x?intValue> | <#-?intValue>[?\\.] | <#f?doubleValue> |    ##unary - associated to value.\n [{[<?unaryOperator> ! | ~ | - | +]}]     ##additional unary operators.\n [ 0x<#x?intValue> | <#?intValue>  ##ones of kind of value:\n | '<!.?charValue>' | <\"\"?textValue> \n | ( <numExpr?parenthesisExpr> ) \n | [& [?(] ] <dataAccess>   ## & is optional, don't confuse with &(variable) \n ].\n \n \n textExpr::=<$NoWhiteSpaces>\n { [?\\<\\.]                             ##abort on <. \n [ \\<&-<*\\>?>\\>                          ##<&- it is comment> \n | \\<:---\\><*|---\\>?>\\<---\\> ##<:---> comment <---> not confused with XML <--- will be produced as output --->\n | \\<:-<*\\>?>\\><textExpr?>\\<\\.-<*\\>?>\\> ##<:-comment> comment <.- > \n | \\#\\#<*\\r\\n?>   ##comment to eol in a text Expression\n | \\<:\\{  <statementBlock?>  <!\\\\s*>  \\}\\>  ##one or more statements inside a text expression, do not produce an output text. \n | \\<:indent:[<#?nIndent>][[?\\>]<!\\.?cIndent>]\\>\n | \\<:for:<forInText?forCtrl>\n | \\<:if: <ifInText?ifCtrl>\n | \\<:hasNext\\> <textExpr?hasNext> \\<\\.hasNext\\>\n | \\<:subtext : <callSubtext?call>\n | \\<:call : <callSubtext?call>\n | \\<:scriptdir<?scriptdir>\\>\n | \\<:debug-break\\> <?breakBlock>     ##ends the text, especially for test. \n | \\<:debug[:<textValue?debug>| <?debug>]\\>\n | \\<:debugOp:<textValue?debugOp>\\>\n | \\<&<dataText>\n | \\<: [<?transliteration>n|r|t|b|x|[\\<|#|\\\"]<*\\>?>] \\>\n | \\<:[<#?utf16code>|x<#x?utf16code>]\\>\n | \\<:lf\\><?newline>\n | \\<:\\ \\><!\\\\s*?> [ \\#\\#<*\\r\\n?> <!\\\\s*?> ]\n | \\<:s\\><?skipWhiteSpaces>\n | \\<:@<setColumn>\\>  \n | \\<:<DefVariable?> \\>  \n | \\<:=<assignInTextExpr?assignExpr>  \n | \\<::\\><textExpr?.indent=-4?.skipFirstnl=1>\\<\\.\\>\n | \\<:\\><textExpr?.indent=-3>\\<\\.\\>\n | <*|\\<:|\\<&|\\#\\#|\\<\\.?plainText>\n ]\n }.\n \n \n dataText::=<dataAccess>[ \\:\\?[<\"\"?errorText>|<*\\>:?errorText>]][ \\: [<\"\"?formatText>|<*\\>?formatText>]] \\>.     ##<*expr: format>\n \n textOut::= [<dataPath?assign>] [:n<?newline>] \\> \n   [ <textExpr>]\n   [ \\<\\.+\\>                     ## end text variants: \n   | \\<\\.n+\\><?newline>  \n   | \\<\\.+n\\><?newline> \n   | \\<\\.+n+flush\\><?newline><?flush>  \n   | \\<\\.+flush\\><?flush>\n   | \\<\\.+n+close\\><?close>  \n   | \\<\\.+close\\><?close> \n   ].\n \n setColumn::=<numExpr> [ : <numExpr?minSpaces>] | : <numExpr?minSpaces>.\n \n \n assignInTextExpr::= <dataPath?assign>[[ = | += <?append>] <objExpr?> \\> | \\><textExpr>\\<\\.=\\> ].\n \n forCtrl::= ( <$?forVariable> : <dataAccess?forContainer> [ && <condition> ] )  [\\{ [<statementBlock>] \\} | ; ] .\n \n forInText::= <$?forVariable> : <dataAccess?forContainer> [ && <condition> ] \\><textExpr>\\<\\.for[ : <$?@checkForVariable> ]\\>. \n ##name is the name of the container element data reference\n \n ifCtrl::= <ifBlock> [{ elsif <ifBlock>  }][ else \\{ [<statementBlock?elseBlock>] \\} ].\n \n ifBlock::= ( <condition> ) [ \\{ [ <statementBlock> ] \\} | ; ] .\n \n ifInText::= <ifBlockInText?ifBlock> [{ \\<:elsif : <ifBlockInText?ifBlock>  }][ \\<:else\\> <textExpr?elseBlock> ] \\<\\.if\\>.\n \n ifBlockInText::= <conditionInText?condition> \\><textExpr>.\n \n whileCtrl::= ( <condition> ) [ \\{ [<statementBlock>] \\} | ; ] .\n \n dowhileCtrl::=  \\{ [<statementBlock>] \\} while ( <condition> ) ; .\n \n \n onerror::= [ <#?errorLevel> \n            | [<?errortype> notfound | cmd | file | internal | exit ]\n            |]\n            \\{ [<statementBlock>] \\}.\n \n \n callSubroutine::= [{ <dataPath?assign> [ = | += <?append>] }] call <textValue?callName> ( [{ <namedArgument?actualArgument> ? , }] ) ; .\n \n callSubtext::=<textValueTextExpr?callName> [ : { <namedArgument?actualArgument> ? , }] \\>.\n \n namedArgument::= <$?name> = <objExpr?>.\n \n \n zmake::= [ : <$-?name> :[?=] ]     ##optional : name : of the zmake target, not ends with := \n          <textValue?zmakeOutput> := <textValue?callName> \n          ( { <namedArgument?actualArgument> | <filesetAccess> ? ,} ).\n \n \n ## An accessPath is a Filepath, see prepFilepath::=, but analyzed on Java level. \n filesetAccess::=[ <\"\"?accessPath> | \\<:\\><textExpr>\\<\\.\\> \n                 | & <dataAccess> ##the fileset, or a String variable for the accessPath\n                 | <*\\ \\r\\n,)&?accessPath> ##will be converted to Filepath maybe with ':'\n                 |] [ & <dataAccess?zmakeFilesetVariable>] . ##& ... it is the fileset   \n \n \n cmdLineWait::=[{ <dataPath?assign> += }] cmd\\  <cmdLine?>.\n \n cmdLine::= [\\!argsCheck!<?argsCheck>] <textValue?> [{[?;[\\ |\\n|\\r]] [ \\<\\:arg\\><textExpr?actualArgument>\\<\\.arg\\> | \\<\\:args:<dataAccess?argList>\\> |<textValue?actualArgument>] }] \n   [ \\<:stdout:[ pipe<?pipe>| [$]<$?stdoutVariable>] \\>] ;.\n \n iferrorlevel::= <#?errorLevel> \\{ [<statementBlock>] \\}.\n \n \n \n assignExpr::= [{ <dataPath?assign> [ = | += <?append>] }] <objExpr?> ;.\n \n \n threadBlock::= Thread <dataPath?defThreadVar> = [thread] \\{ <statementBlock> \\} \n              | thread \\{ <statementBlock> \\}.\n \n");
        }
        catch (ParseException parseException) {
            throw new ScriptException("JZcmd.ctor - internal syntax error; " + parseException.getMessage());
        }
        zbnfParser.setXmlSrcline(file2 != null);
        boolean bl = zbnfParser.parse(stringPartScan);
        if (!bl) {
            String string = zbnfParser.getSyntaxErrorReport();
            throw new ScriptException("\n" + string, stringPartScan.getInputfile(), -1, -1);
        }
        if (file2 != null) {
            try {
                object = new FileWriter(file2);
                zbnfParser.writeResultAsTextList((Appendable)object);
                ((Writer)object).close();
            }
            catch (IOException iOException) {
                throw new ScriptException(iOException);
            }
        }
        object = new ZbnfJavaOutput(this.console);
        zbnfJZcmdScript.scriptfile = new Scriptfile();
        try {
            ((ZbnfJavaOutput)object).setContent(ZbnfJZcmdScript.class, zbnfJZcmdScript, zbnfParser.getFirstParseResult());
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
        if (zbnfJZcmdScript.isXmlSrcNecessary()) {
            zbnfJZcmdScript.setXmlSrc(zbnfParser.getResultTree());
        }
        Subroutine subroutine = zbnfJZcmdScript.scriptfile.getMainRoutine();
        for (JZcmditem jZcmditem : this.scriptClass.statementsAdd) {
            String string;
            int n;
            Object object2;
            if (!(jZcmditem instanceof JZcmdInclude)) continue;
            JZcmdInclude jZcmdInclude = (JZcmdInclude)jZcmditem;
            File file3 = null;
            StringPartScan stringPartScan2 = null;
            if (jZcmdInclude.bJop) {
                try {
                    object2 = (String)DataAccess.access("%" + jZcmdInclude.path, null, false, false, false, null);
                    stringPartScan2 = new StringPartScan((CharSequence)object2);
                    file3 = file.getAbsoluteFile();
                    n = jZcmdInclude.parentLevel;
                    while (--n >= 0) {
                        file3 = file3.getParentFile();
                    }
                    stringPartScan2.setInputfile(FileFunctions.getCanonicalPath(file3) + "/" + jZcmdInclude.path);
                }
                catch (Exception exception) {
                    if (stringPartScan2 != null) {
                        stringPartScan2.close();
                    }
                    throw new ScriptException(exception);
                }
            }
            if (jZcmdInclude.envVar != null) {
                object2 = System.getenv(jZcmdInclude.envVar);
                if (object2 == null) {
                    throw jZcmdInclude.scriptException("JZcmd.include - cannot find environment variable;" + jZcmdInclude.envVar);
                }
                string = (String)object2 + '/' + jZcmdInclude.path;
            } else {
                string = jZcmdInclude.path;
            }
            object2 = FileFunctions.isAbsolutePath(string) ? FileFunctions.newFile(string) : new File(file, string);
            if (!((File)object2).exists()) {
                System.err.printf("TextGenScript - translateAndSetGenCtrl, included file not found; %s\n", ((File)object2).getAbsolutePath());
                throw new ScriptException("JZcmd.compile - included file not found: ", ((File)object2).getAbsolutePath(), -1, -1);
            }
            file3 = FileFunctions.getDir((File)object2);
            n = (int)((File)object2).length();
            try {
                stringPartScan2 = new StringPartFromFileLines((File)object2, n, "encoding", null);
            }
            catch (Exception exception) {
                if (stringPartScan2 != null) {
                    stringPartScan2.close();
                }
                throw new ScriptException(exception);
            }
            object2 = zbnfJZcmdScript.statementsAdd;
            zbnfJZcmdScript.statementsAdd = jZcmdInclude.statementlist.statements;
            this.setScriptFromString(stringPartScan2, zbnfJZcmdScript, file3, file2);
            zbnfJZcmdScript.statementsAdd = object2;
            stringPartScan2.close();
        }
        if (subroutine != null) {
            zbnfJZcmdScript.setMainRoutine(subroutine);
        }
    }

    @Override
    public Object eval(ScriptContext scriptContext) throws ScriptException {
        if (scriptContext instanceof JZtxtcmdExecuter.ExecuteLevel) {
            JZtxtcmdExecuter.ExecuteLevel executeLevel = (JZtxtcmdExecuter.ExecuteLevel)scriptContext;
            try {
                Subroutine subroutine = this.getMain();
                List<DataAccess.Variable<Object>> list = null;
                executeLevel.exec_Subroutine(subroutine, list, null, 0);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    throw new ScriptException((Exception)throwable);
                }
                throw new RuntimeException("JZcmdScript.eval - unexpected Throwable", throwable);
            }
        } else {
            throw new ScriptException("faulty context");
        }
        return null;
    }

    @Override
    public JZtxtcmdEngine getEngine() {
        return this.scriptEngine;
    }

    public JZcmdClass scriptClass() {
        return this.scriptClass;
    }

    public final Subroutine getMain() {
        return this.mainRoutine;
    }

    public Set<Map.Entry<String, Subroutine>> iterSubroutines() {
        return this.subroutinesAll.entrySet();
    }

    public Subroutine getSubroutine(CharSequence charSequence) {
        return this.subroutinesAll.get(charSequence.toString());
    }

    public JZcmdClass getClass(CharSequence charSequence) {
        return this.classesAll.get(charSequence.toString());
    }

    public void writeStruct(Appendable appendable) throws IOException {
        this.scriptClass.writeStruct(0, appendable);
    }

    public void addContentToSelectContainer(AddSub2List addSub2List) {
        this.addSubOfJZcmdClass(this.scriptClass, addSub2List, 1);
    }

    private void addSubOfJZcmdClass(JZcmdClass jZcmdClass, AddSub2List addSub2List, int n) {
        for (Object object : jZcmdClass.listClassesAndSubroutines()) {
            SetLineColumn_ifc setLineColumn_ifc;
            if (object instanceof Subroutine) {
                setLineColumn_ifc = (Subroutine)object;
                if (setLineColumn_ifc.name.startsWith("_")) continue;
                addSub2List.add2List((Subroutine)setLineColumn_ifc, n);
                continue;
            }
            assert (object instanceof JZcmdClass);
            setLineColumn_ifc = (JZcmdClass)object;
            addSub2List.add2List((JZcmdClass)object, n);
            this.addSubOfJZcmdClass((JZcmdClass)setLineColumn_ifc, addSub2List, n + 1);
        }
    }

    public static class Scriptfile {
        Subroutine mainRoutine;

        public Subroutine getMainRoutine() {
            return this.mainRoutine;
        }
    }

    public static final class ZbnfJZcmdScript
    extends JZcmdClass {
        private final JZtxtcmdScript compiledScript;
        public Scriptfile scriptfile;

        public ZbnfJZcmdScript(JZtxtcmdScript jZtxtcmdScript) {
            super(jZtxtcmdScript, jZtxtcmdScript.jzScriptSettings);
            this.compiledScript = jZtxtcmdScript;
            jZtxtcmdScript.scriptClass = this;
        }

        public JZcmdInclude new_include() {
            return new JZcmdInclude(this);
        }

        public void add_include(JZcmdInclude jZcmdInclude) {
            this.statementsAdd.add(jZcmdInclude);
        }

        public StatementList new_mainRoutine() {
            this.scriptfile.mainRoutine = new Subroutine(this.compiledScript.scriptClass);
            this.scriptfile.mainRoutine.statementlist = new StatementList(this.compiledScript.jzScriptSettings);
            this.scriptfile.mainRoutine.srcFile = this.srcFile;
            return this.scriptfile.mainRoutine.statementlist;
        }

        public void add_mainRoutine(StatementList statementList) {
        }

        public JZcmditem new_checkJZcmdFile() {
            return new JZcmditem(this, '\u0000');
        }

        public void add_checkJZcmdFile(JZcmditem jZcmditem) {
            this.compiledScript.checkJZcmdFile = jZcmditem;
        }

        public JZcmditem new_checkXmlFile() {
            return new JZcmditem(this, '\u0000');
        }

        public void add_checkXmlFile(JZcmditem jZcmditem) {
            this.compiledScript.checkJZcmdXmlFile = jZcmditem;
        }

        public void setMainRoutine(Subroutine subroutine) {
            this.compiledScript.mainRoutine = subroutine;
        }

        public boolean isXmlSrcNecessary() {
            return this.compiledScript.checkJZcmdXmlFile != null;
        }

        public void setXmlSrc(XmlNode xmlNode) {
            this.compiledScript.xmlSrc = xmlNode;
        }
    }

    public static final class JZcmdInclude
    extends JZcmditem {
        public String path;
        public String envVar;
        public boolean bJop;
        public int parentLevel;

        JZcmdInclude(StatementList statementList) {
            super(statementList, '.');
            this.statementlist = new StatementList(this);
        }
    }

    public static class JZcmdClass
    extends StatementList {
        List<JZcmdClass> classes;
        final Map<String, Subroutine> subroutines = new TreeMap<String, Subroutine>();
        final List<Object> listClassesAndSubroutines = new ArrayList<Object>();
        final JZtxtcmdScript theScript;

        protected JZcmdClass(JZtxtcmdScript jZtxtcmdScript, JZscriptSettings jZscriptSettings) {
            super(jZscriptSettings);
            this.theScript = jZtxtcmdScript;
        }

        public final List<JZcmdClass> classes() {
            return this.classes;
        }

        public final Map<String, Subroutine> subroutines() {
            return this.subroutines;
        }

        public final List<Object> listClassesAndSubroutines() {
            return this.listClassesAndSubroutines;
        }

        public JZcmdClass new_subClass() {
            return new JZcmdClass(this.theScript, this.theScript.jzScriptSettings);
        }

        public void add_subClass(JZcmdClass jZcmdClass) {
            if (this.classes == null) {
                this.classes = new ArrayList<JZcmdClass>();
            }
            this.classes.add(jZcmdClass);
            this.listClassesAndSubroutines.add(jZcmdClass);
            String string = jZcmdClass.cmpnName;
            String string2 = this.cmpnName == null ? string : this.cmpnName + "." + string;
            this.theScript.classesAll.put(string2, jZcmdClass);
        }

        public Subroutine new_subroutine() {
            return new Subroutine(this);
        }

        public void add_subroutine(Subroutine subroutine) {
            if (subroutine.name == null) {
                subroutine.name = "main";
            }
            String string = subroutine.name.toString();
            this.subroutines.put(string, subroutine);
            this.listClassesAndSubroutines.add(subroutine);
            String string2 = this.cmpnName == null ? string : this.cmpnName + "." + string;
            this.theScript.subroutinesAll.put(string2, subroutine);
        }

        public void writeStruct(int n, Appendable appendable) throws IOException {
            if (this.statements != null) {
                for (JZcmditem object : this.statements) {
                    object.writeStruct(n + 1, appendable);
                }
            }
            for (Map.Entry entry : this.subroutines.entrySet()) {
                Subroutine subroutine = (Subroutine)entry.getValue();
                subroutine.writeStruct(0, appendable);
            }
            if (this.classes != null) {
                for (JZcmdClass jZcmdClass : this.classes) {
                    jZcmdClass.writeStruct(n + 1, appendable);
                }
            }
        }
    }

    public static class StatementList
    implements SetLineColumn_ifc {
        String srcFile = "srcFile-yet-unknown";
        int srcLine;
        int srcColumn;
        final JZcmditem parentStatement;
        public String cmpnName;
        public final List<JZcmditem> statements = new LinkedList<JZcmditem>();
        protected List<JZcmditem> statementsAdd = this.statements;
        List<Onerror> onerrorAccu;
        List<JZcmditem> withoutOnerror = new LinkedList<JZcmditem>();
        public boolean bContainsVariableDef;
        boolean bSetSkipSpaces;
        final JZscriptSettings jzSettings;
        int nIndentInScript = 0;
        String sIndentChars = "=+:";

        public StatementList(JZscriptSettings jZscriptSettings) {
            this.parentStatement = null;
            this.jzSettings = jZscriptSettings;
        }

        public StatementList(JZcmditem jZcmditem) {
            this.parentStatement = jZcmditem;
            if (jZcmditem == null || jZcmditem.parentList == null) {
                this.jzSettings = null;
            } else {
                this.jzSettings = jZcmditem.parentList.jzSettings;
                this.nIndentInScript = jZcmditem.parentList.nIndentInScript;
                this.sIndentChars = jZcmditem.parentList.sIndentChars;
            }
        }

        public JZcmditem new_createTextOut() {
            JZcmditem jZcmditem = new JZcmditem(this, 'o');
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
            return jZcmditem;
        }

        public void add_createTextOut(JZcmditem jZcmditem) {
        }

        public JZcmditem new_appendTextOut() {
            JZcmditem jZcmditem = new JZcmditem(this, 'q');
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
            return jZcmditem;
        }

        public void add_appendTextOut(JZcmditem jZcmditem) {
        }

        @Override
        public void setLineColumnFile(int n, int n2, String string) {
            this.srcLine = n;
            this.srcColumn = n2;
            this.srcFile = string;
        }

        @Override
        public int setLineColumnFileMode() {
            return 7;
        }

        public StatementList new_statementBlock() {
            this.bSetSkipSpaces = false;
            JZcmditem jZcmditem = new JZcmditem(this, 'B');
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
            jZcmditem.statementlist = new StatementList(jZcmditem);
            return jZcmditem.statementlist;
        }

        public void add_statementBlock(StatementList statementList) {
        }

        public JZcmditem new_debugOp() {
            return new JZcmditem(this, 'H');
        }

        public void add_debugOp(JZcmditem jZcmditem) {
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
        }

        public JZcmditem new_debug() {
            return new JZcmditem(this, 'D');
        }

        public void add_debug(JZcmditem jZcmditem) {
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
        }

        public void set_debug() {
            this.statementsAdd.add(new JZcmditem(this, 'D'));
        }

        public void set_scriptdir() {
            this.bSetSkipSpaces = false;
            TextOut textOut = new TextOut(this, 't');
            int n = this.srcFile.lastIndexOf(47);
            textOut.textArg = this.srcFile.substring(0, n);
            this.statementsAdd.add(textOut);
        }

        public TextOut new_textOut() {
            return new TextOut(this, 'T');
        }

        public void add_textOut(TextOut textOut) {
            this.statementsAdd.add(textOut);
        }

        public void set_nIndent(long l) {
            this.nIndentInScript = (int)l;
        }

        public void set_cIndent(String string) {
            this.sIndentChars = string;
        }

        public StatementList new_textExpr(ZbnfParseResultItem zbnfParseResultItem) {
            this.bSetSkipSpaces = false;
            if (zbnfParseResultItem.syntaxItem().bDebugParsing) {
                Debugutil.stop();
            }
            JZcmditem jZcmditem = new JZcmditem(this, ':');
            this.statementsAdd.add(jZcmditem);
            jZcmditem.statementlist = new StatementList(jZcmditem);
            return jZcmditem.new_textExpr(zbnfParseResultItem);
        }

        public void add_textExpr(StatementList statementList) {
        }

        public StatementList new_textExprTEST(ZbnfParseResultItem zbnfParseResultItem) {
            JZcmditem jZcmditem = new JZcmditem(this, ':');
            this.statementsAdd.add(jZcmditem);
            jZcmditem.statementlist = new StatementList(jZcmditem);
            return jZcmditem.statementlist;
        }

        public void add_textExprTEST(StatementList statementList) {
        }

        public DefVariable new_textVariable() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'S');
        }

        public void add_textVariable(DefVariable defVariable) {
            this.statementsAdd.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_Pipe() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'P');
        }

        public void add_Pipe(DefVariable defVariable) {
            this.statementsAdd.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_Stringjar() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'U');
        }

        public void add_Stringjar(DefVariable defVariable) {
            this.statementsAdd.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefContainerVariable new_List() {
            this.bContainsVariableDef = true;
            return new DefContainerVariable(this, 'L');
        }

        public void add_List(DefContainerVariable defContainerVariable) {
            this.statementsAdd.add(defContainerVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defContainerVariable);
        }

        public DefVariable new_DefMapVar() {
            this.bContainsVariableDef = true;
            DefVariable defVariable = new DefVariable(this, 'M');
            this.statementsAdd.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
            return defVariable;
        }

        public void add_DefMapVar(DefVariable defVariable) {
        }

        public DefVariable new_Openfile() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'W');
        }

        public void add_Openfile(DefVariable defVariable) {
            this.statementsAdd.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_DefFilepath() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'F');
        }

        public void add_DefFilepath(DefVariable defVariable) {
            this.statementsAdd.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public UserFileset new_DefFileset() {
            this.bContainsVariableDef = true;
            return new UserFileset(this);
        }

        public void add_DefFileset(UserFileset userFileset) {
            this.statementsAdd.add(userFileset);
            this.onerrorAccu = null;
            this.withoutOnerror.add(userFileset);
        }

        public Zmake new_zmake() {
            this.bContainsVariableDef = true;
            return new Zmake(this);
        }

        public void add_zmake(Zmake zmake) {
            this.statementsAdd.add(zmake);
            this.onerrorAccu = null;
            this.withoutOnerror.add(zmake);
        }

        public DefVariable new_DefObjVar() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'O');
        }

        public void add_DefObjVar(DefVariable defVariable) {
            this.statementsAdd.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable XXXnew_DefSubtext() {
            return new DefVariable(this, 'C');
        }

        public void XXXadd_DefSubtext(DefVariable defVariable) {
            defVariable.elementType = defVariable.statementlist != null ? (char)123 : (char)79;
            this.statementsAdd.add(defVariable);
        }

        public Subroutine new_DefSubtext() {
            StatementList statementList = this;
            while (statementList != null && !(statementList instanceof JZcmdClass)) {
                statementList = statementList.parentStatement.parentList;
            }
            JZcmdClass jZcmdClass = statementList == null ? null : (JZcmdClass)statementList;
            return new Subroutine(jZcmdClass);
        }

        public void add_DefSubtext(Subroutine subroutine) {
            subroutine.elementType = subroutine.statementlist != null ? (char)123 : (char)79;
            this.statementsAdd.add(subroutine);
        }

        public DefClasspathVariable new_DefClasspath() {
            this.bContainsVariableDef = true;
            return new DefClasspathVariable(this);
        }

        public void add_DefClasspath(DefClasspathVariable defClasspathVariable) {
            this.statementsAdd.add(defClasspathVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defClasspathVariable);
        }

        public DefClassVariable new_DefClassVar() {
            this.bContainsVariableDef = true;
            return new DefClassVariable(this);
        }

        public void add_DefClassVar(DefClassVariable defClassVariable) {
            this.statementsAdd.add(defClassVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defClassVariable);
        }

        public DefVariable new_DefNumVar() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'K');
        }

        public void add_DefNumVar(DefVariable defVariable) {
            this.statementsAdd.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_DefBoolVar() {
            this.bContainsVariableDef = true;
            return new DefVariable(this, 'Q');
        }

        public void add_DefBoolVar(DefVariable defVariable) {
            this.statementsAdd.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DefVariable new_setEnvVar() {
            return new DefVariable(this, 'S');
        }

        public void add_setEnvVar(DefVariable defVariable) {
            List<DataAccess.DatapathElement> list = defVariable.defVariable.datapath();
            int n = list.size() - 1;
            DataAccess.DatapathElement datapathElement = list.get(n);
            datapathElement.setIdent("$" + datapathElement.ident());
            this.statementsAdd.add(defVariable);
            this.onerrorAccu = null;
            this.withoutOnerror.add(defVariable);
        }

        public DataText new_dataText() {
            this.bSetSkipSpaces = false;
            return new DataText(this);
        }

        public void add_dataText(DataText dataText) {
            this.statementsAdd.add(dataText);
            this.onerrorAccu = null;
            this.withoutOnerror.add(dataText);
        }

        public void set_textReplLf(String string) {
        }

        public TextColumn new_setColumn() {
            return new TextColumn(this);
        }

        public void add_setColumn(TextColumn textColumn) {
            this.statementsAdd.add(textColumn);
        }

        public void set_plainText(String string) {
            Object object;
            int n = string.length();
            CharSequence charSequence = string;
            if (n > 0) {
                int n2;
                if (this.srcLine == 24) {
                    Debugutil.stop();
                }
                if (this.jzSettings != null && (n = (charSequence = StringFunctions_B.removeIndentReplaceNewline(string, n2 = this.nIndentInScript, (String)(object = this.sIndentChars), this.jzSettings.srcTabsize, this.jzSettings.sLinefeed, this.bSetSkipSpaces)).length()) > 0) {
                    this.bSetSkipSpaces = false;
                }
            }
            if (n > 0) {
                object = new JZcmditem(this, 't');
                ((JZcmditem)object).textArg = charSequence.toString();
                this.statementsAdd.add((JZcmditem)object);
                this.onerrorAccu = null;
                this.withoutOnerror.add((JZcmditem)object);
            }
        }

        public void set_transliteration(String string) {
            this.bSetSkipSpaces = false;
            char c = string.charAt(0);
            if (c != 'x') {
                JZcmditem jZcmditem = new JZcmditem(this, '\\');
                switch (c) {
                    case 'n': {
                        jZcmditem.textArg = "\n";
                        break;
                    }
                    case 'r': {
                        jZcmditem.textArg = "\r";
                        break;
                    }
                    case 't': {
                        jZcmditem.textArg = "\t";
                        break;
                    }
                    case 'b': {
                        jZcmditem.textArg = "\b";
                        break;
                    }
                    case '\"': 
                    case '#': 
                    case '<': {
                        jZcmditem.textArg = string;
                    }
                }
                this.statementsAdd.add(jZcmditem);
                this.onerrorAccu = null;
                this.withoutOnerror.add(jZcmditem);
            }
        }

        public void set_utf16code(long l) {
            this.bSetSkipSpaces = false;
            JZcmditem jZcmditem = new JZcmditem(this, 't');
            jZcmditem.textArg = "" + (char)l;
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
        }

        public void set_newline() {
            this.bSetSkipSpaces = false;
            JZcmditem jZcmditem = new JZcmditem(this, 'n');
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
        }

        public void set_skipWhiteSpaces() {
            this.bSetSkipSpaces = true;
        }

        public AssignExpr new_assignExpr() {
            return new AssignExpr(this, '=');
        }

        public void add_assignExpr(AssignExpr assignExpr) {
            this.statementsAdd.add(assignExpr);
            this.onerrorAccu = null;
            this.withoutOnerror.add(assignExpr);
        }

        public JZcmditem new_throw() {
            return new JZcmditem(this, 'r');
        }

        public void add_throw(JZcmditem jZcmditem) {
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
        }

        public void set_throwonerror(int n) {
            Onerror onerror = new Onerror(this);
            onerror.elementType = (char)118;
            onerror.errorLevel = n;
            this.statementsAdd.add(onerror);
        }

        public void set_errorToOutput(String string) {
            JZcmditem jZcmditem = new JZcmditem(this, ',');
            if (string.equals("1")) {
                jZcmditem.textArg = string;
            }
            this.statementsAdd.add(jZcmditem);
        }

        public Onerror new_onerror() {
            return new Onerror(this);
        }

        public void add_onerror(Onerror onerror) {
            if (onerror.errorLevel != Integer.MIN_VALUE) {
                onerror.setCmdError();
            }
            this.statementsAdd.add(onerror);
            this.withoutOnerror.clear();
        }

        public Onerror new_iferrorlevel() {
            return new Onerror(this);
        }

        public void add_iferrorlevel(Onerror onerror) {
            onerror.setCmdError();
            this.statementsAdd.add(onerror);
        }

        public void set_breakBlock() {
            JZcmditem jZcmditem = new JZcmditem(this, 'b');
            this.statementsAdd.add(jZcmditem);
        }

        public IfStatement new_ifCtrl() {
            this.bSetSkipSpaces = false;
            StatementList statementList = new StatementList(this.parentStatement);
            IfStatement ifStatement = new IfStatement(this, 'i');
            ifStatement.statementlist = statementList;
            return ifStatement;
        }

        public void add_ifCtrl(IfStatement ifStatement) {
            this.statementsAdd.add(ifStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(ifStatement);
        }

        public StatementList new_hasNext() {
            JZcmditem jZcmditem = new JZcmditem(this, 'N');
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
            if (jZcmditem.statementlist == null) {
                jZcmditem.statementlist = new StatementList(jZcmditem);
            }
            return jZcmditem.statementlist;
        }

        public void add_hasNext(StatementList statementList) {
        }

        public ForStatement new_forCtrl() {
            this.bSetSkipSpaces = false;
            ForStatement forStatement = new ForStatement(this, 'f');
            this.statementsAdd.add(forStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(forStatement);
            return forStatement;
        }

        public void add_forCtrl(ForStatement forStatement) {
        }

        public CondStatement new_whileCtrl() {
            this.bSetSkipSpaces = false;
            CondStatement condStatement = new CondStatement(this, 'w');
            this.statementsAdd.add(condStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(condStatement);
            return condStatement;
        }

        public void add_whileCtrl(CondStatement condStatement) {
        }

        public CondStatement new_dowhileCtrl() {
            this.bSetSkipSpaces = false;
            CondStatement condStatement = new CondStatement(this, 'u');
            this.statementsAdd.add(condStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(condStatement);
            return condStatement;
        }

        public void add_dowhileCtrl(CondStatement condStatement) {
        }

        public ThreadBlock new_threadBlock() {
            ThreadBlock threadBlock = new ThreadBlock(this);
            this.statementsAdd.add(threadBlock);
            this.onerrorAccu = null;
            this.withoutOnerror.add(threadBlock);
            return threadBlock;
        }

        public void add_threadBlock(ThreadBlock threadBlock) {
        }

        public CallStatement new_call() {
            this.bSetSkipSpaces = false;
            CallStatement callStatement = new CallStatement(this, 's');
            this.statementsAdd.add(callStatement);
            this.onerrorAccu = null;
            this.withoutOnerror.add(callStatement);
            return callStatement;
        }

        public void add_call(CallStatement callStatement) {
        }

        public CmdInvoke new_cmdWait() {
            CmdInvoke cmdInvoke = new CmdInvoke(this, 'c');
            this.statementsAdd.add(cmdInvoke);
            this.onerrorAccu = null;
            this.withoutOnerror.add(cmdInvoke);
            return cmdInvoke;
        }

        public void add_cmdWait(CmdInvoke cmdInvoke) {
        }

        public CmdInvoke new_cmdStart() {
            CmdInvoke cmdInvoke = new CmdInvoke(this, 'c');
            cmdInvoke.bShouldNotWait = true;
            this.statementsAdd.add(cmdInvoke);
            this.onerrorAccu = null;
            this.withoutOnerror.add(cmdInvoke);
            return cmdInvoke;
        }

        public void add_cmdStart(CmdInvoke cmdInvoke) {
        }

        public CmdInvoke new_cmdShell() {
            CmdInvoke cmdInvoke = new CmdInvoke(this, 'c');
            cmdInvoke.bExecScript = true;
            cmdInvoke.bShouldNotWait = false;
            this.statementsAdd.add(cmdInvoke);
            this.onerrorAccu = null;
            this.withoutOnerror.add(cmdInvoke);
            return cmdInvoke;
        }

        public void add_cmdShell(CmdInvoke cmdInvoke) {
        }

        public FileOpArg new_move() {
            FileOpArg fileOpArg = new FileOpArg(this, 'm');
            this.statementsAdd.add(fileOpArg);
            this.onerrorAccu = null;
            this.withoutOnerror.add(fileOpArg);
            return fileOpArg;
        }

        public void add_move(FileOpArg fileOpArg) {
        }

        public FileOpArg new_copy() {
            FileOpArg fileOpArg = new FileOpArg(this, 'y');
            this.statementsAdd.add(fileOpArg);
            this.onerrorAccu = null;
            this.withoutOnerror.add(fileOpArg);
            return fileOpArg;
        }

        public void add_copy(FileOpArg fileOpArg) {
        }

        public FileOpArg new_del() {
            FileOpArg fileOpArg = new FileOpArg(this, 'l');
            this.statementsAdd.add(fileOpArg);
            this.onerrorAccu = null;
            this.withoutOnerror.add(fileOpArg);
            return fileOpArg;
        }

        public void add_del(FileOpArg fileOpArg) {
        }

        public JZcmditem new_cd() {
            JZcmditem jZcmditem = new JZcmditem(this, 'd');
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
            return jZcmditem;
        }

        public void add_cd(JZcmditem jZcmditem) {
        }

        public JZcmditem new_mkdir() {
            JZcmditem jZcmditem = new JZcmditem(this, '9');
            this.statementsAdd.add(jZcmditem);
            this.onerrorAccu = null;
            this.withoutOnerror.add(jZcmditem);
            return jZcmditem;
        }

        public void add_mkdir(JZcmditem jZcmditem) {
        }

        public void set_name(String string) {
            this.cmpnName = string;
        }

        public void set_exitScript(int n) {
            ExitStatement exitStatement = new ExitStatement(this, n);
            this.statementsAdd.add(exitStatement);
        }
    }

    public static final class Onerror
    extends JZcmditem {
        public int errorLevel = Integer.MIN_VALUE;
        public char errorType = (char)63;

        public void set_errortype(String string) {
            this.errorType = string.charAt(0);
        }

        Onerror(StatementList statementList) {
            super(statementList, '?');
        }

        void setCmdError() {
            this.elementType = (char)35;
        }
    }

    public static class ThreadBlock
    extends JZcmditem {
        DataAccess threadVariable;

        ThreadBlock(StatementList statementList) {
            super(statementList, 'x');
        }

        public JZcmdDataAccess new_defThreadVar() {
            return new JZcmdDataAccess();
        }

        public void add_defThreadVar(JZcmdDataAccess jZcmdDataAccess) {
            jZcmdDataAccess.setTypeToLastElement('T');
            this.threadVariable = jZcmdDataAccess;
        }

        public JZcmdDataAccess new_assignThreadVar() {
            return new JZcmdDataAccess();
        }

        public void add_assignThreadVar(JZcmdDataAccess jZcmdDataAccess) {
            this.threadVariable = jZcmdDataAccess;
        }
    }

    public static class ExitStatement
    extends JZcmditem {
        int exitValue;

        ExitStatement(StatementList statementList, int n) {
            super(statementList, 'z');
            this.exitValue = n;
        }
    }

    public static class CmdInvoke
    extends AssignExpr {
        public List<JZcmditem> cmdArgs;
        public List<DataAccess> errorPipes;
        public DataAccess errorPipe;
        public DataAccess inputPipe;
        boolean bCmdCheck;
        public boolean bShouldNotWait;
        public boolean bExecScript;

        CmdInvoke(StatementList statementList, char c) {
            super(statementList, c);
        }

        public JZcmditem new_actualArgument() {
            return new JZcmditem(this.parentList, '.');
        }

        public void add_actualArgument(JZcmditem jZcmditem) {
            if (this.cmdArgs == null) {
                this.cmdArgs = new ArrayList<JZcmditem>();
            }
            this.cmdArgs.add(jZcmditem);
        }

        public JZcmdDataAccess new_argList() {
            JZcmdDataAccess jZcmdDataAccess;
            JZcmditem jZcmditem = new JZcmditem(this.parentList, 'L');
            jZcmditem.dataAccess = jZcmdDataAccess = new JZcmdDataAccess();
            if (this.cmdArgs == null) {
                this.cmdArgs = new ArrayList<JZcmditem>();
            }
            this.cmdArgs.add(jZcmditem);
            return jZcmdDataAccess;
        }

        public void add_argList(JZcmdDataAccess jZcmdDataAccess) {
        }

        public void set_argsCheck() {
            this.bCmdCheck = true;
        }
    }

    public static class CallStatement
    extends AssignExpr {
        JZcmditem call_Name;
        public List<Argument> actualArgs;

        CallStatement(StatementList statementList, char c) {
            super(statementList, c);
        }

        public JZcmditem new_callName() {
            this.call_Name = new Argument(this.parentList);
            return this.call_Name;
        }

        public void set_callName(JZcmditem jZcmditem) {
        }

        public Argument new_actualArgument() {
            return new Argument(this.parentList);
        }

        public void add_actualArgument(Argument argument) {
            if (this.actualArgs == null) {
                this.actualArgs = new ArrayList<Argument>();
            }
            this.actualArgs.add(argument);
        }

        @Override
        void writeStructAdd(int n, Appendable appendable) throws IOException {
            this.call_Name.writeStruct(0, appendable);
            if (this.actualArgs != null) {
                for (Argument argument : this.actualArgs) {
                    argument.writeStruct(n + 1, appendable);
                }
            }
            appendable.append("\n");
        }
    }

    public static class Subroutine
    extends JZcmditem {
        public String name;
        public boolean addLocals;
        public boolean useLocals;
        public List<DefVariable> formalArgs;
        final JZtxtcmdScript theScript;

        Subroutine(JZcmdClass jZcmdClass) {
            super(jZcmdClass, 'X');
            this.theScript = jZcmdClass.theScript;
        }

        public void set_name(String string) {
            this.name = string;
        }

        public void set_useLocals() {
            this.useLocals = true;
        }

        public void set_addLocals() {
            this.addLocals = true;
        }

        public Subroutine new_formalArgument() {
            return this;
        }

        public void add_formalArgument(Subroutine subroutine) {
        }

        public DefVariable new_DefObjVar() {
            return new DefVariable(this.parentList, 'O');
        }

        public void add_DefObjVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefContainerVariable new_List() {
            return new DefContainerVariable(this.parentList, 'L');
        }

        public void add_List(DefContainerVariable defContainerVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defContainerVariable);
        }

        public DefVariable new_ClassObjVar() {
            return new DefVariable(this.parentList, 'C');
        }

        public void add_DefClassVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_DefNumVar() {
            return new DefVariable(this.parentList, 'K');
        }

        public void add_DefNumVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_DefBoolVar() {
            return new DefVariable(this.parentList, 'Q');
        }

        public void add_DefBoolVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_textVariable() {
            return new DefVariable(this.parentList, 'S');
        }

        public void add_textVariable(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_DefMapVar() {
            return new DefVariable(this.parentList, 'M');
        }

        public void add_DefMapVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public DefVariable new_DefFilepath() {
            return new DefVariable(this.parentList, 'F');
        }

        public void add_DefFilepath(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(defVariable);
        }

        public UserFileset new_DefFileset() {
            return new UserFileset(this.parentList);
        }

        public void add_DefFileset(UserFileset userFileset) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            this.formalArgs.add(userFileset);
        }

        public DefVariable new_setEnvVar() {
            return new DefVariable(this.parentList, 'S');
        }

        public void add_setEnvVar(DefVariable defVariable) {
            if (this.formalArgs == null) {
                this.formalArgs = new ArrayList<DefVariable>();
            }
            defVariable.defVariable.datapath().get(0).setIdent("$" + defVariable.defVariable.datapath().get(0).ident());
            this.formalArgs.add(defVariable);
        }

        @Override
        void writeStructAdd(int n, Appendable appendable) throws IOException {
            if (this.formalArgs != null) {
                for (DefVariable defVariable : this.formalArgs) {
                    defVariable.writeStruct(n + 1, appendable);
                }
            }
            appendable.append(")\n");
        }

        @Override
        void writeStructLine(Appendable appendable) {
            super.writeStructLine(appendable);
            try {
                if (this.name == null) {
                    appendable.append(" main(");
                } else {
                    appendable.append(" sub ").append(this.name).append("(");
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static class ForStatement
    extends CondStatement {
        String forVariable;
        String checkForVariable;
        JZcmdDataAccess forContainer;

        ForStatement(StatementList statementList, char c) {
            super(statementList, c);
        }

        public void set_forVariable(String string) {
            this.forVariable = string;
        }

        public void set_checkForVariable(String string) {
            this.checkForVariable = string;
        }

        public JZcmdDataAccess new_forContainer() {
            return new JZcmdDataAccess();
        }

        public void add_forContainer(JZcmdDataAccess jZcmdDataAccess) {
            this.forContainer = jZcmdDataAccess;
        }
    }

    public static class IfCondition
    extends CondStatement {
        public boolean bElse;

        IfCondition(StatementList statementList, char c) {
            super(statementList, c);
        }
    }

    public static class CondStatement
    extends JZcmditem {
        public JZcmditem condition;

        CondStatement(StatementList statementList, char c) {
            super(statementList, c);
        }

        public JZcmdCalculatorExpr new_condition() {
            this.condition = new JZcmditem(this.statementlist, '.');
            return this.condition.new_numExpr();
        }

        public void add_condition(JZcmdCalculatorExpr jZcmdCalculatorExpr) {
            this.condition.add_numExpr(jZcmdCalculatorExpr);
        }
    }

    public static class IfStatement
    extends JZcmditem {
        IfStatement(StatementList statementList, char c) {
            super(statementList, c);
        }

        public IfCondition new_ifBlock() {
            IfCondition ifCondition = new IfCondition(this.parentList, 'g');
            this.statementlist.statementsAdd.add(ifCondition);
            this.statementlist.onerrorAccu = null;
            this.statementlist.withoutOnerror.add(ifCondition);
            return ifCondition;
        }

        public void add_ifBlock(IfCondition ifCondition) {
        }

        public StatementList new_elseBlock() {
            JZcmditem jZcmditem = new JZcmditem(this.parentList, 'E');
            jZcmditem.statementlist = new StatementList(this);
            this.statementlist.statementsAdd.add(jZcmditem);
            this.statementlist.onerrorAccu = null;
            this.statementlist.withoutOnerror.add(jZcmditem);
            return jZcmditem.statementlist;
        }

        public void add_elseBlock(StatementList statementList) {
        }
    }

    public static class TextColumn
    extends JZcmditem {
        CalculatorExpr minSpaces;
        JZcmdDataAccess minSpacesDataAccess;

        TextColumn(StatementList statementList) {
            super(statementList, '@');
        }

        public JZcmdCalculatorExpr new_minSpaces() {
            return new JZcmdCalculatorExpr(this);
        }

        public void add_minSpaces(JZcmdCalculatorExpr jZcmdCalculatorExpr) {
            DataAccess dataAccess = jZcmdCalculatorExpr.onlyDataAccess();
            if (dataAccess != null) {
                this.minSpacesDataAccess = (JZcmdDataAccess)dataAccess;
            } else {
                jZcmdCalculatorExpr.closeExprPreparation();
                this.minSpaces = jZcmdCalculatorExpr.expr();
            }
        }

        @Override
        void writeStructAdd(int n, Appendable appendable) throws IOException {
            appendable.append(" setColumn ").append(Integer.toString(0x7777777));
        }
    }

    public static class TextOut
    extends JZcmditem {
        public JZcmdDataAccess variable;

        TextOut(StatementList statementList, char c) {
            super(statementList, c);
        }

        public JZcmdDataAccess new_assign() {
            return new JZcmdDataAccess();
        }

        public void add_assign(JZcmdDataAccess jZcmdDataAccess) {
            this.variable = jZcmdDataAccess;
        }

        public void set_newline() {
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            this.statementlist.statementsAdd.add(new JZcmditem(this.parentList, 'n'));
        }

        public void set_flush() {
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            this.statementlist.statementsAdd.add(new JZcmditem(this.parentList, '!'));
        }

        public void set_close() {
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            this.statementlist.statementsAdd.add(new JZcmditem(this.parentList, '_'));
        }
    }

    public static class AssignExpr
    extends JZcmditem {
        public List<JZcmdDataAccess> assignObjs;
        public JZcmdDataAccess variable;

        AssignExpr(StatementList statementList, char c) {
            super(statementList, c);
        }

        public JZcmdDataAccess new_assign() {
            return new JZcmdDataAccess();
        }

        public void add_assign(JZcmdDataAccess jZcmdDataAccess) {
            if (this.variable == null) {
                this.variable = jZcmdDataAccess;
            } else {
                if (this.assignObjs == null) {
                    this.assignObjs = new LinkedList<JZcmdDataAccess>();
                }
                this.assignObjs.add(jZcmdDataAccess);
            }
        }

        public void set_append() {
            if (this.elementType != '=') {
                throw new IllegalArgumentException("JZcmdScript - unexpected set_append");
            }
            this.elementType = (char)43;
        }

        @Override
        void writeStructLine(Appendable appendable) {
            super.writeStructLine(appendable);
            try {
                if (this.variable != null) {
                    appendable.append(" assign ");
                    this.variable.writeStruct(appendable);
                    appendable.append(" = ");
                } else {
                    appendable.append(" invoke ");
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static class FileOpArg
    extends JZcmditem {
        Argument src;
        Argument dst;
        boolean bNewTimestamp;
        boolean bOverwrite;
        boolean bOverwriteReadonly;

        FileOpArg(StatementList statementList, char c) {
            super(statementList, c);
        }

        public Argument new_src() {
            this.src = new Argument(this.parentList);
            return this.src;
        }

        public void set_src(Argument argument) {
        }

        public Argument new_dst() {
            this.dst = new Argument(this.parentList);
            return this.dst;
        }

        public void set_dst(Argument argument) {
        }

        public void set_newTimestamp() {
            this.bNewTimestamp = true;
        }

        public void set_overwr() {
            this.bOverwrite = true;
        }

        public void set_overwro() {
            this.bOverwriteReadonly = true;
        }
    }

    public static class DefClasspathVariable
    extends DefVariable {
        List<AccessFilesetname> jarpaths = new ArrayList<AccessFilesetname>();
        String nameParentClasspath;

        DefClasspathVariable(StatementList statementList) {
            super(statementList, 'J');
        }

        @Override
        public AccessFilesetname new_filesetAccess() {
            return new AccessFilesetname(this.parentList);
        }

        @Override
        public void add_filesetAccess(AccessFilesetname accessFilesetname) {
            this.jarpaths.add(accessFilesetname);
        }

        public void set_parentClasspath(String string) {
            this.nameParentClasspath = string;
        }
    }

    public static class DefClassVariable
    extends DefVariable {
        JZcmdDataAccess loader;

        DefClassVariable(StatementList statementList) {
            super(statementList, 'C');
        }

        public JZcmdDataAccess new_loader() {
            return new JZcmdDataAccess();
        }

        public void add_loader(JZcmdDataAccess jZcmdDataAccess) {
            this.loader = jZcmdDataAccess;
        }
    }

    public static class DefListElement
    extends DefVariable {
        DefListElement() {
            super(null, '\u0000');
        }

        public StatementList new_dataSet() {
            this.elementType = (char)42;
            this.statementlist = new StatementList(this);
            return this.statementlist;
        }

        public void add_dataSet(StatementList statementList) {
        }

        public DefVariable XXXnew_textVariable() {
            this.elementType = (char)83;
            return this;
        }

        public void XXXadd_textVariable(DefVariable defVariable) {
        }

        public void XXXset_elementText(String string) {
        }
    }

    public static class DefContainerVariable
    extends DefVariable {
        public String keyVariableName;
        boolean bFirst = true;

        DefContainerVariable(StatementList statementList, char c) {
            super(statementList, c);
        }

        public DefListElement new_element() {
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            return new DefListElement();
        }

        public void add_element(DefListElement defListElement) {
            this.statementlist.statementsAdd.add(defListElement);
        }

        public DefVariable new_textVariable() {
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            return new DefVariable(this.parentList, 'S');
        }

        public void add_textVariable(DefVariable defVariable) {
            this.statementlist.statementsAdd.add(defVariable);
        }

        public DefVariable XXXnew_DefSubtext() {
            return new DefVariable(this.statementlist, '\u0000');
        }

        public void XXXadd_DefSubtext(DefVariable defVariable) {
            defVariable.elementType = defVariable.statementlist != null ? (char)123 : (char)79;
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            this.statementlist.statementsAdd.add(defVariable);
        }

        public Subroutine new_DefSubtext() {
            StatementList statementList = this.parentList;
            while (statementList != null && !(statementList instanceof JZcmdClass)) {
                statementList = statementList.parentStatement.parentList;
            }
            JZcmdClass jZcmdClass = statementList == null ? null : (JZcmdClass)statementList;
            return new Subroutine(jZcmdClass);
        }

        public void add_DefSubtext(Subroutine subroutine) {
            subroutine.elementType = subroutine.statementlist != null ? (char)123 : (char)79;
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            this.statementlist.statementsAdd.add(subroutine);
        }

        public JZcmditem new_objElement() {
            JZcmditem jZcmditem;
            if (this.bFirst && this.isEmpty()) {
                return this;
            }
            if (this.bFirst) {
                this.bFirst = false;
                jZcmditem = new JZcmditem(this.statementlist, '\u0000');
                jZcmditem.dataAccess = this.dataAccess;
                this.dataAccess = null;
                jZcmditem.textArg = this.textArg;
                this.textArg = null;
                jZcmditem.expression = this.expression;
                this.expression = null;
                jZcmditem.statementlist = this.statementlist;
                this.statementlist = new StatementList(this);
                this.statementlist.statementsAdd.add(jZcmditem);
            }
            jZcmditem = new JZcmditem(this.statementlist, '\u0000');
            return jZcmditem;
        }

        public void add_objElement(JZcmditem jZcmditem) {
            if (jZcmditem != this) {
                this.statementlist.statementsAdd.add(jZcmditem);
            }
        }
    }

    public static class DefVariable
    extends JZcmditem {
        public DataAccess defVariable;
        String typeVariable;
        boolean bConst;
        boolean bAppendToFile;

        DefVariable(StatementList statementList, char c) {
            super(statementList, c);
        }

        public void set_const() {
            this.bConst = true;
        }

        public void set_appendToFile() {
            this.bAppendToFile = true;
        }

        public void set_type(String string) {
            this.typeVariable = string;
        }

        public void set_name(String string) {
        }

        public JZcmdDataAccess new_defVariable() {
            return new JZcmdDataAccess();
        }

        public void add_defVariable(JZcmdDataAccess jZcmdDataAccess) {
            int n = "SPULOKQWMCJFG*{[\u0000".indexOf(this.elementType);
            char c = "SPULOKQAMCJFG*X[\u0000".charAt(n);
            if (this.bConst) {
                c = Character.toLowerCase(c);
            }
            jZcmdDataAccess.setTypeToLastElement(c);
            this.defVariable = jZcmdDataAccess;
        }

        public String getVariableIdent() {
            List<DataAccess.DatapathElement> list = this.defVariable.datapath();
            int n = list.size();
            String string = list == null || n == 0 ? null : (list.size() == 1 ? this.defVariable.datapath().get(0).ident() : null);
            return string;
        }

        @Override
        void writeStructLine(Appendable appendable) {
            super.writeStructLine(appendable);
            try {
                appendable.append(" Defvariable ").append(this.defVariable != null ? this.defVariable.toString() : "no_Variable");
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static class DataText
    extends JZcmditem {
        public String format;
        public String errorText;

        public DataText(StatementList statementList) {
            super(statementList, 'e');
        }

        public void set_formatText(String string) {
            this.format = string;
        }

        public void set_errorText(String string) {
            this.errorText = string;
        }
    }

    public static class AccessFilesetname
    extends JZcmditem {
        String XXXfilesetVariableName;
        JZcmdDataAccess filesetVariable;

        public AccessFilesetname(StatementList statementList) {
            super(statementList, 'G');
        }

        public void set_accessPath(String string) {
            this.textArg = string;
        }

        public void XXXset_zmakeFilesetVariable(String string) {
            if (this.XXXfilesetVariableName != null) {
                this.textArg = "&" + this.XXXfilesetVariableName;
            }
            this.XXXfilesetVariableName = string;
        }

        public JZcmdDataAccess new_zmakeFilesetVariable() {
            return new JZcmdDataAccess();
        }

        public void add_zmakeFilesetVariable(JZcmdDataAccess jZcmdDataAccess) {
            this.filesetVariable = jZcmdDataAccess;
        }
    }

    public static class Zmake
    extends CallStatement {
        JZcmditem jzoutput;
        String name;
        List<AccessFilesetname> input = new ArrayList<AccessFilesetname>();

        Zmake(StatementList statementList) {
            super(statementList, 'Z');
        }

        public void set_name(String string) {
            this.name = string;
        }

        public JZcmditem new_zmakeOutput() {
            return new JZcmditem(this.parentList, '.');
        }

        public void add_zmakeOutput(JZcmditem jZcmditem) {
            this.jzoutput = jZcmditem;
        }

        @Override
        public AccessFilesetname new_filesetAccess() {
            return new AccessFilesetname(this.parentList);
        }

        @Override
        public void add_filesetAccess(AccessFilesetname accessFilesetname) {
            this.input.add(accessFilesetname);
        }
    }

    public static class DefFilepath
    extends DefVariable {
        FilePath filepath;

        DefFilepath(StatementList statementList) {
            super(statementList, 'F');
        }
    }

    public static class UserFileset
    extends DefVariable {
        final JZtxtcmdScript script;
        public final FileSet fileset = new FileSet();

        UserFileset(StatementList statementList, JZtxtcmdScript jZtxtcmdScript) {
            super(statementList, 'G');
            this.script = jZtxtcmdScript;
        }

        public UserFileset(StatementList statementList) {
            super(statementList, 'G');
            this.script = null;
        }

        @Override
        public void set_name(String string) {
            JZcmdDataAccess jZcmdDataAccess;
            this.dataAccess = jZcmdDataAccess = new JZcmdDataAccess();
            jZcmdDataAccess.set_startVariable(string);
        }

        public void set_commonPath(String string) {
            this.fileset.set_commonPath(string);
        }

        public void set_filePath(String string) {
            this.fileset.add_filePath(string);
        }

        public void add_addFileset(String string) {
        }
    }

    public static class JZcmdInstanceofExpr {
    }

    public static class JZcmdCalculatorExpr
    extends CalculatorExpr.SetExprBase.SetExpr
    implements GetTypeToUse {
        JZcmdCalculatorExpr(Object object) {
            super(new CalculatorExpr.SetExprBase(true, object));
        }

        @Override
        public Class<?> getTypeToUse() {
            return JZcmdCalculatorExpr.class;
        }

        @Override
        public JZcmdDataAccess new_dataAccess() {
            return (JZcmdDataAccess)super.new_dataAccess();
        }

        public void add_dataAccess(JZcmdDataAccess jZcmdDataAccess) {
        }

        @Override
        protected JZcmdDataAccess newDataAccessSet() {
            return new JZcmdDataAccess();
        }

        public JZcmdInstanceofExpr new_instanceof() {
            return new JZcmdInstanceofExpr();
        }

        public void add_instanceof(JZcmdInstanceofExpr jZcmdInstanceofExpr) {
        }
    }

    public static class JZcmdDatapathElementClass
    extends DataAccess.DatapathElementClass
    implements GetTypeToUse {
        JZcmdDataAccess dpathLoader;
        protected List<JZcmditem> fnArgsExpr;
        protected JZcmdDataAccess dpathClass;

        @Override
        public Class<?> getTypeToUse() {
            return JZcmdDatapathElementClass.class;
        }

        public JZcmditem new_argument() {
            return new JZcmditem(null, 'A');
        }

        public void add_argument(JZcmditem jZcmditem) {
            if (this.fnArgsExpr == null) {
                this.fnArgsExpr = new ArrayList<JZcmditem>();
            }
            this.fnArgsExpr.add(jZcmditem);
        }

        public JZcmdDataAccess new_Class_Var() {
            return new JZcmdDataAccess();
        }

        public void add_Class_Var(JZcmdDataAccess jZcmdDataAccess) {
            this.dpathClass = jZcmdDataAccess;
        }

        public JZcmdDataAccess new_Classpath_Var() {
            return new JZcmdDataAccess();
        }

        public void add_Classpath_Var(JZcmdDataAccess jZcmdDataAccess) {
            this.dpathLoader = jZcmdDataAccess;
        }
    }

    public static class JZcmdDatapathElement
    extends DataAccess.SetDatapathElement
    implements GetTypeToUse {
        protected List<JZcmditem> fnArgsExpr;
        protected JZcmdDataAccess indirectDatapath;

        @Override
        public Class<?> getTypeToUse() {
            return JZcmdDatapathElement.class;
        }

        public JZcmditem new_argument() {
            return new JZcmditem(null, 'A');
        }

        public void add_argument(JZcmditem jZcmditem) {
            if (this.fnArgsExpr == null) {
                this.fnArgsExpr = new ArrayList<JZcmditem>();
            }
            this.fnArgsExpr.add(jZcmditem);
        }

        public JZcmdDataAccess new_dataPath() {
            return new JZcmdDataAccess();
        }

        public void add_dataPath(JZcmdDataAccess jZcmdDataAccess) {
            this.indirectDatapath = jZcmdDataAccess;
        }

        public void writeStruct(int n, Appendable appendable) throws IOException {
            appendable.append(this.ident).append(':').append(this.whatisit);
            if (this.fnArgsExpr != null) {
                for (JZcmditem jZcmditem : this.fnArgsExpr) {
                    jZcmditem.writeStruct(n + 1, appendable);
                }
            }
        }
    }

    public static class JZcmdDataAccess
    extends DataAccess.DataAccessSet
    implements GetTypeToUse {
        @Override
        public Class<?> getTypeToUse() {
            return JZcmdDataAccess.class;
        }

        public JZcmditem new_File() {
            return new JZcmditem(null, 'A');
        }

        public void set_File(JZcmditem jZcmditem) {
            JZcmdDatapathElementClass jZcmdDatapathElementClass = new JZcmdDatapathElementClass();
            jZcmdDatapathElementClass.set_Class(File.class);
            jZcmdDatapathElementClass.set_whatisit("+");
            jZcmditem.conversion = (char)126;
            jZcmdDatapathElementClass.add_argument(jZcmditem);
            this.add_newJavaClass(jZcmdDatapathElementClass);
        }

        @Override
        public DataAccess.SetDatapathElement new_startDatapath() {
            return new JZcmdDatapathElement();
        }

        @Override
        public final JZcmdDatapathElement new_datapathElement() {
            return new JZcmdDatapathElement();
        }

        public final void add_datapathElement(JZcmdDatapathElement jZcmdDatapathElement) {
            super.add_datapathElement(jZcmdDatapathElement);
        }

        @Override
        public final JZcmdDatapathElementClass newDatapathElementClass() {
            return new JZcmdDatapathElementClass();
        }
    }

    public static class Argument
    extends JZcmditem {
        public String identArgJbat;

        public Argument(StatementList statementList) {
            super(statementList, '.');
        }

        public void set_name(String string) {
            this.identArgJbat = string;
        }

        public String getIdent() {
            return this.identArgJbat;
        }
    }

    public static class JZcmditem
    implements SetLineColumn_ifc {
        protected char elementType;
        protected char conversion = '\u0000';
        int srcLine;
        int srcColumn;
        String srcFile = "";
        final StatementList parentList;
        public StatementList statementlist;
        public JZcmdDataAccess dataAccess;
        public CalculatorExpr expression;
        JZcmditem subitem;
        public String textArg;
        static String sindentA = "                                                                               ";

        JZcmditem(StatementList statementList, char c) {
            if (statementList == null) {
                Debugutil.stop();
            }
            this.parentList = statementList;
            this.elementType = c;
        }

        @Override
        public void setLineColumnFile(int n, int n2, String string) {
            if (this.srcFile != null && !this.srcFile.equals("")) {
                Debugutil.stop();
            }
            this.srcLine = n;
            this.srcColumn = n2;
            this.srcFile = string;
        }

        @Override
        public int setLineColumnFileMode() {
            return 7;
        }

        char elementType() {
            return this.elementType;
        }

        public StatementList statementlist() {
            return this.statementlist;
        }

        private void checkEmpty() {
            if (!this.isEmpty()) {
                throw new IllegalArgumentException("JZcmdItem with more as one content type.");
            }
        }

        protected boolean isEmpty() {
            return this.statementlist == null && this.dataAccess == null && this.expression == null && this.textArg == null;
        }

        public JZcmdDataAccess new_dataAccess() {
            this.checkEmpty();
            return new JZcmdDataAccess();
        }

        public void add_dataAccess(JZcmdDataAccess jZcmdDataAccess) {
            this.dataAccess = jZcmdDataAccess;
        }

        public void set_plainText(String string) {
            if (string.length() > 0) {
                this.set_text(string);
            }
        }

        public void set_text(String string) {
            CharSequence charSequence;
            this.checkEmpty();
            if (string.contains("\n=")) {
                StringBuilder stringBuilder = new StringBuilder(string);
                charSequence = stringBuilder;
                int n = 0;
                while ((n = stringBuilder.indexOf("\n=", n)) >= 0) {
                    stringBuilder.replace(n + 1, n + 2, "");
                }
            } else {
                charSequence = string;
            }
            this.textArg = charSequence.toString();
        }

        public StatementList new_dataStruct() {
            this.checkEmpty();
            this.statementlist = new StatementList(this);
            if (this.elementType != 'M') {
                this.elementType = (char)77;
            }
            return this.statementlist;
        }

        public void add_dataStruct(StatementList statementList) {
        }

        public StatementList new_statementBlock() {
            this.checkEmpty();
            this.statementlist = new StatementList(this);
            return this.statementlist;
        }

        public void add_statementBlock(StatementList statementList) {
        }

        public StatementList new_textExpr(ZbnfParseResultItem zbnfParseResultItem) {
            int n;
            String string;
            if (this.statementlist == null) {
                this.statementlist = new StatementList(this);
            }
            if ((string = zbnfParseResultItem.syntaxItem().getAttribute("indent")) != null && string.length() > 0) {
                try {
                    int n2;
                    if (string.charAt(0) == '-') {
                        n2 = Integer.parseInt(string.substring(1));
                        n = zbnfParseResultItem.getInputColumn() - 1 - n2;
                    }
                    if (string.charAt(0) == '+') {
                        n2 = Integer.parseInt(string.substring(1));
                        n = zbnfParseResultItem.getInputColumn() - 1 + n2;
                    }
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException("faulty number for indentdiff", numberFormatException);
                }
            } else {
                n = this.statementlist.parentStatement.statementlist.nIndentInScript;
            }
            this.statementlist.nIndentInScript = n;
            String string2 = zbnfParseResultItem.syntaxItem().getAttribute("skipFirstnl");
            if (string2 != null) {
                this.statementlist.bSetSkipSpaces = true;
            }
            return this.statementlist;
        }

        public void add_textExpr(StatementList statementList) {
        }

        public JZcmdCalculatorExpr new_numExpr() {
            this.checkEmpty();
            return new JZcmdCalculatorExpr(this);
        }

        public void add_numExpr(JZcmdCalculatorExpr jZcmdCalculatorExpr) {
            DataAccess dataAccess = jZcmdCalculatorExpr.onlyDataAccess();
            if (dataAccess != null) {
                this.dataAccess = (JZcmdDataAccess)dataAccess;
            } else {
                jZcmdCalculatorExpr.closeExprPreparation();
                this.expression = jZcmdCalculatorExpr.expr();
            }
        }

        public JZcmdCalculatorExpr new_boolExpr() {
            this.checkEmpty();
            return new JZcmdCalculatorExpr(this);
        }

        public void add_boolExpr(JZcmdCalculatorExpr jZcmdCalculatorExpr) {
            DataAccess dataAccess = jZcmdCalculatorExpr.onlyDataAccess();
            if (dataAccess != null) {
                this.dataAccess = (JZcmdDataAccess)dataAccess;
            } else {
                jZcmdCalculatorExpr.closeExprPreparation();
                this.expression = jZcmdCalculatorExpr.expr();
            }
        }

        public JZcmditem XXXnew_File() {
            this.conversion = (char)69;
            return this;
        }

        public void XXXadd_File(JZcmditem jZcmditem) {
        }

        public JZcmditem new_Filepath() {
            this.conversion = (char)70;
            return this;
        }

        public void add_Filepath(JZcmditem jZcmditem) {
        }

        public AccessFilesetname new_filesetAccess() {
            return new AccessFilesetname(this.parentList);
        }

        public void add_filesetAccess(AccessFilesetname accessFilesetname) {
            this.conversion = (char)71;
            this.subitem = accessFilesetname;
        }

        public ScriptException scriptException(String string) {
            return new ScriptException(string, this.srcFile, this.srcLine, this.srcColumn);
        }

        final void writeStruct(int n, Appendable appendable) throws IOException {
            String string = 2 * n < sindentA.length() - 2 ? sindentA.substring(0, 2 * n) : sindentA;
            appendable.append(string);
            this.writeStructLine(appendable);
            this.writeStructAdd(n, appendable);
            if (this.textArg != null) {
                appendable.append("\"").append(this.textArg).append("\"");
            }
            if (this.dataAccess != null) {
                this.dataAccess.writeStruct(appendable);
            }
            if (this.expression != null) {
                String string2 = this.expression.toString();
                appendable.append(string2);
            }
            appendable.append("\n");
            if (this.statementlist != null) {
                for (JZcmditem jZcmditem : this.statementlist.statements) {
                    jZcmditem.writeStruct(n + 1, appendable);
                }
            }
        }

        void writeStructAdd(int n, Appendable appendable) throws IOException {
        }

        void writeStructLine(Appendable appendable) {
            try {
                switch (this.elementType) {
                    case 't': {
                        appendable.append(" text \"").append(this.textArg).append("\"");
                        break;
                    }
                    case 'e': {
                        appendable.append(" <*)");
                        break;
                    }
                    case 'B': {
                        appendable.append(" { statementblock }");
                        break;
                    }
                    case 'D': {
                        appendable.append(" debug");
                        break;
                    }
                    case 'E': {
                        appendable.append(" else ");
                        break;
                    }
                    case 'F': {
                        appendable.append(" Filepath ");
                        break;
                    }
                    case 'G': {
                        appendable.append(" Fileset ");
                        break;
                    }
                    case 'H': {
                        appendable.append(" debugOp");
                        break;
                    }
                    case 'I': {
                        appendable.append(" (?forInput?)...(/?)");
                        break;
                    }
                    case 'M': {
                        appendable.append(" Map ");
                        break;
                    }
                    case 'N': {
                        appendable.append(" <:hasNext> content <.hasNext>");
                        break;
                    }
                    case 'O': {
                        appendable.append(" Obj");
                        break;
                    }
                    case 'L': {
                        appendable.append(" List");
                        break;
                    }
                    case 'W': {
                        appendable.append(" Openfile");
                        break;
                    }
                    case 'Z': {
                        appendable.append(" zmake");
                        break;
                    }
                    case 'Y': {
                        appendable.append(" <:file> ");
                        break;
                    }
                    case 'b': {
                        appendable.append(" break; ");
                        break;
                    }
                    case 'c': {
                        appendable.append(" cmd ");
                        break;
                    }
                    case 'd': {
                        appendable.append(" cd ");
                        break;
                    }
                    case 'f': {
                        appendable.append(" for ");
                        break;
                    }
                    case 'g': {
                        appendable.append(" elsif ");
                        break;
                    }
                    case 'i': {
                        appendable.append(" if ");
                        break;
                    }
                    case 'm': {
                        appendable.append(" move ");
                        break;
                    }
                    case 'n': {
                        appendable.append(" newline ");
                        break;
                    }
                    case 'o': {
                        appendable.append(" createTextOut ");
                        break;
                    }
                    case 'q': {
                        appendable.append(" appendTextOut ");
                        break;
                    }
                    case 'r': {
                        appendable.append(" throw ");
                        break;
                    }
                    case 's': {
                        appendable.append(" call ");
                        break;
                    }
                    case 'v': {
                        appendable.append(" throw on error ");
                        break;
                    }
                    case 'w': {
                        appendable.append(" while ");
                        break;
                    }
                    case 'x': {
                        appendable.append(" thread ");
                        break;
                    }
                    case 'y': {
                        appendable.append(" copy ");
                        break;
                    }
                    case 'z': {
                        appendable.append(" exit ");
                        break;
                    }
                    case '9': {
                        appendable.append(" mkdir ");
                        break;
                    }
                    case ':': {
                        appendable.append(" <:> ... <.>");
                        break;
                    }
                    case '!': {
                        appendable.append(" flush ");
                        break;
                    }
                    case '{': {
                        appendable.append(" statements ");
                        break;
                    }
                    case '[': {
                        appendable.append(" List-container ");
                        break;
                    }
                    case '*': {
                        appendable.append(" Map-container ");
                        break;
                    }
                    case '_': {
                        appendable.append(" close ");
                        break;
                    }
                    case ' ': {
                        appendable.append(" skipWhitespace ");
                        break;
                    }
                    case ',': {
                        appendable.append(" errortoOutput ");
                        if (this.textArg != null) break;
                        appendable.append("off ");
                        break;
                    }
                }
                appendable.append(" @").append(Integer.toString(this.srcLine)).append(",").append(Integer.toString(this.srcColumn)).append(':');
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.writeStructLine(stringBuilder);
            return stringBuilder.toString();
        }
    }

    public static class JZscriptSettings {
        String sLinefeed = "\r\n";
        int srcTabsize = 8;
    }

    public static interface AddSub2List {
        public void clear();

        public void add2List(Subroutine var1, int var2);

        public void add2List(JZcmdClass var1, int var2);
    }
}

