/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zbnf.ebnfConvert;

import java.io.IOException;
import java.util.Map;
import org.vishia.util.Debugutil;
import org.vishia.zbnf.ebnfConvert.EBNFread;

public class EBNFconvert {
    public static final String sVersion = "2019-05-16";
    Map<String, EBNFread.EBNFdef> idx_cmpnDef;

    public void convert(EBNFread eBNFread, Appendable appendable) {
        this.idx_cmpnDef = eBNFread.idx_cmpnDef;
        this.checkAllCmpn(eBNFread);
        if (appendable != null) {
            try {
                for (EBNFread.EBNFdef eBNFdef : eBNFread.list_cmpnDef) {
                    if (eBNFdef.cmpnRepl != null || eBNFdef.zbnfBasic != null) {
                        Debugutil.stop();
                        continue;
                    }
                    if (eBNFdef.items == null) {
                        appendable.append("## ").append(eBNFdef.cmpnName).append("::= ... ").append(eBNFdef.comment).append("\n\n");
                        continue;
                    }
                    appendable.append(eBNFdef.cmpnName).append("::=");
                    if (eBNFdef.bOnlyText) {
                        appendable.append("<?>");
                    }
                    if (eBNFdef.cmpnName.equals("event_conn_source")) {
                        Debugutil.stop();
                    }
                    this.convertExpr(appendable, eBNFdef, 1);
                    appendable.append(".\n\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkAllCmpn(EBNFread eBNFread) {
        for (EBNFread.EBNFdef eBNFdef : eBNFread.list_cmpnDef) {
            if (eBNFdef.cmpnName.equals("algorithm_name")) {
                Debugutil.stop();
            }
            if (eBNFdef.bChecked) continue;
            this.checkCmpn(eBNFdef);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkCmpn(EBNFread.EBNFdef var1_1) {
        block4: {
            if (var1_1.cmpnName.equals("subscript")) {
                Debugutil.stop();
            }
            var1_1.bChecked = true;
            if (var1_1.zbnfBasic != null) break block4;
            var1_1.bChecking = true;
            var1_1.bOnlyText = true;
            var1_1.nrCmpn = 0;
            if (var1_1.items == null) break block4;
            if (var1_1.items.size() != 1) ** GOTO lbl-1000
            var2_2 = (EBNFread.EBNFitem)var1_1.items.get(0);
            if (var2_2.what == '<') {
                var1_1.cmpnRepl = var3_3 = this.idx_cmpnDef.get(var2_2.cmpn);
                var1_1.bOnlyText = false;
            } else lbl-1000:
            // 2 sources

            {
                if (var1_1.cmpnName.equals("signed_integer_type_name")) {
                    Debugutil.stop();
                }
                this.checkExpr(var1_1, var1_1, 0);
            }
        }
        var1_1.bChecking = false;
    }

    void checkExpr(EBNFread.EBNFexpr eBNFexpr, EBNFread.EBNFdef eBNFdef, int n) {
        if (n > 100) {
            throw new IllegalArgumentException("too many recursions");
        }
        for (EBNFread.EBNFitem eBNFitem : eBNFexpr.items) {
            this.checkitem(eBNFitem, eBNFdef, n);
        }
    }

    void checkitem(EBNFread.EBNFitem eBNFitem, EBNFread.EBNFdef eBNFdef, int n) {
        if (eBNFitem.what == '|') {
            if (n == 0 && eBNFdef.nrCmpn <= 1) {
                eBNFdef.nrCmpn = 0;
            }
        } else {
            boolean bl = false;
            if (eBNFitem.what == '<') {
                EBNFread.EBNFdef eBNFdef2;
                ++eBNFdef.nrCmpn;
                if (eBNFitem.cmpn.equals("resource_type_name")) {
                    Debugutil.stop();
                }
                if ((eBNFdef2 = this.idx_cmpnDef.get(eBNFitem.cmpn)) != null && !eBNFdef2.bChecked) {
                    this.checkCmpn(eBNFdef2);
                }
                if (eBNFdef2 != null && eBNFdef2.bChecking && eBNFdef2.bOnlyText) {
                    Debugutil.stop();
                    bl = false;
                } else {
                    boolean bl2 = bl = eBNFdef2 != null && eBNFdef2.bOnlyText;
                }
            }
            if (eBNFitem.what == '<' && !bl) {
                eBNFdef.bOnlyText = false;
            }
            if ("#".indexOf(eBNFitem.what) >= 0) {
                eBNFdef.bOnlyText = false;
            }
        }
        if (eBNFitem instanceof EBNFread.EBNFexpr) {
            this.checkExpr((EBNFread.EBNFexpr)eBNFitem, eBNFdef, n + 1);
        }
    }

    private void convertExpr(Appendable appendable, EBNFread.EBNFexpr eBNFexpr, int n) throws IOException {
        if (n >= 2 && eBNFexpr.hasAlternatives) {
            appendable.append("[");
        }
        String string = null;
        boolean bl = eBNFexpr.cmpnDef.nrCmpn <= 1;
        for (EBNFread.EBNFitem eBNFitem : eBNFexpr.items) {
            string = this.convertItem(appendable, string, eBNFitem, eBNFexpr.cmpnDef, bl, n);
        }
        this.wrCmpnCall(appendable, string, bl, eBNFexpr.cmpnDef);
        if (n >= 2 && eBNFexpr.hasAlternatives) {
            appendable.append("]");
        }
    }

    private String convertItem(Appendable appendable, String string, EBNFread.EBNFitem eBNFitem, EBNFread.EBNFdef eBNFdef, boolean bl, int n) throws IOException {
        String string2 = null;
        switch (eBNFitem.what) {
            case '[': {
                EBNFread.EBNFexpr eBNFexpr = (EBNFread.EBNFexpr)eBNFitem;
                this.wrCmpnCall(appendable, string, bl, eBNFdef);
                appendable.append(" [");
                if (eBNFexpr.bOnlyTextInExpr) {
                    appendable.append("<?").append("text").append('>');
                }
                this.convertExpr(appendable, eBNFexpr, n + 1);
                appendable.append(" ]");
                break;
            }
            case '|': {
                this.wrCmpnCall(appendable, string, bl, eBNFdef);
                if (n < 2) {
                    appendable.append("\n |");
                } else {
                    appendable.append(" |");
                }
                this.convertExpr(appendable, (EBNFread.EBNFexpr)eBNFitem, n + 1);
                break;
            }
            case '{': {
                this.checkRepetition(appendable, string, (EBNFread.EBNFexpr)eBNFitem, bl, n + 1);
                break;
            }
            case '<': {
                this.wrCmpnCall(appendable, string, bl, eBNFdef);
                string2 = eBNFitem.cmpn;
                break;
            }
            case '\"': {
                this.wrCmpnCall(appendable, string, bl, eBNFdef);
                int n2 = 0;
                appendable.append(' ');
                while (n2 < eBNFitem.literal.length()) {
                    char c;
                    if ("[]{}<>.?\\".indexOf(c = eBNFitem.literal.charAt(n2++)) >= 0) {
                        appendable.append('\\');
                    }
                    appendable.append(c);
                }
                break;
            }
            case '#': {
                this.wrCmpnCall(appendable, string, bl, eBNFdef);
                appendable.append("    ##").append(eBNFitem.comment).append("\n    ");
                break;
            }
            case '(': {
                this.wrCmpnCall(appendable, string, bl, eBNFdef);
                this.convertExpr(appendable, (EBNFread.EBNFexpr)eBNFitem, n + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type of EBNFitem: " + eBNFitem.what);
            }
        }
        return string2;
    }

    private void wrCmpnCall(Appendable appendable, String string, boolean bl, EBNFread.EBNFdef eBNFdef) throws IOException {
        EBNFread.EBNFdef eBNFdef2;
        if (string == null) {
            return;
        }
        if (string.equals("integer")) {
            Debugutil.stop();
        }
        EBNFread.EBNFdef eBNFdef3 = eBNFdef2 = this.idx_cmpnDef.get(string);
        if (eBNFdef2 != null && eBNFdef2.cmpn != null && eBNFdef2.cmpn.equals("integer")) {
            Debugutil.stop();
        }
        while (eBNFdef3 != null && eBNFdef3.cmpnRepl != null) {
            eBNFdef3 = eBNFdef3.cmpnRepl;
        }
        boolean bl2 = eBNFdef2 == null || eBNFdef2.cmpnRepl != null ? false : (eBNFdef.bOnlyText && eBNFdef2.bOnlyText ? false : eBNFdef2.bOnlyText);
        appendable.append(" <");
        if (eBNFdef3 != null && eBNFdef3.zbnfBasic != null) {
            appendable.append(eBNFdef3.zbnfBasic).append("?");
            if (eBNFdef3.zbnfBasic.equals("#")) {
                Debugutil.stop();
            }
            if (eBNFdef3.zbnfBasic.equals("$")) {
                Debugutil.stop();
            }
        } else if (eBNFdef3 != eBNFdef2) {
            String string2 = eBNFdef3.cmpnName;
            appendable.append(string2).append("?");
            if (bl2) {
                appendable.append("\"!\"");
                bl2 = false;
            }
        }
        appendable.append(string);
        if (bl2) {
            appendable.append("?\"!\"@");
        }
        if (eBNFdef2 != null && eBNFdef2.nrCmpn <= 1 && eBNFdef2.cmpnRepl == null && eBNFdef3.zbnfBasic == null && !eBNFdef2.bOnlyText) {
            appendable.append("?");
        }
        appendable.append('>');
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkRepetition(Appendable appendable, String string, EBNFread.EBNFexpr eBNFexpr, boolean bl, int n) throws IOException {
        int n2 = eBNFexpr.items.size();
        if (n2 >= 1) {
            EBNFread.EBNFitem eBNFitem = eBNFexpr.items.get(n2 - 1);
            if (eBNFitem.what == '<' && eBNFitem.cmpn.equals(string)) {
                appendable.append(" {");
                this.wrCmpnCall(appendable, string, bl, eBNFexpr.cmpnDef);
                if (n2 > 1) {
                    appendable.append(" ? ");
                    String string2 = null;
                    for (int i = 0; i < n2 - 1; ++i) {
                        EBNFread.EBNFitem eBNFitem2 = eBNFexpr.items.get(i);
                        string2 = this.convertItem(appendable, string2, eBNFitem2, eBNFexpr.cmpnDef, bl, n);
                    }
                    if (string2 != null) {
                        this.wrCmpnCall(appendable, string2, bl, eBNFexpr.cmpnDef);
                    }
                }
                appendable.append(" }");
                return;
            }
        }
        this.wrCmpnCall(appendable, string, bl, eBNFexpr.cmpnDef);
        appendable.append(" [{");
        this.convertExpr(appendable, eBNFexpr, n + 1);
        appendable.append(" }]");
    }
}

