/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlReader;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.xmlReader.XmlAddData_ifc;

public class XmlDataNode
implements XmlAddData_ifc {
    public static final String version = "2024-09-19";
    protected final XmlDataNode parent;
    public final String tag;
    public String text;
    public final Map<String, String> attribs;
    public final Map<String, XmlDataNode> singleNodes;
    public final Map<String, List<XmlDataNode>> multiNodes;
    public final List<XmlDataNode> allNodes;

    public XmlDataNode(XmlDataNode xmlDataNode, String string, Map<String, String> map) {
        this.parent = xmlDataNode;
        this.tag = string;
        this.attribs = map;
        this.allNodes = new LinkedList<XmlDataNode>();
        this.singleNodes = new TreeMap<String, XmlDataNode>();
        this.multiNodes = new TreeMap<String, List<XmlDataNode>>();
    }

    @Override
    public XmlAddData_ifc newNode(String string, Map<String, String> map) {
        return new XmlDataNode(this, string, map);
    }

    @Override
    public void addNode(XmlAddData_ifc xmlAddData_ifc) {
        Object object;
        XmlDataNode xmlDataNode = (XmlDataNode)xmlAddData_ifc;
        if (this.text != null) {
            object = new XmlDataNode(this, "$", null);
            ((XmlDataNode)object).text = this.text;
            this.text = null;
            this.addNode((XmlAddData_ifc)object);
        }
        this.allNodes.add(xmlDataNode);
        object = this.multiNodes.get(xmlDataNode.tag);
        if (object != null) {
            object.add(xmlDataNode);
        } else {
            XmlDataNode xmlDataNode2 = this.singleNodes.get(xmlDataNode.tag);
            if (xmlDataNode2 == null) {
                this.singleNodes.put(xmlDataNode.tag, xmlDataNode);
            } else {
                LinkedList<XmlDataNode> linkedList = new LinkedList<XmlDataNode>();
                linkedList.add(xmlDataNode2);
                linkedList.add(xmlDataNode);
                this.singleNodes.remove(xmlDataNode.tag);
                this.multiNodes.put(xmlDataNode.tag, linkedList);
            }
        }
    }

    @Override
    public void addText(String string) {
        if (this.allNodes.size() == 0) {
            this.text = string;
        } else {
            XmlDataNode xmlDataNode = new XmlDataNode(this, "$", null);
            xmlDataNode.text = string;
            this.addNode(xmlDataNode);
        }
    }

    public String getAttrib(String string) {
        return this.attribs == null ? null : this.attribs.get(string);
    }

    public XmlDataNode getFirstNode(String string) {
        List<XmlDataNode> list;
        XmlDataNode xmlDataNode;
        XmlDataNode xmlDataNode2 = xmlDataNode = this.singleNodes == null ? null : this.singleNodes.get(string);
        if (xmlDataNode == null && this.multiNodes != null && (list = this.multiNodes.get(string)) != null) {
            xmlDataNode = list.get(0);
        }
        return xmlDataNode;
    }

    public Iterable<XmlDataNode> iterNodes(String string) {
        List<XmlDataNode> list = this.multiNodes.get(string);
        if (list != null) {
            return list;
        }
        XmlDataNode xmlDataNode = this.singleNodes.get(string);
        return new OnlyOneNode(xmlDataNode);
    }

    public ListIterator<XmlDataNode> iterListNodes(String string) {
        List<XmlDataNode> list = this.multiNodes.get(string);
        if (list != null) {
            return list.listIterator();
        }
        XmlDataNode xmlDataNode = this.singleNodes.get(string);
        return new OnlyOneNode(xmlDataNode);
    }

    public String getText() {
        List<XmlDataNode> list;
        if (this.text != null) {
            assert (this.allNodes.size() == 0);
            return this.text;
        }
        if (this.singleNodes != null && (list = this.singleNodes.get("$")) != null) {
            return ((XmlDataNode)((Object)list)).getText();
        }
        if (this.multiNodes != null) {
            list = this.multiNodes.get("$");
            if (list != null) {
                String string = "";
                for (XmlDataNode xmlDataNode : list) {
                    string = string + xmlDataNode.getText();
                }
                return string;
            }
            return null;
        }
        return null;
    }

    public String getTextAllSubNodes() {
        if (this.text != null && this.allNodes.size() == 0) {
            return this.text;
        }
        if (this.text == null && this.allNodes.size() == 1) {
            return this.allNodes.get(0).getTextAllSubNodes();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.text != null) {
            stringBuilder.append(this.text);
        }
        for (XmlDataNode xmlDataNode : this.allNodes) {
            stringBuilder.append(xmlDataNode.getTextAllSubNodes());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "<" + this.tag + (this.text == null ? ">" : ">" + this.text);
    }

    class OnlyOneNode
    implements ListIterator<XmlDataNode>,
    Iterable<XmlDataNode> {
        private XmlDataNode nd;

        OnlyOneNode(XmlDataNode xmlDataNode2) {
            this.nd = xmlDataNode2;
        }

        @Override
        public boolean hasNext() {
            return this.nd != null;
        }

        @Override
        public XmlDataNode next() {
            XmlDataNode xmlDataNode = this.nd;
            this.nd = null;
            return xmlDataNode;
        }

        @Override
        public Iterator<XmlDataNode> iterator() {
            return this;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public XmlDataNode previous() {
            return null;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void set(XmlDataNode xmlDataNode) {
        }

        @Override
        public void add(XmlDataNode xmlDataNode) {
        }

        @Override
        public void remove() {
        }
    }
}

