/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.vishia.util.Java4C;
import org.vishia.util.StringFunctions_C;

public final class StringFormatter
implements Appendable,
Flushable,
StringFunctions_C.PrepareBufferPos {
    public static final String version = "2022-08-03";
    private static final byte mNrofBytesInWord = 31;
    private static final byte mBytesInWordBigEndian = 32;
    public static final short k1 = 1;
    public static final short k2right = 2;
    public static final short k2left = 34;
    public static final short k4right = 4;
    public static final short k4left = 36;
    public static final short k6right = 6;
    public static final short k6left = 38;
    public static final short k8right = 8;
    public static final short k8left = 40;
    private static final String spaces = "                                                                                                                                                ";
    protected final StringBuilder buffer;
    protected Appendable lineout;
    private final boolean bShouldLineoutClose;
    private char secondNewline = '\u0000';
    protected int pos_ = 0;
    protected int posLine_ = 0;
    private boolean bInsert = false;
    private String sNewline = "\n";
    private char cDecimalSeparator = (char)46;
    String sDatePrefixNewer = "";
    SimpleDateFormat dateFormatNewer = new SimpleDateFormat("?yy-MM-dd HH:mm:ss");
    String sDatePrefixToday = "today";
    SimpleDateFormat dateFormatToday = new SimpleDateFormat(" HH:mm:ss");
    String sDatePrefixYear = "";
    SimpleDateFormat dateFormatYear = new SimpleDateFormat("MMM-dd HH:mm:ss");
    String sDatePrefixOlder = "";
    SimpleDateFormat dateFormatOlder = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
    private final Appendable_Intern appendable = new Appendable_Intern();

    public StringFormatter() {
        this.buffer = new StringBuilder();
        this.lineout = null;
        this.bShouldLineoutClose = false;
    }

    public StringFormatter(Appendable appendable, boolean bl, String string, int n) {
        this.buffer = new StringBuilder(n);
        this.sNewline = string;
        this.lineout = appendable;
        this.bShouldLineoutClose = bl;
    }

    public StringFormatter(int n) {
        this.buffer = new StringBuilder(n);
        this.lineout = null;
        this.bShouldLineoutClose = false;
    }

    public StringFormatter(String string) {
        this.buffer = new StringBuilder(string);
        this.lineout = null;
        this.bShouldLineoutClose = false;
    }

    public StringFormatter(StringBuilder stringBuilder) {
        this.buffer = stringBuilder;
        this.lineout = null;
        this.bShouldLineoutClose = false;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public String getContent() {
        return this.buffer.toString();
    }

    public CharSequence getBuffer() {
        return this.buffer;
    }

    public void setDecimalSeparator(char c) {
        this.cDecimalSeparator = c;
    }

    public StringFormatter reset() {
        this.pos_ = 0;
        this.posLine_ = 0;
        this.buffer.setLength(this.pos_);
        return this;
    }

    public StringFormatter end() {
        this.pos_ = this.buffer.length() - this.posLine_;
        return this;
    }

    public StringFormatter pos(int n) {
        return this.pos(n, -1);
    }

    public StringFormatter pos(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative position not supported");
        }
        this.pos_ = n2 >= 0 && this.pos_ + n2 > n ? (this.pos_ += n2) : n;
        for (int i = this.buffer.length() - this.posLine_; i < this.pos_; ++i) {
            this.buffer.append(' ');
        }
        return this;
    }

    public int replaceHolder(String string, String string2) {
        return this.replace("<&" + string + ">", 0, string2);
    }

    public int replace(String string, int n, CharSequence charSequence) {
        int n2 = this.buffer.indexOf(string, n);
        if (n2 >= 0) {
            int n3 = charSequence.length();
            int n4 = n3 - string.length();
            if (n4 > 0) {
                this.buffer.insert(n2, spaces.substring(0, n4));
            } else if (n4 < 0) {
                this.buffer.delete(n2, n2 - n4);
            }
            for (int i = 0; i < n3; ++i) {
                this.buffer.setCharAt(n2 + i, charSequence.charAt(i));
            }
            if (this.pos_ > n2 + n3) {
                this.pos_ += n4;
            }
        }
        return n2;
    }

    public int length() {
        return this.buffer.length();
    }

    public int getPos() {
        return this.pos_;
    }

    @Override
    public int prepareBufferPos(int n) {
        int n2 = n;
        int n3 = this.pos_ + this.posLine_;
        if (this.bInsert && n3 < this.buffer.length()) {
            while (n2 > 0) {
                if (n2 >= spaces.length()) {
                    this.buffer.insert(n3, spaces);
                    n2 -= spaces.length();
                    continue;
                }
                this.buffer.insert(n3, spaces, 0, n2);
                n2 = 0;
            }
        } else {
            int n4 = this.buffer.length() - n3;
            assert (n4 >= 0);
            n2 -= n4;
            while (n2 > 0) {
                if (n2 >= spaces.length()) {
                    this.buffer.append(spaces);
                    n2 -= spaces.length();
                    continue;
                }
                this.buffer.append(spaces, 0, n2);
                n2 = 0;
            }
        }
        return n3;
    }

    public StringFormatter add(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = this.prepareBufferPos(n);
        this.buffer.delete(n2, n2 + n);
        this.buffer.insert(n2, charSequence, 0, n);
        this.pos_ += n;
        return this;
    }

    public StringFormatter add(String string) {
        int n = string.length();
        int n2 = this.prepareBufferPos(n);
        this.buffer.delete(n2, n2 + n);
        this.buffer.insert(n2, string, 0, n);
        this.pos_ += n;
        return this;
    }

    public StringFormatter addReplaceLinefeed(CharSequence charSequence, CharSequence charSequence2, int n) {
        int n2 = n;
        if (n2 > charSequence.length()) {
            n2 = charSequence.length();
        }
        if (charSequence2.length() < 4) {
            throw new IllegalArgumentException("The argument replaceLinefeed should have 4 characters.");
        }
        int n3 = this.prepareBufferPos(n2);
        int n4 = -1;
        while (--n2 >= 0) {
            char c;
            int n5;
            if ((n5 = "\n\r\f".indexOf(c = charSequence.charAt(++n4))) >= 0) {
                c = charSequence2.charAt(n5);
            }
            if (c <= ' ') {
                c = charSequence2.charAt(3);
            }
            this.buffer.setCharAt(n3++, c);
            ++this.pos_;
        }
        return this;
    }

    public StringFormatter add(char c) {
        int n = this.prepareBufferPos(1);
        this.buffer.setCharAt(n, c);
        ++this.pos_;
        return this;
    }

    public StringFormatter add(char[] cArray) {
        int n;
        for (n = cArray.length; n > 1 && cArray[n - 1] == '\u0000'; --n) {
        }
        int n2 = this.prepareBufferPos(n);
        for (int i = 0; i < n; ++i) {
            this.buffer.setCharAt(n2++, cArray[i]);
            ++this.pos_;
        }
        return this;
    }

    public StringFormatter insert(String string) {
        int n = this.posLine_ + this.pos_;
        this.buffer.insert(n, string);
        this.pos_ += string.length();
        return this;
    }

    public StringFormatter overwrite() {
        this.bInsert = false;
        return this;
    }

    public StringFormatter insert() {
        this.bInsert = true;
        return this;
    }

    public boolean setInsertMode(boolean bl) {
        boolean bl2 = this.bInsert;
        this.bInsert = bl;
        return bl2;
    }

    public StringFormatter addStringLine(byte[] byArray, int n, int n2, String string) {
        String string2;
        int n3 = n2;
        if (n3 > byArray.length) {
            n3 = byArray.length;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        for (int i = 0; i < n3; ++i) {
            if (byArray2[i] >= 32) continue;
            byArray2[i] = 46;
        }
        try {
            string2 = new String(byArray2, 0, n3, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = "??encoding error??";
        }
        int n4 = string2.length();
        int n5 = this.prepareBufferPos(n4);
        this.buffer.replace(n5, n5 + n4, string2);
        this.pos_ += n4;
        return this;
    }

    public StringFormatter addHexLine(byte[] byArray, int n, int n2, short s) {
        int n3 = s & 0x1F;
        int n4 = n2 / n3;
        int n5 = this.prepareBufferPos(2 * n2 + n4);
        int n6 = n2;
        int n7 = n;
        while (n6 > 0) {
            if (n6 < n3) {
                this.addHexWord_(byArray, n7, (short)((s & 0x20) + n6));
                n6 = 0;
                continue;
            }
            this.addHexWord_(byArray, n7, s);
            this.buffer.setCharAt(this.pos_++, ' ');
            n6 -= n3;
            n7 += n3;
        }
        return this;
    }

    public void addHexBlock(byte[] byArray, int n, int n2, short s, short s2) throws IOException {
        int n3;
        int n4 = n;
        int n5 = n3 = n2 <= 0 ? byArray.length + n2 : n2;
        if (n3 > byArray.length) {
            n3 = byArray.length;
        }
        while (n4 < n3) {
            this.addHex(n4, 6).add(": ");
            this.addHexLine(byArray, n4, s, s2);
            this.newline();
            n4 += s;
        }
    }

    public StringFormatter addHexWord(byte[] byArray, int n, short s) {
        this.prepareBufferPos(2 * (s & 0x1F));
        return this.addHexWord_(byArray, n, s);
    }

    private StringFormatter addHexWord_(byte[] byArray, int n, short s) {
        int n2;
        int n3 = n;
        int n4 = s & 0x1F;
        if ((s & 0x20) != 0) {
            n2 = 1;
        } else {
            n2 = -1;
            n3 += n4 - 1;
        }
        while (--n4 >= 0 && n3 < byArray.length) {
            byte by = byArray[n3];
            n3 += n2;
            for (int i = 0; i < 2; ++i) {
                char c = (char)(((by & 0xF0) >> 4) + 48);
                if (c > '9') {
                    c = (char)(c + 97 - 57 - 1);
                }
                this.buffer.setCharAt(this.posLine_ + this.pos_++, c);
                by = (byte)(by << 4);
            }
        }
        return this;
    }

    public StringFormatter addHex(long l, int n) {
        block3: {
            int n2 = n;
            if (n2 < 0) {
                n2 = -n2;
            }
            this.prepareBufferPos(n2);
            try {
                StringFunctions_C.appendHex(this.appendable, l, n2);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return this;
    }

    public StringFormatter addBool(boolean bl, String string) {
        int n = this.prepareBufferPos(1);
        this.buffer.setCharAt(n, bl ? string.charAt(0) : string.charAt(1));
        ++this.pos_;
        return this;
    }

    public StringFormatter addBinary(int n, String string, String string2, String string3) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '1') continue;
            ++n3;
        }
        n2 = 1 << n3 - 1;
        int n4 = this.prepareBufferPos(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '1') {
                int n5 = n & n2;
                char c2 = n5 != 0 ? string3.charAt(i) : string2.charAt(i);
                this.buffer.setCharAt(n4, c2);
                n2 = n2 >> 1 & Integer.MAX_VALUE;
            } else {
                this.buffer.setCharAt(n4, c);
            }
            ++this.pos_;
        }
        return this;
    }

    public StringFormatter addHex44(long l) {
        this.addHex(l >> 16 & 0xFFFFL, 4);
        this.buffer.insert(this.pos_++, '\'');
        this.addHex(l & 0xFFFFL, 4);
        return this;
    }

    public StringFormatter addFloat(double d, int n, int n2) {
        double d2 = d;
        int n3 = n + n2 + 2;
        int n4 = this.prepareBufferPos(n3);
        if (d2 < 0.0) {
            this.buffer.setCharAt(n4++, '-');
            d2 = -d2;
        } else {
            this.buffer.setCharAt(n4++, ' ');
        }
        ++this.pos_;
        String string = Double.toString(d2);
        int n5 = string.indexOf(46);
        if (this.cDecimalSeparator != '.') {
            string = string.replace('.', this.cDecimalSeparator);
        }
        int n6 = n - n5;
        int n7 = n2 - (string.length() - n5 - 1);
        if (n7 < 0) {
            n7 = 0;
        }
        int n8 = n - n6 + 1 + n2 - n7;
        while (n6 > 0) {
            this.buffer.setCharAt(n4++, ' ');
            ++this.pos_;
            --n6;
        }
        if (n6 < 0) {
            n8 = n8 - -n6 - 2;
            this.buffer.replace(n4, n4 + 2, "##");
            this.pos_ += 2;
        }
        this.buffer.replace(n4, n4 + n8, string.substring(0, n8));
        this.pos_ += n8;
        while (--n7 >= 0) {
            this.buffer.setCharAt(n4++, '0');
            ++this.pos_;
        }
        return this;
    }

    public static String addHexLn(byte[] byArray, int n, int n2) {
        int n3 = n2;
        StringFormatter stringFormatter = new StringFormatter();
        String string = "";
        while (n3 < n2 + n) {
            int n4 = n3 + 32;
            if (n4 > n) {
                n4 = n2 + n;
            }
            stringFormatter.addHexLine(byArray, n3, n4 - n3, (short)4);
            stringFormatter.add(" ");
            stringFormatter.addStringLine(byArray, n3, n4 - n3, "ISO-8859-1");
            string = string + stringFormatter.getContent() + "\n";
            stringFormatter.reset();
            n3 = n4;
        }
        try {
            stringFormatter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public StringFormatter addDate(Date date, SimpleDateFormat simpleDateFormat) {
        String string = simpleDateFormat.format(date);
        this.add(string);
        return this;
    }

    public StringFormatter setAt(int n, char c) {
        this.buffer.setCharAt(n, c);
        return this;
    }

    public StringFormatter addint(long l, String string) {
        try {
            StringFunctions_C.strPicture(l, string, "+-..", '.', this);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        return this;
    }

    @Deprecated
    public StringFormatter addIntPicture(long l, String string) {
        return this.addint(l, string);
    }

    public int addFloatPicture(float f, String string) {
        long l;
        boolean bl;
        float f2 = f;
        String string2 = "afpnum.kMGT";
        int n = string2.indexOf(46);
        int n2 = Float.floatToRawIntBits(f2);
        byte by = (byte)(n2 >> 24 & 0x7F);
        if (by > 104) {
            f2 = 9.999999E17f;
        } else if (by < 24) {
            f2 = 0.0f;
        }
        boolean bl2 = n2 < 0;
        boolean bl3 = bl = (n2 & 0x7F800000) == 0;
        if (bl2) {
            f2 = -f2;
        }
        if (!bl) {
            while (f2 >= 1000.0f && n < string2.length() - 1) {
                f2 /= 1000.0f;
                ++n;
            }
            while (f2 < 1.0f && n > 0) {
                f2 *= 1000.0f;
                --n;
            }
            if (bl2) {
                f2 = -f2;
            }
            l = (long)f2;
        } else {
            l = 0L;
        }
        try {
            StringFunctions_C.strPicture(l, string, "+-.@", string2.charAt(n), this);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        return string.length();
    }

    @Java4C.Exclude
    public String convertTimestampToday(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        String string = l3 < -36000000L ? this.sDatePrefixNewer + this.dateFormatNewer.format(l) : (l3 < 64800000L ? this.sDatePrefixToday + this.dateFormatToday.format(l) : (l3 < 27648000000L ? this.sDatePrefixYear + this.dateFormatYear.format(l) : this.sDatePrefixOlder + this.dateFormatOlder.format(l)));
        return string;
    }

    @Override
    public StringFormatter append(CharSequence charSequence) throws IOException {
        this.append(charSequence, 0, charSequence.length());
        return this;
    }

    public void newline() throws IOException {
        this.append('\n');
    }

    @Override
    public StringFormatter append(char c) throws IOException {
        Appendable appendable = this.lineout;
        if (c == '\n' || c == '\r') {
            if (c != this.secondNewline || this.pos_ > 0) {
                if (this.sNewline == null) {
                    this.add(c);
                } else {
                    this.add(this.sNewline);
                }
                if (this.lineout != null) {
                    this.flushLine(null);
                } else {
                    this.posLine_ += this.pos_;
                    this.pos_ = 0;
                }
                this.secondNewline = (char)(c == '\r' ? 10 : 13);
            } else if (this.sNewline == null) {
                this.add(c);
                if (this.lineout != null) {
                    appendable.append(c);
                } else {
                    this.posLine_ += this.pos_;
                    this.pos_ = 0;
                }
            }
        } else {
            this.add(c);
        }
        return this;
    }

    @Override
    public StringFormatter append(CharSequence charSequence, int n, int n2) throws IOException {
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            this.append(c);
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.lineout != null) {
            this.lineout.append(this.buffer);
            if (this.lineout instanceof Flushable) {
                ((Flushable)((Object)this.lineout)).flush();
            }
        }
        this.reset();
    }

    public int flushLine(String string) throws IOException {
        if (this.lineout == null) {
            return 0;
        }
        Appendable appendable = this.lineout;
        int n = this.posLine_ + this.pos_;
        if (n > 0) {
            appendable.append(this.buffer, 0, n);
            this.buffer.setLength(0);
            this.posLine_ = 0;
            this.pos_ = 0;
        }
        if (string != null) {
            appendable.append(string);
        }
        return n;
    }

    public void close() throws IOException {
        if (this.lineout != null) {
            this.lineout.append(this.buffer);
            this.reset();
            if (this.bShouldLineoutClose && this.lineout instanceof Closeable) {
                ((Closeable)((Object)this.lineout)).close();
            }
            this.lineout = null;
        }
    }

    @Override
    public void addBufferPos(char c) throws IOException {
        this.buffer.setCharAt(this.posLine_ + this.pos_++, c);
    }

    private class Appendable_Intern
    implements Appendable {
        Appendable_Intern() {
        }

        @Override
        public Appendable append(CharSequence charSequence) throws IOException {
            assert (false);
            return null;
        }

        @Override
        public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
            assert (false);
            return null;
        }

        @Override
        public Appendable append(char c) throws IOException {
            StringFormatter stringFormatter = StringFormatter.this;
            StringFormatter.this.buffer.setCharAt(stringFormatter.posLine_ + stringFormatter.pos_, c);
            ++stringFormatter.pos_;
            return this;
        }
    }
}

