/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileLocalAccessor;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.vishia.event.EventWithDst;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.fileRemote.FileRemoteProgressEvData;
import org.vishia.fileRemote.FileRemoteWalker;
import org.vishia.fileRemote.FileRemoteWalkerCallback;
import org.vishia.util.FilepathFilterM;
import org.vishia.util.SortedTreeWalkerCallback;

public class FileCallbackLocalDelete
implements FileRemoteWalkerCallback {
    public static final String sVersion = "2023-07-15";
    private final EventWithDst<FileRemoteProgressEvData, ?> evBack;

    public FileCallbackLocalDelete(EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        this.evBack = eventWithDst;
    }

    @Override
    public void start(FileRemote fileRemote, FileRemoteCmdEventData fileRemoteCmdEventData) {
    }

    @Override
    public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote, Object object, Object object2) {
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
        block2: {
            try {
                Path path = (Path)object;
                Files.delete(path);
                fileRemote.internalAccess().setDeleted();
            }
            catch (IOException iOException) {
                if (this.evBack == null) break block2;
                FileRemoteProgressEvData fileRemoteProgressEvData = this.evBack.data();
                fileRemoteProgressEvData.currFile = fileRemote;
                fileRemoteProgressEvData.setDone(false, iOException.getMessage());
                fileRemoteProgressEvData.progressCmd = FileRemoteProgressEvData.ProgressCmd.error;
                this.evBack.sendEvent(this);
            }
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, Object object, Object object2) {
        block3: {
            FileRemoteWalker.WalkInfo walkInfo = (FileRemoteWalker.WalkInfo)object2;
            FilepathFilterM filepathFilterM = walkInfo.fileFilter;
            if (filepathFilterM.selAllDirEntries() && filepathFilterM.selAllFilesInDir()) {
                try {
                    Path path = (Path)object;
                    Files.delete(path);
                    fileRemote.internalAccess().setDeleted();
                }
                catch (IOException iOException) {
                    if (this.evBack == null) break block3;
                    FileRemoteProgressEvData fileRemoteProgressEvData = this.evBack.data();
                    fileRemoteProgressEvData.currFile = fileRemote;
                    fileRemoteProgressEvData.setDone(false, iOException.getMessage());
                    fileRemoteProgressEvData.progressCmd = FileRemoteProgressEvData.ProgressCmd.error;
                    this.evBack.sendEvent(this);
                }
            }
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public void finished(FileRemote fileRemote) {
    }

    @Override
    public boolean shouldAborted() {
        return false;
    }
}

