/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.communication;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SocketCommSimple {
    public static final String version = "2022-08-26";
    DatagramSocket so;
    SocketAddress ownAddr;
    SocketAddress dstAddr;

    InetAddress buildInetAddr(int n, int n2) {
        InetAddress inetAddress;
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 0 & 0xFF)};
        try {
            inetAddress = InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println(unknownHostException.getMessage());
            inetAddress = null;
        }
        return inetAddress;
    }

    public void open(int n, int n2) {
        InetAddress inetAddress = this.buildInetAddr(n, n2);
        this.ownAddr = new InetSocketAddress(inetAddress, n2);
        try {
            this.so = new DatagramSocket(this.ownAddr);
        }
        catch (SocketException socketException) {
            System.err.println(socketException.getMessage());
            this.so = null;
        }
    }

    public void setDst(int n, int n2) {
        InetAddress inetAddress = this.buildInetAddr(n, n2);
        this.dstAddr = new InetSocketAddress(inetAddress, n2);
    }

    public void close() {
        this.so.close();
        this.so = null;
    }

    public void tx(byte[] byArray, int n) {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, this.dstAddr);
        try {
            this.so.send(datagramPacket);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    public void tx(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        this.tx(byArray, byArray.length);
    }

    public int rx(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n2);
        try {
            this.so.receive(datagramPacket);
            n = datagramPacket.getLength();
            System.out.append('.');
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            n = -1;
        }
        return n;
    }
}

