/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.communication;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import org.vishia.communication.Address_InterProcessComm;
import org.vishia.communication.Address_InterProcessComm_Socket;
import org.vishia.communication.InterProcessComm;

public class InterProcessComm_SocketImpl
implements InterProcessComm {
    private static final int kDataBufferSize = 1500;
    private final Address_InterProcessComm_Socket ownAddress;
    private DatagramSocket udpSocket;
    private String sRxErrorMsg;
    private String sTxErrorMsg;

    public InterProcessComm_SocketImpl(Address_InterProcessComm address_InterProcessComm) {
        assert (address_InterProcessComm instanceof Address_InterProcessComm_Socket);
        this.ownAddress = (Address_InterProcessComm_Socket)address_InterProcessComm;
    }

    @Override
    public int open(Address_InterProcessComm address_InterProcessComm, boolean bl) {
        int n = 0;
        Address_InterProcessComm_Socket address_InterProcessComm_Socket = this.ownAddress;
        if (!bl) {
            this.sTxErrorMsg = "InterProcessComm_Socket.open(): The polling mode is not supported yet.";
            this.sRxErrorMsg = "InterProcessComm_Socket.open(): The polling mode is not supported yet.";
            n = -1;
        } else {
            InetSocketAddress inetSocketAddress = address_InterProcessComm_Socket.getSocketAddress();
            try {
                this.udpSocket = new DatagramSocket(inetSocketAddress);
                this.sRxErrorMsg = null;
            }
            catch (SocketException socketException) {
                this.sRxErrorMsg = socketException.getMessage() + "ipaddress= ... port=" + inetSocketAddress.getPort();
                n = -1;
            }
        }
        return n;
    }

    @Override
    public int close() {
        if (this.udpSocket != null) {
            this.udpSocket.close();
            this.udpSocket = null;
        }
        return 0;
    }

    @Override
    public int send(byte[] byArray, int n, Address_InterProcessComm address_InterProcessComm) {
        Address_InterProcessComm_Socket address_InterProcessComm_Socket = (Address_InterProcessComm_Socket)address_InterProcessComm;
        try {
            if (this.udpSocket != null) {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, n, address_InterProcessComm_Socket.getSocketAddress());
                this.udpSocket.send(datagramPacket);
            } else {
                n = -1;
            }
        }
        catch (SocketException socketException) {
            this.sTxErrorMsg = socketException.getMessage();
            n = -1;
        }
        catch (IOException iOException) {
            this.sTxErrorMsg = iOException.getMessage();
            n = -1;
        }
        return n;
    }

    @Override
    public byte[] receive(int[] nArray, Address_InterProcessComm address_InterProcessComm) {
        boolean bl = true;
        if (this.udpSocket == null) {
            return null;
        }
        Address_InterProcessComm_Socket address_InterProcessComm_Socket = (Address_InterProcessComm_Socket)address_InterProcessComm;
        byte[] byArray = new byte[1500];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 1500);
        try {
            this.udpSocket.receive(datagramPacket);
        }
        catch (IOException iOException) {
            bl = false;
            nArray[0] = -1;
            byArray = null;
        }
        if (bl) {
            nArray[0] = datagramPacket.getLength();
            if (address_InterProcessComm_Socket != null) {
                address_InterProcessComm_Socket.storeSender(datagramPacket.getSocketAddress());
            }
        }
        return byArray;
    }

    @Override
    public void freeData(byte[] byArray) {
    }

    @Override
    public boolean equals(Address_InterProcessComm address_InterProcessComm, Address_InterProcessComm address_InterProcessComm2) {
        return false;
    }

    public String getReceiveErrorMsg(boolean bl) {
        return this.sRxErrorMsg;
    }

    public String getSendErrorMsg(boolean bl) {
        return this.sTxErrorMsg;
    }

    @Override
    public int abortReceive() {
        return 0;
    }

    @Override
    public int capacityToSendWithoutBlocking(int n) {
        return 0;
    }

    @Override
    public int checkConnection() {
        if (this.udpSocket == null) {
            return -1;
        }
        return 0;
    }

    @Override
    public int dataAvailable() {
        return 0;
    }

    @Override
    public int flush() {
        return 0;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Address_InterProcessComm getOwnAddress() {
        return null;
    }

    @Override
    public byte[] getSendBuffer(int n) {
        return null;
    }

    @Override
    public byte[] receiveData(int[] nArray, byte[] byArray, Address_InterProcessComm address_InterProcessComm) {
        boolean bl = true;
        if (this.udpSocket == null) {
            return null;
        }
        Address_InterProcessComm_Socket address_InterProcessComm_Socket = (Address_InterProcessComm_Socket)address_InterProcessComm;
        byte[] byArray2 = byArray != null ? byArray : new byte[1500];
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length);
        try {
            this.udpSocket.receive(datagramPacket);
        }
        catch (IOException iOException) {
            bl = false;
            if (nArray != null) {
                nArray[0] = -1;
            }
            byArray2 = null;
        }
        if (bl) {
            if (nArray != null) {
                nArray[0] = datagramPacket.getLength();
            }
            if (address_InterProcessComm_Socket != null) {
                address_InterProcessComm_Socket.storeSender(datagramPacket.getSocketAddress());
            }
        }
        return byArray2;
    }

    @Override
    public String translateErrorMsg(int n) {
        return null;
    }

    @Override
    public Address_InterProcessComm createAddress() {
        return new Address_InterProcessComm_Socket();
    }

    @Override
    public Address_InterProcessComm createAddress(int n, int n2) {
        return new Address_InterProcessComm_Socket("Socket", n, n2);
    }

    @Override
    public Address_InterProcessComm createAddress(String string, int n) {
        return new Address_InterProcessComm_Socket("Socket", string, n);
    }

    @Override
    public Address_InterProcessComm createAddress(String string) {
        return new Address_InterProcessComm_Socket(string);
    }
}

