/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zcmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmdLogging_ifc;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFunctions_C;
import org.vishia.util.StringPart;
import org.vishia.util.StringPartFromFileLines;
import org.vishia.xmlSimple.SimpleXmlOutputter;
import org.vishia.xmlSimple.XmlNode;
import org.vishia.zbnf.ZbnfParser;

public class Csv2Data {
    public static final String sVersion = "2014-06-10";
    final MainCmdLogging_ifc log;
    Map<String, Map<String, String>> dataMap = new IndexMultiTable<String, Map<String, String>>(IndexMultiTable.providerString);
    List<Map<String, String>> lines = new LinkedList<Map<String, String>>();
    List<String> columns = new ArrayList<String>();
    int colident;
    int lineNr;
    char separator;
    char cDecimalSep = (char)46;

    public Csv2Data(MainCmdLogging_ifc mainCmdLogging_ifc) {
        this.log = mainCmdLogging_ifc;
    }

    public Csv2Data() {
        this.log = null;
    }

    public static void main(String[] stringArray) {
        String string = null;
        Args args = new Args();
        CmdHandler cmdHandler = new CmdHandler(args, stringArray);
        try {
            cmdHandler.parseArguments();
        }
        catch (Exception exception) {
            cmdHandler.report("Argument error:", exception);
            cmdHandler.setExitErrorLevel(5);
            cmdHandler.writeHelpInfo(null);
            string = "Csv2Data - cmd line error";
        }
        if (string == null) {
            Csv2Data csv2Data = new Csv2Data(cmdHandler);
            csv2Data.parseCsv(args.sInputCsv);
        }
        if (string != null) {
            cmdHandler.writeError(string);
        }
    }

    public String parseCsv(String string) {
        String string2 = null;
        File file = new File(string);
        BufferedReader bufferedReader = null;
        this.dataMap.clear();
        this.lines.clear();
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            string2 = "Csv2Data - can't open file; " + file.getAbsolutePath();
            bufferedReader = null;
        }
        if (bufferedReader != null) {
            try {
                String string3 = bufferedReader.readLine();
                this.createColumns(string3);
                this.lineNr = 1;
                while (string2 == null && (string3 = bufferedReader.readLine()) != null) {
                    ++this.lineNr;
                    this.parseLine(string3, bufferedReader);
                }
            }
            catch (IOException iOException) {
                string2 = "Csv2Data - readline failed in; " + file.getAbsolutePath();
            }
        }
        return string2;
    }

    public void createColumns(String string) {
        this.columns.clear();
        int n = string.indexOf(34);
        int n2 = string.indexOf(44);
        int n3 = string.indexOf(59);
        this.separator = n3 >= 0 && (n2 < 0 || n2 > n3) ? (char)59 : (char)44;
        LinkedList linkedList = new LinkedList();
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            String string2;
            int n7 = string.indexOf(this.separator, n5);
            if (n7 < 0) {
                n7 = n4;
            }
            if ((string2 = string.substring(n5, n7).trim()).startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            this.columns.add(string2);
            if (string2.equals("Identifier")) {
                this.colident = n6;
            }
            ++n6;
            n5 = n7 + 1;
        }
    }

    public String XXXparseLine(String string) {
        boolean bl = false;
        String[] stringArray = string.split(";");
        String string2 = null;
        StringPart stringPart = new StringPart(string);
        boolean bl2 = false;
        do {
            stringPart.lentoAnyCharOutsideQuotion(";", Integer.MAX_VALUE);
            if (!stringPart.found()) {
                stringPart.len0end();
                boolean bl3 = bl2 = stringPart.length() == 0;
            }
            if (bl2) continue;
            String string3 = stringPart.getCurrentPart().toString();
            stringPart.fromEnd().seek(1);
        } while (stringPart.found());
        stringPart.close();
        return string2;
    }

    public void parseLine(String string, BufferedReader bufferedReader) {
        String string2 = string;
        int n = string2.length();
        boolean bl = false;
        if (this.lineNr == 3) {
            Debugutil.stop();
        }
        int n2 = this.lineNr;
        IndexMultiTable indexMultiTable = new IndexMultiTable(IndexMultiTable.providerString);
        int n3 = 0;
        boolean bl2 = true;
        int n4 = 0;
        String string3 = null;
        while (bl2) {
            String string4;
            int n5 = string2.indexOf(34, n3);
            int n6 = string2.indexOf(this.separator, n3);
            if (n6 < 0 && n5 < 0) {
                n6 = n;
                bl2 = false;
            }
            if (n5 >= 0 && (n6 < 0 || n5 < n6)) {
                int n7 = string2.indexOf(34, n5 + 1);
                while (n7 >= 0 && n7 < n - 1 && string2.charAt(n7 + 1) == '\"') {
                    n7 = string2.indexOf(34, n7 + 2);
                }
                if (n7 < 0) {
                    string4 = string2.substring(n5 + 1);
                    if (string4.startsWith("(Autark")) {
                        Debugutil.stop();
                    }
                    do {
                        try {
                            string2 = bufferedReader.readLine();
                        }
                        catch (IOException iOException) {
                            string2 = null;
                        }
                        n = string2.length();
                        ++this.lineNr;
                        if (this.lineNr == 59) {
                            Debugutil.stop();
                        }
                        n3 = 0;
                        n7 = string2.indexOf(34);
                        string4 = n7 >= 0 ? string4 + '\n' + string2.substring(0, n7) : string4 + '\n' + string2;
                    } while (n7 < 0);
                } else {
                    string4 = string2.substring(n5 + 1, n7);
                }
                n6 = string2.indexOf(this.separator, n7);
                if (n6 < 0) {
                    bl2 = false;
                }
            } else {
                string4 = string2.substring(n3, n6).trim();
            }
            String string5 = n4 >= 0 && n4 < this.columns.size() ? this.columns.get(n4) : "column_" + n4;
            indexMultiTable.put(string5, string4);
            n3 = n6 + 1;
            if (n4 == this.colident) {
                string3 = string4;
            }
            ++n4;
        }
        if (string3 != null && !string3.isEmpty()) {
            n4 = 0;
            this.dataMap.put(string3, indexMultiTable);
            this.lines.add(indexMultiTable);
        }
    }

    public Object value(String string, String string2) {
        if (string2.equals("URS_MS_INORM")) {
            Debugutil.stop();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.startsWith("\"")) {
            return string;
        }
        if (string.startsWith("0x")) {
            return string;
        }
        try {
            if (string.indexOf(44) < 0) {
                Assert.stop();
            }
            float f = StringFunctions_C.parseFloat(string, 0, Integer.MAX_VALUE, this.cDecimalSep, null, null);
            return Float.valueOf(f);
        }
        catch (Exception exception) {
            return Float.valueOf(777777.7f);
        }
    }

    public float XXXfloatVal(String string) {
        try {
            if (string.indexOf(44) < 0) {
                Assert.stop();
            }
            float f = StringFunctions_C.parseFloat(string, 0, Integer.MAX_VALUE, this.cDecimalSep, null, null);
            return f;
        }
        catch (Exception exception) {
            return 777777.7f;
        }
    }

    public String parseCsvZbnf(String string) {
        String string2 = null;
        ZbnfParser zbnfParser = new ZbnfParser(this.log);
        String string3 = FileSystem.readFile(new File("zbnf/csvSyntax.zbnf"));
        try {
            zbnfParser.setSyntax(string3);
        }
        catch (ParseException parseException) {
            string2 = "Csv2Data - zbnf syntax fails";
            this.log.writeError(string2, parseException);
        }
        if (string2 == null) {
            Object object;
            boolean bl;
            File file = new File(string);
            StringPartFromFileLines stringPartFromFileLines = null;
            try {
                stringPartFromFileLines = new StringPartFromFileLines(file);
            }
            catch (IOException iOException) {
                string2 = "Csv2Data - input file read fails";
                this.log.writeError(string2, iOException);
            }
            if (string2 == null && !(bl = zbnfParser.parse(stringPartFromFileLines))) {
                string2 = "Csv2Data - input file syntax";
                object = zbnfParser.getSyntaxErrorReport();
                this.log.writeError((CharSequence)object);
            }
            if (string2 == null) {
                XmlNode xmlNode = zbnfParser.getResultTree();
                object = new SimpleXmlOutputter();
                try {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream("csvinput.xml"));
                    ((SimpleXmlOutputter)object).write(outputStreamWriter, xmlNode);
                }
                catch (IOException iOException) {
                    this.log.writeError("Csv2Data - xmlOut fails", iOException);
                }
            }
        }
        return string2;
    }

    static class CmdHandler
    extends MainCmd {
        protected final Args args;
        private final MainCmd.Argument[] arguments = new MainCmd.Argument[]{new MainCmd.Argument("-i", "=<CSV> Input csv file", new MainCmd.SetArgument(){

            @Override
            public boolean setArgument(String string) {
                args.sInputCsv = string;
                return true;
            }
        })};

        CmdHandler(Args args, String[] stringArray) {
            super(stringArray);
            super.addArgument(this.arguments);
            this.args = args;
        }

        @Override
        protected boolean checkArguments() {
            return this.args.sInputCsv != null;
        }
    }

    static class Args {
        String sInputCsv;

        Args() {
        }
    }
}

