/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zcmd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.vishia.byteData.ByteDataAccessBase;
import org.vishia.mainCmd.MainCmd;
import org.vishia.util.FileSystem;
import org.vishia.util.IndexMultiTable;
import org.vishia.zbnf.ZbnfJavaOutput;

public class Bin2Data {
    public static final String version = "2016-01-15";
    final Args args;
    DescrData descrData;
    ZbnfResultDescrElement zbnfElement = new ZbnfResultDescrElement();
    byte[] data;
    ByteDataAccessBase accData = new ByteDataAccessBase(0);

    public Bin2Data(Args args) {
        this.args = args;
    }

    public Bin2Data() {
        this.args = new Args();
    }

    public void readDescrSyntax() {
    }

    public boolean parseDescription() {
        if (this.args.sDescription == null && this.args.sFileSyntaxDescription == null) {
            this.args.sDescription = "bin2data::= recordStart : <#?posFirstRecord> ; recordLen : <#?recordLength> ; { <element> }. element::= <$?name> : <#?position> <$?type> ;. ";
        }
        if (this.descrData == null || this.descrData.listElements != null) {
            this.descrData = new ZbnfResultDescr();
        }
        ZbnfJavaOutput zbnfJavaOutput = new ZbnfJavaOutput();
        String string = this.args.sDescription != null ? zbnfJavaOutput.parseFileAndFillJavaObject(ZbnfResultDescr.class, (Object)this.descrData, this.args.sDescription, this.args.sFileDescription, this.args.syntaxDescription, null) : (this.args.syntaxDescription != null ? zbnfJavaOutput.parseFileAndFillJavaObject(ZbnfResultDescr.class, (Object)this.descrData, new File(this.args.sFileDescription), this.args.syntaxDescription) : zbnfJavaOutput.parseFileAndFillJavaObject(ZbnfResultDescr.class, (Object)this.descrData, new File(this.args.sFileDescription), new File(this.args.sFileSyntaxDescription)));
        if (string != null) {
            System.err.println(string);
            return false;
        }
        return true;
    }

    public boolean loadBinary(File file, boolean bl) {
        this.data = null;
        File file2 = FileSystem.getFirstFileWildcard(file);
        this.data = FileSystem.readBinFile(file2);
        this.accData.assign(this.data);
        this.accData.setBigEndian(bl);
        return this.data != null;
    }

    public int getIntegerHead(int n, int n2) {
        ByteDataAccessBase byteDataAccessBase = new ByteDataAccessBase(0);
        this.accData.addChildAt(n, byteDataAccessBase, n2);
        return byteDataAccessBase.getChildInt(n2);
    }

    public String getStringHead(int n, int n2) {
        ByteDataAccessBase byteDataAccessBase = new ByteDataAccessBase(0);
        this.accData.addChildAt(n, byteDataAccessBase, n2);
        return byteDataAccessBase.getChildString(n2);
    }

    public boolean setRecordStartLength(int n, int n2) {
        if (this.descrData == null) {
            this.descrData = new ZbnfResultDescr();
        }
        this.descrData.posFirstRecord = n;
        this.descrData.recordLength = n2;
        return this.data != null && (this.data.length - n) % n2 == 0;
    }

    public int nrofRecords() {
        if (this.descrData != null && this.descrData.recordLength > 0 && this.data != null) {
            float f = (this.data.length - this.descrData.posFirstRecord) / this.descrData.recordLength;
            return (int)f;
        }
        return 0;
    }

    private float getFloat(int n, DescrDataElement descrDataElement, ByteDataAccessBase byteDataAccessBase) {
        float f = 0.0f;
        int n2 = this.descrData.posFirstRecord + n * this.descrData.recordLength + descrDataElement.posInRecord;
        if (n2 > this.data.length - 4) {
            throw new IllegalArgumentException("Element out of range: " + descrDataElement.nameElement + ", record = " + n);
        }
        switch (descrDataElement.type) {
            case 'S': {
                this.accData.addChildAt(n2, byteDataAccessBase, 2);
                int n3 = byteDataAccessBase.getChildInt(2);
                if (descrDataElement.scale < 0.0f) {
                    f = (float)n3 / 32768.0f * -descrDataElement.scale;
                    break;
                }
                if (n3 < 0) {
                    n3 += 65536;
                }
                f = (float)n3 / 65536.0f * descrDataElement.scale;
                break;
            }
            case 'F': {
                this.accData.addChildAt(n2, byteDataAccessBase, 4);
                f = byteDataAccessBase.getChildFloat();
                break;
            }
        }
        return f;
    }

    public float getFloat(int n, String string) {
        DescrDataElement descrDataElement = this.descrData.idxElements.get(string);
        if (descrDataElement == null) {
            throw new IllegalArgumentException("Element does not exist: " + string);
        }
        ByteDataAccessBase byteDataAccessBase = new ByteDataAccessBase(0);
        return this.getFloat(n, descrDataElement, byteDataAccessBase);
    }

    public float[] getMinMidMaxFloat(int n, int n2, String string) {
        float[] fArray = new float[3];
        fArray[0] = 1.0E38f;
        fArray[2] = -1.0E38f;
        DescrDataElement descrDataElement = this.descrData.idxElements.get(string);
        if (descrDataElement == null) {
            throw new IllegalArgumentException("Element does not exist: " + string);
        }
        ByteDataAccessBase byteDataAccessBase = new ByteDataAccessBase(0);
        for (int i = n; i < n2; ++i) {
            float f = this.getFloat(i, descrDataElement, byteDataAccessBase);
            if (f < fArray[0]) {
                fArray[0] = f;
            }
            if (f > fArray[2]) {
                fArray[2] = f;
            }
            fArray[1] = fArray[1] + f;
        }
        fArray[1] = fArray[1] / (float)(n - n2);
        return fArray;
    }

    public class ZbnfResultDescrElement
    extends DescrDataElement {
        public boolean addPosition;
        int posInRecordBase;

        public void set_type(String string) {
            this.type = string.charAt(0);
        }

        public void set_position(int n) {
            if (this.addPosition) {
                this.posInRecord = 2 * n + this.posInRecordBase;
            } else {
                this.posInRecordBase = this.posInRecord = 2 * n;
            }
            this.addPosition = false;
        }

        public void set_name(String string) {
            this.nameElement = string;
        }

        public void set_scale(double d) {
            this.scale = (float)d;
        }

        DescrDataElement createDescrDataElement() {
            DescrDataElement descrDataElement = new DescrDataElement();
            descrDataElement.nameElement = this.nameElement;
            descrDataElement.posInRecord = this.posInRecord;
            descrDataElement.scale = this.scale;
            descrDataElement.type = this.type;
            return descrDataElement;
        }

        ZbnfResultDescrElement clean() {
            this.nameElement = null;
            this.posInRecord = 0;
            this.scale = 0.0f;
            this.type = '\u0000';
            this.addPosition = false;
            return this;
        }
    }

    public class ZbnfResultDescr
    extends DescrData {
        public ZbnfResultDescrElement new_element() {
            return Bin2Data.this.zbnfElement.clean();
        }

        public void add_element(ZbnfResultDescrElement zbnfResultDescrElement) {
            DescrDataElement descrDataElement = zbnfResultDescrElement.createDescrDataElement();
            this.idxElements.put(zbnfResultDescrElement.nameElement, descrDataElement);
            this.listElements.add(descrDataElement);
        }
    }

    public static class DescrData {
        public int posFirstRecord;
        public int recordLength;
        List<DescrDataElement> listElements = new ArrayList<DescrDataElement>();
        Map<String, DescrDataElement> idxElements = new IndexMultiTable<String, DescrDataElement>(IndexMultiTable.providerString);
    }

    public static class DescrDataElement {
        public String nameElement;
        public int posInRecord;
        public float scale;
        char type;
    }

    private static class CmdLine
    extends MainCmd {
        private CmdLine() {
        }

        @Override
        protected boolean checkArguments() {
            return false;
        }
    }

    public static class Args {
        public String sFileBin;
        public String sFileSyntaxDescription;
        public String syntaxDescription;
        public String sFileDescription;
        public String sDescription;
    }
}

