/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.zbnf;

import java.io.File;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.xmlSimple.Xsltpre;
import org.vishia.zbnf.Zbnf2Xml;

public class Zmake {
    private String input = null;
    private MainCmd_ifc console;
    private String zbnfjax_PATH;
    private String curDir = null;
    private String tmp = "../tmp";
    private String tmpAbs;
    private String sZbnf4ant = "xsl/ZmakeStd.zbnf";
    private String sXslt4ant = "xsl/ZmakeStd.xslp";
    private String sInputXml = null;
    private String sAntXml = null;

    public static void main(String[] stringArray) {
        Zmake zmake;
        Zmake zmake2 = zmake = new Zmake();
        zmake2.getClass();
        CmdLine cmdLine = zmake2.new CmdLine(stringArray);
        zmake.console = cmdLine;
        boolean bl = true;
        try {
            cmdLine.parseArguments();
        }
        catch (Exception exception) {
            zmake.console.setExitErrorLevel(5);
            bl = false;
        }
        if (bl) {
            String string = null;
            try {
                string = zmake.execute();
            }
            catch (Exception exception) {
                zmake.console.report("Uncatched Exception on main level:", exception);
                exception.printStackTrace(System.err);
                zmake.console.setExitErrorLevel(3);
            }
            if (string != null) {
                zmake.console.reportln(0, string);
                zmake.console.setExitErrorLevel(3);
            }
        }
        zmake.console.writeInfoln("* ");
        cmdLine.exit();
    }

    String execute() throws ParseException {
        Object object;
        Object object2;
        File file;
        int n;
        boolean bl = true;
        String string = null;
        if (this.input.startsWith("\"") && this.input.length() >= 2) {
            this.input = this.input.substring(1, this.input.length() - 1);
        }
        int n2 = this.input.lastIndexOf(47);
        int n3 = this.input.lastIndexOf(92);
        int n4 = this.input.lastIndexOf(58);
        if (n3 > n2) {
            n2 = n3;
        }
        if (n4 > n2) {
            n2 = n4;
        }
        if (n2 < 0) {
            n2 = -1;
        }
        if ((n = this.input.lastIndexOf(46)) < n2) {
            n = this.input.length();
        }
        String string2 = this.input.substring(n2 + 1, n);
        String string3 = this.input.substring(n);
        if (this.curDir == null) {
            this.curDir = this.input.substring(0, n2 + 1);
            this.input = string2 + string3;
        }
        this.tmpAbs = this.curDir + this.tmp;
        if (this.zbnfjax_PATH == null) {
            this.zbnfjax_PATH = System.getenv("XML_TOOLBASE");
        }
        if (this.zbnfjax_PATH == null) {
            this.zbnfjax_PATH = System.getenv("ZBNFJAX_HOME");
        }
        if (this.zbnfjax_PATH == null) {
            throw new ParseException("ZBNFJAX_HOME is not set. Either you should set a environment variable with this name or you should use the -ZBNFJAX_HOME: cmdline-Argument.", 0);
        }
        if (this.zbnfjax_PATH.startsWith("\"") && this.zbnfjax_PATH.length() >= 2) {
            this.zbnfjax_PATH = this.zbnfjax_PATH.substring(1, this.zbnfjax_PATH.length() - 1);
        }
        this.zbnfjax_PATH = this.zbnfjax_PATH + "/";
        this.console.writeInfoln("* Zmake: " + this.input);
        File file2 = new File(this.tmpAbs);
        if (!file2.exists()) {
            file2.mkdir();
        }
        if (this.sInputXml == null) {
            this.sInputXml = string2 + string3 + ".xml";
        }
        File file3 = new File(this.tmpAbs + "/" + this.sInputXml);
        file3.delete();
        if (this.sAntXml == null) {
            this.sAntXml = "ant_" + string2 + string3 + ".xml";
        }
        File file4 = new File(this.tmpAbs + "/" + this.sAntXml);
        file4.delete();
        this.console.writeInfoln("* Zmake: parsing \"" + this.curDir + this.input + "\" with \"" + this.zbnfjax_PATH + this.sZbnf4ant + "\" to \"" + file3.getAbsolutePath() + "\"...");
        String string4 = this.curDir + this.input;
        String string5 = this.zbnfjax_PATH + this.sZbnf4ant;
        String string6 = this.tmpAbs + "/" + this.sInputXml;
        Zbnf2Xml zbnf2Xml = new Zbnf2Xml(string4, string5, string6, this.console);
        bl = zbnf2Xml.execute();
        if (!bl) {
            throw new ParseException("zbnf syntax error", 0);
        }
        this.console.writeInfo("done");
        if (!this.sXslt4ant.endsWith(".xslp")) {
            file = new File(this.zbnfjax_PATH + this.sXslt4ant);
        } else {
            int n5 = this.sXslt4ant.lastIndexOf(47);
            object2 = this.sXslt4ant.substring(n5 + 1, this.sXslt4ant.length() - 1);
            object = this.sXslt4ant.substring(0, n5 + 1);
            File file5 = new File(this.zbnfjax_PATH + (String)object + "gen");
            if (!file5.exists()) {
                file5.mkdir();
            }
            file = new File(this.zbnfjax_PATH + (String)object + "gen/" + (String)object2);
            File file6 = new File(this.zbnfjax_PATH + this.sXslt4ant);
            if (!file6.exists()) {
                bl = false;
                this.console.writeError("* Zmake: " + file6.getAbsolutePath() + " not exists.");
                string = "Xsl File Ant.xml failed";
            }
            if (!file.exists() || file6.lastModified() > file.lastModified()) {
                this.console.writeInfoln("* Zmake: generate " + file.getAbsolutePath() + " from " + file6.getAbsolutePath());
                Xsltpre xsltpre = new Xsltpre(file6, file);
                xsltpre.execute();
            } else {
                this.console.writeInfoln("* Zmake: generated " + file.getAbsolutePath() + " is uptodate.");
            }
        }
        if (!file.exists()) {
            bl = false;
            this.console.writeError("* Zmake: " + file.getAbsolutePath() + " not exists.");
            string = "Xsl File Ant.xml failed";
        }
        if (bl) {
            System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            object2 = null;
            this.console.writeInfoln("* Zmake: preparing net.sf.saxon as XSLT-translator with " + file.getAbsolutePath() + " ...");
            try {
                object2 = transformerFactory.newTransformer(new StreamSource(file));
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                bl = false;
                string = "The saxon transformer couldn't be find: net.sf.saxon.TransformerFactoryImpl.class. The .class saxon*.jar have to be part of the classpath.";
            }
            if (bl) {
                this.console.writeInfo("done");
                this.console.writeInfoln("* Zmake: translating " + file3.getAbsolutePath() + " ...");
                object = new Properties();
                ((Properties)object).put("indent", "yes");
                ((Transformer)object2).setOutputProperties((Properties)object);
                ((Transformer)object2).setParameter("tmp", this.tmp);
                try {
                    ((Transformer)object2).transform(new StreamSource(file3), new StreamResult(file4));
                }
                catch (TransformerException transformerException) {
                    bl = false;
                    string = "xslt exception: " + transformerException.getMessage();
                }
                if (bl) {
                    this.console.writeInfo("done");
                }
            }
        }
        return string;
    }

    private class CmdLine
    extends MainCmd {
        private CmdLine(String[] stringArray) {
            super(stringArray);
            super.addAboutInfo("Zmake organizer");
            super.addAboutInfo("made by JcHartmut, 2007-07-06 - 2007-10-18");
            super.addHelpInfo("invoke>%JAX_EXE% org.vishia.zbnfXml.Zmake [INPUT] [{OPTIONS}]");
            super.addHelpInfo("* pathes to files or dirs are absolute or relativ from cmd line invocation.");
            super.addHelpInfo("* TPATH means a path started from given -ZBNFJAX_HOME:PATH or ZBNFJAX_HOME in environment.");
            super.addHelpInfo("* WPATH means a path started from given -tmp directory (WorkPATH).");
            super.addHelpInfo("* INPUTFILE is the only filename without path and without extension dissolved from INPUT");
            super.addHelpInfo("INPUT              The first argument without - is the input file with path and extension.");
            super.addHelpInfo("-i:INPUT           path to the input file alternatively to INPUT.");
            super.addHelpInfo("-curdir:PATH       sets the current dir alternatively to command line invocation path.");
            super.addHelpInfo("-ZBNFJAX_HOME:PATH path to the ZBNFJAX_HOME, default it is getted from environment.");
            super.addHelpInfo("-tmp:PATH          path of tmp dir, will be created if not exists, default=\"../tmp\".");
            super.addHelpInfo("-tmpinputxml:WPATH name of the temporary file parsed from input, default=INPUTFILE.xml");
            super.addHelpInfo("-tmpantxml:WPATH   ant.xml-file to generate, default=ant_INPUTFILE.xml");
            super.addHelpInfo("-zbnf4ant:TPATH    zbnf-file to parse the input");
            super.addHelpInfo("-xslt4ant:TPATH    xslt-file to generate the ant.xml");
            super.addStandardHelpInfo();
        }

        @Override
        protected boolean testArgument(String string, int n) {
            boolean bl = true;
            if (n == 0 && !string.startsWith("-")) {
                Zmake.this.input = this.getArgument(0);
            } else if (string.startsWith("-i:")) {
                Zmake.this.input = this.getArgument(3);
            } else if (string.startsWith("-i")) {
                Zmake.this.input = this.getArgument(2);
            } else if (string.startsWith("-curdir:")) {
                Zmake.this.curDir = this.getArgument(8) + "/";
            } else if (string.startsWith("-curdir=")) {
                Zmake.this.curDir = this.getArgument(8) + "/";
            } else if (string.startsWith("-ZBNFJAX_HOME:")) {
                Zmake.this.zbnfjax_PATH = this.getArgument(14);
            } else if (string.startsWith("-XML_TOOLBASE:")) {
                Zmake.this.zbnfjax_PATH = this.getArgument(14);
            } else if (string.startsWith("-XML_TOOLBASE=")) {
                Zmake.this.zbnfjax_PATH = this.getArgument(14);
            } else if (string.startsWith("-tmp:")) {
                Zmake.this.tmp = this.getArgument(5);
            } else if (string.startsWith("-tmp=")) {
                Zmake.this.tmp = this.getArgument(5);
            } else if (string.startsWith("-tmpinputxml:")) {
                Zmake.this.sInputXml = this.getArgument(13);
            } else if (string.startsWith("-tmpantxml:")) {
                Zmake.this.sAntXml = this.getArgument(11);
            } else if (string.startsWith("-antxml=")) {
                Zmake.this.sAntXml = this.getArgument(8);
            } else if (string.startsWith("-zbnf4ant:")) {
                Zmake.this.sZbnf4ant = this.getArgument(10);
            } else if (string.startsWith("-zbnf4ant=")) {
                Zmake.this.sZbnf4ant = this.getArgument(10);
            } else if (string.startsWith("-xslt4ant:")) {
                Zmake.this.sXslt4ant = this.getArgument(10);
            } else if (string.startsWith("-xslt4ant=")) {
                Zmake.this.sXslt4ant = this.getArgument(10);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        protected void callWithoutArguments() throws ParseException {
            super.callWithoutArguments();
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (Zmake.this.input == null) {
                bl = false;
                this.writeError("ERROR argument -i is obligat.");
            }
            if (!bl) {
                this.setExitErrorLevel(5);
            }
            return bl;
        }
    }
}

