/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlSimple;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.TreeMap;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.util.StringPart;

public class Xsltpre {
    String sFileIn = null;
    String sFileOut = null;
    String sEncoding = "ISO-8859-1";
    File fIn;
    File fOut;
    boolean bGenerateOnlyifNecessary = true;
    final String[] sKeys = new String[]{"<=", "<@", "<:", "<:call ", "<?if ", "<?elif ", "<?else ", "</?if>", "</?else>", "(?=", "(?!", "(?@", "(?$", "(?call ", "(?if ", "(?elif ", "(?else?)", "(?ifNext?)", "(?/if?)", "(?/else?)"};
    MainCmd_ifc console;
    TreeMap<String, String> aliases;

    public Xsltpre(File file, File file2) {
        this();
        this.fIn = file;
        this.fOut = file2;
    }

    private Xsltpre() {
    }

    public void execute() {
        boolean bl = true;
        if (!this.bGenerateOnlyifNecessary || !this.fOut.exists() || this.fOut.lastModified() < this.fIn.lastModified()) {
            if (this.fOut.exists()) {
                this.fOut.delete();
            }
            this.aliases = new TreeMap();
            LineNumberReader lineNumberReader = null;
            FileWriter fileWriter = null;
            try {
                lineNumberReader = new LineNumberReader(new FileReader(this.fIn));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.console.writeError("file not found: " + this.sFileIn);
                this.console.setExitErrorLevel(4);
                bl = false;
            }
            if (bl) {
                try {
                    fileWriter = new FileWriter(this.fOut);
                }
                catch (IOException iOException) {
                    this.console.writeError("file create/open error: " + this.sFileOut);
                    this.console.setExitErrorLevel(4);
                    bl = false;
                }
            }
            if (bl) {
                try {
                    String string;
                    StringPart stringPart = new StringPart();
                    int[] nArray = new int[1];
                    StringBuffer stringBuffer = new StringBuffer(12000);
                    do {
                        string = lineNumberReader.readLine();
                        stringBuffer.setLength(0);
                        if (string != null) {
                            stringPart.assign(string);
                            do {
                                if (stringPart.startsWith("(?if")) {
                                    this.stop();
                                }
                                stringPart.seekAnyString(this.sKeys, nArray);
                                stringBuffer.append(stringPart.getLastPart());
                                if (!stringPart.found()) continue;
                                switch (nArray[0]) {
                                    case 0: {
                                        this.setAliasOld(stringPart);
                                        break;
                                    }
                                    case 1: {
                                        this.setValueOfOld(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 2: {
                                        this.setCallTemplateOld(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 3: {
                                        this.setCallTemplateOld(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 4: {
                                        this.setIfOld(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 5: {
                                        this.setElifOld(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 6: {
                                        this.setElseOld(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 7: {
                                        this.setIfEndOld(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 8: {
                                        this.setElseEndOld(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 9: {
                                        this.setAlias(stringPart);
                                        break;
                                    }
                                    case 10: {
                                        this.setValueOf(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 11: {
                                        this.setValueOf(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 12: {
                                        this.setValueOf(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 13: {
                                        this.setCallTemplate(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 14: {
                                        this.setIf(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 15: {
                                        this.setElif(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 16: {
                                        this.setElse(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 17: {
                                        this.setIfNext(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 18: {
                                        this.setIfEnd(stringBuffer, stringPart);
                                        break;
                                    }
                                    case 19: {
                                        this.setElseEnd(stringBuffer, stringPart);
                                        break;
                                    }
                                    default: {
                                        throw new RuntimeException("unexpected choice:" + nArray[0]);
                                    }
                                }
                            } while (stringPart.found());
                        }
                        stringBuffer.append('\n');
                        fileWriter.write(stringBuffer.toString());
                        stringBuffer.setLength(0);
                    } while (string != null);
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    System.out.println("file exception" + iOException.getMessage());
                }
            }
        }
    }

    private void setAlias(StringPart stringPart) {
        stringPart.seek(3).lento('=');
        String string = stringPart.getCurrentPart().toString();
        stringPart.fromEnd().seek(1).lento("?)");
        this.aliases.put(string, stringPart.getCurrentPart().toString());
        stringPart.fromEnd().seek(2);
    }

    private void setValueOf(StringBuffer stringBuffer, StringPart stringPart) {
        String string;
        char c = stringPart.seek(2).getCurrentChar();
        stringPart.seek(1).lento("?)");
        if (stringPart.getCurrentChar() == '=') {
            String string2 = stringPart.seek(1).getCurrentPart().toString();
            string = this.aliases.get(string2);
        } else {
            string = stringPart.getCurrentPart().toString();
        }
        stringBuffer.append("</xsl:text><xsl:value-of select=\"");
        if (c != '!') {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
        stringBuffer.append("\" /><xsl:text>");
        stringPart.fromEnd().seek(2);
    }

    private void setCallTemplate(StringBuffer stringBuffer, StringPart stringPart) {
        String string;
        stringPart.seek(7).lentoAnyChar(":(?");
        String string2 = stringPart.getCurrentPart().toString();
        char c = stringPart.fromEnd().getCurrentChar();
        stringBuffer.append("</xsl:text>");
        if (c == ':') {
            stringPart.seek(1).lentoQuotionEnd('\"', Integer.MAX_VALUE);
            string = stringPart.getCurrentPart().toString();
            stringBuffer.append("<xsl:for-each select=");
            stringBuffer.append(string);
            stringBuffer.append(">");
            c = stringPart.fromEnd().getCurrentChar();
        } else {
            string = null;
        }
        stringBuffer.append("<xsl:call-template name=\"");
        stringBuffer.append(string2);
        if (string2.equals("ast")) {
            this.stop();
        }
        if (c == '(') {
            stringBuffer.append("\">");
            stringPart.seek(1);
            while (stringPart.getCurrentChar() != ')') {
                stringPart.lentoAnyChar("=");
                String string3 = stringPart.getCurrentPart().toString();
                stringPart.fromEnd().seek(1).lentoAnyChar(",)");
                String string4 = stringPart.getCurrentPart().toString();
                stringBuffer.append("<xsl:with-param name=\"");
                stringBuffer.append(string3);
                stringBuffer.append("\" ");
                if (string4.indexOf(" + ") >= 0) {
                    this.setParamValueMultiContent(stringBuffer, string4);
                } else {
                    this.setParamValueSelect(stringBuffer, string4);
                }
                if (stringPart.fromEnd().getCurrentChar() != ',') continue;
                stringPart.seek(2);
            }
            stringBuffer.append("</xsl:call-template>");
        } else {
            stringBuffer.append("\" />");
        }
        if (string != null) {
            stringBuffer.append("</xsl:for-each>");
        }
        stringBuffer.append("<xsl:text>");
        stringPart.seek("?)", 1);
    }

    private void setParamValueSelect(StringBuffer stringBuffer, String string) {
        if (string.startsWith("=")) {
            String string2 = string.substring(1);
            string = "\"" + this.aliases.get(string2) + "\"";
        }
        stringBuffer.append(" select=");
        stringBuffer.append(string);
        stringBuffer.append(" />");
    }

    private void setParamValueMultiContent(StringBuffer stringBuffer, String string) {
        if (string.startsWith("*")) {
            string = string.substring(1);
        }
        stringBuffer.append("\" select=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" />");
    }

    private void setIf(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(5);
        stringBuffer.append("</xsl:text><xsl:choose><xsl:when test=");
        stringBuffer.append(this.ifcondition(stringPart));
        stringBuffer.append("><xsl:text>");
        stringPart.fromEnd().seek(2);
    }

    private String ifcondition(StringPart stringPart) {
        String string;
        if (stringPart.getCurrentChar() == '\"') {
            stringPart.lentoQuotionEnd('\"', Integer.MAX_VALUE);
            string = stringPart.getCurrentPart().toString();
        } else {
            stringPart.lento("?)", 0);
            string = "\"" + stringPart.getCurrentPart() + "\"";
        }
        return string;
    }

    private void setElif(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(7);
        stringBuffer.append("</xsl:text></xsl:when><xsl:when test=");
        stringBuffer.append(this.ifcondition(stringPart));
        stringBuffer.append("><xsl:text>");
        stringPart.fromEnd().seek(2);
    }

    private void setElse(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(8);
        stringBuffer.append("</xsl:text></xsl:when><xsl:otherwise><xsl:text>");
    }

    private void setIfNext(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(10);
        stringBuffer.append("</xsl:text><xsl:choose><xsl:when test=\"last() > position()\"><xsl:text>");
    }

    private void setIfEnd(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(7);
        stringBuffer.append("</xsl:text></xsl:when></xsl:choose><xsl:text>");
    }

    private void setElseEnd(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(9);
        stringBuffer.append("</xsl:text></xsl:otherwise></xsl:choose><xsl:text>");
    }

    private void setAliasOld(StringPart stringPart) {
        stringPart.seek(2).lento('=');
        String string = stringPart.getCurrentPart().toString();
        stringPart.fromEnd().seek(1).lento('>');
        this.aliases.put(string, stringPart.getCurrentPart().toString());
        stringPart.fromEnd().seek(1);
    }

    private void setValueOfOld(StringBuffer stringBuffer, StringPart stringPart) {
        String string;
        stringPart.seek(2).lento('>');
        if (stringPart.getCurrentChar() == '=') {
            String string2 = stringPart.seek(1).getCurrentPart().toString();
            string = this.aliases.get(string2);
        } else {
            string = stringPart.getCurrentPart().toString();
        }
        stringBuffer.append("</xsl:text><xsl:value-of select=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" /><xsl:text>");
        stringPart.fromEnd().seek(1);
    }

    private void setCallTemplateOld(StringBuffer stringBuffer, StringPart stringPart) {
        String string;
        stringPart.seek(2).lentoAnyChar(":(>");
        String string2 = stringPart.getCurrentPart().toString();
        char c = stringPart.fromEnd().getCurrentChar();
        if (c == ':') {
            stringPart.seek(1).lentoQuotionEnd('\"', Integer.MAX_VALUE);
            string = stringPart.getCurrentPart().toString();
            stringBuffer.append("</xsl:text><xsl:for-each select=");
            stringBuffer.append(string);
            stringBuffer.append(">");
            c = stringPart.fromEnd().getCurrentChar();
        } else {
            string = null;
        }
        stringBuffer.append("<xsl:call-template name=\"");
        stringBuffer.append(string2);
        if (string2.equals("ast")) {
            this.stop();
        }
        if (c == '(') {
            stringBuffer.append("\">");
            stringPart.seek(1);
            while (stringPart.getCurrentChar() != ')') {
                stringPart.lentoAnyChar("=");
                String string3 = stringPart.getCurrentPart().toString();
                stringPart.fromEnd().seek(1).lentoAnyChar(",)");
                String string4 = stringPart.getCurrentPart().toString();
                stringBuffer.append("<xsl:with-param name=\"");
                stringBuffer.append(string3);
                stringBuffer.append("\" ");
                if (string4.indexOf(" + ") >= 0) {
                    this.setParamValueMultiContent(stringBuffer, string4);
                } else {
                    this.setParamValueSelect(stringBuffer, string4);
                }
                if (stringPart.fromEnd().getCurrentChar() != ',') continue;
                stringPart.seek(2);
            }
            stringBuffer.append("</xsl:call-template>");
        } else {
            stringBuffer.append("\" />");
        }
        if (string != null) {
            stringBuffer.append("</xsl:for-each>");
        }
        stringBuffer.append("<xsl:text>");
        stringPart.seek(">", 0).seek(1);
    }

    private void setIfOld(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(5).lentoQuotionEnd('\"', Integer.MAX_VALUE);
        String string = stringPart.getCurrentPart().toString();
        stringBuffer.append("</xsl:text><xsl:choose><xsl:when test=");
        stringBuffer.append(string);
        stringBuffer.append("><xsl:text>");
        stringPart.fromEnd().seek(1);
    }

    private void setElifOld(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(7).lentoQuotionEnd('\"', Integer.MAX_VALUE);
        String string = stringPart.getCurrentPart().toString();
        stringBuffer.append("</xsl:text></xsl:choose><xsl:when test=");
        stringBuffer.append(string);
        stringBuffer.append("><xsl:text>");
        stringPart.fromEnd().seek(1);
    }

    private void setElseOld(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(8);
        stringBuffer.append("</xsl:text></xsl:when><xsl:otherwise><xsl:text>");
    }

    private void setIfEndOld(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(6);
        stringBuffer.append("</xsl:text></xsl:when></xsl:choose><xsl:text>");
    }

    private void setElseEndOld(StringBuffer stringBuffer, StringPart stringPart) {
        stringPart.seek(8);
        stringBuffer.append("</xsl:text></xsl:otherwise></xsl:choose><xsl:text>");
    }

    public static void main(String[] stringArray) {
        Xsltpre xsltpre;
        Xsltpre xsltpre2 = xsltpre = new Xsltpre();
        xsltpre2.getClass();
        CmdLine cmdLine = xsltpre2.new CmdLine(stringArray);
        xsltpre.console = cmdLine;
        boolean bl = true;
        try {
            cmdLine.parseArguments();
        }
        catch (Exception exception) {
            xsltpre.console.setExitErrorLevel(5);
            bl = false;
        }
        if (bl) {
            xsltpre.fIn = new File(xsltpre.sFileIn);
            xsltpre.fOut = new File(xsltpre.sFileOut);
            try {
                xsltpre.execute();
            }
            catch (Exception exception) {
                cmdLine.report("Uncatched Exception on main level:", exception);
                cmdLine.setExitErrorLevel(3);
            }
        }
        cmdLine.exit();
    }

    void stop() {
    }

    private class CmdLine
    extends MainCmd {
        private CmdLine(String[] stringArray) {
            super(stringArray);
            super.addAboutInfo("Text preprocessor for Xslt");
            super.addAboutInfo("made by JcSchorrig, 2007-01-18");
            super.addHelpInfo("Converts Xsl with macros in a standard xsl.");
            super.addHelpInfo("param: -iINPUT -oOUTPUT [-eEncoding] [-always]");
            super.addHelpInfo("-iINPUT    inputfilepath of a XSL file with macros.");
            super.addHelpInfo("-iOUTPUT   outputfilepath of the pure XSL file.");
            super.addHelpInfo("-eEncoding encoding of the output, default is ISO-8859-1.");
            super.addHelpInfo("-always generate always, otherwise not if the output is newer.");
            super.addStandardHelpInfo();
        }

        @Override
        protected boolean testArgument(String string, int n) {
            boolean bl = true;
            if (string.startsWith("-i:")) {
                Xsltpre.this.sFileIn = this.getArgument(3);
            } else if (string.startsWith("-i")) {
                Xsltpre.this.sFileIn = this.getArgument(2);
            } else if (string.startsWith("-o:")) {
                Xsltpre.this.sFileOut = this.getArgument(3);
            } else if (string.startsWith("-o")) {
                Xsltpre.this.sFileOut = this.getArgument(2);
            } else if (string.startsWith("-e:")) {
                Xsltpre.this.sEncoding = this.getArgument(3);
            } else if (string.startsWith("-e")) {
                Xsltpre.this.sEncoding = this.getArgument(2);
            } else if (string.startsWith("-always")) {
                Xsltpre.this.bGenerateOnlyifNecessary = false;
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        protected boolean checkArguments() {
            boolean bl = true;
            if (Xsltpre.this.sFileIn == null) {
                bl = false;
                this.writeError("ERROR argument -i is obligat.");
            } else if (Xsltpre.this.sFileIn.length() == 0) {
                bl = false;
                this.writeError("ERROR argument -i without content.");
            }
            if (Xsltpre.this.sFileOut == null) {
                this.writeWarning("argument -o no outputfile is given, use default");
                Xsltpre.this.sFileOut = "out.txt";
            } else if (Xsltpre.this.sFileOut.length() == 0) {
                bl = false;
                this.writeError("argument -o without content");
            }
            if (!bl) {
                this.setExitErrorLevel(5);
            }
            return bl;
        }
    }
}

