/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.xmlSimple;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.vishia.util.StringArray;
import org.vishia.util.StringFunctions;

public class XmlBeautificator {
    int len = 16384;
    char[] buffer = new char[this.len];
    int pos = 0;
    int end = 0;
    boolean bEof = false;
    File fin;
    File fout;
    ZipFile zipfin;
    ZipEntry zipEntry;
    String sPathInZip;
    Reader rin;
    Writer wout;
    String sEncoding = "UTF-8";
    final String sWhitespaces = " \n\r\t";
    int indent = 1;
    char[] sNewline = new char[200];
    final CharSequence csBuffer;
    Stack<String> tags;

    public XmlBeautificator() {
        Arrays.fill(this.sNewline, ' ');
        this.sNewline[0] = 10;
        this.csBuffer = new CharSequence(){

            @Override
            public int length() {
                return XmlBeautificator.this.end - XmlBeautificator.this.pos;
            }

            @Override
            public char charAt(int n) {
                return XmlBeautificator.this.buffer[XmlBeautificator.this.pos + n];
            }

            @Override
            public CharSequence subSequence(int n, int n2) {
                return new StringArray(XmlBeautificator.this.buffer, XmlBeautificator.this.pos + n, XmlBeautificator.this.pos + n2);
            }

            @Override
            public String toString() {
                int n = this.length();
                if (n > 40) {
                    n = 40;
                }
                return new String(XmlBeautificator.this.buffer, XmlBeautificator.this.pos, n);
            }
        };
        this.tags = new Stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rw(String[] stringArray) {
        String string = stringArray[0];
        int n = string.indexOf(":zip:");
        if (n >= 0) {
            this.fin = new File(string.substring(0, n));
            this.sPathInZip = string.substring(n + 5);
        } else {
            this.fin = new File(stringArray[0]);
        }
        this.fout = new File(stringArray[1]);
        try {
            this.openInput();
            this.read();
            this.evaluateStartTag();
            this.wout = new OutputStreamWriter((OutputStream)new FileOutputStream(this.fout), this.sEncoding);
            this.wout.write(this.buffer, 0, this.pos);
            this.writeNewline();
            do {
                this.evaluateElement(0);
            } while (this.pos < this.end);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        finally {
            if (this.rin != null) {
                try {
                    this.rin.close();
                    this.rin = null;
                }
                catch (IOException iOException) {
                    System.err.println("exception on close: ");
                }
            }
            if (this.zipfin != null) {
                try {
                    this.zipfin.close();
                    this.zipfin = null;
                }
                catch (IOException iOException) {
                    System.err.println("exception on close zip: ");
                }
            }
            if (this.wout != null) {
                try {
                    this.wout.close();
                    this.wout = null;
                }
                catch (IOException iOException) {
                    System.err.println("exception on close out: ");
                }
            }
        }
    }

    void openInput() throws IOException {
        if (this.sPathInZip == null) {
            this.rin = new InputStreamReader((InputStream)new FileInputStream(this.fin), this.sEncoding);
        } else {
            if (this.zipfin == null) {
                this.zipfin = new ZipFile(this.fin);
                this.zipEntry = this.zipfin.getEntry(this.sPathInZip);
            }
            InputStream inputStream = this.zipfin.getInputStream(this.zipEntry);
            this.rin = new InputStreamReader(inputStream, this.sEncoding);
        }
        this.end = 0;
        this.pos = 0;
    }

    void evaluateStartTag() throws IOException {
        int n;
        String string;
        StringArray stringArray = new StringArray(this.buffer, this.pos, this.end);
        assert (StringFunctions.startsWith(stringArray, "<?"));
        int n2 = StringFunctions.indexOf((CharSequence)stringArray, "encoding=\"") + 10;
        if (n2 >= 10 && !this.sEncoding.equals(string = new String(this.buffer, n2, (n = StringFunctions.indexOf((CharSequence)stringArray, '\"', n2)) - n2))) {
            this.sEncoding = string;
            this.rin.close();
            this.openInput();
            this.read();
        }
        this.pos = StringFunctions.indexOf((CharSequence)stringArray, "?>") + 2;
    }

    private void read() throws IOException {
        if (!this.bEof && this.pos >= this.len / 2 || this.pos == 0 && this.end == 0) {
            int n;
            int n2 = 0;
            for (n = this.pos; n < this.end; ++n) {
                this.buffer[n2++] = this.buffer[n];
            }
            this.end -= this.pos;
            this.pos = 0;
            n = this.rin.read(this.buffer, this.end, this.buffer.length - this.end);
            this.bEof = n < 0;
            if (!this.bEof) {
                this.end += n;
            }
        }
    }

    private void evaluateElement(int n) throws IOException {
        boolean bl;
        char c;
        this.read();
        if (n > 100) {
            throw new IllegalArgumentException("recursion >100");
        }
        do {
            if ((c = this.buffer[this.pos]) == '<') continue;
            assert ("\n\r\t ".indexOf(c) >= 0);
            ++this.pos;
        } while (c != '<' && this.pos < this.end);
        if (this.pos >= this.end) {
            return;
        }
        int n2 = this.pos;
        while ("\n\r\t />".indexOf(c = this.buffer[++this.pos]) < 0) {
        }
        String string = new String(this.buffer, n2 + 1, this.pos - n2 - 1);
        int n3 = StringFunctions.indexOf(this.csBuffer, '>');
        char c2 = this.buffer[this.pos + n3 - 1];
        this.wout.write(this.buffer, n2, this.pos + n3 + 1 - n2);
        this.pos += n3 + 1;
        boolean bl2 = bl = c2 != '/';
        if (!bl) {
            this.writeNewline();
        } else {
            this.tags.push(string);
            this.indent += 2;
            this.writeNewline();
            do {
                this.evaluateContent();
                if (StringFunctions.startsWith(this.csBuffer, "</")) {
                    this.indent -= 2;
                    this.writeCloseTag();
                    this.writeNewline();
                    bl = false;
                    continue;
                }
                this.evaluateElement(n + 1);
            } while (bl);
        }
    }

    private void writeCloseTag() throws IOException {
        String string;
        assert (this.indent >= 1);
        int n = StringFunctions.indexOf(this.csBuffer, '>');
        CharSequence charSequence = this.csBuffer.subSequence(2, n);
        if (StringFunctions.compare(charSequence, string = this.tags.pop()) != 0) {
            System.out.printf("tag mismatching: %s != %s\n", string, charSequence.toString());
        }
        this.wout.write(this.buffer, this.pos, n + 1);
        this.pos += n + 1;
    }

    private boolean evaluateContent() throws IOException {
        this.read();
        int n = this.pos;
        int n2 = StringFunctions.indexOf(this.csBuffer, '<') + this.pos;
        boolean bl = false;
        this.pos = n2;
        for (int i = n; i < n2; ++i) {
            char c = this.buffer[i];
            if (this.sWhitespaces.indexOf(c) >= 0) continue;
            bl = true;
            this.wout.write(this.buffer, n, n2 - n);
            break;
        }
        return bl;
    }

    private void writeNewline() throws IOException {
        this.wout.write(this.sNewline, 0, this.indent);
        this.wout.flush();
    }

    public static void main(String[] stringArray) {
        XmlBeautificator xmlBeautificator = new XmlBeautificator();
        xmlBeautificator.rw(stringArray);
    }
}

