/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.util.Timeshort;

public class TimedValues {
    public static final int version = 20130327;
    private Timeshort timeAbs;
    private Map<String, Track> tracks = new TreeMap<String, Track>();
    private int[] timeShort;
    private int[] timeShortAdd;
    int ix;
    private int length = 10000;

    public TimedValues(int n) {
        this.cleanSetCapacity(n);
    }

    public int getLength() {
        return this.length;
    }

    public void cleanSetCapacity(int n) {
        this.length = n;
        for (Map.Entry<String, Track> entry : this.tracks.entrySet()) {
            Track track = entry.getValue();
            if (track.values_D != null) {
                track.values_D = new double[n];
            }
            if (track.values_F != null) {
                track.values_F = new float[n];
            }
            if (track.values_I != null) {
                track.values_I = new int[n];
            }
            if (track.values_S != null) {
                track.values_S = new short[n];
            }
            track.max = Double.MIN_VALUE;
            track.min = Double.MAX_VALUE;
        }
        this.timeShort = new int[n];
        this.timeShortAdd = new int[n];
    }

    public boolean increaseCapacity(int n) {
        if (this.length >= n) {
            return this.length == n;
        }
        this.length = n;
        for (Map.Entry<String, Track> entry : this.tracks.entrySet()) {
            Track track = entry.getValue();
            if (track.values_D != null) {
                track.values_D = Arrays.copyOf(track.values_D, n);
            }
            if (track.values_F != null) {
                track.values_F = Arrays.copyOf(track.values_F, n);
            }
            if (track.values_I != null) {
                track.values_I = Arrays.copyOf(track.values_I, n);
            }
            if (track.values_S != null) {
                track.values_S = Arrays.copyOf(track.values_S, n);
            }
            track.max = Double.MIN_VALUE;
            track.min = Double.MAX_VALUE;
        }
        this.timeShort = Arrays.copyOf(this.timeShort, n);
        this.timeShortAdd = Arrays.copyOf(this.timeShortAdd, n);
        return true;
    }

    public Track addTrack(String string, char c) {
        Track track = new Track(string, c, this.length);
        this.tracks.put(string, track);
        return track;
    }

    public Track getTrack(String string) {
        return this.tracks.get(string);
    }

    public int getIncrIx() {
        int n = this.ix++;
        return n;
    }

    public int getIncrWrapIx() {
        int n = this.ix++;
        if (this.ix >= this.length) {
            this.ix = 0;
        }
        return n;
    }

    public int getTimeShort(int n) {
        return this.timeShort[n] + this.timeShortAdd[n];
    }

    public int getsetTimeShort(int n, int n2, int n3) {
        int n4 = this.timeShort[n] + this.timeShortAdd[n];
        this.timeShort[n] = n2;
        this.timeShortAdd[n] = n3;
        return n4;
    }

    public void setTimeShort(int n, int n2, int n3) {
        this.timeShort[n] = n2;
        this.timeShortAdd[n] = n3;
    }

    public static final class Track {
        public final String name;
        public final char typeChar;
        public double max;
        public double min;
        float[] values_F;
        double[] values_D;
        int[] values_I;
        short[] values_S;

        protected Track(String string, char c, int n) {
            this.name = string;
            this.typeChar = c;
            switch (c) {
                case 'D': {
                    this.values_D = new double[n];
                    break;
                }
                case 'F': {
                    this.values_F = new float[n];
                    break;
                }
                case 'I': {
                    this.values_I = new int[n];
                    break;
                }
                case 'S': {
                    this.values_S = new short[n];
                    break;
                }
                default: {
                    throw new IllegalArgumentException(" org.vishia.util.TimedValues.Track: only D F I S is admissible as typechar");
                }
            }
        }

        public float getFloat(int n) {
            switch (this.typeChar) {
                case 'D': {
                    return (float)this.values_D[n];
                }
                case 'F': {
                    return this.values_F[n];
                }
                case 'I': {
                    return this.values_I[n];
                }
                case 'S': {
                    return this.values_S[n];
                }
            }
            throw new IllegalArgumentException("should not occure: typeChar faulty");
        }

        public int getInt(int n) {
            switch (this.typeChar) {
                case 'D': {
                    return (int)this.values_D[n];
                }
                case 'F': {
                    return (int)this.values_F[n];
                }
                case 'I': {
                    return this.values_I[n];
                }
                case 'S': {
                    return this.values_S[n];
                }
            }
            throw new IllegalArgumentException("should not occure: typeChar faulty");
        }

        public double getDouble(int n) {
            switch (this.typeChar) {
                case 'D': {
                    return this.values_D[n];
                }
                case 'F': {
                    return this.values_F[n];
                }
                case 'I': {
                    return this.values_I[n];
                }
                case 'S': {
                    return this.values_S[n];
                }
            }
            throw new IllegalArgumentException("should not occure: typeChar faulty");
        }

        public void setFloat(int n, float f) {
            switch (this.typeChar) {
                case 'D': {
                    this.values_D[n] = f;
                    break;
                }
                case 'F': {
                    this.values_F[n] = f;
                    break;
                }
                case 'I': {
                    this.values_I[n] = (int)f;
                    throw new IllegalArgumentException("assignment float to int");
                }
                case 'S': {
                    this.values_S[n] = (short)f;
                    throw new IllegalArgumentException("assignment float to short");
                }
                default: {
                    throw new IllegalArgumentException("should not occure: typeChar faulty");
                }
            }
        }

        public void setDouble(int n, double d) {
            switch (this.typeChar) {
                case 'D': {
                    this.values_D[n] = d;
                    break;
                }
                case 'F': {
                    this.values_F[n] = (float)d;
                    break;
                }
                case 'I': {
                    this.values_I[n] = (int)d;
                    throw new IllegalArgumentException("assignment double to int");
                }
                case 'S': {
                    this.values_S[n] = (short)d;
                    throw new IllegalArgumentException("assignment double to short");
                }
                default: {
                    throw new IllegalArgumentException("should not occure: typeChar faulty");
                }
            }
        }

        public void setInt(int n, int n2) {
            switch (this.typeChar) {
                case 'D': {
                    this.values_D[n] = n2;
                    break;
                }
                case 'F': {
                    this.values_F[n] = n2;
                    break;
                }
                case 'I': {
                    this.values_I[n] = n2;
                }
                case 'S': {
                    this.values_S[n] = (short)n2;
                    throw new IllegalArgumentException("assignment int to short");
                }
                default: {
                    throw new IllegalArgumentException("should not occure: typeChar faulty");
                }
            }
        }

        public void setShort(int n, short s) {
            switch (this.typeChar) {
                case 'D': {
                    this.values_D[n] = s;
                    break;
                }
                case 'F': {
                    this.values_F[n] = s;
                    break;
                }
                case 'I': {
                    this.values_I[n] = s;
                    break;
                }
                case 'S': {
                    this.values_S[n] = s;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("should not occure: typeChar faulty");
                }
            }
        }
    }
}

