/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.vishia.util.Debugutil;

public class LinkedListLock<T>
extends LinkedList<T> {
    private static final long serialVersionUID = 1L;
    boolean bLock;

    public LinkedListLock() {
    }

    public LinkedListLock(Collection<? extends T> collection) {
        super(collection);
    }

    public boolean lock() {
        boolean bl = this.bLock;
        this.bLock = true;
        return bl;
    }

    public void unlock() {
        if (!this.bLock) {
            throw new IllegalStateException("unlock():List is not locked");
        }
        this.bLock = false;
    }

    @Override
    public boolean add(T t) {
        if (this.bLock) {
            Debugutil.stop();
        }
        return super.add(t);
    }

    @Override
    public Iterator<T> iterator() {
        if (!this.bLock) {
            this.lock();
        }
        return super.iterator();
    }
}

