/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import org.vishia.bridgeC.DivideJc;

public class IntegerBlockArray {
    public static final int version = 538181889;
    int[] array;
    int bit1 = 10;
    int bit2 = 7;
    int size;
    IntegerBlockArray[] blocks;

    IntegerBlockArray(int n) {
        this.setSize(n);
    }

    int get(int n) {
        if (this.blocks != null) {
            DivideJc divideJc = DivideJc.divLess2pow(n, this.bit1, this.bit2);
            IntegerBlockArray integerBlockArray = this.blocks[divideJc.q];
            if (integerBlockArray == null) {
                return 0;
            }
            return integerBlockArray.get(divideJc.r);
        }
        return this.array[n];
    }

    void set(int n, int n2) {
        if (this.blocks != null) {
            DivideJc divideJc = DivideJc.divLess2pow(n, this.bit1, this.bit2);
            IntegerBlockArray integerBlockArray = this.blocks[divideJc.q];
            if (integerBlockArray == null) {
                int n3 = (1 << this.bit1) - (1 << this.bit2);
                integerBlockArray = this.blocks[divideJc.q] = new IntegerBlockArray(n3);
            }
            integerBlockArray.set(divideJc.r, n2);
        } else {
            this.array[n] = n2;
        }
    }

    void setSize(int n) {
        if (n >= this.size) {
            int n2 = (1 << this.bit1) - (1 << this.bit2);
            if (n <= n2) {
                if (this.array == null) {
                    this.array = new int[n];
                } else {
                    int[] nArray = this.array;
                    this.array = new int[n];
                    System.arraycopy(nArray, 0, this.array, 0, nArray.length);
                }
            } else {
                DivideJc divideJc = DivideJc.divLess2pow(n, this.bit1, this.bit2);
                this.blocks = new IntegerBlockArray[n2];
            }
            this.size = n;
        }
    }

    public int binarySearch(int n, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            int n6 = this.get(n5);
            if (n6 < n) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public int binarySearchFirstKey(int n, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = 0;
        boolean bl = false;
        while (n3 <= n4) {
            n5 = n3 + n4 >> 1;
            int n6 = this.get(n5);
            if (n6 < n) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5 - 1;
            bl = bl || n6 > n;
        }
        if (bl) {
            return n3 > n5 ? n3 : n5;
        }
        return -(n3 + 1);
    }

    public static void main(String[] stringArray) {
        IntegerBlockArray integerBlockArray = new IntegerBlockArray(5000);
        integerBlockArray.set(234, 43981);
        integerBlockArray.set(4690, 18064);
        int n = integerBlockArray.get(234);
        assert (n == 43981);
        n = integerBlockArray.get(4690);
        assert (n == 18064);
        n = integerBlockArray.get(2048);
        assert (n == 0);
        n = integerBlockArray.get(2047);
        assert (n == 0);
    }
}

