/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.util;

import java.util.Arrays;
import org.vishia.bridgeC.AllocInBlock;
import org.vishia.util.Debugutil;
import org.vishia.util.IndexMultiTable;
import org.vishia.util.StringFunctions;

class IndexMultiTable_Table<Key extends Comparable<Key>, Type> {
    public static final String sVersion = "2016-10-15";
    protected static final int maxBlock = AllocInBlock.restSizeBlock(IndexMultiTable.class, 200) / 8;
    static int identParent_ = 100;
    protected final Key[] aKeys;
    protected final Object[] aValues = new Object[maxBlock];
    int sizeBlock;
    int sizeAll;
    protected boolean isHyperBlock;
    final int identParent = ++identParent_;
    int ixInParent;
    IndexMultiTable_Table<Key, Type> parent;
    final IndexMultiTable<Key, Type> rootIdxTable;

    IndexMultiTable_Table(IndexMultiTable.Provide<Key> provide) {
        this.rootIdxTable = (IndexMultiTable)this;
        this.aKeys = (Comparable[])provide.createSortKeyArray(maxBlock);
        Comparable comparable = (Comparable)provide.getMaxSortKey();
        for (int i = 0; i < maxBlock; ++i) {
            this.aKeys[i] = comparable;
        }
        this.sizeBlock = 0;
        this.ixInParent = -1;
    }

    IndexMultiTable_Table(IndexMultiTable<Key, Type> indexMultiTable) {
        this.rootIdxTable = indexMultiTable;
        this.aKeys = (Comparable[])this.rootIdxTable.provider.createSortKeyArray(maxBlock);
        for (int i = 0; i < maxBlock; ++i) {
            this.aKeys[i] = this.rootIdxTable.maxKey__;
        }
        this.sizeBlock = 0;
        this.ixInParent = -1;
    }

    int binarySearchFirstKey(Comparable<Key>[] comparableArray, int n, int n2, Object object) {
        int n3 = n;
        int n4 = n2 - 1;
        int n5 = 0;
        boolean bl = false;
        while (n3 <= n4) {
            n5 = n3 + n4 >> 1;
            Comparable<Key> comparable = comparableArray[n5];
            int n6 = this.compare(comparable, object);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5 - 1;
            bl = bl || n6 == 0;
        }
        if (bl) {
            return n3 > n5 ? n3 : n5;
        }
        return -(n3 + 1);
    }

    protected int compare(Comparable<Key> comparable, Object object) {
        int n;
        if (comparable instanceof CharSequence) {
            CharSequence charSequence = object instanceof CharSequence ? (CharSequence)object : object.toString();
            n = StringFunctions.compare((CharSequence)((Object)comparable), charSequence);
        } else {
            Comparable comparable2 = (Comparable)object;
            n = comparable.compareTo(comparable2);
        }
        return n;
    }

    Type putOrAdd(Key Key2, Type Type2, Type Type3, IndexMultiTable.KindofAdd kindofAdd) {
        int n;
        Object object = null;
        if (this.isHyperBlock && this.sizeBlock == maxBlock) {
            if (this.parent != null) {
                IndexMultiTable_Table<Object, Type> indexMultiTable_Table = this.splitIntoSibling(-1, null, null);
                if (this.compare((Comparable<Key>)indexMultiTable_Table.aKeys[0], Key2) <= 0) {
                    return indexMultiTable_Table.putOrAdd(Key2, Type2, Type3, kindofAdd);
                }
            } else {
                this.splitTopLevel(-1, null, null);
            }
        }
        if ((n = Arrays.binarySearch(this.aKeys, Key2)) < 0) {
            n = -n - 1;
            if (this.isHyperBlock) {
                if (--n < 0) {
                    n = 0;
                }
                IndexMultiTable_Table indexMultiTable_Table = (IndexMultiTable_Table)this.aValues[n];
                object = indexMultiTable_Table.putOrAdd(Key2, Type2, Type3, kindofAdd);
            } else if (n < 0) {
                n = -n - 1;
                this.sortin(n, Key2, Type2);
            } else {
                this.sortin(n, Key2, Type2);
            }
        } else {
            switch (kindofAdd) {
                case replace: {
                    Object object2;
                    if (this.isHyperBlock) {
                        IndexMultiTable_Table indexMultiTable_Table = (IndexMultiTable_Table)this.aValues[n];
                        object = indexMultiTable_Table.putOrAdd(Key2, Type2, Type3, kindofAdd);
                        break;
                    }
                    object = object2 = this.aValues[n];
                    this.aValues[n] = Type2;
                    break;
                }
                case addBefore: {
                    boolean bl = this.searchAndSortin(Key2, Type2, n, Type3);
                    if (bl) break;
                    this.searchbackAndSortin(Key2, Type2, n, Type3);
                    break;
                }
                case addLast: {
                    assert (Type3 == null);
                    this.searchLastAndSortin(Key2, Type2, n);
                    break;
                }
                case addOptimized: {
                    if (this.isHyperBlock) {
                        IndexMultiTable_Table indexMultiTable_Table = (IndexMultiTable_Table)this.aValues[n];
                        indexMultiTable_Table.putOrAdd(Key2, Type2, Type3, kindofAdd);
                        break;
                    }
                    this.sortin(n, Key2, Type2);
                }
            }
        }
        return (Type)object;
    }

    boolean searchLastAndSortin(Key Key2, Type Type2, int n) {
        boolean bl = true;
        int n2 = n;
        IndexMultiTable_Table<Key, Type> indexMultiTable_Table = this.parent;
        IndexMultiTable_Table<Key, Type> indexMultiTable_Table2 = this;
        while (indexMultiTable_Table != null) {
            if (indexMultiTable_Table2.ixInParent + 1 < indexMultiTable_Table.sizeBlock && this.compare((Comparable<Key>)indexMultiTable_Table.aKeys[indexMultiTable_Table2.ixInParent + 1], Key2) == 0) {
                return indexMultiTable_Table.searchLastAndSortin(Key2, Type2, this.ixInParent + 1);
            }
            if (indexMultiTable_Table2.ixInParent == indexMultiTable_Table.sizeBlock) {
                indexMultiTable_Table2 = indexMultiTable_Table;
                indexMultiTable_Table = indexMultiTable_Table.parent;
                continue;
            }
            indexMultiTable_Table = null;
        }
        while (bl && n2 < this.sizeBlock) {
            if (++n2 != this.sizeBlock && this.compare((Comparable<Key>)this.aKeys[n2], Key2) == 0) continue;
            if (this.isHyperBlock) {
                IndexMultiTable_Table indexMultiTable_Table3 = (IndexMultiTable_Table)this.aValues[--n2];
                indexMultiTable_Table3.searchLastAndSortin(Key2, Type2, 0);
                bl = false;
                continue;
            }
            bl = false;
            this.sortin(n2, Key2, Type2);
        }
        return !bl;
    }

    boolean searchAndSortin(Key Key2, Type Type2, int n, Type Type3) {
        boolean bl = true;
        boolean bl2 = false;
        int n2 = n;
        while (bl && n2 < this.sizeBlock) {
            if (this.isHyperBlock) {
                IndexMultiTable_Table indexMultiTable_Table = (IndexMultiTable_Table)this.aValues[n2];
                bl2 = indexMultiTable_Table.searchAndSortin(Key2, Type2, n2, Type3);
                bl = !bl2;
                if (!bl) continue;
                ++n2;
                continue;
            }
            if (n2 < this.sizeBlock - 1 || this.aValues[n2 + 1] == Type3) {
                this.sortin(n2, Key2, Type2);
                bl2 = true;
                bl = false;
                continue;
            }
            if (++n2 >= this.sizeBlock || this.compare((Comparable<Key>)this.aKeys[n2], Key2) == 0) continue;
            bl = false;
        }
        return bl2;
    }

    boolean searchbackAndSortin(Key Key2, Type Type2, int n, Type Type3) {
        return false;
    }

    void sortin(int n, Key Key2, Object object) {
        if (this.sizeBlock == maxBlock) {
            if (this.isHyperBlock) {
                this.rootIdxTable.stop();
            }
            if (this.parent != null) {
                this.splitIntoSibling(n, Key2, object);
            } else {
                this.splitTopLevel(n, Key2, object);
            }
        } else {
            if (n < this.sizeBlock) {
                this.movein(this, this, n, n + 1, this.sizeBlock - n);
            }
            ++this.sizeBlock;
            this.setKeyValue(n, Key2, object);
            if (object instanceof IndexMultiTable_Table && !(object instanceof IndexMultiTable)) {
                IndexMultiTable_Table indexMultiTable_Table = (IndexMultiTable_Table)object;
                indexMultiTable_Table.ixInParent = n;
                indexMultiTable_Table.parent = this;
            } else {
                this.addSizeAll(1);
            }
        }
    }

    private void splitTopLevel(int n, Key Key2, Object object) {
        IndexMultiTable_Table<Key, Type> indexMultiTable_Table = new IndexMultiTable_Table<Key, Type>(this.rootIdxTable);
        IndexMultiTable_Table<Key, Type> indexMultiTable_Table2 = new IndexMultiTable_Table<Key, Type>(this.rootIdxTable);
        indexMultiTable_Table.parent = indexMultiTable_Table2.parent = this;
        indexMultiTable_Table.isHyperBlock = indexMultiTable_Table2.isHyperBlock = this.isHyperBlock;
        indexMultiTable_Table.ixInParent = 0;
        indexMultiTable_Table2.ixInParent = 1;
        this.isHyperBlock = true;
        int n2 = this.sizeBlock / 2;
        IndexMultiTable_Table indexMultiTable_Table3 = this;
        if (n > n2) {
            indexMultiTable_Table.sizeAll = this.movein(indexMultiTable_Table3, indexMultiTable_Table, 0, 0, n2);
            indexMultiTable_Table.sizeBlock = n2;
            indexMultiTable_Table2.sizeAll = this.movein(indexMultiTable_Table3, indexMultiTable_Table2, n2, 0, n - n2);
            int n3 = n - n2;
            indexMultiTable_Table2.aKeys[n3] = Key2;
            indexMultiTable_Table2.aValues[n3] = object;
            if (object instanceof IndexMultiTable_Table && !(object instanceof IndexMultiTable)) {
                IndexMultiTable_Table indexMultiTable_Table4 = (IndexMultiTable_Table)object;
                indexMultiTable_Table2.sizeAll += indexMultiTable_Table4.sizeAll;
                indexMultiTable_Table4.ixInParent = n3;
                indexMultiTable_Table4.parent = indexMultiTable_Table2;
            } else {
                super.addSizeAll(1);
            }
            indexMultiTable_Table2.sizeAll += this.movein(indexMultiTable_Table3, indexMultiTable_Table2, n, n3 + 1, this.sizeBlock - n);
            indexMultiTable_Table2.sizeBlock = this.sizeBlock - n2 + 1;
            this.aValues[0] = indexMultiTable_Table;
            this.aValues[1] = indexMultiTable_Table2;
            indexMultiTable_Table.check();
            indexMultiTable_Table2.check();
        } else {
            if (n >= 0) {
                indexMultiTable_Table.sizeAll = this.movein(indexMultiTable_Table3, indexMultiTable_Table, 0, 0, n);
                indexMultiTable_Table.aKeys[n] = Key2;
                indexMultiTable_Table.aValues[n] = object;
                if (object instanceof IndexMultiTable_Table && !(object instanceof IndexMultiTable)) {
                    IndexMultiTable_Table indexMultiTable_Table5 = (IndexMultiTable_Table)object;
                    indexMultiTable_Table5.ixInParent = n;
                    indexMultiTable_Table5.parent = indexMultiTable_Table;
                }
                super.addSizeAll(1);
                indexMultiTable_Table.sizeAll += this.movein(indexMultiTable_Table3, indexMultiTable_Table, n, n + 1, n2 - n);
                indexMultiTable_Table.sizeBlock = n2 + 1;
            } else {
                indexMultiTable_Table.sizeAll = this.movein(indexMultiTable_Table3, indexMultiTable_Table, 0, 0, n2);
                indexMultiTable_Table.sizeBlock = n2;
            }
            indexMultiTable_Table2.sizeAll = this.movein(indexMultiTable_Table3, indexMultiTable_Table2, n2, 0, this.sizeBlock - n2);
            indexMultiTable_Table2.sizeBlock = this.sizeBlock - n2;
            this.aValues[0] = indexMultiTable_Table;
            this.aValues[1] = indexMultiTable_Table2;
        }
        this.aKeys[0] = indexMultiTable_Table.aKeys[0];
        this.aKeys[1] = indexMultiTable_Table2.aKeys[0];
        this.sizeBlock = 2;
        this.clearRestArray(indexMultiTable_Table3);
        if (this.rootIdxTable.shouldCheck) {
            this.check();
        }
    }

    private IndexMultiTable_Table<Key, Type> splitIntoSibling(int n, Key Key2, Object object) {
        IndexMultiTable_Table<Key, Type> indexMultiTable_Table = new IndexMultiTable_Table<Key, Type>(this.rootIdxTable);
        indexMultiTable_Table.parent = this.parent;
        indexMultiTable_Table.isHyperBlock = this.isHyperBlock;
        indexMultiTable_Table.ixInParent = this.ixInParent + 1;
        int n2 = this.sizeBlock / 2;
        if (n > n2) {
            int n3 = n - n2;
            if (n3 > 0) {
                indexMultiTable_Table.sizeAll = this.movein(this, indexMultiTable_Table, n2, 0, n3);
            }
            indexMultiTable_Table.aKeys[n3] = Key2;
            indexMultiTable_Table.aValues[n3] = object;
            if (this.sizeBlock > n) {
                indexMultiTable_Table.sizeAll += this.movein(this, indexMultiTable_Table, n, n3 + 1, this.sizeBlock - n);
            }
            indexMultiTable_Table.sizeBlock = this.sizeBlock - n2 + 1;
            this.sizeBlock = n2;
            this.sizeAll -= indexMultiTable_Table.sizeAll;
            if (object instanceof IndexMultiTable_Table && !(object instanceof IndexMultiTable)) {
                IndexMultiTable_Table indexMultiTable_Table2 = (IndexMultiTable_Table)object;
                indexMultiTable_Table2.ixInParent = n3;
                indexMultiTable_Table2.parent = indexMultiTable_Table;
            }
            this.clearRestArray(this);
            this.parent.sortin(indexMultiTable_Table.ixInParent, indexMultiTable_Table.aKeys[0], indexMultiTable_Table);
            if (!(object instanceof IndexMultiTable_Table) || object instanceof IndexMultiTable) {
                super.addSizeAll(1);
            }
        } else {
            indexMultiTable_Table.sizeAll = this.movein(this, indexMultiTable_Table, n2, 0, this.sizeBlock - n2);
            indexMultiTable_Table.sizeBlock = this.sizeBlock - n2;
            if (n >= 0) {
                if (n < n2) {
                    this.movein(this, this, n, n + 1, n2 - n);
                }
                this.sizeBlock = n2 + 1;
                this.sizeAll -= indexMultiTable_Table.sizeAll;
                this.setKeyValue(n, Key2, object);
                if (object instanceof IndexMultiTable_Table && !(object instanceof IndexMultiTable)) {
                    IndexMultiTable_Table indexMultiTable_Table3 = (IndexMultiTable_Table)object;
                    indexMultiTable_Table3.ixInParent = n;
                    indexMultiTable_Table3.parent = this;
                }
            } else {
                this.sizeBlock = n2;
                this.sizeAll -= indexMultiTable_Table.sizeAll;
            }
            this.clearRestArray(this);
            this.parent.sortin(indexMultiTable_Table.ixInParent, indexMultiTable_Table.aKeys[0], indexMultiTable_Table);
            if (n >= 0 && (!(object instanceof IndexMultiTable_Table) || object instanceof IndexMultiTable)) {
                this.addSizeAll(1);
            }
        }
        return indexMultiTable_Table;
    }

    int movein(IndexMultiTable_Table<Key, Type> indexMultiTable_Table, IndexMultiTable_Table<Key, Type> indexMultiTable_Table2, int n, int n2, int n3) {
        boolean bl;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = n3;
        if (indexMultiTable_Table == indexMultiTable_Table2 && n < n2) {
            n6 = -1;
            n5 = n + n3 - 1;
            n4 = n2 + n3 - 1;
        } else {
            n6 = 1;
            n5 = n;
            n4 = n2;
        }
        boolean bl2 = bl = n3 > 0 && indexMultiTable_Table.aValues[n] instanceof IndexMultiTable_Table && !(indexMultiTable_Table.aValues[n] instanceof IndexMultiTable);
        while (--n8 >= 0) {
            Object object = indexMultiTable_Table.aValues[n5];
            if (bl) {
                IndexMultiTable_Table indexMultiTable_Table3 = (IndexMultiTable_Table)object;
                indexMultiTable_Table3.ixInParent = n4;
                indexMultiTable_Table3.parent = indexMultiTable_Table2;
                n7 += indexMultiTable_Table3.sizeAll;
            } else {
                ++n7;
            }
            indexMultiTable_Table2.aValues[n4] = object;
            indexMultiTable_Table2.aKeys[n4] = indexMultiTable_Table.aKeys[n5];
            n5 += n6;
            n4 += n6;
        }
        return n7;
    }

    void clearRestArray(IndexMultiTable_Table<Key, Type> indexMultiTable_Table) {
        for (int i = indexMultiTable_Table.sizeBlock; i < maxBlock; ++i) {
            indexMultiTable_Table.aKeys[i] = this.rootIdxTable.maxKey__;
            indexMultiTable_Table.aValues[i] = null;
        }
    }

    protected void delete(int n) {
        --this.sizeBlock;
        if (!(this.aValues[n] instanceof IndexMultiTable_Table)) {
            this.addSizeAll(-1);
        }
        if (n < this.sizeBlock) {
            this.movein(this, this, n + 1, n, this.sizeBlock - n);
        }
        if (n == 0) {
            this.correctKey0InParents();
        }
        this.aKeys[this.sizeBlock] = this.rootIdxTable.maxKey__;
        this.aValues[this.sizeBlock] = null;
        if (this.sizeBlock == 0) {
            if (this.parent != null) {
                this.parent.delete(this.ixInParent);
            } else {
                this.isHyperBlock = false;
            }
        }
    }

    void clear() {
        for (int i = 0; i < this.sizeBlock; ++i) {
            if (this.isHyperBlock) {
                IndexMultiTable_Table indexMultiTable_Table = (IndexMultiTable_Table)this.aValues[i];
                indexMultiTable_Table.clear();
            }
            this.aValues[i] = null;
            this.aKeys[i] = this.rootIdxTable.maxKey__;
        }
        this.sizeBlock = 0;
        this.sizeAll = 0;
        this.isHyperBlock = false;
    }

    IndexMultiTable_Table<Key, Type> searchInTables(Object object, boolean bl, IndexMultiTable.IndexBox indexBox) {
        int n;
        IndexMultiTable_Table indexMultiTable_Table = this;
        while (indexMultiTable_Table.isHyperBlock) {
            IndexMultiTable_Table indexMultiTable_Table2;
            n = this.binarySearchFirstKey((Comparable<Key>[])indexMultiTable_Table.aKeys, 0, indexMultiTable_Table.sizeBlock, object);
            if (n < 0) {
                n = -n - 2;
            }
            if (n < 0) {
                return null;
            }
            assert (n < indexMultiTable_Table.sizeBlock);
            indexMultiTable_Table = indexMultiTable_Table2 = (IndexMultiTable_Table)indexMultiTable_Table.aValues[n];
        }
        n = this.binarySearchFirstKey((Comparable<Key>[])indexMultiTable_Table.aKeys, 0, indexMultiTable_Table.sizeBlock, object);
        if (n < 0) {
            if (bl) {
                return null;
            }
            n = -n - 2;
        } else {
            indexBox.found = true;
        }
        if (n >= 0) {
            indexBox.ix = n;
            return indexMultiTable_Table;
        }
        return null;
    }

    private void addSizeAll(int n) {
        this.sizeAll += n;
        if (this.parent != null) {
            super.addSizeAll(n);
        }
    }

    private void correctKey0InParents() {
        int n = 0;
        IndexMultiTable_Table<Key, Type> indexMultiTable_Table = this;
        while (indexMultiTable_Table.parent != null && n == 0) {
            n = indexMultiTable_Table.ixInParent;
            indexMultiTable_Table.parent.aKeys[n] = indexMultiTable_Table.aKeys[0];
            indexMultiTable_Table = indexMultiTable_Table.parent;
        }
    }

    private void setKeyValue(int n, Key Key2, Object object) {
        this.aKeys[n] = Key2;
        this.aValues[n] = object;
        if (n == 0) {
            this.correctKey0InParents();
        }
    }

    int check() {
        int n;
        int n2 = 0;
        if (this.parent != null) {
            IndexMultiTable_Table.assert1(this.parent.aValues[this.ixInParent] == this);
        }
        for (n = 1; n < this.sizeBlock; ++n) {
            IndexMultiTable_Table.assert1(this.compare((Comparable<Key>)this.aKeys[n - 1], this.aKeys[n]) <= 0);
            if (this.aValues[n] != null) continue;
            this.rootIdxTable.stop();
        }
        if (this.isHyperBlock) {
            for (n = 0; n < this.sizeBlock; ++n) {
                IndexMultiTable_Table.assert1(this.aValues[n] instanceof IndexMultiTable_Table && !(this.aValues[n] instanceof IndexMultiTable));
                IndexMultiTable_Table indexMultiTable_Table = (IndexMultiTable_Table)this.aValues[n];
                IndexMultiTable_Table.assert1(this.aKeys[n].equals(indexMultiTable_Table.aKeys[0]));
                IndexMultiTable_Table.assert1(indexMultiTable_Table.ixInParent == n);
                n2 += indexMultiTable_Table.check();
            }
        } else {
            n2 = this.sizeBlock;
        }
        IndexMultiTable_Table.assert1(n2 == this.sizeAll);
        for (n = this.sizeBlock; n < maxBlock; ++n) {
            IndexMultiTable_Table.assert1(this.aKeys[n] == this.rootIdxTable.maxKey__);
            IndexMultiTable_Table.assert1(this.aValues[n] == null);
        }
        return n2;
    }

    private static void assert1(boolean bl) {
        if (!bl) {
            Debugutil.stop();
            throw new RuntimeException("IndexMultiTable - is corrupted;");
        }
    }

    Key checkTable(IndexMultiTable_Table<Key, Type> indexMultiTable_Table, Key Key2, int n, Key Key3) {
        int n2;
        Key Key4 = Key3;
        IndexMultiTable_Table.assert1(indexMultiTable_Table == null || Key2.equals(this.aKeys[0]));
        IndexMultiTable_Table.assert1(this.parent == indexMultiTable_Table);
        IndexMultiTable_Table.assert1(this.ixInParent == n);
        for (n2 = 0; n2 < this.sizeBlock; ++n2) {
            IndexMultiTable_Table.assert1(this.compare((Comparable<Key>)this.aKeys[n2], Key4) >= 0);
            if (this.isHyperBlock) {
                IndexMultiTable_Table.assert1(this.aValues[n2] instanceof IndexMultiTable_Table && !(this.aValues[n2] instanceof IndexMultiTable));
                IndexMultiTable_Table indexMultiTable_Table2 = (IndexMultiTable_Table)this.aValues[n2];
                Key4 = indexMultiTable_Table2.checkTable(this, this.aKeys[n2], n2, Key4);
                continue;
            }
            IndexMultiTable_Table.assert1(!(this.aValues[n2] instanceof IndexMultiTable_Table) || this.aValues[n2] instanceof IndexMultiTable);
            Key4 = this.aKeys[n2];
        }
        for (n2 = this.sizeBlock; n2 < maxBlock; ++n2) {
            IndexMultiTable_Table.assert1(this.aKeys[n2] == this.rootIdxTable.maxKey__);
            IndexMultiTable_Table.assert1(this.aValues[n2] == null);
        }
        return Key4;
    }

    private void toString(StringBuilder stringBuilder) {
        if (this.sizeBlock == 0) {
            stringBuilder.append("..emptyIndexMultiTable...");
        } else if (this.isHyperBlock) {
            for (int i = 0; i < this.sizeBlock; ++i) {
                IndexMultiTable_Table indexMultiTable_Table = (IndexMultiTable_Table)this.aValues[i];
                indexMultiTable_Table.toString(stringBuilder);
            }
        } else {
            for (int i = 0; i < this.sizeBlock; ++i) {
                stringBuilder.append(this.aKeys[i]).append(", ");
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.parent != null) {
            stringBuilder.append("#").append(this.parent.identParent);
        }
        if (this.isHyperBlock) {
            stringBuilder.append(':');
        } else {
            stringBuilder.append('=');
        }
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }
}

