/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.msgDispatch;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.vishia.bridgeC.OS_TimeStamp;
import org.vishia.bridgeC.Va_list;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.msgDispatch.LogMessageBase;
import org.vishia.util.ExcUtil;
import org.vishia.util.StringFunctions;

public class LogMessageStream
extends LogMessageBase {
    public static final String sVersion = "2025-10-01";
    final FileDescriptor fd;
    final OutputStream out1;
    final OutputStream out2;
    final Appendable out3;
    final Appendable outErr;
    final boolean closeOnClose;
    final Charset encoding;
    byte[] sNewLine = new byte[]{10};
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM-dd HH:mm:ss.SSS: ");

    public static LogMessage create(FileDescriptor fileDescriptor) {
        return new LogMessageStream(fileDescriptor);
    }

    public LogMessageStream(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
        this.out1 = new FileOutputStream(fileDescriptor);
        this.out2 = null;
        this.out3 = null;
        this.outErr = null;
        this.closeOnClose = false;
        this.encoding = Charset.defaultCharset();
    }

    public LogMessageStream(OutputStream outputStream) {
        this.out1 = outputStream;
        this.fd = null;
        this.out2 = null;
        this.out3 = null;
        this.outErr = null;
        this.closeOnClose = false;
        this.encoding = Charset.defaultCharset();
    }

    public LogMessageStream(OutputStream outputStream, OutputStream outputStream2, Appendable appendable, boolean bl, Charset charset) {
        this.out1 = outputStream;
        this.fd = null;
        this.out2 = outputStream2;
        this.out3 = appendable;
        this.outErr = null;
        this.closeOnClose = bl;
        this.encoding = charset == null ? Charset.defaultCharset() : charset;
    }

    public LogMessageStream(OutputStream outputStream, OutputStream outputStream2, Appendable appendable, Appendable appendable2, boolean bl, Charset charset) {
        this.out1 = outputStream;
        this.fd = null;
        this.out2 = outputStream2;
        this.out3 = appendable;
        this.outErr = appendable2;
        this.closeOnClose = bl;
        this.encoding = charset == null ? Charset.defaultCharset() : charset;
    }

    @Override
    public boolean sendMsgVaList(int n, OS_TimeStamp oS_TimeStamp, CharSequence charSequence, Va_list va_list) {
        String string = "?";
        try {
            string = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + String.format(charSequence.toString(), va_list.get());
        }
        catch (Exception exception) {
            string = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + charSequence;
        }
        try {
            byte[] byArray = string.getBytes(this.encoding);
            if (this.out1 != null) {
                this.out1.write(byArray);
                this.out1.write(this.sNewLine);
            }
            if (this.out2 != null) {
                this.out2.write(byArray);
                this.out2.write(this.sNewLine);
            }
            if (this.out3 != null) {
                this.out3.append(string).append('\n');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void close() {
        CharSequence charSequence;
        if (this.out1 != null) {
            try {
                this.out1.close();
            }
            catch (IOException iOException) {
                charSequence = ExcUtil.exceptionInfo("ERROR on close ", iOException, 0, 10);
                System.err.println(charSequence);
            }
        }
        if (this.out2 != null) {
            try {
                this.out2.close();
            }
            catch (IOException iOException) {
                charSequence = ExcUtil.exceptionInfo("ERROR on close ", iOException, 0, 10);
                System.err.println(charSequence);
            }
        }
        if (this.out3 instanceof Closeable) {
            try {
                ((Closeable)((Object)this.out3)).close();
            }
            catch (IOException iOException) {
                charSequence = ExcUtil.exceptionInfo("ERROR on close ", iOException, 0, 10);
                System.err.println(charSequence);
            }
        }
        if (this.outErr instanceof Closeable) {
            try {
                ((Closeable)((Object)this.outErr)).close();
            }
            catch (IOException iOException) {
                charSequence = ExcUtil.exceptionInfo("ERROR on close ", iOException, 0, 10);
                System.err.println(charSequence);
            }
        }
    }

    @Override
    public void flush() {
        try {
            if (this.out1 != null) {
                this.out1.flush();
            }
            if (this.out2 != null) {
                this.out2.flush();
            }
            if (this.out3 instanceof Flushable) {
                ((Flushable)((Object)this.out3)).flush();
            }
            if (this.outErr instanceof Flushable) {
                ((Flushable)((Object)this.outErr)).flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public boolean sendMsg(int n, CharSequence charSequence, Object ... objectArray) {
        CharSequence charSequence2 = ExcUtil.stackInfo(" ", 2, 1);
        String string = this.dateFormat.format(new Date(System.currentTimeMillis())) + "; " + n + "; " + String.format(charSequence.toString(), objectArray) + charSequence2;
        try {
            byte[] byArray = string.getBytes(this.encoding);
            if (this.out1 != null) {
                this.out1.write(byArray);
                this.out1.write(this.sNewLine);
                this.out1.flush();
            }
            if (this.out2 != null) {
                this.out2.write(byArray);
                this.out2.write(this.sNewLine);
                this.out2.flush();
            }
            if (this.out3 != null) {
                this.out3.append(string).append('\n');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean sendMsgTime(int n, OS_TimeStamp oS_TimeStamp, CharSequence charSequence, Object ... objectArray) {
        String string = this.dateFormat.format(oS_TimeStamp) + "; " + n + "; " + String.format(charSequence.toString(), objectArray);
        try {
            byte[] byArray = string.getBytes(this.encoding);
            if (this.out1 != null) {
                this.out1.write(byArray);
                this.out1.write(this.sNewLine);
                this.out1.flush();
            }
            if (this.out2 != null) {
                this.out2.write(byArray);
                this.out2.write(this.sNewLine);
                this.out2.flush();
            }
            if (this.out3 != null) {
                this.out3.append(string).append('\n');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public Appendable append(CharSequence charSequence) throws IOException {
        byte[] byArray = charSequence.toString().getBytes(this.encoding);
        if (this.out1 != null) {
            this.out1.write(byArray);
        }
        if (this.out2 != null) {
            this.out2.write(byArray);
        }
        if ((StringFunctions.indexOf(charSequence, 0, 20, "ERROR") >= 0 || StringFunctions.indexOf(charSequence, 0, 20, "EXCEPTION") >= 0) && this.outErr != null) {
            this.outErr.append(charSequence);
        } else if (this.out3 != null) {
            this.out3.append(charSequence);
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
        byte[] byArray = charSequence.subSequence(n, n2).toString().getBytes(this.encoding);
        if (this.out1 != null) {
            this.out1.write(byArray);
        }
        if (this.out2 != null) {
            this.out2.write(byArray);
        }
        if (StringFunctions.indexOf(charSequence, n, n + 20, "ERROR") >= 0 && this.outErr != null) {
            this.outErr.append(charSequence, n, n2);
        } else if (this.out3 != null) {
            this.out3.append(charSequence, n, n2);
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        byte[] byArray = ("" + c).getBytes(this.encoding);
        if (this.out1 != null) {
            this.out1.write(byArray);
        }
        if (this.out2 != null) {
            this.out2.write(byArray);
        }
        if (this.out3 != null) {
            this.out3.append(c);
        }
        return this;
    }

    private void writeError(String string) {
        try {
            if (this.out1 != null || this.out2 != null) {
                byte[] byArray = string.getBytes(this.encoding);
                if (this.out1 != null) {
                    this.out1.write(byArray);
                }
                if (this.out2 != null) {
                    this.out2.write(byArray);
                }
            }
            if (this.outErr != null) {
                this.outErr.append(string);
            } else if (this.out3 != null) {
                this.out3.append(string);
            }
        }
        catch (IOException iOException) {
            System.err.println("EXCEPTION: " + string + "  exception:" + iOException.getMessage());
        }
    }

    @Override
    public void writeError(String string, Object ... objectArray) {
        this.writeError(String.format("\n" + string, objectArray));
        this.flush();
    }

    @Override
    public void writeErrorAdd(String string, Object ... objectArray) {
        this.writeError(String.format(string, objectArray));
        this.flush();
    }
}

