/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.util.Iterator;
import java.util.Map;
import org.vishia.event.EventWithDst;
import org.vishia.fileRemote.FileMark;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.fileRemote.FileRemoteProgressEvData;
import org.vishia.fileRemote.FileRemoteWalkerCallback;
import org.vishia.util.ExcUtil;
import org.vishia.util.FilepathFilterM;
import org.vishia.util.SortedTreeWalkerCallback;

public class FileRemoteWalker {
    public static final String sVersion = "2023-07-22";
    private WalkInfo walkInfo;
    final FileRemoteCmdEventData co;
    final FileRemoteWalkerCallback callback;
    final EventWithDst<FileRemoteProgressEvData, ?> evBack;

    public static void walkFileTree(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        FileRemoteWalker fileRemoteWalker = new FileRemoteWalker(fileRemoteCmdEventData, eventWithDst);
        fileRemoteWalker.walkFileTree();
    }

    public static void walkFileTreeThread(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        FileRemoteWalker fileRemoteWalker = new FileRemoteWalker(fileRemoteCmdEventData, eventWithDst);
        WalkThread walkThread = fileRemoteWalker.new WalkThread();
        walkThread.start();
    }

    public FileRemoteWalker(FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        this.co = fileRemoteCmdEventData;
        this.callback = fileRemoteCmdEventData.callback();
        this.evBack = eventWithDst;
    }

    protected void walkFileTree() {
        FilepathFilterM filepathFilterM = this.co.selectFilter() == null ? null : FilepathFilterM.createWildcardFilter(this.co.selectFilter());
        this.walkInfo = new WalkInfo(this.co.filesrc(), null, filepathFilterM);
        if (this.callback != null) {
            this.callback.start(this.co.filesrc(), this.co);
        }
        this.walkSubTree(this.co.filesrc(), this.co.depthWalk() <= 0 ? Integer.MAX_VALUE : this.co.depthWalk());
        if (this.callback != null) {
            this.callback.finished(this.co.filesrc());
        }
    }

    private SortedTreeWalkerCallback.Result walkSubTree(FileRemote fileRemote, int n) {
        SortedTreeWalkerCallback.Result result = this.preVisitDirectory(fileRemote);
        if (result == SortedTreeWalkerCallback.Result.cont) {
            Map<String, FileRemote> map = fileRemote.children();
            if (map != null) {
                Iterator<Map.Entry<String, FileRemote>> iterator = map.entrySet().iterator();
                while (result == SortedTreeWalkerCallback.Result.cont && iterator.hasNext()) {
                    try {
                        Map.Entry<String, FileRemote> entry = iterator.next();
                        FileRemote fileRemote2 = entry.getValue();
                        if (fileRemote2.isDirectory()) {
                            if (n > 1) {
                                result = this.walkSubTree(fileRemote2, n - 1);
                                continue;
                            }
                            result = this.visitFile(fileRemote2);
                            continue;
                        }
                        result = this.visitFile(fileRemote2);
                    }
                    catch (Exception exception) {
                        System.err.println(ExcUtil.exceptionInfo("FileRemote unexpected - walkSubtree", exception, 0, 20, true));
                    }
                }
            }
            result = this.postVisitDirectory(fileRemote);
        } else if (result == SortedTreeWalkerCallback.Result.skipSubtree) {
            result = SortedTreeWalkerCallback.Result.cont;
        }
        return result;
    }

    private SortedTreeWalkerCallback.Result preVisitDirectory(FileRemote fileRemote) {
        FilepathFilterM filepathFilterM;
        boolean bl;
        SortedTreeWalkerCallback.Result result = SortedTreeWalkerCallback.Result.cont;
        if (this.walkInfo.parent == null) {
            bl = true;
            filepathFilterM = this.walkInfo.fileFilter;
        } else {
            int n = this.co.selectMask();
            if ((n & Integer.MIN_VALUE) != 0 && (fileRemote.flags & 0x400) != 0) {
                bl = false;
                filepathFilterM = null;
            } else if (this.walkInfo.fileFilter == null) {
                bl = (n & 0x40000000) == 0;
                result = SortedTreeWalkerCallback.Result.cont;
                filepathFilterM = null;
            } else {
                String string = fileRemote.getName();
                filepathFilterM = this.walkInfo.fileFilter.check(string, true);
                boolean bl2 = bl = filepathFilterM != null;
            }
            if ((n & 0x3FFFFFFF) != 0) {
                boolean bl3;
                int n2 = fileRemote.getMark();
                boolean bl4 = bl3 = (n2 & 0x3FFFFFFF & n) != 0;
                bl = (n & 0x40000000) != 0 ? (bl |= bl3) : (bl &= bl3);
            }
        }
        if (!bl) {
            result = SortedTreeWalkerCallback.Result.skipSubtree;
        } else {
            if (this.walkInfo.parent != null && this.co.markSet() != 0 && (this.co.markSet() & Integer.MIN_VALUE) != 0) {
                fileRemote.resetMarked(this.co.markSet());
            }
            WalkInfo walkInfo = new WalkInfo(fileRemote, this.walkInfo, filepathFilterM);
            result = this.walkInfo.parent != null && this.callback != null ? this.callback.offerParentNode(fileRemote, null, walkInfo) : SortedTreeWalkerCallback.Result.cont;
            if (result == SortedTreeWalkerCallback.Result.cont) {
                this.walkInfo = walkInfo;
            }
        }
        return result;
    }

    private SortedTreeWalkerCallback.Result postVisitDirectory(FileRemote fileRemote) {
        SortedTreeWalkerCallback.Result result = SortedTreeWalkerCallback.Result.cont;
        if (this.walkInfo.nrofFilesSelected > 0 && this.co.markSetDir() != 0 && (this.co.markSetDir() & Integer.MIN_VALUE) == 0) {
            FileMark fileMark = this.walkInfo.dir.getCreateMark();
            fileMark.nrofBytesSelected = this.walkInfo.nrBytesInDirSelected;
            fileMark.nrofFilesSelected = this.walkInfo.nrofFilesSelected;
            fileMark.setMarked(this.co.markSetDir(), null);
        }
        result = this.walkInfo.parent != null && this.walkInfo.parent.parent != null && this.callback != null ? this.callback.finishedParentNode(this.walkInfo.dir, fileRemote, this.walkInfo) : SortedTreeWalkerCallback.Result.cont;
        if (this.walkInfo.parent != null) {
            this.walkInfo.parent.nrBytesInDirSelected += this.walkInfo.nrBytesInDirSelected;
            this.walkInfo.parent.nrofFilesSelected += this.walkInfo.nrofFilesSelected;
        }
        this.walkInfo = this.walkInfo.parent;
        return result;
    }

    private SortedTreeWalkerCallback.Result visitFile(FileRemote fileRemote) {
        Object object;
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = (fileRemote.flags & 0x10) != 0;
        if (this.evBack != null) {
            FileRemoteProgressEvData fileRemoteProgressEvData = this.evBack.data();
            if (bl2) {
                ++fileRemoteProgressEvData.nrDirVisited;
            } else {
                ++fileRemoteProgressEvData.nrFilesVisited;
            }
        }
        int n = this.co.selectMask();
        if (this.walkInfo.fileFilter == null) {
            bl = (n & 0x40000000) == 0;
        } else {
            object = fileRemote.getName();
            boolean bl4 = bl = this.walkInfo.fileFilter.check((String)object, bl2) != null;
        }
        if ((this.co.selectMask() & 0x3FFFFFFF) != 0) {
            boolean bl5;
            boolean bl6 = bl5 = (fileRemote.getMark() & 0x3FFFFFFF & this.co.selectMask()) != 0;
            bl = (n & 0x40000000) != 0 ? (bl |= bl5) : (bl &= bl5);
        }
        if (bl) {
            if ((this.co.markSet() & Integer.MIN_VALUE) != 0) {
                fileRemote.resetMarked(this.co.markSet());
            } else {
                fileRemote.setMarked(this.co.markSet());
            }
            ++this.walkInfo.nrofFilesSelected;
            this.walkInfo.nrBytesInDirSelected += fileRemote.length;
            object = this.callback != null ? this.callback.offerLeafNode(fileRemote, null) : SortedTreeWalkerCallback.Result.cont;
        } else {
            object = SortedTreeWalkerCallback.Result.cont;
        }
        return object;
    }

    class WalkThread
    extends Thread {
        WalkThread() {
            super("walkFileTreeThread");
        }

        @Override
        public void run() {
            try {
                FileRemoteWalker.this.walkFileTree();
            }
            catch (Exception exception) {
                CharSequence charSequence = ExcUtil.exceptionInfo("unexpected ", exception, 0, 10);
                System.err.println(charSequence);
            }
        }
    }

    public static class WalkInfo {
        public FileRemote dir;
        public long nrBytesInDir;
        public long nrBytesInDirSelected;
        public int nrofFilesSelected;
        public final FilepathFilterM fileFilter;
        public int levelProcessMarked;
        public final WalkInfo parent;

        public WalkInfo(FileRemote fileRemote, WalkInfo walkInfo, FilepathFilterM filepathFilterM) {
            this.dir = fileRemote;
            this.parent = walkInfo;
            this.levelProcessMarked = walkInfo == null ? 0 : walkInfo.levelProcessMarked - 1;
            this.fileFilter = filepathFilterM;
        }
    }
}

