/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileRemote;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.vishia.event.EventConsumer;
import org.vishia.event.EventSource;
import org.vishia.event.EventTimerThread;
import org.vishia.event.EventWithDst;
import org.vishia.fileLocalAccessor.FileAccessorLocalJava7;
import org.vishia.fileRemote.FileCluster;
import org.vishia.fileRemote.FileMark;
import org.vishia.fileRemote.FileRemoteAccessor;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.fileRemote.FileRemoteProgressEvData;
import org.vishia.fileRemote.FileRemoteProgressEventConsumer;
import org.vishia.fileRemote.FileRemoteWalker;
import org.vishia.fileRemote.FileRemoteWalkerCallback;
import org.vishia.util.Debugutil;
import org.vishia.util.ExcUtil;
import org.vishia.util.FileFunctions;
import org.vishia.util.FileSystem;
import org.vishia.util.MarkMask_ifc;
import org.vishia.util.StringFunctions;
import org.vishia.util.StringPart;
import org.vishia.util.TreeNodeNamed_ifc;

public class FileRemote
extends File
implements MarkMask_ifc,
TreeNodeNamed_ifc {
    private static final long serialVersionUID = -5568304770699633308L;
    public static final String version = "2023-06-17";
    public static final int modeCopyReadOnlyMask = 15;
    public static final int modeCopyReadOnlyNever = 1;
    public static final int modeCopyReadOnlyOverwrite = 3;
    public static final int modeCopyReadOnlyAks = 0;
    public static final int modeCopyExistMask = 240;
    public static final int modeCopyExistNewer = 16;
    public static final int modeCopyExistOlder = 32;
    public static final int modeCopyExistAll = 48;
    public static final int modeCopyExistSkip = 64;
    public static final int modeCopyExistAsk = 0;
    public static final int modeCopyCreateMask = 3840;
    public static final int modeCopyCreateNever = 512;
    public static final int modeCopyCreateYes = 768;
    public static final int modeCopyCreateAsk = 0;
    public static final int modeCmprLogNotEqualFiles = 1;
    public static final int modeCmprLogMissing2File = 2;
    public static final int modeCmprLogMissing1File = 4;
    public static final int modeCmprLogComparedFiles = 8;
    public static final int mExist = 1;
    public static final int mCanRead = 2;
    public static final int mCanWrite = 4;
    public static final int mHidden = 8;
    public static final int mDirectory = 16;
    public static final int mFile = 32;
    public static final int mExecute = 64;
    public static final int mExecuteAny = 128;
    public static final int mRelativePath = 256;
    public static final int mAbsPath = 512;
    public static final int mSymLinkedPath = 1024;
    public static final int mCanReadGrp = 2048;
    public static final int mCanWriteGrp = 4096;
    public static final int mExecuteGrp = 8192;
    public static final int mCanReadAny = 16384;
    public static final int mCanWriteAny = 32768;
    public static final int mRoot = 0x100000;
    public static final int mShouldRefresh = 0x10000000;
    public static final int mThreadIsRunning = 0x20000000;
    public static final int mRefreshChildPending = 0x40000000;
    public static final int mTested = Integer.MIN_VALUE;
    private static FileRemoteAccessorSelector accessorSelector;
    private static int ctIdent;
    private final int _ident;
    public static final FileCluster clusterOfApplication;
    public final FileCluster itsCluster;
    protected FileRemoteAccessor device;
    protected FileMark mark;
    public long timeRefresh;
    public long timeChildren;
    protected String sDir;
    protected String sFile;
    protected String sCanonicalPath;
    protected long date;
    protected long dateCreation;
    protected long dateLastAccess;
    protected long length;
    protected int flags;
    FileRemote parent;
    private Map<String, FileRemote> children;
    Object oFile;
    protected Path path;
    EventSource evSrc = new EventSource("FileLocalAccessor"){

        @Override
        public void notifyDequeued() {
        }

        @Override
        public void notifyConsumed(int n) {
        }

        @Override
        public void notifyRelinquished(int n) {
        }
    };
    private final InternalAccess acc_ = new InternalAccess();

    protected FileRemote(FileCluster fileCluster, FileRemoteAccessor fileRemoteAccessor, FileRemote fileRemote, CharSequence charSequence, long l, long l2, long l3, long l4, int n, Object object, boolean bl) {
        super(fileRemote == null ? charSequence.toString() : fileRemote.getPath() + "/" + charSequence);
        String string;
        if (fileRemote != null) {
            this.parent = fileRemote;
            this.sDir = fileRemote.getAbsolutePath();
            this.sFile = charSequence.toString();
            if (fileCluster != null && fileCluster != fileRemote.itsCluster) {
                throw new IllegalArgumentException("FileRemote.ctor - Mismatching cluster association; parent.itsCluster=" + fileRemote.itsCluster.toString() + ";  parameter cluster=" + fileCluster.toString() + ";");
            }
            this.itsCluster = fileRemote.itsCluster;
        } else {
            this.parent = null;
            int n2 = StringFunctions.lastIndexOf(charSequence, '/');
            if (n2 >= 0) {
                int n3 = charSequence.length();
                String string2 = this.sDir = n2 == 0 ? "/" : charSequence.subSequence(0, n2).toString();
                this.sFile = n2 == 0 && n3 == 1 || n2 == 2 && charSequence.charAt(1) == ':' && n3 == 3 ? "/" : charSequence.subSequence(n2 + 1, charSequence.length()).toString();
            } else {
                this.sDir = "";
                this.sFile = charSequence.toString();
            }
            this.itsCluster = fileCluster == null ? clusterOfApplication : fileCluster;
        }
        this._ident = ++ctIdent;
        this.device = fileRemoteAccessor;
        this.flags = n;
        ExcUtil.check(this.sDir != null);
        ExcUtil.check(l >= 0L);
        this.oFile = object;
        this.length = l;
        this.date = l2;
        this.dateCreation = l3;
        this.dateLastAccess = l4;
        this.sCanonicalPath = string = this.sDir + (this.sFile != null ? "/" + this.sFile : "");
        this.path = Paths.get(string, new String[0]);
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if (fileRemote != null) {
            fileRemote.putNewChild(this);
        }
    }

    public Path path() {
        return this.path;
    }

    public File file() {
        return this.oFile instanceof File ? (File)this.oFile : null;
    }

    public FileRemote child(CharSequence charSequence) {
        return this.child(charSequence, 0, 0, 0L, 0L, 0L);
    }

    public FileRemote subdir(CharSequence charSequence) {
        return this.child(charSequence, 16, 0, 0L, 0L, 0L);
    }

    private FileRemote child(CharSequence charSequence, int n, int n2, long l, long l2, long l3) {
        FileRemote fileRemote;
        StringPart stringPart;
        CharSequence charSequence2 = FileSystem.normalizePath(charSequence);
        int n3 = StringFunctions.indexOf(charSequence2, '/', 0);
        if (n3 >= 0) {
            stringPart = new StringPart(charSequence2, 0, charSequence2.length());
            charSequence2 = stringPart.lento('/');
        } else {
            stringPart = null;
        }
        FileRemote fileRemote2 = this;
        boolean bl = true;
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder(100);
        boolean bl2 = this.sDir.length() >= 2 && this.sDir.charAt(1) == ':';
        do {
            stringBuilder.setLength(0);
            fileRemote2.setPathTo(stringBuilder).append('/').append(charSequence2);
            CharSequence charSequence3 = bl2 ? charSequence2.toString().toUpperCase() : charSequence2;
            FileRemote fileRemote3 = fileRemote = fileRemote2.children == null ? null : fileRemote2.children.get(charSequence3.toString());
            if (fileRemote == null) {
                if (stringPart != null) {
                    fileRemote = this.itsCluster.getFile(stringBuilder, null, false);
                } else {
                    fileRemote = new FileRemote(this.itsCluster, this.device, fileRemote2, charSequence2, n2, l, l2, l3, n, null, true);
                    fileRemote2.putNewChild(fileRemote);
                }
            } else if (StringFunctions.compare(fileRemote.sFile, charSequence2) != 0) {
                fileRemote.sFile = charSequence2.toString();
            }
            if (stringPart != null) {
                fileRemote2 = fileRemote;
                charSequence2 = stringPart.fromEnd().seek(1).lento('/');
                if (stringPart.found()) continue;
                n4 = 32;
                stringPart.len0end();
                if (stringPart.length() == 0) {
                    bl = false;
                }
                stringPart = null;
                continue;
            }
            bl = false;
        } while (bl);
        return fileRemote;
    }

    public FileRemote getChild(CharSequence charSequence) {
        boolean bl = this.sDir.length() >= 2 && this.sDir.charAt(1) == ':';
        String string = bl ? charSequence.toString().toUpperCase() : charSequence.toString();
        return this.children == null ? null : this.children.get(string);
    }

    public Map<String, FileRemote> children() {
        return this.children;
    }

    public void cleanChildren() {
        this.children = null;
        this.flags |= 0x10000000;
    }

    public static Map<String, FileRemote> createChildrenList() {
        return new TreeMap<String, FileRemote>();
    }

    public static boolean setAccessorSelector(FileRemoteAccessorSelector fileRemoteAccessorSelector) {
        boolean bl = accessorSelector != null;
        accessorSelector = fileRemoteAccessorSelector;
        return bl;
    }

    public static FileRemoteAccessorSelector getAccessorSelector() {
        if (accessorSelector == null) {
            accessorSelector = FileAccessorLocalJava7.selectLocalFileAlways;
        }
        return accessorSelector;
    }

    public static FileRemote fromFile(File file) {
        if (file instanceof FileRemote) {
            return (FileRemote)file;
        }
        return FileRemote.get(file.getAbsolutePath());
    }

    public static FileRemote get(FileCluster fileCluster, String string) {
        FileRemoteAccessor fileRemoteAccessor = FileRemote.getAccessorSelector().selectFileRemoteAccessor(string);
        CharSequence charSequence = null;
        if (fileRemoteAccessor != null) {
            charSequence = fileRemoteAccessor.completeFilePath(string);
        }
        CharSequence[] charSequenceArray = FileFunctions.separateDirName(charSequence);
        return fileCluster.getFile(charSequenceArray[0], charSequenceArray[1]);
    }

    public static FileRemote get(String string) {
        return FileRemote.get(clusterOfApplication, string);
    }

    public static FileRemote getDir(FileCluster fileCluster, CharSequence charSequence) {
        FileRemoteAccessor fileRemoteAccessor = FileRemote.getAccessorSelector().selectFileRemoteAccessor(charSequence);
        CharSequence charSequence2 = null;
        if (fileRemoteAccessor != null) {
            charSequence2 = fileRemoteAccessor.completeFilePath(charSequence);
        }
        return fileCluster.getFile(charSequence2, null);
    }

    public static FileRemote getDir(CharSequence charSequence) {
        return FileRemote.getDir(clusterOfApplication, charSequence);
    }

    public static FileRemote getFile(FileCluster fileCluster, CharSequence charSequence, CharSequence charSequence2) {
        FileRemoteAccessor fileRemoteAccessor = FileRemote.getAccessorSelector().selectFileRemoteAccessor(charSequence);
        CharSequence charSequence3 = null;
        if (fileRemoteAccessor != null) {
            charSequence3 = fileRemoteAccessor.completeFilePath(charSequence);
        }
        return fileCluster.getFile(charSequence3, charSequence2);
    }

    public static FileRemote getFile(CharSequence charSequence, CharSequence charSequence2) {
        return FileRemote.getFile(clusterOfApplication, charSequence, charSequence2);
    }

    public FileRemoteAccessor device() {
        return this.device;
    }

    void putNewChild(FileRemote fileRemote) {
        if (this.children == null) {
            this.children = FileRemote.createChildrenList();
        }
        if (fileRemote.parent != this) {
            if (fileRemote.parent != null) {
                throw new IllegalStateException("faulty parent-child");
            }
            fileRemote.parent = this;
        }
        boolean bl = this.sDir.length() >= 2 && this.sDir.charAt(1) == ':';
        String string = bl ? fileRemote.sFile.toUpperCase() : fileRemote.sFile;
        this.children.put(string, fileRemote);
        fileRemote.flags &= 0xBFFFFFFF;
    }

    public void setShouldRefresh() {
        this.flags |= 0x10000000;
    }

    public void setDirShouldRefresh() {
        if (this.parent != null) {
            this.parent.setShouldRefresh();
        }
    }

    public boolean shouldRefresh() {
        return (this.flags & 0x10000000) != 0;
    }

    public long setMarked(int n) {
        if (this.mark == null) {
            this.mark = new FileMark(this);
        }
        this.mark.setMarked(n, this);
        return this.length();
    }

    public long resetMarked(int n) {
        if (this.mark != null) {
            this.mark.setNonMarked(n, this);
            return this.length();
        }
        return 0L;
    }

    public long resetMarkedRecurs(int n, int[] nArray) {
        return this.resetMarkedRecurs(n, nArray, 0);
    }

    private long resetMarkedRecurs(int n, int[] nArray, int n2) {
        long l = this.length();
        if (nArray != null) {
            nArray[0] = nArray[0] + 1;
        }
        if (this.mark != null) {
            this.mark.setNonMarked(n, this);
        }
        if (n2 > 1000) {
            throw new RuntimeException("FileRemote - resetMarkedRecurs,too many recursion");
        }
        if (this.children != null) {
            for (Map.Entry<String, FileRemote> entry : this.children.entrySet()) {
                FileRemote fileRemote = entry.getValue();
                l += fileRemote.resetMarkedRecurs(n, nArray, n2 + 1);
            }
        }
        return l;
    }

    public FileMark getCreateMark() {
        if (this.mark == null) {
            this.mark = new FileMark(this);
        }
        return this.mark;
    }

    public FileMark mark() {
        return this.mark;
    }

    @Override
    public int getMark() {
        return this.mark == null ? 0 : this.mark.getMark();
    }

    @Override
    public int setNonMarked(int n, Object object) {
        if (this.mark == null) {
            return 0;
        }
        return this.mark.setNonMarkedRecursively(n, object, false);
    }

    public int setNonMarkedRecursively(int n, Object object) {
        if (this.mark == null) {
            return 0;
        }
        return this.mark.setNonMarkedRecursively(n, object, true);
    }

    @Override
    public int setMarked(int n, Object object) {
        if (this.sFile.equals("ReleaseNotes.topic")) {
            Debugutil.stop();
        }
        if (this.mark == null) {
            this.mark = new FileMark(this);
        }
        return this.mark.setMarked(n, object);
    }

    public boolean isMarked(int n) {
        return this.mark != null && (this.mark.getMark() & n) != 0;
    }

    public void _setProperties(long l, long l2, long l3, long l4, int n, Object object) {
        this.length = l;
        this.date = l2;
        this.dateCreation = l3;
        this.dateLastAccess = l4;
        this.flags = n;
        this.oFile = object;
    }

    public void refreshProperties(EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        this.device.refreshFileProperties(this, eventWithDst);
    }

    public void cmdRemote(FileRemoteCmdEventData.Cmd cmd, FileRemote fileRemote, String string, int n, int n2, int n3, FileRemoteCmdEventData fileRemoteCmdEventData, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData2 = fileRemoteCmdEventData == null ? new FileRemoteCmdEventData() : fileRemoteCmdEventData.clean();
        fileRemoteCmdEventData2.setCmdWalkRemote(this, cmd, fileRemote, string, n, n2, n3);
        this.device.cmd(eventWithDst == null, fileRemoteCmdEventData2, eventWithDst);
    }

    public void walkLocal(FileRemote fileRemote, int n, int n2, String string, int n3, int n4, FileRemoteWalkerCallback fileRemoteWalkerCallback, FileRemoteCmdEventData fileRemoteCmdEventData, int n5, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData2 = fileRemoteCmdEventData == null ? new FileRemoteCmdEventData() : fileRemoteCmdEventData;
        fileRemoteCmdEventData2.setCmdWalkLocal(this, FileRemoteCmdEventData.Cmd.noCmd, fileRemote, n, n2, string, n3, n4, fileRemoteWalkerCallback, n5);
        if (eventWithDst == null || n5 < 0) {
            FileRemoteWalker.walkFileTree(fileRemoteCmdEventData2, eventWithDst);
        } else {
            FileRemoteWalker.walkFileTreeThread(fileRemoteCmdEventData2, eventWithDst);
        }
    }

    public void walkRemote(boolean bl, FileRemote fileRemote, int n, String string, int n2, int n3, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdWalkRemote(this, FileRemoteCmdEventData.Cmd.walkTest, fileRemote, string, n2, n3, n);
        this.device.cmd(bl, fileRemoteCmdEventData, eventWithDst);
    }

    public void refreshProperties() {
        this.refreshProperties(null);
    }

    public void refreshPropertiesAndChildren(boolean bl, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdWalkRemote(this, FileRemoteCmdEventData.Cmd.walkRefresh, null, null, 0, 0, 1);
        this.device.cmd(bl, fileRemoteCmdEventData, eventWithDst);
    }

    public void refreshAndMark(boolean bl, int n, int n2, int n3, String string, int n4, FileRemoteWalkerCallback fileRemoteWalkerCallback, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if (fileRemoteWalkerCallback != null) {
            Debugutil.stop();
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdWalkLocal(this, FileRemoteCmdEventData.Cmd.walkRefresh, null, n2, n3, string, n4, n, null, 0);
        this.device.cmd(bl, fileRemoteCmdEventData, eventWithDst);
    }

    public void refreshAndSearch(int n, String string, int n2, byte[] byArray, FileRemoteWalkerCallback fileRemoteWalkerCallback, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
    }

    public void cmprDirTreeTo(boolean bl, FileRemote fileRemote, String string, int n, int n2, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if (fileRemote.device == null) {
            fileRemote.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(fileRemote.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdWalkRemote(this, FileRemoteCmdEventData.Cmd.walkCompare, fileRemote, string, n, 100, 0);
        fileRemoteCmdEventData.modeCmpOper = n2;
        this.device.cmd(bl, fileRemoteCmdEventData, eventWithDst);
    }

    public void copyDirTreeTo(boolean bl, FileRemote fileRemote, int n, String string, int n2, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdWalkRemote(this, FileRemoteCmdEventData.Cmd.walkCopyDirTree, fileRemote, string, n2, 100, n);
        this.device.cmd(bl, fileRemoteCmdEventData, eventWithDst);
    }

    public void copyDirTreeTo(boolean bl, FileRemote fileRemote, int n, int n2, int n3, String string, int n4, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdWalkLocal(this, FileRemoteCmdEventData.Cmd.walkCopyDirTree, fileRemote, n2, n3, string, n4, n, null, 100);
        this.device.cmd(bl, fileRemoteCmdEventData, eventWithDst);
    }

    public void deleteFilesDirTree(boolean bl, int n, String string, int n2, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdWalkRemote(this, FileRemoteCmdEventData.Cmd.walkDelete, null, string, n2, 100, n);
        this.device.cmd(bl, fileRemoteCmdEventData, eventWithDst);
    }

    public String copyTo(FileRemote fileRemote, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdChgFileRemote(this, FileRemoteCmdEventData.Cmd.copyFile, fileRemote, null, 0L);
        boolean bl = eventWithDst == null;
        String string = this.device.cmd(bl, fileRemoteCmdEventData, eventWithDst);
        return string;
    }

    public String moveTo(FileRemote fileRemote, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdChgFileRemote(this, FileRemoteCmdEventData.Cmd.moveFile, fileRemote, null, 0L);
        boolean bl = eventWithDst == null;
        String string = this.device.cmd(bl, fileRemoteCmdEventData, eventWithDst);
        return string;
    }

    public String renameTo(FileRemote fileRemote, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdChgFileRemote(this, FileRemoteCmdEventData.Cmd.moveFile, fileRemote, null, 0L);
        return this.device.cmd(eventWithDst == null, fileRemoteCmdEventData, eventWithDst);
    }

    @Override
    public boolean renameTo(File file) {
        return this.renameTo(FileRemote.fromFile(file), null) == null;
    }

    public void setSymbolicLinkedPath(String string) {
        this.flags |= 0x400;
        this.sCanonicalPath = string;
    }

    public void setCanonicalAbsPath(String string) {
        this.flags |= 0x200;
        this.flags &= 0xFFFFFBFF;
        this.sCanonicalPath = string;
    }

    public boolean sameDevice(FileRemote fileRemote) {
        return this.device.equals(fileRemote.device);
    }

    public ReadableByteChannel openRead(long l) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.openRead(this, l);
    }

    public InputStream openInputStream(long l) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.openInputStream(this, l);
    }

    public OutputStream openOutputStream(long l) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.openOutputStream(this, l);
    }

    public WritableByteChannel openWrite(long l) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.openWrite(this, l);
    }

    @Override
    public long length() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return this.length;
    }

    @Override
    public long lastModified() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return this.date;
    }

    public long creationTime() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return this.dateCreation;
    }

    public long lastAccessTime() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return this.dateLastAccess;
    }

    @Override
    public boolean setLastModified(long l) {
        this.date = l;
        if (this.oFile != null) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            return this.device.setLastModified(this, l);
        }
        return super.setLastModified(l);
    }

    public Object oFile() {
        return this.oFile;
    }

    public void setFileObject(Object object) {
        this.oFile = object;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getName() {
        return this.sFile;
    }

    @Override
    public String getParent() {
        FileRemote fileRemote = this.getParentFile();
        if (fileRemote == null) {
            return this.sDir;
        }
        return ((File)fileRemote).getAbsolutePath();
    }

    @Override
    public String getPath() {
        int n;
        CharSequence charSequence = this.getPathChars();
        if (charSequence.charAt((n = charSequence.length()) - 1) != '/' || n == 1 || n == 3 && charSequence.charAt(1) == ':') {
            return charSequence.toString();
        }
        return charSequence.subSequence(0, n - 1).toString();
    }

    public CharSequence getPathChars() {
        int n;
        int n2 = n = this.sFile == null ? 0 : this.sFile.length();
        if (n > 0) {
            int n3 = this.sDir == null ? 0 : this.sDir.length();
            StringBuilder stringBuilder = new StringBuilder(n3 + 1 + n);
            if (n3 > 0) {
                stringBuilder.append(this.sDir);
            }
            if (n3 == 0 || this.sDir.charAt(n3 - 1) != '/') {
                stringBuilder.append('/');
            }
            if (n != 1 || this.sFile.charAt(0) != '/') {
                stringBuilder.append(this.sFile);
                if (this.isDirectory()) {
                    stringBuilder.append('/');
                }
            }
            return stringBuilder;
        }
        return this.sDir;
    }

    public CharSequence getDirChars() {
        return this.sDir;
    }

    public StringBuilder setPathTo(StringBuilder stringBuilder) {
        int n;
        int n2 = n = this.sFile == null ? 0 : this.sFile.length();
        if (n > 0) {
            int n3;
            int n4 = n3 = this.sDir == null ? 0 : this.sDir.length();
            if (n3 > 0) {
                stringBuilder.append(this.sDir);
                if (this.sDir.charAt(n3 - 1) != '/' && this.sFile.charAt(0) != '/') {
                    stringBuilder.append('/');
                }
            }
            stringBuilder.append(this.sFile);
        } else {
            stringBuilder.append(this.sDir);
        }
        return stringBuilder;
    }

    @Override
    public String getCanonicalPath() {
        return this.sCanonicalPath;
    }

    public CharSequence isChild(CharSequence charSequence) {
        if (this.sFile != null) {
            return null;
        }
        CharSequence charSequence2 = FileSystem.normalizePath(charSequence);
        int n = this.sDir.length();
        int n2 = charSequence2.length();
        if (n2 > n && StringFunctions.startsWith(charSequence2, this.sDir) && charSequence2.charAt(n) == '/') {
            return charSequence2.subSequence(n + 1, n2);
        }
        return null;
    }

    public CharSequence isParent(CharSequence charSequence) {
        int n;
        CharSequence charSequence2 = FileSystem.normalizePath(charSequence);
        CharSequence charSequence3 = this.getPathChars();
        int n2 = charSequence3.length();
        if (n2 > (n = charSequence2.length()) && StringFunctions.startsWith(charSequence3, charSequence2) && charSequence3.charAt(n) == '/') {
            return charSequence2;
        }
        return null;
    }

    @Override
    public FileRemote getParentFile() {
        if (this.parent == null) {
            String string;
            int n = this.sDir.length();
            if (this.sFile.equals("/")) {
                string = null;
            } else if (this.sFile == null || this.sFile.length() == 0) {
                if (n > 1) {
                    int n2 = this.sDir.lastIndexOf(47, n - 1);
                    if (n2 == 0 || n2 == 2 && this.sDir.charAt(1) == ':') {
                        ++n2;
                    }
                    string = n2 > 0 ? this.sDir.substring(0, n2) : null;
                } else {
                    string = null;
                }
            } else if (n == 0 || n == 2 && this.sDir.charAt(1) == ':') {
                int n3 = n;
                string = this.sDir.substring(0, n3) + "/";
            } else {
                int n4 = n;
                string = this.sDir.substring(0, n4);
            }
            if (string != null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
                this.parent = this.itsCluster.getFile(string, null);
                if (this.parent.children == null) {
                    this.parent.children = FileRemote.createChildrenList();
                    boolean bl = this.sDir.charAt(1) == ':';
                    String string2 = bl ? this.sFile.toUpperCase() : this.sFile;
                    this.parent.children.put(string2, this);
                    this.parent.timeChildren = 0L;
                }
            }
        }
        return this.parent;
    }

    public boolean isTested() {
        return (this.flags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public boolean isTested(long l) {
        if (this.timeRefresh < l) {
            return false;
        }
        return !this.isDirectory() || this.timeChildren >= l;
    }

    @Override
    public boolean exists() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isFile() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isHidden() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean isDirectory() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isRoot() {
        return this.sFile.equals("/");
    }

    @Override
    public boolean canWrite() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean canRead() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean canExecute() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 0x40) != 0;
    }

    public int getFlagsTested() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return this.flags;
    }

    public boolean isSymbolicLink() {
        if ((this.flags & Integer.MIN_VALUE) == 0) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.device.refreshFileProperties(this, null);
        }
        return (this.flags & 0x400) != 0;
    }

    @Override
    public String getAbsolutePath() {
        String string = this.getPath();
        return string;
    }

    public FileRemote[] listFiles() {
        if (this.children == null) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.refreshPropertiesAndChildren(true, null);
        }
        if (this.children == null) {
            return null;
        }
        FileRemote[] fileRemoteArray = new FileRemote[this.children.size()];
        int n = -1;
        for (Map.Entry<String, FileRemote> entry : this.children.entrySet()) {
            if (n + 1 >= fileRemoteArray.length) {
                System.err.println("Bug in IndexMultiTable");
                continue;
            }
            fileRemoteArray[++n] = entry.getValue();
        }
        return fileRemoteArray;
    }

    @Override
    public File[] listFiles(FileFilter fileFilter) {
        if (this.children == null) {
            if (this.device == null) {
                this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
            }
            this.refreshPropertiesAndChildren(true, null);
        }
        List<File> list = this.device.getChildren(this, fileFilter);
        File[] fileArray = new File[list.size()];
        return list.toArray(fileArray);
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.createNewFile(this, null);
    }

    @Override
    public boolean delete() {
        boolean bl;
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if ((bl = this.device.delete(this, null)) && this.parent != null && this.parent.children != null) {
            this.parent.children.remove(this.sFile);
        }
        return bl;
    }

    public void delete(EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdChgFileRemote(this, FileRemoteCmdEventData.Cmd.delete, null, null, 0L);
        this.device.cmd(eventWithDst == null, fileRemoteCmdEventData, eventWithDst);
    }

    @Override
    public boolean mkdir() {
        String string = this.mkdir(false, null);
        return string == null;
    }

    @Override
    public boolean mkdirs() {
        this.mkdir(true, null);
        return true;
    }

    public String mkdir(boolean bl, EventWithDst<FileRemoteProgressEvData, FileRemoteCmdEventData> eventWithDst) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        return this.device.cmdFile(this, FileRemoteCmdEventData.Cmd.mkDir, null, null, 0L, eventWithDst);
    }

    @Deprecated
    public void check(String string, String string2, FileRemoteProgressEvData fileRemoteProgressEvData) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
    }

    public void copyChecked(String string, String string2, int n, FileRemoteWalkerCallback fileRemoteWalkerCallback, FileRemoteProgressEvData fileRemoteProgressEvData) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        this.device.copyChecked(this, string, string2, n, fileRemoteWalkerCallback, fileRemoteProgressEvData);
    }

    public void copyTo(FileRemote fileRemote, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst, int n) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if (fileRemote.device == null) {
            fileRemote.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(fileRemote.getAbsolutePath());
        }
    }

    public void XXXcopyTo(FileRemote fileRemote, int n) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        if (fileRemote.device == null) {
            fileRemote.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(fileRemote.getAbsolutePath());
        }
    }

    public void moveTo(String string, FileRemote fileRemote, FileRemoteProgressEvData fileRemoteProgressEvData) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
    }

    public void search(byte[] byArray, FileRemoteWalkerCallback fileRemoteWalkerCallback, FileRemoteProgressEvData fileRemoteProgressEvData) {
        if (this.device == null) {
            this.device = FileRemote.getAccessorSelector().selectFileRemoteAccessor(this.getAbsolutePath());
        }
        this.device.search(this, byArray, fileRemoteWalkerCallback, fileRemoteProgressEvData);
    }

    public void chgProps(boolean bl, String string, int n, int n2, long l, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        FileRemoteCmdEventData fileRemoteCmdEventData = new FileRemoteCmdEventData();
        fileRemoteCmdEventData.setCmdChgFileRemote(this, FileRemoteCmdEventData.Cmd.chgProps, null, string, l);
        fileRemoteCmdEventData.maskFlags = n;
        fileRemoteCmdEventData.newFlags = n2;
        this.device.cmd(bl, fileRemoteCmdEventData, eventWithDst);
    }

    public void chgPropsRecursive(int n, int n2, long l, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
    }

    public void countAllFileLength(EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
    }

    public void abortAction() {
    }

    public CharSequence getStateDevice() {
        return this.device == null ? "no-device" : this.device.getStateInfo();
    }

    public int ident() {
        return this._ident;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public InternalAccess internalAccess() {
        return this.acc_;
    }

    static {
        ctIdent = 0;
        clusterOfApplication = new FileCluster();
    }

    public class InternalAccess {
        public int setFlagBit(int n) {
            FileRemote.this.flags |= n;
            return FileRemote.this.flags;
        }

        public int clrFlagBit(int n) {
            FileRemote.this.flags &= ~n;
            return FileRemote.this.flags;
        }

        public int clrFlagBitChildren(int n, int n2) {
            int n3 = 1;
            if (n2 > 1000) {
                throw new IllegalArgumentException("too many recursion in directory tree");
            }
            this.clrFlagBit(n);
            if (FileRemote.this.children != null) {
                for (Map.Entry entry : FileRemote.this.children.entrySet()) {
                    if (entry == null) continue;
                    n3 += ((FileRemote)entry.getValue()).internalAccess().clrFlagBitChildren(n, n2 + 1);
                }
            }
            return n3;
        }

        public int setFlagBits(int n, int n2) {
            FileRemote.this.flags &= ~n;
            FileRemote.this.flags |= n2;
            return FileRemote.this.flags;
        }

        public void setPath(Path path) {
            boolean bl;
            String string = path.toString();
            File file = path.toFile();
            CharSequence[] charSequenceArray = FileFunctions.separateDirName(FileFunctions.normalizePath(string));
            boolean bl2 = bl = StringFunctions.compare(FileRemote.this.sDir, charSequenceArray[0]) == 0 && StringFunctions.compare(FileRemote.this.sFile, charSequenceArray[1]) == 0;
            if (!bl) {
                FileRemote.this.oFile = path.toFile();
                FileRemote.this.path = path;
                FileRemote.this.sDir = charSequenceArray[0].toString();
                FileRemote.this.sFile = charSequenceArray[1] == null ? "/" : charSequenceArray[1].toString();
            }
        }

        public void setLengthAndDate(long l, long l2, long l3, long l4) {
            if (l2 != -1L) {
                FileRemote.this.date = l2;
            }
            if (l4 != -1L) {
                FileRemote.this.dateLastAccess = l4;
            }
            if (l3 != -1L) {
                FileRemote.this.dateCreation = l3;
            }
            if (l != -1L) {
                FileRemote.this.length = l;
            }
        }

        public int setOrClrFlagBit(int n, boolean bl) {
            FileRemote.this.flags = bl ? (FileRemote.this.flags |= n) : (FileRemote.this.flags &= ~n);
            return FileRemote.this.flags;
        }

        public void setRefreshed() {
            FileRemote.this.flags &= 0xEFFFFFFF;
            FileRemote.this.timeRefresh = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setChildrenRefreshed() {
            if (FileRemote.this.children != null) {
                Map map = FileRemote.this.children;
                synchronized (map) {
                    Iterator iterator = FileRemote.this.children.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        FileRemote fileRemote = (FileRemote)entry.getValue();
                        if (fileRemote == null) {
                            Debugutil.stop();
                            continue;
                        }
                        if ((fileRemote.flags & 0x40000000) == 0) continue;
                        iterator.remove();
                    }
                }
            }
            FileRemote.this.flags &= 0xEFFFFFFF;
            FileRemote.this.timeRefresh = FileRemote.this.timeChildren = System.currentTimeMillis();
        }

        public void newChildren() {
            if (FileRemote.this.children == null) {
                FileRemote.this.children = FileRemote.createChildrenList();
            } else {
                Iterator iterator = FileRemote.this.children.entrySet().iterator();
                while (iterator.hasNext()) {
                    FileRemote fileRemote = (FileRemote)iterator.next().getValue();
                    if (fileRemote == null) {
                        Debugutil.stop();
                        continue;
                    }
                    fileRemote.flags |= 0x40000000;
                }
            }
        }

        public FileRemote newChild(CharSequence charSequence, long l, long l2, long l3, long l4, int n, Object object) {
            return new FileRemote(FileRemote.this.itsCluster, FileRemote.this.device, FileRemote.this, charSequence, l, l2, l3, FileRemote.this.dateLastAccess, n, object, true);
        }

        public void putNewChild(FileRemote fileRemote) {
            FileRemote.this.putNewChild(fileRemote);
        }

        public boolean setDeleted() {
            this.setFlagBits(-1, 0);
            this.setLengthAndDate(0L, 0L, 0L, 0L);
            String string = FileRemote.this.sDir.length() >= 3 && FileRemote.this.sDir.charAt(1) == ':' ? FileRemote.this.sFile.toUpperCase() : FileRemote.this.sFile;
            FileRemote fileRemote = (FileRemote)FileRemote.this.parent.children.remove(string);
            return fileRemote == FileRemote.this;
        }
    }

    public static enum XXXCallbackCmd {
        free,
        reserve,
        done,
        nok,
        error,
        errorDelete,
        doneCheck,
        nrofFilesAndBytes,
        copyDir,
        askErrorSrcOpen,
        askErrorDstCreate,
        askDstOverwr,
        askDstReadonly,
        askDstNotAbletoOverwr,
        askErrorCopy,
        acknAbortAll,
        acknAbortDir,
        acknAbortFile,
        start,
        last;

    }

    public static class CallbackEvent {
        public final EventWithDst<FileRemoteProgressEvData, FileRemoteCmdEventData> ev;
        public final FileRemoteProgressEvData progress;

        public CallbackEvent(String string, EventConsumer eventConsumer, EventTimerThread eventTimerThread, EventSource eventSource) {
            assert (eventConsumer instanceof FileRemoteProgressEventConsumer);
            this.progress = new FileRemoteProgressEvData();
            this.ev = new EventWithDst(string, null, (FileRemoteProgressEventConsumer)eventConsumer, eventTimerThread, this.progress);
        }
    }

    public static enum Ecmp {
        ends,
        starts,
        contains,
        equals,
        always;

    }

    public static interface FileRemoteAccessorSelector {
        public FileRemoteAccessor selectFileRemoteAccessor(CharSequence var1);
    }
}

