/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.fileLocalAccessor;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.vishia.event.EventWithDst;
import org.vishia.fileRemote.FileRemote;
import org.vishia.fileRemote.FileRemoteCmdEventData;
import org.vishia.fileRemote.FileRemoteProgressEvData;
import org.vishia.fileRemote.FileRemoteWalkerCallback;
import org.vishia.util.Assert;
import org.vishia.util.Debugutil;
import org.vishia.util.FileFunctions;
import org.vishia.util.FileSystem;
import org.vishia.util.SelectMask;
import org.vishia.util.SortedTreeWalkerCallback;
import org.vishia.util.StringFunctions;

public class FileCallbackLocalCmp
implements FileRemoteWalkerCallback {
    public static final String sVersion = "2024-02-12";
    private final CompareCtrl cmpCtrl = new CompareCtrl();
    private final FileRemote dir1;
    private final FileRemote dir2;
    private final String basepath1;
    private final int zBasePath1;
    private final EventWithDst<FileRemoteProgressEvData, ?> evBack;
    private final FileRemoteProgressEvData progress;
    private final FileRemoteWalkerCallback callbackUser;
    int mode;
    long minDiffTimestamp = 2000L;
    boolean aborted = false;
    final FileRemoteWalkerCallback XXXcallbackMarkSecondAlone = new FileRemoteWalkerCallback(){

        @Override
        public void finished(FileRemote fileRemote) {
        }

        @Override
        public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, Object object, Object object2) {
            return SortedTreeWalkerCallback.Result.cont;
        }

        @Override
        public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote, Object object, Object object2) {
            return SortedTreeWalkerCallback.Result.cont;
        }

        @Override
        public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
            fileRemote.setMarked(0x1000000);
            return SortedTreeWalkerCallback.Result.cont;
        }

        @Override
        public void start(FileRemote fileRemote, FileRemoteCmdEventData fileRemoteCmdEventData) {
        }

        @Override
        public boolean shouldAborted() {
            return false;
        }
    };

    public FileCallbackLocalCmp(FileRemote fileRemote, FileRemote fileRemote2, int n, FileRemoteWalkerCallback fileRemoteWalkerCallback, EventWithDst<FileRemoteProgressEvData, ?> eventWithDst) {
        this.evBack = eventWithDst;
        this.progress = eventWithDst.data();
        this.callbackUser = fileRemoteWalkerCallback;
        this.dir1 = fileRemote;
        this.dir2 = fileRemote2;
        this.mode = n;
        this.basepath1 = FileSystem.normalizePath(fileRemote.getAbsolutePath()).toString();
        this.zBasePath1 = this.basepath1.length();
        this.cmpCtrl.ignoreToEol.add(".file");
        this.cmpCtrl.ignoreToEol.add("//");
        this.cmpCtrl.ignoreToEol.add("Compilation time:");
        this.cmpCtrl.ignoreToEol.add("Compiler options:");
        this.cmpCtrl.ignoreCommentline.add("//");
        this.cmpCtrl.ignoreFromTo.add(new String[]{".epcannot:", ".epcannot.end:"});
        this.cmpCtrl.ignoreFromTo.add(new String[]{".static1:", ".static1.end:"});
    }

    @Override
    public void start(FileRemote fileRemote, FileRemoteCmdEventData fileRemoteCmdEventData) {
        this.dir2.refreshPropertiesAndChildren(true, null);
        int n = 0xFF00000;
        this.dir1.resetMarkedRecurs(n, null);
        this.dir2.resetMarkedRecurs(n, null);
        this.dir1.setMarked(0x100000);
        this.dir2.setMarked(0x100000);
    }

    @Override
    public SortedTreeWalkerCallback.Result offerParentNode(FileRemote fileRemote, Object object, Object object2) {
        Object object3;
        FileRemote fileRemote2;
        CharSequence charSequence = FileSystem.normalizePath(fileRemote.getAbsolutePath());
        if (charSequence.length() <= this.zBasePath1) {
            fileRemote2 = this.dir2;
        } else {
            object3 = charSequence.subSequence(this.zBasePath1 + 1, charSequence.length());
            if (StringFunctions.equals((CharSequence)object3, "functionBlocks")) {
                Debugutil.stop();
            }
            fileRemote2 = this.dir2.subdir((CharSequence)object3);
        }
        if (!fileRemote2.exists()) {
            fileRemote.setMarked(0x1000000);
            fileRemote.mark().setMarkParent(0x10000000, false);
            return SortedTreeWalkerCallback.Result.cont;
        }
        object3 = fileRemote2.mark();
        if (object3 == null || (((SelectMask)object3).getMark() & 0x1000000) == 0) {
            fileRemote2.walkLocal(null, 0x1000000, 0x1000000, null, 0, 0, null, null, 0, null);
        }
        fileRemote2.resetMarked(0x1000000);
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result finishedParentNode(FileRemote fileRemote, Object object, Object object2) {
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public SortedTreeWalkerCallback.Result offerLeafNode(FileRemote fileRemote, Object object) {
        FileRemote fileRemote2;
        CharSequence charSequence = FileSystem.normalizePath(fileRemote.getAbsolutePath());
        CharSequence charSequence2 = charSequence.subSequence(this.zBasePath1 + 1, charSequence.length());
        if (StringFunctions.compare(charSequence2, "functionBlocks/AngleBlocks_FB.h") == 0) {
            Assert.stop();
        }
        if (!(fileRemote2 = this.dir2.child(charSequence2)).exists()) {
            if (this.callbackUser != null) {
                this.callbackUser.offerLeafNode(fileRemote, new Integer(0x1000000));
            }
            fileRemote.setMarked(0x1000000);
            fileRemote.mark().setMarkParent(0x10000000, false);
            return SortedTreeWalkerCallback.Result.cont;
        }
        fileRemote2.resetMarked(0x1000000);
        int n = this.compareFile(fileRemote, fileRemote2);
        fileRemote.setMarked(n);
        if ((n & 0x400000) != 0) {
            n &= 0xFFBFFFFF;
            n |= 0x800000;
        } else if ((n & 0x800000) != 0) {
            n &= 0xFF7FFFFF;
            n |= 0x400000;
        }
        fileRemote2.setMarked(n);
        if ((n & 0x6000000) == 0) {
            fileRemote.mark().setMarkParent(0x20000000, false);
            fileRemote2.mark().setMarkParent(0x20000000, false);
            ++this.progress.nrofFilesMarked;
        }
        if (this.callbackUser != null) {
            this.callbackUser.offerLeafNode(fileRemote, new Integer(n));
        }
        return SortedTreeWalkerCallback.Result.cont;
    }

    @Override
    public boolean shouldAborted() {
        return this.aborted;
    }

    int compareFile(FileRemote fileRemote, FileRemote fileRemote2) {
        boolean bl = false;
        if (fileRemote.getName().equals("ReleaseNotes.topic")) {
            Assert.stop();
        }
        int n = 0;
        long l = fileRemote.lastModified();
        long l2 = fileRemote2.lastModified();
        long l3 = fileRemote.length();
        long l4 = fileRemote2.length();
        n = l > l2 + this.minDiffTimestamp ? (n |= 0x400000) : (l < l2 - this.minDiffTimestamp ? (n |= 0x800000) : (l3 == l4 ? (n |= 0x2000000) : (n |= 0x20000000)));
        if ((this.mode & 1) == 0) {
            boolean bl2;
            boolean bl3;
            if (l3 != l4) {
                if ((this.mode & 0x1C) != 0) {
                    bl3 = true;
                    bl2 = false;
                } else {
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    bl2 = false;
                    bl3 = false;
                }
            } else {
                bl3 = true;
                bl2 = false;
            }
            if (bl3) {
                try {
                    bl2 = this.compareFileContent(fileRemote, fileRemote2);
                    n = bl2 ? (n |= 0x4000000) : (n |= 0x8000000);
                }
                catch (IOException iOException) {
                    boolean bl7 = true;
                    bl2 = false;
                }
            }
        }
        if ((n & 0x8000000) != 0) {
            // empty if block
        }
        return n;
    }

    boolean compareFileContent(FileRemote fileRemote, FileRemote fileRemote2) throws IOException {
        String string;
        boolean bl = true;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        bufferedReader = new BufferedReader(new FileReader(fileRemote));
        bufferedReader2 = new BufferedReader(new FileReader(fileRemote2));
        while (bl && (string = this.readIgnoreComment(bufferedReader)) != null) {
            int n;
            String string2 = this.readIgnoreComment(bufferedReader2);
            for (String string3 : this.cmpCtrl.ignoreToEol) {
                n = string.indexOf(string3);
                if (n < 0) continue;
                string = string.substring(0, n);
                int n2 = string2.indexOf(string3);
                if (n2 < 0 || n2 != n) break;
                string2 = string2.substring(0, n2);
                break;
            }
            block2: for (String[] stringArray : this.cmpCtrl.ignoreFromTo) {
                String string4;
                int n3;
                String string5;
                n = string.indexOf(stringArray[0]);
                if (n < 0) continue;
                string = string.substring(0, n);
                while ((string5 = this.readIgnoreComment(bufferedReader)) != null) {
                    n3 = string5.indexOf(stringArray[1]);
                    if (n3 < 0) continue;
                    string = string + string5.substring(n3 + stringArray[1].length());
                    break;
                }
                if ((n3 = string2.indexOf(stringArray[0])) < 0) break;
                string2 = string2.substring(0, n3);
                while ((string4 = this.readIgnoreComment(bufferedReader2)) != null) {
                    int n4 = string4.indexOf(stringArray[1]);
                    if (n4 < 0) continue;
                    string2 = string2 + string4.substring(n4 + stringArray[1].length());
                    break block2;
                }
                break block2;
            }
            if (string2 != null && string.equals(string2)) continue;
            bl = false;
        }
        if (this.readIgnoreComment(bufferedReader2) != null) {
            bl = false;
        }
        bufferedReader.close();
        bufferedReader2.close();
        bufferedReader2 = null;
        bufferedReader = null;
        FileFunctions.close(bufferedReader);
        FileFunctions.close(bufferedReader2);
        return bl;
    }

    private String readIgnoreComment(BufferedReader bufferedReader) throws IOException {
        String string;
        boolean bl;
        block0: do {
            bl = false;
            string = bufferedReader.readLine();
            if (string == null) continue;
            for (String string2 : this.cmpCtrl.ignoreCommentline) {
                if (!string.startsWith(string2)) continue;
                bl = true;
                continue block0;
            }
        } while (bl);
        return string;
    }

    @Override
    public void finished(FileRemote fileRemote) {
        if (this.evBack != null) {
            this.progress.done(null, null);
        }
    }

    class CompareCtrl {
        final List<String> ignoreToEol = new LinkedList<String>();
        final List<String> ignoreCommentline = new LinkedList<String>();
        final List<String[]> ignoreFromTo = new LinkedList<String[]>();

        CompareCtrl() {
        }
    }
}

