/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.event;

import org.vishia.event.EventConsumer;
import org.vishia.event.EventSource;
import org.vishia.event.EventThread_ifc;
import org.vishia.event.EventTimerThread_ifc;
import org.vishia.event.EventWithDst;
import org.vishia.util.Debugutil;

public class TimeOrder
extends EventSource {
    public static final String version = "2023-03-12";
    private static final long serialVersionUID = 2695620140769906847L;
    public final String name;
    protected EventWithDst event;
    public final EventTimerThread_ifc timerThread;
    private int timeCycleFirst = 1;
    private int timeCycle = 200;
    private boolean bCyclic;
    protected long timeExecution;
    protected long timeExecutionLatest;
    protected boolean bAwaiting;
    protected boolean bHoldTimeorder;
    protected boolean bNotifyAlsoOnException;
    protected boolean bTimeElapsed;
    protected boolean bEventException;
    protected int ctConsumed;
    protected boolean bEventExecuted;
    protected boolean bTimeOrderFinished;
    public int dbgctWindup = 0;

    public TimeOrder(String string, EventTimerThread_ifc eventTimerThread_ifc, EventSource eventSource, EventConsumer eventConsumer, EventThread_ifc eventThread_ifc) {
        super(string);
        this.name = string;
        this.event = new EventWithDst(string, eventSource, eventConsumer, eventThread_ifc != null ? eventThread_ifc : eventTimerThread_ifc, null);
        this.timerThread = eventTimerThread_ifc;
    }

    public TimeOrder(String string, EventTimerThread_ifc eventTimerThread_ifc, EventWithDst eventWithDst) {
        super(string);
        this.name = string;
        this.event = eventWithDst;
        if (eventTimerThread_ifc != null) {
            this.timerThread = eventTimerThread_ifc;
        } else {
            EventThread_ifc eventThread_ifc = eventWithDst.getDstThread();
            if (!(eventThread_ifc instanceof EventTimerThread_ifc)) {
                throw new IllegalArgumentException("event should refer an EventTimerThread_ifc");
            }
            this.timerThread = (EventTimerThread_ifc)eventThread_ifc;
        }
    }

    void setEvent(EventWithDst eventWithDst) {
        this.event = eventWithDst;
    }

    public void setCycle(int n, int n2) {
        this.timeCycleFirst = n;
        this.timeCycle = n2;
    }

    public EventWithDst event() {
        return this.event;
    }

    public void clear() {
        this.notifyConsumed(4);
        this.event.removeFromQueue();
        this.timerThread.removeTimeEntry(this);
        this.timeExecutionLatest = 0L;
        this.timeExecution = 0L;
        this.bAwaiting = false;
        this.bNotifyAlsoOnException = false;
        this.bTimeElapsed = false;
        this.bEventException = false;
        this.bEventExecuted = false;
        this.ctConsumed = 0;
        this.bTimeOrderFinished = false;
        this.bCyclic = false;
    }

    public final void activateCyclic() {
        this.bCyclic = true;
        this.activate(this.timeCycleFirst);
    }

    final void repeatCyclic() {
        if (this.bCyclic) {
            this.activate(this.timeCycle);
        }
    }

    public final synchronized boolean hold() {
        this.bHoldTimeorder = true;
        return this.timeExecution == 0L;
    }

    public final void activate(int n) {
        this.activateAt(System.currentTimeMillis() + (long)n, 0L);
    }

    public final void activateAt(long l) {
        this.activateAt(l, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activateAt(long l, long l2) {
        if (this.timeExecution != 0L && this.timeExecution - System.currentTimeMillis() < -5000L) {
            this.timeExecution = 0L;
            this.timeExecutionLatest = 0L;
            this.timerThread.removeTimeEntry(this);
        }
        if (this.timeExecution == 0L && this.timeExecutionLatest != 0L) {
            Debugutil.stop();
        }
        if (this.timeExecutionLatest == 0L) {
            this.timeExecutionLatest = l2 == 0L ? l : l2;
        }
        EventTimerThread_ifc eventTimerThread_ifc = this.timerThread;
        synchronized (eventTimerThread_ifc) {
            long l3;
            boolean bl;
            if (this.timeExecution == 0L) {
                bl = true;
                l3 = l;
            } else {
                long l4;
                bl = false;
                long l5 = l - this.timeExecutionLatest;
                l3 = l5 >= 0L ? (this.timeExecution == this.timeExecutionLatest ? 0L : this.timeExecutionLatest) : ((l4 = l - this.timeExecution) < 0L ? l : l);
            }
            if (l3 != 0L) {
                this.timeExecution = l3;
                if (bl) {
                    this.event.dateCreation.set(System.currentTimeMillis());
                    this.dbgctWindup = 0;
                    this.timerThread.addTimeEntry(this);
                } else {
                    ++this.dbgctWindup;
                    this.timerThread.removeTimeEntry(this);
                    this.timerThread.addTimeEntry(this);
                }
            }
            this.bHoldTimeorder = false;
        }
    }

    public final void deactivate() {
        this.timeExecution = 0L;
        this.timeExecutionLatest = 0L;
        this.bCyclic = false;
        if (this.timerThread != null) {
            this.timerThread.removeTimeEntry(this);
        }
    }

    public final long timeExecution() {
        return this.timeExecution;
    }

    public final long timeExecutionLatest() {
        return this.timeExecutionLatest;
    }

    public final boolean used() {
        return this.timeExecution != 0L;
    }

    public final boolean isExecuted() {
        return this.bEventExecuted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyConsumed(int n) {
        boolean bl = this.bEventException = (n & 8) != 0;
        if ((n & 1) != 0) {
            ++this.ctConsumed;
        }
        int n2 = 4;
        if (this.bNotifyAlsoOnException) {
            n2 += 8;
        }
        if ((n & n2) != 0) {
            TimeOrder timeOrder = this;
            synchronized (timeOrder) {
                this.bTimeOrderFinished = true;
                if (this.bAwaiting) {
                    this.notify();
                }
            }
        }
    }

    public final int timeToExecution() {
        return this.timeExecution == 0L ? Integer.MAX_VALUE : (int)(this.timeExecution - System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean XXXawaitExecution(int n, boolean bl) {
        long l = System.currentTimeMillis() + (long)n;
        TimeOrder timeOrder = this;
        synchronized (timeOrder) {
            this.bNotifyAlsoOnException = bl;
            while (!this.bTimeOrderFinished) {
                long l2 = l - System.currentTimeMillis();
                if (l2 <= 0L && n != 0) continue;
                this.bAwaiting = true;
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.bAwaiting = false;
            }
        }
        return this.bEventExecuted;
    }
}

