/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.cmd;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import org.vishia.cmd.CmdGetFileArgs_ifc;
import org.vishia.cmd.PrepareCmd;
import org.vishia.mainCmd.MainCmd;
import org.vishia.mainCmd.MainCmd_ifc;
import org.vishia.util.FileSystem;

public class Filecmd {
    public static final int version = 537986848;
    private final Cargs cargs;
    private final MainCmd_ifc mainCmd;
    private final PrepareCmd cmd = new PrepareCmd();
    private final List<File> files = new LinkedList<File>();
    ProcessBuilder processBuilder;
    Writer out;

    Filecmd(MainCmd_ifc mainCmd_ifc, Cargs cargs) {
        this.mainCmd = mainCmd_ifc;
        this.cargs = cargs;
    }

    void execute() {
        boolean bl = true;
        bl = FileSystem.addFileToList(this.cargs.sFileMask, this.files);
        if (!bl) {
            this.mainCmd.writeError("Filecmd- file not found in path; " + this.cargs.sFileMask);
        }
        if (bl && this.cargs.sFileOut != null) {
            try {
                this.out = new FileWriter(this.cargs.sFileOut);
            }
            catch (IOException iOException) {
                this.mainCmd.writeError("Filecmd- can't open outfile; " + this.cargs.sFileOut, iOException);
                bl = false;
            }
        }
        if (bl) {
            for (File file : this.files) {
                if (this.cargs.sLine == null) continue;
                this.executeCmd(file);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void executeCmd(File file) {
        this.cmd.set_cmd(this.cargs.sLine);
        File1Arg file1Arg = new File1Arg(file);
        String[] stringArray = this.cmd.prepareCmd(file1Arg);
        if (this.cargs.bExecute) {
            if (this.processBuilder == null) {
                this.processBuilder = new ProcessBuilder(new String[0]);
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            this.mainCmd.executeCmdLine(this.processBuilder, stringArray, null, 0, (Appendable)stringBuilder, (Appendable)stringBuilder2);
            if (this.out == null) {
                try {
                    this.out.append(stringBuilder).append("\n");
                    this.out.append(stringBuilder2).append("\n");
                }
                catch (IOException iOException) {
                    this.mainCmd.writeError("write error", iOException);
                }
            }
        } else if (this.out != null) {
            try {
                this.out.append(stringArray[0]).append("\n");
            }
            catch (IOException iOException) {
                this.mainCmd.writeError("write error", iOException);
            }
        }
    }

    public static void main(String[] stringArray) {
        Cargs cargs = new Cargs();
        Cmdline cmdline = new Cmdline(cargs);
        try {
            cmdline.parseArguments(stringArray);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Filecmd filecmd = new Filecmd(cmdline, cargs);
        filecmd.execute();
    }

    private static class File1Arg
    implements CmdGetFileArgs_ifc {
        final File file;

        public File1Arg(File file) {
            this.file = file;
        }

        @Override
        public File getFile1() {
            return this.file;
        }

        @Override
        public File getFile2() {
            return this.file;
        }

        @Override
        public File getFile3() {
            return this.file;
        }

        @Override
        public File getFileSelect() {
            return this.file;
        }

        @Override
        public void prepareFileSelection() {
        }
    }

    private static class Cmdline
    extends MainCmd {
        final Cargs cargs;

        Cmdline(Cargs cargs) {
            this.cargs = cargs;
            this.addAboutInfo("Filecmd copyleft Hartmut Schorrig " + String.format("%x", 537986848));
            this.addHelpInfo("org.vishia.cmd.Filecmd searches some files and executes a command for each file.");
            this.addHelpInfo("cmd=CMDLINE - executes CMDLINE as shell command of the underlying operation system");
            this.addHelpInfo("  <:file> - replaces the complete path-name of the file in the command line string");
            this.addHelpInfo("    as absolute or relative path how it is given in the mask=PATHMASK argument.");
            this.addHelpInfo("  <:absFile>   - complete absoute path-name of the file");
            this.addHelpInfo("  <:absDir>    - absoute path of the directory of the file");
            this.addHelpInfo("  <:localFile> - complete local path-name of the file.");
            this.addHelpInfo("    The local part of a path can be designate with a ':' in the mask=PATHMASK");
            this.addHelpInfo("  <:localDir>  - local path of the file's directory.");
            this.addHelpInfo("  <:name>      - onyl the name of the file, without extension");
            this.addHelpInfo("  <:nameExt>   - complete name of the file");
            this.addHelpInfo("  <:ext>       - onyl the extension, it is the part after a last dot.");
            this.addHelpInfo("files=PATHMASK - The path and mask to select files.");
            this.addHelpInfo("  There are additional capabilities to select files:");
            this.addHelpInfo("  PATH/**/  means any directory starting from PATH");
            this.addHelpInfo("  PATH:PATHLOCAL A colon is the separator for local path. The local path starts from colon.");
            this.addHelpInfo("                 The ':' replaces a '/'. But it is accepted from position 3 only ");
            this.addHelpInfo("                 because at position 2 it is a windows-drive separator.");
            this.addHelpInfo("execJava=JAVAPATH a java-path to a class which should be executed. ");
            this.addHelpInfo("                 The class should be able to found in any jar file");
            this.addHelpInfo("                 of the given CLASSPATH of the java invocation.");
            this.addHelpInfo("  execJava=org.vishia.cmd.DeleteFile (example)");
            this.addHelpInfo("outJava=JAVAPATH a java-path to a class which is used as output text preparer.");
            this.addHelpInfo("  execJava=org.vishia.cmd.CatOutput (example)");
            this.addHelpInfo("all other cmd line options are forwarded to the cmd=CMD and to the execJava and outJava class");
        }

        @Override
        protected boolean checkArguments() {
            return true;
        }

        @Override
        protected boolean testArgument(String string, int n) {
            boolean bl = true;
            if (string.startsWith("cmd:")) {
                this.cargs.sLine = string.substring(4);
                this.cargs.bExecute = true;
            } else if (string.startsWith("line:")) {
                this.cargs.sLine = string.substring(5);
            } else if (string.startsWith("out:")) {
                this.cargs.sFileOut = string.substring(4);
            } else if (string.startsWith("files:")) {
                this.cargs.sFileMask = string.substring(6);
            } else if (string.startsWith("execjava:")) {
                this.cargs.sExecCmdClass = string.substring(9);
            } else if (string.startsWith("outjava:")) {
                this.cargs.sExecFilterOutputClass = string.substring(8);
            } else {
                bl = false;
            }
            return bl;
        }
    }

    public static class Cargs {
        public String sLine;
        public boolean bExecute;
        public String sFileOut;
        public String sFileMask;
        public String sExecCmdClass;
        public String sExecFilterOutputClass;
    }
}

