/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.cmd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.script.ScriptException;
import org.vishia.cmd.JZtxtcmdExecuter;
import org.vishia.cmd.JZtxtcmdScript;
import org.vishia.msgDispatch.LogMessage;
import org.vishia.util.DataAccess;
import org.vishia.util.Debugutil;
import org.vishia.util.StringFunctions;

public class CmdExecuter
implements Closeable {
    public static final String version = "2022-01-24";
    private final ProcessBuilder processBuilder;
    private Process process;
    private ExecuteAfterFinish executeAfterCmd;
    private Appendable echoCmd;
    private Charset charsetCmd = Charset.defaultCharset();
    boolean bRunThreads = true;
    private final OutThread outThread = new OutThread(true);
    private final OutThread errThread = new OutThread(false);
    final Thread threadExecOut;
    final Thread threadExecIn = null;
    final Thread threadExecError;
    public ConcurrentLinkedQueue<CmdQueueEntry> cmdQueue;
    public JZtxtcmdExecuter jzcmdExecuter;
    String[] sConsoleInvocation = new String[]{"cmd.exe", "/C"};

    public CmdExecuter() {
        this.processBuilder = new ProcessBuilder("");
        this.threadExecOut = new Thread((Runnable)this.outThread, "execOut");
        this.threadExecError = new Thread((Runnable)this.errThread, "execError");
        this.threadExecOut.start();
        this.threadExecError.start();
    }

    public void initJZcmdExecuter(JZtxtcmdScript jZtxtcmdScript, String string, LogMessage logMessage) throws Throwable {
        if (this.jzcmdExecuter == null) {
            this.jzcmdExecuter = new JZtxtcmdExecuter(logMessage);
        }
        this.jzcmdExecuter.initialize(jZtxtcmdScript, false, string);
    }

    public void setCurrentDir(File file) {
        this.processBuilder.directory(file);
    }

    public void setCharsetForOutput(String string) {
        this.charsetCmd = Charset.forName(string);
    }

    public Map<String, String> environment() {
        return this.processBuilder.environment();
    }

    private String getRemoveEnv(String string) {
        Map<String, String> map = this.processBuilder.environment();
        String string2 = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string3 = entry.getKey();
            if (!string.equalsIgnoreCase(string3.toUpperCase())) continue;
            string2 = entry.getValue();
            map.remove(string3);
            break;
        }
        return string2;
    }

    public String setEnv(String string, String string2) {
        Map<String, String> map = this.processBuilder.environment();
        String string3 = map.get(string);
        map.put(string, string2);
        return string3;
    }

    public String setEnvIgnoreCase(String string, String string2) {
        Map<String, String> map = this.processBuilder.environment();
        String string3 = this.getRemoveEnv(string);
        map.put(string, string2);
        return string3;
    }

    public String prefixEnv(String string, String string2) {
        Map<String, String> map = this.processBuilder.environment();
        String string3 = map.get(string);
        String string4 = string2 + (string3 == null ? "" : string3);
        map.put(string, string4);
        return string3;
    }

    public String prefixEnvIgnoreCase(String string, String string2) {
        Map<String, String> map = this.processBuilder.environment();
        String string3 = this.getRemoveEnv(string);
        String string4 = string2 + (string3 == null ? "" : string3);
        map.put(string, string4);
        return string3;
    }

    public void outAllEnvironment(Appendable appendable) throws IOException {
        Map<String, String> map = this.processBuilder.environment();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            treeMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : treeMap.entrySet()) {
            appendable.append("env ").append(entry.getKey()).append("=").append(entry.getValue()).append("<<<\n");
        }
    }

    public void specifyConsoleInvocation(String string) {
        this.sConsoleInvocation = CmdExecuter.splitArgs(string);
    }

    public void setEchoCmdOut(Appendable appendable) {
        this.echoCmd = appendable;
    }

    public void addCmd(String string, String string2, Appendable appendable, File file, ExecuteAfterFinish executeAfterFinish) {
        String[] stringArray = CmdExecuter.splitArgs(string);
        LinkedList<Appendable> linkedList = new LinkedList<Appendable>();
        linkedList.add(appendable);
        this.addCmd(stringArray, string2, linkedList, null, file, executeAfterFinish);
    }

    public void addCmd(String[] stringArray, String string, List<Appendable> list, List<Appendable> list2, File file, ExecuteAfterFinish executeAfterFinish) {
        if (this.cmdQueue == null) {
            this.cmdQueue = new ConcurrentLinkedQueue();
        }
        CmdQueueEntry cmdQueueEntry = new CmdQueueEntry();
        cmdQueueEntry.cmd = stringArray;
        cmdQueueEntry.input = string;
        cmdQueueEntry.out = list;
        cmdQueueEntry.err = list2;
        cmdQueueEntry.currentDir = file;
        cmdQueueEntry.executeAfterFinish = executeAfterFinish;
        this.cmdQueue.offer(cmdQueueEntry);
    }

    public void addCmd(JZtxtcmdScript.Subroutine subroutine, List<DataAccess.Variable<Object>> list, Appendable appendable, File file) {
        this.addCmd(subroutine, list, appendable, file, null);
    }

    public void addCmd(JZtxtcmdScript.Subroutine subroutine, List<DataAccess.Variable<Object>> list, Appendable appendable, File file, ExecuteAfterFinish executeAfterFinish) {
        if (this.jzcmdExecuter == null) {
            throw new IllegalArgumentException("The CmdExecuter should be initiaized with initJZcmdExecuter(script,...)");
        }
        if (this.cmdQueue == null) {
            this.cmdQueue = new ConcurrentLinkedQueue();
        }
        CmdQueueEntry cmdQueueEntry = new CmdQueueEntry();
        cmdQueueEntry.jzsub = subroutine;
        cmdQueueEntry.args = list;
        cmdQueueEntry.out1 = appendable;
        cmdQueueEntry.out = new LinkedList<Appendable>();
        cmdQueueEntry.out.add(appendable);
        cmdQueueEntry.currentDir = file;
        cmdQueueEntry.executeAfterFinish = executeAfterFinish;
        this.cmdQueue.offer(cmdQueueEntry);
    }

    public void clearCmdQueue() {
        if (this.cmdQueue != null) {
            this.cmdQueue.clear();
        }
    }

    public boolean hasEntries() {
        return this.cmdQueue != null && !this.cmdQueue.isEmpty();
    }

    public CmdQueueEntry executeCmdQueue(boolean bl) {
        CmdQueueEntry cmdQueueEntry = null;
        while (this.cmdQueue != null && (cmdQueueEntry = this.cmdQueue.poll()) != null) {
            if (cmdQueueEntry.jzsub != null) {
                try {
                    this.jzcmdExecuter.execSub(cmdQueueEntry.jzsub, cmdQueueEntry.args, true, cmdQueueEntry.out1, cmdQueueEntry.currentDir, this);
                }
                catch (ScriptException scriptException) {
                    String string = "\nexecuteCmdQueue JZsub, scriptexception: " + scriptException.getMessage();
                    try {
                        cmdQueueEntry.out1.append(string);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (cmdQueueEntry.executeAfterFinish == null) continue;
                cmdQueueEntry.executeAfterFinish.exec(0, cmdQueueEntry.out1, null);
                continue;
            }
            if (cmdQueueEntry.currentDir != null) {
                this.setCurrentDir(cmdQueueEntry.currentDir);
            }
            cmdQueueEntry.errorCmd = this.execute(cmdQueueEntry.cmd, false, cmdQueueEntry.input, cmdQueueEntry.out, cmdQueueEntry.err, cmdQueueEntry.executeAfterFinish);
            if (cmdQueueEntry.errorCmd == 0 || !bl) continue;
            break;
        }
        return cmdQueueEntry;
    }

    public int execute(String string, String string2, Appendable appendable, Appendable appendable2) {
        String[] stringArray = CmdExecuter.splitArgs(string);
        return this.execute(stringArray, string2, appendable, appendable2);
    }

    public int execute(String string, String string2, Appendable appendable, Appendable appendable2, boolean bl) {
        String[] stringArray = bl ? this.sConsoleInvocation : null;
        String[] stringArray2 = CmdExecuter.splitArgs(string, stringArray, null);
        return this.execute(stringArray2, string2, appendable, appendable2);
    }

    public int execute(String[] stringArray, String string, Appendable appendable, Appendable appendable2) {
        LinkedList<Appendable> linkedList;
        LinkedList<Appendable> linkedList2;
        boolean bl = true;
        if (appendable != null) {
            bl = false;
            linkedList2 = new LinkedList<Appendable>();
            linkedList2.add(appendable);
        } else {
            linkedList2 = null;
        }
        if (appendable2 != null && appendable2 != appendable) {
            bl = false;
            linkedList = new LinkedList<Appendable>();
            linkedList.add(appendable2);
        } else {
            linkedList = null;
        }
        return this.execute(stringArray, bl, string, linkedList2, linkedList, null);
    }

    public int execute(String[] stringArray, String string, List<Appendable> list, List<Appendable> list2) {
        return this.execute(stringArray, list == null && list2 == null, string, list, list2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] stringArray, boolean bl, String string, List<Appendable> list, List<Appendable> list2, ExecuteAfterFinish executeAfterFinish) {
        int n;
        this.executeAfterCmd = executeAfterFinish;
        if (this.echoCmd != null) {
            try {
                this.echoCmd.append(">cmdExecuter>");
                for (String object : stringArray) {
                    this.echoCmd.append(" <").append(object).append(">");
                }
                this.echoCmd.append("\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.processBuilder.command(stringArray);
        if (list2 == null) {
            this.processBuilder.redirectErrorStream(true);
        }
        try {
            Object object;
            this.process = this.processBuilder.start();
            if (list2 != null) {
                this.errThread.bProcessIsRunning = true;
                this.errThread.processOut = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), this.charsetCmd));
                this.errThread.outs = list2;
                object = this.errThread;
                synchronized (object) {
                    this.errThread.notify();
                }
            }
            if (list != null) {
                this.outThread.bProcessIsRunning = true;
                this.outThread.processOut = new BufferedReader(new InputStreamReader(this.process.getInputStream(), this.charsetCmd));
                this.outThread.outs = list;
                object = this.outThread;
                synchronized (object) {
                    this.outThread.notify();
                }
            }
            if (string != null) {
                object = this.process.getOutputStream();
                ((OutputStream)object).write(string.getBytes());
            }
            if (string != null || list != null || list2 != null) {
                n = this.process.waitFor();
                this.outThread.bProcessIsRunning = false;
                this.errThread.bProcessIsRunning = false;
                object = this.outThread;
                synchronized (object) {
                    if (this.outThread.processOut != null) {
                        this.outThread.wait();
                    }
                }
                object = this.errThread;
                synchronized (object) {
                    if (this.errThread.processOut != null) {
                        this.errThread.wait();
                    }
                }
            }
            n = bl ? 0 : this.process.waitFor();
            object = this;
            synchronized (object) {
                this.process = null;
            }
        }
        catch (Exception exception) {
            if (list2 != null) {
                try {
                    String string2 = "CmdExecuter - Problem;" + exception.getMessage();
                    for (Appendable appendable : list2) {
                        appendable.append(string2);
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            } else {
                throw new RuntimeException(exception);
            }
            n = -1;
        }
        if (this.echoCmd != null) {
            try {
                if (n != 0) {
                    this.echoCmd.append(">cmdExecuter exit:").append(Integer.toString(n)).append("\n");
                } else {
                    this.echoCmd.append(">cmdExecuter finished\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abortCmd(boolean bl) {
        boolean bl2 = false;
        CmdExecuter cmdExecuter = this;
        synchronized (cmdExecuter) {
            if (this.process != null) {
                if (bl) {
                    this.process.destroyForcibly();
                } else {
                    this.process.destroy();
                }
                bl2 = true;
            }
            this.outThread.outs = null;
            this.errThread.outs = null;
        }
        return bl2;
    }

    public boolean abortAllCmds() {
        if (this.cmdQueue != null) {
            this.cmdQueue.clear();
        }
        return this.abortCmd(true);
    }

    public static String[] splitArgs(String string) {
        return CmdExecuter.splitArgs(string, null, null);
    }

    public static String[] splitArgs(String string, int n, int n2) {
        int n3;
        int n4;
        int n5 = -1;
        int[] nArray = new int[200];
        int n6 = 0;
        int n7 = string.length();
        while ((n6 = StringFunctions.indexNoWhitespace(string, n6, n7)) < n7) {
            int n8;
            if (string.substring(n6, n6 + 2) == "##") {
                n6 = StringFunctions.indexOfAnyChar(string, n6, n7, "\n\r");
                continue;
            }
            n4 = StringFunctions.indexOfAnyCharOutsideQuotation(string, n6, n7, " \t\n\r", "\"'", null, '\u0000', null);
            if (n4 < 0) {
                n4 = n7;
            }
            if ((n8 = StringFunctions.indexOf((CharSequence)"\"'", string.charAt(n6))) >= 0) {
                n3 = "\"'".charAt(n8);
                if (string.charAt(n4 - 1) == n3) {
                    // empty if block
                }
            }
            nArray[++n5] = ++n6;
            nArray[++n5] = --n4;
            n6 = n4 + 1;
        }
        n4 = (n5 + 1) / 2;
        n4 += n;
        String[] stringArray = new String[n4 += n2];
        n3 = n;
        n5 = -1;
        while (n3 < n4 - n2) {
            int n9 = nArray[++n5];
            int n10 = nArray[++n5];
            stringArray[n3++] = string.substring(n9, n10);
        }
        return stringArray;
    }

    public static String[] splitArgs(String string, String[] stringArray, String[] stringArray2) {
        int n = stringArray == null ? 0 : stringArray.length;
        int n2 = stringArray2 == null ? 0 : stringArray2.length;
        String[] stringArray3 = CmdExecuter.splitArgs(string, n, n2);
        int n3 = 0;
        if (stringArray != null) {
            for (String string2 : stringArray) {
                stringArray3[n3++] = string2;
            }
        }
        n3 = stringArray3.length - n2;
        if (stringArray2 != null) {
            for (String string2 : stringArray) {
                stringArray3[n3++] = string2;
            }
        }
        return stringArray3;
    }

    void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.bRunThreads = false;
        while (this.outThread != null && this.outThread.state == 'r' || this.errThread != null && this.errThread.state == 'r') {
            CmdExecuter cmdExecuter = this;
            synchronized (cmdExecuter) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void finalize() {
        this.bRunThreads = false;
    }

    public static final void main(String[] stringArray) {
        CmdExecuter cmdExecuter = new CmdExecuter();
        cmdExecuter.execute("cmd /C", null, null, null);
        cmdExecuter.close();
        cmdExecuter.finalize();
    }

    class InThread
    implements Runnable {
        boolean bRunExec = false;
        BufferedWriter processIn;
        BufferedReader userInput;

        InThread() {
        }

        @Override
        public void run() {
            while (CmdExecuter.this.bRunThreads) {
                if (this.bRunExec) {
                    boolean bl = true;
                    try {
                        if (this.processIn.append("") != null) {
                            bl = false;
                        }
                    }
                    catch (IOException iOException) {
                        CmdExecuter.this.stop();
                    }
                    if (bl) {
                        this.bRunExec = false;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    CmdExecuter.this.process.destroy();
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class OutThread
    implements Runnable {
        BufferedReader processOut;
        List<Appendable> outs;
        private final boolean isOutThread;
        char state = (char)46;
        boolean bProcessIsRunning;

        OutThread(boolean bl) {
            this.isOutThread = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.state = (char)114;
            while (CmdExecuter.this.bRunThreads) {
                try {
                    Object object;
                    if (this.processOut != null && this.outs != null) {
                        if (this.outs != null && this.processOut.ready()) {
                            object = this.processOut.readLine();
                            if (object != null) {
                                for (Appendable appendable : this.outs) {
                                    try {
                                        appendable.append((CharSequence)object).append("\n");
                                    }
                                    catch (Exception exception) {}
                                }
                            } else {
                                this.processOut = null;
                            }
                        } else if (!this.bProcessIsRunning) {
                            if (this.isOutThread && CmdExecuter.this.executeAfterCmd != null) {
                                try {
                                    int n = CmdExecuter.this.process.exitValue();
                                    CmdExecuter.this.executeAfterCmd.exec(n, this.outs == null ? null : this.outs.get(0), CmdExecuter.this.errThread == null || ((CmdExecuter)CmdExecuter.this).errThread.outs == null ? null : ((CmdExecuter)CmdExecuter.this).errThread.outs.get(0));
                                }
                                catch (Exception exception) {
                                    System.err.println("CmdExecuter - exception in executeAfterCmd");
                                }
                                CmdExecuter.this.executeAfterCmd = null;
                            }
                            this.outs = null;
                        } else {
                            Thread.sleep(100L);
                        }
                    } else {
                        try {
                            object = this;
                            synchronized (object) {
                                this.wait(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.outs != null || this.processOut == null) continue;
                    object = this;
                    synchronized (object) {
                        this.processOut.close();
                        this.processOut = null;
                        this.notify();
                    }
                }
                catch (Exception exception) {
                    Debugutil.stop();
                }
            }
            this.state = (char)120;
        }
    }

    public static interface ExecuteAfterFinish {
        public void exec(int var1, Appendable var2, Appendable var3);
    }

    public static class CmdQueueEntry {
        public String[] cmd;
        public JZtxtcmdScript.Subroutine jzsub;
        public List<DataAccess.Variable<Object>> args;
        public String input;
        public Appendable out1;
        public List<Appendable> out;
        public List<Appendable> err;
        public File currentDir;
        public ExecuteAfterFinish executeAfterFinish;
        public int errorCmd;
    }
}

