/*
 * Decompiled with CFR 0.152.
 */
package org.vishia.byteData;

import java.io.UnsupportedEncodingException;

public abstract class ByteDataAccessOld {
    public static final int _version_ = 537924145;
    protected byte[] data = null;
    protected int idxBegin = 0;
    protected int idxEnd = 0;
    protected boolean bExpand = false;
    protected int idxFirstChild;
    protected int idxCurrentChild = -1;
    protected int idxCurrentChildEnd = 0;
    protected boolean bBigEndian = false;
    private ByteDataAccessOld parent = null;
    private ByteDataAccessOld currentChild = null;
    String charset = "ISO-8859-1";
    public static final byte kEndOfElements = 0;
    public static final byte kNothing = -1;
    public static final byte kText = 1;
    public static final byte kUndefined = -63;
    protected static final int kIdxElementCode = 0;

    public final int getLengthHead() {
        return this.idxFirstChild - this.idxBegin;
    }

    protected abstract void specifyEmptyDefaultData();

    public abstract int specifyLengthElementHead();

    protected abstract int specifyLengthElement() throws IllegalArgumentException;

    protected int specifyLengthCurrentChildElement() throws IllegalArgumentException {
        throw new IllegalArgumentException("The length of the child is undefined, no user specification is known");
    }

    protected ByteDataAccessOld() {
    }

    public void assignData(byte[] byArray, int n) throws IllegalArgumentException {
        if (n == 0) {
            n = -1;
        }
        this.assignData(byArray, n, 0);
    }

    public void assignData(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        this.data = byArray;
        if (n2 < 0) {
            throw new RuntimeException("idx have to be >=0");
        }
        this.idxBegin = n2;
        if (this.parent != null && this.parent.currentChild == this) {
            this.parent.currentChild = null;
        }
        this.parent = null;
        this.reset(n);
        this.assignDataToFixChilds();
    }

    public final void reset(int n) {
        int n2 = this.specifyLengthElementHead();
        if (n <= 0) {
            this.specifyEmptyDefaultData();
            this.bExpand = true;
        } else {
            boolean bl = this.bExpand = n <= 0;
        }
        if (this.currentChild != null) {
            this.currentChild.detach();
            this.currentChild = null;
        }
        this.idxCurrentChild = -1;
        this.idxFirstChild = this.idxCurrentChildEnd = this.idxBegin + n2;
        int n3 = this.idxEnd = this.bExpand ? this.idxFirstChild : n;
        if (this.idxEnd > this.data.length) {
            throw new IllegalArgumentException("not enough data bytes, requested=" + this.idxEnd + ", buffer-length=" + this.data.length);
        }
    }

    public final void assignEmpty(byte[] byArray) {
        try {
            this.assignData(byArray, -1, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.specifyEmptyDefaultData();
    }

    public final void removeChildren() {
        this.idxCurrentChildEnd = this.idxFirstChild;
        if (this.bExpand) {
            this.idxEnd = this.idxFirstChild;
        }
        this.idxCurrentChild = -1;
        if (this.currentChild != null) {
            this.currentChild.detach();
            this.currentChild = null;
        }
    }

    public final void detach() {
        if (this.currentChild != null) {
            this.currentChild.detach();
        }
        this.data = null;
        this.parent = null;
        this.idxEnd = 0;
        this.idxBegin = 0;
        this.idxCurrentChildEnd = 0;
        this.idxCurrentChild = 0;
        this.idxFirstChild = 0;
        this.bExpand = false;
    }

    protected final void assignCasted_i(ByteDataAccessOld byteDataAccessOld, int n, int n2) throws IllegalArgumentException {
        this.bBigEndian = byteDataAccessOld.bBigEndian;
        this.bExpand = byteDataAccessOld.bExpand;
        this.assignData(byteDataAccessOld.data, byteDataAccessOld.idxEnd, byteDataAccessOld.idxBegin + n);
    }

    protected final void assignDowncast_i(ByteDataAccessOld byteDataAccessOld) throws IllegalArgumentException {
        this.assignCasted_i(byteDataAccessOld, 0, -1);
    }

    @Deprecated
    public final void assignAsChild(ByteDataAccessOld byteDataAccessOld) throws IllegalArgumentException {
        byteDataAccessOld.addChild(this);
    }

    public final void assignAtIndex(int n, int n2, ByteDataAccessOld byteDataAccessOld) throws IllegalArgumentException {
        this.bBigEndian = byteDataAccessOld.bBigEndian;
        this.bExpand = byteDataAccessOld.bExpand;
        this.assignData(byteDataAccessOld.data, byteDataAccessOld.idxBegin + n + n2, byteDataAccessOld.idxBegin + n);
        this.setBigEndian(byteDataAccessOld.bBigEndian);
    }

    public final void assignAtIndex(int n, ByteDataAccessOld byteDataAccessOld) throws IllegalArgumentException {
        int n2 = this.getLengthHead();
        this.assignData(byteDataAccessOld.data, byteDataAccessOld.idxEnd, byteDataAccessOld.idxBegin + n);
        this.setBigEndian(byteDataAccessOld.bBigEndian);
    }

    protected void assignDataToFixChilds() throws IllegalArgumentException {
    }

    public final boolean addChild(ByteDataAccessOld byteDataAccessOld) throws IllegalArgumentException {
        this.notifyAddChild();
        byteDataAccessOld.bBigEndian = this.bBigEndian;
        byteDataAccessOld.bExpand = this.bExpand;
        this.setIdxtoNextCurrentChild();
        ByteDataAccessOld byteDataAccessOld2 = byteDataAccessOld;
        byteDataAccessOld2.assignData(this.data, this.bExpand ? -1 : this.idxEnd, this.idxCurrentChild);
        byteDataAccessOld2.setBigEndian(this.bBigEndian);
        byteDataAccessOld.parent = this;
        this.currentChild = byteDataAccessOld;
        this.correctIdxChildEnd(byteDataAccessOld.idxCurrentChildEnd);
        return this.bExpand;
    }

    public final void removeChild() throws IllegalArgumentException {
        if (this.bExpand) {
            throw new RuntimeException("don't call it in expand mode");
        }
        this.idxCurrentChildEnd = this.idxCurrentChild;
        this.idxCurrentChild = -1;
    }

    private final void setIdxtoNextCurrentChild() {
        if (this.idxCurrentChildEnd >= this.idxCurrentChild) {
            this.idxCurrentChild = this.idxCurrentChildEnd;
        } else if (this.idxCurrentChildEnd != -2) {
            throw new RuntimeException("unexpected idxCurrentChildEnd");
        }
        this.idxCurrentChildEnd = -1;
    }

    protected final boolean setIdxCurrentChildEnd(int n) throws IllegalArgumentException {
        if (this.bExpand) {
            if (this.data.length < this.idxCurrentChild + n) {
                throw new IllegalArgumentException("data length to small:" + (this.idxCurrentChild + n));
            }
        } else if (this.idxEnd < this.idxCurrentChildEnd) {
            throw new IllegalArgumentException("to few user data:" + (this.idxCurrentChild + n));
        }
        this.correctIdxChildEnd(this.idxCurrentChild + n);
        return this.bExpand;
    }

    public final void addChildEmpty(ByteDataAccessOld byteDataAccessOld) throws IllegalArgumentException {
        this.addChild(byteDataAccessOld);
        byteDataAccessOld.specifyEmptyDefaultData();
    }

    protected void notifyAddChild() {
    }

    protected final void correctCurrentChildEnd(int n) {
        if (this.idxEnd < n) {
            this.idxEnd = n;
        }
        if (this.idxCurrentChildEnd < n) {
            this.idxCurrentChildEnd = n;
        }
        if (this.parent != null) {
            this.parent.correctCurrentChildEnd(n);
        }
    }

    private final void correctIdxChildEnd(int n) {
        if (this.bExpand) {
            this.idxEnd = n;
        }
        assert (n >= this.idxFirstChild);
        this.idxCurrentChildEnd = n;
        if (this.parent != null) {
            this.parent.correctIdxChildEnd(n);
        }
    }

    public final void expandParent() throws IllegalArgumentException {
        if (this.idxBegin != 0 || this.parent != null) {
            if (this.parent != null) {
                if (this.parent.idxEnd < this.idxEnd) {
                    this.parent.idxEnd = this.idxEnd;
                }
                this.parent.expandParent();
            } else {
                throw new IllegalArgumentException("invalid expandParent()");
            }
        }
    }

    public final long getChildInteger(int n) throws IllegalArgumentException {
        this.setIdxtoNextCurrentChild();
        if (!this.setIdxCurrentChildEnd(Math.abs(n))) {
            long l = this._getLong(this.idxCurrentChild - this.idxBegin, n);
            return l;
        }
        throw new RuntimeException("Not available in expand mode.");
    }

    public final float getChildFloat() throws IllegalArgumentException {
        this.setIdxtoNextCurrentChild();
        if (!this.setIdxCurrentChildEnd(4)) {
            int n = (int)this._getLong(this.idxCurrentChild - this.idxBegin, 4);
            return Float.intBitsToFloat(n);
        }
        throw new RuntimeException("Not available in expand mode.");
    }

    public final double getChildDouble() throws IllegalArgumentException {
        this.setIdxtoNextCurrentChild();
        if (!this.setIdxCurrentChildEnd(8)) {
            long l = this._getLong(this.idxCurrentChild - this.idxBegin, 8);
            return Double.longBitsToDouble(l);
        }
        throw new RuntimeException("Not available in expand mode.");
    }

    public final void addChildInteger(int n, long l) throws IllegalArgumentException {
        this.setIdxtoNextCurrentChild();
        if (this.data.length < this.idxCurrentChild + n) {
            throw new IllegalArgumentException("data length to small:" + (this.idxCurrentChild + n));
        }
        this._setLong(this.idxCurrentChild - this.idxBegin, n, l);
        this.correctIdxChildEnd(this.idxCurrentChild + n);
    }

    public final void addChildFloat(float f) throws IllegalArgumentException {
        this.setIdxtoNextCurrentChild();
        if (this.data.length < this.idxCurrentChild + 4) {
            throw new IllegalArgumentException("data length to small:" + (this.idxCurrentChild + 4));
        }
        this.setFloat(this.idxCurrentChild - this.idxBegin, f);
        this.correctIdxChildEnd(this.idxCurrentChild + 4);
    }

    public final String getChildString(int n) throws IllegalArgumentException, UnsupportedEncodingException {
        this.setIdxtoNextCurrentChild();
        if (!this.setIdxCurrentChildEnd(n)) {
            return this._getString(this.idxCurrentChild - this.idxBegin, n);
        }
        throw new RuntimeException("Not available in expand mode.  ");
    }

    public final void addChildString(String string, String string2, boolean bl) throws IllegalArgumentException, UnsupportedEncodingException {
        this.setIdxtoNextCurrentChild();
        int n = string.length();
        if (this.data.length < this.idxCurrentChild + n) {
            throw new IllegalArgumentException("data length to small:" + (this.idxCurrentChild + n));
        }
        this._setString(this.idxCurrentChild - this.idxBegin, n, string, string2, bl);
        this.correctIdxChildEnd(this.idxCurrentChild + n);
    }

    public final void addChildString(String string) throws IllegalArgumentException {
        try {
            this.addChildString(string, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public final void addChildString(CharSequence charSequence, String string) throws IllegalArgumentException, UnsupportedEncodingException {
        this.setIdxtoNextCurrentChild();
        int n = charSequence.length();
        if (this.data.length < this.idxCurrentChild + n) {
            throw new IllegalArgumentException("data length to small:" + (this.idxCurrentChild + n));
        }
        for (int i = 0; i < n; ++i) {
            byte by;
            this.data[this.idxCurrentChild + i] = by = (byte)charSequence.charAt(i);
        }
        this.correctIdxChildEnd(this.idxCurrentChild + n);
    }

    public final void addChildString(CharSequence charSequence) throws IllegalArgumentException {
        try {
            this.addChildString(charSequence, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    @Deprecated
    public final int addText(String string) throws IllegalArgumentException {
        if (this.parent != null || this.idxBegin == 0) {
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            int n2 = this.data.length;
            for (int i = 0; i < n; ++i) {
                int n3 = byArray[i];
                if (n3 < 32) {
                    n3 = 63;
                }
                if (this.idxEnd >= n2) {
                    throw new IllegalArgumentException("element to long");
                }
                this.data[this.idxEnd++] = n3;
            }
            this.expandParent();
            return this.idxEnd - this.idxBegin;
        }
        throw new IllegalArgumentException("inadmissable add-operation");
    }

    public final void rewind() {
        this.idxCurrentChild = -1;
    }

    public final int next() throws IllegalArgumentException {
        byte by;
        this.setIdxtoNextCurrentChild();
        this.idxCurrentChildEnd = -2;
        if (this.idxCurrentChild >= this.idxEnd) {
            by = 0;
        } else {
            by = this.data[this.idxCurrentChild];
            if (this.isTextByte(by)) {
                by = 1;
            }
        }
        return by;
    }

    public final boolean sufficingBytesForNextChild(int n) throws IllegalArgumentException {
        int n2 = this.getMaxNrofBytesForNextChild();
        return n < 0 ? false : n2 >= n;
    }

    public final int getMaxNrofBytesForNextChild() throws IllegalArgumentException {
        if (this.idxCurrentChildEnd < this.idxCurrentChild) {
            throw new IllegalArgumentException("length of current child is undefined.");
        }
        return this.idxEnd - this.idxCurrentChildEnd;
    }

    public final int getMaxNrofBytes() {
        return this.data.length - this.idxBegin;
    }

    public final int getLength() {
        return this.idxEnd - this.idxBegin;
    }

    public final int getLengthTotal() {
        return this.idxEnd;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final int getPositionInBuffer() {
        return this.idxBegin;
    }

    public final int getPositionNextChildInBuffer() {
        return this.idxCurrentChildEnd;
    }

    public final int getLengthCurrentChildElement() throws IllegalArgumentException {
        if (this.idxCurrentChildEnd > this.idxCurrentChild) {
            return this.idxCurrentChildEnd - this.idxCurrentChild;
        }
        return this.specifyLengthCurrentChildElement();
    }

    public final void setLengthCurrentChildElement(int n) {
        if (this.currentChild != null) {
            this.currentChild.setLengthElement(n);
        }
    }

    public final void setLengthElement(int n) {
        this.correctIdxChildEnd(this.idxBegin + n);
    }

    public final boolean isTextByte(byte by) {
        return by >= 32;
    }

    public final String getText() {
        if (this.idxCurrentChild >= this.idxEnd) {
            return null;
        }
        byte by = this.data[this.idxCurrentChild];
        if (this.isTextByte(by)) {
            this.idxCurrentChildEnd = this.idxCurrentChild;
            char c = '?';
            StringBuffer stringBuffer = new StringBuffer(20);
            while (this.idxCurrentChildEnd < this.idxEnd && this.isTextByte(by = this.data[this.idxCurrentChildEnd])) {
                c = by < 0 ? (char)'?' : (char)((char)by);
                stringBuffer.append(c);
                ++this.idxCurrentChildEnd;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    protected String getString(int n, int n2) {
        String string;
        try {
            string = new String(this.data, this.idxBegin + n, n2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = null;
        }
        int n3 = string.indexOf(0);
        if (n3 > 0) {
            string = string.substring(0, n3);
        }
        return string;
    }

    protected int setString(int n, int n2, String string) {
        byte[] byArray;
        if (string.length() > n2) {
            string = string.substring(0, n2);
        }
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = null;
        }
        int n3 = byArray.length;
        if (n3 > n2) {
            n3 = n2;
        }
        System.arraycopy(byArray, 0, this.data, this.idxBegin + n, n3);
        return n3;
    }

    public void setBigEndian(boolean bl) {
        this.bBigEndian = bl;
    }

    protected final long _getLong(int n, int n2) {
        int n3;
        long l;
        int n4;
        int n5;
        boolean bl;
        int n6;
        long l2 = 0L;
        if (n2 >= 0) {
            n6 = n2;
            bl = false;
        } else {
            n6 = -n2;
            bl = true;
        }
        if (this.bBigEndian) {
            n5 = this.idxBegin + n;
            n4 = 1;
        } else {
            n5 = this.idxBegin + n + n6 - 1;
            n4 = -1;
        }
        int n7 = n6;
        while (true) {
            l2 |= (long)(this.data[n5] & 0xFF);
            if (--n7 <= 0) break;
            l2 <<= 8;
            n5 += n4;
        }
        if (bl && (l2 & (l = 1L << (n3 = n6 * 8 - 1))) != 0L) {
            long l3 = -1L << n3;
            l2 |= l3;
        }
        return l2;
    }

    protected final void _setLong(int n, int n2, long l) {
        int n3;
        if (this.bBigEndian) {
            n = this.idxBegin + n + n2 - 1;
            n3 = -1;
        } else {
            n = this.idxBegin + n;
            n3 = 1;
        }
        while (true) {
            this.data[n] = (byte)l;
            if (--n2 <= 0) break;
            l >>= 8;
            n += n3;
        }
    }

    protected final String _getString(int n, int n2) throws UnsupportedEncodingException {
        int n3 = n + this.idxBegin;
        String string = new String(this.data, n3, n2, this.charset);
        int n4 = string.indexOf(0);
        if (n4 >= 0) {
            string = string.substring(0, n4);
        }
        return string;
    }

    protected final void _setString(int n, int n2, String string, String string2, boolean bl) throws UnsupportedEncodingException {
        int n3 = n + this.idxBegin;
        int n4 = n3 + n2;
        if (string2 == null) {
            string2 = "ISO-8859-1";
        }
        byte[] byArray = string.getBytes(string2);
        int n5 = byArray.length;
        for (int i = 0; i < n5 && i < n2; ++i) {
            int n6 = byArray[i];
            if (bl && n6 < 32) {
                n6 = 63;
            }
            this.data[n3++] = n6;
        }
        while (n3 < n4) {
            this.data[n3++] = 0;
        }
    }

    public final void copyData(int[] nArray) {
        int n = this.idxEnd - this.idxBegin;
        if (n / 4 > nArray.length) {
            n = 4 * nArray.length;
        }
        int n2 = 0;
        for (int i = 0; i < n; i += 4) {
            nArray[n2++] = (int)this._getLong(i, 4);
        }
    }

    protected final float getFloat(int n) {
        int n2 = this.getInt32(n);
        float f = Float.intBitsToFloat(n2);
        return f;
    }

    protected final double getDouble(int n) {
        long l = this._getLong(n, 8);
        return Double.longBitsToDouble(l);
    }

    protected final long getInt64(int n) {
        int n2;
        int n3;
        if (this.bBigEndian) {
            n3 = this.getInt32(n);
            n2 = this.getInt32(n + 4);
        } else {
            n3 = this.getInt32(n + 4);
            n2 = this.getInt32(n);
        }
        long l = n2 << 32;
        return l |= (long)(n3 & 0xFFFFFFFF);
    }

    public final int getInt32(int n) {
        int n2 = this.bBigEndian ? this.data[this.idxBegin + n] << 24 | this.data[this.idxBegin + n + 1] << 16 & 0xFF0000 | this.data[this.idxBegin + n + 2] << 8 & 0xFF00 | this.data[this.idxBegin + n + 3] & 0xFF : this.data[this.idxBegin + n + 3] << 24 | this.data[this.idxBegin + n + 2] << 16 & 0xFF0000 | this.data[this.idxBegin + n + 1] << 8 & 0xFF00 | this.data[this.idxBegin + n] & 0xFF;
        return n2;
    }

    public final int getUint32(int n) {
        return this.getInt32(n);
    }

    protected final int getUint16(int n) {
        int n2 = this.bBigEndian ? this.data[this.idxBegin + n] << 8 & 0xFF00 | this.data[this.idxBegin + n + 1] & 0xFF : this.data[this.idxBegin + n + 1] << 8 & 0xFF00 | this.data[this.idxBegin + n] & 0xFF;
        return n2;
    }

    protected final short getInt16(int n) {
        int n2 = this.bBigEndian ? this.data[this.idxBegin + n] << 8 & 0xFF00 | this.data[this.idxBegin + n + 1] & 0xFF : this.data[this.idxBegin + n + 1] << 8 & 0xFF00 | this.data[this.idxBegin + n] & 0xFF;
        return (short)n2;
    }

    protected final char getChar(int n) {
        char c = (char)this.data[this.idxBegin + n];
        return c;
    }

    protected final byte getInt8(int n) {
        byte by = this.data[this.idxBegin + n];
        return by;
    }

    protected final int getUint8(int n) {
        int n2 = this.data[this.idxBegin + n] & 0xFF;
        return n2;
    }

    protected final int getUint32(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getUint16:" + n2);
        }
        return this.getUint32(n + 4 * n2);
    }

    protected final int getInt32(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt32:" + n2);
        }
        return this.getInt32(n + 4 * n2);
    }

    protected final int getInt16(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        return this.getInt16(n + 2 * n2);
    }

    protected final int getInt8(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt8:" + n2);
        }
        return this.getInt8(n + n2);
    }

    protected int getUint16(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getUint16:" + n2);
        }
        return this.getUint16(n + 2 * n2);
    }

    protected int getUint8(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getUint8:" + n2);
        }
        return this.getInt8(n + n2);
    }

    protected float getFloat(int n, int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getFloat:" + n2);
        }
        return this.getFloat(n + 4 * n2);
    }

    protected final void setFloat(int n, float f) {
        int n2 = Float.floatToRawIntBits(f);
        this.setInt32(n, n2);
    }

    protected final void setDouble(int n, double d) {
        long l = Double.doubleToRawLongBits(d);
        this._setLong(n, 8, l);
    }

    protected final void setInt32(int n, int n2) {
        if (this.bBigEndian) {
            this.data[this.idxBegin + n] = (byte)(n2 >> 24 & 0xFF);
            this.data[this.idxBegin + n + 1] = (byte)(n2 >> 16 & 0xFF);
            this.data[this.idxBegin + n + 2] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.idxBegin + n + 3] = (byte)(n2 & 0xFF);
        } else {
            this.data[this.idxBegin + n + 3] = (byte)(n2 >> 24 & 0xFF);
            this.data[this.idxBegin + n + 2] = (byte)(n2 >> 16 & 0xFF);
            this.data[this.idxBegin + n + 1] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.idxBegin + n] = (byte)(n2 & 0xFF);
        }
    }

    protected final void setUint8(int n, int n2) {
        this.setInt8(n, n2);
    }

    protected final void setUint16(int n, int n2) {
        this.setInt16(n, n2);
    }

    protected final void setUint32(int n, long l) {
        if (this.bBigEndian) {
            this.data[this.idxBegin + n] = (byte)(l >> 24 & 0xFFL);
            this.data[this.idxBegin + n + 1] = (byte)(l >> 16 & 0xFFL);
            this.data[this.idxBegin + n + 2] = (byte)(l >> 8 & 0xFFL);
            this.data[this.idxBegin + n + 3] = (byte)(l & 0xFFL);
        } else {
            this.data[this.idxBegin + n + 3] = (byte)(l >> 24 & 0xFFL);
            this.data[this.idxBegin + n + 2] = (byte)(l >> 16 & 0xFFL);
            this.data[this.idxBegin + n + 1] = (byte)(l >> 8 & 0xFFL);
            this.data[this.idxBegin + n] = (byte)(l & 0xFFL);
        }
    }

    protected final void setInt16(int n, int n2) {
        if (this.bBigEndian) {
            this.data[this.idxBegin + n] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.idxBegin + n + 1] = (byte)(n2 & 0xFF);
        } else {
            this.data[this.idxBegin + n + 1] = (byte)(n2 >> 8 & 0xFF);
            this.data[this.idxBegin + n] = (byte)(n2 & 0xFF);
        }
    }

    protected final void setInt8(int n, int n2) {
        this.data[this.idxBegin + n] = (byte)(n2 & 0xFF);
    }

    protected final void setUint32(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("setUint32:" + n2);
        }
        this.setUint32(n + 4 * n2, n4);
    }

    protected final void setInt32(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("setInt32:" + n2);
        }
        this.setInt32(n + 4 * n2, n4);
    }

    protected final void setInt16(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setInt16(n + 2 * n2, n4);
    }

    protected final void setInt8(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setInt8(n + n2, n4);
    }

    protected final void setUint16(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setUint16(n + 2 * n2, n4);
    }

    protected final void setUint8(int n, int n2, int n3, int n4) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setUint8(n + n2, n4);
    }

    protected final void setFloat(int n, int n2, int n3, float f) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("getInt16:" + n2);
        }
        this.setFloat(n + 4 * n2, f);
    }

    public final void copyDataFrom(ByteDataAccessOld byteDataAccessOld) throws IllegalArgumentException {
        int n = byteDataAccessOld.getLength();
        if (this.data.length < n) {
            throw new IndexOutOfBoundsException("copy, dst to small" + n);
        }
        System.arraycopy(byteDataAccessOld.data, byteDataAccessOld.idxBegin, this.data, this.idxBegin, n);
    }

    public final void elementAt(int n) {
        try {
            this.idxCurrentChild = this.idxBegin + this.specifyLengthElementHead() + this.specifyLengthCurrentChildElement() * n;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public final boolean assertNotExpandable() {
        assert (this.idxCurrentChild > 0 && this.idxEnd > 0 && !this.bExpand);
        return true;
    }

    public final ByteDataAccessOld getCurrentChild() {
        return this.currentChild;
    }
}

